/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ScopeStack;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrTypeVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011BQ\u0012:\u0010\u0002\u001a6\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003j\u0002`\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0004RB\u0010\u0002\u001a6\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003j\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrTypeParameterScopeValidator;", "", "reportError", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lkotlin/ParameterName;", "name", "element", "", "message", "", "Lorg/jetbrains/kotlin/backend/common/ReportError;", "parentChain", "", "<init>", "(Lkotlin/jvm/functions/Function2;Ljava/util/List;)V", "check", "Checker", "ir.backend.common"})
public final class IrTypeParameterScopeValidator {
    @NotNull
    private final Function2<IrElement, String, Unit> reportError;
    @NotNull
    private final List<IrElement> parentChain;

    public IrTypeParameterScopeValidator(@NotNull Function2<? super IrElement, ? super String, Unit> reportError, @NotNull List<IrElement> parentChain) {
        Intrinsics.checkNotNullParameter(reportError, "reportError");
        Intrinsics.checkNotNullParameter(parentChain, "parentChain");
        this.reportError = reportError;
        this.parentChain = parentChain;
    }

    public final void check(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        IrVisitorsKt.acceptVoid(element, new Checker());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u001bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrTypeParameterScopeValidator$Checker;", "Lorg/jetbrains/kotlin/ir/visitors/IrTypeVisitorVoid;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/IrTypeParameterScopeValidator;)V", "scopeStack", "Lorg/jetbrains/kotlin/backend/common/ScopeStack;", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "checkTypeParameterReference", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "typeParameterSymbol", "withTypeParametersInScope", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "block", "Lkotlin/Function0;", "visitType", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "visitElement", "visitFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nIrTypeParameterScopeValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeParameterScopeValidator.kt\norg/jetbrains/kotlin/backend/common/IrTypeParameterScopeValidator$Checker\n+ 2 Utils.kt\norg/jetbrains/kotlin/backend/common/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n24#2,6:84\n1863#3,2:90\n*S KotlinDebug\n*F\n+ 1 IrTypeParameterScopeValidator.kt\norg/jetbrains/kotlin/backend/common/IrTypeParameterScopeValidator$Checker\n*L\n60#1:84,6\n48#1:90,2\n*E\n"})
    private final class Checker
    extends IrTypeVisitorVoid {
        @NotNull
        private final ScopeStack<IrTypeParameterSymbol> scopeStack = new ScopeStack();

        private final void checkTypeParameterReference(IrElement element, IrTypeParameterSymbol typeParameterSymbol) {
            if (!this.scopeStack.isVisibleInCurrentScope(typeParameterSymbol)) {
                IrTypeParameterScopeValidator.this.reportError.invoke(element, "The following element references a type parameter '" + RenderIrElementKt.render$default((IrElement)typeParameterSymbol.getOwner(), null, 1, null) + "' that is not available in the current scope.");
            }
        }

        private final void withTypeParametersInScope(IrTypeParametersContainer container, Function0<Unit> block) {
            ScopeStack.withNewScope$default(this.scopeStack, false, container instanceof IrClass && !((IrClass)container).isInner() && !Intrinsics.areEqual(((IrClass)container).getVisibility(), DescriptorVisibilities.LOCAL), arg_0 -> Checker.withTypeParametersInScope$lambda$1(container, arg_0), block, 1, null);
        }

        @Override
        public void visitType(@NotNull IrElement container, @NotNull IrType type2) {
            block0: {
                Intrinsics.checkNotNullParameter(container, "container");
                Intrinsics.checkNotNullParameter(type2, "type");
                IrSimpleType irSimpleType = type2 instanceof IrSimpleType ? (IrSimpleType)type2 : null;
                IrClassifierSymbol irClassifierSymbol = irSimpleType != null ? irSimpleType.getClassifier() : null;
                IrTypeParameterSymbol irTypeParameterSymbol = irClassifierSymbol instanceof IrTypeParameterSymbol ? (IrTypeParameterSymbol)irClassifierSymbol : null;
                if (irTypeParameterSymbol == null) break block0;
                IrTypeParameterSymbol it = irTypeParameterSymbol;
                boolean bl = false;
                this.checkTypeParameterReference(container, it);
            }
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            List $this$temporarilyPushing$iv = IrTypeParameterScopeValidator.this.parentChain;
            boolean $i$f$temporarilyPushing = false;
            UtilsKt.push($this$temporarilyPushing$iv, element);
            IrElement it = element;
            boolean bl = false;
            IrVisitorsKt.acceptChildrenVoid(element, this);
            Unit result$iv = Unit.INSTANCE;
            UtilsKt.pop($this$temporarilyPushing$iv);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.withTypeParametersInScope(declaration, () -> Checker.visitFunction$lambda$4(this, declaration));
        }

        @Override
        public void visitClass(@NotNull IrClass declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.withTypeParametersInScope(declaration, () -> Checker.visitClass$lambda$5(this, declaration));
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.withTypeParametersInScope(declaration, () -> Checker.visitTypeAlias$lambda$6(this, declaration));
        }

        private static final Unit withTypeParametersInScope$lambda$1(IrTypeParametersContainer $container, Set $this$withNewScope) {
            Intrinsics.checkNotNullParameter($this$withNewScope, "$this$withNewScope");
            Iterable $this$forEach$iv = $container.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrTypeParameter it = (IrTypeParameter)element$iv;
                boolean bl = false;
                $this$withNewScope.add(it.getSymbol());
            }
            return Unit.INSTANCE;
        }

        private static final Unit visitFunction$lambda$4(Checker this$0, IrFunction $declaration) {
            super.visitFunction($declaration);
            return Unit.INSTANCE;
        }

        private static final Unit visitClass$lambda$5(Checker this$0, IrClass $declaration) {
            super.visitClass($declaration);
            return Unit.INSTANCE;
        }

        private static final Unit visitTypeAlias$lambda$6(Checker this$0, IrTypeAlias $declaration) {
            super.visitTypeAlias($declaration);
            return Unit.INSTANCE;
        }
    }
}

