/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ProtectedConstructorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nProtectedConstructorCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtectedConstructorCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/ProtectedConstructorCallChecker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,70:1\n1251#2,2:71\n*S KotlinDebug\n*F\n+ 1 ProtectedConstructorCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/ProtectedConstructorCallChecker\n*L\n52#1:71,2\n*E\n"})
public final class ProtectedConstructorCallChecker
implements CallChecker {
    @NotNull
    public static final ProtectedConstructorCallChecker INSTANCE = new ProtectedConstructorCallChecker();

    private ProtectedConstructorCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean bl;
        ConstructorDescriptor actualConstructor;
        DeclarationDescriptor scopeOwner;
        ConstructorDescriptor descriptor;
        block7: {
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context, "context");
            Object obj = resolvedCall2.getResultingDescriptor();
            ConstructorDescriptor constructorDescriptor = obj instanceof ConstructorDescriptor ? (ConstructorDescriptor)obj : null;
            if (constructorDescriptor == null) {
                return;
            }
            descriptor = constructorDescriptor;
            ClassifierDescriptor classifierDescriptor = descriptor.getContainingDeclaration().getOriginal();
            Intrinsics.checkNotNullExpressionValue(classifierDescriptor, "getOriginal(...)");
            ClassifierDescriptor constructorOwner = classifierDescriptor;
            scopeOwner = context.getScope().getOwnerDescriptor();
            ConstructorDescriptor constructorDescriptor2 = descriptor instanceof TypeAliasConstructorDescriptor ? (TypeAliasConstructorDescriptor)descriptor : null;
            ConstructorDescriptor constructorDescriptor3 = constructorDescriptor2 != null && (constructorDescriptor2 = constructorDescriptor2.getUnderlyingConstructorDescriptor()) != null ? (ConstructorDescriptor)constructorDescriptor2 : (actualConstructor = descriptor);
            if (!Intrinsics.areEqual(actualConstructor.getVisibility().normalize(), DescriptorVisibilities.PROTECTED)) {
                return;
            }
            if (!DescriptorVisibilityUtils.isVisibleWithAnyReceiver(descriptor, scopeOwner, context.getLanguageVersionSettings())) {
                return;
            }
            KtExpression calleeExpression = resolvedCall2.getCall().getCalleeExpression();
            KtExpression ktExpression = calleeExpression;
            if (ktExpression instanceof KtConstructorCalleeExpression ? ((KtConstructorCalleeExpression)calleeExpression).getParent() instanceof KtSuperTypeCallEntry : ktExpression instanceof KtConstructorDelegationReferenceExpression) {
                return;
            }
            Sequence<DeclarationDescriptor> $this$any$iv = DescriptorUtilsKt.getParentsWithSelf(scopeOwner);
            boolean $i$f$any = false;
            Iterator<DeclarationDescriptor> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                DeclarationDescriptor element$iv;
                DeclarationDescriptor it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(it.getOriginal() == constructorOwner)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        if (Intrinsics.areEqual(DescriptorVisibilityUtils.findInvisibleMember(DescriptorVisibilities.FALSE_IF_PROTECTED, descriptor, scopeOwner, context.getLanguageVersionSettings()), actualConstructor.getOriginal())) {
            context.getTrace().report(Errors.PROTECTED_CONSTRUCTOR_NOT_IN_SUPER_CALL.on(reportOn, descriptor));
        }
    }
}

