/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.threads;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerThreads;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.threads.exceptions.PAThreadException;

public class ThreadProvider {
    private static final Logger LOG = LogManager.getLogger(ThreadProvider.class);

    public Thread createThreadForRunnable(Runnable innerRunnable, PerformanceAnalyzerThreads paThread, String threadNameAppender) {
        StringBuilder threadName = new StringBuilder(paThread.toString());
        if (!threadNameAppender.isEmpty()) {
            threadName.append("-").append(threadNameAppender);
        }
        String threadNameStr = threadName.toString();
        StatExceptionCode metric = paThread.getThreadExceptionCode();
        Thread t = new Thread(() -> {
            try {
                innerRunnable.run();
            }
            catch (Throwable innerThrowable) {
                LOG.error("A thread crashed: ", innerThrowable);
                try {
                    PerformanceAnalyzerApp.exceptionQueue.put(new PAThreadException(paThread, innerThrowable));
                }
                catch (InterruptedException e) {
                    LOG.error("Thread was interrupted while waiting to put an exception into the queue. Message: {}", (Object)e.getMessage(), (Object)e);
                    StatsCollector.instance().logException(metric);
                }
            }
            LOG.info("Thread: {} completed.", (Object)threadNameStr);
            StatsCollector.instance().logException(StatExceptionCode.NUM_PA_THREADS_ENDED);
        }, threadNameStr);
        LOG.info("Spun up a thread with name: {}", (Object)threadNameStr);
        StatsCollector.instance().logException(StatExceptionCode.NUM_PA_THREADS_STARTED);
        return t;
    }

    public Thread createThreadForRunnable(Runnable innerRunnable, PerformanceAnalyzerThreads paThread) {
        return this.createThreadForRunnable(innerRunnable, paThread, "");
    }
}

