/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandNamespaceEmpty
extends SingleLineCommand2<ClassDiagram> {
    public CommandNamespaceEmpty() {
        super(CommandNamespaceEmpty.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNamespaceEmpty.class.getName(), RegexLeaf.start(), new RegexLeaf("namespace"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "([%pLN_][-%pLN_.:\\\\/]*)"), StereotypePattern.optional("STEREOTYPE"), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\}"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String color;
        String urlString;
        String idShort = arg.get("NAME", 0);
        Quark<Entity> quark = diagram.quarkInContext(false, diagram.cleanId(idShort));
        if (quark.getData() != null) {
            return CommandExecutionResult.error("Already exists " + quark.getName());
        }
        Display display = Display.getWithNewlines(diagram.getPragma(), quark.getQualifiedName());
        CommandExecutionResult status = diagram.gotoGroup(quark, display, GroupType.PACKAGE);
        if (!status.isOk()) {
            return status;
        }
        Entity p = diagram.getCurrentGroup();
        String stereotype = arg.get("STEREOTYPE", 0);
        if (stereotype != null) {
            p.setStereotype(Stereotype.build(stereotype));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        if ((color = arg.get("COLOR", 0)) != null) {
            p.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(color));
        }
        diagram.endGroup();
        return CommandExecutionResult.ok();
    }
}

