/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.BlocLines;

public class SkinLoader {
    public static final Pattern2 p1 = MyPattern.cmpile("^([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*)[%s]+(?:(\\{)|(.*))$|^\\}?$");
    private final List<String> context = new ArrayList<String>();
    private final TitledDiagram diagram;

    public SkinLoader(TitledDiagram diagram) {
        this.diagram = diagram;
    }

    private void push(String s2) {
        this.context.add(s2);
    }

    private void pop() {
        this.context.remove(this.context.size() - 1);
    }

    private String getFullParam() {
        StringBuilder sb = new StringBuilder();
        for (String s2 : this.context) {
            sb.append(s2);
        }
        return sb.toString();
    }

    public CommandExecutionResult execute(BlocLines lines, String group1) {
        if (group1 != null) {
            this.push(group1);
        }
        try {
            lines = lines.subExtract(1, 1);
            lines = lines.trim().removeEmptyLines();
            for (StringLocated s2 : lines) {
                assert (s2.getString().length() > 0);
                if (s2.getString().equals("}")) {
                    this.pop();
                    continue;
                }
                Matcher2 m4 = p1.matcher(s2.getString());
                if (!m4.find()) {
                    throw new IllegalStateException();
                }
                if (m4.group(2) != null) {
                    this.push(m4.group(1));
                    continue;
                }
                if (m4.group(3) != null) {
                    String key = this.getFullParam() + m4.group(1);
                    this.diagram.setParam(key, m4.group(3));
                    continue;
                }
                throw new IllegalStateException("." + s2.getString() + ".");
            }
            return CommandExecutionResult.ok();
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }
}

