/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.GroupMakerState;
import net.sourceforge.plantuml.svek.IEntityImage;

public final class CucaDiagramSimplifierState {
    public void simplify(CucaDiagram diagram, StringBounder stringBounder, DotMode dotMode) throws IOException, InterruptedException {
        boolean changed;
        do {
            changed = false;
            Collection<Entity> groups = this.getOrdered(diagram.getRootGroup());
            for (Entity g2 : groups) {
                if (!g2.isAutarkic()) continue;
                GroupMakerState maker = new GroupMakerState(diagram, g2, stringBounder, dotMode);
                IEntityImage img = maker.getImage();
                g2.overrideImage(img, g2.getGroupType() == GroupType.CONCURRENT_STATE ? LeafType.STATE_CONCURRENT : LeafType.STATE);
                changed = true;
            }
        } while (changed);
    }

    private Collection<Entity> getOrdered(Entity root) {
        LinkedHashSet<Entity> ordered = new LinkedHashSet<Entity>();
        ordered.add(root);
        int size = 1;
        do {
            size = ordered.size();
            this.addOneLevel(ordered);
        } while (size != ordered.size());
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity g2 : ordered) {
            if (g2.isRoot()) continue;
            result.add(0, g2);
        }
        return result;
    }

    private void addOneLevel(Collection<Entity> currents) {
        for (Entity g2 : new ArrayList<Entity>(currents)) {
            for (Entity child : this.reverse(g2.groups())) {
                currents.add(child);
            }
        }
    }

    private List<Entity> reverse(Collection<Entity> source) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity g2 : source) {
            result.add(0, g2);
        }
        return result;
    }
}

