/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.elk;

import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.elk.CucaDiagramFileMakerElk;
import net.sourceforge.plantuml.elk.proxy.graph.ElkNode;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorderNone;
import net.sourceforge.plantuml.klimt.geom.RectangleArea;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ClusterHeader;
import net.sourceforge.plantuml.svek.PackageStyle;

public class MyElkCluster {
    private final Entity group;
    private final ElkNode elkNode;
    private final CucaDiagram diagram;
    private final ISkinParam skinParam;

    public MyElkCluster(CucaDiagram diagram, Entity group, ElkNode elkNode) {
        this.group = group;
        this.elkNode = elkNode;
        this.diagram = diagram;
        this.skinParam = diagram.getSkinParam();
    }

    public void drawSingleCluster(UGraphic ug) {
        XPoint2D corner = CucaDiagramFileMakerElk.getPosition(this.elkNode);
        URectangle rect = URectangle.build(this.elkNode.getWidth(), this.elkNode.getHeight());
        PackageStyle packageStyle = this.group.getPackageStyle();
        ISkinParam skinParam = this.diagram.getSkinParam();
        if (packageStyle == null) {
            packageStyle = skinParam.packageStyle();
        }
        UmlDiagramType umlDiagramType = this.diagram.getUmlDiagramType();
        Style style = Cluster.getDefaultStyleDefinition(umlDiagramType.getStyleName(), this.group.getUSymbol(), this.group.getGroupType()).getMergedStyle(skinParam.getCurrentStyleBuilder());
        double shadowing = style.value(PName.Shadowing).asDouble();
        UStroke stroke = Cluster.getStrokeInternal(this.group, style);
        HColor backColor = this.getBackColor(umlDiagramType);
        backColor = Cluster.getBackColor(backColor, this.group.getStereotype(), umlDiagramType.getStyleName(), this.group.getUSymbol(), skinParam.getCurrentStyleBuilder(), skinParam.getIHtmlColorSet(), this.group.getGroupType());
        double roundCorner = style.value(PName.RoundCorner).asDouble();
        RectangleArea rectangleArea = new RectangleArea(0.0, 0.0, this.elkNode.getWidth(), this.elkNode.getHeight());
        ClusterHeader clusterHeader = new ClusterHeader(this.group, this.diagram, ug.getStringBounder());
        ClusterDecoration decoration = new ClusterDecoration(packageStyle, this.group.getUSymbol(), clusterHeader.getTitle(), clusterHeader.getStereo(), rectangleArea, stroke);
        HColor borderColor = HColors.BLACK;
        decoration.drawU(ug.apply(UTranslate.point(corner)), backColor, borderColor, shadowing, roundCorner, skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null), skinParam.getStereotypeAlignment(), 0.0);
    }

    private HColor getBackColor(UmlDiagramType umlDiagramType) {
        return null;
    }

    public MagneticBorder getMagneticBorder(StringBounder stringBounder) {
        USymbol uSymbol = this.group.getUSymbol();
        PackageStyle packageStyle = this.group.getPackageStyle();
        if (packageStyle == null) {
            packageStyle = this.skinParam.packageStyle();
        }
        if (uSymbol == null && packageStyle == PackageStyle.FOLDER) {
            uSymbol = USymbols.FOLDER;
        }
        if (uSymbol == null) {
            return new MagneticBorderNone();
        }
        final XPoint2D corner = CucaDiagramFileMakerElk.getPosition(this.elkNode);
        UmlDiagramType umlDiagramType = UmlDiagramType.CLASS;
        Style style = Cluster.getDefaultStyleDefinition(umlDiagramType.getStyleName(), uSymbol, this.group.getGroupType()).withTOBECHANGED(this.group.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        UStroke stroke = Cluster.getStrokeInternal(this.group, style);
        RectangleArea rectangleArea = new RectangleArea(0.0, 0.0, this.elkNode.getWidth(), this.elkNode.getHeight());
        ClusterHeader clusterHeader = new ClusterHeader(this.group, this.diagram, stringBounder);
        ClusterDecoration decoration = new ClusterDecoration(packageStyle, this.group.getUSymbol(), clusterHeader.getTitle(), clusterHeader.getStereo(), rectangleArea, stroke);
        TextBlock textBlock = decoration.getTextBlock(HColors.BLACK, HColors.BLACK, 0.0, 0.0, this.skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null), this.skinParam.getStereotypeAlignment(), 0.0);
        final MagneticBorder orig = textBlock.getMagneticBorder();
        return new MagneticBorder(){
            final /* synthetic */ MyElkCluster this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public UTranslate getForceAt(StringBounder stringBounder, XPoint2D position) {
                return orig.getForceAt(stringBounder, position.move(-corner.x, -corner.y));
            }
        };
    }
}

