/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.RectangleArea;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.url.Url;

public class EntityImageEmptyPackage
extends AbstractEntityImage {
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final Stereotype stereotype;
    private final TextBlock stereoBlock;
    private final Url url;
    private final double shadowing;
    private final HColor borderColor;
    private final UStroke stroke;
    private final double roundCorner;
    private final double diagonalCorner;
    private final HColor back;

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.getStyleName(), SName.package_, SName.title).withTOBECHANGED(this.stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    public EntityImageEmptyPackage(Entity entity, PortionShower portionShower) {
        super(entity);
        TextBlock legendBlock;
        Colors colors = entity.getColors();
        HColor specificBackColor = colors.getColor(ColorType.BACK);
        this.stereotype = entity.getStereotype();
        this.url = entity.getUrl99();
        Style style = this.getStyle();
        style = style.eventuallyOverride(colors);
        this.borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        this.shadowing = style.value(PName.Shadowing).asDouble();
        this.stroke = style.getStroke(colors);
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.diagonalCorner = style.value(PName.DiagonalCorner).asDouble();
        this.back = specificBackColor == null ? style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet()) : specificBackColor;
        FontConfiguration titleFontConfiguration = style.getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        HorizontalAlignment titleHorizontalAlignment = style.getHorizontalAlignment();
        this.desc = entity.getDisplay().create(titleFontConfiguration, titleHorizontalAlignment, this.getSkinParam());
        DisplayPositioned legend = entity.getLegend();
        this.stereoBlock = legend != null ? (legendBlock = EntityImageLegend.create(legend.getDisplay(), this.getSkinParam())) : (this.stereotype == null || this.stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.withMargin(Display.create(this.stereotype.getLabels(this.getSkinParam().guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.PACKAGE_STEREOTYPE, this.stereotype), titleHorizontalAlignment, this.getSkinParam()), 1.0, 0.0));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        XDimension2D dim = TextBlockUtils.mergeTB(this.desc, this.stereoBlock, HorizontalAlignment.LEFT).calculateDimension(stringBounder);
        dim = dim.atLeast(0.0, 2.0 * dimDesc.getHeight());
        return dim.delta(20.0, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        RectangleArea rectangleArea = new RectangleArea(0.0, 0.0, widthTotal, heightTotal);
        ClusterDecoration decoration = new ClusterDecoration(this.getSkinParam().packageStyle(), null, this.desc, this.stereoBlock, rectangleArea, this.stroke);
        HorizontalAlignment horizontalAlignment = this.getSkinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
        HorizontalAlignment stereotypeAlignment = this.getSkinParam().getStereotypeAlignment();
        decoration.drawU(ug, this.back, this.borderColor, this.shadowing, this.roundCorner, horizontalAlignment, stereotypeAlignment, this.diagonalCorner);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

