/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.wls.shaded.org.apache.xalan.processor;

import com.oracle.wls.shaded.org.apache.xalan.processor.StylesheetHandler;
import com.oracle.wls.shaded.org.apache.xalan.processor.XSLTAttributeDef;
import com.oracle.wls.shaded.org.apache.xalan.processor.XSLTElementDef;
import com.oracle.wls.shaded.org.apache.xalan.processor.XSLTElementProcessor;
import com.oracle.wls.shaded.org.apache.xalan.res.XSLMessages;
import com.oracle.wls.shaded.org.apache.xalan.templates.ElemTemplateElement;
import com.oracle.wls.shaded.org.apache.xalan.templates.KeyDeclaration;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ProcessorKey
extends XSLTElementProcessor {
    static final long serialVersionUID = 4285205417566822979L;

    ProcessorKey() {
    }

    public void startElement(StylesheetHandler handler, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        KeyDeclaration kd = new KeyDeclaration(handler.getStylesheet(), handler.nextUid());
        kd.setDOMBackPointer(handler.getOriginatingNode());
        kd.setLocaterInfo(handler.getLocator());
        this.setPropertiesFromAttributes(handler, rawName, attributes, kd);
        handler.getStylesheet().setKey(kd);
    }

    void setPropertiesFromAttributes(StylesheetHandler handler, String rawName, Attributes attributes, ElemTemplateElement target) throws SAXException {
        XSLTAttributeDef attrDef;
        XSLTElementDef def = this.getElemDef();
        ArrayList<XSLTAttributeDef> processedDefs = new ArrayList<XSLTAttributeDef>();
        int nAttrs = attributes.getLength();
        for (int i = 0; i < nAttrs; ++i) {
            String attrLocalName;
            String attrUri = attributes.getURI(i);
            attrDef = def.getAttributeDef(attrUri, attrLocalName = attributes.getLocalName(i));
            if (null == attrDef) {
                handler.error(attributes.getQName(i) + "attribute is not allowed on the " + rawName + " element!", null);
                continue;
            }
            String valueString = attributes.getValue(i);
            if (valueString.indexOf("key(") >= 0) {
                handler.error(XSLMessages.createMessage("ER_INVALID_KEY_CALL", null), null);
            }
            processedDefs.add(attrDef);
            attrDef.setAttrValue(handler, attrUri, attrLocalName, attributes.getQName(i), attributes.getValue(i), target);
        }
        XSLTAttributeDef[] attrDefs = def.getAttributes();
        int nAttrDefs = attrDefs.length;
        for (int i = 0; i < nAttrDefs; ++i) {
            attrDef = attrDefs[i];
            String defVal = attrDef.getDefault();
            if (null != defVal && !processedDefs.contains(attrDef)) {
                attrDef.setDefAttrValue(handler, target);
            }
            if (!attrDef.getRequired() || processedDefs.contains(attrDef)) continue;
            handler.error(XSLMessages.createMessage("ER_REQUIRES_ATTRIB", new Object[]{rawName, attrDef.getName()}), null);
        }
    }
}

