# This file has been autogenerated by the pywayland scanner

# Copyright © 2018 Simon Ser
# Copyright © 2019 Ivan Molodetskikh
# Copyright © 2024 Neal Gompa
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class ExtDataControlOfferV1(Interface):
    """Offer to transfer data

    A ext_data_control_offer represents a piece of data offered for transfer by
    another client (the source client). The offer describes the different MIME
    types that the data can be converted to and provides the mechanism for
    transferring the data directly from the source client.
    """

    name = "ext_data_control_offer_v1"
    version = 1


class ExtDataControlOfferV1Proxy(Proxy[ExtDataControlOfferV1]):
    interface = ExtDataControlOfferV1

    @ExtDataControlOfferV1.request(
        Argument(ArgumentType.String),
        Argument(ArgumentType.FileDescriptor),
    )
    def receive(self, mime_type: str, fd: int) -> None:
        """Request that the data is transferred

        To transfer the offered data, the client issues this request and
        indicates the MIME type it wants to receive. The transfer happens
        through the passed file descriptor (typically created with the pipe
        system call). The source client writes the data in the MIME type
        representation requested and then closes the file descriptor.

        The receiving client reads from the read end of the pipe until EOF and
        then closes its end, at which point the transfer is complete.

        This request may happen multiple times for different MIME types.

        :param mime_type:
            MIME type desired by receiver
        :type mime_type:
            `ArgumentType.String`
        :param fd:
            file descriptor for data transfer
        :type fd:
            `ArgumentType.FileDescriptor`
        """
        self._marshal(0, mime_type, fd)

    @ExtDataControlOfferV1.request()
    def destroy(self) -> None:
        """Destroy this offer

        Destroys the data offer object.
        """
        self._marshal(1)
        self._destroy()


class ExtDataControlOfferV1Resource(Resource):
    interface = ExtDataControlOfferV1

    @ExtDataControlOfferV1.event(
        Argument(ArgumentType.String),
    )
    def offer(self, mime_type: str) -> None:
        """Advertise offered mime type

        Sent immediately after creating the ext_data_control_offer object. One
        event per offered MIME type.

        :param mime_type:
            offered MIME type
        :type mime_type:
            `ArgumentType.String`
        """
        self._post_event(0, mime_type)


class ExtDataControlOfferV1Global(Global):
    interface = ExtDataControlOfferV1


ExtDataControlOfferV1._gen_c()
ExtDataControlOfferV1.proxy_class = ExtDataControlOfferV1Proxy
ExtDataControlOfferV1.resource_class = ExtDataControlOfferV1Resource
ExtDataControlOfferV1.global_class = ExtDataControlOfferV1Global
