"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logger = void 0;
class Logger {
    constructor(tsLogService, suppressNonSvelteLogs = false, logDebug = false) {
        this.tsLogService = tsLogService;
        this.logDebug = logDebug;
        if (suppressNonSvelteLogs) {
            const log = this.tsLogService.info.bind(this.tsLogService);
            this.tsLogService.info = (s) => {
                if (s.startsWith('-Svelte Plugin-')) {
                    log(s);
                }
            };
        }
    }
    log(...args) {
        const str = args
            .map((arg) => {
            if (typeof arg === 'object') {
                try {
                    return JSON.stringify(arg);
                }
                catch (e) {
                    return '[object that cannot by stringified]';
                }
            }
            return arg;
        })
            .join(' ');
        this.tsLogService.info('-Svelte Plugin- ' + str);
    }
    debug(...args) {
        if (!this.logDebug) {
            return;
        }
        this.log(...args);
    }
}
exports.Logger = Logger;
//# sourceMappingURL=logger.js.map