/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.windows.WinUser;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.WindowsGroup;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchStringAction;
import com.install4j.runtime.installer.platform.win32.ACLHandling;
import java.io.Serializable;

public abstract class AbstractChangeWindowsRightsAction
extends SystemInstallOrUninstallAction {
    private WindowsGroup group = WindowsGroup.AUTHENTICATED_USERS;
    private boolean read;
    private boolean write;
    private boolean execute;
    private boolean all = true;
    private String sidOrAccountName;
    private AccessMode accessMode = AccessMode.GRANT_ACCESS;

    protected final String getUsedSidOrAccountName() {
        if (this.getGroup() == WindowsGroup.ORIGINAL_USER) {
            return HelperCommunication.getInstance().fetchString(ExecutionContext.UNELEVATED, new GetOriginalUserRemoteCallable());
        }
        if (this.getGroup().getSid() != null) {
            return this.getGroup().getSid();
        }
        return this.getSidOrAccountName();
    }

    public String getSidOrAccountName() {
        return AbstractChangeWindowsRightsAction.replaceVariables(AbstractChangeWindowsRightsAction.replaceVariables(this.sidOrAccountName));
    }

    public void setSidOrAccountName(String sidOrAccountName) {
        this.sidOrAccountName = sidOrAccountName;
    }

    public WindowsGroup getGroup() {
        return this.replaceWithTextOverride("group", this.group, WindowsGroup.class);
    }

    public void setGroup(WindowsGroup group) {
        this.group = group;
    }

    public boolean isRead() {
        return this.replaceWithTextOverride("read", this.read);
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isWrite() {
        return this.replaceWithTextOverride("write", this.write);
    }

    public void setWrite(boolean write) {
        this.write = write;
    }

    public boolean isExecute() {
        return this.replaceWithTextOverride("execute", this.execute);
    }

    public void setExecute(boolean execute2) {
        this.execute = execute2;
    }

    public boolean isAll() {
        return this.replaceWithTextOverride("all", this.all);
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public AccessMode getAccessMode() {
        return this.replaceWithTextOverride("accessMode", this.accessMode, AccessMode.class);
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public static enum AccessMode {
        GRANT_ACCESS(1, "Grant access"),
        SET_ACCESS(2, "Set access"),
        DENY_ACCESS(3, "Deny access"),
        REVOKE_ACCESS(4, "Revoke access");

        private final int intValue;
        private final String verbose;

        private AccessMode(int intValue, String verbose) {
            this.intValue = intValue;
            this.verbose = verbose;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public String toString() {
            return this.verbose;
        }
    }

    protected static class ACERemoteCallable
    extends AbstractRemoteCallable {
        private final String objectName;
        private final boolean regKey;
        private final boolean read;
        private final boolean write;
        private final boolean execute;
        private final boolean all;
        private final int groupType;
        private final String sidOrAccountName;
        private final AccessMode accessMode;

        public ACERemoteCallable(String objectName, boolean regKey, boolean read, boolean write, boolean execute2, boolean all, int groupType, String sidOrAccountName, AccessMode accessMode) {
            this.objectName = objectName;
            this.regKey = regKey;
            this.read = read;
            this.write = write;
            this.execute = execute2;
            this.all = all;
            this.groupType = groupType;
            this.sidOrAccountName = sidOrAccountName;
            this.accessMode = accessMode;
        }

        @Override
        public Serializable execute() {
            return Boolean.valueOf(ACLHandling.addACE(this.objectName, this.regKey, this.read, this.write, this.execute, this.all, this.groupType, this.sidOrAccountName, this.accessMode.getIntValue()));
        }
    }

    private static class GetOriginalUserRemoteCallable
    extends FetchStringAction {
        private GetOriginalUserRemoteCallable() {
        }

        @Override
        protected String fetchValue(Context context) throws Exception {
            return WinUser.getUserSid();
        }
    }
}

