/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.misc.AbstractPrivilegesAction;
import com.install4j.runtime.beans.actions.misc.RequestPrivilegesAction;
import com.install4j.runtime.installer.InstallerVariables;
import java.util.Objects;

public class RequireInstallerPrivilegesAction
extends AbstractPrivilegesAction {
    private boolean failIfNotObtained = true;

    public boolean isFailIfNotObtained() {
        return this.replaceWithTextOverride("failIfNotObtained", this.failIfNotObtained);
    }

    public void setFailIfNotObtained(boolean failIfNotObtained) {
        this.failIfNotObtained = failIfNotObtained;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        boolean adminRightsRequired = Objects.equals(Boolean.TRUE, InstallerVariables.getVariable("sys.adminRights"));
        if (!(!adminRightsRequired || Util.isAdminGroup() && Util.hasFullAdminRights())) {
            if (Util.isWindows()) {
                return this.handleResult(this.startOnWindows(context), context);
            }
            if (Util.isMacOS()) {
                return this.handleResult(this.startOnMac(context), context);
            }
            if (RequestPrivilegesAction.isLinuxPrivilegeHandling()) {
                boolean success = false;
                if (!Objects.equals(Boolean.TRUE, InstallerVariables.getVariable("sys.adminRightsUiRootUnix"))) {
                    success = this.startOnLinux(context);
                }
                return this.handleResult(success, context);
            }
            return this.handleResult(false, context);
        }
        return true;
    }

    private boolean handleResult(boolean success, Context context) throws UserCanceledException {
        this.setAdminRightsVariable();
        if (!success && this.isFailIfNotObtained()) {
            this.showFailureMessage(context);
        }
        return success;
    }
}

