"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkspaceService = void 0;
var _operators = require("rxjs/operators");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
/** @internal */
class WorkspaceService {
  constructor(coreContext) {
    this.coreContext = coreContext;
    _defineProperty(this, "log", void 0);
    _defineProperty(this, "config$", void 0);
    this.log = this.coreContext.logger.get('workspace-service');
    this.config$ = this.coreContext.configService.atPath('workspace');
  }
  async setup() {
    this.log.debug('Setting up workspace service');
    const workspaceConfig = await this.config$.pipe((0, _operators.first)()).toPromise();
    return {
      isWorkspaceEnabled: () => workspaceConfig.enabled
    };
  }
  async start() {
    this.log.debug('Starting workspace service');
    const workspaceConfig = await this.config$.pipe((0, _operators.first)()).toPromise();
    return {
      isWorkspaceEnabled: () => workspaceConfig.enabled
    };
  }
  async stop() {}
}
exports.WorkspaceService = WorkspaceService;