# Namco 163 (also called N163, Namco C163, Namco 106 [sic], Namco 160 or Namco 129)

this is one of Namco's NES mappers, with up to 8 wavetable channels.

it has 256 nibbles (128 bytes) of internal RAM which is shared between channel state and waves.

wavetables are variable in size and may be allocated anywhere in RAM. at least 128 nibbles (64 bytes) can be dedicated to waves, with more available if not all channels are used - waveform RAM area becomes smaller as more channels are activated, since channel registers consume 8 bytes for each channel.

Namco 163 uses time-division multiplexing (TDM) for its output. this means that only one channel is output per sample (like OPLL and OPN2). therefore, its sound quality gets worse as more channels are activated.

## waveform load position versus waveform position

in Furnace, waveform **load** position/length is different from the waveform position/length.

when placing a note, the load pos/len and the pos/len are set to the values specified in the instrument.

waveforms are loaded in the region set by the **load** pos/len, which you can change using effects `15xx` and `16xx` as described below.

the region that will play is set by the waveform pos/len, which you can alter using effects `11xx` and `12xx`.

the waveform pos/len macros only change the pos/len, and not the **load** one.

if the waveform changes (e.g. ins change, wave macro or wave synth), or the **load** pos/len changes, the wave is written to memory.

## effects

- `10xx`: **set waveform for playback.**
- `11xx`: **set waveform position in RAM for playback.**
- `12xx`: **set waveform length in RAM for playback.**
  - `x` goes from `04` to `FC` in steps of 4.
- `15xx`: **set waveform load position.**
- `16xx`: **set waveform load length.**
  - `x` goes from `04` to `FC` in steps of 4.
- `180x`: **set channel limit.**
  - range of `x` is `0` to `7`. 1 is added to get results of 1 through 8.
- `20xx`: **load a waveform to RAM.**
  - `x` is the waveform.
  - the length is determined by the wave's width (it will be snapped to a multiple of 4 if it isn't).
  - make sure to use `21xx` first!
- `21xx`: **set position for 20xx.**

## info

this chip uses the [Namco 163](../4-instrument/n163.md) instrument editor.

## chip config

the following options are available in the Chip Manager window:

- **Clock rate**: sets the rate at which the chip will run.
- **Initial channel limit**: sets the number of channels that will be active. higher values reduce volume and make TDM artifacts more noticeable.
- **Disable hissing**: remove TDM artifacts by mixing. sacrifices some accuracy!
- **Scale frequency to wave length**: automatically adjusts note frequency to account for differing waveform lengths.
  - if disabled, note frequencies ignore waveveform length. this is how FamiTracker behaves.

