"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEK_IN_MILLI_SECS = exports.SUGGEST_ANOMALY_DETECTOR_CONFIG_ID = exports.STACK_TRACE_PATTERN = exports.SORT_DIRECTION = exports.SEC_IN_MILLI_SECS = exports.SAMPLE_TYPE = exports.REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPES = exports.OPENSEARCH_EXCEPTION_PREFIX = exports.MODEL_ID_FIELD = exports.MIN_IN_MILLI_SECS = exports.MAX_MONITORS = exports.MAX_DETECTORS = exports.MAX_ANOMALY_GRADE_FIELD = exports.MAX_ALERTS = exports.KEY_FIELD = exports.HOUR_IN_MILLI_SECS = exports.HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPES = exports.HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.ENTITY_VALUE_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = exports.ENTITY_LIST_FIELD = exports.ENTITY_LIST_DELIMITER = exports.ENTITY_FIELD = exports.DOC_COUNT_FIELD = exports.DETECTOR_STATE = exports.DETECTORS_QUERY_PARAMS = exports.DEFAULT_HEADERS = exports.DAY_IN_MILLI_SECS = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CLUSTER = exports.API = exports.ALERTING_API_ROUTE_PREFIX = exports.AD_DOC_FIELDS = exports.AD_API_ROUTE_PREFIX = void 0;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const AD_API_ROUTE_PREFIX = exports.AD_API_ROUTE_PREFIX = '/_plugins/_anomaly_detection';
const ALERTING_API_ROUTE_PREFIX = exports.ALERTING_API_ROUTE_PREFIX = '/_plugins/_alerting';
const API = exports.API = {
  DETECTOR_BASE: `${AD_API_ROUTE_PREFIX}/detectors`,
  ALERTING_BASE: `${ALERTING_API_ROUTE_PREFIX}/monitors`
};
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch Dashboards'
};
const SEC_IN_MILLI_SECS = exports.SEC_IN_MILLI_SECS = 1000;
const MIN_IN_MILLI_SECS = exports.MIN_IN_MILLI_SECS = 60 * SEC_IN_MILLI_SECS;
const HOUR_IN_MILLI_SECS = exports.HOUR_IN_MILLI_SECS = 60 * MIN_IN_MILLI_SECS;
const DAY_IN_MILLI_SECS = exports.DAY_IN_MILLI_SECS = 24 * HOUR_IN_MILLI_SECS;
const WEEK_IN_MILLI_SECS = exports.WEEK_IN_MILLI_SECS = 7 * DAY_IN_MILLI_SECS;
let CLUSTER = exports.CLUSTER = /*#__PURE__*/function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["AES_AD"] = "aes_ad";
  CLUSTER["DATA"] = "data";
  return CLUSTER;
}({});
let SORT_DIRECTION = exports.SORT_DIRECTION = /*#__PURE__*/function (SORT_DIRECTION) {
  SORT_DIRECTION["ASC"] = "asc";
  SORT_DIRECTION["DESC"] = "desc";
  return SORT_DIRECTION;
}({});
let DETECTORS_QUERY_PARAMS = exports.DETECTORS_QUERY_PARAMS = /*#__PURE__*/function (DETECTORS_QUERY_PARAMS) {
  DETECTORS_QUERY_PARAMS["FROM"] = "from";
  DETECTORS_QUERY_PARAMS["SIZE"] = "size";
  DETECTORS_QUERY_PARAMS["SEARCH"] = "search";
  DETECTORS_QUERY_PARAMS["INDICES"] = "indices";
  DETECTORS_QUERY_PARAMS["SORT_FIELD"] = "sortField";
  DETECTORS_QUERY_PARAMS["SORT_DIRECTION"] = "sortDirection";
  DETECTORS_QUERY_PARAMS["NAME"] = "name";
  DETECTORS_QUERY_PARAMS["DATASOURCEID"] = "dataSourceId";
  return DETECTORS_QUERY_PARAMS;
}({});
let AD_DOC_FIELDS = exports.AD_DOC_FIELDS = /*#__PURE__*/function (AD_DOC_FIELDS) {
  AD_DOC_FIELDS["DATA_START_TIME"] = "data_start_time";
  AD_DOC_FIELDS["DATA_END_TIME"] = "data_end_time";
  AD_DOC_FIELDS["DETECTOR_ID"] = "detector_id";
  AD_DOC_FIELDS["TASK_ID"] = "task_id";
  AD_DOC_FIELDS["DETECTOR_NAME"] = "name";
  AD_DOC_FIELDS["PLOT_TIME"] = "plot_time";
  AD_DOC_FIELDS["ANOMALY_GRADE"] = "anomaly_grade";
  AD_DOC_FIELDS["ERROR"] = "error";
  AD_DOC_FIELDS["INDICES"] = "indices";
  return AD_DOC_FIELDS;
}({});
const MAX_DETECTORS = exports.MAX_DETECTORS = 1000;
const MAX_MONITORS = exports.MAX_MONITORS = 1000;
const MAX_ALERTS = exports.MAX_ALERTS = 1000;

// TODO: maybe move types/interfaces/constants/helpers shared between client and server
// side as many as possible into single place
let DETECTOR_STATE = exports.DETECTOR_STATE = /*#__PURE__*/function (DETECTOR_STATE) {
  DETECTOR_STATE["DISABLED"] = "Stopped";
  DETECTOR_STATE["INIT"] = "Initializing";
  DETECTOR_STATE["RUNNING"] = "Running";
  DETECTOR_STATE["FINISHED"] = "Finished";
  DETECTOR_STATE["FEATURE_REQUIRED"] = "Feature required";
  DETECTOR_STATE["INIT_FAILURE"] = "Initialization failure";
  DETECTOR_STATE["UNEXPECTED_FAILURE"] = "Unexpected failure";
  DETECTOR_STATE["FAILED"] = "Failed";
  return DETECTOR_STATE;
}({});
let SAMPLE_TYPE = exports.SAMPLE_TYPE = /*#__PURE__*/function (SAMPLE_TYPE) {
  SAMPLE_TYPE["HTTP_RESPONSES"] = "http-responses";
  SAMPLE_TYPE["HOST_HEALTH"] = "host-health";
  SAMPLE_TYPE["ECOMMERCE"] = "ecommerce";
  return SAMPLE_TYPE;
}({});
const ENTITY_FIELD = exports.ENTITY_FIELD = 'entity';
const ENTITY_VALUE_PATH_FIELD = exports.ENTITY_VALUE_PATH_FIELD = 'entity.value';
const ENTITY_NAME_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = 'entity.name';
const MODEL_ID_FIELD = exports.MODEL_ID_FIELD = 'model_id';
const DOC_COUNT_FIELD = exports.DOC_COUNT_FIELD = 'doc_count';
const KEY_FIELD = exports.KEY_FIELD = 'key';
const ENTITY_LIST_FIELD = exports.ENTITY_LIST_FIELD = 'entity_list';
const MAX_ANOMALY_GRADE_FIELD = exports.MAX_ANOMALY_GRADE_FIELD = 'max_anomaly_grade';

// y-axis values in the heatmap chart should be in the form:
// <category-field-value-1><br><category-field-value-2>
const ENTITY_LIST_DELIMITER = exports.ENTITY_LIST_DELIMITER = '<br>';

// when hovering over a cell, the entity list should be in the form:
// <category-field-name-1>: <category-field-value-1>, <category-field-name-2>: <category-field-value-2>
const HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CELL_ENTITY_DELIMITER = ', ';
const HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = ': ';
const STACK_TRACE_PATTERN = exports.STACK_TRACE_PATTERN = '.java:';
const OPENSEARCH_EXCEPTION_PREFIX = exports.OPENSEARCH_EXCEPTION_PREFIX = 'org.opensearch.OpenSearchException: ';
const REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPE_PREFIX = 'REALTIME';
const HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPE_PREFIX = 'HISTORICAL';
const REALTIME_TASK_TYPES = exports.REALTIME_TASK_TYPES = ['REALTIME_HC_DETECTOR', 'REALTIME_SINGLE_ENTITY'];
const HISTORICAL_TASK_TYPES = exports.HISTORICAL_TASK_TYPES = ['HISTORICAL_SINGLE_ENTITY', 'HISTORICAL_HC_DETECTOR', 'HISTORICAL'];
const CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = 'opensearch-ad-plugin-result-';
const SUGGEST_ANOMALY_DETECTOR_CONFIG_ID = exports.SUGGEST_ANOMALY_DETECTOR_CONFIG_ID = 'os_suggest_ad';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJBRF9BUElfUk9VVEVfUFJFRklYIiwiZXhwb3J0cyIsIkFMRVJUSU5HX0FQSV9ST1VURV9QUkVGSVgiLCJBUEkiLCJERVRFQ1RPUl9CQVNFIiwiQUxFUlRJTkdfQkFTRSIsIkRFRkFVTFRfSEVBREVSUyIsIkFjY2VwdCIsIlNFQ19JTl9NSUxMSV9TRUNTIiwiTUlOX0lOX01JTExJX1NFQ1MiLCJIT1VSX0lOX01JTExJX1NFQ1MiLCJEQVlfSU5fTUlMTElfU0VDUyIsIldFRUtfSU5fTUlMTElfU0VDUyIsIkNMVVNURVIiLCJTT1JUX0RJUkVDVElPTiIsIkRFVEVDVE9SU19RVUVSWV9QQVJBTVMiLCJBRF9ET0NfRklFTERTIiwiTUFYX0RFVEVDVE9SUyIsIk1BWF9NT05JVE9SUyIsIk1BWF9BTEVSVFMiLCJERVRFQ1RPUl9TVEFURSIsIlNBTVBMRV9UWVBFIiwiRU5USVRZX0ZJRUxEIiwiRU5USVRZX1ZBTFVFX1BBVEhfRklFTEQiLCJFTlRJVFlfTkFNRV9QQVRIX0ZJRUxEIiwiTU9ERUxfSURfRklFTEQiLCJET0NfQ09VTlRfRklFTEQiLCJLRVlfRklFTEQiLCJFTlRJVFlfTElTVF9GSUVMRCIsIk1BWF9BTk9NQUxZX0dSQURFX0ZJRUxEIiwiRU5USVRZX0xJU1RfREVMSU1JVEVSIiwiSEVBVE1BUF9DRUxMX0VOVElUWV9ERUxJTUlURVIiLCJIRUFUTUFQX0NBTExfRU5USVRZX0tFWV9WQUxVRV9ERUxJTUlURVIiLCJTVEFDS19UUkFDRV9QQVRURVJOIiwiT1BFTlNFQVJDSF9FWENFUFRJT05fUFJFRklYIiwiUkVBTFRJTUVfVEFTS19UWVBFX1BSRUZJWCIsIkhJU1RPUklDQUxfVEFTS19UWVBFX1BSRUZJWCIsIlJFQUxUSU1FX1RBU0tfVFlQRVMiLCJISVNUT1JJQ0FMX1RBU0tfVFlQRVMiLCJDVVNUT01fQURfUkVTVUxUX0lOREVYX1BSRUZJWCIsIlNVR0dFU1RfQU5PTUFMWV9ERVRFQ1RPUl9DT05GSUdfSUQiXSwic291cmNlcyI6WyJjb25zdGFudHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKlxuICogVGhlIE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzIHJlcXVpcmUgY29udHJpYnV0aW9ucyBtYWRlIHRvXG4gKiB0aGlzIGZpbGUgYmUgbGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZS0yLjAgbGljZW5zZSBvciBhXG4gKiBjb21wYXRpYmxlIG9wZW4gc291cmNlIGxpY2Vuc2UuXG4gKlxuICogTW9kaWZpY2F0aW9ucyBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnMuIFNlZVxuICogR2l0SHViIGhpc3RvcnkgZm9yIGRldGFpbHMuXG4gKi9cblxuaW1wb3J0IHsgQURBcGlzLCBEZWZhdWx0SGVhZGVycyB9IGZyb20gJy4uL21vZGVscy9pbnRlcmZhY2VzJztcblxuZXhwb3J0IGNvbnN0IEFEX0FQSV9ST1VURV9QUkVGSVggPSAnL19wbHVnaW5zL19hbm9tYWx5X2RldGVjdGlvbic7XG5leHBvcnQgY29uc3QgQUxFUlRJTkdfQVBJX1JPVVRFX1BSRUZJWCA9ICcvX3BsdWdpbnMvX2FsZXJ0aW5nJztcblxuZXhwb3J0IGNvbnN0IEFQSTogQURBcGlzID0ge1xuICBERVRFQ1RPUl9CQVNFOiBgJHtBRF9BUElfUk9VVEVfUFJFRklYfS9kZXRlY3RvcnNgLFxuICBBTEVSVElOR19CQVNFOiBgJHtBTEVSVElOR19BUElfUk9VVEVfUFJFRklYfS9tb25pdG9yc2AsXG59O1xuXG5leHBvcnQgY29uc3QgREVGQVVMVF9IRUFERVJTOiBEZWZhdWx0SGVhZGVycyA9IHtcbiAgJ0NvbnRlbnQtVHlwZSc6ICdhcHBsaWNhdGlvbi9qc29uJyxcbiAgQWNjZXB0OiAnYXBwbGljYXRpb24vanNvbicsXG4gICdVc2VyLUFnZW50JzogJ09wZW5TZWFyY2ggRGFzaGJvYXJkcycsXG59O1xuXG5leHBvcnQgY29uc3QgU0VDX0lOX01JTExJX1NFQ1MgPSAxMDAwO1xuXG5leHBvcnQgY29uc3QgTUlOX0lOX01JTExJX1NFQ1MgPSA2MCAqIFNFQ19JTl9NSUxMSV9TRUNTO1xuXG5leHBvcnQgY29uc3QgSE9VUl9JTl9NSUxMSV9TRUNTID0gNjAgKiBNSU5fSU5fTUlMTElfU0VDUztcblxuZXhwb3J0IGNvbnN0IERBWV9JTl9NSUxMSV9TRUNTID0gMjQgKiBIT1VSX0lOX01JTExJX1NFQ1M7XG5cbmV4cG9ydCBjb25zdCBXRUVLX0lOX01JTExJX1NFQ1MgPSA3ICogREFZX0lOX01JTExJX1NFQ1M7XG5cbmV4cG9ydCBlbnVtIENMVVNURVIge1xuICBBRE1JTiA9ICdhZG1pbicsXG4gIEFFU19BRCA9ICdhZXNfYWQnLFxuICBEQVRBID0gJ2RhdGEnLFxufVxuXG5leHBvcnQgZW51bSBTT1JUX0RJUkVDVElPTiB7XG4gIEFTQyA9ICdhc2MnLFxuICBERVNDID0gJ2Rlc2MnLFxufVxuXG5leHBvcnQgZW51bSBERVRFQ1RPUlNfUVVFUllfUEFSQU1TIHtcbiAgRlJPTSA9ICdmcm9tJyxcbiAgU0laRSA9ICdzaXplJyxcbiAgU0VBUkNIID0gJ3NlYXJjaCcsXG4gIElORElDRVMgPSAnaW5kaWNlcycsXG4gIFNPUlRfRklFTEQgPSAnc29ydEZpZWxkJyxcbiAgU09SVF9ESVJFQ1RJT04gPSAnc29ydERpcmVjdGlvbicsXG4gIE5BTUUgPSAnbmFtZScsXG4gIERBVEFTT1VSQ0VJRCA9ICdkYXRhU291cmNlSWQnLFxufVxuXG5leHBvcnQgZW51bSBBRF9ET0NfRklFTERTIHtcbiAgREFUQV9TVEFSVF9USU1FID0gJ2RhdGFfc3RhcnRfdGltZScsXG4gIERBVEFfRU5EX1RJTUUgPSAnZGF0YV9lbmRfdGltZScsXG4gIERFVEVDVE9SX0lEID0gJ2RldGVjdG9yX2lkJyxcbiAgVEFTS19JRCA9ICd0YXNrX2lkJyxcbiAgREVURUNUT1JfTkFNRSA9ICduYW1lJyxcbiAgUExPVF9USU1FID0gJ3Bsb3RfdGltZScsXG4gIEFOT01BTFlfR1JBREUgPSAnYW5vbWFseV9ncmFkZScsXG4gIEVSUk9SID0gJ2Vycm9yJyxcbiAgSU5ESUNFUyA9ICdpbmRpY2VzJyxcbn1cblxuZXhwb3J0IGNvbnN0IE1BWF9ERVRFQ1RPUlMgPSAxMDAwO1xuXG5leHBvcnQgY29uc3QgTUFYX01PTklUT1JTID0gMTAwMDtcblxuZXhwb3J0IGNvbnN0IE1BWF9BTEVSVFMgPSAxMDAwO1xuXG4vLyBUT0RPOiBtYXliZSBtb3ZlIHR5cGVzL2ludGVyZmFjZXMvY29uc3RhbnRzL2hlbHBlcnMgc2hhcmVkIGJldHdlZW4gY2xpZW50IGFuZCBzZXJ2ZXJcbi8vIHNpZGUgYXMgbWFueSBhcyBwb3NzaWJsZSBpbnRvIHNpbmdsZSBwbGFjZVxuZXhwb3J0IGVudW0gREVURUNUT1JfU1RBVEUge1xuICBESVNBQkxFRCA9ICdTdG9wcGVkJyxcbiAgSU5JVCA9ICdJbml0aWFsaXppbmcnLFxuICBSVU5OSU5HID0gJ1J1bm5pbmcnLFxuICBGSU5JU0hFRCA9ICdGaW5pc2hlZCcsXG4gIEZFQVRVUkVfUkVRVUlSRUQgPSAnRmVhdHVyZSByZXF1aXJlZCcsXG4gIElOSVRfRkFJTFVSRSA9ICdJbml0aWFsaXphdGlvbiBmYWlsdXJlJyxcbiAgVU5FWFBFQ1RFRF9GQUlMVVJFID0gJ1VuZXhwZWN0ZWQgZmFpbHVyZScsXG4gIEZBSUxFRCA9ICdGYWlsZWQnLFxufVxuXG5leHBvcnQgZW51bSBTQU1QTEVfVFlQRSB7XG4gIEhUVFBfUkVTUE9OU0VTID0gJ2h0dHAtcmVzcG9uc2VzJyxcbiAgSE9TVF9IRUFMVEggPSAnaG9zdC1oZWFsdGgnLFxuICBFQ09NTUVSQ0UgPSAnZWNvbW1lcmNlJyxcbn1cblxuZXhwb3J0IGNvbnN0IEVOVElUWV9GSUVMRCA9ICdlbnRpdHknO1xuZXhwb3J0IGNvbnN0IEVOVElUWV9WQUxVRV9QQVRIX0ZJRUxEID0gJ2VudGl0eS52YWx1ZSc7XG5leHBvcnQgY29uc3QgRU5USVRZX05BTUVfUEFUSF9GSUVMRCA9ICdlbnRpdHkubmFtZSc7XG5leHBvcnQgY29uc3QgTU9ERUxfSURfRklFTEQgPSAnbW9kZWxfaWQnO1xuXG5leHBvcnQgY29uc3QgRE9DX0NPVU5UX0ZJRUxEID0gJ2RvY19jb3VudCc7XG5leHBvcnQgY29uc3QgS0VZX0ZJRUxEID0gJ2tleSc7XG5leHBvcnQgY29uc3QgRU5USVRZX0xJU1RfRklFTEQgPSAnZW50aXR5X2xpc3QnO1xuZXhwb3J0IGNvbnN0IE1BWF9BTk9NQUxZX0dSQURFX0ZJRUxEID0gJ21heF9hbm9tYWx5X2dyYWRlJztcblxuLy8geS1heGlzIHZhbHVlcyBpbiB0aGUgaGVhdG1hcCBjaGFydCBzaG91bGQgYmUgaW4gdGhlIGZvcm06XG4vLyA8Y2F0ZWdvcnktZmllbGQtdmFsdWUtMT48YnI+PGNhdGVnb3J5LWZpZWxkLXZhbHVlLTI+XG5leHBvcnQgY29uc3QgRU5USVRZX0xJU1RfREVMSU1JVEVSID0gJzxicj4nO1xuXG4vLyB3aGVuIGhvdmVyaW5nIG92ZXIgYSBjZWxsLCB0aGUgZW50aXR5IGxpc3Qgc2hvdWxkIGJlIGluIHRoZSBmb3JtOlxuLy8gPGNhdGVnb3J5LWZpZWxkLW5hbWUtMT46IDxjYXRlZ29yeS1maWVsZC12YWx1ZS0xPiwgPGNhdGVnb3J5LWZpZWxkLW5hbWUtMj46IDxjYXRlZ29yeS1maWVsZC12YWx1ZS0yPlxuZXhwb3J0IGNvbnN0IEhFQVRNQVBfQ0VMTF9FTlRJVFlfREVMSU1JVEVSID0gJywgJztcbmV4cG9ydCBjb25zdCBIRUFUTUFQX0NBTExfRU5USVRZX0tFWV9WQUxVRV9ERUxJTUlURVIgPSAnOiAnO1xuXG5leHBvcnQgY29uc3QgU1RBQ0tfVFJBQ0VfUEFUVEVSTiA9ICcuamF2YTonO1xuZXhwb3J0IGNvbnN0IE9QRU5TRUFSQ0hfRVhDRVBUSU9OX1BSRUZJWCA9XG4gICdvcmcub3BlbnNlYXJjaC5PcGVuU2VhcmNoRXhjZXB0aW9uOiAnO1xuXG5leHBvcnQgY29uc3QgUkVBTFRJTUVfVEFTS19UWVBFX1BSRUZJWCA9ICdSRUFMVElNRSc7XG5leHBvcnQgY29uc3QgSElTVE9SSUNBTF9UQVNLX1RZUEVfUFJFRklYID0gJ0hJU1RPUklDQUwnO1xuXG5leHBvcnQgY29uc3QgUkVBTFRJTUVfVEFTS19UWVBFUyA9IFtcbiAgJ1JFQUxUSU1FX0hDX0RFVEVDVE9SJyxcbiAgJ1JFQUxUSU1FX1NJTkdMRV9FTlRJVFknLFxuXTtcblxuZXhwb3J0IGNvbnN0IEhJU1RPUklDQUxfVEFTS19UWVBFUyA9IFtcbiAgJ0hJU1RPUklDQUxfU0lOR0xFX0VOVElUWScsXG4gICdISVNUT1JJQ0FMX0hDX0RFVEVDVE9SJyxcbiAgJ0hJU1RPUklDQUwnLFxuXTtcblxuZXhwb3J0IGNvbnN0IENVU1RPTV9BRF9SRVNVTFRfSU5ERVhfUFJFRklYID0gJ29wZW5zZWFyY2gtYWQtcGx1Z2luLXJlc3VsdC0nO1xuXG5leHBvcnQgY29uc3QgU1VHR0VTVF9BTk9NQUxZX0RFVEVDVE9SX0NPTkZJR19JRCA9ICdvc19zdWdnZXN0X2FkJztcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBSU8sTUFBTUEsbUJBQW1CLEdBQUFDLE9BQUEsQ0FBQUQsbUJBQUEsR0FBRyw4QkFBOEI7QUFDMUQsTUFBTUUseUJBQXlCLEdBQUFELE9BQUEsQ0FBQUMseUJBQUEsR0FBRyxxQkFBcUI7QUFFdkQsTUFBTUMsR0FBVyxHQUFBRixPQUFBLENBQUFFLEdBQUEsR0FBRztFQUN6QkMsYUFBYSxFQUFHLEdBQUVKLG1CQUFvQixZQUFXO0VBQ2pESyxhQUFhLEVBQUcsR0FBRUgseUJBQTBCO0FBQzlDLENBQUM7QUFFTSxNQUFNSSxlQUErQixHQUFBTCxPQUFBLENBQUFLLGVBQUEsR0FBRztFQUM3QyxjQUFjLEVBQUUsa0JBQWtCO0VBQ2xDQyxNQUFNLEVBQUUsa0JBQWtCO0VBQzFCLFlBQVksRUFBRTtBQUNoQixDQUFDO0FBRU0sTUFBTUMsaUJBQWlCLEdBQUFQLE9BQUEsQ0FBQU8saUJBQUEsR0FBRyxJQUFJO0FBRTlCLE1BQU1DLGlCQUFpQixHQUFBUixPQUFBLENBQUFRLGlCQUFBLEdBQUcsRUFBRSxHQUFHRCxpQkFBaUI7QUFFaEQsTUFBTUUsa0JBQWtCLEdBQUFULE9BQUEsQ0FBQVMsa0JBQUEsR0FBRyxFQUFFLEdBQUdELGlCQUFpQjtBQUVqRCxNQUFNRSxpQkFBaUIsR0FBQVYsT0FBQSxDQUFBVSxpQkFBQSxHQUFHLEVBQUUsR0FBR0Qsa0JBQWtCO0FBRWpELE1BQU1FLGtCQUFrQixHQUFBWCxPQUFBLENBQUFXLGtCQUFBLEdBQUcsQ0FBQyxHQUFHRCxpQkFBaUI7QUFBQyxJQUU1Q0UsT0FBTyxHQUFBWixPQUFBLENBQUFZLE9BQUEsMEJBQVBBLE9BQU87RUFBUEEsT0FBTztFQUFQQSxPQUFPO0VBQVBBLE9BQU87RUFBQSxPQUFQQSxPQUFPO0FBQUE7QUFBQSxJQU1QQyxjQUFjLEdBQUFiLE9BQUEsQ0FBQWEsY0FBQSwwQkFBZEEsY0FBYztFQUFkQSxjQUFjO0VBQWRBLGNBQWM7RUFBQSxPQUFkQSxjQUFjO0FBQUE7QUFBQSxJQUtkQyxzQkFBc0IsR0FBQWQsT0FBQSxDQUFBYyxzQkFBQSwwQkFBdEJBLHNCQUFzQjtFQUF0QkEsc0JBQXNCO0VBQXRCQSxzQkFBc0I7RUFBdEJBLHNCQUFzQjtFQUF0QkEsc0JBQXNCO0VBQXRCQSxzQkFBc0I7RUFBdEJBLHNCQUFzQjtFQUF0QkEsc0JBQXNCO0VBQXRCQSxzQkFBc0I7RUFBQSxPQUF0QkEsc0JBQXNCO0FBQUE7QUFBQSxJQVd0QkMsYUFBYSxHQUFBZixPQUFBLENBQUFlLGFBQUEsMEJBQWJBLGFBQWE7RUFBYkEsYUFBYTtFQUFiQSxhQUFhO0VBQWJBLGFBQWE7RUFBYkEsYUFBYTtFQUFiQSxhQUFhO0VBQWJBLGFBQWE7RUFBYkEsYUFBYTtFQUFiQSxhQUFhO0VBQWJBLGFBQWE7RUFBQSxPQUFiQSxhQUFhO0FBQUE7QUFZbEIsTUFBTUMsYUFBYSxHQUFBaEIsT0FBQSxDQUFBZ0IsYUFBQSxHQUFHLElBQUk7QUFFMUIsTUFBTUMsWUFBWSxHQUFBakIsT0FBQSxDQUFBaUIsWUFBQSxHQUFHLElBQUk7QUFFekIsTUFBTUMsVUFBVSxHQUFBbEIsT0FBQSxDQUFBa0IsVUFBQSxHQUFHLElBQUk7O0FBRTlCO0FBQ0E7QUFBQSxJQUNZQyxjQUFjLEdBQUFuQixPQUFBLENBQUFtQixjQUFBLDBCQUFkQSxjQUFjO0VBQWRBLGNBQWM7RUFBZEEsY0FBYztFQUFkQSxjQUFjO0VBQWRBLGNBQWM7RUFBZEEsY0FBYztFQUFkQSxjQUFjO0VBQWRBLGNBQWM7RUFBZEEsY0FBYztFQUFBLE9BQWRBLGNBQWM7QUFBQTtBQUFBLElBV2RDLFdBQVcsR0FBQXBCLE9BQUEsQ0FBQW9CLFdBQUEsMEJBQVhBLFdBQVc7RUFBWEEsV0FBVztFQUFYQSxXQUFXO0VBQVhBLFdBQVc7RUFBQSxPQUFYQSxXQUFXO0FBQUE7QUFNaEIsTUFBTUMsWUFBWSxHQUFBckIsT0FBQSxDQUFBcUIsWUFBQSxHQUFHLFFBQVE7QUFDN0IsTUFBTUMsdUJBQXVCLEdBQUF0QixPQUFBLENBQUFzQix1QkFBQSxHQUFHLGNBQWM7QUFDOUMsTUFBTUMsc0JBQXNCLEdBQUF2QixPQUFBLENBQUF1QixzQkFBQSxHQUFHLGFBQWE7QUFDNUMsTUFBTUMsY0FBYyxHQUFBeEIsT0FBQSxDQUFBd0IsY0FBQSxHQUFHLFVBQVU7QUFFakMsTUFBTUMsZUFBZSxHQUFBekIsT0FBQSxDQUFBeUIsZUFBQSxHQUFHLFdBQVc7QUFDbkMsTUFBTUMsU0FBUyxHQUFBMUIsT0FBQSxDQUFBMEIsU0FBQSxHQUFHLEtBQUs7QUFDdkIsTUFBTUMsaUJBQWlCLEdBQUEzQixPQUFBLENBQUEyQixpQkFBQSxHQUFHLGFBQWE7QUFDdkMsTUFBTUMsdUJBQXVCLEdBQUE1QixPQUFBLENBQUE0Qix1QkFBQSxHQUFHLG1CQUFtQjs7QUFFMUQ7QUFDQTtBQUNPLE1BQU1DLHFCQUFxQixHQUFBN0IsT0FBQSxDQUFBNkIscUJBQUEsR0FBRyxNQUFNOztBQUUzQztBQUNBO0FBQ08sTUFBTUMsNkJBQTZCLEdBQUE5QixPQUFBLENBQUE4Qiw2QkFBQSxHQUFHLElBQUk7QUFDMUMsTUFBTUMsdUNBQXVDLEdBQUEvQixPQUFBLENBQUErQix1Q0FBQSxHQUFHLElBQUk7QUFFcEQsTUFBTUMsbUJBQW1CLEdBQUFoQyxPQUFBLENBQUFnQyxtQkFBQSxHQUFHLFFBQVE7QUFDcEMsTUFBTUMsMkJBQTJCLEdBQUFqQyxPQUFBLENBQUFpQywyQkFBQSxHQUN0QyxzQ0FBc0M7QUFFakMsTUFBTUMseUJBQXlCLEdBQUFsQyxPQUFBLENBQUFrQyx5QkFBQSxHQUFHLFVBQVU7QUFDNUMsTUFBTUMsMkJBQTJCLEdBQUFuQyxPQUFBLENBQUFtQywyQkFBQSxHQUFHLFlBQVk7QUFFaEQsTUFBTUMsbUJBQW1CLEdBQUFwQyxPQUFBLENBQUFvQyxtQkFBQSxHQUFHLENBQ2pDLHNCQUFzQixFQUN0Qix3QkFBd0IsQ0FDekI7QUFFTSxNQUFNQyxxQkFBcUIsR0FBQXJDLE9BQUEsQ0FBQXFDLHFCQUFBLEdBQUcsQ0FDbkMsMEJBQTBCLEVBQzFCLHdCQUF3QixFQUN4QixZQUFZLENBQ2I7QUFFTSxNQUFNQyw2QkFBNkIsR0FBQXRDLE9BQUEsQ0FBQXNDLDZCQUFBLEdBQUcsOEJBQThCO0FBRXBFLE1BQU1DLGtDQUFrQyxHQUFBdkMsT0FBQSxDQUFBdUMsa0NBQUEsR0FBRyxlQUFlIn0=