#!/bin/sh
#shellcheck shell=sh
#===============================================================================
# Copyright 2003-2022 Intel Corporation.
#
# This software and the related documents are Intel copyrighted  materials,  and
# your use of  them is  governed by the  express license  under which  they were
# provided to you (License).  Unless the License provides otherwise, you may not
# use, modify, copy, publish, distribute,  disclose or transmit this software or
# the related documents without Intel's prior written permission.
#
# This software and the related documents  are provided as  is,  with no express
# or implied  warranties,  other  than those  that are  expressly stated  in the
# License.
#===============================================================================

mkl_help() {
    __mkl_help=1
    echo ""
    echo "oneAPI MKL vars.sh syntax:"
    echo "  source vars.sh [<arch>] [<MKL_interface>] [mod]"
    echo ""
    echo "   <MKL_interface> (optional) - oneAPI MKL programming interface for intel64"
    echo "                                Not applicable without \"mod\""
    echo "       lp64         : 4 bytes integer (default)"
    echo "       ilp64        : 8 bytes integer"
    echo ""
    echo "   mod (optional) - set path to oneAPI MKL F95 modules"
    echo ""
}

# ############################################################################

# Setup environment.

MKLROOT="${ONEAPI_ROOT}" ; export MKLROOT

# Defaults
__mkl_tmp_TARGET_ARCH=${INTEL_TARGET_ARCH}
__mkl_tmp_LP64_ILP64=
__mkl_tmp_MOD_NAME=mod
__mkl_tmp_MKLVARS_VERBOSE=
__mkl_help=

while [ -n "${1:-}" ]; do
    if [ "$1" = "lp64" ]          ; then __mkl_tmp_LP64_ILP64=lp64;
    elif [ "$1" = "ilp64" ]       ; then __mkl_tmp_LP64_ILP64=ilp64;
    elif [ "$1" = "${__mkl_tmp_MOD_NAME}" ] ; then __mkl_tmp_MOD=${__mkl_tmp_MOD_NAME};
    elif [ "$1" = "verbose" ]     ; then __mkl_tmp_MKLVARS_VERBOSE=verbose;
    elif [ "$1" = "help" ]        ; then mkl_help;
    fi
    shift;
done

if [ -z "${__mkl_help}" ] ; then
        if [ "${__mkl_tmp_MOD}" = "${__mkl_tmp_MOD_NAME}" ] ; then
            if [ "${__mkl_tmp_TARGET_ARCH}" = "ia32" ] ; then
                __mkl_tmp_LP64_ILP64=
            else
                if [ -z "$__mkl_tmp_LP64_ILP64" ] ; then
                    __mkl_tmp_LP64_ILP64=lp64
                fi
            fi
            __cpath="${MKLROOT}/include/mkl/${__mkl_tmp_TARGET_ARCH}/${__mkl_tmp_LP64_ILP64}:${__cpath}"
            export CPATH="${__cpath}${CPATH+:${CPATH}}"
        fi

    if [ "${__mkl_tmp_MKLVARS_VERBOSE}" = "verbose" ] ; then
        echo MKLROOT=${MKLROOT}
        echo LD_LIBRARY_PATH=${LD_LIBRARY_PATH}
        echo LIBRARY_PATH=${LIBRARY_PATH}
        echo NLSPATH=${NLSPATH}
        echo CPATH=${CPATH}
        echo PKG_CONFIG_PATH=${PKG_CONFIG_PATH}
    fi
fi
