/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;

public class CaptionConverter
extends ConverterHelper {
    private boolean bNeedCaptionOf = false;
    private Element seqField = null;

    public CaptionConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bNeedCaptionOf) {
            if (this.config.useCaption()) {
                pack.append("\\usepackage{caption}").nl();
            } else {
                decl.append("% Non-floating captions").nl().append("\\makeatletter").nl().append("\\newcommand\\captionof[1]{\\def\\@captype{#1}\\caption}").nl().append("\\makeatother").nl();
            }
        }
    }

    public void handleCaptionBody(Element node, LaTeXDocumentPortion ldp, Context oc, boolean bIsCaptionOf) {
        this.bNeedCaptionOf |= bIsCaptionOf;
        this.removeCaptionLabel(node, 0);
        Element label = this.seqField;
        this.seqField = null;
        String sStyleName = node.getAttribute("text:style-name");
        this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(this.ofr.getParStyle(sStyleName)));
        if (this.palette.getHeadingCv().containsElements(node)) {
            ldp.append("[");
            this.palette.getInlineCv().traversePlainInlineText(node, ldp, oc);
            ldp.append("]");
        }
        Context ic = (Context)oc.clone();
        ldp.append("{");
        this.palette.getInlineCv().traverseInlineText(node, ldp, ic);
        ldp.append("}").nl();
        this.palette.getFieldCv().handleSequence(label, ldp, oc);
        this.palette.getIndexCv().flushIndexMarks(ldp, oc);
        this.palette.getI18n().popSpecialTable();
    }

    private int removeCaptionLabel(Element node, int nStep) {
        if (nStep == 2) {
            return 2;
        }
        Node removeMe = null;
        block0: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 1) {
                if (nStep == 0 && child.getNodeName().equals("text:sequence")) {
                    removeMe = child;
                    this.seqField = (Element)child;
                    nStep = 1;
                    continue;
                }
                if (nStep >= 2 || OfficeReader.isDrawElement(child)) continue;
                nStep = this.removeCaptionLabel((Element)child, nStep);
                continue;
            }
            if (child.getNodeType() != 3) continue;
            if (nStep == 0) {
                child.setNodeValue("");
                continue;
            }
            if (nStep != 1) continue;
            String s = child.getNodeValue();
            int n = s.length();
            for (int j = 0; j < n; ++j) {
                if (!Character.isLetterOrDigit(s.charAt(j))) continue;
                child.setNodeValue(s.substring(j));
                nStep = 2;
                continue block0;
            }
        }
        if (removeMe != null) {
            node.removeChild(removeMe);
        }
        return nStep;
    }
}

