/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.plugin.FileActionProvider;
import net.sf.sdedit.editor.plugin.FileHandler;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.TabListener;
import net.sf.sdedit.ui.components.FullScreen;
import net.sf.sdedit.ui.components.Stainable;
import net.sf.sdedit.ui.components.StainedListener;
import net.sf.sdedit.ui.components.ZoomPane;
import net.sf.sdedit.ui.components.Zoomable;
import net.sf.sdedit.ui.components.buttons.ActionManager;
import net.sf.sdedit.ui.components.buttons.Activator;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.impl.TabContainerListener;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;
import net.sf.sdedit.util.DocUtil;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.Ref;

public abstract class Tab
extends JPanel
implements Stainable,
TabContainerListener,
Runnable {
    private static ImageIcon cleanIcon = Icons.getIcon("close");
    private static ImageIcon dirtyIcon = Icons.getIcon("close2");
    private File file;
    private List<TabListener> listeners;
    private static FullScreen fullScreen = new FullScreen();
    private boolean clean;
    private List<StainedListener> stainedListeners;
    private final UserInterfaceImpl ui;
    private JPanel contentPanel;
    private JPanel statusPanel;
    private JLabel cleanLabel;
    private JPanel bottom;
    private String title;
    private int id;
    private long lastModified;
    protected Action closeAction = new AbstractAction(){
        {
            this.putValue("Name", "Close");
            this.putValue("SmallIcon", Icons.getIcon("close"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Tab.this.canClose()) {
                Tab.this.close(true);
            }
        }
    };

    protected Tab(UserInterfaceImpl ui) {
        this.ui = ui;
        this.setLayout(new BorderLayout());
        this.contentPanel = new JPanel();
        this.bottom = new JPanel();
        this.add((Component)this.contentPanel, "Center");
        this.add((Component)this.bottom, "South");
        this.bottom.setLayout(new BorderLayout());
        this.cleanLabel = new JLabel(cleanIcon);
        this.cleanLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && Tab.this.canClose()) {
                    Tab.this.close(true);
                }
            }
        });
        this.bottom.add((Component)this.cleanLabel, "West");
        this.statusPanel = new JPanel();
        this.bottom.add((Component)this.statusPanel, "Center");
        this.listeners = new LinkedList<TabListener>();
        this.addTabListener(ui);
        this.stainedListeners = new LinkedList<StainedListener>();
        this.clean = true;
        ui.addTask(this, 500);
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<Tab> getChildren() {
        return this.ui.getTabContainer().getSuccessors(this);
    }

    public Tab getParentTab() {
        return this.ui.getTabContainer().getParentTab(this);
    }

    public int getId() {
        return this.id;
    }

    public boolean alsoRemoveDescendants() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        boolean changed = title != null ? !title.equals(this.title) : this.title != null;
        this.title = title;
        if (changed) {
            for (TabListener listener : this.listeners) {
                listener.titleChanged(this);
            }
        }
    }

    public final JPanel getContentPanel() {
        return this.contentPanel;
    }

    public final JPanel getStatusPanel() {
        return this.statusPanel;
    }

    public final void tabClosing(Tab tab) {
        if (tab == this) {
            this.close(true);
        }
    }

    @Override
    public void tabSelected(Tab previous, Tab current) {
    }

    public abstract Icon getIcon();

    public void fullScreen() {
        fullScreen.display(this.getZoomable());
    }

    public boolean supportsFullScreen() {
        return this.getZoomable() != null;
    }

    protected abstract Zoomable<? extends JComponent> getZoomable();

    public void activate(ActionManager actionManager, FileActionProvider faProvider) {
        if (this.getOverloadedActions() != null) {
            for (Pair<Action, Activator> action : this.getOverloadedActions()) {
                actionManager.overload(action.getFirst(), action.getSecond());
            }
        }
        if (this.getFileHandler() != null) {
            actionManager.overload(faProvider.getSaveAction(this.getFileHandler(), this.ui), faProvider.getSaveActivator);
            actionManager.overload(faProvider.getSaveAsAction(this.getFileHandler(), this.ui), faProvider.getSaveActivator);
        }
    }

    public UserInterfaceImpl get_UI() {
        return this.ui;
    }

    public void deactivate(ActionManager actionManager, FileActionProvider faProvider) {
        if (this.getOverloadedActions() != null) {
            for (Pair<Action, Activator> action : this.getOverloadedActions()) {
                actionManager.unload(action.getFirst());
            }
        }
        if (this.getFileHandler() != null) {
            actionManager.unload(faProvider.getSaveAction(this.getFileHandler(), this.ui));
            actionManager.unload(faProvider.getSaveAsAction(this.getFileHandler(), this.ui));
        }
    }

    @Override
    public boolean isClean() {
        return this.clean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClean(boolean clean) {
        if (clean != this.clean) {
            for (StainedListener stainedListener : this.stainedListeners) {
                stainedListener.stainedStatusChanged(this, !clean);
            }
            if (clean) {
                this.cleanLabel.setIcon(cleanIcon);
            } else {
                this.cleanLabel.setIcon(dirtyIcon);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Tab.this.bottom.revalidate();
                    Tab.this.bottom.repaint();
                }
            });
            this.clean = clean;
            Tab tab = this;
            synchronized (tab) {
                if (this.file != null) {
                    this.lastModified = this.file.lastModified();
                }
            }
        }
    }

    @Override
    public void addStainedListener(StainedListener listener) {
        this.stainedListeners.add(listener);
    }

    public File getFile() {
        return this.file;
    }

    public synchronized void setFile(File file) {
        this.file = file;
        this.lastModified = file == null ? 0L : file.lastModified();
        if (file != null) {
            this.setTitle(file.getName());
        }
    }

    public boolean isReadyToBeClosed(Ref<Boolean> noToAll) {
        String option;
        if (this.isClean() || this.getFileHandler() == null) {
            return true;
        }
        Editor editor = Editor.getEditor();
        if (noToAll != null) {
            option = editor.getUI().getOption("<html>There are unsaved changes. Do you want<br>to save them?", "Cancel", "No", "::::Yes#", "No to all");
            noToAll.t = false;
        } else {
            option = editor.getUI().getOption("<html>There are unsaved changes. Do you want<br>to save them?", "Cancel", "No", "::::Yes#");
        }
        if (option.equals("Yes")) {
            File file = this.getFile();
            if (file == null) {
                try {
                    file = this.getFileHandler().save(this, false);
                }
                catch (IOException ioe) {
                    editor.getUI().errorMessage(ioe, null, null);
                }
            }
            return file != null;
        }
        if (option.equals("No")) {
            return true;
        }
        if (noToAll != null && option.equals("No to all")) {
            noToAll.t = true;
            return true;
        }
        return false;
    }

    public boolean close(boolean check) {
        if (!check || this.isReadyToBeClosed(null)) {
            for (TabListener listener : this.listeners) {
                listener.tabIsClosed(this);
            }
            this.listeners.clear();
            this.stainedListeners.clear();
            this.ui.removeTask(this);
            return true;
        }
        return false;
    }

    public void addTabListener(TabListener listener) {
        this.listeners.add(listener);
    }

    public final List<Action> getContextActions() {
        LinkedList<Action> list = new LinkedList<Action>();
        if (this.canClose()) {
            list.add(this.closeAction);
        }
        this._getContextActions(list);
        return list;
    }

    public abstract boolean canClose();

    public ZoomPane getZoomPane() {
        return null;
    }

    public boolean canZoom() {
        return this.getZoomPane() != null;
    }

    public abstract boolean canGoHome();

    public void goHome() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (this.getFileHandler() != null) {
            boolean changed = false;
            Tab tab = this;
            synchronized (tab) {
                if (this.file != null && this.file.lastModified() > this.lastModified) {
                    changed = true;
                    this.lastModified = this.file.lastModified();
                }
            }
            if (changed) {
                try {
                    FileInputStream is = new FileInputStream(this.file);
                    try {
                        Pair<String, Bean<? extends Configuration>> x = this.getFileHandler().load(is, "utf-8");
                        this.fileChanged(x.getFirst(), x.getSecond());
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    this.ui.errorMessage(e, "Cannot load file", "cannot load file");
                }
                catch (DocUtil.XMLException e) {
                    this.ui.errorMessage(e, "Cannot load file", "cannot load file");
                }
            }
        }
    }

    protected void fileChanged(String text, Bean<? extends Configuration> conf) {
    }

    protected abstract void _getContextActions(List<Action> var1);

    protected abstract List<Pair<Action, Activator>> getOverloadedActions();

    public abstract FileHandler getFileHandler();

    public abstract String getCategory();
}

