// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from MK22F51212.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && mk22f51212

// MK22F51212 NXP Microcontroller
//
//	Redistribution and use in source and binary forms, with or without modification,\nare permitted provided that the following conditions are met:
//	o Redistributions of source code must retain the above copyright notice, this list
//	of conditions and the following disclaimer.
//	o Redistributions in binary form must reproduce the above copyright notice, this
//	list of conditions and the following disclaimer in the documentation and/or
//	other materials provided with the distribution.
//	o Neither the name of the copyright holder nor the names of its
//	contributors may be used to endorse or promote products derived from this
//	software without specific prior written permission.
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
//	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//	DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
//	ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
//	ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//	SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "MK22F51212"
	CPU          = "CM4"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Enhanced direct memory access controller
	IRQ_DMA0 = 0

	// Enhanced direct memory access controller
	IRQ_DMA1 = 1

	// Enhanced direct memory access controller
	IRQ_DMA2 = 2

	// Enhanced direct memory access controller
	IRQ_DMA3 = 3

	// Enhanced direct memory access controller
	IRQ_DMA4 = 4

	// Enhanced direct memory access controller
	IRQ_DMA5 = 5

	// Enhanced direct memory access controller
	IRQ_DMA6 = 6

	// Enhanced direct memory access controller
	IRQ_DMA7 = 7

	// Enhanced direct memory access controller
	IRQ_DMA8 = 8

	// Enhanced direct memory access controller
	IRQ_DMA9 = 9

	// Enhanced direct memory access controller
	IRQ_DMA10 = 10

	// Enhanced direct memory access controller
	IRQ_DMA11 = 11

	// Enhanced direct memory access controller
	IRQ_DMA12 = 12

	// Enhanced direct memory access controller
	IRQ_DMA13 = 13

	// Enhanced direct memory access controller
	IRQ_DMA14 = 14

	// Enhanced direct memory access controller
	IRQ_DMA15 = 15

	// Enhanced direct memory access controller
	IRQ_DMA_Error = 16

	// Core Platform Miscellaneous Control Module
	IRQ_MCM = 17

	// Flash Memory Interface
	IRQ_FTF = 18

	// Flash Memory Interface
	IRQ_Read_Collision = 19

	// Power Management Controller
	IRQ_LVD_LVW = 20

	// Low leakage wakeup unit
	IRQ_LLWU = 21

	// Generation 2008 Watchdog Timer // External Watchdog Monitor
	IRQ_WDOG_EWM = 22

	// Random Number Generator Accelerator
	IRQ_RNG = 23

	// Inter-Integrated Circuit
	IRQ_I2C0 = 24

	// Inter-Integrated Circuit
	IRQ_I2C1 = 25

	// Serial Peripheral Interface
	IRQ_SPI0 = 26

	// Serial Peripheral Interface
	IRQ_SPI1 = 27

	// Inter-IC Sound / Synchronous Audio Interface
	IRQ_I2S0_Tx = 28

	// Inter-IC Sound / Synchronous Audio Interface
	IRQ_I2S0_Rx = 29

	// Universal Asynchronous Receiver/Transmitter
	IRQ_LPUART0 = 30

	// Serial Communication Interface
	IRQ_UART0_RX_TX = 31

	// Serial Communication Interface
	IRQ_UART0_ERR = 32

	// Serial Communication Interface
	IRQ_UART1_RX_TX = 33

	// Serial Communication Interface
	IRQ_UART1_ERR = 34

	// Serial Communication Interface
	IRQ_UART2_RX_TX = 35

	// Serial Communication Interface
	IRQ_UART2_ERR = 36

	// Analog-to-Digital Converter
	IRQ_ADC0 = 39

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	IRQ_CMP0 = 40

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	IRQ_CMP1 = 41

	// FlexTimer Module
	IRQ_FTM0 = 42

	// FlexTimer Module
	IRQ_FTM1 = 43

	// FlexTimer Module
	IRQ_FTM2 = 44

	// Secure Real Time Clock
	IRQ_RTC = 46

	// Secure Real Time Clock
	IRQ_RTC_Seconds = 47

	// Periodic Interrupt Timer
	IRQ_PIT0 = 48

	// Periodic Interrupt Timer
	IRQ_PIT1 = 49

	// Periodic Interrupt Timer
	IRQ_PIT2 = 50

	// Periodic Interrupt Timer
	IRQ_PIT3 = 51

	// Programmable Delay Block
	IRQ_PDB0 = 52

	// Universal Serial Bus, OTG Capable Controller
	IRQ_USB0 = 53

	// 12-Bit Digital-to-Analog Converter
	IRQ_DAC0 = 56

	// Low Power Timer
	IRQ_LPTMR0 = 58

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTA = 59

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTB = 60

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTC = 61

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTD = 62

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTE = 63

	// FlexTimer Module
	IRQ_FTM3 = 71

	// 12-Bit Digital-to-Analog Converter
	IRQ_DAC1 = 72

	// Analog-to-Digital Converter
	IRQ_ADC1 = 73

	// Highest interrupt number on this device.
	IRQ_max = 73
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export DMA0_IRQHandler
func interruptDMA0() {
	callHandlers(IRQ_DMA0)
}

//export DMA1_IRQHandler
func interruptDMA1() {
	callHandlers(IRQ_DMA1)
}

//export DMA2_IRQHandler
func interruptDMA2() {
	callHandlers(IRQ_DMA2)
}

//export DMA3_IRQHandler
func interruptDMA3() {
	callHandlers(IRQ_DMA3)
}

//export DMA4_IRQHandler
func interruptDMA4() {
	callHandlers(IRQ_DMA4)
}

//export DMA5_IRQHandler
func interruptDMA5() {
	callHandlers(IRQ_DMA5)
}

//export DMA6_IRQHandler
func interruptDMA6() {
	callHandlers(IRQ_DMA6)
}

//export DMA7_IRQHandler
func interruptDMA7() {
	callHandlers(IRQ_DMA7)
}

//export DMA8_IRQHandler
func interruptDMA8() {
	callHandlers(IRQ_DMA8)
}

//export DMA9_IRQHandler
func interruptDMA9() {
	callHandlers(IRQ_DMA9)
}

//export DMA10_IRQHandler
func interruptDMA10() {
	callHandlers(IRQ_DMA10)
}

//export DMA11_IRQHandler
func interruptDMA11() {
	callHandlers(IRQ_DMA11)
}

//export DMA12_IRQHandler
func interruptDMA12() {
	callHandlers(IRQ_DMA12)
}

//export DMA13_IRQHandler
func interruptDMA13() {
	callHandlers(IRQ_DMA13)
}

//export DMA14_IRQHandler
func interruptDMA14() {
	callHandlers(IRQ_DMA14)
}

//export DMA15_IRQHandler
func interruptDMA15() {
	callHandlers(IRQ_DMA15)
}

//export DMA_Error_IRQHandler
func interruptDMA_Error() {
	callHandlers(IRQ_DMA_Error)
}

//export MCM_IRQHandler
func interruptMCM() {
	callHandlers(IRQ_MCM)
}

//export FTF_IRQHandler
func interruptFTF() {
	callHandlers(IRQ_FTF)
}

//export Read_Collision_IRQHandler
func interruptRead_Collision() {
	callHandlers(IRQ_Read_Collision)
}

//export LVD_LVW_IRQHandler
func interruptLVD_LVW() {
	callHandlers(IRQ_LVD_LVW)
}

//export LLWU_IRQHandler
func interruptLLWU() {
	callHandlers(IRQ_LLWU)
}

//export WDOG_EWM_IRQHandler
func interruptWDOG_EWM() {
	callHandlers(IRQ_WDOG_EWM)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export I2S0_Tx_IRQHandler
func interruptI2S0_Tx() {
	callHandlers(IRQ_I2S0_Tx)
}

//export I2S0_Rx_IRQHandler
func interruptI2S0_Rx() {
	callHandlers(IRQ_I2S0_Rx)
}

//export LPUART0_IRQHandler
func interruptLPUART0() {
	callHandlers(IRQ_LPUART0)
}

//export UART0_RX_TX_IRQHandler
func interruptUART0_RX_TX() {
	callHandlers(IRQ_UART0_RX_TX)
}

//export UART0_ERR_IRQHandler
func interruptUART0_ERR() {
	callHandlers(IRQ_UART0_ERR)
}

//export UART1_RX_TX_IRQHandler
func interruptUART1_RX_TX() {
	callHandlers(IRQ_UART1_RX_TX)
}

//export UART1_ERR_IRQHandler
func interruptUART1_ERR() {
	callHandlers(IRQ_UART1_ERR)
}

//export UART2_RX_TX_IRQHandler
func interruptUART2_RX_TX() {
	callHandlers(IRQ_UART2_RX_TX)
}

//export UART2_ERR_IRQHandler
func interruptUART2_ERR() {
	callHandlers(IRQ_UART2_ERR)
}

//export ADC0_IRQHandler
func interruptADC0() {
	callHandlers(IRQ_ADC0)
}

//export CMP0_IRQHandler
func interruptCMP0() {
	callHandlers(IRQ_CMP0)
}

//export CMP1_IRQHandler
func interruptCMP1() {
	callHandlers(IRQ_CMP1)
}

//export FTM0_IRQHandler
func interruptFTM0() {
	callHandlers(IRQ_FTM0)
}

//export FTM1_IRQHandler
func interruptFTM1() {
	callHandlers(IRQ_FTM1)
}

//export FTM2_IRQHandler
func interruptFTM2() {
	callHandlers(IRQ_FTM2)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export RTC_Seconds_IRQHandler
func interruptRTC_Seconds() {
	callHandlers(IRQ_RTC_Seconds)
}

//export PIT0_IRQHandler
func interruptPIT0() {
	callHandlers(IRQ_PIT0)
}

//export PIT1_IRQHandler
func interruptPIT1() {
	callHandlers(IRQ_PIT1)
}

//export PIT2_IRQHandler
func interruptPIT2() {
	callHandlers(IRQ_PIT2)
}

//export PIT3_IRQHandler
func interruptPIT3() {
	callHandlers(IRQ_PIT3)
}

//export PDB0_IRQHandler
func interruptPDB0() {
	callHandlers(IRQ_PDB0)
}

//export USB0_IRQHandler
func interruptUSB0() {
	callHandlers(IRQ_USB0)
}

//export DAC0_IRQHandler
func interruptDAC0() {
	callHandlers(IRQ_DAC0)
}

//export LPTMR0_IRQHandler
func interruptLPTMR0() {
	callHandlers(IRQ_LPTMR0)
}

//export PORTA_IRQHandler
func interruptPORTA() {
	callHandlers(IRQ_PORTA)
}

//export PORTB_IRQHandler
func interruptPORTB() {
	callHandlers(IRQ_PORTB)
}

//export PORTC_IRQHandler
func interruptPORTC() {
	callHandlers(IRQ_PORTC)
}

//export PORTD_IRQHandler
func interruptPORTD() {
	callHandlers(IRQ_PORTD)
}

//export PORTE_IRQHandler
func interruptPORTE() {
	callHandlers(IRQ_PORTE)
}

//export FTM3_IRQHandler
func interruptFTM3() {
	callHandlers(IRQ_FTM3)
}

//export DAC1_IRQHandler
func interruptDAC1() {
	callHandlers(IRQ_DAC1)
}

//export ADC1_IRQHandler
func interruptADC1() {
	callHandlers(IRQ_ADC1)
}

// Peripherals.
var (
	// Flash configuration field
	FTFA_FlashConfig = (*FTFA_FlashConfig_Type)(unsafe.Pointer(uintptr(0x400)))

	// Enhanced direct memory access controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// FlexBus external bus interface
	FB = (*FB_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// Flash Memory Controller
	FMC = (*FMC_Type)(unsafe.Pointer(uintptr(0x4001f000)))

	// Flash Memory Interface
	FTFA = (*FTFA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMA channel multiplexor
	DMAMUX = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// FlexTimer Module
	FTM0 = (*FTM_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// FlexTimer Module
	FTM1 = (*FTM_Type)(unsafe.Pointer(uintptr(0x40039000)))

	// FlexTimer Module
	FTM2 = (*FTM_Type)(unsafe.Pointer(uintptr(0x4003a000)))

	// FlexTimer Module
	FTM3 = (*FTM_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// Analog-to-Digital Converter
	ADC0 = (*ADC_Type)(unsafe.Pointer(uintptr(0x4003b000)))

	// Analog-to-Digital Converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40027000)))

	// 12-Bit Digital-to-Analog Converter
	DAC0 = (*DAC_Type)(unsafe.Pointer(uintptr(0x4003f000)))

	// 12-Bit Digital-to-Analog Converter
	DAC1 = (*DAC_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Random Number Generator Accelerator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x40029000)))

	// Universal Asynchronous Receiver/Transmitter
	LPUART0 = (*LPUART0_Type)(unsafe.Pointer(uintptr(0x4002a000)))

	// Serial Peripheral Interface
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// Serial Peripheral Interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x4002d000)))

	// Inter-IC Sound / Synchronous Audio Interface
	I2S0 = (*I2S0_Type)(unsafe.Pointer(uintptr(0x4002f000)))

	// Cyclic Redundancy Check
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40032000)))

	// Programmable Delay Block
	PDB0 = (*PDB0_Type)(unsafe.Pointer(uintptr(0x40036000)))

	// Periodic Interrupt Timer
	PIT = (*PIT_Type)(unsafe.Pointer(uintptr(0x40037000)))

	// Secure Real Time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x4003d000)))

	// VBAT register file
	RFVBAT = (*RFVBAT_Type)(unsafe.Pointer(uintptr(0x4003e000)))

	// Low Power Timer
	LPTMR0 = (*LPTMR0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// System register file
	RFSYS = (*RFSYS_Type)(unsafe.Pointer(uintptr(0x40041000)))

	// System Integration Module
	SIM = (*SIM_Type)(unsafe.Pointer(uintptr(0x40047000)))

	// Pin Control and Interrupts
	PORTA = (*PORT_Type)(unsafe.Pointer(uintptr(0x40049000)))

	// Pin Control and Interrupts
	PORTB = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004a000)))

	// Pin Control and Interrupts
	PORTC = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004b000)))

	// Pin Control and Interrupts
	PORTD = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// Pin Control and Interrupts
	PORTE = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004d000)))

	// Generation 2008 Watchdog Timer
	WDOG = (*WDOG_Type)(unsafe.Pointer(uintptr(0x40052000)))

	// External Watchdog Monitor
	EWM = (*EWM_Type)(unsafe.Pointer(uintptr(0x40061000)))

	// Multipurpose Clock Generator module
	MCG = (*MCG_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Oscillator
	OSC = (*OSC_Type)(unsafe.Pointer(uintptr(0x40065000)))

	// Inter-Integrated Circuit
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40066000)))

	// Inter-Integrated Circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40067000)))

	// Serial Communication Interface
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x4006a000)))

	// Serial Communication Interface
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x4006b000)))

	// Serial Communication Interface
	UART2 = (*UART_Type)(unsafe.Pointer(uintptr(0x4006c000)))

	// Universal Serial Bus, OTG Capable Controller
	USB0 = (*USB0_Type)(unsafe.Pointer(uintptr(0x40072000)))

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	CMP0 = (*CMP_Type)(unsafe.Pointer(uintptr(0x40073000)))

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	CMP1 = (*CMP_Type)(unsafe.Pointer(uintptr(0x40073008)))

	// Voltage Reference
	VREF = (*VREF_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// Low leakage wakeup unit
	LLWU = (*LLWU_Type)(unsafe.Pointer(uintptr(0x4007c000)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x4007d000)))

	// System Mode Controller
	SMC = (*SMC_Type)(unsafe.Pointer(uintptr(0x4007e000)))

	// Reset Control Module
	RCM = (*RCM_Type)(unsafe.Pointer(uintptr(0x4007f000)))

	// General Purpose Input/Output
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff000)))

	// General Purpose Input/Output
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff040)))

	// General Purpose Input/Output
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff080)))

	// General Purpose Input/Output
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff0c0)))

	// General Purpose Input/Output
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff100)))

	// System Control Block
	SystemControl = (*SystemControl_Type)(unsafe.Pointer(uintptr(0xe000e000)))

	// System timer
	SysTick = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Core Platform Miscellaneous Control Module
	MCM = (*MCM_Type)(unsafe.Pointer(uintptr(0xe0080000)))
)

// Flash configuration field
type FTFA_FlashConfig_Type struct {
	BACKKEY3 volatile.Register8 // 0x0
	BACKKEY2 volatile.Register8 // 0x1
	BACKKEY1 volatile.Register8 // 0x2
	BACKKEY0 volatile.Register8 // 0x3
	BACKKEY7 volatile.Register8 // 0x4
	BACKKEY6 volatile.Register8 // 0x5
	BACKKEY5 volatile.Register8 // 0x6
	BACKKEY4 volatile.Register8 // 0x7
	FPROT3   volatile.Register8 // 0x8
	FPROT2   volatile.Register8 // 0x9
	FPROT1   volatile.Register8 // 0xA
	FPROT0   volatile.Register8 // 0xB
	FSEC     volatile.Register8 // 0xC
	FOPT     volatile.Register8 // 0xD
}

// FTFA_FlashConfig.BACKKEY3: Backdoor Comparison Key 3.
func (o *FTFA_FlashConfig_Type) SetBACKKEY3(value uint8) {
	volatile.StoreUint8(&o.BACKKEY3.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY3() uint8 {
	return volatile.LoadUint8(&o.BACKKEY3.Reg)
}

// FTFA_FlashConfig.BACKKEY2: Backdoor Comparison Key 2.
func (o *FTFA_FlashConfig_Type) SetBACKKEY2(value uint8) {
	volatile.StoreUint8(&o.BACKKEY2.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY2() uint8 {
	return volatile.LoadUint8(&o.BACKKEY2.Reg)
}

// FTFA_FlashConfig.BACKKEY1: Backdoor Comparison Key 1.
func (o *FTFA_FlashConfig_Type) SetBACKKEY1(value uint8) {
	volatile.StoreUint8(&o.BACKKEY1.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY1() uint8 {
	return volatile.LoadUint8(&o.BACKKEY1.Reg)
}

// FTFA_FlashConfig.BACKKEY0: Backdoor Comparison Key 0.
func (o *FTFA_FlashConfig_Type) SetBACKKEY0(value uint8) {
	volatile.StoreUint8(&o.BACKKEY0.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY0() uint8 {
	return volatile.LoadUint8(&o.BACKKEY0.Reg)
}

// FTFA_FlashConfig.BACKKEY7: Backdoor Comparison Key 7.
func (o *FTFA_FlashConfig_Type) SetBACKKEY7(value uint8) {
	volatile.StoreUint8(&o.BACKKEY7.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY7() uint8 {
	return volatile.LoadUint8(&o.BACKKEY7.Reg)
}

// FTFA_FlashConfig.BACKKEY6: Backdoor Comparison Key 6.
func (o *FTFA_FlashConfig_Type) SetBACKKEY6(value uint8) {
	volatile.StoreUint8(&o.BACKKEY6.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY6() uint8 {
	return volatile.LoadUint8(&o.BACKKEY6.Reg)
}

// FTFA_FlashConfig.BACKKEY5: Backdoor Comparison Key 5.
func (o *FTFA_FlashConfig_Type) SetBACKKEY5(value uint8) {
	volatile.StoreUint8(&o.BACKKEY5.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY5() uint8 {
	return volatile.LoadUint8(&o.BACKKEY5.Reg)
}

// FTFA_FlashConfig.BACKKEY4: Backdoor Comparison Key 4.
func (o *FTFA_FlashConfig_Type) SetBACKKEY4(value uint8) {
	volatile.StoreUint8(&o.BACKKEY4.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY4() uint8 {
	return volatile.LoadUint8(&o.BACKKEY4.Reg)
}

// FTFA_FlashConfig.FPROT3: Non-volatile P-Flash Protection 1 - Low Register
func (o *FTFA_FlashConfig_Type) SetFPROT3(value uint8) {
	volatile.StoreUint8(&o.FPROT3.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT3() uint8 {
	return volatile.LoadUint8(&o.FPROT3.Reg)
}

// FTFA_FlashConfig.FPROT2: Non-volatile P-Flash Protection 1 - High Register
func (o *FTFA_FlashConfig_Type) SetFPROT2(value uint8) {
	volatile.StoreUint8(&o.FPROT2.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT2() uint8 {
	return volatile.LoadUint8(&o.FPROT2.Reg)
}

// FTFA_FlashConfig.FPROT1: Non-volatile P-Flash Protection 0 - Low Register
func (o *FTFA_FlashConfig_Type) SetFPROT1(value uint8) {
	volatile.StoreUint8(&o.FPROT1.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT1() uint8 {
	return volatile.LoadUint8(&o.FPROT1.Reg)
}

// FTFA_FlashConfig.FPROT0: Non-volatile P-Flash Protection 0 - High Register
func (o *FTFA_FlashConfig_Type) SetFPROT0(value uint8) {
	volatile.StoreUint8(&o.FPROT0.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT0() uint8 {
	return volatile.LoadUint8(&o.FPROT0.Reg)
}

// FTFA_FlashConfig.FSEC: Non-volatile Flash Security Register
func (o *FTFA_FlashConfig_Type) SetFSEC_SEC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x3)|value)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_SEC() uint8 {
	return volatile.LoadUint8(&o.FSEC.Reg) & 0x3
}
func (o *FTFA_FlashConfig_Type) SetFSEC_FSLACC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc)|value<<2)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_FSLACC() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc) >> 2
}
func (o *FTFA_FlashConfig_Type) SetFSEC_MEEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x30)|value<<4)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_MEEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0x30) >> 4
}
func (o *FTFA_FlashConfig_Type) SetFSEC_KEYEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc0)|value<<6)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_KEYEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc0) >> 6
}

// FTFA_FlashConfig.FOPT: Non-volatile Flash Option Register
func (o *FTFA_FlashConfig_Type) SetFOPT_LPBOOT(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x1)|value)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_LPBOOT() uint8 {
	return volatile.LoadUint8(&o.FOPT.Reg) & 0x1
}
func (o *FTFA_FlashConfig_Type) SetFOPT_EZPORT_DIS(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x2)|value<<1)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_EZPORT_DIS() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x2) >> 1
}
func (o *FTFA_FlashConfig_Type) SetFOPT_NMI_DIS(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x4)|value<<2)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_NMI_DIS() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x4) >> 2
}
func (o *FTFA_FlashConfig_Type) SetFOPT_FAST_INIT(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x20)|value<<5)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_FAST_INIT() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x20) >> 5
}

// Enhanced direct memory access controller
type DMA_Type struct {
	CR                  volatile.Register32 // 0x0
	ES                  volatile.Register32 // 0x4
	_                   [4]byte
	ERQ                 volatile.Register32 // 0xC
	_                   [4]byte
	EEI                 volatile.Register32 // 0x14
	CEEI                volatile.Register8  // 0x18
	SEEI                volatile.Register8  // 0x19
	CERQ                volatile.Register8  // 0x1A
	SERQ                volatile.Register8  // 0x1B
	CDNE                volatile.Register8  // 0x1C
	SSRT                volatile.Register8  // 0x1D
	CERR                volatile.Register8  // 0x1E
	CINT                volatile.Register8  // 0x1F
	_                   [4]byte
	INT                 volatile.Register32 // 0x24
	_                   [4]byte
	ERR                 volatile.Register32 // 0x2C
	_                   [4]byte
	HRS                 volatile.Register32 // 0x34
	_                   [12]byte
	EARS                volatile.Register32 // 0x44
	_                   [184]byte
	DCHPRI3             volatile.Register8 // 0x100
	DCHPRI2             volatile.Register8 // 0x101
	DCHPRI1             volatile.Register8 // 0x102
	DCHPRI0             volatile.Register8 // 0x103
	DCHPRI7             volatile.Register8 // 0x104
	DCHPRI6             volatile.Register8 // 0x105
	DCHPRI5             volatile.Register8 // 0x106
	DCHPRI4             volatile.Register8 // 0x107
	DCHPRI11            volatile.Register8 // 0x108
	DCHPRI10            volatile.Register8 // 0x109
	DCHPRI9             volatile.Register8 // 0x10A
	DCHPRI8             volatile.Register8 // 0x10B
	DCHPRI15            volatile.Register8 // 0x10C
	DCHPRI14            volatile.Register8 // 0x10D
	DCHPRI13            volatile.Register8 // 0x10E
	DCHPRI12            volatile.Register8 // 0x10F
	_                   [3824]byte
	TCD0_SADDR          volatile.Register32 // 0x1000
	TCD0_SOFF           volatile.Register16 // 0x1004
	TCD0_ATTR           volatile.Register16 // 0x1006
	TCD0_NBYTES_MLNO    volatile.Register32 // 0x1008
	TCD0_SLAST          volatile.Register32 // 0x100C
	TCD0_DADDR          volatile.Register32 // 0x1010
	TCD0_DOFF           volatile.Register16 // 0x1014
	TCD0_CITER_ELINKNO  volatile.Register16 // 0x1016
	TCD0_DLASTSGA       volatile.Register32 // 0x1018
	TCD0_CSR            volatile.Register16 // 0x101C
	TCD0_BITER_ELINKNO  volatile.Register16 // 0x101E
	TCD1_SADDR          volatile.Register32 // 0x1020
	TCD1_SOFF           volatile.Register16 // 0x1024
	TCD1_ATTR           volatile.Register16 // 0x1026
	TCD1_NBYTES_MLNO    volatile.Register32 // 0x1028
	TCD1_SLAST          volatile.Register32 // 0x102C
	TCD1_DADDR          volatile.Register32 // 0x1030
	TCD1_DOFF           volatile.Register16 // 0x1034
	TCD1_CITER_ELINKNO  volatile.Register16 // 0x1036
	TCD1_DLASTSGA       volatile.Register32 // 0x1038
	TCD1_CSR            volatile.Register16 // 0x103C
	TCD1_BITER_ELINKNO  volatile.Register16 // 0x103E
	TCD2_SADDR          volatile.Register32 // 0x1040
	TCD2_SOFF           volatile.Register16 // 0x1044
	TCD2_ATTR           volatile.Register16 // 0x1046
	TCD2_NBYTES_MLNO    volatile.Register32 // 0x1048
	TCD2_SLAST          volatile.Register32 // 0x104C
	TCD2_DADDR          volatile.Register32 // 0x1050
	TCD2_DOFF           volatile.Register16 // 0x1054
	TCD2_CITER_ELINKNO  volatile.Register16 // 0x1056
	TCD2_DLASTSGA       volatile.Register32 // 0x1058
	TCD2_CSR            volatile.Register16 // 0x105C
	TCD2_BITER_ELINKNO  volatile.Register16 // 0x105E
	TCD3_SADDR          volatile.Register32 // 0x1060
	TCD3_SOFF           volatile.Register16 // 0x1064
	TCD3_ATTR           volatile.Register16 // 0x1066
	TCD3_NBYTES_MLNO    volatile.Register32 // 0x1068
	TCD3_SLAST          volatile.Register32 // 0x106C
	TCD3_DADDR          volatile.Register32 // 0x1070
	TCD3_DOFF           volatile.Register16 // 0x1074
	TCD3_CITER_ELINKNO  volatile.Register16 // 0x1076
	TCD3_DLASTSGA       volatile.Register32 // 0x1078
	TCD3_CSR            volatile.Register16 // 0x107C
	TCD3_BITER_ELINKNO  volatile.Register16 // 0x107E
	TCD4_SADDR          volatile.Register32 // 0x1080
	TCD4_SOFF           volatile.Register16 // 0x1084
	TCD4_ATTR           volatile.Register16 // 0x1086
	TCD4_NBYTES_MLNO    volatile.Register32 // 0x1088
	TCD4_SLAST          volatile.Register32 // 0x108C
	TCD4_DADDR          volatile.Register32 // 0x1090
	TCD4_DOFF           volatile.Register16 // 0x1094
	TCD4_CITER_ELINKNO  volatile.Register16 // 0x1096
	TCD4_DLASTSGA       volatile.Register32 // 0x1098
	TCD4_CSR            volatile.Register16 // 0x109C
	TCD4_BITER_ELINKNO  volatile.Register16 // 0x109E
	TCD5_SADDR          volatile.Register32 // 0x10A0
	TCD5_SOFF           volatile.Register16 // 0x10A4
	TCD5_ATTR           volatile.Register16 // 0x10A6
	TCD5_NBYTES_MLNO    volatile.Register32 // 0x10A8
	TCD5_SLAST          volatile.Register32 // 0x10AC
	TCD5_DADDR          volatile.Register32 // 0x10B0
	TCD5_DOFF           volatile.Register16 // 0x10B4
	TCD5_CITER_ELINKNO  volatile.Register16 // 0x10B6
	TCD5_DLASTSGA       volatile.Register32 // 0x10B8
	TCD5_CSR            volatile.Register16 // 0x10BC
	TCD5_BITER_ELINKNO  volatile.Register16 // 0x10BE
	TCD6_SADDR          volatile.Register32 // 0x10C0
	TCD6_SOFF           volatile.Register16 // 0x10C4
	TCD6_ATTR           volatile.Register16 // 0x10C6
	TCD6_NBYTES_MLNO    volatile.Register32 // 0x10C8
	TCD6_SLAST          volatile.Register32 // 0x10CC
	TCD6_DADDR          volatile.Register32 // 0x10D0
	TCD6_DOFF           volatile.Register16 // 0x10D4
	TCD6_CITER_ELINKNO  volatile.Register16 // 0x10D6
	TCD6_DLASTSGA       volatile.Register32 // 0x10D8
	TCD6_CSR            volatile.Register16 // 0x10DC
	TCD6_BITER_ELINKNO  volatile.Register16 // 0x10DE
	TCD7_SADDR          volatile.Register32 // 0x10E0
	TCD7_SOFF           volatile.Register16 // 0x10E4
	TCD7_ATTR           volatile.Register16 // 0x10E6
	TCD7_NBYTES_MLNO    volatile.Register32 // 0x10E8
	TCD7_SLAST          volatile.Register32 // 0x10EC
	TCD7_DADDR          volatile.Register32 // 0x10F0
	TCD7_DOFF           volatile.Register16 // 0x10F4
	TCD7_CITER_ELINKNO  volatile.Register16 // 0x10F6
	TCD7_DLASTSGA       volatile.Register32 // 0x10F8
	TCD7_CSR            volatile.Register16 // 0x10FC
	TCD7_BITER_ELINKNO  volatile.Register16 // 0x10FE
	TCD8_SADDR          volatile.Register32 // 0x1100
	TCD8_SOFF           volatile.Register16 // 0x1104
	TCD8_ATTR           volatile.Register16 // 0x1106
	TCD8_NBYTES_MLNO    volatile.Register32 // 0x1108
	TCD8_SLAST          volatile.Register32 // 0x110C
	TCD8_DADDR          volatile.Register32 // 0x1110
	TCD8_DOFF           volatile.Register16 // 0x1114
	TCD8_CITER_ELINKNO  volatile.Register16 // 0x1116
	TCD8_DLASTSGA       volatile.Register32 // 0x1118
	TCD8_CSR            volatile.Register16 // 0x111C
	TCD8_BITER_ELINKNO  volatile.Register16 // 0x111E
	TCD9_SADDR          volatile.Register32 // 0x1120
	TCD9_SOFF           volatile.Register16 // 0x1124
	TCD9_ATTR           volatile.Register16 // 0x1126
	TCD9_NBYTES_MLNO    volatile.Register32 // 0x1128
	TCD9_SLAST          volatile.Register32 // 0x112C
	TCD9_DADDR          volatile.Register32 // 0x1130
	TCD9_DOFF           volatile.Register16 // 0x1134
	TCD9_CITER_ELINKNO  volatile.Register16 // 0x1136
	TCD9_DLASTSGA       volatile.Register32 // 0x1138
	TCD9_CSR            volatile.Register16 // 0x113C
	TCD9_BITER_ELINKNO  volatile.Register16 // 0x113E
	TCD10_SADDR         volatile.Register32 // 0x1140
	TCD10_SOFF          volatile.Register16 // 0x1144
	TCD10_ATTR          volatile.Register16 // 0x1146
	TCD10_NBYTES_MLNO   volatile.Register32 // 0x1148
	TCD10_SLAST         volatile.Register32 // 0x114C
	TCD10_DADDR         volatile.Register32 // 0x1150
	TCD10_DOFF          volatile.Register16 // 0x1154
	TCD10_CITER_ELINKNO volatile.Register16 // 0x1156
	TCD10_DLASTSGA      volatile.Register32 // 0x1158
	TCD10_CSR           volatile.Register16 // 0x115C
	TCD10_BITER_ELINKNO volatile.Register16 // 0x115E
	TCD11_SADDR         volatile.Register32 // 0x1160
	TCD11_SOFF          volatile.Register16 // 0x1164
	TCD11_ATTR          volatile.Register16 // 0x1166
	TCD11_NBYTES_MLNO   volatile.Register32 // 0x1168
	TCD11_SLAST         volatile.Register32 // 0x116C
	TCD11_DADDR         volatile.Register32 // 0x1170
	TCD11_DOFF          volatile.Register16 // 0x1174
	TCD11_CITER_ELINKNO volatile.Register16 // 0x1176
	TCD11_DLASTSGA      volatile.Register32 // 0x1178
	TCD11_CSR           volatile.Register16 // 0x117C
	TCD11_BITER_ELINKNO volatile.Register16 // 0x117E
	TCD12_SADDR         volatile.Register32 // 0x1180
	TCD12_SOFF          volatile.Register16 // 0x1184
	TCD12_ATTR          volatile.Register16 // 0x1186
	TCD12_NBYTES_MLNO   volatile.Register32 // 0x1188
	TCD12_SLAST         volatile.Register32 // 0x118C
	TCD12_DADDR         volatile.Register32 // 0x1190
	TCD12_DOFF          volatile.Register16 // 0x1194
	TCD12_CITER_ELINKNO volatile.Register16 // 0x1196
	TCD12_DLASTSGA      volatile.Register32 // 0x1198
	TCD12_CSR           volatile.Register16 // 0x119C
	TCD12_BITER_ELINKNO volatile.Register16 // 0x119E
	TCD13_SADDR         volatile.Register32 // 0x11A0
	TCD13_SOFF          volatile.Register16 // 0x11A4
	TCD13_ATTR          volatile.Register16 // 0x11A6
	TCD13_NBYTES_MLNO   volatile.Register32 // 0x11A8
	TCD13_SLAST         volatile.Register32 // 0x11AC
	TCD13_DADDR         volatile.Register32 // 0x11B0
	TCD13_DOFF          volatile.Register16 // 0x11B4
	TCD13_CITER_ELINKNO volatile.Register16 // 0x11B6
	TCD13_DLASTSGA      volatile.Register32 // 0x11B8
	TCD13_CSR           volatile.Register16 // 0x11BC
	TCD13_BITER_ELINKNO volatile.Register16 // 0x11BE
	TCD14_SADDR         volatile.Register32 // 0x11C0
	TCD14_SOFF          volatile.Register16 // 0x11C4
	TCD14_ATTR          volatile.Register16 // 0x11C6
	TCD14_NBYTES_MLNO   volatile.Register32 // 0x11C8
	TCD14_SLAST         volatile.Register32 // 0x11CC
	TCD14_DADDR         volatile.Register32 // 0x11D0
	TCD14_DOFF          volatile.Register16 // 0x11D4
	TCD14_CITER_ELINKNO volatile.Register16 // 0x11D6
	TCD14_DLASTSGA      volatile.Register32 // 0x11D8
	TCD14_CSR           volatile.Register16 // 0x11DC
	TCD14_BITER_ELINKNO volatile.Register16 // 0x11DE
	TCD15_SADDR         volatile.Register32 // 0x11E0
	TCD15_SOFF          volatile.Register16 // 0x11E4
	TCD15_ATTR          volatile.Register16 // 0x11E6
	TCD15_NBYTES_MLNO   volatile.Register32 // 0x11E8
	TCD15_SLAST         volatile.Register32 // 0x11EC
	TCD15_DADDR         volatile.Register32 // 0x11F0
	TCD15_DOFF          volatile.Register16 // 0x11F4
	TCD15_CITER_ELINKNO volatile.Register16 // 0x11F6
	TCD15_DLASTSGA      volatile.Register32 // 0x11F8
	TCD15_CSR           volatile.Register16 // 0x11FC
	TCD15_BITER_ELINKNO volatile.Register16 // 0x11FE
}

// DMA.CR: Control Register
func (o *DMA_Type) SetCR_EDBG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCR_EDBG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCR_ERCA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCR_ERCA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCR_HOE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCR_HOE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCR_HALT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCR_HALT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCR_CLM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCR_CLM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCR_EMLM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCR_EMLM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCR_ECX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetCR_ECX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetCR_CX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetCR_CX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}

// DMA.ES: Error Status Register
func (o *DMA_Type) SetES_DBE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetES_DBE() uint32 {
	return volatile.LoadUint32(&o.ES.Reg) & 0x1
}
func (o *DMA_Type) SetES_SBE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetES_SBE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetES_SGE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetES_SGE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetES_NCE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetES_NCE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetES_DOE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetES_DOE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetES_DAE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetES_DAE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetES_SOE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetES_SOE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetES_SAE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetES_SAE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetES_ERRCHN(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetES_ERRCHN() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetES_CPE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetES_CPE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetES_ECX(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetES_ECX() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetES_VLD(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x80000000)|value<<31)
}
func (o *DMA_Type) GetES_VLD() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x80000000) >> 31
}

// DMA.ERQ: Enable Request Register
func (o *DMA_Type) SetERQ_ERQ0(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetERQ_ERQ0() uint32 {
	return volatile.LoadUint32(&o.ERQ.Reg) & 0x1
}
func (o *DMA_Type) SetERQ_ERQ1(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetERQ_ERQ1() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetERQ_ERQ2(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetERQ_ERQ2() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetERQ_ERQ3(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetERQ_ERQ3() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetERQ_ERQ4(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetERQ_ERQ4() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetERQ_ERQ5(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetERQ_ERQ5() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetERQ_ERQ6(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetERQ_ERQ6() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetERQ_ERQ7(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetERQ_ERQ7() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetERQ_ERQ8(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetERQ_ERQ8() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetERQ_ERQ9(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetERQ_ERQ9() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetERQ_ERQ10(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetERQ_ERQ10() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetERQ_ERQ11(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetERQ_ERQ11() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetERQ_ERQ12(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetERQ_ERQ12() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetERQ_ERQ13(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetERQ_ERQ13() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetERQ_ERQ14(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetERQ_ERQ14() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetERQ_ERQ15(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetERQ_ERQ15() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x8000) >> 15
}

// DMA.EEI: Enable Error Interrupt Register
func (o *DMA_Type) SetEEI_EEI0(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetEEI_EEI0() uint32 {
	return volatile.LoadUint32(&o.EEI.Reg) & 0x1
}
func (o *DMA_Type) SetEEI_EEI1(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetEEI_EEI1() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetEEI_EEI2(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetEEI_EEI2() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetEEI_EEI3(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetEEI_EEI3() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetEEI_EEI4(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetEEI_EEI4() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetEEI_EEI5(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetEEI_EEI5() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetEEI_EEI6(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetEEI_EEI6() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetEEI_EEI7(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetEEI_EEI7() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetEEI_EEI8(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetEEI_EEI8() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetEEI_EEI9(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetEEI_EEI9() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetEEI_EEI10(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetEEI_EEI10() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetEEI_EEI11(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetEEI_EEI11() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetEEI_EEI12(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetEEI_EEI12() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetEEI_EEI13(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetEEI_EEI13() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetEEI_EEI14(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetEEI_EEI14() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetEEI_EEI15(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetEEI_EEI15() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x8000) >> 15
}

// DMA.CEEI: Clear Enable Error Interrupt Register
func (o *DMA_Type) SetCEEI(value uint8) {
	volatile.StoreUint8(&o.CEEI.Reg, volatile.LoadUint8(&o.CEEI.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCEEI() uint8 {
	return volatile.LoadUint8(&o.CEEI.Reg) & 0xf
}
func (o *DMA_Type) SetCEEI_CAEE(value uint8) {
	volatile.StoreUint8(&o.CEEI.Reg, volatile.LoadUint8(&o.CEEI.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCEEI_CAEE() uint8 {
	return (volatile.LoadUint8(&o.CEEI.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCEEI_NOP(value uint8) {
	volatile.StoreUint8(&o.CEEI.Reg, volatile.LoadUint8(&o.CEEI.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCEEI_NOP() uint8 {
	return (volatile.LoadUint8(&o.CEEI.Reg) & 0x80) >> 7
}

// DMA.SEEI: Set Enable Error Interrupt Register
func (o *DMA_Type) SetSEEI(value uint8) {
	volatile.StoreUint8(&o.SEEI.Reg, volatile.LoadUint8(&o.SEEI.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetSEEI() uint8 {
	return volatile.LoadUint8(&o.SEEI.Reg) & 0xf
}
func (o *DMA_Type) SetSEEI_SAEE(value uint8) {
	volatile.StoreUint8(&o.SEEI.Reg, volatile.LoadUint8(&o.SEEI.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSEEI_SAEE() uint8 {
	return (volatile.LoadUint8(&o.SEEI.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSEEI_NOP(value uint8) {
	volatile.StoreUint8(&o.SEEI.Reg, volatile.LoadUint8(&o.SEEI.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSEEI_NOP() uint8 {
	return (volatile.LoadUint8(&o.SEEI.Reg) & 0x80) >> 7
}

// DMA.CERQ: Clear Enable Request Register
func (o *DMA_Type) SetCERQ(value uint8) {
	volatile.StoreUint8(&o.CERQ.Reg, volatile.LoadUint8(&o.CERQ.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCERQ() uint8 {
	return volatile.LoadUint8(&o.CERQ.Reg) & 0xf
}
func (o *DMA_Type) SetCERQ_CAER(value uint8) {
	volatile.StoreUint8(&o.CERQ.Reg, volatile.LoadUint8(&o.CERQ.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCERQ_CAER() uint8 {
	return (volatile.LoadUint8(&o.CERQ.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCERQ_NOP(value uint8) {
	volatile.StoreUint8(&o.CERQ.Reg, volatile.LoadUint8(&o.CERQ.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCERQ_NOP() uint8 {
	return (volatile.LoadUint8(&o.CERQ.Reg) & 0x80) >> 7
}

// DMA.SERQ: Set Enable Request Register
func (o *DMA_Type) SetSERQ(value uint8) {
	volatile.StoreUint8(&o.SERQ.Reg, volatile.LoadUint8(&o.SERQ.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetSERQ() uint8 {
	return volatile.LoadUint8(&o.SERQ.Reg) & 0xf
}
func (o *DMA_Type) SetSERQ_SAER(value uint8) {
	volatile.StoreUint8(&o.SERQ.Reg, volatile.LoadUint8(&o.SERQ.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSERQ_SAER() uint8 {
	return (volatile.LoadUint8(&o.SERQ.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSERQ_NOP(value uint8) {
	volatile.StoreUint8(&o.SERQ.Reg, volatile.LoadUint8(&o.SERQ.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSERQ_NOP() uint8 {
	return (volatile.LoadUint8(&o.SERQ.Reg) & 0x80) >> 7
}

// DMA.CDNE: Clear DONE Status Bit Register
func (o *DMA_Type) SetCDNE(value uint8) {
	volatile.StoreUint8(&o.CDNE.Reg, volatile.LoadUint8(&o.CDNE.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCDNE() uint8 {
	return volatile.LoadUint8(&o.CDNE.Reg) & 0xf
}
func (o *DMA_Type) SetCDNE_CADN(value uint8) {
	volatile.StoreUint8(&o.CDNE.Reg, volatile.LoadUint8(&o.CDNE.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCDNE_CADN() uint8 {
	return (volatile.LoadUint8(&o.CDNE.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCDNE_NOP(value uint8) {
	volatile.StoreUint8(&o.CDNE.Reg, volatile.LoadUint8(&o.CDNE.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCDNE_NOP() uint8 {
	return (volatile.LoadUint8(&o.CDNE.Reg) & 0x80) >> 7
}

// DMA.SSRT: Set START Bit Register
func (o *DMA_Type) SetSSRT(value uint8) {
	volatile.StoreUint8(&o.SSRT.Reg, volatile.LoadUint8(&o.SSRT.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetSSRT() uint8 {
	return volatile.LoadUint8(&o.SSRT.Reg) & 0xf
}
func (o *DMA_Type) SetSSRT_SAST(value uint8) {
	volatile.StoreUint8(&o.SSRT.Reg, volatile.LoadUint8(&o.SSRT.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSSRT_SAST() uint8 {
	return (volatile.LoadUint8(&o.SSRT.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSSRT_NOP(value uint8) {
	volatile.StoreUint8(&o.SSRT.Reg, volatile.LoadUint8(&o.SSRT.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSSRT_NOP() uint8 {
	return (volatile.LoadUint8(&o.SSRT.Reg) & 0x80) >> 7
}

// DMA.CERR: Clear Error Register
func (o *DMA_Type) SetCERR(value uint8) {
	volatile.StoreUint8(&o.CERR.Reg, volatile.LoadUint8(&o.CERR.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCERR() uint8 {
	return volatile.LoadUint8(&o.CERR.Reg) & 0xf
}
func (o *DMA_Type) SetCERR_CAEI(value uint8) {
	volatile.StoreUint8(&o.CERR.Reg, volatile.LoadUint8(&o.CERR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCERR_CAEI() uint8 {
	return (volatile.LoadUint8(&o.CERR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCERR_NOP(value uint8) {
	volatile.StoreUint8(&o.CERR.Reg, volatile.LoadUint8(&o.CERR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCERR_NOP() uint8 {
	return (volatile.LoadUint8(&o.CERR.Reg) & 0x80) >> 7
}

// DMA.CINT: Clear Interrupt Request Register
func (o *DMA_Type) SetCINT(value uint8) {
	volatile.StoreUint8(&o.CINT.Reg, volatile.LoadUint8(&o.CINT.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCINT() uint8 {
	return volatile.LoadUint8(&o.CINT.Reg) & 0xf
}
func (o *DMA_Type) SetCINT_CAIR(value uint8) {
	volatile.StoreUint8(&o.CINT.Reg, volatile.LoadUint8(&o.CINT.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCINT_CAIR() uint8 {
	return (volatile.LoadUint8(&o.CINT.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCINT_NOP(value uint8) {
	volatile.StoreUint8(&o.CINT.Reg, volatile.LoadUint8(&o.CINT.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCINT_NOP() uint8 {
	return (volatile.LoadUint8(&o.CINT.Reg) & 0x80) >> 7
}

// DMA.INT: Interrupt Request Register
func (o *DMA_Type) SetINT_INT0(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_INT0() uint32 {
	return volatile.LoadUint32(&o.INT.Reg) & 0x1
}
func (o *DMA_Type) SetINT_INT1(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_INT1() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_INT2(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_INT2() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_INT3(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_INT3() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_INT4(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_INT4() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_INT5(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_INT5() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_INT6(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_INT6() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_INT7(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_INT7() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_INT8(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_INT8() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_INT9(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_INT9() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_INT10(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_INT10() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_INT11(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_INT11() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_INT12(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_INT12() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetINT_INT13(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetINT_INT13() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetINT_INT14(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetINT_INT14() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetINT_INT15(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetINT_INT15() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x8000) >> 15
}

// DMA.ERR: Error Register
func (o *DMA_Type) SetERR_ERR0(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetERR_ERR0() uint32 {
	return volatile.LoadUint32(&o.ERR.Reg) & 0x1
}
func (o *DMA_Type) SetERR_ERR1(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetERR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetERR_ERR2(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetERR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetERR_ERR3(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetERR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetERR_ERR4(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetERR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetERR_ERR5(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetERR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetERR_ERR6(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetERR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetERR_ERR7(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetERR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetERR_ERR8(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetERR_ERR8() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetERR_ERR9(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetERR_ERR9() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetERR_ERR10(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetERR_ERR10() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetERR_ERR11(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetERR_ERR11() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetERR_ERR12(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetERR_ERR12() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetERR_ERR13(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetERR_ERR13() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetERR_ERR14(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetERR_ERR14() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetERR_ERR15(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetERR_ERR15() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x8000) >> 15
}

// DMA.HRS: Hardware Request Status Register
func (o *DMA_Type) SetHRS_HRS0(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHRS_HRS0() uint32 {
	return volatile.LoadUint32(&o.HRS.Reg) & 0x1
}
func (o *DMA_Type) SetHRS_HRS1(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetHRS_HRS1() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetHRS_HRS2(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHRS_HRS2() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHRS_HRS3(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHRS_HRS3() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHRS_HRS4(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHRS_HRS4() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHRS_HRS5(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHRS_HRS5() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHRS_HRS6(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHRS_HRS6() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHRS_HRS7(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetHRS_HRS7() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetHRS_HRS8(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHRS_HRS8() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHRS_HRS9(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHRS_HRS9() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHRS_HRS10(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHRS_HRS10() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHRS_HRS11(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHRS_HRS11() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHRS_HRS12(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetHRS_HRS12() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetHRS_HRS13(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetHRS_HRS13() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetHRS_HRS14(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetHRS_HRS14() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetHRS_HRS15(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetHRS_HRS15() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x8000) >> 15
}

// DMA.EARS: Enable Asynchronous Request in Stop Register
func (o *DMA_Type) SetEARS_EDREQ_0(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetEARS_EDREQ_0() uint32 {
	return volatile.LoadUint32(&o.EARS.Reg) & 0x1
}
func (o *DMA_Type) SetEARS_EDREQ_1(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetEARS_EDREQ_1() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetEARS_EDREQ_2(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetEARS_EDREQ_2() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetEARS_EDREQ_3(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetEARS_EDREQ_3() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetEARS_EDREQ_4(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetEARS_EDREQ_4() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetEARS_EDREQ_5(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetEARS_EDREQ_5() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetEARS_EDREQ_6(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetEARS_EDREQ_6() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetEARS_EDREQ_7(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetEARS_EDREQ_7() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetEARS_EDREQ_8(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetEARS_EDREQ_8() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetEARS_EDREQ_9(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetEARS_EDREQ_9() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetEARS_EDREQ_10(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetEARS_EDREQ_10() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetEARS_EDREQ_11(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetEARS_EDREQ_11() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetEARS_EDREQ_12(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetEARS_EDREQ_12() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetEARS_EDREQ_13(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetEARS_EDREQ_13() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetEARS_EDREQ_14(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetEARS_EDREQ_14() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetEARS_EDREQ_15(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetEARS_EDREQ_15() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x8000) >> 15
}

// DMA.DCHPRI3: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI3_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI3.Reg, volatile.LoadUint8(&o.DCHPRI3.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI3_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI3.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI3_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI3.Reg, volatile.LoadUint8(&o.DCHPRI3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI3_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI3_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI3.Reg, volatile.LoadUint8(&o.DCHPRI3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI3_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI3.Reg) & 0x80) >> 7
}

// DMA.DCHPRI2: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI2_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI2.Reg, volatile.LoadUint8(&o.DCHPRI2.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI2_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI2.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI2_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI2.Reg, volatile.LoadUint8(&o.DCHPRI2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI2_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI2_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI2.Reg, volatile.LoadUint8(&o.DCHPRI2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI2_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI2.Reg) & 0x80) >> 7
}

// DMA.DCHPRI1: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI1_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI1.Reg, volatile.LoadUint8(&o.DCHPRI1.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI1_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI1.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI1_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI1.Reg, volatile.LoadUint8(&o.DCHPRI1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI1_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI1_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI1.Reg, volatile.LoadUint8(&o.DCHPRI1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI1_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI1.Reg) & 0x80) >> 7
}

// DMA.DCHPRI0: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI0_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI0.Reg, volatile.LoadUint8(&o.DCHPRI0.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI0_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI0.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI0_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI0.Reg, volatile.LoadUint8(&o.DCHPRI0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI0_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI0_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI0.Reg, volatile.LoadUint8(&o.DCHPRI0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI0_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI0.Reg) & 0x80) >> 7
}

// DMA.DCHPRI7: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI7_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI7.Reg, volatile.LoadUint8(&o.DCHPRI7.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI7_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI7.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI7_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI7.Reg, volatile.LoadUint8(&o.DCHPRI7.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI7_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI7.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI7_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI7.Reg, volatile.LoadUint8(&o.DCHPRI7.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI7_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI7.Reg) & 0x80) >> 7
}

// DMA.DCHPRI6: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI6_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI6.Reg, volatile.LoadUint8(&o.DCHPRI6.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI6_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI6.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI6_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI6.Reg, volatile.LoadUint8(&o.DCHPRI6.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI6_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI6.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI6_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI6.Reg, volatile.LoadUint8(&o.DCHPRI6.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI6_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI6.Reg) & 0x80) >> 7
}

// DMA.DCHPRI5: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI5_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI5.Reg, volatile.LoadUint8(&o.DCHPRI5.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI5_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI5.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI5_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI5.Reg, volatile.LoadUint8(&o.DCHPRI5.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI5_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI5.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI5_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI5.Reg, volatile.LoadUint8(&o.DCHPRI5.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI5_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI5.Reg) & 0x80) >> 7
}

// DMA.DCHPRI4: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI4_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI4.Reg, volatile.LoadUint8(&o.DCHPRI4.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI4_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI4.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI4_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI4.Reg, volatile.LoadUint8(&o.DCHPRI4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI4_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI4_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI4.Reg, volatile.LoadUint8(&o.DCHPRI4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI4_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI4.Reg) & 0x80) >> 7
}

// DMA.DCHPRI11: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI11_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI11.Reg, volatile.LoadUint8(&o.DCHPRI11.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI11_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI11.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI11_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI11.Reg, volatile.LoadUint8(&o.DCHPRI11.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI11_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI11.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI11_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI11.Reg, volatile.LoadUint8(&o.DCHPRI11.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI11_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI11.Reg) & 0x80) >> 7
}

// DMA.DCHPRI10: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI10_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI10.Reg, volatile.LoadUint8(&o.DCHPRI10.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI10_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI10.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI10_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI10.Reg, volatile.LoadUint8(&o.DCHPRI10.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI10_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI10.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI10_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI10.Reg, volatile.LoadUint8(&o.DCHPRI10.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI10_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI10.Reg) & 0x80) >> 7
}

// DMA.DCHPRI9: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI9_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI9.Reg, volatile.LoadUint8(&o.DCHPRI9.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI9_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI9.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI9_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI9.Reg, volatile.LoadUint8(&o.DCHPRI9.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI9_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI9.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI9_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI9.Reg, volatile.LoadUint8(&o.DCHPRI9.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI9_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI9.Reg) & 0x80) >> 7
}

// DMA.DCHPRI8: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI8_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI8.Reg, volatile.LoadUint8(&o.DCHPRI8.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI8_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI8.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI8_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI8.Reg, volatile.LoadUint8(&o.DCHPRI8.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI8_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI8.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI8_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI8.Reg, volatile.LoadUint8(&o.DCHPRI8.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI8_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI8.Reg) & 0x80) >> 7
}

// DMA.DCHPRI15: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI15_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI15.Reg, volatile.LoadUint8(&o.DCHPRI15.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI15_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI15.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI15_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI15.Reg, volatile.LoadUint8(&o.DCHPRI15.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI15_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI15.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI15_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI15.Reg, volatile.LoadUint8(&o.DCHPRI15.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI15_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI15.Reg) & 0x80) >> 7
}

// DMA.DCHPRI14: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI14_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI14.Reg, volatile.LoadUint8(&o.DCHPRI14.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI14_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI14.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI14_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI14.Reg, volatile.LoadUint8(&o.DCHPRI14.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI14_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI14.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI14_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI14.Reg, volatile.LoadUint8(&o.DCHPRI14.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI14_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI14.Reg) & 0x80) >> 7
}

// DMA.DCHPRI13: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI13_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI13.Reg, volatile.LoadUint8(&o.DCHPRI13.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI13_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI13.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI13_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI13.Reg, volatile.LoadUint8(&o.DCHPRI13.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI13_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI13.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI13_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI13.Reg, volatile.LoadUint8(&o.DCHPRI13.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI13_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI13.Reg) & 0x80) >> 7
}

// DMA.DCHPRI12: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI12_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI12.Reg, volatile.LoadUint8(&o.DCHPRI12.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI12_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI12.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI12_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI12.Reg, volatile.LoadUint8(&o.DCHPRI12.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI12_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI12.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI12_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI12.Reg, volatile.LoadUint8(&o.DCHPRI12.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI12_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI12.Reg) & 0x80) >> 7
}

// DMA.TCD0_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD0_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD0_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD0_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD0_SADDR.Reg)
}

// DMA.TCD0_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD0_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD0_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD0_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD0_SOFF.Reg)
}

// DMA.TCD0_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD0_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD0_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD0_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD0_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD0_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD0_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD0_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD0_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD0_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD0_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD0_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD0_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD0_NBYTES_MLNO.Reg)
}

// DMA.TCD0_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD0_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD0_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD0_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD0_SLAST.Reg)
}

// DMA.TCD0_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD0_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD0_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD0_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD0_DADDR.Reg)
}

// DMA.TCD0_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD0_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD0_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD0_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD0_DOFF.Reg)
}

// DMA.TCD0_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD0_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD0_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD0_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD0_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD0_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD0_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD0_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD0_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD0_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD0_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD0_DLASTSGA.Reg)
}

// DMA.TCD0_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD0_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD0_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD0_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD0_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD0_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD0_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD0_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD0_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD0_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD0_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD0_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD0_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD0_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD0_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD0_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD0_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD0_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD0_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD0_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD0_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD0_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD0_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD0_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD0_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD0_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD0_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD0_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD1_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD1_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD1_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD1_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD1_SADDR.Reg)
}

// DMA.TCD1_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD1_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD1_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD1_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD1_SOFF.Reg)
}

// DMA.TCD1_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD1_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD1_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD1_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD1_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD1_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD1_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD1_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD1_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD1_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD1_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD1_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD1_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD1_NBYTES_MLNO.Reg)
}

// DMA.TCD1_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD1_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD1_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD1_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD1_SLAST.Reg)
}

// DMA.TCD1_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD1_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD1_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD1_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD1_DADDR.Reg)
}

// DMA.TCD1_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD1_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD1_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD1_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD1_DOFF.Reg)
}

// DMA.TCD1_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD1_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD1_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD1_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD1_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD1_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD1_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD1_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD1_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD1_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD1_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD1_DLASTSGA.Reg)
}

// DMA.TCD1_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD1_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD1_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD1_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD1_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD1_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD1_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD1_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD1_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD1_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD1_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD1_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD1_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD1_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD1_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD1_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD1_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD1_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD1_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD1_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD1_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD1_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD1_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD1_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD1_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD1_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD1_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD1_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD2_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD2_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD2_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD2_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD2_SADDR.Reg)
}

// DMA.TCD2_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD2_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD2_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD2_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD2_SOFF.Reg)
}

// DMA.TCD2_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD2_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD2_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD2_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD2_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD2_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD2_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD2_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD2_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD2_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD2_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD2_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD2_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD2_NBYTES_MLNO.Reg)
}

// DMA.TCD2_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD2_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD2_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD2_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD2_SLAST.Reg)
}

// DMA.TCD2_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD2_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD2_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD2_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD2_DADDR.Reg)
}

// DMA.TCD2_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD2_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD2_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD2_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD2_DOFF.Reg)
}

// DMA.TCD2_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD2_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD2_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD2_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD2_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD2_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD2_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD2_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD2_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD2_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD2_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD2_DLASTSGA.Reg)
}

// DMA.TCD2_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD2_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD2_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD2_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD2_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD2_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD2_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD2_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD2_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD2_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD2_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD2_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD2_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD2_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD2_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD2_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD2_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD2_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD2_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD2_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD2_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD2_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD2_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD2_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD2_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD2_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD2_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD2_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD3_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD3_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD3_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD3_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD3_SADDR.Reg)
}

// DMA.TCD3_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD3_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD3_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD3_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD3_SOFF.Reg)
}

// DMA.TCD3_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD3_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD3_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD3_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD3_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD3_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD3_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD3_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD3_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD3_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD3_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD3_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD3_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD3_NBYTES_MLNO.Reg)
}

// DMA.TCD3_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD3_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD3_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD3_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD3_SLAST.Reg)
}

// DMA.TCD3_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD3_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD3_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD3_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD3_DADDR.Reg)
}

// DMA.TCD3_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD3_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD3_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD3_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD3_DOFF.Reg)
}

// DMA.TCD3_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD3_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD3_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD3_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD3_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD3_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD3_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD3_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD3_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD3_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD3_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD3_DLASTSGA.Reg)
}

// DMA.TCD3_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD3_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD3_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD3_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD3_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD3_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD3_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD3_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD3_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD3_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD3_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD3_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD3_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD3_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD3_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD3_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD3_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD3_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD3_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD3_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD3_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD3_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD3_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD3_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD3_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD3_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD3_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD3_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD4_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD4_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD4_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD4_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD4_SADDR.Reg)
}

// DMA.TCD4_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD4_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD4_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD4_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD4_SOFF.Reg)
}

// DMA.TCD4_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD4_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD4_ATTR.Reg, volatile.LoadUint16(&o.TCD4_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD4_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD4_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD4_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD4_ATTR.Reg, volatile.LoadUint16(&o.TCD4_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD4_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD4_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD4_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD4_ATTR.Reg, volatile.LoadUint16(&o.TCD4_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD4_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD4_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD4_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD4_ATTR.Reg, volatile.LoadUint16(&o.TCD4_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD4_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD4_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD4_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD4_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD4_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD4_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD4_NBYTES_MLNO.Reg)
}

// DMA.TCD4_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD4_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD4_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD4_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD4_SLAST.Reg)
}

// DMA.TCD4_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD4_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD4_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD4_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD4_DADDR.Reg)
}

// DMA.TCD4_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD4_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD4_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD4_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD4_DOFF.Reg)
}

// DMA.TCD4_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD4_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD4_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD4_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD4_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD4_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD4_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD4_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD4_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD4_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD4_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD4_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD4_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD4_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD4_DLASTSGA.Reg)
}

// DMA.TCD4_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD4_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD4_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD4_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD4_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD4_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD4_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD4_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD4_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD4_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD4_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD4_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD4_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD4_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD4_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD4_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD4_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD4_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD4_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD4_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD4_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD4_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD4_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD4_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD4_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD4_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD4_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD4_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD4_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD4_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD4_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD4_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD5_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD5_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD5_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD5_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD5_SADDR.Reg)
}

// DMA.TCD5_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD5_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD5_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD5_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD5_SOFF.Reg)
}

// DMA.TCD5_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD5_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD5_ATTR.Reg, volatile.LoadUint16(&o.TCD5_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD5_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD5_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD5_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD5_ATTR.Reg, volatile.LoadUint16(&o.TCD5_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD5_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD5_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD5_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD5_ATTR.Reg, volatile.LoadUint16(&o.TCD5_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD5_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD5_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD5_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD5_ATTR.Reg, volatile.LoadUint16(&o.TCD5_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD5_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD5_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD5_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD5_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD5_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD5_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD5_NBYTES_MLNO.Reg)
}

// DMA.TCD5_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD5_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD5_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD5_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD5_SLAST.Reg)
}

// DMA.TCD5_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD5_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD5_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD5_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD5_DADDR.Reg)
}

// DMA.TCD5_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD5_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD5_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD5_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD5_DOFF.Reg)
}

// DMA.TCD5_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD5_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD5_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD5_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD5_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD5_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD5_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD5_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD5_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD5_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD5_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD5_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD5_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD5_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD5_DLASTSGA.Reg)
}

// DMA.TCD5_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD5_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD5_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD5_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD5_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD5_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD5_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD5_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD5_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD5_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD5_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD5_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD5_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD5_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD5_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD5_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD5_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD5_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD5_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD5_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD5_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD5_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD5_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD5_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD5_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD5_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD5_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD5_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD5_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD5_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD5_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD5_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD6_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD6_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD6_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD6_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD6_SADDR.Reg)
}

// DMA.TCD6_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD6_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD6_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD6_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD6_SOFF.Reg)
}

// DMA.TCD6_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD6_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD6_ATTR.Reg, volatile.LoadUint16(&o.TCD6_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD6_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD6_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD6_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD6_ATTR.Reg, volatile.LoadUint16(&o.TCD6_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD6_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD6_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD6_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD6_ATTR.Reg, volatile.LoadUint16(&o.TCD6_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD6_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD6_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD6_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD6_ATTR.Reg, volatile.LoadUint16(&o.TCD6_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD6_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD6_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD6_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD6_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD6_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD6_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD6_NBYTES_MLNO.Reg)
}

// DMA.TCD6_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD6_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD6_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD6_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD6_SLAST.Reg)
}

// DMA.TCD6_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD6_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD6_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD6_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD6_DADDR.Reg)
}

// DMA.TCD6_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD6_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD6_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD6_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD6_DOFF.Reg)
}

// DMA.TCD6_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD6_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD6_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD6_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD6_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD6_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD6_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD6_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD6_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD6_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD6_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD6_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD6_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD6_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD6_DLASTSGA.Reg)
}

// DMA.TCD6_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD6_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD6_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD6_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD6_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD6_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD6_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD6_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD6_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD6_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD6_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD6_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD6_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD6_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD6_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD6_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD6_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD6_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD6_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD6_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD6_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD6_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD6_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD6_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD6_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD6_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD6_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD6_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD6_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD6_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD6_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD6_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD7_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD7_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD7_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD7_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD7_SADDR.Reg)
}

// DMA.TCD7_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD7_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD7_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD7_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD7_SOFF.Reg)
}

// DMA.TCD7_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD7_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD7_ATTR.Reg, volatile.LoadUint16(&o.TCD7_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD7_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD7_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD7_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD7_ATTR.Reg, volatile.LoadUint16(&o.TCD7_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD7_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD7_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD7_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD7_ATTR.Reg, volatile.LoadUint16(&o.TCD7_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD7_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD7_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD7_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD7_ATTR.Reg, volatile.LoadUint16(&o.TCD7_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD7_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD7_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD7_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD7_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD7_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD7_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD7_NBYTES_MLNO.Reg)
}

// DMA.TCD7_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD7_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD7_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD7_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD7_SLAST.Reg)
}

// DMA.TCD7_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD7_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD7_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD7_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD7_DADDR.Reg)
}

// DMA.TCD7_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD7_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD7_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD7_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD7_DOFF.Reg)
}

// DMA.TCD7_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD7_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD7_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD7_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD7_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD7_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD7_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD7_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD7_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD7_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD7_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD7_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD7_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD7_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD7_DLASTSGA.Reg)
}

// DMA.TCD7_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD7_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD7_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD7_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD7_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD7_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD7_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD7_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD7_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD7_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD7_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD7_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD7_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD7_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD7_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD7_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD7_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD7_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD7_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD7_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD7_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD7_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD7_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD7_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD7_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD7_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD7_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD7_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD7_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD7_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD7_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD7_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD8_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD8_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD8_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD8_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD8_SADDR.Reg)
}

// DMA.TCD8_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD8_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD8_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD8_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD8_SOFF.Reg)
}

// DMA.TCD8_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD8_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD8_ATTR.Reg, volatile.LoadUint16(&o.TCD8_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD8_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD8_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD8_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD8_ATTR.Reg, volatile.LoadUint16(&o.TCD8_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD8_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD8_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD8_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD8_ATTR.Reg, volatile.LoadUint16(&o.TCD8_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD8_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD8_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD8_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD8_ATTR.Reg, volatile.LoadUint16(&o.TCD8_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD8_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD8_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD8_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD8_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD8_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD8_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD8_NBYTES_MLNO.Reg)
}

// DMA.TCD8_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD8_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD8_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD8_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD8_SLAST.Reg)
}

// DMA.TCD8_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD8_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD8_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD8_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD8_DADDR.Reg)
}

// DMA.TCD8_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD8_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD8_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD8_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD8_DOFF.Reg)
}

// DMA.TCD8_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD8_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD8_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD8_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD8_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD8_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD8_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD8_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD8_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD8_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD8_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD8_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD8_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD8_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD8_DLASTSGA.Reg)
}

// DMA.TCD8_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD8_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD8_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD8_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD8_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD8_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD8_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD8_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD8_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD8_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD8_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD8_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD8_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD8_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD8_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD8_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD8_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD8_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD8_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD8_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD8_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD8_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD8_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD8_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD8_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD8_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD8_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD8_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD8_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD8_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD8_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD8_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD9_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD9_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD9_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD9_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD9_SADDR.Reg)
}

// DMA.TCD9_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD9_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD9_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD9_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD9_SOFF.Reg)
}

// DMA.TCD9_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD9_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD9_ATTR.Reg, volatile.LoadUint16(&o.TCD9_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD9_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD9_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD9_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD9_ATTR.Reg, volatile.LoadUint16(&o.TCD9_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD9_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD9_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD9_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD9_ATTR.Reg, volatile.LoadUint16(&o.TCD9_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD9_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD9_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD9_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD9_ATTR.Reg, volatile.LoadUint16(&o.TCD9_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD9_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD9_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD9_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD9_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD9_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD9_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD9_NBYTES_MLNO.Reg)
}

// DMA.TCD9_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD9_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD9_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD9_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD9_SLAST.Reg)
}

// DMA.TCD9_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD9_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD9_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD9_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD9_DADDR.Reg)
}

// DMA.TCD9_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD9_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD9_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD9_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD9_DOFF.Reg)
}

// DMA.TCD9_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD9_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD9_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD9_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD9_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD9_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD9_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD9_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD9_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD9_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD9_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD9_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD9_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD9_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD9_DLASTSGA.Reg)
}

// DMA.TCD9_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD9_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD9_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD9_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD9_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD9_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD9_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD9_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD9_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD9_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD9_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD9_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD9_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD9_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD9_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD9_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD9_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD9_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD9_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD9_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD9_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD9_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD9_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD9_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD9_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD9_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD9_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD9_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD9_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD9_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD9_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD9_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD10_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD10_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD10_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD10_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD10_SADDR.Reg)
}

// DMA.TCD10_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD10_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD10_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD10_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD10_SOFF.Reg)
}

// DMA.TCD10_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD10_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD10_ATTR.Reg, volatile.LoadUint16(&o.TCD10_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD10_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD10_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD10_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD10_ATTR.Reg, volatile.LoadUint16(&o.TCD10_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD10_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD10_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD10_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD10_ATTR.Reg, volatile.LoadUint16(&o.TCD10_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD10_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD10_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD10_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD10_ATTR.Reg, volatile.LoadUint16(&o.TCD10_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD10_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD10_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD10_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD10_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD10_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD10_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD10_NBYTES_MLNO.Reg)
}

// DMA.TCD10_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD10_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD10_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD10_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD10_SLAST.Reg)
}

// DMA.TCD10_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD10_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD10_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD10_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD10_DADDR.Reg)
}

// DMA.TCD10_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD10_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD10_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD10_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD10_DOFF.Reg)
}

// DMA.TCD10_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD10_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD10_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD10_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD10_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD10_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD10_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD10_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD10_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD10_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD10_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD10_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD10_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD10_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD10_DLASTSGA.Reg)
}

// DMA.TCD10_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD10_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD10_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD10_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD10_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD10_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD10_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD10_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD10_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD10_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD10_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD10_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD10_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD10_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD10_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD10_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD10_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD10_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD10_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD10_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD10_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD10_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD10_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD10_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD10_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD10_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD10_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD10_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD10_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD10_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD10_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD10_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD11_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD11_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD11_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD11_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD11_SADDR.Reg)
}

// DMA.TCD11_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD11_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD11_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD11_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD11_SOFF.Reg)
}

// DMA.TCD11_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD11_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD11_ATTR.Reg, volatile.LoadUint16(&o.TCD11_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD11_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD11_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD11_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD11_ATTR.Reg, volatile.LoadUint16(&o.TCD11_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD11_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD11_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD11_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD11_ATTR.Reg, volatile.LoadUint16(&o.TCD11_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD11_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD11_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD11_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD11_ATTR.Reg, volatile.LoadUint16(&o.TCD11_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD11_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD11_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD11_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD11_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD11_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD11_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD11_NBYTES_MLNO.Reg)
}

// DMA.TCD11_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD11_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD11_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD11_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD11_SLAST.Reg)
}

// DMA.TCD11_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD11_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD11_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD11_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD11_DADDR.Reg)
}

// DMA.TCD11_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD11_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD11_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD11_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD11_DOFF.Reg)
}

// DMA.TCD11_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD11_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD11_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD11_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD11_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD11_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD11_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD11_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD11_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD11_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD11_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD11_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD11_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD11_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD11_DLASTSGA.Reg)
}

// DMA.TCD11_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD11_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD11_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD11_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD11_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD11_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD11_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD11_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD11_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD11_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD11_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD11_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD11_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD11_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD11_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD11_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD11_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD11_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD11_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD11_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD11_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD11_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD11_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD11_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD11_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD11_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD11_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD11_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD11_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD11_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD11_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD11_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD12_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD12_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD12_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD12_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD12_SADDR.Reg)
}

// DMA.TCD12_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD12_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD12_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD12_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD12_SOFF.Reg)
}

// DMA.TCD12_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD12_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD12_ATTR.Reg, volatile.LoadUint16(&o.TCD12_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD12_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD12_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD12_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD12_ATTR.Reg, volatile.LoadUint16(&o.TCD12_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD12_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD12_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD12_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD12_ATTR.Reg, volatile.LoadUint16(&o.TCD12_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD12_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD12_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD12_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD12_ATTR.Reg, volatile.LoadUint16(&o.TCD12_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD12_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD12_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD12_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD12_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD12_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD12_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD12_NBYTES_MLNO.Reg)
}

// DMA.TCD12_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD12_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD12_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD12_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD12_SLAST.Reg)
}

// DMA.TCD12_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD12_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD12_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD12_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD12_DADDR.Reg)
}

// DMA.TCD12_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD12_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD12_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD12_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD12_DOFF.Reg)
}

// DMA.TCD12_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD12_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD12_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD12_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD12_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD12_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD12_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD12_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD12_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD12_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD12_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD12_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD12_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD12_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD12_DLASTSGA.Reg)
}

// DMA.TCD12_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD12_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD12_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD12_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD12_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD12_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD12_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD12_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD12_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD12_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD12_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD12_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD12_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD12_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD12_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD12_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD12_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD12_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD12_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD12_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD12_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD12_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD12_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD12_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD12_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD12_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD12_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD12_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD12_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD12_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD12_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD12_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD13_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD13_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD13_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD13_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD13_SADDR.Reg)
}

// DMA.TCD13_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD13_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD13_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD13_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD13_SOFF.Reg)
}

// DMA.TCD13_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD13_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD13_ATTR.Reg, volatile.LoadUint16(&o.TCD13_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD13_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD13_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD13_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD13_ATTR.Reg, volatile.LoadUint16(&o.TCD13_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD13_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD13_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD13_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD13_ATTR.Reg, volatile.LoadUint16(&o.TCD13_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD13_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD13_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD13_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD13_ATTR.Reg, volatile.LoadUint16(&o.TCD13_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD13_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD13_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD13_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD13_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD13_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD13_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD13_NBYTES_MLNO.Reg)
}

// DMA.TCD13_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD13_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD13_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD13_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD13_SLAST.Reg)
}

// DMA.TCD13_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD13_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD13_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD13_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD13_DADDR.Reg)
}

// DMA.TCD13_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD13_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD13_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD13_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD13_DOFF.Reg)
}

// DMA.TCD13_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD13_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD13_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD13_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD13_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD13_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD13_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD13_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD13_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD13_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD13_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD13_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD13_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD13_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD13_DLASTSGA.Reg)
}

// DMA.TCD13_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD13_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD13_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD13_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD13_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD13_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD13_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD13_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD13_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD13_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD13_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD13_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD13_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD13_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD13_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD13_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD13_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD13_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD13_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD13_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD13_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD13_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD13_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD13_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD13_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD13_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD13_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD13_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD13_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD13_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD13_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD13_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD14_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD14_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD14_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD14_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD14_SADDR.Reg)
}

// DMA.TCD14_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD14_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD14_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD14_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD14_SOFF.Reg)
}

// DMA.TCD14_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD14_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD14_ATTR.Reg, volatile.LoadUint16(&o.TCD14_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD14_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD14_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD14_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD14_ATTR.Reg, volatile.LoadUint16(&o.TCD14_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD14_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD14_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD14_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD14_ATTR.Reg, volatile.LoadUint16(&o.TCD14_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD14_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD14_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD14_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD14_ATTR.Reg, volatile.LoadUint16(&o.TCD14_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD14_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD14_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD14_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD14_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD14_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD14_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD14_NBYTES_MLNO.Reg)
}

// DMA.TCD14_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD14_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD14_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD14_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD14_SLAST.Reg)
}

// DMA.TCD14_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD14_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD14_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD14_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD14_DADDR.Reg)
}

// DMA.TCD14_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD14_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD14_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD14_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD14_DOFF.Reg)
}

// DMA.TCD14_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD14_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD14_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD14_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD14_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD14_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD14_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD14_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD14_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD14_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD14_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD14_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD14_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD14_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD14_DLASTSGA.Reg)
}

// DMA.TCD14_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD14_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD14_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD14_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD14_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD14_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD14_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD14_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD14_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD14_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD14_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD14_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD14_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD14_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD14_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD14_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD14_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD14_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD14_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD14_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD14_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD14_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD14_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD14_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD14_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD14_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD14_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD14_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD14_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD14_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD14_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD14_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD15_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD15_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD15_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD15_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD15_SADDR.Reg)
}

// DMA.TCD15_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD15_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD15_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD15_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD15_SOFF.Reg)
}

// DMA.TCD15_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD15_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD15_ATTR.Reg, volatile.LoadUint16(&o.TCD15_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD15_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD15_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD15_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD15_ATTR.Reg, volatile.LoadUint16(&o.TCD15_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD15_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD15_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD15_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD15_ATTR.Reg, volatile.LoadUint16(&o.TCD15_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD15_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD15_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD15_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD15_ATTR.Reg, volatile.LoadUint16(&o.TCD15_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD15_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD15_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD15_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD15_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD15_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD15_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD15_NBYTES_MLNO.Reg)
}

// DMA.TCD15_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD15_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD15_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD15_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD15_SLAST.Reg)
}

// DMA.TCD15_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD15_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD15_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD15_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD15_DADDR.Reg)
}

// DMA.TCD15_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD15_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD15_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD15_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD15_DOFF.Reg)
}

// DMA.TCD15_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD15_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD15_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD15_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD15_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD15_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD15_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD15_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD15_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD15_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD15_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD15_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD15_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD15_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD15_DLASTSGA.Reg)
}

// DMA.TCD15_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD15_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD15_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD15_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD15_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD15_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD15_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD15_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD15_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD15_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD15_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD15_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD15_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD15_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD15_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD15_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD15_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD15_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD15_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD15_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD15_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD15_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD15_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD15_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD15_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD15_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD15_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD15_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD15_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD15_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD15_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD15_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// FlexBus external bus interface
type FB_Type struct {
	CSAR0  volatile.Register32 // 0x0
	CSMR0  volatile.Register32 // 0x4
	CSCR0  volatile.Register32 // 0x8
	CSAR1  volatile.Register32 // 0xC
	CSMR1  volatile.Register32 // 0x10
	CSCR1  volatile.Register32 // 0x14
	CSAR2  volatile.Register32 // 0x18
	CSMR2  volatile.Register32 // 0x1C
	CSCR2  volatile.Register32 // 0x20
	CSAR3  volatile.Register32 // 0x24
	CSMR3  volatile.Register32 // 0x28
	CSCR3  volatile.Register32 // 0x2C
	CSAR4  volatile.Register32 // 0x30
	CSMR4  volatile.Register32 // 0x34
	CSCR4  volatile.Register32 // 0x38
	CSAR5  volatile.Register32 // 0x3C
	CSMR5  volatile.Register32 // 0x40
	CSCR5  volatile.Register32 // 0x44
	_      [24]byte
	CSPMCR volatile.Register32 // 0x60
}

// FB.CSAR0: Chip Select Address Register
func (o *FB_Type) SetCSAR0_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR0.Reg, volatile.LoadUint32(&o.CSAR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR0_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR0.Reg) & 0xffff0000) >> 16
}

// FB.CSMR0: Chip Select Mask Register
func (o *FB_Type) SetCSMR0_V(value uint32) {
	volatile.StoreUint32(&o.CSMR0.Reg, volatile.LoadUint32(&o.CSMR0.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR0_V() uint32 {
	return volatile.LoadUint32(&o.CSMR0.Reg) & 0x1
}
func (o *FB_Type) SetCSMR0_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR0.Reg, volatile.LoadUint32(&o.CSMR0.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR0_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR0.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR0_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR0.Reg, volatile.LoadUint32(&o.CSMR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR0_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR0.Reg) & 0xffff0000) >> 16
}

// FB.CSCR0: Chip Select Control Register
func (o *FB_Type) SetCSCR0_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR0_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR0_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR0_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR0_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR0_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR0_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR0_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR0_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR0_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR0_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR0_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR0_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR0_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR0_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR0_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR0_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR0_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR0_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR0_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR0_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR0_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR0_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR0_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR0_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR0_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0xfc000000) >> 26
}

// FB.CSAR1: Chip Select Address Register
func (o *FB_Type) SetCSAR1_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR1.Reg, volatile.LoadUint32(&o.CSAR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR1_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR1.Reg) & 0xffff0000) >> 16
}

// FB.CSMR1: Chip Select Mask Register
func (o *FB_Type) SetCSMR1_V(value uint32) {
	volatile.StoreUint32(&o.CSMR1.Reg, volatile.LoadUint32(&o.CSMR1.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR1_V() uint32 {
	return volatile.LoadUint32(&o.CSMR1.Reg) & 0x1
}
func (o *FB_Type) SetCSMR1_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR1.Reg, volatile.LoadUint32(&o.CSMR1.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR1_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR1.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR1_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR1.Reg, volatile.LoadUint32(&o.CSMR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR1_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR1.Reg) & 0xffff0000) >> 16
}

// FB.CSCR1: Chip Select Control Register
func (o *FB_Type) SetCSCR1_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR1_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR1_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR1_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR1_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR1_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR1_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR1_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR1_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR1_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR1_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR1_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR1_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR1_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR1_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR1_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR1_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR1_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR1_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR1_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR1_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR1_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR1_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR1_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0xfc000000) >> 26
}

// FB.CSAR2: Chip Select Address Register
func (o *FB_Type) SetCSAR2_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR2.Reg, volatile.LoadUint32(&o.CSAR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR2_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR2.Reg) & 0xffff0000) >> 16
}

// FB.CSMR2: Chip Select Mask Register
func (o *FB_Type) SetCSMR2_V(value uint32) {
	volatile.StoreUint32(&o.CSMR2.Reg, volatile.LoadUint32(&o.CSMR2.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR2_V() uint32 {
	return volatile.LoadUint32(&o.CSMR2.Reg) & 0x1
}
func (o *FB_Type) SetCSMR2_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR2.Reg, volatile.LoadUint32(&o.CSMR2.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR2_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR2.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR2_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR2.Reg, volatile.LoadUint32(&o.CSMR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR2_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR2.Reg) & 0xffff0000) >> 16
}

// FB.CSCR2: Chip Select Control Register
func (o *FB_Type) SetCSCR2_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR2_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR2_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR2_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR2_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR2_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR2_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR2_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR2_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR2_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR2_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR2_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR2_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR2_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR2_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR2_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR2_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR2_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR2_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR2_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR2_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR2_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR2_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR2_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR2_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR2_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0xfc000000) >> 26
}

// FB.CSAR3: Chip Select Address Register
func (o *FB_Type) SetCSAR3_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR3.Reg, volatile.LoadUint32(&o.CSAR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR3_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR3.Reg) & 0xffff0000) >> 16
}

// FB.CSMR3: Chip Select Mask Register
func (o *FB_Type) SetCSMR3_V(value uint32) {
	volatile.StoreUint32(&o.CSMR3.Reg, volatile.LoadUint32(&o.CSMR3.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR3_V() uint32 {
	return volatile.LoadUint32(&o.CSMR3.Reg) & 0x1
}
func (o *FB_Type) SetCSMR3_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR3.Reg, volatile.LoadUint32(&o.CSMR3.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR3_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR3.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR3_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR3.Reg, volatile.LoadUint32(&o.CSMR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR3_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR3.Reg) & 0xffff0000) >> 16
}

// FB.CSCR3: Chip Select Control Register
func (o *FB_Type) SetCSCR3_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR3_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR3_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR3_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR3_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR3_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR3_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR3_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR3_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR3_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR3_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR3_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR3_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR3_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR3_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR3_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR3_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR3_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR3_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR3_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR3_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR3_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR3_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR3_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR3_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR3_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0xfc000000) >> 26
}

// FB.CSAR4: Chip Select Address Register
func (o *FB_Type) SetCSAR4_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR4.Reg, volatile.LoadUint32(&o.CSAR4.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR4_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR4.Reg) & 0xffff0000) >> 16
}

// FB.CSMR4: Chip Select Mask Register
func (o *FB_Type) SetCSMR4_V(value uint32) {
	volatile.StoreUint32(&o.CSMR4.Reg, volatile.LoadUint32(&o.CSMR4.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR4_V() uint32 {
	return volatile.LoadUint32(&o.CSMR4.Reg) & 0x1
}
func (o *FB_Type) SetCSMR4_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR4.Reg, volatile.LoadUint32(&o.CSMR4.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR4_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR4.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR4_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR4.Reg, volatile.LoadUint32(&o.CSMR4.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR4_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR4.Reg) & 0xffff0000) >> 16
}

// FB.CSCR4: Chip Select Control Register
func (o *FB_Type) SetCSCR4_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR4_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR4_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR4_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR4_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR4_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR4_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR4_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR4_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR4_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR4_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR4_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR4_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR4_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR4_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR4_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR4_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR4_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR4_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR4_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR4_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR4_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR4_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR4_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR4_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR4_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0xfc000000) >> 26
}

// FB.CSAR5: Chip Select Address Register
func (o *FB_Type) SetCSAR5_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR5.Reg, volatile.LoadUint32(&o.CSAR5.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR5_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR5.Reg) & 0xffff0000) >> 16
}

// FB.CSMR5: Chip Select Mask Register
func (o *FB_Type) SetCSMR5_V(value uint32) {
	volatile.StoreUint32(&o.CSMR5.Reg, volatile.LoadUint32(&o.CSMR5.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR5_V() uint32 {
	return volatile.LoadUint32(&o.CSMR5.Reg) & 0x1
}
func (o *FB_Type) SetCSMR5_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR5.Reg, volatile.LoadUint32(&o.CSMR5.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR5_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR5.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR5_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR5.Reg, volatile.LoadUint32(&o.CSMR5.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR5_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR5.Reg) & 0xffff0000) >> 16
}

// FB.CSCR5: Chip Select Control Register
func (o *FB_Type) SetCSCR5_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR5_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR5_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR5_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR5_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR5_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR5_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR5_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR5_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR5_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR5_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR5_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR5_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR5_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR5_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR5_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR5_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR5_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR5_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR5_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR5_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR5_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR5_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR5_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR5_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR5_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0xfc000000) >> 26
}

// FB.CSPMCR: Chip Select port Multiplexing Control Register
func (o *FB_Type) SetCSPMCR_GROUP5(value uint32) {
	volatile.StoreUint32(&o.CSPMCR.Reg, volatile.LoadUint32(&o.CSPMCR.Reg)&^(0xf000)|value<<12)
}
func (o *FB_Type) GetCSPMCR_GROUP5() uint32 {
	return (volatile.LoadUint32(&o.CSPMCR.Reg) & 0xf000) >> 12
}
func (o *FB_Type) SetCSPMCR_GROUP4(value uint32) {
	volatile.StoreUint32(&o.CSPMCR.Reg, volatile.LoadUint32(&o.CSPMCR.Reg)&^(0xf0000)|value<<16)
}
func (o *FB_Type) GetCSPMCR_GROUP4() uint32 {
	return (volatile.LoadUint32(&o.CSPMCR.Reg) & 0xf0000) >> 16
}
func (o *FB_Type) SetCSPMCR_GROUP3(value uint32) {
	volatile.StoreUint32(&o.CSPMCR.Reg, volatile.LoadUint32(&o.CSPMCR.Reg)&^(0xf00000)|value<<20)
}
func (o *FB_Type) GetCSPMCR_GROUP3() uint32 {
	return (volatile.LoadUint32(&o.CSPMCR.Reg) & 0xf00000) >> 20
}
func (o *FB_Type) SetCSPMCR_GROUP2(value uint32) {
	volatile.StoreUint32(&o.CSPMCR.Reg, volatile.LoadUint32(&o.CSPMCR.Reg)&^(0xf000000)|value<<24)
}
func (o *FB_Type) GetCSPMCR_GROUP2() uint32 {
	return (volatile.LoadUint32(&o.CSPMCR.Reg) & 0xf000000) >> 24
}
func (o *FB_Type) SetCSPMCR_GROUP1(value uint32) {
	volatile.StoreUint32(&o.CSPMCR.Reg, volatile.LoadUint32(&o.CSPMCR.Reg)&^(0xf0000000)|value<<28)
}
func (o *FB_Type) GetCSPMCR_GROUP1() uint32 {
	return (volatile.LoadUint32(&o.CSPMCR.Reg) & 0xf0000000) >> 28
}

// Flash Memory Controller
type FMC_Type struct {
	PFAPR     volatile.Register32 // 0x0
	PFB0CR    volatile.Register32 // 0x4
	PFB1CR    volatile.Register32 // 0x8
	_         [244]byte
	TAGVDW0S0 volatile.Register32 // 0x100
	TAGVDW0S1 volatile.Register32 // 0x104
	TAGVDW0S2 volatile.Register32 // 0x108
	TAGVDW0S3 volatile.Register32 // 0x10C
	TAGVDW0S4 volatile.Register32 // 0x110
	TAGVDW0S5 volatile.Register32 // 0x114
	TAGVDW0S6 volatile.Register32 // 0x118
	TAGVDW0S7 volatile.Register32 // 0x11C
	TAGVDW1S0 volatile.Register32 // 0x120
	TAGVDW1S1 volatile.Register32 // 0x124
	TAGVDW1S2 volatile.Register32 // 0x128
	TAGVDW1S3 volatile.Register32 // 0x12C
	TAGVDW1S4 volatile.Register32 // 0x130
	TAGVDW1S5 volatile.Register32 // 0x134
	TAGVDW1S6 volatile.Register32 // 0x138
	TAGVDW1S7 volatile.Register32 // 0x13C
	TAGVDW2S0 volatile.Register32 // 0x140
	TAGVDW2S1 volatile.Register32 // 0x144
	TAGVDW2S2 volatile.Register32 // 0x148
	TAGVDW2S3 volatile.Register32 // 0x14C
	TAGVDW2S4 volatile.Register32 // 0x150
	TAGVDW2S5 volatile.Register32 // 0x154
	TAGVDW2S6 volatile.Register32 // 0x158
	TAGVDW2S7 volatile.Register32 // 0x15C
	TAGVDW3S0 volatile.Register32 // 0x160
	TAGVDW3S1 volatile.Register32 // 0x164
	TAGVDW3S2 volatile.Register32 // 0x168
	TAGVDW3S3 volatile.Register32 // 0x16C
	TAGVDW3S4 volatile.Register32 // 0x170
	TAGVDW3S5 volatile.Register32 // 0x174
	TAGVDW3S6 volatile.Register32 // 0x178
	TAGVDW3S7 volatile.Register32 // 0x17C
	_         [128]byte
	DATAW0S0U volatile.Register32 // 0x200
	DATAW0S0L volatile.Register32 // 0x204
	DATAW0S1U volatile.Register32 // 0x208
	DATAW0S1L volatile.Register32 // 0x20C
	DATAW0S2U volatile.Register32 // 0x210
	DATAW0S2L volatile.Register32 // 0x214
	DATAW0S3U volatile.Register32 // 0x218
	DATAW0S3L volatile.Register32 // 0x21C
	DATAW0S4U volatile.Register32 // 0x220
	DATAW0S4L volatile.Register32 // 0x224
	DATAW0S5U volatile.Register32 // 0x228
	DATAW0S5L volatile.Register32 // 0x22C
	DATAW0S6U volatile.Register32 // 0x230
	DATAW0S6L volatile.Register32 // 0x234
	DATAW0S7U volatile.Register32 // 0x238
	DATAW0S7L volatile.Register32 // 0x23C
	DATAW1S0U volatile.Register32 // 0x240
	DATAW1S0L volatile.Register32 // 0x244
	DATAW1S1U volatile.Register32 // 0x248
	DATAW1S1L volatile.Register32 // 0x24C
	DATAW1S2U volatile.Register32 // 0x250
	DATAW1S2L volatile.Register32 // 0x254
	DATAW1S3U volatile.Register32 // 0x258
	DATAW1S3L volatile.Register32 // 0x25C
	DATAW1S4U volatile.Register32 // 0x260
	DATAW1S4L volatile.Register32 // 0x264
	DATAW1S5U volatile.Register32 // 0x268
	DATAW1S5L volatile.Register32 // 0x26C
	DATAW1S6U volatile.Register32 // 0x270
	DATAW1S6L volatile.Register32 // 0x274
	DATAW1S7U volatile.Register32 // 0x278
	DATAW1S7L volatile.Register32 // 0x27C
	DATAW2S0U volatile.Register32 // 0x280
	DATAW2S0L volatile.Register32 // 0x284
	DATAW2S1U volatile.Register32 // 0x288
	DATAW2S1L volatile.Register32 // 0x28C
	DATAW2S2U volatile.Register32 // 0x290
	DATAW2S2L volatile.Register32 // 0x294
	DATAW2S3U volatile.Register32 // 0x298
	DATAW2S3L volatile.Register32 // 0x29C
	DATAW2S4U volatile.Register32 // 0x2A0
	DATAW2S4L volatile.Register32 // 0x2A4
	DATAW2S5U volatile.Register32 // 0x2A8
	DATAW2S5L volatile.Register32 // 0x2AC
	DATAW2S6U volatile.Register32 // 0x2B0
	DATAW2S6L volatile.Register32 // 0x2B4
	DATAW2S7U volatile.Register32 // 0x2B8
	DATAW2S7L volatile.Register32 // 0x2BC
	DATAW3S0U volatile.Register32 // 0x2C0
	DATAW3S0L volatile.Register32 // 0x2C4
	DATAW3S1U volatile.Register32 // 0x2C8
	DATAW3S1L volatile.Register32 // 0x2CC
	DATAW3S2U volatile.Register32 // 0x2D0
	DATAW3S2L volatile.Register32 // 0x2D4
	DATAW3S3U volatile.Register32 // 0x2D8
	DATAW3S3L volatile.Register32 // 0x2DC
	DATAW3S4U volatile.Register32 // 0x2E0
	DATAW3S4L volatile.Register32 // 0x2E4
	DATAW3S5U volatile.Register32 // 0x2E8
	DATAW3S5L volatile.Register32 // 0x2EC
	DATAW3S6U volatile.Register32 // 0x2F0
	DATAW3S6L volatile.Register32 // 0x2F4
	DATAW3S7U volatile.Register32 // 0x2F8
	DATAW3S7L volatile.Register32 // 0x2FC
}

// FMC.PFAPR: Flash Access Protection Register
func (o *FMC_Type) SetPFAPR_M0AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x3)|value)
}
func (o *FMC_Type) GetPFAPR_M0AP() uint32 {
	return volatile.LoadUint32(&o.PFAPR.Reg) & 0x3
}
func (o *FMC_Type) SetPFAPR_M1AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetPFAPR_M1AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetPFAPR_M2AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetPFAPR_M2AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetPFAPR_M3AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0xc0)|value<<6)
}
func (o *FMC_Type) GetPFAPR_M3AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0xc0) >> 6
}
func (o *FMC_Type) SetPFAPR_M4AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x300)|value<<8)
}
func (o *FMC_Type) GetPFAPR_M4AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x300) >> 8
}
func (o *FMC_Type) SetPFAPR_M5AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0xc00)|value<<10)
}
func (o *FMC_Type) GetPFAPR_M5AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0xc00) >> 10
}
func (o *FMC_Type) SetPFAPR_M6AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x3000)|value<<12)
}
func (o *FMC_Type) GetPFAPR_M6AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x3000) >> 12
}
func (o *FMC_Type) SetPFAPR_M7AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0xc000)|value<<14)
}
func (o *FMC_Type) GetPFAPR_M7AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0xc000) >> 14
}
func (o *FMC_Type) SetPFAPR_M0PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x10000)|value<<16)
}
func (o *FMC_Type) GetPFAPR_M0PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x10000) >> 16
}
func (o *FMC_Type) SetPFAPR_M1PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x20000)|value<<17)
}
func (o *FMC_Type) GetPFAPR_M1PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x20000) >> 17
}
func (o *FMC_Type) SetPFAPR_M2PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x40000)|value<<18)
}
func (o *FMC_Type) GetPFAPR_M2PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x40000) >> 18
}
func (o *FMC_Type) SetPFAPR_M3PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetPFAPR_M3PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetPFAPR_M4PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetPFAPR_M4PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetPFAPR_M5PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetPFAPR_M5PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x200000) >> 21
}
func (o *FMC_Type) SetPFAPR_M6PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x400000)|value<<22)
}
func (o *FMC_Type) GetPFAPR_M6PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x400000) >> 22
}
func (o *FMC_Type) SetPFAPR_M7PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x800000)|value<<23)
}
func (o *FMC_Type) GetPFAPR_M7PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x800000) >> 23
}

// FMC.PFB0CR: Flash Bank 0 Control Register
func (o *FMC_Type) SetPFB0CR_B0SEBE(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetPFB0CR_B0SEBE() uint32 {
	return volatile.LoadUint32(&o.PFB0CR.Reg) & 0x1
}
func (o *FMC_Type) SetPFB0CR_B0IPE(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetPFB0CR_B0IPE() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetPFB0CR_B0DPE(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x4)|value<<2)
}
func (o *FMC_Type) GetPFB0CR_B0DPE() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x4) >> 2
}
func (o *FMC_Type) SetPFB0CR_B0ICE(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x8)|value<<3)
}
func (o *FMC_Type) GetPFB0CR_B0ICE() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x8) >> 3
}
func (o *FMC_Type) SetPFB0CR_B0DCE(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x10)|value<<4)
}
func (o *FMC_Type) GetPFB0CR_B0DCE() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x10) >> 4
}
func (o *FMC_Type) SetPFB0CR_CRC(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0xe0)|value<<5)
}
func (o *FMC_Type) GetPFB0CR_CRC() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0xe0) >> 5
}
func (o *FMC_Type) SetPFB0CR_B0MW(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x60000)|value<<17)
}
func (o *FMC_Type) GetPFB0CR_B0MW() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x60000) >> 17
}
func (o *FMC_Type) SetPFB0CR_S_B_INV(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetPFB0CR_S_B_INV() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetPFB0CR_CINV_WAY(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetPFB0CR_CINV_WAY() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetPFB0CR_CLCK_WAY(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetPFB0CR_CLCK_WAY() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetPFB0CR_B0RWSC(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0xf0000000)|value<<28)
}
func (o *FMC_Type) GetPFB0CR_B0RWSC() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0xf0000000) >> 28
}

// FMC.PFB1CR: Flash Bank 1 Control Register
func (o *FMC_Type) SetPFB1CR_B1SEBE(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetPFB1CR_B1SEBE() uint32 {
	return volatile.LoadUint32(&o.PFB1CR.Reg) & 0x1
}
func (o *FMC_Type) SetPFB1CR_B1IPE(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetPFB1CR_B1IPE() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetPFB1CR_B1DPE(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x4)|value<<2)
}
func (o *FMC_Type) GetPFB1CR_B1DPE() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0x4) >> 2
}
func (o *FMC_Type) SetPFB1CR_B1ICE(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x8)|value<<3)
}
func (o *FMC_Type) GetPFB1CR_B1ICE() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0x8) >> 3
}
func (o *FMC_Type) SetPFB1CR_B1DCE(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x10)|value<<4)
}
func (o *FMC_Type) GetPFB1CR_B1DCE() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0x10) >> 4
}
func (o *FMC_Type) SetPFB1CR_B1MW(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x60000)|value<<17)
}
func (o *FMC_Type) GetPFB1CR_B1MW() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0x60000) >> 17
}
func (o *FMC_Type) SetPFB1CR_B1RWSC(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0xf0000000)|value<<28)
}
func (o *FMC_Type) GetPFB1CR_B1RWSC() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0xf0000000) >> 28
}

// FMC.TAGVDW0S0: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S0_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S0.Reg, volatile.LoadUint32(&o.TAGVDW0S0.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S0_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S0.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S0_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S0.Reg, volatile.LoadUint32(&o.TAGVDW0S0.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S0_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S0.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW0S1: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S1_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S1.Reg, volatile.LoadUint32(&o.TAGVDW0S1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S1_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S1.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S1_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S1.Reg, volatile.LoadUint32(&o.TAGVDW0S1.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S1_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S1.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW0S2: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S2_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S2.Reg, volatile.LoadUint32(&o.TAGVDW0S2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S2_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S2.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S2_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S2.Reg, volatile.LoadUint32(&o.TAGVDW0S2.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S2_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S2.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW0S3: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S3_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S3.Reg, volatile.LoadUint32(&o.TAGVDW0S3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S3_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S3.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S3_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S3.Reg, volatile.LoadUint32(&o.TAGVDW0S3.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S3_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S3.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW0S4: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S4_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S4.Reg, volatile.LoadUint32(&o.TAGVDW0S4.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S4_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S4.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S4_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S4.Reg, volatile.LoadUint32(&o.TAGVDW0S4.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S4_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S4.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW0S5: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S5_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S5.Reg, volatile.LoadUint32(&o.TAGVDW0S5.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S5_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S5.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S5_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S5.Reg, volatile.LoadUint32(&o.TAGVDW0S5.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S5_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S5.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW0S6: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S6_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S6.Reg, volatile.LoadUint32(&o.TAGVDW0S6.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S6_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S6.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S6_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S6.Reg, volatile.LoadUint32(&o.TAGVDW0S6.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S6_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S6.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW0S7: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S7_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S7.Reg, volatile.LoadUint32(&o.TAGVDW0S7.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S7_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S7.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S7_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S7.Reg, volatile.LoadUint32(&o.TAGVDW0S7.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S7_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S7.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S0: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S0_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S0.Reg, volatile.LoadUint32(&o.TAGVDW1S0.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S0_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S0.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S0_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S0.Reg, volatile.LoadUint32(&o.TAGVDW1S0.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S0_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S0.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S1: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S1_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S1.Reg, volatile.LoadUint32(&o.TAGVDW1S1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S1_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S1.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S1_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S1.Reg, volatile.LoadUint32(&o.TAGVDW1S1.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S1_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S1.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S2: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S2_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S2.Reg, volatile.LoadUint32(&o.TAGVDW1S2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S2_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S2.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S2_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S2.Reg, volatile.LoadUint32(&o.TAGVDW1S2.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S2_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S2.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S3: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S3_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S3.Reg, volatile.LoadUint32(&o.TAGVDW1S3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S3_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S3.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S3_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S3.Reg, volatile.LoadUint32(&o.TAGVDW1S3.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S3_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S3.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S4: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S4_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S4.Reg, volatile.LoadUint32(&o.TAGVDW1S4.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S4_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S4.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S4_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S4.Reg, volatile.LoadUint32(&o.TAGVDW1S4.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S4_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S4.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S5: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S5_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S5.Reg, volatile.LoadUint32(&o.TAGVDW1S5.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S5_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S5.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S5_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S5.Reg, volatile.LoadUint32(&o.TAGVDW1S5.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S5_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S5.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S6: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S6_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S6.Reg, volatile.LoadUint32(&o.TAGVDW1S6.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S6_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S6.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S6_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S6.Reg, volatile.LoadUint32(&o.TAGVDW1S6.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S6_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S6.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S7: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S7_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S7.Reg, volatile.LoadUint32(&o.TAGVDW1S7.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S7_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S7.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S7_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S7.Reg, volatile.LoadUint32(&o.TAGVDW1S7.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S7_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S7.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S0: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S0_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S0.Reg, volatile.LoadUint32(&o.TAGVDW2S0.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S0_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S0.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S0_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S0.Reg, volatile.LoadUint32(&o.TAGVDW2S0.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S0_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S0.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S1: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S1_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S1.Reg, volatile.LoadUint32(&o.TAGVDW2S1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S1_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S1.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S1_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S1.Reg, volatile.LoadUint32(&o.TAGVDW2S1.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S1_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S1.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S2: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S2_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S2.Reg, volatile.LoadUint32(&o.TAGVDW2S2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S2_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S2.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S2_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S2.Reg, volatile.LoadUint32(&o.TAGVDW2S2.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S2_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S2.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S3: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S3_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S3.Reg, volatile.LoadUint32(&o.TAGVDW2S3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S3_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S3.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S3_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S3.Reg, volatile.LoadUint32(&o.TAGVDW2S3.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S3_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S3.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S4: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S4_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S4.Reg, volatile.LoadUint32(&o.TAGVDW2S4.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S4_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S4.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S4_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S4.Reg, volatile.LoadUint32(&o.TAGVDW2S4.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S4_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S4.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S5: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S5_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S5.Reg, volatile.LoadUint32(&o.TAGVDW2S5.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S5_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S5.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S5_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S5.Reg, volatile.LoadUint32(&o.TAGVDW2S5.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S5_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S5.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S6: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S6_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S6.Reg, volatile.LoadUint32(&o.TAGVDW2S6.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S6_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S6.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S6_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S6.Reg, volatile.LoadUint32(&o.TAGVDW2S6.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S6_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S6.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S7: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S7_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S7.Reg, volatile.LoadUint32(&o.TAGVDW2S7.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S7_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S7.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S7_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S7.Reg, volatile.LoadUint32(&o.TAGVDW2S7.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S7_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S7.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S0: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S0_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S0.Reg, volatile.LoadUint32(&o.TAGVDW3S0.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S0_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S0.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S0_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S0.Reg, volatile.LoadUint32(&o.TAGVDW3S0.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S0_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S0.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S1: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S1_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S1.Reg, volatile.LoadUint32(&o.TAGVDW3S1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S1_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S1.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S1_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S1.Reg, volatile.LoadUint32(&o.TAGVDW3S1.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S1_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S1.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S2: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S2_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S2.Reg, volatile.LoadUint32(&o.TAGVDW3S2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S2_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S2.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S2_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S2.Reg, volatile.LoadUint32(&o.TAGVDW3S2.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S2_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S2.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S3: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S3_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S3.Reg, volatile.LoadUint32(&o.TAGVDW3S3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S3_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S3.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S3_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S3.Reg, volatile.LoadUint32(&o.TAGVDW3S3.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S3_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S3.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S4: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S4_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S4.Reg, volatile.LoadUint32(&o.TAGVDW3S4.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S4_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S4.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S4_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S4.Reg, volatile.LoadUint32(&o.TAGVDW3S4.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S4_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S4.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S5: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S5_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S5.Reg, volatile.LoadUint32(&o.TAGVDW3S5.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S5_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S5.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S5_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S5.Reg, volatile.LoadUint32(&o.TAGVDW3S5.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S5_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S5.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S6: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S6_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S6.Reg, volatile.LoadUint32(&o.TAGVDW3S6.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S6_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S6.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S6_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S6.Reg, volatile.LoadUint32(&o.TAGVDW3S6.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S6_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S6.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S7: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S7_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S7.Reg, volatile.LoadUint32(&o.TAGVDW3S7.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S7_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S7.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S7_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S7.Reg, volatile.LoadUint32(&o.TAGVDW3S7.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S7_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S7.Reg) & 0x7ffe0) >> 5
}

// FMC.DATAW0S0U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S0U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S0U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S0U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S0U.Reg)
}

// FMC.DATAW0S0L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S0L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S0L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S0L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S0L.Reg)
}

// FMC.DATAW0S1U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S1U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S1U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S1U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S1U.Reg)
}

// FMC.DATAW0S1L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S1L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S1L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S1L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S1L.Reg)
}

// FMC.DATAW0S2U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S2U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S2U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S2U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S2U.Reg)
}

// FMC.DATAW0S2L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S2L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S2L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S2L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S2L.Reg)
}

// FMC.DATAW0S3U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S3U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S3U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S3U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S3U.Reg)
}

// FMC.DATAW0S3L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S3L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S3L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S3L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S3L.Reg)
}

// FMC.DATAW0S4U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S4U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S4U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S4U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S4U.Reg)
}

// FMC.DATAW0S4L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S4L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S4L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S4L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S4L.Reg)
}

// FMC.DATAW0S5U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S5U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S5U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S5U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S5U.Reg)
}

// FMC.DATAW0S5L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S5L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S5L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S5L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S5L.Reg)
}

// FMC.DATAW0S6U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S6U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S6U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S6U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S6U.Reg)
}

// FMC.DATAW0S6L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S6L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S6L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S6L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S6L.Reg)
}

// FMC.DATAW0S7U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S7U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S7U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S7U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S7U.Reg)
}

// FMC.DATAW0S7L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S7L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S7L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S7L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S7L.Reg)
}

// FMC.DATAW1S0U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S0U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S0U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S0U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S0U.Reg)
}

// FMC.DATAW1S0L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S0L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S0L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S0L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S0L.Reg)
}

// FMC.DATAW1S1U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S1U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S1U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S1U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S1U.Reg)
}

// FMC.DATAW1S1L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S1L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S1L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S1L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S1L.Reg)
}

// FMC.DATAW1S2U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S2U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S2U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S2U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S2U.Reg)
}

// FMC.DATAW1S2L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S2L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S2L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S2L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S2L.Reg)
}

// FMC.DATAW1S3U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S3U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S3U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S3U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S3U.Reg)
}

// FMC.DATAW1S3L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S3L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S3L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S3L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S3L.Reg)
}

// FMC.DATAW1S4U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S4U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S4U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S4U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S4U.Reg)
}

// FMC.DATAW1S4L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S4L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S4L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S4L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S4L.Reg)
}

// FMC.DATAW1S5U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S5U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S5U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S5U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S5U.Reg)
}

// FMC.DATAW1S5L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S5L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S5L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S5L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S5L.Reg)
}

// FMC.DATAW1S6U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S6U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S6U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S6U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S6U.Reg)
}

// FMC.DATAW1S6L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S6L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S6L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S6L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S6L.Reg)
}

// FMC.DATAW1S7U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S7U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S7U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S7U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S7U.Reg)
}

// FMC.DATAW1S7L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S7L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S7L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S7L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S7L.Reg)
}

// FMC.DATAW2S0U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S0U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S0U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S0U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S0U.Reg)
}

// FMC.DATAW2S0L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S0L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S0L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S0L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S0L.Reg)
}

// FMC.DATAW2S1U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S1U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S1U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S1U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S1U.Reg)
}

// FMC.DATAW2S1L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S1L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S1L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S1L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S1L.Reg)
}

// FMC.DATAW2S2U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S2U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S2U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S2U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S2U.Reg)
}

// FMC.DATAW2S2L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S2L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S2L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S2L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S2L.Reg)
}

// FMC.DATAW2S3U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S3U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S3U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S3U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S3U.Reg)
}

// FMC.DATAW2S3L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S3L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S3L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S3L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S3L.Reg)
}

// FMC.DATAW2S4U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S4U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S4U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S4U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S4U.Reg)
}

// FMC.DATAW2S4L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S4L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S4L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S4L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S4L.Reg)
}

// FMC.DATAW2S5U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S5U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S5U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S5U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S5U.Reg)
}

// FMC.DATAW2S5L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S5L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S5L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S5L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S5L.Reg)
}

// FMC.DATAW2S6U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S6U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S6U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S6U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S6U.Reg)
}

// FMC.DATAW2S6L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S6L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S6L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S6L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S6L.Reg)
}

// FMC.DATAW2S7U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S7U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S7U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S7U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S7U.Reg)
}

// FMC.DATAW2S7L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S7L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S7L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S7L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S7L.Reg)
}

// FMC.DATAW3S0U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S0U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S0U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S0U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S0U.Reg)
}

// FMC.DATAW3S0L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S0L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S0L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S0L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S0L.Reg)
}

// FMC.DATAW3S1U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S1U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S1U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S1U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S1U.Reg)
}

// FMC.DATAW3S1L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S1L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S1L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S1L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S1L.Reg)
}

// FMC.DATAW3S2U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S2U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S2U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S2U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S2U.Reg)
}

// FMC.DATAW3S2L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S2L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S2L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S2L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S2L.Reg)
}

// FMC.DATAW3S3U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S3U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S3U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S3U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S3U.Reg)
}

// FMC.DATAW3S3L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S3L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S3L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S3L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S3L.Reg)
}

// FMC.DATAW3S4U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S4U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S4U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S4U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S4U.Reg)
}

// FMC.DATAW3S4L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S4L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S4L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S4L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S4L.Reg)
}

// FMC.DATAW3S5U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S5U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S5U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S5U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S5U.Reg)
}

// FMC.DATAW3S5L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S5L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S5L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S5L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S5L.Reg)
}

// FMC.DATAW3S6U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S6U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S6U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S6U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S6U.Reg)
}

// FMC.DATAW3S6L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S6L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S6L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S6L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S6L.Reg)
}

// FMC.DATAW3S7U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S7U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S7U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S7U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S7U.Reg)
}

// FMC.DATAW3S7L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S7L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S7L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S7L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S7L.Reg)
}

// Flash Memory Interface
type FTFA_Type struct {
	FSTAT  volatile.Register8 // 0x0
	FCNFG  volatile.Register8 // 0x1
	FSEC   volatile.Register8 // 0x2
	FOPT   volatile.Register8 // 0x3
	FCCOB3 volatile.Register8 // 0x4
	FCCOB2 volatile.Register8 // 0x5
	FCCOB1 volatile.Register8 // 0x6
	FCCOB0 volatile.Register8 // 0x7
	FCCOB7 volatile.Register8 // 0x8
	FCCOB6 volatile.Register8 // 0x9
	FCCOB5 volatile.Register8 // 0xA
	FCCOB4 volatile.Register8 // 0xB
	FCCOBB volatile.Register8 // 0xC
	FCCOBA volatile.Register8 // 0xD
	FCCOB9 volatile.Register8 // 0xE
	FCCOB8 volatile.Register8 // 0xF
	FPROT3 volatile.Register8 // 0x10
	FPROT2 volatile.Register8 // 0x11
	FPROT1 volatile.Register8 // 0x12
	FPROT0 volatile.Register8 // 0x13
	_      [4]byte
	XACCH3 volatile.Register8 // 0x18
	XACCH2 volatile.Register8 // 0x19
	XACCH1 volatile.Register8 // 0x1A
	XACCH0 volatile.Register8 // 0x1B
	XACCL3 volatile.Register8 // 0x1C
	XACCL2 volatile.Register8 // 0x1D
	XACCL1 volatile.Register8 // 0x1E
	XACCL0 volatile.Register8 // 0x1F
	SACCH3 volatile.Register8 // 0x20
	SACCH2 volatile.Register8 // 0x21
	SACCH1 volatile.Register8 // 0x22
	SACCH0 volatile.Register8 // 0x23
	SACCL3 volatile.Register8 // 0x24
	SACCL2 volatile.Register8 // 0x25
	SACCL1 volatile.Register8 // 0x26
	SACCL0 volatile.Register8 // 0x27
	FACSS  volatile.Register8 // 0x28
	_      [2]byte
	FACSN  volatile.Register8 // 0x2B
}

// FTFA.FSTAT: Flash Status Register
func (o *FTFA_Type) SetFSTAT_MGSTAT0(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x1)|value)
}
func (o *FTFA_Type) GetFSTAT_MGSTAT0() uint8 {
	return volatile.LoadUint8(&o.FSTAT.Reg) & 0x1
}
func (o *FTFA_Type) SetFSTAT_FPVIOL(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x10)|value<<4)
}
func (o *FTFA_Type) GetFSTAT_FPVIOL() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x10) >> 4
}
func (o *FTFA_Type) SetFSTAT_ACCERR(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x20)|value<<5)
}
func (o *FTFA_Type) GetFSTAT_ACCERR() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x20) >> 5
}
func (o *FTFA_Type) SetFSTAT_RDCOLERR(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x40)|value<<6)
}
func (o *FTFA_Type) GetFSTAT_RDCOLERR() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x40) >> 6
}
func (o *FTFA_Type) SetFSTAT_CCIF(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x80)|value<<7)
}
func (o *FTFA_Type) GetFSTAT_CCIF() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x80) >> 7
}

// FTFA.FCNFG: Flash Configuration Register
func (o *FTFA_Type) SetFCNFG_ERSSUSP(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x10)|value<<4)
}
func (o *FTFA_Type) GetFCNFG_ERSSUSP() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x10) >> 4
}
func (o *FTFA_Type) SetFCNFG_ERSAREQ(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x20)|value<<5)
}
func (o *FTFA_Type) GetFCNFG_ERSAREQ() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x20) >> 5
}
func (o *FTFA_Type) SetFCNFG_RDCOLLIE(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x40)|value<<6)
}
func (o *FTFA_Type) GetFCNFG_RDCOLLIE() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x40) >> 6
}
func (o *FTFA_Type) SetFCNFG_CCIE(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x80)|value<<7)
}
func (o *FTFA_Type) GetFCNFG_CCIE() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x80) >> 7
}

// FTFA.FSEC: Flash Security Register
func (o *FTFA_Type) SetFSEC_SEC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x3)|value)
}
func (o *FTFA_Type) GetFSEC_SEC() uint8 {
	return volatile.LoadUint8(&o.FSEC.Reg) & 0x3
}
func (o *FTFA_Type) SetFSEC_FSLACC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc)|value<<2)
}
func (o *FTFA_Type) GetFSEC_FSLACC() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc) >> 2
}
func (o *FTFA_Type) SetFSEC_MEEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x30)|value<<4)
}
func (o *FTFA_Type) GetFSEC_MEEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0x30) >> 4
}
func (o *FTFA_Type) SetFSEC_KEYEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc0)|value<<6)
}
func (o *FTFA_Type) GetFSEC_KEYEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc0) >> 6
}

// FTFA.FOPT: Flash Option Register
func (o *FTFA_Type) SetFOPT(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, value)
}
func (o *FTFA_Type) GetFOPT() uint8 {
	return volatile.LoadUint8(&o.FOPT.Reg)
}

// FTFA.FCCOB3: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB3(value uint8) {
	volatile.StoreUint8(&o.FCCOB3.Reg, value)
}
func (o *FTFA_Type) GetFCCOB3() uint8 {
	return volatile.LoadUint8(&o.FCCOB3.Reg)
}

// FTFA.FCCOB2: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB2(value uint8) {
	volatile.StoreUint8(&o.FCCOB2.Reg, value)
}
func (o *FTFA_Type) GetFCCOB2() uint8 {
	return volatile.LoadUint8(&o.FCCOB2.Reg)
}

// FTFA.FCCOB1: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB1(value uint8) {
	volatile.StoreUint8(&o.FCCOB1.Reg, value)
}
func (o *FTFA_Type) GetFCCOB1() uint8 {
	return volatile.LoadUint8(&o.FCCOB1.Reg)
}

// FTFA.FCCOB0: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB0(value uint8) {
	volatile.StoreUint8(&o.FCCOB0.Reg, value)
}
func (o *FTFA_Type) GetFCCOB0() uint8 {
	return volatile.LoadUint8(&o.FCCOB0.Reg)
}

// FTFA.FCCOB7: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB7(value uint8) {
	volatile.StoreUint8(&o.FCCOB7.Reg, value)
}
func (o *FTFA_Type) GetFCCOB7() uint8 {
	return volatile.LoadUint8(&o.FCCOB7.Reg)
}

// FTFA.FCCOB6: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB6(value uint8) {
	volatile.StoreUint8(&o.FCCOB6.Reg, value)
}
func (o *FTFA_Type) GetFCCOB6() uint8 {
	return volatile.LoadUint8(&o.FCCOB6.Reg)
}

// FTFA.FCCOB5: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB5(value uint8) {
	volatile.StoreUint8(&o.FCCOB5.Reg, value)
}
func (o *FTFA_Type) GetFCCOB5() uint8 {
	return volatile.LoadUint8(&o.FCCOB5.Reg)
}

// FTFA.FCCOB4: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB4(value uint8) {
	volatile.StoreUint8(&o.FCCOB4.Reg, value)
}
func (o *FTFA_Type) GetFCCOB4() uint8 {
	return volatile.LoadUint8(&o.FCCOB4.Reg)
}

// FTFA.FCCOBB: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOBB(value uint8) {
	volatile.StoreUint8(&o.FCCOBB.Reg, value)
}
func (o *FTFA_Type) GetFCCOBB() uint8 {
	return volatile.LoadUint8(&o.FCCOBB.Reg)
}

// FTFA.FCCOBA: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOBA(value uint8) {
	volatile.StoreUint8(&o.FCCOBA.Reg, value)
}
func (o *FTFA_Type) GetFCCOBA() uint8 {
	return volatile.LoadUint8(&o.FCCOBA.Reg)
}

// FTFA.FCCOB9: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB9(value uint8) {
	volatile.StoreUint8(&o.FCCOB9.Reg, value)
}
func (o *FTFA_Type) GetFCCOB9() uint8 {
	return volatile.LoadUint8(&o.FCCOB9.Reg)
}

// FTFA.FCCOB8: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB8(value uint8) {
	volatile.StoreUint8(&o.FCCOB8.Reg, value)
}
func (o *FTFA_Type) GetFCCOB8() uint8 {
	return volatile.LoadUint8(&o.FCCOB8.Reg)
}

// FTFA.FPROT3: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT3(value uint8) {
	volatile.StoreUint8(&o.FPROT3.Reg, value)
}
func (o *FTFA_Type) GetFPROT3() uint8 {
	return volatile.LoadUint8(&o.FPROT3.Reg)
}

// FTFA.FPROT2: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT2(value uint8) {
	volatile.StoreUint8(&o.FPROT2.Reg, value)
}
func (o *FTFA_Type) GetFPROT2() uint8 {
	return volatile.LoadUint8(&o.FPROT2.Reg)
}

// FTFA.FPROT1: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT1(value uint8) {
	volatile.StoreUint8(&o.FPROT1.Reg, value)
}
func (o *FTFA_Type) GetFPROT1() uint8 {
	return volatile.LoadUint8(&o.FPROT1.Reg)
}

// FTFA.FPROT0: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT0(value uint8) {
	volatile.StoreUint8(&o.FPROT0.Reg, value)
}
func (o *FTFA_Type) GetFPROT0() uint8 {
	return volatile.LoadUint8(&o.FPROT0.Reg)
}

// FTFA.XACCH3: Execute-only Access Registers
func (o *FTFA_Type) SetXACCH3(value uint8) {
	volatile.StoreUint8(&o.XACCH3.Reg, value)
}
func (o *FTFA_Type) GetXACCH3() uint8 {
	return volatile.LoadUint8(&o.XACCH3.Reg)
}

// FTFA.XACCH2: Execute-only Access Registers
func (o *FTFA_Type) SetXACCH2(value uint8) {
	volatile.StoreUint8(&o.XACCH2.Reg, value)
}
func (o *FTFA_Type) GetXACCH2() uint8 {
	return volatile.LoadUint8(&o.XACCH2.Reg)
}

// FTFA.XACCH1: Execute-only Access Registers
func (o *FTFA_Type) SetXACCH1(value uint8) {
	volatile.StoreUint8(&o.XACCH1.Reg, value)
}
func (o *FTFA_Type) GetXACCH1() uint8 {
	return volatile.LoadUint8(&o.XACCH1.Reg)
}

// FTFA.XACCH0: Execute-only Access Registers
func (o *FTFA_Type) SetXACCH0(value uint8) {
	volatile.StoreUint8(&o.XACCH0.Reg, value)
}
func (o *FTFA_Type) GetXACCH0() uint8 {
	return volatile.LoadUint8(&o.XACCH0.Reg)
}

// FTFA.XACCL3: Execute-only Access Registers
func (o *FTFA_Type) SetXACCL3(value uint8) {
	volatile.StoreUint8(&o.XACCL3.Reg, value)
}
func (o *FTFA_Type) GetXACCL3() uint8 {
	return volatile.LoadUint8(&o.XACCL3.Reg)
}

// FTFA.XACCL2: Execute-only Access Registers
func (o *FTFA_Type) SetXACCL2(value uint8) {
	volatile.StoreUint8(&o.XACCL2.Reg, value)
}
func (o *FTFA_Type) GetXACCL2() uint8 {
	return volatile.LoadUint8(&o.XACCL2.Reg)
}

// FTFA.XACCL1: Execute-only Access Registers
func (o *FTFA_Type) SetXACCL1(value uint8) {
	volatile.StoreUint8(&o.XACCL1.Reg, value)
}
func (o *FTFA_Type) GetXACCL1() uint8 {
	return volatile.LoadUint8(&o.XACCL1.Reg)
}

// FTFA.XACCL0: Execute-only Access Registers
func (o *FTFA_Type) SetXACCL0(value uint8) {
	volatile.StoreUint8(&o.XACCL0.Reg, value)
}
func (o *FTFA_Type) GetXACCL0() uint8 {
	return volatile.LoadUint8(&o.XACCL0.Reg)
}

// FTFA.SACCH3: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCH3(value uint8) {
	volatile.StoreUint8(&o.SACCH3.Reg, value)
}
func (o *FTFA_Type) GetSACCH3() uint8 {
	return volatile.LoadUint8(&o.SACCH3.Reg)
}

// FTFA.SACCH2: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCH2(value uint8) {
	volatile.StoreUint8(&o.SACCH2.Reg, value)
}
func (o *FTFA_Type) GetSACCH2() uint8 {
	return volatile.LoadUint8(&o.SACCH2.Reg)
}

// FTFA.SACCH1: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCH1(value uint8) {
	volatile.StoreUint8(&o.SACCH1.Reg, value)
}
func (o *FTFA_Type) GetSACCH1() uint8 {
	return volatile.LoadUint8(&o.SACCH1.Reg)
}

// FTFA.SACCH0: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCH0(value uint8) {
	volatile.StoreUint8(&o.SACCH0.Reg, value)
}
func (o *FTFA_Type) GetSACCH0() uint8 {
	return volatile.LoadUint8(&o.SACCH0.Reg)
}

// FTFA.SACCL3: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCL3(value uint8) {
	volatile.StoreUint8(&o.SACCL3.Reg, value)
}
func (o *FTFA_Type) GetSACCL3() uint8 {
	return volatile.LoadUint8(&o.SACCL3.Reg)
}

// FTFA.SACCL2: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCL2(value uint8) {
	volatile.StoreUint8(&o.SACCL2.Reg, value)
}
func (o *FTFA_Type) GetSACCL2() uint8 {
	return volatile.LoadUint8(&o.SACCL2.Reg)
}

// FTFA.SACCL1: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCL1(value uint8) {
	volatile.StoreUint8(&o.SACCL1.Reg, value)
}
func (o *FTFA_Type) GetSACCL1() uint8 {
	return volatile.LoadUint8(&o.SACCL1.Reg)
}

// FTFA.SACCL0: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCL0(value uint8) {
	volatile.StoreUint8(&o.SACCL0.Reg, value)
}
func (o *FTFA_Type) GetSACCL0() uint8 {
	return volatile.LoadUint8(&o.SACCL0.Reg)
}

// FTFA.FACSS: Flash Access Segment Size Register
func (o *FTFA_Type) SetFACSS(value uint8) {
	volatile.StoreUint8(&o.FACSS.Reg, value)
}
func (o *FTFA_Type) GetFACSS() uint8 {
	return volatile.LoadUint8(&o.FACSS.Reg)
}

// FTFA.FACSN: Flash Access Segment Number Register
func (o *FTFA_Type) SetFACSN(value uint8) {
	volatile.StoreUint8(&o.FACSN.Reg, value)
}
func (o *FTFA_Type) GetFACSN() uint8 {
	return volatile.LoadUint8(&o.FACSN.Reg)
}

// DMA channel multiplexor
type DMAMUX_Type struct {
	CHCFG0  volatile.Register8 // 0x0
	CHCFG1  volatile.Register8 // 0x1
	CHCFG2  volatile.Register8 // 0x2
	CHCFG3  volatile.Register8 // 0x3
	CHCFG4  volatile.Register8 // 0x4
	CHCFG5  volatile.Register8 // 0x5
	CHCFG6  volatile.Register8 // 0x6
	CHCFG7  volatile.Register8 // 0x7
	CHCFG8  volatile.Register8 // 0x8
	CHCFG9  volatile.Register8 // 0x9
	CHCFG10 volatile.Register8 // 0xA
	CHCFG11 volatile.Register8 // 0xB
	CHCFG12 volatile.Register8 // 0xC
	CHCFG13 volatile.Register8 // 0xD
	CHCFG14 volatile.Register8 // 0xE
	CHCFG15 volatile.Register8 // 0xF
}

// DMAMUX.CHCFG0: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG0_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG0_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG0.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG0_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG0_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG0.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG0_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG0_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG0.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG1: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG1_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG1_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG1.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG1_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG1_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG1.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG1_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG1_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG1.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG2: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG2_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG2_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG2.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG2_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG2_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG2.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG2_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG2_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG2.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG3: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG3_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG3_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG3.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG3_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG3_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG3.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG3_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG3_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG3.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG4: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG4_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG4.Reg, volatile.LoadUint8(&o.CHCFG4.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG4_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG4.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG4_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG4.Reg, volatile.LoadUint8(&o.CHCFG4.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG4_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG4.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG4_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG4.Reg, volatile.LoadUint8(&o.CHCFG4.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG4_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG4.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG5: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG5_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG5.Reg, volatile.LoadUint8(&o.CHCFG5.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG5_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG5.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG5_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG5.Reg, volatile.LoadUint8(&o.CHCFG5.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG5_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG5.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG5_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG5.Reg, volatile.LoadUint8(&o.CHCFG5.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG5_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG5.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG6: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG6_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG6.Reg, volatile.LoadUint8(&o.CHCFG6.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG6_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG6.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG6_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG6.Reg, volatile.LoadUint8(&o.CHCFG6.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG6_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG6.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG6_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG6.Reg, volatile.LoadUint8(&o.CHCFG6.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG6_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG6.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG7: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG7_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG7.Reg, volatile.LoadUint8(&o.CHCFG7.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG7_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG7.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG7_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG7.Reg, volatile.LoadUint8(&o.CHCFG7.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG7_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG7.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG7_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG7.Reg, volatile.LoadUint8(&o.CHCFG7.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG7_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG7.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG8: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG8_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG8.Reg, volatile.LoadUint8(&o.CHCFG8.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG8_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG8.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG8_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG8.Reg, volatile.LoadUint8(&o.CHCFG8.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG8_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG8.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG8_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG8.Reg, volatile.LoadUint8(&o.CHCFG8.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG8_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG8.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG9: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG9_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG9.Reg, volatile.LoadUint8(&o.CHCFG9.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG9_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG9.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG9_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG9.Reg, volatile.LoadUint8(&o.CHCFG9.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG9_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG9.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG9_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG9.Reg, volatile.LoadUint8(&o.CHCFG9.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG9_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG9.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG10: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG10_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG10.Reg, volatile.LoadUint8(&o.CHCFG10.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG10_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG10.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG10_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG10.Reg, volatile.LoadUint8(&o.CHCFG10.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG10_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG10.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG10_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG10.Reg, volatile.LoadUint8(&o.CHCFG10.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG10_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG10.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG11: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG11_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG11.Reg, volatile.LoadUint8(&o.CHCFG11.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG11_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG11.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG11_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG11.Reg, volatile.LoadUint8(&o.CHCFG11.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG11_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG11.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG11_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG11.Reg, volatile.LoadUint8(&o.CHCFG11.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG11_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG11.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG12: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG12_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG12.Reg, volatile.LoadUint8(&o.CHCFG12.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG12_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG12.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG12_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG12.Reg, volatile.LoadUint8(&o.CHCFG12.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG12_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG12.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG12_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG12.Reg, volatile.LoadUint8(&o.CHCFG12.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG12_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG12.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG13: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG13_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG13.Reg, volatile.LoadUint8(&o.CHCFG13.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG13_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG13.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG13_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG13.Reg, volatile.LoadUint8(&o.CHCFG13.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG13_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG13.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG13_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG13.Reg, volatile.LoadUint8(&o.CHCFG13.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG13_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG13.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG14: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG14_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG14.Reg, volatile.LoadUint8(&o.CHCFG14.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG14_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG14.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG14_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG14.Reg, volatile.LoadUint8(&o.CHCFG14.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG14_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG14.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG14_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG14.Reg, volatile.LoadUint8(&o.CHCFG14.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG14_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG14.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG15: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG15_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG15.Reg, volatile.LoadUint8(&o.CHCFG15.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG15_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG15.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG15_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG15.Reg, volatile.LoadUint8(&o.CHCFG15.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG15_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG15.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG15_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG15.Reg, volatile.LoadUint8(&o.CHCFG15.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG15_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG15.Reg) & 0x80) >> 7
}

// FlexTimer Module
type FTM_Type struct {
	SC       volatile.Register32 // 0x0
	CNT      volatile.Register32 // 0x4
	MOD      volatile.Register32 // 0x8
	C0SC     volatile.Register32 // 0xC
	C0V      volatile.Register32 // 0x10
	C1SC     volatile.Register32 // 0x14
	C1V      volatile.Register32 // 0x18
	C2SC     volatile.Register32 // 0x1C
	C2V      volatile.Register32 // 0x20
	C3SC     volatile.Register32 // 0x24
	C3V      volatile.Register32 // 0x28
	C4SC     volatile.Register32 // 0x2C
	C4V      volatile.Register32 // 0x30
	C5SC     volatile.Register32 // 0x34
	C5V      volatile.Register32 // 0x38
	C6SC     volatile.Register32 // 0x3C
	C6V      volatile.Register32 // 0x40
	C7SC     volatile.Register32 // 0x44
	C7V      volatile.Register32 // 0x48
	CNTIN    volatile.Register32 // 0x4C
	STATUS   volatile.Register32 // 0x50
	MODE     volatile.Register32 // 0x54
	SYNC     volatile.Register32 // 0x58
	OUTINIT  volatile.Register32 // 0x5C
	OUTMASK  volatile.Register32 // 0x60
	COMBINE  volatile.Register32 // 0x64
	DEADTIME volatile.Register32 // 0x68
	EXTTRIG  volatile.Register32 // 0x6C
	POL      volatile.Register32 // 0x70
	FMS      volatile.Register32 // 0x74
	FILTER   volatile.Register32 // 0x78
	FLTCTRL  volatile.Register32 // 0x7C
	QDCTRL   volatile.Register32 // 0x80
	CONF     volatile.Register32 // 0x84
	FLTPOL   volatile.Register32 // 0x88
	SYNCONF  volatile.Register32 // 0x8C
	INVCTRL  volatile.Register32 // 0x90
	SWOCTRL  volatile.Register32 // 0x94
	PWMLOAD  volatile.Register32 // 0x98
}

// FTM.SC: Status And Control
func (o *FTM_Type) SetSC_PS(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x7)|value)
}
func (o *FTM_Type) GetSC_PS() uint32 {
	return volatile.LoadUint32(&o.SC.Reg) & 0x7
}
func (o *FTM_Type) SetSC_CLKS(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x18)|value<<3)
}
func (o *FTM_Type) GetSC_CLKS() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x18) >> 3
}
func (o *FTM_Type) SetSC_CPWMS(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetSC_CPWMS() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetSC_TOIE(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetSC_TOIE() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetSC_TOF(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetSC_TOF() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x80) >> 7
}

// FTM.CNT: Counter
func (o *FTM_Type) SetCNT_COUNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetCNT_COUNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// FTM.MOD: Modulo
func (o *FTM_Type) SetMOD(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetMOD() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0xffff
}

// FTM.C0SC: Channel (n) Status And Control
func (o *FTM_Type) SetC0SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC0SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C0SC.Reg) & 0x1
}
func (o *FTM_Type) SetC0SC_ICRST(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetC0SC_ICRST() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetC0SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC0SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC0SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC0SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC0SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC0SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC0SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC0SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC0SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC0SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC0SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC0SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x80) >> 7
}

// FTM.C0V: Channel (n) Value
func (o *FTM_Type) SetC0V_VAL(value uint32) {
	volatile.StoreUint32(&o.C0V.Reg, volatile.LoadUint32(&o.C0V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC0V_VAL() uint32 {
	return volatile.LoadUint32(&o.C0V.Reg) & 0xffff
}

// FTM.C1SC: Channel (n) Status And Control
func (o *FTM_Type) SetC1SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC1SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C1SC.Reg) & 0x1
}
func (o *FTM_Type) SetC1SC_ICRST(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetC1SC_ICRST() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetC1SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC1SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC1SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC1SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC1SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC1SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC1SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC1SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC1SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC1SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC1SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC1SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x80) >> 7
}

// FTM.C1V: Channel (n) Value
func (o *FTM_Type) SetC1V_VAL(value uint32) {
	volatile.StoreUint32(&o.C1V.Reg, volatile.LoadUint32(&o.C1V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC1V_VAL() uint32 {
	return volatile.LoadUint32(&o.C1V.Reg) & 0xffff
}

// FTM.C2SC: Channel (n) Status And Control
func (o *FTM_Type) SetC2SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC2SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C2SC.Reg) & 0x1
}
func (o *FTM_Type) SetC2SC_ICRST(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetC2SC_ICRST() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetC2SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC2SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC2SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC2SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC2SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC2SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC2SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC2SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC2SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC2SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC2SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC2SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x80) >> 7
}

// FTM.C2V: Channel (n) Value
func (o *FTM_Type) SetC2V_VAL(value uint32) {
	volatile.StoreUint32(&o.C2V.Reg, volatile.LoadUint32(&o.C2V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC2V_VAL() uint32 {
	return volatile.LoadUint32(&o.C2V.Reg) & 0xffff
}

// FTM.C3SC: Channel (n) Status And Control
func (o *FTM_Type) SetC3SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC3SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C3SC.Reg) & 0x1
}
func (o *FTM_Type) SetC3SC_ICRST(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetC3SC_ICRST() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetC3SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC3SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC3SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC3SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC3SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC3SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC3SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC3SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC3SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC3SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC3SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC3SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x80) >> 7
}

// FTM.C3V: Channel (n) Value
func (o *FTM_Type) SetC3V_VAL(value uint32) {
	volatile.StoreUint32(&o.C3V.Reg, volatile.LoadUint32(&o.C3V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC3V_VAL() uint32 {
	return volatile.LoadUint32(&o.C3V.Reg) & 0xffff
}

// FTM.C4SC: Channel (n) Status And Control
func (o *FTM_Type) SetC4SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC4SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C4SC.Reg) & 0x1
}
func (o *FTM_Type) SetC4SC_ICRST(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetC4SC_ICRST() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetC4SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC4SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC4SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC4SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC4SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC4SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC4SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC4SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC4SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC4SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC4SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC4SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x80) >> 7
}

// FTM.C4V: Channel (n) Value
func (o *FTM_Type) SetC4V_VAL(value uint32) {
	volatile.StoreUint32(&o.C4V.Reg, volatile.LoadUint32(&o.C4V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC4V_VAL() uint32 {
	return volatile.LoadUint32(&o.C4V.Reg) & 0xffff
}

// FTM.C5SC: Channel (n) Status And Control
func (o *FTM_Type) SetC5SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC5SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C5SC.Reg) & 0x1
}
func (o *FTM_Type) SetC5SC_ICRST(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetC5SC_ICRST() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetC5SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC5SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC5SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC5SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC5SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC5SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC5SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC5SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC5SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC5SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC5SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC5SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x80) >> 7
}

// FTM.C5V: Channel (n) Value
func (o *FTM_Type) SetC5V_VAL(value uint32) {
	volatile.StoreUint32(&o.C5V.Reg, volatile.LoadUint32(&o.C5V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC5V_VAL() uint32 {
	return volatile.LoadUint32(&o.C5V.Reg) & 0xffff
}

// FTM.C6SC: Channel (n) Status And Control
func (o *FTM_Type) SetC6SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC6SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C6SC.Reg) & 0x1
}
func (o *FTM_Type) SetC6SC_ICRST(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetC6SC_ICRST() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetC6SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC6SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC6SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC6SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC6SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC6SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC6SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC6SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC6SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC6SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC6SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC6SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x80) >> 7
}

// FTM.C6V: Channel (n) Value
func (o *FTM_Type) SetC6V_VAL(value uint32) {
	volatile.StoreUint32(&o.C6V.Reg, volatile.LoadUint32(&o.C6V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC6V_VAL() uint32 {
	return volatile.LoadUint32(&o.C6V.Reg) & 0xffff
}

// FTM.C7SC: Channel (n) Status And Control
func (o *FTM_Type) SetC7SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC7SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C7SC.Reg) & 0x1
}
func (o *FTM_Type) SetC7SC_ICRST(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetC7SC_ICRST() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetC7SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC7SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC7SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC7SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC7SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC7SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC7SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC7SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC7SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC7SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC7SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC7SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x80) >> 7
}

// FTM.C7V: Channel (n) Value
func (o *FTM_Type) SetC7V_VAL(value uint32) {
	volatile.StoreUint32(&o.C7V.Reg, volatile.LoadUint32(&o.C7V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC7V_VAL() uint32 {
	return volatile.LoadUint32(&o.C7V.Reg) & 0xffff
}

// FTM.CNTIN: Counter Initial Value
func (o *FTM_Type) SetCNTIN_INIT(value uint32) {
	volatile.StoreUint32(&o.CNTIN.Reg, volatile.LoadUint32(&o.CNTIN.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetCNTIN_INIT() uint32 {
	return volatile.LoadUint32(&o.CNTIN.Reg) & 0xffff
}

// FTM.STATUS: Capture And Compare Status
func (o *FTM_Type) SetSTATUS_CH0F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetSTATUS_CH0F() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *FTM_Type) SetSTATUS_CH1F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetSTATUS_CH1F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetSTATUS_CH2F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetSTATUS_CH2F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetSTATUS_CH3F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetSTATUS_CH3F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetSTATUS_CH4F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetSTATUS_CH4F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetSTATUS_CH5F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetSTATUS_CH5F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetSTATUS_CH6F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetSTATUS_CH6F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetSTATUS_CH7F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetSTATUS_CH7F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}

// FTM.MODE: Features Mode Selection
func (o *FTM_Type) SetMODE_FTMEN(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetMODE_FTMEN() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}
func (o *FTM_Type) SetMODE_INIT(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetMODE_INIT() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetMODE_WPDIS(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetMODE_WPDIS() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetMODE_PWMSYNC(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetMODE_PWMSYNC() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetMODE_CAPTEST(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetMODE_CAPTEST() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetMODE_FAULTM(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x60)|value<<5)
}
func (o *FTM_Type) GetMODE_FAULTM() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x60) >> 5
}
func (o *FTM_Type) SetMODE_FAULTIE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetMODE_FAULTIE() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x80) >> 7
}

// FTM.SYNC: Synchronization
func (o *FTM_Type) SetSYNC_CNTMIN(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetSYNC_CNTMIN() uint32 {
	return volatile.LoadUint32(&o.SYNC.Reg) & 0x1
}
func (o *FTM_Type) SetSYNC_CNTMAX(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetSYNC_CNTMAX() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetSYNC_REINIT(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetSYNC_REINIT() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetSYNC_SYNCHOM(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetSYNC_SYNCHOM() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetSYNC_TRIG0(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetSYNC_TRIG0() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetSYNC_TRIG1(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetSYNC_TRIG1() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetSYNC_TRIG2(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetSYNC_TRIG2() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetSYNC_SWSYNC(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetSYNC_SWSYNC() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x80) >> 7
}

// FTM.OUTINIT: Initial State For Channels Output
func (o *FTM_Type) SetOUTINIT_CH0OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetOUTINIT_CH0OI() uint32 {
	return volatile.LoadUint32(&o.OUTINIT.Reg) & 0x1
}
func (o *FTM_Type) SetOUTINIT_CH1OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetOUTINIT_CH1OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetOUTINIT_CH2OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetOUTINIT_CH2OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetOUTINIT_CH3OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetOUTINIT_CH3OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetOUTINIT_CH4OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetOUTINIT_CH4OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetOUTINIT_CH5OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetOUTINIT_CH5OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetOUTINIT_CH6OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetOUTINIT_CH6OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetOUTINIT_CH7OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetOUTINIT_CH7OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x80) >> 7
}

// FTM.OUTMASK: Output Mask
func (o *FTM_Type) SetOUTMASK_CH0OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetOUTMASK_CH0OM() uint32 {
	return volatile.LoadUint32(&o.OUTMASK.Reg) & 0x1
}
func (o *FTM_Type) SetOUTMASK_CH1OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetOUTMASK_CH1OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetOUTMASK_CH2OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetOUTMASK_CH2OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetOUTMASK_CH3OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetOUTMASK_CH3OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetOUTMASK_CH4OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetOUTMASK_CH4OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetOUTMASK_CH5OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetOUTMASK_CH5OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetOUTMASK_CH6OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetOUTMASK_CH6OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetOUTMASK_CH7OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetOUTMASK_CH7OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x80) >> 7
}

// FTM.COMBINE: Function For Linked Channels
func (o *FTM_Type) SetCOMBINE_COMBINE0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetCOMBINE_COMBINE0() uint32 {
	return volatile.LoadUint32(&o.COMBINE.Reg) & 0x1
}
func (o *FTM_Type) SetCOMBINE_COMP0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetCOMBINE_COMP0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetCOMBINE_DECAPEN0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetCOMBINE_DECAPEN0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetCOMBINE_DECAP0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetCOMBINE_DECAP0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetCOMBINE_DTEN0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetCOMBINE_DTEN0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetCOMBINE_SYNCEN0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetCOMBINE_SYNCEN0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetCOMBINE_FAULTEN0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetCOMBINE_FAULTEN0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetCOMBINE_COMBINE1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x100)|value<<8)
}
func (o *FTM_Type) GetCOMBINE_COMBINE1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x100) >> 8
}
func (o *FTM_Type) SetCOMBINE_COMP1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x200)|value<<9)
}
func (o *FTM_Type) GetCOMBINE_COMP1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x200) >> 9
}
func (o *FTM_Type) SetCOMBINE_DECAPEN1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x400)|value<<10)
}
func (o *FTM_Type) GetCOMBINE_DECAPEN1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x400) >> 10
}
func (o *FTM_Type) SetCOMBINE_DECAP1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x800)|value<<11)
}
func (o *FTM_Type) GetCOMBINE_DECAP1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x800) >> 11
}
func (o *FTM_Type) SetCOMBINE_DTEN1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x1000)|value<<12)
}
func (o *FTM_Type) GetCOMBINE_DTEN1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x1000) >> 12
}
func (o *FTM_Type) SetCOMBINE_SYNCEN1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x2000)|value<<13)
}
func (o *FTM_Type) GetCOMBINE_SYNCEN1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x2000) >> 13
}
func (o *FTM_Type) SetCOMBINE_FAULTEN1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x4000)|value<<14)
}
func (o *FTM_Type) GetCOMBINE_FAULTEN1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x4000) >> 14
}
func (o *FTM_Type) SetCOMBINE_COMBINE2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x10000)|value<<16)
}
func (o *FTM_Type) GetCOMBINE_COMBINE2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x10000) >> 16
}
func (o *FTM_Type) SetCOMBINE_COMP2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x20000)|value<<17)
}
func (o *FTM_Type) GetCOMBINE_COMP2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x20000) >> 17
}
func (o *FTM_Type) SetCOMBINE_DECAPEN2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x40000)|value<<18)
}
func (o *FTM_Type) GetCOMBINE_DECAPEN2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x40000) >> 18
}
func (o *FTM_Type) SetCOMBINE_DECAP2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x80000)|value<<19)
}
func (o *FTM_Type) GetCOMBINE_DECAP2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x80000) >> 19
}
func (o *FTM_Type) SetCOMBINE_DTEN2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x100000)|value<<20)
}
func (o *FTM_Type) GetCOMBINE_DTEN2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x100000) >> 20
}
func (o *FTM_Type) SetCOMBINE_SYNCEN2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x200000)|value<<21)
}
func (o *FTM_Type) GetCOMBINE_SYNCEN2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x200000) >> 21
}
func (o *FTM_Type) SetCOMBINE_FAULTEN2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x400000)|value<<22)
}
func (o *FTM_Type) GetCOMBINE_FAULTEN2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x400000) >> 22
}
func (o *FTM_Type) SetCOMBINE_COMBINE3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x1000000)|value<<24)
}
func (o *FTM_Type) GetCOMBINE_COMBINE3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x1000000) >> 24
}
func (o *FTM_Type) SetCOMBINE_COMP3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x2000000)|value<<25)
}
func (o *FTM_Type) GetCOMBINE_COMP3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x2000000) >> 25
}
func (o *FTM_Type) SetCOMBINE_DECAPEN3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x4000000)|value<<26)
}
func (o *FTM_Type) GetCOMBINE_DECAPEN3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x4000000) >> 26
}
func (o *FTM_Type) SetCOMBINE_DECAP3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x8000000)|value<<27)
}
func (o *FTM_Type) GetCOMBINE_DECAP3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x8000000) >> 27
}
func (o *FTM_Type) SetCOMBINE_DTEN3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x10000000)|value<<28)
}
func (o *FTM_Type) GetCOMBINE_DTEN3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x10000000) >> 28
}
func (o *FTM_Type) SetCOMBINE_SYNCEN3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x20000000)|value<<29)
}
func (o *FTM_Type) GetCOMBINE_SYNCEN3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x20000000) >> 29
}
func (o *FTM_Type) SetCOMBINE_FAULTEN3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x40000000)|value<<30)
}
func (o *FTM_Type) GetCOMBINE_FAULTEN3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x40000000) >> 30
}

// FTM.DEADTIME: Deadtime Insertion Control
func (o *FTM_Type) SetDEADTIME_DTVAL(value uint32) {
	volatile.StoreUint32(&o.DEADTIME.Reg, volatile.LoadUint32(&o.DEADTIME.Reg)&^(0x3f)|value)
}
func (o *FTM_Type) GetDEADTIME_DTVAL() uint32 {
	return volatile.LoadUint32(&o.DEADTIME.Reg) & 0x3f
}
func (o *FTM_Type) SetDEADTIME_DTPS(value uint32) {
	volatile.StoreUint32(&o.DEADTIME.Reg, volatile.LoadUint32(&o.DEADTIME.Reg)&^(0xc0)|value<<6)
}
func (o *FTM_Type) GetDEADTIME_DTPS() uint32 {
	return (volatile.LoadUint32(&o.DEADTIME.Reg) & 0xc0) >> 6
}

// FTM.EXTTRIG: FTM External Trigger
func (o *FTM_Type) SetEXTTRIG_CH2TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetEXTTRIG_CH2TRIG() uint32 {
	return volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x1
}
func (o *FTM_Type) SetEXTTRIG_CH3TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetEXTTRIG_CH3TRIG() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetEXTTRIG_CH4TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetEXTTRIG_CH4TRIG() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetEXTTRIG_CH5TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetEXTTRIG_CH5TRIG() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetEXTTRIG_CH0TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetEXTTRIG_CH0TRIG() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetEXTTRIG_CH1TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetEXTTRIG_CH1TRIG() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetEXTTRIG_INITTRIGEN(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetEXTTRIG_INITTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetEXTTRIG_TRIGF(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetEXTTRIG_TRIGF() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x80) >> 7
}

// FTM.POL: Channels Polarity
func (o *FTM_Type) SetPOL_POL0(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetPOL_POL0() uint32 {
	return volatile.LoadUint32(&o.POL.Reg) & 0x1
}
func (o *FTM_Type) SetPOL_POL1(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetPOL_POL1() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetPOL_POL2(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetPOL_POL2() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetPOL_POL3(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetPOL_POL3() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetPOL_POL4(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetPOL_POL4() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetPOL_POL5(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetPOL_POL5() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetPOL_POL6(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetPOL_POL6() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetPOL_POL7(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetPOL_POL7() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x80) >> 7
}

// FTM.FMS: Fault Mode Status
func (o *FTM_Type) SetFMS_FAULTF0(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetFMS_FAULTF0() uint32 {
	return volatile.LoadUint32(&o.FMS.Reg) & 0x1
}
func (o *FTM_Type) SetFMS_FAULTF1(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetFMS_FAULTF1() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetFMS_FAULTF2(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetFMS_FAULTF2() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetFMS_FAULTF3(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetFMS_FAULTF3() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetFMS_FAULTIN(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetFMS_FAULTIN() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetFMS_WPEN(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetFMS_WPEN() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetFMS_FAULTF(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetFMS_FAULTF() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x80) >> 7
}

// FTM.FILTER: Input Capture Filter Control
func (o *FTM_Type) SetFILTER_CH0FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf)|value)
}
func (o *FTM_Type) GetFILTER_CH0FVAL() uint32 {
	return volatile.LoadUint32(&o.FILTER.Reg) & 0xf
}
func (o *FTM_Type) SetFILTER_CH1FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf0)|value<<4)
}
func (o *FTM_Type) GetFILTER_CH1FVAL() uint32 {
	return (volatile.LoadUint32(&o.FILTER.Reg) & 0xf0) >> 4
}
func (o *FTM_Type) SetFILTER_CH2FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf00)|value<<8)
}
func (o *FTM_Type) GetFILTER_CH2FVAL() uint32 {
	return (volatile.LoadUint32(&o.FILTER.Reg) & 0xf00) >> 8
}
func (o *FTM_Type) SetFILTER_CH3FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf000)|value<<12)
}
func (o *FTM_Type) GetFILTER_CH3FVAL() uint32 {
	return (volatile.LoadUint32(&o.FILTER.Reg) & 0xf000) >> 12
}

// FTM.FLTCTRL: Fault Control
func (o *FTM_Type) SetFLTCTRL_FAULT0EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetFLTCTRL_FAULT0EN() uint32 {
	return volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x1
}
func (o *FTM_Type) SetFLTCTRL_FAULT1EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetFLTCTRL_FAULT1EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetFLTCTRL_FAULT2EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetFLTCTRL_FAULT2EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetFLTCTRL_FAULT3EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetFLTCTRL_FAULT3EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetFLTCTRL_FFLTR0EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetFLTCTRL_FFLTR0EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetFLTCTRL_FFLTR1EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetFLTCTRL_FFLTR1EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetFLTCTRL_FFLTR2EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetFLTCTRL_FFLTR2EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetFLTCTRL_FFLTR3EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetFLTCTRL_FFLTR3EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x80) >> 7
}
func (o *FTM_Type) SetFLTCTRL_FFVAL(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0xf00)|value<<8)
}
func (o *FTM_Type) GetFLTCTRL_FFVAL() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0xf00) >> 8
}

// FTM.QDCTRL: Quadrature Decoder Control And Status
func (o *FTM_Type) SetQDCTRL_QUADEN(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetQDCTRL_QUADEN() uint32 {
	return volatile.LoadUint32(&o.QDCTRL.Reg) & 0x1
}
func (o *FTM_Type) SetQDCTRL_TOFDIR(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetQDCTRL_TOFDIR() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetQDCTRL_QUADIR(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetQDCTRL_QUADIR() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetQDCTRL_QUADMODE(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetQDCTRL_QUADMODE() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetQDCTRL_PHBPOL(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetQDCTRL_PHBPOL() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetQDCTRL_PHAPOL(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetQDCTRL_PHAPOL() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetQDCTRL_PHBFLTREN(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetQDCTRL_PHBFLTREN() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetQDCTRL_PHAFLTREN(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetQDCTRL_PHAFLTREN() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x80) >> 7
}

// FTM.CONF: Configuration
func (o *FTM_Type) SetCONF_NUMTOF(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1f)|value)
}
func (o *FTM_Type) GetCONF_NUMTOF() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0x1f
}
func (o *FTM_Type) SetCONF_BDMMODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xc0)|value<<6)
}
func (o *FTM_Type) GetCONF_BDMMODE() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xc0) >> 6
}
func (o *FTM_Type) SetCONF_GTBEEN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x200)|value<<9)
}
func (o *FTM_Type) GetCONF_GTBEEN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x200) >> 9
}
func (o *FTM_Type) SetCONF_GTBEOUT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x400)|value<<10)
}
func (o *FTM_Type) GetCONF_GTBEOUT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x400) >> 10
}

// FTM.FLTPOL: FTM Fault Input Polarity
func (o *FTM_Type) SetFLTPOL_FLT0POL(value uint32) {
	volatile.StoreUint32(&o.FLTPOL.Reg, volatile.LoadUint32(&o.FLTPOL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetFLTPOL_FLT0POL() uint32 {
	return volatile.LoadUint32(&o.FLTPOL.Reg) & 0x1
}
func (o *FTM_Type) SetFLTPOL_FLT1POL(value uint32) {
	volatile.StoreUint32(&o.FLTPOL.Reg, volatile.LoadUint32(&o.FLTPOL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetFLTPOL_FLT1POL() uint32 {
	return (volatile.LoadUint32(&o.FLTPOL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetFLTPOL_FLT2POL(value uint32) {
	volatile.StoreUint32(&o.FLTPOL.Reg, volatile.LoadUint32(&o.FLTPOL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetFLTPOL_FLT2POL() uint32 {
	return (volatile.LoadUint32(&o.FLTPOL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetFLTPOL_FLT3POL(value uint32) {
	volatile.StoreUint32(&o.FLTPOL.Reg, volatile.LoadUint32(&o.FLTPOL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetFLTPOL_FLT3POL() uint32 {
	return (volatile.LoadUint32(&o.FLTPOL.Reg) & 0x8) >> 3
}

// FTM.SYNCONF: Synchronization Configuration
func (o *FTM_Type) SetSYNCONF_HWTRIGMODE(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetSYNCONF_HWTRIGMODE() uint32 {
	return volatile.LoadUint32(&o.SYNCONF.Reg) & 0x1
}
func (o *FTM_Type) SetSYNCONF_CNTINC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetSYNCONF_CNTINC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetSYNCONF_INVC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetSYNCONF_INVC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetSYNCONF_SWOC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetSYNCONF_SWOC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetSYNCONF_SYNCMODE(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetSYNCONF_SYNCMODE() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x80) >> 7
}
func (o *FTM_Type) SetSYNCONF_SWRSTCNT(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x100)|value<<8)
}
func (o *FTM_Type) GetSYNCONF_SWRSTCNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x100) >> 8
}
func (o *FTM_Type) SetSYNCONF_SWWRBUF(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x200)|value<<9)
}
func (o *FTM_Type) GetSYNCONF_SWWRBUF() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x200) >> 9
}
func (o *FTM_Type) SetSYNCONF_SWOM(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x400)|value<<10)
}
func (o *FTM_Type) GetSYNCONF_SWOM() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x400) >> 10
}
func (o *FTM_Type) SetSYNCONF_SWINVC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x800)|value<<11)
}
func (o *FTM_Type) GetSYNCONF_SWINVC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x800) >> 11
}
func (o *FTM_Type) SetSYNCONF_SWSOC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x1000)|value<<12)
}
func (o *FTM_Type) GetSYNCONF_SWSOC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x1000) >> 12
}
func (o *FTM_Type) SetSYNCONF_HWRSTCNT(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x10000)|value<<16)
}
func (o *FTM_Type) GetSYNCONF_HWRSTCNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x10000) >> 16
}
func (o *FTM_Type) SetSYNCONF_HWWRBUF(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x20000)|value<<17)
}
func (o *FTM_Type) GetSYNCONF_HWWRBUF() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x20000) >> 17
}
func (o *FTM_Type) SetSYNCONF_HWOM(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x40000)|value<<18)
}
func (o *FTM_Type) GetSYNCONF_HWOM() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x40000) >> 18
}
func (o *FTM_Type) SetSYNCONF_HWINVC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x80000)|value<<19)
}
func (o *FTM_Type) GetSYNCONF_HWINVC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x80000) >> 19
}
func (o *FTM_Type) SetSYNCONF_HWSOC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x100000)|value<<20)
}
func (o *FTM_Type) GetSYNCONF_HWSOC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x100000) >> 20
}

// FTM.INVCTRL: FTM Inverting Control
func (o *FTM_Type) SetINVCTRL_INV0EN(value uint32) {
	volatile.StoreUint32(&o.INVCTRL.Reg, volatile.LoadUint32(&o.INVCTRL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetINVCTRL_INV0EN() uint32 {
	return volatile.LoadUint32(&o.INVCTRL.Reg) & 0x1
}
func (o *FTM_Type) SetINVCTRL_INV1EN(value uint32) {
	volatile.StoreUint32(&o.INVCTRL.Reg, volatile.LoadUint32(&o.INVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetINVCTRL_INV1EN() uint32 {
	return (volatile.LoadUint32(&o.INVCTRL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetINVCTRL_INV2EN(value uint32) {
	volatile.StoreUint32(&o.INVCTRL.Reg, volatile.LoadUint32(&o.INVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetINVCTRL_INV2EN() uint32 {
	return (volatile.LoadUint32(&o.INVCTRL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetINVCTRL_INV3EN(value uint32) {
	volatile.StoreUint32(&o.INVCTRL.Reg, volatile.LoadUint32(&o.INVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetINVCTRL_INV3EN() uint32 {
	return (volatile.LoadUint32(&o.INVCTRL.Reg) & 0x8) >> 3
}

// FTM.SWOCTRL: FTM Software Output Control
func (o *FTM_Type) SetSWOCTRL_CH0OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetSWOCTRL_CH0OC() uint32 {
	return volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x1
}
func (o *FTM_Type) SetSWOCTRL_CH1OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetSWOCTRL_CH1OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetSWOCTRL_CH2OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetSWOCTRL_CH2OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetSWOCTRL_CH3OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetSWOCTRL_CH3OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetSWOCTRL_CH4OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetSWOCTRL_CH4OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetSWOCTRL_CH5OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetSWOCTRL_CH5OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetSWOCTRL_CH6OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetSWOCTRL_CH6OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetSWOCTRL_CH7OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetSWOCTRL_CH7OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x80) >> 7
}
func (o *FTM_Type) SetSWOCTRL_CH0OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x100)|value<<8)
}
func (o *FTM_Type) GetSWOCTRL_CH0OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x100) >> 8
}
func (o *FTM_Type) SetSWOCTRL_CH1OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x200)|value<<9)
}
func (o *FTM_Type) GetSWOCTRL_CH1OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x200) >> 9
}
func (o *FTM_Type) SetSWOCTRL_CH2OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x400)|value<<10)
}
func (o *FTM_Type) GetSWOCTRL_CH2OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x400) >> 10
}
func (o *FTM_Type) SetSWOCTRL_CH3OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x800)|value<<11)
}
func (o *FTM_Type) GetSWOCTRL_CH3OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x800) >> 11
}
func (o *FTM_Type) SetSWOCTRL_CH4OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *FTM_Type) GetSWOCTRL_CH4OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x1000) >> 12
}
func (o *FTM_Type) SetSWOCTRL_CH5OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *FTM_Type) GetSWOCTRL_CH5OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x2000) >> 13
}
func (o *FTM_Type) SetSWOCTRL_CH6OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *FTM_Type) GetSWOCTRL_CH6OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x4000) >> 14
}
func (o *FTM_Type) SetSWOCTRL_CH7OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *FTM_Type) GetSWOCTRL_CH7OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x8000) >> 15
}

// FTM.PWMLOAD: FTM PWM Load
func (o *FTM_Type) SetPWMLOAD_CH0SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetPWMLOAD_CH0SEL() uint32 {
	return volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x1
}
func (o *FTM_Type) SetPWMLOAD_CH1SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetPWMLOAD_CH1SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetPWMLOAD_CH2SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetPWMLOAD_CH2SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetPWMLOAD_CH3SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetPWMLOAD_CH3SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetPWMLOAD_CH4SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetPWMLOAD_CH4SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetPWMLOAD_CH5SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetPWMLOAD_CH5SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetPWMLOAD_CH6SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetPWMLOAD_CH6SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetPWMLOAD_CH7SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetPWMLOAD_CH7SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x80) >> 7
}
func (o *FTM_Type) SetPWMLOAD_LDOK(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x200)|value<<9)
}
func (o *FTM_Type) GetPWMLOAD_LDOK() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x200) >> 9
}

// Analog-to-Digital Converter
type ADC_Type struct {
	SC1A volatile.Register32 // 0x0
	SC1B volatile.Register32 // 0x4
	CFG1 volatile.Register32 // 0x8
	CFG2 volatile.Register32 // 0xC
	RA   volatile.Register32 // 0x10
	RB   volatile.Register32 // 0x14
	CV1  volatile.Register32 // 0x18
	CV2  volatile.Register32 // 0x1C
	SC2  volatile.Register32 // 0x20
	SC3  volatile.Register32 // 0x24
	OFS  volatile.Register32 // 0x28
	PG   volatile.Register32 // 0x2C
	MG   volatile.Register32 // 0x30
	CLPD volatile.Register32 // 0x34
	CLPS volatile.Register32 // 0x38
	CLP4 volatile.Register32 // 0x3C
	CLP3 volatile.Register32 // 0x40
	CLP2 volatile.Register32 // 0x44
	CLP1 volatile.Register32 // 0x48
	CLP0 volatile.Register32 // 0x4C
	_    [4]byte
	CLMD volatile.Register32 // 0x54
	CLMS volatile.Register32 // 0x58
	CLM4 volatile.Register32 // 0x5C
	CLM3 volatile.Register32 // 0x60
	CLM2 volatile.Register32 // 0x64
	CLM1 volatile.Register32 // 0x68
	CLM0 volatile.Register32 // 0x6C
}

// ADC.SC1A: ADC Status and Control Registers 1
func (o *ADC_Type) SetSC1A_ADCH(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSC1A_ADCH() uint32 {
	return volatile.LoadUint32(&o.SC1A.Reg) & 0x1f
}
func (o *ADC_Type) SetSC1A_DIFF(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSC1A_DIFF() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSC1A_AIEN(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSC1A_AIEN() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSC1A_COCO(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSC1A_COCO() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x80) >> 7
}

// ADC.SC1B: ADC Status and Control Registers 1
func (o *ADC_Type) SetSC1B_ADCH(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSC1B_ADCH() uint32 {
	return volatile.LoadUint32(&o.SC1B.Reg) & 0x1f
}
func (o *ADC_Type) SetSC1B_DIFF(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSC1B_DIFF() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSC1B_AIEN(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSC1B_AIEN() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSC1B_COCO(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSC1B_COCO() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x80) >> 7
}

// ADC.CFG1: ADC Configuration Register 1
func (o *ADC_Type) SetCFG1_ADICLK(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetCFG1_ADICLK() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0x3
}
func (o *ADC_Type) SetCFG1_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xc)|value<<2)
}
func (o *ADC_Type) GetCFG1_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xc) >> 2
}
func (o *ADC_Type) SetCFG1_ADLSMP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCFG1_ADLSMP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCFG1_ADIV(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x60)|value<<5)
}
func (o *ADC_Type) GetCFG1_ADIV() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x60) >> 5
}
func (o *ADC_Type) SetCFG1_ADLPC(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCFG1_ADLPC() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x80) >> 7
}

// ADC.CFG2: ADC Configuration Register 2
func (o *ADC_Type) SetCFG2_ADLSTS(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetCFG2_ADLSTS() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0x3
}
func (o *ADC_Type) SetCFG2_ADHSC(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCFG2_ADHSC() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCFG2_ADACKEN(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCFG2_ADACKEN() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCFG2_MUXSEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCFG2_MUXSEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10) >> 4
}

// ADC.RA: ADC Data Result Register
func (o *ADC_Type) SetRA_D(value uint32) {
	volatile.StoreUint32(&o.RA.Reg, volatile.LoadUint32(&o.RA.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRA_D() uint32 {
	return volatile.LoadUint32(&o.RA.Reg) & 0xffff
}

// ADC.RB: ADC Data Result Register
func (o *ADC_Type) SetRB_D(value uint32) {
	volatile.StoreUint32(&o.RB.Reg, volatile.LoadUint32(&o.RB.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRB_D() uint32 {
	return volatile.LoadUint32(&o.RB.Reg) & 0xffff
}

// ADC.CV1: Compare Value Registers
func (o *ADC_Type) SetCV1_CV(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, volatile.LoadUint32(&o.CV1.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetCV1_CV() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg) & 0xffff
}

// ADC.CV2: Compare Value Registers
func (o *ADC_Type) SetCV2_CV(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, volatile.LoadUint32(&o.CV2.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetCV2_CV() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg) & 0xffff
}

// ADC.SC2: Status and Control Register 2
func (o *ADC_Type) SetSC2_REFSEL(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetSC2_REFSEL() uint32 {
	return volatile.LoadUint32(&o.SC2.Reg) & 0x3
}
func (o *ADC_Type) SetSC2_DMAEN(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSC2_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSC2_ACREN(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSC2_ACREN() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSC2_ACFGT(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetSC2_ACFGT() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetSC2_ACFE(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSC2_ACFE() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSC2_ADTRG(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSC2_ADTRG() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSC2_ADACT(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSC2_ADACT() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x80) >> 7
}

// ADC.SC3: Status and Control Register 3
func (o *ADC_Type) SetSC3_AVGS(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetSC3_AVGS() uint32 {
	return volatile.LoadUint32(&o.SC3.Reg) & 0x3
}
func (o *ADC_Type) SetSC3_AVGE(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSC3_AVGE() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSC3_ADCO(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSC3_ADCO() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSC3_CALF(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSC3_CALF() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSC3_CAL(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSC3_CAL() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x80) >> 7
}

// ADC.OFS: ADC Offset Correction Register
func (o *ADC_Type) SetOFS(value uint32) {
	volatile.StoreUint32(&o.OFS.Reg, volatile.LoadUint32(&o.OFS.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetOFS() uint32 {
	return volatile.LoadUint32(&o.OFS.Reg) & 0xffff
}

// ADC.PG: ADC Plus-Side Gain Register
func (o *ADC_Type) SetPG(value uint32) {
	volatile.StoreUint32(&o.PG.Reg, volatile.LoadUint32(&o.PG.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetPG() uint32 {
	return volatile.LoadUint32(&o.PG.Reg) & 0xffff
}

// ADC.MG: ADC Minus-Side Gain Register
func (o *ADC_Type) SetMG(value uint32) {
	volatile.StoreUint32(&o.MG.Reg, volatile.LoadUint32(&o.MG.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetMG() uint32 {
	return volatile.LoadUint32(&o.MG.Reg) & 0xffff
}

// ADC.CLPD: ADC Plus-Side General Calibration Value Register
func (o *ADC_Type) SetCLPD(value uint32) {
	volatile.StoreUint32(&o.CLPD.Reg, volatile.LoadUint32(&o.CLPD.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetCLPD() uint32 {
	return volatile.LoadUint32(&o.CLPD.Reg) & 0x3f
}

// ADC.CLPS: ADC Plus-Side General Calibration Value Register
func (o *ADC_Type) SetCLPS(value uint32) {
	volatile.StoreUint32(&o.CLPS.Reg, volatile.LoadUint32(&o.CLPS.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetCLPS() uint32 {
	return volatile.LoadUint32(&o.CLPS.Reg) & 0x3f
}

// ADC.CLP4: ADC Plus-Side General Calibration Value Register
func (o *ADC_Type) SetCLP4(value uint32) {
	volatile.StoreUint32(&o.CLP4.Reg, volatile.LoadUint32(&o.CLP4.Reg)&^(0x3ff)|value)
}
func (o *ADC_Type) GetCLP4() uint32 {
	return volatile.LoadUint32(&o.CLP4.Reg) & 0x3ff
}

// ADC.CLP3: ADC Plus-Side General Calibration Value Register
func (o *ADC_Type) SetCLP3(value uint32) {
	volatile.StoreUint32(&o.CLP3.Reg, volatile.LoadUint32(&o.CLP3.Reg)&^(0x1ff)|value)
}
func (o *ADC_Type) GetCLP3() uint32 {
	return volatile.LoadUint32(&o.CLP3.Reg) & 0x1ff
}

// ADC.CLP2: ADC Plus-Side General Calibration Value Register
func (o *ADC_Type) SetCLP2(value uint32) {
	volatile.StoreUint32(&o.CLP2.Reg, volatile.LoadUint32(&o.CLP2.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetCLP2() uint32 {
	return volatile.LoadUint32(&o.CLP2.Reg) & 0xff
}

// ADC.CLP1: ADC Plus-Side General Calibration Value Register
func (o *ADC_Type) SetCLP1(value uint32) {
	volatile.StoreUint32(&o.CLP1.Reg, volatile.LoadUint32(&o.CLP1.Reg)&^(0x7f)|value)
}
func (o *ADC_Type) GetCLP1() uint32 {
	return volatile.LoadUint32(&o.CLP1.Reg) & 0x7f
}

// ADC.CLP0: ADC Plus-Side General Calibration Value Register
func (o *ADC_Type) SetCLP0(value uint32) {
	volatile.StoreUint32(&o.CLP0.Reg, volatile.LoadUint32(&o.CLP0.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetCLP0() uint32 {
	return volatile.LoadUint32(&o.CLP0.Reg) & 0x3f
}

// ADC.CLMD: ADC Minus-Side General Calibration Value Register
func (o *ADC_Type) SetCLMD(value uint32) {
	volatile.StoreUint32(&o.CLMD.Reg, volatile.LoadUint32(&o.CLMD.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetCLMD() uint32 {
	return volatile.LoadUint32(&o.CLMD.Reg) & 0x3f
}

// ADC.CLMS: ADC Minus-Side General Calibration Value Register
func (o *ADC_Type) SetCLMS(value uint32) {
	volatile.StoreUint32(&o.CLMS.Reg, volatile.LoadUint32(&o.CLMS.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetCLMS() uint32 {
	return volatile.LoadUint32(&o.CLMS.Reg) & 0x3f
}

// ADC.CLM4: ADC Minus-Side General Calibration Value Register
func (o *ADC_Type) SetCLM4(value uint32) {
	volatile.StoreUint32(&o.CLM4.Reg, volatile.LoadUint32(&o.CLM4.Reg)&^(0x3ff)|value)
}
func (o *ADC_Type) GetCLM4() uint32 {
	return volatile.LoadUint32(&o.CLM4.Reg) & 0x3ff
}

// ADC.CLM3: ADC Minus-Side General Calibration Value Register
func (o *ADC_Type) SetCLM3(value uint32) {
	volatile.StoreUint32(&o.CLM3.Reg, volatile.LoadUint32(&o.CLM3.Reg)&^(0x1ff)|value)
}
func (o *ADC_Type) GetCLM3() uint32 {
	return volatile.LoadUint32(&o.CLM3.Reg) & 0x1ff
}

// ADC.CLM2: ADC Minus-Side General Calibration Value Register
func (o *ADC_Type) SetCLM2(value uint32) {
	volatile.StoreUint32(&o.CLM2.Reg, volatile.LoadUint32(&o.CLM2.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetCLM2() uint32 {
	return volatile.LoadUint32(&o.CLM2.Reg) & 0xff
}

// ADC.CLM1: ADC Minus-Side General Calibration Value Register
func (o *ADC_Type) SetCLM1(value uint32) {
	volatile.StoreUint32(&o.CLM1.Reg, volatile.LoadUint32(&o.CLM1.Reg)&^(0x7f)|value)
}
func (o *ADC_Type) GetCLM1() uint32 {
	return volatile.LoadUint32(&o.CLM1.Reg) & 0x7f
}

// ADC.CLM0: ADC Minus-Side General Calibration Value Register
func (o *ADC_Type) SetCLM0(value uint32) {
	volatile.StoreUint32(&o.CLM0.Reg, volatile.LoadUint32(&o.CLM0.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetCLM0() uint32 {
	return volatile.LoadUint32(&o.CLM0.Reg) & 0x3f
}

// 12-Bit Digital-to-Analog Converter
type DAC_Type struct {
	DAT0L  volatile.Register8 // 0x0
	DAT0H  volatile.Register8 // 0x1
	DAT1L  volatile.Register8 // 0x2
	DAT1H  volatile.Register8 // 0x3
	DAT2L  volatile.Register8 // 0x4
	DAT2H  volatile.Register8 // 0x5
	DAT3L  volatile.Register8 // 0x6
	DAT3H  volatile.Register8 // 0x7
	DAT4L  volatile.Register8 // 0x8
	DAT4H  volatile.Register8 // 0x9
	DAT5L  volatile.Register8 // 0xA
	DAT5H  volatile.Register8 // 0xB
	DAT6L  volatile.Register8 // 0xC
	DAT6H  volatile.Register8 // 0xD
	DAT7L  volatile.Register8 // 0xE
	DAT7H  volatile.Register8 // 0xF
	DAT8L  volatile.Register8 // 0x10
	DAT8H  volatile.Register8 // 0x11
	DAT9L  volatile.Register8 // 0x12
	DAT9H  volatile.Register8 // 0x13
	DAT10L volatile.Register8 // 0x14
	DAT10H volatile.Register8 // 0x15
	DAT11L volatile.Register8 // 0x16
	DAT11H volatile.Register8 // 0x17
	DAT12L volatile.Register8 // 0x18
	DAT12H volatile.Register8 // 0x19
	DAT13L volatile.Register8 // 0x1A
	DAT13H volatile.Register8 // 0x1B
	DAT14L volatile.Register8 // 0x1C
	DAT14H volatile.Register8 // 0x1D
	DAT15L volatile.Register8 // 0x1E
	DAT15H volatile.Register8 // 0x1F
	SR     volatile.Register8 // 0x20
	C0     volatile.Register8 // 0x21
	C1     volatile.Register8 // 0x22
	C2     volatile.Register8 // 0x23
}

// DAC.DAT0L: DAC Data Low Register
func (o *DAC_Type) SetDAT0L(value uint8) {
	volatile.StoreUint8(&o.DAT0L.Reg, value)
}
func (o *DAC_Type) GetDAT0L() uint8 {
	return volatile.LoadUint8(&o.DAT0L.Reg)
}

// DAC.DAT0H: DAC Data High Register
func (o *DAC_Type) SetDAT0H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT0H.Reg, volatile.LoadUint8(&o.DAT0H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT0H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT0H.Reg) & 0xf
}

// DAC.DAT1L: DAC Data Low Register
func (o *DAC_Type) SetDAT1L(value uint8) {
	volatile.StoreUint8(&o.DAT1L.Reg, value)
}
func (o *DAC_Type) GetDAT1L() uint8 {
	return volatile.LoadUint8(&o.DAT1L.Reg)
}

// DAC.DAT1H: DAC Data High Register
func (o *DAC_Type) SetDAT1H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT1H.Reg, volatile.LoadUint8(&o.DAT1H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT1H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT1H.Reg) & 0xf
}

// DAC.DAT2L: DAC Data Low Register
func (o *DAC_Type) SetDAT2L(value uint8) {
	volatile.StoreUint8(&o.DAT2L.Reg, value)
}
func (o *DAC_Type) GetDAT2L() uint8 {
	return volatile.LoadUint8(&o.DAT2L.Reg)
}

// DAC.DAT2H: DAC Data High Register
func (o *DAC_Type) SetDAT2H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT2H.Reg, volatile.LoadUint8(&o.DAT2H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT2H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT2H.Reg) & 0xf
}

// DAC.DAT3L: DAC Data Low Register
func (o *DAC_Type) SetDAT3L(value uint8) {
	volatile.StoreUint8(&o.DAT3L.Reg, value)
}
func (o *DAC_Type) GetDAT3L() uint8 {
	return volatile.LoadUint8(&o.DAT3L.Reg)
}

// DAC.DAT3H: DAC Data High Register
func (o *DAC_Type) SetDAT3H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT3H.Reg, volatile.LoadUint8(&o.DAT3H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT3H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT3H.Reg) & 0xf
}

// DAC.DAT4L: DAC Data Low Register
func (o *DAC_Type) SetDAT4L(value uint8) {
	volatile.StoreUint8(&o.DAT4L.Reg, value)
}
func (o *DAC_Type) GetDAT4L() uint8 {
	return volatile.LoadUint8(&o.DAT4L.Reg)
}

// DAC.DAT4H: DAC Data High Register
func (o *DAC_Type) SetDAT4H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT4H.Reg, volatile.LoadUint8(&o.DAT4H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT4H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT4H.Reg) & 0xf
}

// DAC.DAT5L: DAC Data Low Register
func (o *DAC_Type) SetDAT5L(value uint8) {
	volatile.StoreUint8(&o.DAT5L.Reg, value)
}
func (o *DAC_Type) GetDAT5L() uint8 {
	return volatile.LoadUint8(&o.DAT5L.Reg)
}

// DAC.DAT5H: DAC Data High Register
func (o *DAC_Type) SetDAT5H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT5H.Reg, volatile.LoadUint8(&o.DAT5H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT5H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT5H.Reg) & 0xf
}

// DAC.DAT6L: DAC Data Low Register
func (o *DAC_Type) SetDAT6L(value uint8) {
	volatile.StoreUint8(&o.DAT6L.Reg, value)
}
func (o *DAC_Type) GetDAT6L() uint8 {
	return volatile.LoadUint8(&o.DAT6L.Reg)
}

// DAC.DAT6H: DAC Data High Register
func (o *DAC_Type) SetDAT6H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT6H.Reg, volatile.LoadUint8(&o.DAT6H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT6H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT6H.Reg) & 0xf
}

// DAC.DAT7L: DAC Data Low Register
func (o *DAC_Type) SetDAT7L(value uint8) {
	volatile.StoreUint8(&o.DAT7L.Reg, value)
}
func (o *DAC_Type) GetDAT7L() uint8 {
	return volatile.LoadUint8(&o.DAT7L.Reg)
}

// DAC.DAT7H: DAC Data High Register
func (o *DAC_Type) SetDAT7H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT7H.Reg, volatile.LoadUint8(&o.DAT7H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT7H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT7H.Reg) & 0xf
}

// DAC.DAT8L: DAC Data Low Register
func (o *DAC_Type) SetDAT8L(value uint8) {
	volatile.StoreUint8(&o.DAT8L.Reg, value)
}
func (o *DAC_Type) GetDAT8L() uint8 {
	return volatile.LoadUint8(&o.DAT8L.Reg)
}

// DAC.DAT8H: DAC Data High Register
func (o *DAC_Type) SetDAT8H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT8H.Reg, volatile.LoadUint8(&o.DAT8H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT8H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT8H.Reg) & 0xf
}

// DAC.DAT9L: DAC Data Low Register
func (o *DAC_Type) SetDAT9L(value uint8) {
	volatile.StoreUint8(&o.DAT9L.Reg, value)
}
func (o *DAC_Type) GetDAT9L() uint8 {
	return volatile.LoadUint8(&o.DAT9L.Reg)
}

// DAC.DAT9H: DAC Data High Register
func (o *DAC_Type) SetDAT9H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT9H.Reg, volatile.LoadUint8(&o.DAT9H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT9H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT9H.Reg) & 0xf
}

// DAC.DAT10L: DAC Data Low Register
func (o *DAC_Type) SetDAT10L(value uint8) {
	volatile.StoreUint8(&o.DAT10L.Reg, value)
}
func (o *DAC_Type) GetDAT10L() uint8 {
	return volatile.LoadUint8(&o.DAT10L.Reg)
}

// DAC.DAT10H: DAC Data High Register
func (o *DAC_Type) SetDAT10H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT10H.Reg, volatile.LoadUint8(&o.DAT10H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT10H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT10H.Reg) & 0xf
}

// DAC.DAT11L: DAC Data Low Register
func (o *DAC_Type) SetDAT11L(value uint8) {
	volatile.StoreUint8(&o.DAT11L.Reg, value)
}
func (o *DAC_Type) GetDAT11L() uint8 {
	return volatile.LoadUint8(&o.DAT11L.Reg)
}

// DAC.DAT11H: DAC Data High Register
func (o *DAC_Type) SetDAT11H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT11H.Reg, volatile.LoadUint8(&o.DAT11H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT11H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT11H.Reg) & 0xf
}

// DAC.DAT12L: DAC Data Low Register
func (o *DAC_Type) SetDAT12L(value uint8) {
	volatile.StoreUint8(&o.DAT12L.Reg, value)
}
func (o *DAC_Type) GetDAT12L() uint8 {
	return volatile.LoadUint8(&o.DAT12L.Reg)
}

// DAC.DAT12H: DAC Data High Register
func (o *DAC_Type) SetDAT12H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT12H.Reg, volatile.LoadUint8(&o.DAT12H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT12H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT12H.Reg) & 0xf
}

// DAC.DAT13L: DAC Data Low Register
func (o *DAC_Type) SetDAT13L(value uint8) {
	volatile.StoreUint8(&o.DAT13L.Reg, value)
}
func (o *DAC_Type) GetDAT13L() uint8 {
	return volatile.LoadUint8(&o.DAT13L.Reg)
}

// DAC.DAT13H: DAC Data High Register
func (o *DAC_Type) SetDAT13H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT13H.Reg, volatile.LoadUint8(&o.DAT13H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT13H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT13H.Reg) & 0xf
}

// DAC.DAT14L: DAC Data Low Register
func (o *DAC_Type) SetDAT14L(value uint8) {
	volatile.StoreUint8(&o.DAT14L.Reg, value)
}
func (o *DAC_Type) GetDAT14L() uint8 {
	return volatile.LoadUint8(&o.DAT14L.Reg)
}

// DAC.DAT14H: DAC Data High Register
func (o *DAC_Type) SetDAT14H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT14H.Reg, volatile.LoadUint8(&o.DAT14H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT14H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT14H.Reg) & 0xf
}

// DAC.DAT15L: DAC Data Low Register
func (o *DAC_Type) SetDAT15L(value uint8) {
	volatile.StoreUint8(&o.DAT15L.Reg, value)
}
func (o *DAC_Type) GetDAT15L() uint8 {
	return volatile.LoadUint8(&o.DAT15L.Reg)
}

// DAC.DAT15H: DAC Data High Register
func (o *DAC_Type) SetDAT15H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT15H.Reg, volatile.LoadUint8(&o.DAT15H.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetDAT15H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT15H.Reg) & 0xf
}

// DAC.SR: DAC Status Register
func (o *DAC_Type) SetSR_DACBFRPBF(value uint8) {
	volatile.StoreUint8(&o.SR.Reg, volatile.LoadUint8(&o.SR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSR_DACBFRPBF() uint8 {
	return volatile.LoadUint8(&o.SR.Reg) & 0x1
}
func (o *DAC_Type) SetSR_DACBFRPTF(value uint8) {
	volatile.StoreUint8(&o.SR.Reg, volatile.LoadUint8(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSR_DACBFRPTF() uint8 {
	return (volatile.LoadUint8(&o.SR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetSR_DACBFWMF(value uint8) {
	volatile.StoreUint8(&o.SR.Reg, volatile.LoadUint8(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetSR_DACBFWMF() uint8 {
	return (volatile.LoadUint8(&o.SR.Reg) & 0x4) >> 2
}

// DAC.C0: DAC Control Register
func (o *DAC_Type) SetC0_DACBBIEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetC0_DACBBIEN() uint8 {
	return volatile.LoadUint8(&o.C0.Reg) & 0x1
}
func (o *DAC_Type) SetC0_DACBTIEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetC0_DACBTIEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetC0_DACBWIEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetC0_DACBWIEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetC0_LPEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x8)|value<<3)
}
func (o *DAC_Type) GetC0_LPEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x8) >> 3
}
func (o *DAC_Type) SetC0_DACSWTRG(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x10)|value<<4)
}
func (o *DAC_Type) GetC0_DACSWTRG() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x10) >> 4
}
func (o *DAC_Type) SetC0_DACTRGSEL(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x20)|value<<5)
}
func (o *DAC_Type) GetC0_DACTRGSEL() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x20) >> 5
}
func (o *DAC_Type) SetC0_DACRFS(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x40)|value<<6)
}
func (o *DAC_Type) GetC0_DACRFS() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x40) >> 6
}
func (o *DAC_Type) SetC0_DACEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x80)|value<<7)
}
func (o *DAC_Type) GetC0_DACEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x80) >> 7
}

// DAC.C1: DAC Control Register 1
func (o *DAC_Type) SetC1_DACBFEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetC1_DACBFEN() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *DAC_Type) SetC1_DACBFMD(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x6)|value<<1)
}
func (o *DAC_Type) GetC1_DACBFMD() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x6) >> 1
}
func (o *DAC_Type) SetC1_DACBFWM(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x18)|value<<3)
}
func (o *DAC_Type) GetC1_DACBFWM() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x18) >> 3
}
func (o *DAC_Type) SetC1_DMAEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x80)|value<<7)
}
func (o *DAC_Type) GetC1_DMAEN() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x80) >> 7
}

// DAC.C2: DAC Control Register 2
func (o *DAC_Type) SetC2_DACBFUP(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0xf)|value)
}
func (o *DAC_Type) GetC2_DACBFUP() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0xf
}
func (o *DAC_Type) SetC2_DACBFRP(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0xf0)|value<<4)
}
func (o *DAC_Type) GetC2_DACBFRP() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0xf0) >> 4
}

// Random Number Generator Accelerator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	ER volatile.Register32 // 0x8
	OR volatile.Register32 // 0xC
}

// RNG.CR: RNGA Control Register
func (o *RNG_Type) SetCR_GO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetCR_GO() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RNG_Type) SetCR_HA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetCR_HA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetCR_INTM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_INTM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetCR_CLRI(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_CLRI() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_SLP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RNG_Type) GetCR_SLP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}

// RNG.SR: RNGA Status Register
func (o *RNG_Type) SetSR_SECV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_SECV() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RNG_Type) SetSR_LRS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_LRS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_ORU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_ORU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_ERRI(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetSR_ERRI() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetSR_SLP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *RNG_Type) GetSR_SLP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *RNG_Type) SetSR_OREG_LVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xff00)|value<<8)
}
func (o *RNG_Type) GetSR_OREG_LVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xff00) >> 8
}
func (o *RNG_Type) SetSR_OREG_SIZE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xff0000)|value<<16)
}
func (o *RNG_Type) GetSR_OREG_SIZE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xff0000) >> 16
}

// RNG.ER: RNGA Entropy Register
func (o *RNG_Type) SetER(value uint32) {
	volatile.StoreUint32(&o.ER.Reg, value)
}
func (o *RNG_Type) GetER() uint32 {
	return volatile.LoadUint32(&o.ER.Reg)
}

// RNG.OR: RNGA Output Register
func (o *RNG_Type) SetOR(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, value)
}
func (o *RNG_Type) GetOR() uint32 {
	return volatile.LoadUint32(&o.OR.Reg)
}

// Universal Asynchronous Receiver/Transmitter
type LPUART0_Type struct {
	BAUD  volatile.Register32 // 0x0
	STAT  volatile.Register32 // 0x4
	CTRL  volatile.Register32 // 0x8
	DATA  volatile.Register32 // 0xC
	MATCH volatile.Register32 // 0x10
	MODIR volatile.Register32 // 0x14
}

// LPUART0.BAUD: LPUART Baud Rate Register
func (o *LPUART0_Type) SetBAUD_SBR(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x1fff)|value)
}
func (o *LPUART0_Type) GetBAUD_SBR() uint32 {
	return volatile.LoadUint32(&o.BAUD.Reg) & 0x1fff
}
func (o *LPUART0_Type) SetBAUD_SBNS(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x2000)|value<<13)
}
func (o *LPUART0_Type) GetBAUD_SBNS() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x2000) >> 13
}
func (o *LPUART0_Type) SetBAUD_RXEDGIE(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART0_Type) GetBAUD_RXEDGIE() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x4000) >> 14
}
func (o *LPUART0_Type) SetBAUD_LBKDIE(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART0_Type) GetBAUD_LBKDIE() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x8000) >> 15
}
func (o *LPUART0_Type) SetBAUD_RESYNCDIS(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART0_Type) GetBAUD_RESYNCDIS() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x10000) >> 16
}
func (o *LPUART0_Type) SetBAUD_BOTHEDGE(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART0_Type) GetBAUD_BOTHEDGE() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x20000) >> 17
}
func (o *LPUART0_Type) SetBAUD_MATCFG(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xc0000)|value<<18)
}
func (o *LPUART0_Type) GetBAUD_MATCFG() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xc0000) >> 18
}
func (o *LPUART0_Type) SetBAUD_RDMAE(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x200000)|value<<21)
}
func (o *LPUART0_Type) GetBAUD_RDMAE() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x200000) >> 21
}
func (o *LPUART0_Type) SetBAUD_TDMAE(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART0_Type) GetBAUD_TDMAE() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x800000) >> 23
}
func (o *LPUART0_Type) SetBAUD_OSR(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x1f000000)|value<<24)
}
func (o *LPUART0_Type) GetBAUD_OSR() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x1f000000) >> 24
}
func (o *LPUART0_Type) SetBAUD_M10(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x20000000)|value<<29)
}
func (o *LPUART0_Type) GetBAUD_M10() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x20000000) >> 29
}
func (o *LPUART0_Type) SetBAUD_MAEN2(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x40000000)|value<<30)
}
func (o *LPUART0_Type) GetBAUD_MAEN2() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x40000000) >> 30
}
func (o *LPUART0_Type) SetBAUD_MAEN1(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x80000000)|value<<31)
}
func (o *LPUART0_Type) GetBAUD_MAEN1() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x80000000) >> 31
}

// LPUART0.STAT: LPUART Status Register
func (o *LPUART0_Type) SetSTAT_MA2F(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART0_Type) GetSTAT_MA2F() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000) >> 14
}
func (o *LPUART0_Type) SetSTAT_MA1F(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART0_Type) GetSTAT_MA1F() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000) >> 15
}
func (o *LPUART0_Type) SetSTAT_PF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART0_Type) GetSTAT_PF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000) >> 16
}
func (o *LPUART0_Type) SetSTAT_FE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART0_Type) GetSTAT_FE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20000) >> 17
}
func (o *LPUART0_Type) SetSTAT_NF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART0_Type) GetSTAT_NF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40000) >> 18
}
func (o *LPUART0_Type) SetSTAT_OR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80000)|value<<19)
}
func (o *LPUART0_Type) GetSTAT_OR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80000) >> 19
}
func (o *LPUART0_Type) SetSTAT_IDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x100000)|value<<20)
}
func (o *LPUART0_Type) GetSTAT_IDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x100000) >> 20
}
func (o *LPUART0_Type) SetSTAT_RDRF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x200000)|value<<21)
}
func (o *LPUART0_Type) GetSTAT_RDRF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x200000) >> 21
}
func (o *LPUART0_Type) SetSTAT_TC(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x400000)|value<<22)
}
func (o *LPUART0_Type) GetSTAT_TC() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x400000) >> 22
}
func (o *LPUART0_Type) SetSTAT_TDRE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART0_Type) GetSTAT_TDRE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x800000) >> 23
}
func (o *LPUART0_Type) SetSTAT_RAF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1000000)|value<<24)
}
func (o *LPUART0_Type) GetSTAT_RAF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x1000000) >> 24
}
func (o *LPUART0_Type) SetSTAT_LBKDE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2000000)|value<<25)
}
func (o *LPUART0_Type) GetSTAT_LBKDE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2000000) >> 25
}
func (o *LPUART0_Type) SetSTAT_BRK13(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000000)|value<<26)
}
func (o *LPUART0_Type) GetSTAT_BRK13() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000000) >> 26
}
func (o *LPUART0_Type) SetSTAT_RWUID(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000000)|value<<27)
}
func (o *LPUART0_Type) GetSTAT_RWUID() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000000) >> 27
}
func (o *LPUART0_Type) SetSTAT_RXINV(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000000)|value<<28)
}
func (o *LPUART0_Type) GetSTAT_RXINV() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000000) >> 28
}
func (o *LPUART0_Type) SetSTAT_MSBF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20000000)|value<<29)
}
func (o *LPUART0_Type) GetSTAT_MSBF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20000000) >> 29
}
func (o *LPUART0_Type) SetSTAT_RXEDGIF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40000000)|value<<30)
}
func (o *LPUART0_Type) GetSTAT_RXEDGIF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40000000) >> 30
}
func (o *LPUART0_Type) SetSTAT_LBKDIF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80000000)|value<<31)
}
func (o *LPUART0_Type) GetSTAT_LBKDIF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80000000) >> 31
}

// LPUART0.CTRL: LPUART Control Register
func (o *LPUART0_Type) SetCTRL_PT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *LPUART0_Type) GetCTRL_PT() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *LPUART0_Type) SetCTRL_PE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *LPUART0_Type) GetCTRL_PE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *LPUART0_Type) SetCTRL_ILT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *LPUART0_Type) GetCTRL_ILT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *LPUART0_Type) SetCTRL_WAKE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *LPUART0_Type) GetCTRL_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *LPUART0_Type) SetCTRL_M(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *LPUART0_Type) GetCTRL_M() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *LPUART0_Type) SetCTRL_RSRC(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *LPUART0_Type) GetCTRL_RSRC() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *LPUART0_Type) SetCTRL_DOZEEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *LPUART0_Type) GetCTRL_DOZEEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *LPUART0_Type) SetCTRL_LOOPS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *LPUART0_Type) GetCTRL_LOOPS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *LPUART0_Type) SetCTRL_IDLECFG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x700)|value<<8)
}
func (o *LPUART0_Type) GetCTRL_IDLECFG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x700) >> 8
}
func (o *LPUART0_Type) SetCTRL_MA2IE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART0_Type) GetCTRL_MA2IE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000) >> 14
}
func (o *LPUART0_Type) SetCTRL_MA1IE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART0_Type) GetCTRL_MA1IE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8000) >> 15
}
func (o *LPUART0_Type) SetCTRL_SBK(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART0_Type) GetCTRL_SBK() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *LPUART0_Type) SetCTRL_RWU(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART0_Type) GetCTRL_RWU() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000) >> 17
}
func (o *LPUART0_Type) SetCTRL_RE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART0_Type) GetCTRL_RE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *LPUART0_Type) SetCTRL_TE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *LPUART0_Type) GetCTRL_TE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *LPUART0_Type) SetCTRL_ILIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *LPUART0_Type) GetCTRL_ILIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *LPUART0_Type) SetCTRL_RIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *LPUART0_Type) GetCTRL_RIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200000) >> 21
}
func (o *LPUART0_Type) SetCTRL_TCIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *LPUART0_Type) GetCTRL_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400000) >> 22
}
func (o *LPUART0_Type) SetCTRL_TIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART0_Type) GetCTRL_TIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *LPUART0_Type) SetCTRL_PEIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *LPUART0_Type) GetCTRL_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}
func (o *LPUART0_Type) SetCTRL_FEIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *LPUART0_Type) GetCTRL_FEIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000000) >> 25
}
func (o *LPUART0_Type) SetCTRL_NEIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *LPUART0_Type) GetCTRL_NEIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000000) >> 26
}
func (o *LPUART0_Type) SetCTRL_ORIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *LPUART0_Type) GetCTRL_ORIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8000000) >> 27
}
func (o *LPUART0_Type) SetCTRL_TXINV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *LPUART0_Type) GetCTRL_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000000) >> 28
}
func (o *LPUART0_Type) SetCTRL_TXDIR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *LPUART0_Type) GetCTRL_TXDIR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000000) >> 29
}
func (o *LPUART0_Type) SetCTRL_R9T8(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *LPUART0_Type) GetCTRL_R9T8() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000000) >> 30
}
func (o *LPUART0_Type) SetCTRL_R8T9(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *LPUART0_Type) GetCTRL_R8T9() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000000) >> 31
}

// LPUART0.DATA: LPUART Data Register
func (o *LPUART0_Type) SetDATA_R0T0(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x1)|value)
}
func (o *LPUART0_Type) GetDATA_R0T0() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0x1
}
func (o *LPUART0_Type) SetDATA_R1T1(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x2)|value<<1)
}
func (o *LPUART0_Type) GetDATA_R1T1() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x2) >> 1
}
func (o *LPUART0_Type) SetDATA_R2T2(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x4)|value<<2)
}
func (o *LPUART0_Type) GetDATA_R2T2() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x4) >> 2
}
func (o *LPUART0_Type) SetDATA_R3T3(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x8)|value<<3)
}
func (o *LPUART0_Type) GetDATA_R3T3() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x8) >> 3
}
func (o *LPUART0_Type) SetDATA_R4T4(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x10)|value<<4)
}
func (o *LPUART0_Type) GetDATA_R4T4() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x10) >> 4
}
func (o *LPUART0_Type) SetDATA_R5T5(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x20)|value<<5)
}
func (o *LPUART0_Type) GetDATA_R5T5() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x20) >> 5
}
func (o *LPUART0_Type) SetDATA_R6T6(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x40)|value<<6)
}
func (o *LPUART0_Type) GetDATA_R6T6() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x40) >> 6
}
func (o *LPUART0_Type) SetDATA_R7T7(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x80)|value<<7)
}
func (o *LPUART0_Type) GetDATA_R7T7() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x80) >> 7
}
func (o *LPUART0_Type) SetDATA_R8T8(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x100)|value<<8)
}
func (o *LPUART0_Type) GetDATA_R8T8() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x100) >> 8
}
func (o *LPUART0_Type) SetDATA_R9T9(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x200)|value<<9)
}
func (o *LPUART0_Type) GetDATA_R9T9() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x200) >> 9
}
func (o *LPUART0_Type) SetDATA_IDLINE(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x800)|value<<11)
}
func (o *LPUART0_Type) GetDATA_IDLINE() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x800) >> 11
}
func (o *LPUART0_Type) SetDATA_RXEMPT(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x1000)|value<<12)
}
func (o *LPUART0_Type) GetDATA_RXEMPT() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x1000) >> 12
}
func (o *LPUART0_Type) SetDATA_FRETSC(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x2000)|value<<13)
}
func (o *LPUART0_Type) GetDATA_FRETSC() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x2000) >> 13
}
func (o *LPUART0_Type) SetDATA_PARITYE(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART0_Type) GetDATA_PARITYE() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x4000) >> 14
}
func (o *LPUART0_Type) SetDATA_NOISY(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART0_Type) GetDATA_NOISY() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x8000) >> 15
}

// LPUART0.MATCH: LPUART Match Address Register
func (o *LPUART0_Type) SetMATCH_MA1(value uint32) {
	volatile.StoreUint32(&o.MATCH.Reg, volatile.LoadUint32(&o.MATCH.Reg)&^(0x3ff)|value)
}
func (o *LPUART0_Type) GetMATCH_MA1() uint32 {
	return volatile.LoadUint32(&o.MATCH.Reg) & 0x3ff
}
func (o *LPUART0_Type) SetMATCH_MA2(value uint32) {
	volatile.StoreUint32(&o.MATCH.Reg, volatile.LoadUint32(&o.MATCH.Reg)&^(0x3ff0000)|value<<16)
}
func (o *LPUART0_Type) GetMATCH_MA2() uint32 {
	return (volatile.LoadUint32(&o.MATCH.Reg) & 0x3ff0000) >> 16
}

// LPUART0.MODIR: LPUART Modem IrDA Register
func (o *LPUART0_Type) SetMODIR_TXCTSE(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x1)|value)
}
func (o *LPUART0_Type) GetMODIR_TXCTSE() uint32 {
	return volatile.LoadUint32(&o.MODIR.Reg) & 0x1
}
func (o *LPUART0_Type) SetMODIR_TXRTSE(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x2)|value<<1)
}
func (o *LPUART0_Type) GetMODIR_TXRTSE() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x2) >> 1
}
func (o *LPUART0_Type) SetMODIR_TXRTSPOL(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x4)|value<<2)
}
func (o *LPUART0_Type) GetMODIR_TXRTSPOL() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x4) >> 2
}
func (o *LPUART0_Type) SetMODIR_RXRTSE(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x8)|value<<3)
}
func (o *LPUART0_Type) GetMODIR_RXRTSE() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x8) >> 3
}
func (o *LPUART0_Type) SetMODIR_TXCTSC(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x10)|value<<4)
}
func (o *LPUART0_Type) GetMODIR_TXCTSC() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x10) >> 4
}
func (o *LPUART0_Type) SetMODIR_TXCTSSRC(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x20)|value<<5)
}
func (o *LPUART0_Type) GetMODIR_TXCTSSRC() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x20) >> 5
}
func (o *LPUART0_Type) SetMODIR_TNP(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x30000)|value<<16)
}
func (o *LPUART0_Type) GetMODIR_TNP() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x30000) >> 16
}
func (o *LPUART0_Type) SetMODIR_IREN(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART0_Type) GetMODIR_IREN() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x40000) >> 18
}

// Serial Peripheral Interface
type SPI_Type struct {
	MCR   volatile.Register32 // 0x0
	_     [4]byte
	TCR   volatile.Register32 // 0x8
	CTAR0 volatile.Register32 // 0xC
	CTAR1 volatile.Register32 // 0x10
	_     [24]byte
	SR    volatile.Register32 // 0x2C
	RSER  volatile.Register32 // 0x30
	PUSHR volatile.Register32 // 0x34
	POPR  volatile.Register32 // 0x38
	TXFR0 volatile.Register32 // 0x3C
	TXFR1 volatile.Register32 // 0x40
	TXFR2 volatile.Register32 // 0x44
	TXFR3 volatile.Register32 // 0x48
	_     [48]byte
	RXFR0 volatile.Register32 // 0x7C
	RXFR1 volatile.Register32 // 0x80
	RXFR2 volatile.Register32 // 0x84
	RXFR3 volatile.Register32 // 0x88
}

// SPI.MCR: Module Configuration Register
func (o *SPI_Type) SetMCR_HALT(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMCR_HALT() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *SPI_Type) SetMCR_SMPL_PT(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetMCR_SMPL_PT() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetMCR_CLR_RXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetMCR_CLR_RXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetMCR_CLR_TXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetMCR_CLR_TXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetMCR_DIS_RXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetMCR_DIS_RXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetMCR_DIS_TXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetMCR_DIS_TXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetMCR_MDIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetMCR_MDIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetMCR_DOZE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetMCR_DOZE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetMCR_PCSIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x3f0000)|value<<16)
}
func (o *SPI_Type) GetMCR_PCSIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x3f0000) >> 16
}
func (o *SPI_Type) SetMCR_ROOE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetMCR_ROOE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetMCR_PCSSE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetMCR_PCSSE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetMCR_MTFE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetMCR_MTFE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetMCR_FRZ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetMCR_FRZ() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetMCR_DCONF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x30000000)|value<<28)
}
func (o *SPI_Type) GetMCR_DCONF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x30000000) >> 28
}
func (o *SPI_Type) SetMCR_CONT_SCKE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI_Type) GetMCR_CONT_SCKE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40000000) >> 30
}
func (o *SPI_Type) SetMCR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetMCR_MSTR() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000000) >> 31
}

// SPI.TCR: Transfer Count Register
func (o *SPI_Type) SetTCR_SPI_TCNT(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTCR_SPI_TCNT() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xffff0000) >> 16
}

// SPI.CTAR0: Clock and Transfer Attributes Register (In Master Mode)
func (o *SPI_Type) SetCTAR0_BR(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetCTAR0_BR() uint32 {
	return volatile.LoadUint32(&o.CTAR0.Reg) & 0xf
}
func (o *SPI_Type) SetCTAR0_DT(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCTAR0_DT() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCTAR0_ASC(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCTAR0_ASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCTAR0_CSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf000)|value<<12)
}
func (o *SPI_Type) GetCTAR0_CSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xf000) >> 12
}
func (o *SPI_Type) SetCTAR0_PBR(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x30000)|value<<16)
}
func (o *SPI_Type) GetCTAR0_PBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x30000) >> 16
}
func (o *SPI_Type) SetCTAR0_PDT(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xc0000)|value<<18)
}
func (o *SPI_Type) GetCTAR0_PDT() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xc0000) >> 18
}
func (o *SPI_Type) SetCTAR0_PASC(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x300000)|value<<20)
}
func (o *SPI_Type) GetCTAR0_PASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x300000) >> 20
}
func (o *SPI_Type) SetCTAR0_PCSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xc00000)|value<<22)
}
func (o *SPI_Type) GetCTAR0_PCSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xc00000) >> 22
}
func (o *SPI_Type) SetCTAR0_LSBFE(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCTAR0_LSBFE() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetCTAR0_CPHA(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetCTAR0_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetCTAR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetCTAR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetCTAR0_FMSZ(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x78000000)|value<<27)
}
func (o *SPI_Type) GetCTAR0_FMSZ() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x78000000) >> 27
}
func (o *SPI_Type) SetCTAR0_DBR(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetCTAR0_DBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x80000000) >> 31
}

// SPI.CTAR1: Clock and Transfer Attributes Register (In Master Mode)
func (o *SPI_Type) SetCTAR1_BR(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetCTAR1_BR() uint32 {
	return volatile.LoadUint32(&o.CTAR1.Reg) & 0xf
}
func (o *SPI_Type) SetCTAR1_DT(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCTAR1_DT() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCTAR1_ASC(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCTAR1_ASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCTAR1_CSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf000)|value<<12)
}
func (o *SPI_Type) GetCTAR1_CSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xf000) >> 12
}
func (o *SPI_Type) SetCTAR1_PBR(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x30000)|value<<16)
}
func (o *SPI_Type) GetCTAR1_PBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x30000) >> 16
}
func (o *SPI_Type) SetCTAR1_PDT(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xc0000)|value<<18)
}
func (o *SPI_Type) GetCTAR1_PDT() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xc0000) >> 18
}
func (o *SPI_Type) SetCTAR1_PASC(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x300000)|value<<20)
}
func (o *SPI_Type) GetCTAR1_PASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x300000) >> 20
}
func (o *SPI_Type) SetCTAR1_PCSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xc00000)|value<<22)
}
func (o *SPI_Type) GetCTAR1_PCSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xc00000) >> 22
}
func (o *SPI_Type) SetCTAR1_LSBFE(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCTAR1_LSBFE() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetCTAR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetCTAR1_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetCTAR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetCTAR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetCTAR1_FMSZ(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x78000000)|value<<27)
}
func (o *SPI_Type) GetCTAR1_FMSZ() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x78000000) >> 27
}
func (o *SPI_Type) SetCTAR1_DBR(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetCTAR1_DBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x80000000) >> 31
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_POPNXTPTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetSR_POPNXTPTR() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0xf
}
func (o *SPI_Type) SetSR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetSR_RXCTR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetSR_TXNXTPTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetSR_TXNXTPTR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetSR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf000)|value<<12)
}
func (o *SPI_Type) GetSR_TXCTR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf000) >> 12
}
func (o *SPI_Type) SetSR_RFDF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SPI_Type) GetSR_RFDF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *SPI_Type) SetSR_RFOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *SPI_Type) GetSR_RFOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *SPI_Type) SetSR_TFFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetSR_TFFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetSR_TFUF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetSR_TFUF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetSR_EOQF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI_Type) GetSR_EOQF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *SPI_Type) SetSR_TXRXS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI_Type) GetSR_TXRXS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *SPI_Type) SetSR_TCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// SPI.RSER: DMA/Interrupt Request Select and Enable Register
func (o *SPI_Type) SetRSER_RFDF_DIRS(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetRSER_RFDF_DIRS() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x10000) >> 16
}
func (o *SPI_Type) SetRSER_RFDF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x20000)|value<<17)
}
func (o *SPI_Type) GetRSER_RFDF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x20000) >> 17
}
func (o *SPI_Type) SetRSER_RFOF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x80000)|value<<19)
}
func (o *SPI_Type) GetRSER_RFOF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x80000) >> 19
}
func (o *SPI_Type) SetRSER_TFFF_DIRS(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetRSER_TFFF_DIRS() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetRSER_TFFF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetRSER_TFFF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetRSER_TFUF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetRSER_TFUF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetRSER_EOQF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI_Type) GetRSER_EOQF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x10000000) >> 28
}
func (o *SPI_Type) SetRSER_TCF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetRSER_TCF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x80000000) >> 31
}

// SPI.PUSHR: PUSH TX FIFO Register In Master Mode
func (o *SPI_Type) SetPUSHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetPUSHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.PUSHR.Reg) & 0xffff
}
func (o *SPI_Type) SetPUSHR_PCS(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x3f0000)|value<<16)
}
func (o *SPI_Type) GetPUSHR_PCS() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x3f0000) >> 16
}
func (o *SPI_Type) SetPUSHR_CTCNT(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetPUSHR_CTCNT() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetPUSHR_EOQ(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetPUSHR_EOQ() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetPUSHR_CTAS(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x70000000)|value<<28)
}
func (o *SPI_Type) GetPUSHR_CTAS() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x70000000) >> 28
}
func (o *SPI_Type) SetPUSHR_CONT(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetPUSHR_CONT() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x80000000) >> 31
}

// SPI.POPR: POP RX FIFO Register
func (o *SPI_Type) SetPOPR(value uint32) {
	volatile.StoreUint32(&o.POPR.Reg, value)
}
func (o *SPI_Type) GetPOPR() uint32 {
	return volatile.LoadUint32(&o.POPR.Reg)
}

// SPI.TXFR0: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR0_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR0.Reg, volatile.LoadUint32(&o.TXFR0.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR0_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR0.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR0_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR0.Reg, volatile.LoadUint32(&o.TXFR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR0_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR0.Reg) & 0xffff0000) >> 16
}

// SPI.TXFR1: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR1_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR1.Reg, volatile.LoadUint32(&o.TXFR1.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR1_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR1.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR1_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR1.Reg, volatile.LoadUint32(&o.TXFR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR1_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR1.Reg) & 0xffff0000) >> 16
}

// SPI.TXFR2: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR2_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR2.Reg, volatile.LoadUint32(&o.TXFR2.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR2_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR2.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR2_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR2.Reg, volatile.LoadUint32(&o.TXFR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR2_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR2.Reg) & 0xffff0000) >> 16
}

// SPI.TXFR3: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR3_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR3.Reg, volatile.LoadUint32(&o.TXFR3.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR3_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR3.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR3_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR3.Reg, volatile.LoadUint32(&o.TXFR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR3_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR3.Reg) & 0xffff0000) >> 16
}

// SPI.RXFR0: Receive FIFO Registers
func (o *SPI_Type) SetRXFR0(value uint32) {
	volatile.StoreUint32(&o.RXFR0.Reg, value)
}
func (o *SPI_Type) GetRXFR0() uint32 {
	return volatile.LoadUint32(&o.RXFR0.Reg)
}

// SPI.RXFR1: Receive FIFO Registers
func (o *SPI_Type) SetRXFR1(value uint32) {
	volatile.StoreUint32(&o.RXFR1.Reg, value)
}
func (o *SPI_Type) GetRXFR1() uint32 {
	return volatile.LoadUint32(&o.RXFR1.Reg)
}

// SPI.RXFR2: Receive FIFO Registers
func (o *SPI_Type) SetRXFR2(value uint32) {
	volatile.StoreUint32(&o.RXFR2.Reg, value)
}
func (o *SPI_Type) GetRXFR2() uint32 {
	return volatile.LoadUint32(&o.RXFR2.Reg)
}

// SPI.RXFR3: Receive FIFO Registers
func (o *SPI_Type) SetRXFR3(value uint32) {
	volatile.StoreUint32(&o.RXFR3.Reg, value)
}
func (o *SPI_Type) GetRXFR3() uint32 {
	return volatile.LoadUint32(&o.RXFR3.Reg)
}

// Inter-IC Sound / Synchronous Audio Interface
type I2S0_Type struct {
	TCSR volatile.Register32 // 0x0
	TCR1 volatile.Register32 // 0x4
	TCR2 volatile.Register32 // 0x8
	TCR3 volatile.Register32 // 0xC
	TCR4 volatile.Register32 // 0x10
	TCR5 volatile.Register32 // 0x14
	_    [8]byte
	TDR  volatile.Register32 // 0x20
	_    [28]byte
	TFR  volatile.Register32 // 0x40
	_    [28]byte
	TMR  volatile.Register32 // 0x60
	_    [28]byte
	RCSR volatile.Register32 // 0x80
	RCR1 volatile.Register32 // 0x84
	RCR2 volatile.Register32 // 0x88
	RCR3 volatile.Register32 // 0x8C
	RCR4 volatile.Register32 // 0x90
	RCR5 volatile.Register32 // 0x94
	_    [8]byte
	RDR  volatile.Register32 // 0xA0
	_    [28]byte
	RFR  volatile.Register32 // 0xC0
	_    [28]byte
	RMR  volatile.Register32 // 0xE0
	_    [28]byte
	MCR  volatile.Register32 // 0x100
	MDR  volatile.Register32 // 0x104
}

// I2S0.TCSR: SAI Transmit Control Register
func (o *I2S0_Type) SetTCSR_FRDE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetTCSR_FRDE() uint32 {
	return volatile.LoadUint32(&o.TCSR.Reg) & 0x1
}
func (o *I2S0_Type) SetTCSR_FWDE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetTCSR_FWDE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetTCSR_FRIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x100)|value<<8)
}
func (o *I2S0_Type) GetTCSR_FRIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x100) >> 8
}
func (o *I2S0_Type) SetTCSR_FWIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x200)|value<<9)
}
func (o *I2S0_Type) GetTCSR_FWIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x200) >> 9
}
func (o *I2S0_Type) SetTCSR_FEIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x400)|value<<10)
}
func (o *I2S0_Type) GetTCSR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x400) >> 10
}
func (o *I2S0_Type) SetTCSR_SEIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x800)|value<<11)
}
func (o *I2S0_Type) GetTCSR_SEIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x800) >> 11
}
func (o *I2S0_Type) SetTCSR_WSIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S0_Type) GetTCSR_WSIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x1000) >> 12
}
func (o *I2S0_Type) SetTCSR_FRF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetTCSR_FRF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x10000) >> 16
}
func (o *I2S0_Type) SetTCSR_FWF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x20000)|value<<17)
}
func (o *I2S0_Type) GetTCSR_FWF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x20000) >> 17
}
func (o *I2S0_Type) SetTCSR_FEF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x40000)|value<<18)
}
func (o *I2S0_Type) GetTCSR_FEF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x40000) >> 18
}
func (o *I2S0_Type) SetTCSR_SEF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x80000)|value<<19)
}
func (o *I2S0_Type) GetTCSR_SEF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x80000) >> 19
}
func (o *I2S0_Type) SetTCSR_WSF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x100000)|value<<20)
}
func (o *I2S0_Type) GetTCSR_WSF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x100000) >> 20
}
func (o *I2S0_Type) SetTCSR_SR(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetTCSR_SR() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetTCSR_FR(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetTCSR_FR() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetTCSR_BCE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetTCSR_BCE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetTCSR_DBGE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetTCSR_DBGE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetTCSR_STOPE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetTCSR_STOPE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetTCSR_TE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetTCSR_TE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x80000000) >> 31
}

// I2S0.TCR1: SAI Transmit Configuration 1 Register
func (o *I2S0_Type) SetTCR1_TFW(value uint32) {
	volatile.StoreUint32(&o.TCR1.Reg, volatile.LoadUint32(&o.TCR1.Reg)&^(0x7)|value)
}
func (o *I2S0_Type) GetTCR1_TFW() uint32 {
	return volatile.LoadUint32(&o.TCR1.Reg) & 0x7
}

// I2S0.TCR2: SAI Transmit Configuration 2 Register
func (o *I2S0_Type) SetTCR2_DIV(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0xff)|value)
}
func (o *I2S0_Type) GetTCR2_DIV() uint32 {
	return volatile.LoadUint32(&o.TCR2.Reg) & 0xff
}
func (o *I2S0_Type) SetTCR2_BCD(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetTCR2_BCD() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetTCR2_BCP(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetTCR2_BCP() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetTCR2_MSEL(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0xc000000)|value<<26)
}
func (o *I2S0_Type) GetTCR2_MSEL() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0xc000000) >> 26
}
func (o *I2S0_Type) SetTCR2_BCI(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetTCR2_BCI() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetTCR2_BCS(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetTCR2_BCS() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetTCR2_SYNC(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0xc0000000)|value<<30)
}
func (o *I2S0_Type) GetTCR2_SYNC() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0xc0000000) >> 30
}

// I2S0.TCR3: SAI Transmit Configuration 3 Register
func (o *I2S0_Type) SetTCR3_WDFL(value uint32) {
	volatile.StoreUint32(&o.TCR3.Reg, volatile.LoadUint32(&o.TCR3.Reg)&^(0xf)|value)
}
func (o *I2S0_Type) GetTCR3_WDFL() uint32 {
	return volatile.LoadUint32(&o.TCR3.Reg) & 0xf
}
func (o *I2S0_Type) SetTCR3_TCE(value uint32) {
	volatile.StoreUint32(&o.TCR3.Reg, volatile.LoadUint32(&o.TCR3.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetTCR3_TCE() uint32 {
	return (volatile.LoadUint32(&o.TCR3.Reg) & 0x10000) >> 16
}

// I2S0.TCR4: SAI Transmit Configuration 4 Register
func (o *I2S0_Type) SetTCR4_FSD(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetTCR4_FSD() uint32 {
	return volatile.LoadUint32(&o.TCR4.Reg) & 0x1
}
func (o *I2S0_Type) SetTCR4_FSP(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetTCR4_FSP() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetTCR4_ONDEM(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x4)|value<<2)
}
func (o *I2S0_Type) GetTCR4_ONDEM() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x4) >> 2
}
func (o *I2S0_Type) SetTCR4_FSE(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x8)|value<<3)
}
func (o *I2S0_Type) GetTCR4_FSE() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x8) >> 3
}
func (o *I2S0_Type) SetTCR4_MF(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x10)|value<<4)
}
func (o *I2S0_Type) GetTCR4_MF() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x10) >> 4
}
func (o *I2S0_Type) SetTCR4_SYWD(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetTCR4_SYWD() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetTCR4_FRSZ(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S0_Type) GetTCR4_FRSZ() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0xf0000) >> 16
}
func (o *I2S0_Type) SetTCR4_FPACK(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x3000000)|value<<24)
}
func (o *I2S0_Type) GetTCR4_FPACK() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x3000000) >> 24
}
func (o *I2S0_Type) SetTCR4_FCONT(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetTCR4_FCONT() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x10000000) >> 28
}

// I2S0.TCR5: SAI Transmit Configuration 5 Register
func (o *I2S0_Type) SetTCR5_FBT(value uint32) {
	volatile.StoreUint32(&o.TCR5.Reg, volatile.LoadUint32(&o.TCR5.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetTCR5_FBT() uint32 {
	return (volatile.LoadUint32(&o.TCR5.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetTCR5_W0W(value uint32) {
	volatile.StoreUint32(&o.TCR5.Reg, volatile.LoadUint32(&o.TCR5.Reg)&^(0x1f0000)|value<<16)
}
func (o *I2S0_Type) GetTCR5_W0W() uint32 {
	return (volatile.LoadUint32(&o.TCR5.Reg) & 0x1f0000) >> 16
}
func (o *I2S0_Type) SetTCR5_WNW(value uint32) {
	volatile.StoreUint32(&o.TCR5.Reg, volatile.LoadUint32(&o.TCR5.Reg)&^(0x1f000000)|value<<24)
}
func (o *I2S0_Type) GetTCR5_WNW() uint32 {
	return (volatile.LoadUint32(&o.TCR5.Reg) & 0x1f000000) >> 24
}

// I2S0.TDR: SAI Transmit Data Register
func (o *I2S0_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *I2S0_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// I2S0.TFR: SAI Transmit FIFO Register
func (o *I2S0_Type) SetTFR_RFP(value uint32) {
	volatile.StoreUint32(&o.TFR.Reg, volatile.LoadUint32(&o.TFR.Reg)&^(0xf)|value)
}
func (o *I2S0_Type) GetTFR_RFP() uint32 {
	return volatile.LoadUint32(&o.TFR.Reg) & 0xf
}
func (o *I2S0_Type) SetTFR_WFP(value uint32) {
	volatile.StoreUint32(&o.TFR.Reg, volatile.LoadUint32(&o.TFR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S0_Type) GetTFR_WFP() uint32 {
	return (volatile.LoadUint32(&o.TFR.Reg) & 0xf0000) >> 16
}

// I2S0.TMR: SAI Transmit Mask Register
func (o *I2S0_Type) SetTMR_TWM(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0xffff)|value)
}
func (o *I2S0_Type) GetTMR_TWM() uint32 {
	return volatile.LoadUint32(&o.TMR.Reg) & 0xffff
}

// I2S0.RCSR: SAI Receive Control Register
func (o *I2S0_Type) SetRCSR_FRDE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetRCSR_FRDE() uint32 {
	return volatile.LoadUint32(&o.RCSR.Reg) & 0x1
}
func (o *I2S0_Type) SetRCSR_FWDE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetRCSR_FWDE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetRCSR_FRIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x100)|value<<8)
}
func (o *I2S0_Type) GetRCSR_FRIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x100) >> 8
}
func (o *I2S0_Type) SetRCSR_FWIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x200)|value<<9)
}
func (o *I2S0_Type) GetRCSR_FWIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x200) >> 9
}
func (o *I2S0_Type) SetRCSR_FEIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x400)|value<<10)
}
func (o *I2S0_Type) GetRCSR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x400) >> 10
}
func (o *I2S0_Type) SetRCSR_SEIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x800)|value<<11)
}
func (o *I2S0_Type) GetRCSR_SEIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x800) >> 11
}
func (o *I2S0_Type) SetRCSR_WSIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S0_Type) GetRCSR_WSIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x1000) >> 12
}
func (o *I2S0_Type) SetRCSR_FRF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetRCSR_FRF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x10000) >> 16
}
func (o *I2S0_Type) SetRCSR_FWF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x20000)|value<<17)
}
func (o *I2S0_Type) GetRCSR_FWF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x20000) >> 17
}
func (o *I2S0_Type) SetRCSR_FEF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x40000)|value<<18)
}
func (o *I2S0_Type) GetRCSR_FEF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x40000) >> 18
}
func (o *I2S0_Type) SetRCSR_SEF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x80000)|value<<19)
}
func (o *I2S0_Type) GetRCSR_SEF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x80000) >> 19
}
func (o *I2S0_Type) SetRCSR_WSF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x100000)|value<<20)
}
func (o *I2S0_Type) GetRCSR_WSF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x100000) >> 20
}
func (o *I2S0_Type) SetRCSR_SR(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetRCSR_SR() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetRCSR_FR(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetRCSR_FR() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetRCSR_BCE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetRCSR_BCE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetRCSR_DBGE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetRCSR_DBGE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetRCSR_STOPE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetRCSR_STOPE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetRCSR_RE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetRCSR_RE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x80000000) >> 31
}

// I2S0.RCR1: SAI Receive Configuration 1 Register
func (o *I2S0_Type) SetRCR1_RFW(value uint32) {
	volatile.StoreUint32(&o.RCR1.Reg, volatile.LoadUint32(&o.RCR1.Reg)&^(0x7)|value)
}
func (o *I2S0_Type) GetRCR1_RFW() uint32 {
	return volatile.LoadUint32(&o.RCR1.Reg) & 0x7
}

// I2S0.RCR2: SAI Receive Configuration 2 Register
func (o *I2S0_Type) SetRCR2_DIV(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0xff)|value)
}
func (o *I2S0_Type) GetRCR2_DIV() uint32 {
	return volatile.LoadUint32(&o.RCR2.Reg) & 0xff
}
func (o *I2S0_Type) SetRCR2_BCD(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetRCR2_BCD() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetRCR2_BCP(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetRCR2_BCP() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetRCR2_MSEL(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0xc000000)|value<<26)
}
func (o *I2S0_Type) GetRCR2_MSEL() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0xc000000) >> 26
}
func (o *I2S0_Type) SetRCR2_BCI(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetRCR2_BCI() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetRCR2_BCS(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetRCR2_BCS() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetRCR2_SYNC(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0xc0000000)|value<<30)
}
func (o *I2S0_Type) GetRCR2_SYNC() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0xc0000000) >> 30
}

// I2S0.RCR3: SAI Receive Configuration 3 Register
func (o *I2S0_Type) SetRCR3_WDFL(value uint32) {
	volatile.StoreUint32(&o.RCR3.Reg, volatile.LoadUint32(&o.RCR3.Reg)&^(0xf)|value)
}
func (o *I2S0_Type) GetRCR3_WDFL() uint32 {
	return volatile.LoadUint32(&o.RCR3.Reg) & 0xf
}
func (o *I2S0_Type) SetRCR3_RCE(value uint32) {
	volatile.StoreUint32(&o.RCR3.Reg, volatile.LoadUint32(&o.RCR3.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetRCR3_RCE() uint32 {
	return (volatile.LoadUint32(&o.RCR3.Reg) & 0x10000) >> 16
}

// I2S0.RCR4: SAI Receive Configuration 4 Register
func (o *I2S0_Type) SetRCR4_FSD(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetRCR4_FSD() uint32 {
	return volatile.LoadUint32(&o.RCR4.Reg) & 0x1
}
func (o *I2S0_Type) SetRCR4_FSP(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetRCR4_FSP() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetRCR4_ONDEM(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x4)|value<<2)
}
func (o *I2S0_Type) GetRCR4_ONDEM() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x4) >> 2
}
func (o *I2S0_Type) SetRCR4_FSE(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x8)|value<<3)
}
func (o *I2S0_Type) GetRCR4_FSE() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x8) >> 3
}
func (o *I2S0_Type) SetRCR4_MF(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x10)|value<<4)
}
func (o *I2S0_Type) GetRCR4_MF() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x10) >> 4
}
func (o *I2S0_Type) SetRCR4_SYWD(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetRCR4_SYWD() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetRCR4_FRSZ(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S0_Type) GetRCR4_FRSZ() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0xf0000) >> 16
}
func (o *I2S0_Type) SetRCR4_FPACK(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x3000000)|value<<24)
}
func (o *I2S0_Type) GetRCR4_FPACK() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x3000000) >> 24
}
func (o *I2S0_Type) SetRCR4_FCONT(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetRCR4_FCONT() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x10000000) >> 28
}

// I2S0.RCR5: SAI Receive Configuration 5 Register
func (o *I2S0_Type) SetRCR5_FBT(value uint32) {
	volatile.StoreUint32(&o.RCR5.Reg, volatile.LoadUint32(&o.RCR5.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetRCR5_FBT() uint32 {
	return (volatile.LoadUint32(&o.RCR5.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetRCR5_W0W(value uint32) {
	volatile.StoreUint32(&o.RCR5.Reg, volatile.LoadUint32(&o.RCR5.Reg)&^(0x1f0000)|value<<16)
}
func (o *I2S0_Type) GetRCR5_W0W() uint32 {
	return (volatile.LoadUint32(&o.RCR5.Reg) & 0x1f0000) >> 16
}
func (o *I2S0_Type) SetRCR5_WNW(value uint32) {
	volatile.StoreUint32(&o.RCR5.Reg, volatile.LoadUint32(&o.RCR5.Reg)&^(0x1f000000)|value<<24)
}
func (o *I2S0_Type) GetRCR5_WNW() uint32 {
	return (volatile.LoadUint32(&o.RCR5.Reg) & 0x1f000000) >> 24
}

// I2S0.RDR: SAI Receive Data Register
func (o *I2S0_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *I2S0_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// I2S0.RFR: SAI Receive FIFO Register
func (o *I2S0_Type) SetRFR_RFP(value uint32) {
	volatile.StoreUint32(&o.RFR.Reg, volatile.LoadUint32(&o.RFR.Reg)&^(0xf)|value)
}
func (o *I2S0_Type) GetRFR_RFP() uint32 {
	return volatile.LoadUint32(&o.RFR.Reg) & 0xf
}
func (o *I2S0_Type) SetRFR_WFP(value uint32) {
	volatile.StoreUint32(&o.RFR.Reg, volatile.LoadUint32(&o.RFR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S0_Type) GetRFR_WFP() uint32 {
	return (volatile.LoadUint32(&o.RFR.Reg) & 0xf0000) >> 16
}

// I2S0.RMR: SAI Receive Mask Register
func (o *I2S0_Type) SetRMR_RWM(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0xffff)|value)
}
func (o *I2S0_Type) GetRMR_RWM() uint32 {
	return volatile.LoadUint32(&o.RMR.Reg) & 0xffff
}

// I2S0.MCR: SAI MCLK Control Register
func (o *I2S0_Type) SetMCR_MICS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x3000000)|value<<24)
}
func (o *I2S0_Type) GetMCR_MICS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x3000000) >> 24
}
func (o *I2S0_Type) SetMCR_MOE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetMCR_MOE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetMCR_DUF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetMCR_DUF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000000) >> 31
}

// I2S0.MDR: SAI MCLK Divide Register
func (o *I2S0_Type) SetMDR_DIVIDE(value uint32) {
	volatile.StoreUint32(&o.MDR.Reg, volatile.LoadUint32(&o.MDR.Reg)&^(0xfff)|value)
}
func (o *I2S0_Type) GetMDR_DIVIDE() uint32 {
	return volatile.LoadUint32(&o.MDR.Reg) & 0xfff
}
func (o *I2S0_Type) SetMDR_FRACT(value uint32) {
	volatile.StoreUint32(&o.MDR.Reg, volatile.LoadUint32(&o.MDR.Reg)&^(0xff000)|value<<12)
}
func (o *I2S0_Type) GetMDR_FRACT() uint32 {
	return (volatile.LoadUint32(&o.MDR.Reg) & 0xff000) >> 12
}

// Cyclic Redundancy Check
type CRC_Type struct {
	DATA  volatile.Register32 // 0x0
	GPOLY volatile.Register32 // 0x4
	CTRL  volatile.Register32 // 0x8
}

// CRC.DATA: CRC Data register
func (o *CRC_Type) SetDATA_LL(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff)|value)
}
func (o *CRC_Type) GetDATA_LL() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0xff
}
func (o *CRC_Type) SetDATA_LU(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff00)|value<<8)
}
func (o *CRC_Type) GetDATA_LU() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0xff00) >> 8
}
func (o *CRC_Type) SetDATA_HL(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff0000)|value<<16)
}
func (o *CRC_Type) GetDATA_HL() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0xff0000) >> 16
}
func (o *CRC_Type) SetDATA_HU(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff000000)|value<<24)
}
func (o *CRC_Type) GetDATA_HU() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0xff000000) >> 24
}

// CRC.GPOLY: CRC Polynomial register
func (o *CRC_Type) SetGPOLY_LOW(value uint32) {
	volatile.StoreUint32(&o.GPOLY.Reg, volatile.LoadUint32(&o.GPOLY.Reg)&^(0xffff)|value)
}
func (o *CRC_Type) GetGPOLY_LOW() uint32 {
	return volatile.LoadUint32(&o.GPOLY.Reg) & 0xffff
}
func (o *CRC_Type) SetGPOLY_HIGH(value uint32) {
	volatile.StoreUint32(&o.GPOLY.Reg, volatile.LoadUint32(&o.GPOLY.Reg)&^(0xffff0000)|value<<16)
}
func (o *CRC_Type) GetGPOLY_HIGH() uint32 {
	return (volatile.LoadUint32(&o.GPOLY.Reg) & 0xffff0000) >> 16
}

// CRC.CTRL: CRC Control register
func (o *CRC_Type) SetCTRL_TCRC(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *CRC_Type) GetCTRL_TCRC() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}
func (o *CRC_Type) SetCTRL_WAS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *CRC_Type) GetCTRL_WAS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000000) >> 25
}
func (o *CRC_Type) SetCTRL_FXOR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *CRC_Type) GetCTRL_FXOR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000000) >> 26
}
func (o *CRC_Type) SetCTRL_TOTR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *CRC_Type) GetCTRL_TOTR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x30000000) >> 28
}
func (o *CRC_Type) SetCTRL_TOT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc0000000)|value<<30)
}
func (o *CRC_Type) GetCTRL_TOT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc0000000) >> 30
}

// Programmable Delay Block
type PDB0_Type struct {
	SC       volatile.Register32 // 0x0
	MOD      volatile.Register32 // 0x4
	CNT      volatile.Register32 // 0x8
	IDLY     volatile.Register32 // 0xC
	CH0C1    volatile.Register32 // 0x10
	CH0S     volatile.Register32 // 0x14
	CH0DLY0  volatile.Register32 // 0x18
	CH0DLY1  volatile.Register32 // 0x1C
	_        [24]byte
	CH1C1    volatile.Register32 // 0x38
	CH1S     volatile.Register32 // 0x3C
	CH1DLY0  volatile.Register32 // 0x40
	CH1DLY1  volatile.Register32 // 0x44
	_        [264]byte
	DACINTC0 volatile.Register32 // 0x150
	DACINT0  volatile.Register32 // 0x154
	DACINTC1 volatile.Register32 // 0x158
	DACINT1  volatile.Register32 // 0x15C
	_        [48]byte
	POEN     volatile.Register32 // 0x190
	PO0DLY   volatile.Register32 // 0x194
	PO1DLY   volatile.Register32 // 0x198
}

// PDB0.SC: Status and Control register
func (o *PDB0_Type) SetSC_LDOK(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetSC_LDOK() uint32 {
	return volatile.LoadUint32(&o.SC.Reg) & 0x1
}
func (o *PDB0_Type) SetSC_CONT(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetSC_CONT() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x2) >> 1
}
func (o *PDB0_Type) SetSC_MULT(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0xc)|value<<2)
}
func (o *PDB0_Type) GetSC_MULT() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0xc) >> 2
}
func (o *PDB0_Type) SetSC_PDBIE(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x20)|value<<5)
}
func (o *PDB0_Type) GetSC_PDBIE() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x20) >> 5
}
func (o *PDB0_Type) SetSC_PDBIF(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x40)|value<<6)
}
func (o *PDB0_Type) GetSC_PDBIF() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x40) >> 6
}
func (o *PDB0_Type) SetSC_PDBEN(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x80)|value<<7)
}
func (o *PDB0_Type) GetSC_PDBEN() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x80) >> 7
}
func (o *PDB0_Type) SetSC_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0xf00)|value<<8)
}
func (o *PDB0_Type) GetSC_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0xf00) >> 8
}
func (o *PDB0_Type) SetSC_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x7000)|value<<12)
}
func (o *PDB0_Type) GetSC_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x7000) >> 12
}
func (o *PDB0_Type) SetSC_DMAEN(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x8000)|value<<15)
}
func (o *PDB0_Type) GetSC_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x8000) >> 15
}
func (o *PDB0_Type) SetSC_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x10000)|value<<16)
}
func (o *PDB0_Type) GetSC_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x10000) >> 16
}
func (o *PDB0_Type) SetSC_PDBEIE(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x20000)|value<<17)
}
func (o *PDB0_Type) GetSC_PDBEIE() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x20000) >> 17
}
func (o *PDB0_Type) SetSC_LDMOD(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0xc0000)|value<<18)
}
func (o *PDB0_Type) GetSC_LDMOD() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0xc0000) >> 18
}

// PDB0.MOD: Modulus register
func (o *PDB0_Type) SetMOD(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetMOD() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0xffff
}

// PDB0.CNT: Counter register
func (o *PDB0_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// PDB0.IDLY: Interrupt Delay register
func (o *PDB0_Type) SetIDLY(value uint32) {
	volatile.StoreUint32(&o.IDLY.Reg, volatile.LoadUint32(&o.IDLY.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetIDLY() uint32 {
	return volatile.LoadUint32(&o.IDLY.Reg) & 0xffff
}

// PDB0.CH0C1: Channel n Control register 1
func (o *PDB0_Type) SetCH0C1_EN(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0xff)|value)
}
func (o *PDB0_Type) GetCH0C1_EN() uint32 {
	return volatile.LoadUint32(&o.CH0C1.Reg) & 0xff
}
func (o *PDB0_Type) SetCH0C1_TOS(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0xff00)|value<<8)
}
func (o *PDB0_Type) GetCH0C1_TOS() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0xff00) >> 8
}
func (o *PDB0_Type) SetCH0C1_BB(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0xff0000)|value<<16)
}
func (o *PDB0_Type) GetCH0C1_BB() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0xff0000) >> 16
}

// PDB0.CH0S: Channel n Status register
func (o *PDB0_Type) SetCH0S_ERR(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0xff)|value)
}
func (o *PDB0_Type) GetCH0S_ERR() uint32 {
	return volatile.LoadUint32(&o.CH0S.Reg) & 0xff
}
func (o *PDB0_Type) SetCH0S_CF(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0xff0000)|value<<16)
}
func (o *PDB0_Type) GetCH0S_CF() uint32 {
	return (volatile.LoadUint32(&o.CH0S.Reg) & 0xff0000) >> 16
}

// PDB0.CH0DLY0: Channel n Delay 0 register
func (o *PDB0_Type) SetCH0DLY0_DLY(value uint32) {
	volatile.StoreUint32(&o.CH0DLY0.Reg, volatile.LoadUint32(&o.CH0DLY0.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetCH0DLY0_DLY() uint32 {
	return volatile.LoadUint32(&o.CH0DLY0.Reg) & 0xffff
}

// PDB0.CH0DLY1: Channel n Delay 1 register
func (o *PDB0_Type) SetCH0DLY1_DLY(value uint32) {
	volatile.StoreUint32(&o.CH0DLY1.Reg, volatile.LoadUint32(&o.CH0DLY1.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetCH0DLY1_DLY() uint32 {
	return volatile.LoadUint32(&o.CH0DLY1.Reg) & 0xffff
}

// PDB0.CH1C1: Channel n Control register 1
func (o *PDB0_Type) SetCH1C1_EN(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0xff)|value)
}
func (o *PDB0_Type) GetCH1C1_EN() uint32 {
	return volatile.LoadUint32(&o.CH1C1.Reg) & 0xff
}
func (o *PDB0_Type) SetCH1C1_TOS(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0xff00)|value<<8)
}
func (o *PDB0_Type) GetCH1C1_TOS() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0xff00) >> 8
}
func (o *PDB0_Type) SetCH1C1_BB(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0xff0000)|value<<16)
}
func (o *PDB0_Type) GetCH1C1_BB() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0xff0000) >> 16
}

// PDB0.CH1S: Channel n Status register
func (o *PDB0_Type) SetCH1S_ERR(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0xff)|value)
}
func (o *PDB0_Type) GetCH1S_ERR() uint32 {
	return volatile.LoadUint32(&o.CH1S.Reg) & 0xff
}
func (o *PDB0_Type) SetCH1S_CF(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0xff0000)|value<<16)
}
func (o *PDB0_Type) GetCH1S_CF() uint32 {
	return (volatile.LoadUint32(&o.CH1S.Reg) & 0xff0000) >> 16
}

// PDB0.CH1DLY0: Channel n Delay 0 register
func (o *PDB0_Type) SetCH1DLY0_DLY(value uint32) {
	volatile.StoreUint32(&o.CH1DLY0.Reg, volatile.LoadUint32(&o.CH1DLY0.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetCH1DLY0_DLY() uint32 {
	return volatile.LoadUint32(&o.CH1DLY0.Reg) & 0xffff
}

// PDB0.CH1DLY1: Channel n Delay 1 register
func (o *PDB0_Type) SetCH1DLY1_DLY(value uint32) {
	volatile.StoreUint32(&o.CH1DLY1.Reg, volatile.LoadUint32(&o.CH1DLY1.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetCH1DLY1_DLY() uint32 {
	return volatile.LoadUint32(&o.CH1DLY1.Reg) & 0xffff
}

// PDB0.DACINTC0: DAC Interval Trigger n Control register
func (o *PDB0_Type) SetDACINTC0_TOE(value uint32) {
	volatile.StoreUint32(&o.DACINTC0.Reg, volatile.LoadUint32(&o.DACINTC0.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetDACINTC0_TOE() uint32 {
	return volatile.LoadUint32(&o.DACINTC0.Reg) & 0x1
}
func (o *PDB0_Type) SetDACINTC0_EXT(value uint32) {
	volatile.StoreUint32(&o.DACINTC0.Reg, volatile.LoadUint32(&o.DACINTC0.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetDACINTC0_EXT() uint32 {
	return (volatile.LoadUint32(&o.DACINTC0.Reg) & 0x2) >> 1
}

// PDB0.DACINT0: DAC Interval n register
func (o *PDB0_Type) SetDACINT0_INT(value uint32) {
	volatile.StoreUint32(&o.DACINT0.Reg, volatile.LoadUint32(&o.DACINT0.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetDACINT0_INT() uint32 {
	return volatile.LoadUint32(&o.DACINT0.Reg) & 0xffff
}

// PDB0.DACINTC1: DAC Interval Trigger n Control register
func (o *PDB0_Type) SetDACINTC1_TOE(value uint32) {
	volatile.StoreUint32(&o.DACINTC1.Reg, volatile.LoadUint32(&o.DACINTC1.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetDACINTC1_TOE() uint32 {
	return volatile.LoadUint32(&o.DACINTC1.Reg) & 0x1
}
func (o *PDB0_Type) SetDACINTC1_EXT(value uint32) {
	volatile.StoreUint32(&o.DACINTC1.Reg, volatile.LoadUint32(&o.DACINTC1.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetDACINTC1_EXT() uint32 {
	return (volatile.LoadUint32(&o.DACINTC1.Reg) & 0x2) >> 1
}

// PDB0.DACINT1: DAC Interval n register
func (o *PDB0_Type) SetDACINT1_INT(value uint32) {
	volatile.StoreUint32(&o.DACINT1.Reg, volatile.LoadUint32(&o.DACINT1.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetDACINT1_INT() uint32 {
	return volatile.LoadUint32(&o.DACINT1.Reg) & 0xffff
}

// PDB0.POEN: Pulse-Out n Enable register
func (o *PDB0_Type) SetPOEN(value uint32) {
	volatile.StoreUint32(&o.POEN.Reg, volatile.LoadUint32(&o.POEN.Reg)&^(0xff)|value)
}
func (o *PDB0_Type) GetPOEN() uint32 {
	return volatile.LoadUint32(&o.POEN.Reg) & 0xff
}

// PDB0.PO0DLY: Pulse-Out n Delay register
func (o *PDB0_Type) SetPO0DLY_DLY2(value uint32) {
	volatile.StoreUint32(&o.PO0DLY.Reg, volatile.LoadUint32(&o.PO0DLY.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetPO0DLY_DLY2() uint32 {
	return volatile.LoadUint32(&o.PO0DLY.Reg) & 0xffff
}
func (o *PDB0_Type) SetPO0DLY_DLY1(value uint32) {
	volatile.StoreUint32(&o.PO0DLY.Reg, volatile.LoadUint32(&o.PO0DLY.Reg)&^(0xffff0000)|value<<16)
}
func (o *PDB0_Type) GetPO0DLY_DLY1() uint32 {
	return (volatile.LoadUint32(&o.PO0DLY.Reg) & 0xffff0000) >> 16
}

// PDB0.PO1DLY: Pulse-Out n Delay register
func (o *PDB0_Type) SetPO1DLY_DLY2(value uint32) {
	volatile.StoreUint32(&o.PO1DLY.Reg, volatile.LoadUint32(&o.PO1DLY.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetPO1DLY_DLY2() uint32 {
	return volatile.LoadUint32(&o.PO1DLY.Reg) & 0xffff
}
func (o *PDB0_Type) SetPO1DLY_DLY1(value uint32) {
	volatile.StoreUint32(&o.PO1DLY.Reg, volatile.LoadUint32(&o.PO1DLY.Reg)&^(0xffff0000)|value<<16)
}
func (o *PDB0_Type) GetPO1DLY_DLY1() uint32 {
	return (volatile.LoadUint32(&o.PO1DLY.Reg) & 0xffff0000) >> 16
}

// Periodic Interrupt Timer
type PIT_Type struct {
	MCR    volatile.Register32 // 0x0
	_      [252]byte
	LDVAL0 volatile.Register32 // 0x100
	CVAL0  volatile.Register32 // 0x104
	TCTRL0 volatile.Register32 // 0x108
	TFLG0  volatile.Register32 // 0x10C
	LDVAL1 volatile.Register32 // 0x110
	CVAL1  volatile.Register32 // 0x114
	TCTRL1 volatile.Register32 // 0x118
	TFLG1  volatile.Register32 // 0x11C
	LDVAL2 volatile.Register32 // 0x120
	CVAL2  volatile.Register32 // 0x124
	TCTRL2 volatile.Register32 // 0x128
	TFLG2  volatile.Register32 // 0x12C
	LDVAL3 volatile.Register32 // 0x130
	CVAL3  volatile.Register32 // 0x134
	TCTRL3 volatile.Register32 // 0x138
	TFLG3  volatile.Register32 // 0x13C
}

// PIT.MCR: PIT Module Control Register
func (o *PIT_Type) SetMCR_FRZ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetMCR_FRZ() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *PIT_Type) SetMCR_MDIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetMCR_MDIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}

// PIT.LDVAL0: Timer Load Value Register
func (o *PIT_Type) SetLDVAL0(value uint32) {
	volatile.StoreUint32(&o.LDVAL0.Reg, value)
}
func (o *PIT_Type) GetLDVAL0() uint32 {
	return volatile.LoadUint32(&o.LDVAL0.Reg)
}

// PIT.CVAL0: Current Timer Value Register
func (o *PIT_Type) SetCVAL0(value uint32) {
	volatile.StoreUint32(&o.CVAL0.Reg, value)
}
func (o *PIT_Type) GetCVAL0() uint32 {
	return volatile.LoadUint32(&o.CVAL0.Reg)
}

// PIT.TCTRL0: Timer Control Register
func (o *PIT_Type) SetTCTRL0_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL0_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL0.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL0_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL0_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL0.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL0_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL0_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL0.Reg) & 0x4) >> 2
}

// PIT.TFLG0: Timer Flag Register
func (o *PIT_Type) SetTFLG0_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG0.Reg, volatile.LoadUint32(&o.TFLG0.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG0_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG0.Reg) & 0x1
}

// PIT.LDVAL1: Timer Load Value Register
func (o *PIT_Type) SetLDVAL1(value uint32) {
	volatile.StoreUint32(&o.LDVAL1.Reg, value)
}
func (o *PIT_Type) GetLDVAL1() uint32 {
	return volatile.LoadUint32(&o.LDVAL1.Reg)
}

// PIT.CVAL1: Current Timer Value Register
func (o *PIT_Type) SetCVAL1(value uint32) {
	volatile.StoreUint32(&o.CVAL1.Reg, value)
}
func (o *PIT_Type) GetCVAL1() uint32 {
	return volatile.LoadUint32(&o.CVAL1.Reg)
}

// PIT.TCTRL1: Timer Control Register
func (o *PIT_Type) SetTCTRL1_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL1_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL1.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL1_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL1_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL1.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL1_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL1_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL1.Reg) & 0x4) >> 2
}

// PIT.TFLG1: Timer Flag Register
func (o *PIT_Type) SetTFLG1_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG1.Reg, volatile.LoadUint32(&o.TFLG1.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG1_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG1.Reg) & 0x1
}

// PIT.LDVAL2: Timer Load Value Register
func (o *PIT_Type) SetLDVAL2(value uint32) {
	volatile.StoreUint32(&o.LDVAL2.Reg, value)
}
func (o *PIT_Type) GetLDVAL2() uint32 {
	return volatile.LoadUint32(&o.LDVAL2.Reg)
}

// PIT.CVAL2: Current Timer Value Register
func (o *PIT_Type) SetCVAL2(value uint32) {
	volatile.StoreUint32(&o.CVAL2.Reg, value)
}
func (o *PIT_Type) GetCVAL2() uint32 {
	return volatile.LoadUint32(&o.CVAL2.Reg)
}

// PIT.TCTRL2: Timer Control Register
func (o *PIT_Type) SetTCTRL2_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL2.Reg, volatile.LoadUint32(&o.TCTRL2.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL2_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL2.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL2_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL2.Reg, volatile.LoadUint32(&o.TCTRL2.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL2_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL2.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL2_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL2.Reg, volatile.LoadUint32(&o.TCTRL2.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL2_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL2.Reg) & 0x4) >> 2
}

// PIT.TFLG2: Timer Flag Register
func (o *PIT_Type) SetTFLG2_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG2.Reg, volatile.LoadUint32(&o.TFLG2.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG2_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG2.Reg) & 0x1
}

// PIT.LDVAL3: Timer Load Value Register
func (o *PIT_Type) SetLDVAL3(value uint32) {
	volatile.StoreUint32(&o.LDVAL3.Reg, value)
}
func (o *PIT_Type) GetLDVAL3() uint32 {
	return volatile.LoadUint32(&o.LDVAL3.Reg)
}

// PIT.CVAL3: Current Timer Value Register
func (o *PIT_Type) SetCVAL3(value uint32) {
	volatile.StoreUint32(&o.CVAL3.Reg, value)
}
func (o *PIT_Type) GetCVAL3() uint32 {
	return volatile.LoadUint32(&o.CVAL3.Reg)
}

// PIT.TCTRL3: Timer Control Register
func (o *PIT_Type) SetTCTRL3_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL3.Reg, volatile.LoadUint32(&o.TCTRL3.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL3_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL3.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL3_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL3.Reg, volatile.LoadUint32(&o.TCTRL3.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL3_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL3.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL3_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL3.Reg, volatile.LoadUint32(&o.TCTRL3.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL3_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL3.Reg) & 0x4) >> 2
}

// PIT.TFLG3: Timer Flag Register
func (o *PIT_Type) SetTFLG3_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG3.Reg, volatile.LoadUint32(&o.TFLG3.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG3_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG3.Reg) & 0x1
}

// Secure Real Time Clock
type RTC_Type struct {
	TSR volatile.Register32 // 0x0
	TPR volatile.Register32 // 0x4
	TAR volatile.Register32 // 0x8
	TCR volatile.Register32 // 0xC
	CR  volatile.Register32 // 0x10
	SR  volatile.Register32 // 0x14
	LR  volatile.Register32 // 0x18
	IER volatile.Register32 // 0x1C
	_   [2016]byte
	WAR volatile.Register32 // 0x800
	RAR volatile.Register32 // 0x804
}

// RTC.TSR: RTC Time Seconds Register
func (o *RTC_Type) SetTSR(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, value)
}
func (o *RTC_Type) GetTSR() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg)
}

// RTC.TPR: RTC Time Prescaler Register
func (o *RTC_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, volatile.LoadUint32(&o.TPR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg) & 0xffff
}

// RTC.TAR: RTC Time Alarm Register
func (o *RTC_Type) SetTAR(value uint32) {
	volatile.StoreUint32(&o.TAR.Reg, value)
}
func (o *RTC_Type) GetTAR() uint32 {
	return volatile.LoadUint32(&o.TAR.Reg)
}

// RTC.TCR: RTC Time Compensation Register
func (o *RTC_Type) SetTCR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetTCR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xff
}
func (o *RTC_Type) SetTCR_CIR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff00)|value<<8)
}
func (o *RTC_Type) GetTCR_CIR() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xff00) >> 8
}
func (o *RTC_Type) SetTCR_TCV(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff0000)|value<<16)
}
func (o *RTC_Type) GetTCR_TCV() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xff0000) >> 16
}
func (o *RTC_Type) SetTCR_CIC(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff000000)|value<<24)
}
func (o *RTC_Type) GetTCR_CIC() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xff000000) >> 24
}

// RTC.CR: RTC Control Register
func (o *RTC_Type) SetCR_SWR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCR_SWR() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RTC_Type) SetCR_WPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCR_WPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCR_SUP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetCR_SUP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetCR_UM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_UM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_WPS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_WPS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_OSCE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_OSCE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_CLKO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_SC16P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_SC16P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_SC8P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_SC8P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_SC4P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_SC4P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_SC2P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_SC2P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}

// RTC.SR: RTC Status Register
func (o *RTC_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSR_TIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RTC_Type) SetSR_TOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSR_TOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSR_TAF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSR_TAF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSR_TCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSR_TCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}

// RTC.LR: RTC Lock Register
func (o *RTC_Type) SetLR_TCL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetLR_TCL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetLR_CRL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetLR_CRL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetLR_SRL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetLR_SRL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetLR_LRL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetLR_LRL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x40) >> 6
}

// RTC.IER: RTC Interrupt Enable Register
func (o *RTC_Type) SetIER_TIIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetIER_TIIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *RTC_Type) SetIER_TOIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetIER_TOIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetIER_TAIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetIER_TAIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetIER_TSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetIER_TSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetIER_WPON(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetIER_WPON() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}

// RTC.WAR: RTC Write Access Register
func (o *RTC_Type) SetWAR_TSRW(value uint32) {
	volatile.StoreUint32(&o.WAR.Reg, volatile.LoadUint32(&o.WAR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetWAR_TSRW() uint32 {
	return volatile.LoadUint32(&o.WAR.Reg) & 0x1
}
func (o *RTC_Type) SetWAR_TPRW(value uint32) {
	volatile.StoreUint32(&o.WAR.Reg, volatile.LoadUint32(&o.WAR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetWAR_TPRW() uint32 {
	return (volatile.LoadUint32(&o.WAR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetWAR_TARW(value uint32) {
	volatile.StoreUint32(&o.WAR.Reg, volatile.LoadUint32(&o.WAR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetWAR_TARW() uint32 {
	return (volatile.LoadUint32(&o.WAR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetWAR_TCRW(value uint32) {
	volatile.StoreUint32(&o.WAR.Reg, volatile.LoadUint32(&o.WAR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetWAR_TCRW() uint32 {
	return (volatile.LoadUint32(&o.WAR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetWAR_CRW(value uint32) {
	volatile.StoreUint32(&o.WAR.Reg, volatile.LoadUint32(&o.WAR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetWAR_CRW() uint32 {
	return (volatile.LoadUint32(&o.WAR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetWAR_SRW(value uint32) {
	volatile.StoreUint32(&o.WAR.Reg, volatile.LoadUint32(&o.WAR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetWAR_SRW() uint32 {
	return (volatile.LoadUint32(&o.WAR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetWAR_LRW(value uint32) {
	volatile.StoreUint32(&o.WAR.Reg, volatile.LoadUint32(&o.WAR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetWAR_LRW() uint32 {
	return (volatile.LoadUint32(&o.WAR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetWAR_IERW(value uint32) {
	volatile.StoreUint32(&o.WAR.Reg, volatile.LoadUint32(&o.WAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetWAR_IERW() uint32 {
	return (volatile.LoadUint32(&o.WAR.Reg) & 0x80) >> 7
}

// RTC.RAR: RTC Read Access Register
func (o *RTC_Type) SetRAR_TSRR(value uint32) {
	volatile.StoreUint32(&o.RAR.Reg, volatile.LoadUint32(&o.RAR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetRAR_TSRR() uint32 {
	return volatile.LoadUint32(&o.RAR.Reg) & 0x1
}
func (o *RTC_Type) SetRAR_TPRR(value uint32) {
	volatile.StoreUint32(&o.RAR.Reg, volatile.LoadUint32(&o.RAR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetRAR_TPRR() uint32 {
	return (volatile.LoadUint32(&o.RAR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetRAR_TARR(value uint32) {
	volatile.StoreUint32(&o.RAR.Reg, volatile.LoadUint32(&o.RAR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetRAR_TARR() uint32 {
	return (volatile.LoadUint32(&o.RAR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetRAR_TCRR(value uint32) {
	volatile.StoreUint32(&o.RAR.Reg, volatile.LoadUint32(&o.RAR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetRAR_TCRR() uint32 {
	return (volatile.LoadUint32(&o.RAR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetRAR_CRR(value uint32) {
	volatile.StoreUint32(&o.RAR.Reg, volatile.LoadUint32(&o.RAR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetRAR_CRR() uint32 {
	return (volatile.LoadUint32(&o.RAR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetRAR_SRR(value uint32) {
	volatile.StoreUint32(&o.RAR.Reg, volatile.LoadUint32(&o.RAR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetRAR_SRR() uint32 {
	return (volatile.LoadUint32(&o.RAR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetRAR_LRR(value uint32) {
	volatile.StoreUint32(&o.RAR.Reg, volatile.LoadUint32(&o.RAR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetRAR_LRR() uint32 {
	return (volatile.LoadUint32(&o.RAR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetRAR_IERR(value uint32) {
	volatile.StoreUint32(&o.RAR.Reg, volatile.LoadUint32(&o.RAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetRAR_IERR() uint32 {
	return (volatile.LoadUint32(&o.RAR.Reg) & 0x80) >> 7
}

// VBAT register file
type RFVBAT_Type struct {
	REG0 volatile.Register32 // 0x0
	REG1 volatile.Register32 // 0x4
	REG2 volatile.Register32 // 0x8
	REG3 volatile.Register32 // 0xC
	REG4 volatile.Register32 // 0x10
	REG5 volatile.Register32 // 0x14
	REG6 volatile.Register32 // 0x18
	REG7 volatile.Register32 // 0x1C
}

// RFVBAT.REG0: VBAT register file register
func (o *RFVBAT_Type) SetREG0_LL(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff)|value)
}
func (o *RFVBAT_Type) GetREG0_LL() uint32 {
	return volatile.LoadUint32(&o.REG0.Reg) & 0xff
}
func (o *RFVBAT_Type) SetREG0_LH(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff00)|value<<8)
}
func (o *RFVBAT_Type) GetREG0_LH() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0xff00) >> 8
}
func (o *RFVBAT_Type) SetREG0_HL(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff0000)|value<<16)
}
func (o *RFVBAT_Type) GetREG0_HL() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0xff0000) >> 16
}
func (o *RFVBAT_Type) SetREG0_HH(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff000000)|value<<24)
}
func (o *RFVBAT_Type) GetREG0_HH() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0xff000000) >> 24
}

// RFVBAT.REG1: VBAT register file register
func (o *RFVBAT_Type) SetREG1_LL(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff)|value)
}
func (o *RFVBAT_Type) GetREG1_LL() uint32 {
	return volatile.LoadUint32(&o.REG1.Reg) & 0xff
}
func (o *RFVBAT_Type) SetREG1_LH(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff00)|value<<8)
}
func (o *RFVBAT_Type) GetREG1_LH() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0xff00) >> 8
}
func (o *RFVBAT_Type) SetREG1_HL(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff0000)|value<<16)
}
func (o *RFVBAT_Type) GetREG1_HL() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0xff0000) >> 16
}
func (o *RFVBAT_Type) SetREG1_HH(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff000000)|value<<24)
}
func (o *RFVBAT_Type) GetREG1_HH() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0xff000000) >> 24
}

// RFVBAT.REG2: VBAT register file register
func (o *RFVBAT_Type) SetREG2_LL(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff)|value)
}
func (o *RFVBAT_Type) GetREG2_LL() uint32 {
	return volatile.LoadUint32(&o.REG2.Reg) & 0xff
}
func (o *RFVBAT_Type) SetREG2_LH(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff00)|value<<8)
}
func (o *RFVBAT_Type) GetREG2_LH() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0xff00) >> 8
}
func (o *RFVBAT_Type) SetREG2_HL(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff0000)|value<<16)
}
func (o *RFVBAT_Type) GetREG2_HL() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0xff0000) >> 16
}
func (o *RFVBAT_Type) SetREG2_HH(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff000000)|value<<24)
}
func (o *RFVBAT_Type) GetREG2_HH() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0xff000000) >> 24
}

// RFVBAT.REG3: VBAT register file register
func (o *RFVBAT_Type) SetREG3_LL(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff)|value)
}
func (o *RFVBAT_Type) GetREG3_LL() uint32 {
	return volatile.LoadUint32(&o.REG3.Reg) & 0xff
}
func (o *RFVBAT_Type) SetREG3_LH(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff00)|value<<8)
}
func (o *RFVBAT_Type) GetREG3_LH() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0xff00) >> 8
}
func (o *RFVBAT_Type) SetREG3_HL(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff0000)|value<<16)
}
func (o *RFVBAT_Type) GetREG3_HL() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0xff0000) >> 16
}
func (o *RFVBAT_Type) SetREG3_HH(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff000000)|value<<24)
}
func (o *RFVBAT_Type) GetREG3_HH() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0xff000000) >> 24
}

// RFVBAT.REG4: VBAT register file register
func (o *RFVBAT_Type) SetREG4_LL(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff)|value)
}
func (o *RFVBAT_Type) GetREG4_LL() uint32 {
	return volatile.LoadUint32(&o.REG4.Reg) & 0xff
}
func (o *RFVBAT_Type) SetREG4_LH(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff00)|value<<8)
}
func (o *RFVBAT_Type) GetREG4_LH() uint32 {
	return (volatile.LoadUint32(&o.REG4.Reg) & 0xff00) >> 8
}
func (o *RFVBAT_Type) SetREG4_HL(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff0000)|value<<16)
}
func (o *RFVBAT_Type) GetREG4_HL() uint32 {
	return (volatile.LoadUint32(&o.REG4.Reg) & 0xff0000) >> 16
}
func (o *RFVBAT_Type) SetREG4_HH(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff000000)|value<<24)
}
func (o *RFVBAT_Type) GetREG4_HH() uint32 {
	return (volatile.LoadUint32(&o.REG4.Reg) & 0xff000000) >> 24
}

// RFVBAT.REG5: VBAT register file register
func (o *RFVBAT_Type) SetREG5_LL(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff)|value)
}
func (o *RFVBAT_Type) GetREG5_LL() uint32 {
	return volatile.LoadUint32(&o.REG5.Reg) & 0xff
}
func (o *RFVBAT_Type) SetREG5_LH(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff00)|value<<8)
}
func (o *RFVBAT_Type) GetREG5_LH() uint32 {
	return (volatile.LoadUint32(&o.REG5.Reg) & 0xff00) >> 8
}
func (o *RFVBAT_Type) SetREG5_HL(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff0000)|value<<16)
}
func (o *RFVBAT_Type) GetREG5_HL() uint32 {
	return (volatile.LoadUint32(&o.REG5.Reg) & 0xff0000) >> 16
}
func (o *RFVBAT_Type) SetREG5_HH(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff000000)|value<<24)
}
func (o *RFVBAT_Type) GetREG5_HH() uint32 {
	return (volatile.LoadUint32(&o.REG5.Reg) & 0xff000000) >> 24
}

// RFVBAT.REG6: VBAT register file register
func (o *RFVBAT_Type) SetREG6_LL(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff)|value)
}
func (o *RFVBAT_Type) GetREG6_LL() uint32 {
	return volatile.LoadUint32(&o.REG6.Reg) & 0xff
}
func (o *RFVBAT_Type) SetREG6_LH(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff00)|value<<8)
}
func (o *RFVBAT_Type) GetREG6_LH() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0xff00) >> 8
}
func (o *RFVBAT_Type) SetREG6_HL(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff0000)|value<<16)
}
func (o *RFVBAT_Type) GetREG6_HL() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0xff0000) >> 16
}
func (o *RFVBAT_Type) SetREG6_HH(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff000000)|value<<24)
}
func (o *RFVBAT_Type) GetREG6_HH() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0xff000000) >> 24
}

// RFVBAT.REG7: VBAT register file register
func (o *RFVBAT_Type) SetREG7_LL(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff)|value)
}
func (o *RFVBAT_Type) GetREG7_LL() uint32 {
	return volatile.LoadUint32(&o.REG7.Reg) & 0xff
}
func (o *RFVBAT_Type) SetREG7_LH(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff00)|value<<8)
}
func (o *RFVBAT_Type) GetREG7_LH() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0xff00) >> 8
}
func (o *RFVBAT_Type) SetREG7_HL(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff0000)|value<<16)
}
func (o *RFVBAT_Type) GetREG7_HL() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0xff0000) >> 16
}
func (o *RFVBAT_Type) SetREG7_HH(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff000000)|value<<24)
}
func (o *RFVBAT_Type) GetREG7_HH() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0xff000000) >> 24
}

// Low Power Timer
type LPTMR0_Type struct {
	CSR volatile.Register32 // 0x0
	PSR volatile.Register32 // 0x4
	CMR volatile.Register32 // 0x8
	CNR volatile.Register32 // 0xC
}

// LPTMR0.CSR: Low Power Timer Control Status Register
func (o *LPTMR0_Type) SetCSR_TEN(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *LPTMR0_Type) GetCSR_TEN() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *LPTMR0_Type) SetCSR_TMS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *LPTMR0_Type) GetCSR_TMS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *LPTMR0_Type) SetCSR_TFC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *LPTMR0_Type) GetCSR_TFC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *LPTMR0_Type) SetCSR_TPP(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *LPTMR0_Type) GetCSR_TPP() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *LPTMR0_Type) SetCSR_TPS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x30)|value<<4)
}
func (o *LPTMR0_Type) GetCSR_TPS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x30) >> 4
}
func (o *LPTMR0_Type) SetCSR_TIE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *LPTMR0_Type) GetCSR_TIE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *LPTMR0_Type) SetCSR_TCF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *LPTMR0_Type) GetCSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}

// LPTMR0.PSR: Low Power Timer Prescale Register
func (o *LPTMR0_Type) SetPSR_PCS(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x3)|value)
}
func (o *LPTMR0_Type) GetPSR_PCS() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x3
}
func (o *LPTMR0_Type) SetPSR_PBYP(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *LPTMR0_Type) GetPSR_PBYP() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *LPTMR0_Type) SetPSR_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x78)|value<<3)
}
func (o *LPTMR0_Type) GetPSR_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x78) >> 3
}

// LPTMR0.CMR: Low Power Timer Compare Register
func (o *LPTMR0_Type) SetCMR_COMPARE(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xffff)|value)
}
func (o *LPTMR0_Type) GetCMR_COMPARE() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xffff
}

// LPTMR0.CNR: Low Power Timer Counter Register
func (o *LPTMR0_Type) SetCNR_COUNTER(value uint32) {
	volatile.StoreUint32(&o.CNR.Reg, volatile.LoadUint32(&o.CNR.Reg)&^(0xffff)|value)
}
func (o *LPTMR0_Type) GetCNR_COUNTER() uint32 {
	return volatile.LoadUint32(&o.CNR.Reg) & 0xffff
}

// System register file
type RFSYS_Type struct {
	REG0 volatile.Register32 // 0x0
	REG1 volatile.Register32 // 0x4
	REG2 volatile.Register32 // 0x8
	REG3 volatile.Register32 // 0xC
	REG4 volatile.Register32 // 0x10
	REG5 volatile.Register32 // 0x14
	REG6 volatile.Register32 // 0x18
	REG7 volatile.Register32 // 0x1C
}

// RFSYS.REG0: Register file register
func (o *RFSYS_Type) SetREG0_LL(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG0_LL() uint32 {
	return volatile.LoadUint32(&o.REG0.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG0_LH(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG0_LH() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG0_HL(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG0_HL() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG0_HH(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG0_HH() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0xff000000) >> 24
}

// RFSYS.REG1: Register file register
func (o *RFSYS_Type) SetREG1_LL(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG1_LL() uint32 {
	return volatile.LoadUint32(&o.REG1.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG1_LH(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG1_LH() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG1_HL(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG1_HL() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG1_HH(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG1_HH() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0xff000000) >> 24
}

// RFSYS.REG2: Register file register
func (o *RFSYS_Type) SetREG2_LL(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG2_LL() uint32 {
	return volatile.LoadUint32(&o.REG2.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG2_LH(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG2_LH() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG2_HL(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG2_HL() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG2_HH(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG2_HH() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0xff000000) >> 24
}

// RFSYS.REG3: Register file register
func (o *RFSYS_Type) SetREG3_LL(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG3_LL() uint32 {
	return volatile.LoadUint32(&o.REG3.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG3_LH(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG3_LH() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG3_HL(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG3_HL() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG3_HH(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG3_HH() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0xff000000) >> 24
}

// RFSYS.REG4: Register file register
func (o *RFSYS_Type) SetREG4_LL(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG4_LL() uint32 {
	return volatile.LoadUint32(&o.REG4.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG4_LH(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG4_LH() uint32 {
	return (volatile.LoadUint32(&o.REG4.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG4_HL(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG4_HL() uint32 {
	return (volatile.LoadUint32(&o.REG4.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG4_HH(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG4_HH() uint32 {
	return (volatile.LoadUint32(&o.REG4.Reg) & 0xff000000) >> 24
}

// RFSYS.REG5: Register file register
func (o *RFSYS_Type) SetREG5_LL(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG5_LL() uint32 {
	return volatile.LoadUint32(&o.REG5.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG5_LH(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG5_LH() uint32 {
	return (volatile.LoadUint32(&o.REG5.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG5_HL(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG5_HL() uint32 {
	return (volatile.LoadUint32(&o.REG5.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG5_HH(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG5_HH() uint32 {
	return (volatile.LoadUint32(&o.REG5.Reg) & 0xff000000) >> 24
}

// RFSYS.REG6: Register file register
func (o *RFSYS_Type) SetREG6_LL(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG6_LL() uint32 {
	return volatile.LoadUint32(&o.REG6.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG6_LH(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG6_LH() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG6_HL(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG6_HL() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG6_HH(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG6_HH() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0xff000000) >> 24
}

// RFSYS.REG7: Register file register
func (o *RFSYS_Type) SetREG7_LL(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG7_LL() uint32 {
	return volatile.LoadUint32(&o.REG7.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG7_LH(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG7_LH() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG7_HL(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG7_HL() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG7_HH(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG7_HH() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0xff000000) >> 24
}

// System Integration Module
type SIM_Type struct {
	SOPT1    volatile.Register32 // 0x0
	SOPT1CFG volatile.Register32 // 0x4
	_        [4092]byte
	SOPT2    volatile.Register32 // 0x1004
	_        [4]byte
	SOPT4    volatile.Register32 // 0x100C
	SOPT5    volatile.Register32 // 0x1010
	_        [4]byte
	SOPT7    volatile.Register32 // 0x1018
	SOPT8    volatile.Register32 // 0x101C
	_        [4]byte
	SDID     volatile.Register32 // 0x1024
	_        [12]byte
	SCGC4    volatile.Register32 // 0x1034
	SCGC5    volatile.Register32 // 0x1038
	SCGC6    volatile.Register32 // 0x103C
	SCGC7    volatile.Register32 // 0x1040
	CLKDIV1  volatile.Register32 // 0x1044
	CLKDIV2  volatile.Register32 // 0x1048
	FCFG1    volatile.Register32 // 0x104C
	FCFG2    volatile.Register32 // 0x1050
	UIDH     volatile.Register32 // 0x1054
	UIDMH    volatile.Register32 // 0x1058
	UIDML    volatile.Register32 // 0x105C
	UIDL     volatile.Register32 // 0x1060
}

// SIM.SOPT1: System Options Register 1
func (o *SIM_Type) SetSOPT1_RAMSIZE(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0xf000)|value<<12)
}
func (o *SIM_Type) GetSOPT1_RAMSIZE() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0xf000) >> 12
}
func (o *SIM_Type) SetSOPT1_OSC32KOUT(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0x30000)|value<<16)
}
func (o *SIM_Type) GetSOPT1_OSC32KOUT() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0x30000) >> 16
}
func (o *SIM_Type) SetSOPT1_OSC32KSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0xc0000)|value<<18)
}
func (o *SIM_Type) GetSOPT1_OSC32KSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0xc0000) >> 18
}
func (o *SIM_Type) SetSOPT1_USBVSTBY(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0x20000000)|value<<29)
}
func (o *SIM_Type) GetSOPT1_USBVSTBY() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0x20000000) >> 29
}
func (o *SIM_Type) SetSOPT1_USBSSTBY(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0x40000000)|value<<30)
}
func (o *SIM_Type) GetSOPT1_USBSSTBY() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0x40000000) >> 30
}
func (o *SIM_Type) SetSOPT1_USBREGEN(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0x80000000)|value<<31)
}
func (o *SIM_Type) GetSOPT1_USBREGEN() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0x80000000) >> 31
}

// SIM.SOPT1CFG: SOPT1 Configuration Register
func (o *SIM_Type) SetSOPT1CFG_URWE(value uint32) {
	volatile.StoreUint32(&o.SOPT1CFG.Reg, volatile.LoadUint32(&o.SOPT1CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *SIM_Type) GetSOPT1CFG_URWE() uint32 {
	return (volatile.LoadUint32(&o.SOPT1CFG.Reg) & 0x1000000) >> 24
}
func (o *SIM_Type) SetSOPT1CFG_UVSWE(value uint32) {
	volatile.StoreUint32(&o.SOPT1CFG.Reg, volatile.LoadUint32(&o.SOPT1CFG.Reg)&^(0x2000000)|value<<25)
}
func (o *SIM_Type) GetSOPT1CFG_UVSWE() uint32 {
	return (volatile.LoadUint32(&o.SOPT1CFG.Reg) & 0x2000000) >> 25
}
func (o *SIM_Type) SetSOPT1CFG_USSWE(value uint32) {
	volatile.StoreUint32(&o.SOPT1CFG.Reg, volatile.LoadUint32(&o.SOPT1CFG.Reg)&^(0x4000000)|value<<26)
}
func (o *SIM_Type) GetSOPT1CFG_USSWE() uint32 {
	return (volatile.LoadUint32(&o.SOPT1CFG.Reg) & 0x4000000) >> 26
}

// SIM.SOPT2: System Options Register 2
func (o *SIM_Type) SetSOPT2_RTCCLKOUTSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0x10)|value<<4)
}
func (o *SIM_Type) GetSOPT2_RTCCLKOUTSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0x10) >> 4
}
func (o *SIM_Type) SetSOPT2_CLKOUTSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0xe0)|value<<5)
}
func (o *SIM_Type) GetSOPT2_CLKOUTSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0xe0) >> 5
}
func (o *SIM_Type) SetSOPT2_FBSL(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0x300)|value<<8)
}
func (o *SIM_Type) GetSOPT2_FBSL() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0x300) >> 8
}
func (o *SIM_Type) SetSOPT2_TRACECLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0x1000)|value<<12)
}
func (o *SIM_Type) GetSOPT2_TRACECLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0x1000) >> 12
}
func (o *SIM_Type) SetSOPT2_PLLFLLSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0x30000)|value<<16)
}
func (o *SIM_Type) GetSOPT2_PLLFLLSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0x30000) >> 16
}
func (o *SIM_Type) SetSOPT2_USBSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0x40000)|value<<18)
}
func (o *SIM_Type) GetSOPT2_USBSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0x40000) >> 18
}
func (o *SIM_Type) SetSOPT2_LPUARTSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0xc000000)|value<<26)
}
func (o *SIM_Type) GetSOPT2_LPUARTSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0xc000000) >> 26
}

// SIM.SOPT4: System Options Register 4
func (o *SIM_Type) SetSOPT4_FTM0FLT0(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetSOPT4_FTM0FLT0() uint32 {
	return volatile.LoadUint32(&o.SOPT4.Reg) & 0x1
}
func (o *SIM_Type) SetSOPT4_FTM0FLT1(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetSOPT4_FTM0FLT1() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetSOPT4_FTM1FLT0(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x10)|value<<4)
}
func (o *SIM_Type) GetSOPT4_FTM1FLT0() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x10) >> 4
}
func (o *SIM_Type) SetSOPT4_FTM2FLT0(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x100)|value<<8)
}
func (o *SIM_Type) GetSOPT4_FTM2FLT0() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x100) >> 8
}
func (o *SIM_Type) SetSOPT4_FTM3FLT0(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x1000)|value<<12)
}
func (o *SIM_Type) GetSOPT4_FTM3FLT0() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x1000) >> 12
}
func (o *SIM_Type) SetSOPT4_FTM1CH0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0xc0000)|value<<18)
}
func (o *SIM_Type) GetSOPT4_FTM1CH0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0xc0000) >> 18
}
func (o *SIM_Type) SetSOPT4_FTM2CH0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x300000)|value<<20)
}
func (o *SIM_Type) GetSOPT4_FTM2CH0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x300000) >> 20
}
func (o *SIM_Type) SetSOPT4_FTM2CH1SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x400000)|value<<22)
}
func (o *SIM_Type) GetSOPT4_FTM2CH1SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x400000) >> 22
}
func (o *SIM_Type) SetSOPT4_FTM0CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x1000000)|value<<24)
}
func (o *SIM_Type) GetSOPT4_FTM0CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x1000000) >> 24
}
func (o *SIM_Type) SetSOPT4_FTM1CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x2000000)|value<<25)
}
func (o *SIM_Type) GetSOPT4_FTM1CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x2000000) >> 25
}
func (o *SIM_Type) SetSOPT4_FTM2CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x4000000)|value<<26)
}
func (o *SIM_Type) GetSOPT4_FTM2CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x4000000) >> 26
}
func (o *SIM_Type) SetSOPT4_FTM3CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x8000000)|value<<27)
}
func (o *SIM_Type) GetSOPT4_FTM3CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x8000000) >> 27
}
func (o *SIM_Type) SetSOPT4_FTM0TRG0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x10000000)|value<<28)
}
func (o *SIM_Type) GetSOPT4_FTM0TRG0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x10000000) >> 28
}
func (o *SIM_Type) SetSOPT4_FTM0TRG1SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x20000000)|value<<29)
}
func (o *SIM_Type) GetSOPT4_FTM0TRG1SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x20000000) >> 29
}
func (o *SIM_Type) SetSOPT4_FTM3TRG0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x40000000)|value<<30)
}
func (o *SIM_Type) GetSOPT4_FTM3TRG0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x40000000) >> 30
}
func (o *SIM_Type) SetSOPT4_FTM3TRG1SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x80000000)|value<<31)
}
func (o *SIM_Type) GetSOPT4_FTM3TRG1SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x80000000) >> 31
}

// SIM.SOPT5: System Options Register 5
func (o *SIM_Type) SetSOPT5_UART0TXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x3)|value)
}
func (o *SIM_Type) GetSOPT5_UART0TXSRC() uint32 {
	return volatile.LoadUint32(&o.SOPT5.Reg) & 0x3
}
func (o *SIM_Type) SetSOPT5_UART0RXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0xc)|value<<2)
}
func (o *SIM_Type) GetSOPT5_UART0RXSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0xc) >> 2
}
func (o *SIM_Type) SetSOPT5_UART1TXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x30)|value<<4)
}
func (o *SIM_Type) GetSOPT5_UART1TXSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0x30) >> 4
}
func (o *SIM_Type) SetSOPT5_UART1RXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0xc0)|value<<6)
}
func (o *SIM_Type) GetSOPT5_UART1RXSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0xc0) >> 6
}
func (o *SIM_Type) SetSOPT5_LPUART0RXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0xc0000)|value<<18)
}
func (o *SIM_Type) GetSOPT5_LPUART0RXSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0xc0000) >> 18
}

// SIM.SOPT7: System Options Register 7
func (o *SIM_Type) SetSOPT7_ADC0TRGSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0xf)|value)
}
func (o *SIM_Type) GetSOPT7_ADC0TRGSEL() uint32 {
	return volatile.LoadUint32(&o.SOPT7.Reg) & 0xf
}
func (o *SIM_Type) SetSOPT7_ADC0PRETRGSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0x10)|value<<4)
}
func (o *SIM_Type) GetSOPT7_ADC0PRETRGSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT7.Reg) & 0x10) >> 4
}
func (o *SIM_Type) SetSOPT7_ADC0ALTTRGEN(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0x80)|value<<7)
}
func (o *SIM_Type) GetSOPT7_ADC0ALTTRGEN() uint32 {
	return (volatile.LoadUint32(&o.SOPT7.Reg) & 0x80) >> 7
}
func (o *SIM_Type) SetSOPT7_ADC1TRGSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0xf00)|value<<8)
}
func (o *SIM_Type) GetSOPT7_ADC1TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT7.Reg) & 0xf00) >> 8
}
func (o *SIM_Type) SetSOPT7_ADC1PRETRGSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0x1000)|value<<12)
}
func (o *SIM_Type) GetSOPT7_ADC1PRETRGSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT7.Reg) & 0x1000) >> 12
}
func (o *SIM_Type) SetSOPT7_ADC1ALTTRGEN(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0x8000)|value<<15)
}
func (o *SIM_Type) GetSOPT7_ADC1ALTTRGEN() uint32 {
	return (volatile.LoadUint32(&o.SOPT7.Reg) & 0x8000) >> 15
}

// SIM.SOPT8: System Options Register 8
func (o *SIM_Type) SetSOPT8_FTM0SYNCBIT(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetSOPT8_FTM0SYNCBIT() uint32 {
	return volatile.LoadUint32(&o.SOPT8.Reg) & 0x1
}
func (o *SIM_Type) SetSOPT8_FTM1SYNCBIT(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetSOPT8_FTM1SYNCBIT() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetSOPT8_FTM2SYNCBIT(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x4)|value<<2)
}
func (o *SIM_Type) GetSOPT8_FTM2SYNCBIT() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x4) >> 2
}
func (o *SIM_Type) SetSOPT8_FTM3SYNCBIT(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x8)|value<<3)
}
func (o *SIM_Type) GetSOPT8_FTM3SYNCBIT() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x8) >> 3
}
func (o *SIM_Type) SetSOPT8_FTM0OCH0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x10000)|value<<16)
}
func (o *SIM_Type) GetSOPT8_FTM0OCH0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x10000) >> 16
}
func (o *SIM_Type) SetSOPT8_FTM0OCH1SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x20000)|value<<17)
}
func (o *SIM_Type) GetSOPT8_FTM0OCH1SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x20000) >> 17
}
func (o *SIM_Type) SetSOPT8_FTM0OCH2SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x40000)|value<<18)
}
func (o *SIM_Type) GetSOPT8_FTM0OCH2SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x40000) >> 18
}
func (o *SIM_Type) SetSOPT8_FTM0OCH3SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x80000)|value<<19)
}
func (o *SIM_Type) GetSOPT8_FTM0OCH3SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x80000) >> 19
}
func (o *SIM_Type) SetSOPT8_FTM0OCH4SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x100000)|value<<20)
}
func (o *SIM_Type) GetSOPT8_FTM0OCH4SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x100000) >> 20
}
func (o *SIM_Type) SetSOPT8_FTM0OCH5SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x200000)|value<<21)
}
func (o *SIM_Type) GetSOPT8_FTM0OCH5SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x200000) >> 21
}
func (o *SIM_Type) SetSOPT8_FTM0OCH6SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x400000)|value<<22)
}
func (o *SIM_Type) GetSOPT8_FTM0OCH6SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x400000) >> 22
}
func (o *SIM_Type) SetSOPT8_FTM0OCH7SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x800000)|value<<23)
}
func (o *SIM_Type) GetSOPT8_FTM0OCH7SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x800000) >> 23
}
func (o *SIM_Type) SetSOPT8_FTM3OCH0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x1000000)|value<<24)
}
func (o *SIM_Type) GetSOPT8_FTM3OCH0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x1000000) >> 24
}
func (o *SIM_Type) SetSOPT8_FTM3OCH1SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x2000000)|value<<25)
}
func (o *SIM_Type) GetSOPT8_FTM3OCH1SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x2000000) >> 25
}
func (o *SIM_Type) SetSOPT8_FTM3OCH2SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x4000000)|value<<26)
}
func (o *SIM_Type) GetSOPT8_FTM3OCH2SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x4000000) >> 26
}
func (o *SIM_Type) SetSOPT8_FTM3OCH3SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x8000000)|value<<27)
}
func (o *SIM_Type) GetSOPT8_FTM3OCH3SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x8000000) >> 27
}
func (o *SIM_Type) SetSOPT8_FTM3OCH4SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x10000000)|value<<28)
}
func (o *SIM_Type) GetSOPT8_FTM3OCH4SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x10000000) >> 28
}
func (o *SIM_Type) SetSOPT8_FTM3OCH5SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x20000000)|value<<29)
}
func (o *SIM_Type) GetSOPT8_FTM3OCH5SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x20000000) >> 29
}
func (o *SIM_Type) SetSOPT8_FTM3OCH6SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x40000000)|value<<30)
}
func (o *SIM_Type) GetSOPT8_FTM3OCH6SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x40000000) >> 30
}
func (o *SIM_Type) SetSOPT8_FTM3OCH7SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT8.Reg, volatile.LoadUint32(&o.SOPT8.Reg)&^(0x80000000)|value<<31)
}
func (o *SIM_Type) GetSOPT8_FTM3OCH7SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT8.Reg) & 0x80000000) >> 31
}

// SIM.SDID: System Device Identification Register
func (o *SIM_Type) SetSDID_PINID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf)|value)
}
func (o *SIM_Type) GetSDID_PINID() uint32 {
	return volatile.LoadUint32(&o.SDID.Reg) & 0xf
}
func (o *SIM_Type) SetSDID_FAMID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0x70)|value<<4)
}
func (o *SIM_Type) GetSDID_FAMID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0x70) >> 4
}
func (o *SIM_Type) SetSDID_DIEID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf80)|value<<7)
}
func (o *SIM_Type) GetSDID_DIEID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf80) >> 7
}
func (o *SIM_Type) SetSDID_REVID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf000)|value<<12)
}
func (o *SIM_Type) GetSDID_REVID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf000) >> 12
}
func (o *SIM_Type) SetSDID_SERIESID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf00000)|value<<20)
}
func (o *SIM_Type) GetSDID_SERIESID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf00000) >> 20
}
func (o *SIM_Type) SetSDID_SUBFAMID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf000000)|value<<24)
}
func (o *SIM_Type) GetSDID_SUBFAMID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf000000) >> 24
}
func (o *SIM_Type) SetSDID_FAMILYID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf0000000)|value<<28)
}
func (o *SIM_Type) GetSDID_FAMILYID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf0000000) >> 28
}

// SIM.SCGC4: System Clock Gating Control Register 4
func (o *SIM_Type) SetSCGC4_EWM(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetSCGC4_EWM() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetSCGC4_I2C0(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x40)|value<<6)
}
func (o *SIM_Type) GetSCGC4_I2C0() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x40) >> 6
}
func (o *SIM_Type) SetSCGC4_I2C1(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x80)|value<<7)
}
func (o *SIM_Type) GetSCGC4_I2C1() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x80) >> 7
}
func (o *SIM_Type) SetSCGC4_UART0(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x400)|value<<10)
}
func (o *SIM_Type) GetSCGC4_UART0() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x400) >> 10
}
func (o *SIM_Type) SetSCGC4_UART1(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x800)|value<<11)
}
func (o *SIM_Type) GetSCGC4_UART1() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x800) >> 11
}
func (o *SIM_Type) SetSCGC4_UART2(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x1000)|value<<12)
}
func (o *SIM_Type) GetSCGC4_UART2() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x1000) >> 12
}
func (o *SIM_Type) SetSCGC4_USBOTG(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x40000)|value<<18)
}
func (o *SIM_Type) GetSCGC4_USBOTG() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x40000) >> 18
}
func (o *SIM_Type) SetSCGC4_CMP(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x80000)|value<<19)
}
func (o *SIM_Type) GetSCGC4_CMP() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x80000) >> 19
}
func (o *SIM_Type) SetSCGC4_VREF(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x100000)|value<<20)
}
func (o *SIM_Type) GetSCGC4_VREF() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x100000) >> 20
}

// SIM.SCGC5: System Clock Gating Control Register 5
func (o *SIM_Type) SetSCGC5_LPTMR(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetSCGC5_LPTMR() uint32 {
	return volatile.LoadUint32(&o.SCGC5.Reg) & 0x1
}
func (o *SIM_Type) SetSCGC5_PORTA(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x200)|value<<9)
}
func (o *SIM_Type) GetSCGC5_PORTA() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x200) >> 9
}
func (o *SIM_Type) SetSCGC5_PORTB(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x400)|value<<10)
}
func (o *SIM_Type) GetSCGC5_PORTB() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x400) >> 10
}
func (o *SIM_Type) SetSCGC5_PORTC(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x800)|value<<11)
}
func (o *SIM_Type) GetSCGC5_PORTC() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x800) >> 11
}
func (o *SIM_Type) SetSCGC5_PORTD(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x1000)|value<<12)
}
func (o *SIM_Type) GetSCGC5_PORTD() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x1000) >> 12
}
func (o *SIM_Type) SetSCGC5_PORTE(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x2000)|value<<13)
}
func (o *SIM_Type) GetSCGC5_PORTE() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x2000) >> 13
}

// SIM.SCGC6: System Clock Gating Control Register 6
func (o *SIM_Type) SetSCGC6_FTF(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetSCGC6_FTF() uint32 {
	return volatile.LoadUint32(&o.SCGC6.Reg) & 0x1
}
func (o *SIM_Type) SetSCGC6_DMAMUX(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetSCGC6_DMAMUX() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetSCGC6_FTM3(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x40)|value<<6)
}
func (o *SIM_Type) GetSCGC6_FTM3() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x40) >> 6
}
func (o *SIM_Type) SetSCGC6_ADC1(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x80)|value<<7)
}
func (o *SIM_Type) GetSCGC6_ADC1() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x80) >> 7
}
func (o *SIM_Type) SetSCGC6_DAC1(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x100)|value<<8)
}
func (o *SIM_Type) GetSCGC6_DAC1() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x100) >> 8
}
func (o *SIM_Type) SetSCGC6_RNGA(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x200)|value<<9)
}
func (o *SIM_Type) GetSCGC6_RNGA() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x200) >> 9
}
func (o *SIM_Type) SetSCGC6_LPUART0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x400)|value<<10)
}
func (o *SIM_Type) GetSCGC6_LPUART0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x400) >> 10
}
func (o *SIM_Type) SetSCGC6_SPI0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x1000)|value<<12)
}
func (o *SIM_Type) GetSCGC6_SPI0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x1000) >> 12
}
func (o *SIM_Type) SetSCGC6_SPI1(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x2000)|value<<13)
}
func (o *SIM_Type) GetSCGC6_SPI1() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x2000) >> 13
}
func (o *SIM_Type) SetSCGC6_I2S(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x8000)|value<<15)
}
func (o *SIM_Type) GetSCGC6_I2S() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x8000) >> 15
}
func (o *SIM_Type) SetSCGC6_CRC(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x40000)|value<<18)
}
func (o *SIM_Type) GetSCGC6_CRC() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x40000) >> 18
}
func (o *SIM_Type) SetSCGC6_PDB(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x400000)|value<<22)
}
func (o *SIM_Type) GetSCGC6_PDB() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x400000) >> 22
}
func (o *SIM_Type) SetSCGC6_PIT(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x800000)|value<<23)
}
func (o *SIM_Type) GetSCGC6_PIT() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x800000) >> 23
}
func (o *SIM_Type) SetSCGC6_FTM0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x1000000)|value<<24)
}
func (o *SIM_Type) GetSCGC6_FTM0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x1000000) >> 24
}
func (o *SIM_Type) SetSCGC6_FTM1(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x2000000)|value<<25)
}
func (o *SIM_Type) GetSCGC6_FTM1() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x2000000) >> 25
}
func (o *SIM_Type) SetSCGC6_FTM2(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x4000000)|value<<26)
}
func (o *SIM_Type) GetSCGC6_FTM2() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x4000000) >> 26
}
func (o *SIM_Type) SetSCGC6_ADC0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x8000000)|value<<27)
}
func (o *SIM_Type) GetSCGC6_ADC0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x8000000) >> 27
}
func (o *SIM_Type) SetSCGC6_RTC(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x20000000)|value<<29)
}
func (o *SIM_Type) GetSCGC6_RTC() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x20000000) >> 29
}
func (o *SIM_Type) SetSCGC6_DAC0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x80000000)|value<<31)
}
func (o *SIM_Type) GetSCGC6_DAC0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x80000000) >> 31
}

// SIM.SCGC7: System Clock Gating Control Register 7
func (o *SIM_Type) SetSCGC7_FLEXBUS(value uint32) {
	volatile.StoreUint32(&o.SCGC7.Reg, volatile.LoadUint32(&o.SCGC7.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetSCGC7_FLEXBUS() uint32 {
	return volatile.LoadUint32(&o.SCGC7.Reg) & 0x1
}
func (o *SIM_Type) SetSCGC7_DMA(value uint32) {
	volatile.StoreUint32(&o.SCGC7.Reg, volatile.LoadUint32(&o.SCGC7.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetSCGC7_DMA() uint32 {
	return (volatile.LoadUint32(&o.SCGC7.Reg) & 0x2) >> 1
}

// SIM.CLKDIV1: System Clock Divider Register 1
func (o *SIM_Type) SetCLKDIV1_OUTDIV4(value uint32) {
	volatile.StoreUint32(&o.CLKDIV1.Reg, volatile.LoadUint32(&o.CLKDIV1.Reg)&^(0xf0000)|value<<16)
}
func (o *SIM_Type) GetCLKDIV1_OUTDIV4() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV1.Reg) & 0xf0000) >> 16
}
func (o *SIM_Type) SetCLKDIV1_OUTDIV3(value uint32) {
	volatile.StoreUint32(&o.CLKDIV1.Reg, volatile.LoadUint32(&o.CLKDIV1.Reg)&^(0xf00000)|value<<20)
}
func (o *SIM_Type) GetCLKDIV1_OUTDIV3() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV1.Reg) & 0xf00000) >> 20
}
func (o *SIM_Type) SetCLKDIV1_OUTDIV2(value uint32) {
	volatile.StoreUint32(&o.CLKDIV1.Reg, volatile.LoadUint32(&o.CLKDIV1.Reg)&^(0xf000000)|value<<24)
}
func (o *SIM_Type) GetCLKDIV1_OUTDIV2() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV1.Reg) & 0xf000000) >> 24
}
func (o *SIM_Type) SetCLKDIV1_OUTDIV1(value uint32) {
	volatile.StoreUint32(&o.CLKDIV1.Reg, volatile.LoadUint32(&o.CLKDIV1.Reg)&^(0xf0000000)|value<<28)
}
func (o *SIM_Type) GetCLKDIV1_OUTDIV1() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV1.Reg) & 0xf0000000) >> 28
}

// SIM.CLKDIV2: System Clock Divider Register 2
func (o *SIM_Type) SetCLKDIV2_USBFRAC(value uint32) {
	volatile.StoreUint32(&o.CLKDIV2.Reg, volatile.LoadUint32(&o.CLKDIV2.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetCLKDIV2_USBFRAC() uint32 {
	return volatile.LoadUint32(&o.CLKDIV2.Reg) & 0x1
}
func (o *SIM_Type) SetCLKDIV2_USBDIV(value uint32) {
	volatile.StoreUint32(&o.CLKDIV2.Reg, volatile.LoadUint32(&o.CLKDIV2.Reg)&^(0xe)|value<<1)
}
func (o *SIM_Type) GetCLKDIV2_USBDIV() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV2.Reg) & 0xe) >> 1
}

// SIM.FCFG1: Flash Configuration Register 1
func (o *SIM_Type) SetFCFG1_FLASHDIS(value uint32) {
	volatile.StoreUint32(&o.FCFG1.Reg, volatile.LoadUint32(&o.FCFG1.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetFCFG1_FLASHDIS() uint32 {
	return volatile.LoadUint32(&o.FCFG1.Reg) & 0x1
}
func (o *SIM_Type) SetFCFG1_FLASHDOZE(value uint32) {
	volatile.StoreUint32(&o.FCFG1.Reg, volatile.LoadUint32(&o.FCFG1.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetFCFG1_FLASHDOZE() uint32 {
	return (volatile.LoadUint32(&o.FCFG1.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetFCFG1_PFSIZE(value uint32) {
	volatile.StoreUint32(&o.FCFG1.Reg, volatile.LoadUint32(&o.FCFG1.Reg)&^(0xf000000)|value<<24)
}
func (o *SIM_Type) GetFCFG1_PFSIZE() uint32 {
	return (volatile.LoadUint32(&o.FCFG1.Reg) & 0xf000000) >> 24
}

// SIM.FCFG2: Flash Configuration Register 2
func (o *SIM_Type) SetFCFG2_MAXADDR1(value uint32) {
	volatile.StoreUint32(&o.FCFG2.Reg, volatile.LoadUint32(&o.FCFG2.Reg)&^(0x7f0000)|value<<16)
}
func (o *SIM_Type) GetFCFG2_MAXADDR1() uint32 {
	return (volatile.LoadUint32(&o.FCFG2.Reg) & 0x7f0000) >> 16
}
func (o *SIM_Type) SetFCFG2_MAXADDR0(value uint32) {
	volatile.StoreUint32(&o.FCFG2.Reg, volatile.LoadUint32(&o.FCFG2.Reg)&^(0x7f000000)|value<<24)
}
func (o *SIM_Type) GetFCFG2_MAXADDR0() uint32 {
	return (volatile.LoadUint32(&o.FCFG2.Reg) & 0x7f000000) >> 24
}

// SIM.UIDH: Unique Identification Register High
func (o *SIM_Type) SetUIDH(value uint32) {
	volatile.StoreUint32(&o.UIDH.Reg, value)
}
func (o *SIM_Type) GetUIDH() uint32 {
	return volatile.LoadUint32(&o.UIDH.Reg)
}

// SIM.UIDMH: Unique Identification Register Mid-High
func (o *SIM_Type) SetUIDMH(value uint32) {
	volatile.StoreUint32(&o.UIDMH.Reg, value)
}
func (o *SIM_Type) GetUIDMH() uint32 {
	return volatile.LoadUint32(&o.UIDMH.Reg)
}

// SIM.UIDML: Unique Identification Register Mid Low
func (o *SIM_Type) SetUIDML(value uint32) {
	volatile.StoreUint32(&o.UIDML.Reg, value)
}
func (o *SIM_Type) GetUIDML() uint32 {
	return volatile.LoadUint32(&o.UIDML.Reg)
}

// SIM.UIDL: Unique Identification Register Low
func (o *SIM_Type) SetUIDL(value uint32) {
	volatile.StoreUint32(&o.UIDL.Reg, value)
}
func (o *SIM_Type) GetUIDL() uint32 {
	return volatile.LoadUint32(&o.UIDL.Reg)
}

// Pin Control and Interrupts
type PORT_Type struct {
	PCR0  volatile.Register32 // 0x0
	PCR1  volatile.Register32 // 0x4
	PCR2  volatile.Register32 // 0x8
	PCR3  volatile.Register32 // 0xC
	PCR4  volatile.Register32 // 0x10
	PCR5  volatile.Register32 // 0x14
	PCR6  volatile.Register32 // 0x18
	PCR7  volatile.Register32 // 0x1C
	PCR8  volatile.Register32 // 0x20
	PCR9  volatile.Register32 // 0x24
	PCR10 volatile.Register32 // 0x28
	PCR11 volatile.Register32 // 0x2C
	PCR12 volatile.Register32 // 0x30
	PCR13 volatile.Register32 // 0x34
	PCR14 volatile.Register32 // 0x38
	PCR15 volatile.Register32 // 0x3C
	PCR16 volatile.Register32 // 0x40
	PCR17 volatile.Register32 // 0x44
	PCR18 volatile.Register32 // 0x48
	PCR19 volatile.Register32 // 0x4C
	PCR20 volatile.Register32 // 0x50
	PCR21 volatile.Register32 // 0x54
	PCR22 volatile.Register32 // 0x58
	PCR23 volatile.Register32 // 0x5C
	PCR24 volatile.Register32 // 0x60
	PCR25 volatile.Register32 // 0x64
	PCR26 volatile.Register32 // 0x68
	PCR27 volatile.Register32 // 0x6C
	PCR28 volatile.Register32 // 0x70
	PCR29 volatile.Register32 // 0x74
	PCR30 volatile.Register32 // 0x78
	PCR31 volatile.Register32 // 0x7C
	GPCLR volatile.Register32 // 0x80
	GPCHR volatile.Register32 // 0x84
	_     [24]byte
	ISFR  volatile.Register32 // 0xA0
}

// PORT.PCR0: Pin Control Register n
func (o *PORT_Type) SetPCR0_PS(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR0_PS() uint32 {
	return volatile.LoadUint32(&o.PCR0.Reg) & 0x1
}
func (o *PORT_Type) SetPCR0_PE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR0_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR0_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR0_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR0_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR0_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR0_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR0_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR0_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR0_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR0_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR0_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR0_LK(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR0_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR0_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR0_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR0_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR0_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x1000000) >> 24
}

// PORT.PCR1: Pin Control Register n
func (o *PORT_Type) SetPCR1_PS(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR1_PS() uint32 {
	return volatile.LoadUint32(&o.PCR1.Reg) & 0x1
}
func (o *PORT_Type) SetPCR1_PE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR1_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR1_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR1_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR1_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR1_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR1_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR1_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR1_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR1_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR1_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR1_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR1_LK(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR1_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR1_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR1_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR1_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR1_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x1000000) >> 24
}

// PORT.PCR2: Pin Control Register n
func (o *PORT_Type) SetPCR2_PS(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR2_PS() uint32 {
	return volatile.LoadUint32(&o.PCR2.Reg) & 0x1
}
func (o *PORT_Type) SetPCR2_PE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR2_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR2_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR2_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR2_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR2_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR2_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR2_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR2_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR2_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR2_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR2_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR2_LK(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR2_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR2_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR2_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR2_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR2_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x1000000) >> 24
}

// PORT.PCR3: Pin Control Register n
func (o *PORT_Type) SetPCR3_PS(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR3_PS() uint32 {
	return volatile.LoadUint32(&o.PCR3.Reg) & 0x1
}
func (o *PORT_Type) SetPCR3_PE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR3_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR3_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR3_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR3_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR3_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR3_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR3_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR3_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR3_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR3_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR3_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR3_LK(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR3_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR3_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR3_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR3_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR3_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x1000000) >> 24
}

// PORT.PCR4: Pin Control Register n
func (o *PORT_Type) SetPCR4_PS(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR4_PS() uint32 {
	return volatile.LoadUint32(&o.PCR4.Reg) & 0x1
}
func (o *PORT_Type) SetPCR4_PE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR4_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR4_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR4_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR4_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR4_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR4_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR4_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR4_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR4_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR4_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR4_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR4_LK(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR4_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR4_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR4_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR4_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR4_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x1000000) >> 24
}

// PORT.PCR5: Pin Control Register n
func (o *PORT_Type) SetPCR5_PS(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR5_PS() uint32 {
	return volatile.LoadUint32(&o.PCR5.Reg) & 0x1
}
func (o *PORT_Type) SetPCR5_PE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR5_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR5_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR5_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR5_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR5_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR5_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR5_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR5_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR5_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR5_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR5_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR5_LK(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR5_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR5_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR5_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR5_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR5_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x1000000) >> 24
}

// PORT.PCR6: Pin Control Register n
func (o *PORT_Type) SetPCR6_PS(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR6_PS() uint32 {
	return volatile.LoadUint32(&o.PCR6.Reg) & 0x1
}
func (o *PORT_Type) SetPCR6_PE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR6_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR6_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR6_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR6_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR6_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR6_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR6_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR6_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR6_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR6_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR6_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR6_LK(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR6_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR6_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR6_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR6_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR6_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x1000000) >> 24
}

// PORT.PCR7: Pin Control Register n
func (o *PORT_Type) SetPCR7_PS(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR7_PS() uint32 {
	return volatile.LoadUint32(&o.PCR7.Reg) & 0x1
}
func (o *PORT_Type) SetPCR7_PE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR7_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR7_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR7_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR7_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR7_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR7_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR7_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR7_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR7_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR7_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR7_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR7_LK(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR7_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR7_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR7_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR7_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR7_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x1000000) >> 24
}

// PORT.PCR8: Pin Control Register n
func (o *PORT_Type) SetPCR8_PS(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR8_PS() uint32 {
	return volatile.LoadUint32(&o.PCR8.Reg) & 0x1
}
func (o *PORT_Type) SetPCR8_PE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR8_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR8_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR8_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR8_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR8_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR8_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR8_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR8_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR8_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR8_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR8_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR8_LK(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR8_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR8_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR8_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR8_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR8_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x1000000) >> 24
}

// PORT.PCR9: Pin Control Register n
func (o *PORT_Type) SetPCR9_PS(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR9_PS() uint32 {
	return volatile.LoadUint32(&o.PCR9.Reg) & 0x1
}
func (o *PORT_Type) SetPCR9_PE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR9_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR9_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR9_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR9_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR9_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR9_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR9_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR9_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR9_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR9_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR9_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR9_LK(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR9_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR9_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR9_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR9_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR9_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x1000000) >> 24
}

// PORT.PCR10: Pin Control Register n
func (o *PORT_Type) SetPCR10_PS(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR10_PS() uint32 {
	return volatile.LoadUint32(&o.PCR10.Reg) & 0x1
}
func (o *PORT_Type) SetPCR10_PE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR10_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR10_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR10_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR10_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR10_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR10_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR10_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR10_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR10_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR10_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR10_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR10_LK(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR10_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR10_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR10_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR10_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR10_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x1000000) >> 24
}

// PORT.PCR11: Pin Control Register n
func (o *PORT_Type) SetPCR11_PS(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR11_PS() uint32 {
	return volatile.LoadUint32(&o.PCR11.Reg) & 0x1
}
func (o *PORT_Type) SetPCR11_PE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR11_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR11_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR11_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR11_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR11_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR11_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR11_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR11_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR11_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR11_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR11_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR11_LK(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR11_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR11_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR11_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR11_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR11_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x1000000) >> 24
}

// PORT.PCR12: Pin Control Register n
func (o *PORT_Type) SetPCR12_PS(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR12_PS() uint32 {
	return volatile.LoadUint32(&o.PCR12.Reg) & 0x1
}
func (o *PORT_Type) SetPCR12_PE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR12_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR12_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR12_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR12_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR12_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR12_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR12_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR12_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR12_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR12_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR12_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR12_LK(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR12_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR12_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR12_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR12_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR12_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x1000000) >> 24
}

// PORT.PCR13: Pin Control Register n
func (o *PORT_Type) SetPCR13_PS(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR13_PS() uint32 {
	return volatile.LoadUint32(&o.PCR13.Reg) & 0x1
}
func (o *PORT_Type) SetPCR13_PE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR13_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR13_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR13_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR13_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR13_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR13_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR13_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR13_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR13_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR13_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR13_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR13_LK(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR13_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR13_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR13_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR13_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR13_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x1000000) >> 24
}

// PORT.PCR14: Pin Control Register n
func (o *PORT_Type) SetPCR14_PS(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR14_PS() uint32 {
	return volatile.LoadUint32(&o.PCR14.Reg) & 0x1
}
func (o *PORT_Type) SetPCR14_PE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR14_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR14_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR14_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR14_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR14_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR14_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR14_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR14_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR14_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR14_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR14_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR14_LK(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR14_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR14_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR14_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR14_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR14_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x1000000) >> 24
}

// PORT.PCR15: Pin Control Register n
func (o *PORT_Type) SetPCR15_PS(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR15_PS() uint32 {
	return volatile.LoadUint32(&o.PCR15.Reg) & 0x1
}
func (o *PORT_Type) SetPCR15_PE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR15_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR15_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR15_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR15_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR15_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR15_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR15_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR15_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR15_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR15_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR15_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR15_LK(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR15_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR15_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR15_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR15_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR15_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x1000000) >> 24
}

// PORT.PCR16: Pin Control Register n
func (o *PORT_Type) SetPCR16_PS(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR16_PS() uint32 {
	return volatile.LoadUint32(&o.PCR16.Reg) & 0x1
}
func (o *PORT_Type) SetPCR16_PE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR16_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR16_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR16_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR16_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR16_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR16_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR16_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR16_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR16_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR16_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR16_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR16_LK(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR16_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR16_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR16_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR16_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR16_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x1000000) >> 24
}

// PORT.PCR17: Pin Control Register n
func (o *PORT_Type) SetPCR17_PS(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR17_PS() uint32 {
	return volatile.LoadUint32(&o.PCR17.Reg) & 0x1
}
func (o *PORT_Type) SetPCR17_PE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR17_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR17_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR17_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR17_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR17_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR17_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR17_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR17_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR17_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR17_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR17_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR17_LK(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR17_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR17_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR17_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR17_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR17_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x1000000) >> 24
}

// PORT.PCR18: Pin Control Register n
func (o *PORT_Type) SetPCR18_PS(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR18_PS() uint32 {
	return volatile.LoadUint32(&o.PCR18.Reg) & 0x1
}
func (o *PORT_Type) SetPCR18_PE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR18_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR18_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR18_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR18_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR18_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR18_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR18_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR18_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR18_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR18_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR18_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR18_LK(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR18_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR18_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR18_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR18_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR18_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x1000000) >> 24
}

// PORT.PCR19: Pin Control Register n
func (o *PORT_Type) SetPCR19_PS(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR19_PS() uint32 {
	return volatile.LoadUint32(&o.PCR19.Reg) & 0x1
}
func (o *PORT_Type) SetPCR19_PE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR19_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR19_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR19_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR19_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR19_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR19_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR19_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR19_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR19_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR19_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR19_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR19_LK(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR19_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR19_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR19_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR19_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR19_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x1000000) >> 24
}

// PORT.PCR20: Pin Control Register n
func (o *PORT_Type) SetPCR20_PS(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR20_PS() uint32 {
	return volatile.LoadUint32(&o.PCR20.Reg) & 0x1
}
func (o *PORT_Type) SetPCR20_PE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR20_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR20_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR20_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR20_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR20_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR20_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR20_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR20_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR20_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR20_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR20_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR20_LK(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR20_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR20_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR20_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR20_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR20_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x1000000) >> 24
}

// PORT.PCR21: Pin Control Register n
func (o *PORT_Type) SetPCR21_PS(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR21_PS() uint32 {
	return volatile.LoadUint32(&o.PCR21.Reg) & 0x1
}
func (o *PORT_Type) SetPCR21_PE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR21_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR21_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR21_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR21_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR21_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR21_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR21_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR21_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR21_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR21_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR21_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR21_LK(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR21_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR21_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR21_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR21_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR21_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x1000000) >> 24
}

// PORT.PCR22: Pin Control Register n
func (o *PORT_Type) SetPCR22_PS(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR22_PS() uint32 {
	return volatile.LoadUint32(&o.PCR22.Reg) & 0x1
}
func (o *PORT_Type) SetPCR22_PE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR22_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR22_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR22_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR22_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR22_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR22_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR22_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR22_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR22_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR22_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR22_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR22_LK(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR22_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR22_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR22_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR22_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR22_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x1000000) >> 24
}

// PORT.PCR23: Pin Control Register n
func (o *PORT_Type) SetPCR23_PS(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR23_PS() uint32 {
	return volatile.LoadUint32(&o.PCR23.Reg) & 0x1
}
func (o *PORT_Type) SetPCR23_PE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR23_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR23_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR23_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR23_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR23_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR23_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR23_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR23_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR23_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR23_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR23_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR23_LK(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR23_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR23_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR23_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR23_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR23_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x1000000) >> 24
}

// PORT.PCR24: Pin Control Register n
func (o *PORT_Type) SetPCR24_PS(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR24_PS() uint32 {
	return volatile.LoadUint32(&o.PCR24.Reg) & 0x1
}
func (o *PORT_Type) SetPCR24_PE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR24_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR24_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR24_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR24_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR24_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR24_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR24_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR24_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR24_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR24_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR24_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR24_LK(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR24_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR24_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR24_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR24_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR24_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x1000000) >> 24
}

// PORT.PCR25: Pin Control Register n
func (o *PORT_Type) SetPCR25_PS(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR25_PS() uint32 {
	return volatile.LoadUint32(&o.PCR25.Reg) & 0x1
}
func (o *PORT_Type) SetPCR25_PE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR25_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR25_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR25_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR25_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR25_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR25_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR25_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR25_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR25_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR25_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR25_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR25_LK(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR25_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR25_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR25_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR25_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR25_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x1000000) >> 24
}

// PORT.PCR26: Pin Control Register n
func (o *PORT_Type) SetPCR26_PS(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR26_PS() uint32 {
	return volatile.LoadUint32(&o.PCR26.Reg) & 0x1
}
func (o *PORT_Type) SetPCR26_PE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR26_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR26_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR26_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR26_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR26_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR26_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR26_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR26_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR26_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR26_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR26_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR26_LK(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR26_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR26_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR26_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR26_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR26_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x1000000) >> 24
}

// PORT.PCR27: Pin Control Register n
func (o *PORT_Type) SetPCR27_PS(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR27_PS() uint32 {
	return volatile.LoadUint32(&o.PCR27.Reg) & 0x1
}
func (o *PORT_Type) SetPCR27_PE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR27_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR27_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR27_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR27_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR27_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR27_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR27_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR27_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR27_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR27_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR27_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR27_LK(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR27_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR27_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR27_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR27_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR27_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x1000000) >> 24
}

// PORT.PCR28: Pin Control Register n
func (o *PORT_Type) SetPCR28_PS(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR28_PS() uint32 {
	return volatile.LoadUint32(&o.PCR28.Reg) & 0x1
}
func (o *PORT_Type) SetPCR28_PE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR28_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR28_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR28_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR28_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR28_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR28_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR28_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR28_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR28_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR28_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR28_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR28_LK(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR28_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR28_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR28_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR28_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR28_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x1000000) >> 24
}

// PORT.PCR29: Pin Control Register n
func (o *PORT_Type) SetPCR29_PS(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR29_PS() uint32 {
	return volatile.LoadUint32(&o.PCR29.Reg) & 0x1
}
func (o *PORT_Type) SetPCR29_PE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR29_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR29_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR29_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR29_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR29_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR29_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR29_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR29_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR29_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR29_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR29_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR29_LK(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR29_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR29_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR29_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR29_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR29_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x1000000) >> 24
}

// PORT.PCR30: Pin Control Register n
func (o *PORT_Type) SetPCR30_PS(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR30_PS() uint32 {
	return volatile.LoadUint32(&o.PCR30.Reg) & 0x1
}
func (o *PORT_Type) SetPCR30_PE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR30_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR30_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR30_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR30_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR30_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR30_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR30_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR30_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR30_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR30_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR30_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR30_LK(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR30_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR30_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR30_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR30_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR30_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x1000000) >> 24
}

// PORT.PCR31: Pin Control Register n
func (o *PORT_Type) SetPCR31_PS(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR31_PS() uint32 {
	return volatile.LoadUint32(&o.PCR31.Reg) & 0x1
}
func (o *PORT_Type) SetPCR31_PE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR31_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR31_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR31_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR31_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR31_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR31_ODE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x20)|value<<5)
}
func (o *PORT_Type) GetPCR31_ODE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x20) >> 5
}
func (o *PORT_Type) SetPCR31_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR31_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR31_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR31_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR31_LK(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetPCR31_LK() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetPCR31_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR31_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR31_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR31_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x1000000) >> 24
}

// PORT.GPCLR: Global Pin Control Low Register
func (o *PORT_Type) SetGPCLR_GPWD(value uint32) {
	volatile.StoreUint32(&o.GPCLR.Reg, volatile.LoadUint32(&o.GPCLR.Reg)&^(0xffff)|value)
}
func (o *PORT_Type) GetGPCLR_GPWD() uint32 {
	return volatile.LoadUint32(&o.GPCLR.Reg) & 0xffff
}
func (o *PORT_Type) SetGPCLR_GPWE(value uint32) {
	volatile.StoreUint32(&o.GPCLR.Reg, volatile.LoadUint32(&o.GPCLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PORT_Type) GetGPCLR_GPWE() uint32 {
	return (volatile.LoadUint32(&o.GPCLR.Reg) & 0xffff0000) >> 16
}

// PORT.GPCHR: Global Pin Control High Register
func (o *PORT_Type) SetGPCHR_GPWD(value uint32) {
	volatile.StoreUint32(&o.GPCHR.Reg, volatile.LoadUint32(&o.GPCHR.Reg)&^(0xffff)|value)
}
func (o *PORT_Type) GetGPCHR_GPWD() uint32 {
	return volatile.LoadUint32(&o.GPCHR.Reg) & 0xffff
}
func (o *PORT_Type) SetGPCHR_GPWE(value uint32) {
	volatile.StoreUint32(&o.GPCHR.Reg, volatile.LoadUint32(&o.GPCHR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PORT_Type) GetGPCHR_GPWE() uint32 {
	return (volatile.LoadUint32(&o.GPCHR.Reg) & 0xffff0000) >> 16
}

// PORT.ISFR: Interrupt Status Flag Register
func (o *PORT_Type) SetISFR(value uint32) {
	volatile.StoreUint32(&o.ISFR.Reg, value)
}
func (o *PORT_Type) GetISFR() uint32 {
	return volatile.LoadUint32(&o.ISFR.Reg)
}

// Generation 2008 Watchdog Timer
type WDOG_Type struct {
	STCTRLH volatile.Register16 // 0x0
	STCTRLL volatile.Register16 // 0x2
	TOVALH  volatile.Register16 // 0x4
	TOVALL  volatile.Register16 // 0x6
	WINH    volatile.Register16 // 0x8
	WINL    volatile.Register16 // 0xA
	REFRESH volatile.Register16 // 0xC
	UNLOCK  volatile.Register16 // 0xE
	TMROUTH volatile.Register16 // 0x10
	TMROUTL volatile.Register16 // 0x12
	RSTCNT  volatile.Register16 // 0x14
	PRESC   volatile.Register16 // 0x16
}

// WDOG.STCTRLH: Watchdog Status and Control Register High
func (o *WDOG_Type) SetSTCTRLH_WDOGEN(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x1)|value)
}
func (o *WDOG_Type) GetSTCTRLH_WDOGEN() uint16 {
	return volatile.LoadUint16(&o.STCTRLH.Reg) & 0x1
}
func (o *WDOG_Type) SetSTCTRLH_CLKSRC(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x2)|value<<1)
}
func (o *WDOG_Type) GetSTCTRLH_CLKSRC() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x2) >> 1
}
func (o *WDOG_Type) SetSTCTRLH_IRQRSTEN(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x4)|value<<2)
}
func (o *WDOG_Type) GetSTCTRLH_IRQRSTEN() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x4) >> 2
}
func (o *WDOG_Type) SetSTCTRLH_WINEN(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x8)|value<<3)
}
func (o *WDOG_Type) GetSTCTRLH_WINEN() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x8) >> 3
}
func (o *WDOG_Type) SetSTCTRLH_ALLOWUPDATE(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x10)|value<<4)
}
func (o *WDOG_Type) GetSTCTRLH_ALLOWUPDATE() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x10) >> 4
}
func (o *WDOG_Type) SetSTCTRLH_DBGEN(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x20)|value<<5)
}
func (o *WDOG_Type) GetSTCTRLH_DBGEN() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x20) >> 5
}
func (o *WDOG_Type) SetSTCTRLH_STOPEN(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x40)|value<<6)
}
func (o *WDOG_Type) GetSTCTRLH_STOPEN() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x40) >> 6
}
func (o *WDOG_Type) SetSTCTRLH_WAITEN(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x80)|value<<7)
}
func (o *WDOG_Type) GetSTCTRLH_WAITEN() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x80) >> 7
}
func (o *WDOG_Type) SetSTCTRLH_TESTWDOG(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x400)|value<<10)
}
func (o *WDOG_Type) GetSTCTRLH_TESTWDOG() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x400) >> 10
}
func (o *WDOG_Type) SetSTCTRLH_TESTSEL(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x800)|value<<11)
}
func (o *WDOG_Type) GetSTCTRLH_TESTSEL() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x800) >> 11
}
func (o *WDOG_Type) SetSTCTRLH_BYTESEL(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x3000)|value<<12)
}
func (o *WDOG_Type) GetSTCTRLH_BYTESEL() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x3000) >> 12
}
func (o *WDOG_Type) SetSTCTRLH_DISTESTWDOG(value uint16) {
	volatile.StoreUint16(&o.STCTRLH.Reg, volatile.LoadUint16(&o.STCTRLH.Reg)&^(0x4000)|value<<14)
}
func (o *WDOG_Type) GetSTCTRLH_DISTESTWDOG() uint16 {
	return (volatile.LoadUint16(&o.STCTRLH.Reg) & 0x4000) >> 14
}

// WDOG.STCTRLL: Watchdog Status and Control Register Low
func (o *WDOG_Type) SetSTCTRLL_INTFLG(value uint16) {
	volatile.StoreUint16(&o.STCTRLL.Reg, volatile.LoadUint16(&o.STCTRLL.Reg)&^(0x8000)|value<<15)
}
func (o *WDOG_Type) GetSTCTRLL_INTFLG() uint16 {
	return (volatile.LoadUint16(&o.STCTRLL.Reg) & 0x8000) >> 15
}

// WDOG.TOVALH: Watchdog Time-out Value Register High
func (o *WDOG_Type) SetTOVALH(value uint16) {
	volatile.StoreUint16(&o.TOVALH.Reg, value)
}
func (o *WDOG_Type) GetTOVALH() uint16 {
	return volatile.LoadUint16(&o.TOVALH.Reg)
}

// WDOG.TOVALL: Watchdog Time-out Value Register Low
func (o *WDOG_Type) SetTOVALL(value uint16) {
	volatile.StoreUint16(&o.TOVALL.Reg, value)
}
func (o *WDOG_Type) GetTOVALL() uint16 {
	return volatile.LoadUint16(&o.TOVALL.Reg)
}

// WDOG.WINH: Watchdog Window Register High
func (o *WDOG_Type) SetWINH(value uint16) {
	volatile.StoreUint16(&o.WINH.Reg, value)
}
func (o *WDOG_Type) GetWINH() uint16 {
	return volatile.LoadUint16(&o.WINH.Reg)
}

// WDOG.WINL: Watchdog Window Register Low
func (o *WDOG_Type) SetWINL(value uint16) {
	volatile.StoreUint16(&o.WINL.Reg, value)
}
func (o *WDOG_Type) GetWINL() uint16 {
	return volatile.LoadUint16(&o.WINL.Reg)
}

// WDOG.REFRESH: Watchdog Refresh register
func (o *WDOG_Type) SetREFRESH(value uint16) {
	volatile.StoreUint16(&o.REFRESH.Reg, value)
}
func (o *WDOG_Type) GetREFRESH() uint16 {
	return volatile.LoadUint16(&o.REFRESH.Reg)
}

// WDOG.UNLOCK: Watchdog Unlock register
func (o *WDOG_Type) SetUNLOCK(value uint16) {
	volatile.StoreUint16(&o.UNLOCK.Reg, value)
}
func (o *WDOG_Type) GetUNLOCK() uint16 {
	return volatile.LoadUint16(&o.UNLOCK.Reg)
}

// WDOG.TMROUTH: Watchdog Timer Output Register High
func (o *WDOG_Type) SetTMROUTH(value uint16) {
	volatile.StoreUint16(&o.TMROUTH.Reg, value)
}
func (o *WDOG_Type) GetTMROUTH() uint16 {
	return volatile.LoadUint16(&o.TMROUTH.Reg)
}

// WDOG.TMROUTL: Watchdog Timer Output Register Low
func (o *WDOG_Type) SetTMROUTL(value uint16) {
	volatile.StoreUint16(&o.TMROUTL.Reg, value)
}
func (o *WDOG_Type) GetTMROUTL() uint16 {
	return volatile.LoadUint16(&o.TMROUTL.Reg)
}

// WDOG.RSTCNT: Watchdog Reset Count register
func (o *WDOG_Type) SetRSTCNT(value uint16) {
	volatile.StoreUint16(&o.RSTCNT.Reg, value)
}
func (o *WDOG_Type) GetRSTCNT() uint16 {
	return volatile.LoadUint16(&o.RSTCNT.Reg)
}

// WDOG.PRESC: Watchdog Prescaler register
func (o *WDOG_Type) SetPRESC_PRESCVAL(value uint16) {
	volatile.StoreUint16(&o.PRESC.Reg, volatile.LoadUint16(&o.PRESC.Reg)&^(0x700)|value<<8)
}
func (o *WDOG_Type) GetPRESC_PRESCVAL() uint16 {
	return (volatile.LoadUint16(&o.PRESC.Reg) & 0x700) >> 8
}

// External Watchdog Monitor
type EWM_Type struct {
	CTRL         volatile.Register8 // 0x0
	SERV         volatile.Register8 // 0x1
	CMPL         volatile.Register8 // 0x2
	CMPH         volatile.Register8 // 0x3
	_            byte
	CLKPRESCALER volatile.Register8 // 0x5
}

// EWM.CTRL: Control Register
func (o *EWM_Type) SetCTRL_EWMEN(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *EWM_Type) GetCTRL_EWMEN() uint8 {
	return volatile.LoadUint8(&o.CTRL.Reg) & 0x1
}
func (o *EWM_Type) SetCTRL_ASSIN(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EWM_Type) GetCTRL_ASSIN() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *EWM_Type) SetCTRL_INEN(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EWM_Type) GetCTRL_INEN() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *EWM_Type) SetCTRL_INTEN(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EWM_Type) GetCTRL_INTEN() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x8) >> 3
}

// EWM.SERV: Service Register
func (o *EWM_Type) SetSERV(value uint8) {
	volatile.StoreUint8(&o.SERV.Reg, value)
}
func (o *EWM_Type) GetSERV() uint8 {
	return volatile.LoadUint8(&o.SERV.Reg)
}

// EWM.CMPL: Compare Low Register
func (o *EWM_Type) SetCMPL(value uint8) {
	volatile.StoreUint8(&o.CMPL.Reg, value)
}
func (o *EWM_Type) GetCMPL() uint8 {
	return volatile.LoadUint8(&o.CMPL.Reg)
}

// EWM.CMPH: Compare High Register
func (o *EWM_Type) SetCMPH(value uint8) {
	volatile.StoreUint8(&o.CMPH.Reg, value)
}
func (o *EWM_Type) GetCMPH() uint8 {
	return volatile.LoadUint8(&o.CMPH.Reg)
}

// EWM.CLKPRESCALER: Clock Prescaler Register
func (o *EWM_Type) SetCLKPRESCALER(value uint8) {
	volatile.StoreUint8(&o.CLKPRESCALER.Reg, value)
}
func (o *EWM_Type) GetCLKPRESCALER() uint8 {
	return volatile.LoadUint8(&o.CLKPRESCALER.Reg)
}

// Multipurpose Clock Generator module
type MCG_Type struct {
	C1    volatile.Register8 // 0x0
	C2    volatile.Register8 // 0x1
	C3    volatile.Register8 // 0x2
	C4    volatile.Register8 // 0x3
	C5    volatile.Register8 // 0x4
	C6    volatile.Register8 // 0x5
	S     volatile.Register8 // 0x6
	_     byte
	SC    volatile.Register8 // 0x8
	_     byte
	ATCVH volatile.Register8 // 0xA
	ATCVL volatile.Register8 // 0xB
	C7    volatile.Register8 // 0xC
	C8    volatile.Register8 // 0xD
}

// MCG.C1: MCG Control 1 Register
func (o *MCG_Type) SetC1_IREFSTEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetC1_IREFSTEN() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *MCG_Type) SetC1_IRCLKEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x2)|value<<1)
}
func (o *MCG_Type) GetC1_IRCLKEN() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x2) >> 1
}
func (o *MCG_Type) SetC1_IREFS(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x4)|value<<2)
}
func (o *MCG_Type) GetC1_IREFS() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x4) >> 2
}
func (o *MCG_Type) SetC1_FRDIV(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x38)|value<<3)
}
func (o *MCG_Type) GetC1_FRDIV() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x38) >> 3
}
func (o *MCG_Type) SetC1_CLKS(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0xc0)|value<<6)
}
func (o *MCG_Type) GetC1_CLKS() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0xc0) >> 6
}

// MCG.C2: MCG Control 2 Register
func (o *MCG_Type) SetC2_IRCS(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetC2_IRCS() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0x1
}
func (o *MCG_Type) SetC2_LP(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x2)|value<<1)
}
func (o *MCG_Type) GetC2_LP() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x2) >> 1
}
func (o *MCG_Type) SetC2_EREFS(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x4)|value<<2)
}
func (o *MCG_Type) GetC2_EREFS() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x4) >> 2
}
func (o *MCG_Type) SetC2_HGO(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x8)|value<<3)
}
func (o *MCG_Type) GetC2_HGO() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x8) >> 3
}
func (o *MCG_Type) SetC2_RANGE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x30)|value<<4)
}
func (o *MCG_Type) GetC2_RANGE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x30) >> 4
}
func (o *MCG_Type) SetC2_FCFTRIM(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetC2_FCFTRIM() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x40) >> 6
}
func (o *MCG_Type) SetC2_LOCRE0(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetC2_LOCRE0() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x80) >> 7
}

// MCG.C3: MCG Control 3 Register
func (o *MCG_Type) SetC3(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, value)
}
func (o *MCG_Type) GetC3() uint8 {
	return volatile.LoadUint8(&o.C3.Reg)
}

// MCG.C4: MCG Control 4 Register
func (o *MCG_Type) SetC4_SCFTRIM(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetC4_SCFTRIM() uint8 {
	return volatile.LoadUint8(&o.C4.Reg) & 0x1
}
func (o *MCG_Type) SetC4_FCTRIM(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x1e)|value<<1)
}
func (o *MCG_Type) GetC4_FCTRIM() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x1e) >> 1
}
func (o *MCG_Type) SetC4_DRST_DRS(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x60)|value<<5)
}
func (o *MCG_Type) GetC4_DRST_DRS() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x60) >> 5
}
func (o *MCG_Type) SetC4_DMX32(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetC4_DMX32() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x80) >> 7
}

// MCG.C5: MCG Control 5 Register
func (o *MCG_Type) SetC5_PRDIV0(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x1f)|value)
}
func (o *MCG_Type) GetC5_PRDIV0() uint8 {
	return volatile.LoadUint8(&o.C5.Reg) & 0x1f
}
func (o *MCG_Type) SetC5_PLLSTEN0(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x20)|value<<5)
}
func (o *MCG_Type) GetC5_PLLSTEN0() uint8 {
	return (volatile.LoadUint8(&o.C5.Reg) & 0x20) >> 5
}
func (o *MCG_Type) SetC5_PLLCLKEN0(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetC5_PLLCLKEN0() uint8 {
	return (volatile.LoadUint8(&o.C5.Reg) & 0x40) >> 6
}

// MCG.C6: MCG Control 6 Register
func (o *MCG_Type) SetC6_VDIV0(value uint8) {
	volatile.StoreUint8(&o.C6.Reg, volatile.LoadUint8(&o.C6.Reg)&^(0x1f)|value)
}
func (o *MCG_Type) GetC6_VDIV0() uint8 {
	return volatile.LoadUint8(&o.C6.Reg) & 0x1f
}
func (o *MCG_Type) SetC6_CME0(value uint8) {
	volatile.StoreUint8(&o.C6.Reg, volatile.LoadUint8(&o.C6.Reg)&^(0x20)|value<<5)
}
func (o *MCG_Type) GetC6_CME0() uint8 {
	return (volatile.LoadUint8(&o.C6.Reg) & 0x20) >> 5
}
func (o *MCG_Type) SetC6_PLLS(value uint8) {
	volatile.StoreUint8(&o.C6.Reg, volatile.LoadUint8(&o.C6.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetC6_PLLS() uint8 {
	return (volatile.LoadUint8(&o.C6.Reg) & 0x40) >> 6
}
func (o *MCG_Type) SetC6_LOLIE0(value uint8) {
	volatile.StoreUint8(&o.C6.Reg, volatile.LoadUint8(&o.C6.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetC6_LOLIE0() uint8 {
	return (volatile.LoadUint8(&o.C6.Reg) & 0x80) >> 7
}

// MCG.S: MCG Status Register
func (o *MCG_Type) SetS_IRCST(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetS_IRCST() uint8 {
	return volatile.LoadUint8(&o.S.Reg) & 0x1
}
func (o *MCG_Type) SetS_OSCINIT0(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x2)|value<<1)
}
func (o *MCG_Type) GetS_OSCINIT0() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x2) >> 1
}
func (o *MCG_Type) SetS_CLKST(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0xc)|value<<2)
}
func (o *MCG_Type) GetS_CLKST() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0xc) >> 2
}
func (o *MCG_Type) SetS_IREFST(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x10)|value<<4)
}
func (o *MCG_Type) GetS_IREFST() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x10) >> 4
}
func (o *MCG_Type) SetS_PLLST(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x20)|value<<5)
}
func (o *MCG_Type) GetS_PLLST() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x20) >> 5
}
func (o *MCG_Type) SetS_LOCK0(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetS_LOCK0() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x40) >> 6
}
func (o *MCG_Type) SetS_LOLS0(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetS_LOLS0() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x80) >> 7
}

// MCG.SC: MCG Status and Control Register
func (o *MCG_Type) SetSC_LOCS0(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetSC_LOCS0() uint8 {
	return volatile.LoadUint8(&o.SC.Reg) & 0x1
}
func (o *MCG_Type) SetSC_FCRDIV(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0xe)|value<<1)
}
func (o *MCG_Type) GetSC_FCRDIV() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0xe) >> 1
}
func (o *MCG_Type) SetSC_FLTPRSRV(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x10)|value<<4)
}
func (o *MCG_Type) GetSC_FLTPRSRV() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x10) >> 4
}
func (o *MCG_Type) SetSC_ATMF(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x20)|value<<5)
}
func (o *MCG_Type) GetSC_ATMF() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x20) >> 5
}
func (o *MCG_Type) SetSC_ATMS(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetSC_ATMS() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x40) >> 6
}
func (o *MCG_Type) SetSC_ATME(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetSC_ATME() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x80) >> 7
}

// MCG.ATCVH: MCG Auto Trim Compare Value High Register
func (o *MCG_Type) SetATCVH(value uint8) {
	volatile.StoreUint8(&o.ATCVH.Reg, value)
}
func (o *MCG_Type) GetATCVH() uint8 {
	return volatile.LoadUint8(&o.ATCVH.Reg)
}

// MCG.ATCVL: MCG Auto Trim Compare Value Low Register
func (o *MCG_Type) SetATCVL(value uint8) {
	volatile.StoreUint8(&o.ATCVL.Reg, value)
}
func (o *MCG_Type) GetATCVL() uint8 {
	return volatile.LoadUint8(&o.ATCVL.Reg)
}

// MCG.C7: MCG Control 7 Register
func (o *MCG_Type) SetC7_OSCSEL(value uint8) {
	volatile.StoreUint8(&o.C7.Reg, volatile.LoadUint8(&o.C7.Reg)&^(0x3)|value)
}
func (o *MCG_Type) GetC7_OSCSEL() uint8 {
	return volatile.LoadUint8(&o.C7.Reg) & 0x3
}

// MCG.C8: MCG Control 8 Register
func (o *MCG_Type) SetC8_LOCS1(value uint8) {
	volatile.StoreUint8(&o.C8.Reg, volatile.LoadUint8(&o.C8.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetC8_LOCS1() uint8 {
	return volatile.LoadUint8(&o.C8.Reg) & 0x1
}
func (o *MCG_Type) SetC8_CME1(value uint8) {
	volatile.StoreUint8(&o.C8.Reg, volatile.LoadUint8(&o.C8.Reg)&^(0x20)|value<<5)
}
func (o *MCG_Type) GetC8_CME1() uint8 {
	return (volatile.LoadUint8(&o.C8.Reg) & 0x20) >> 5
}
func (o *MCG_Type) SetC8_LOLRE(value uint8) {
	volatile.StoreUint8(&o.C8.Reg, volatile.LoadUint8(&o.C8.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetC8_LOLRE() uint8 {
	return (volatile.LoadUint8(&o.C8.Reg) & 0x40) >> 6
}
func (o *MCG_Type) SetC8_LOCRE1(value uint8) {
	volatile.StoreUint8(&o.C8.Reg, volatile.LoadUint8(&o.C8.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetC8_LOCRE1() uint8 {
	return (volatile.LoadUint8(&o.C8.Reg) & 0x80) >> 7
}

// Oscillator
type OSC_Type struct {
	CR  volatile.Register8 // 0x0
	_   byte
	DIV volatile.Register8 // 0x2
}

// OSC.CR: OSC Control Register
func (o *OSC_Type) SetCR_SC16P(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x1)|value)
}
func (o *OSC_Type) GetCR_SC16P() uint8 {
	return volatile.LoadUint8(&o.CR.Reg) & 0x1
}
func (o *OSC_Type) SetCR_SC8P(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *OSC_Type) GetCR_SC8P() uint8 {
	return (volatile.LoadUint8(&o.CR.Reg) & 0x2) >> 1
}
func (o *OSC_Type) SetCR_SC4P(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *OSC_Type) GetCR_SC4P() uint8 {
	return (volatile.LoadUint8(&o.CR.Reg) & 0x4) >> 2
}
func (o *OSC_Type) SetCR_SC2P(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *OSC_Type) GetCR_SC2P() uint8 {
	return (volatile.LoadUint8(&o.CR.Reg) & 0x8) >> 3
}
func (o *OSC_Type) SetCR_EREFSTEN(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *OSC_Type) GetCR_EREFSTEN() uint8 {
	return (volatile.LoadUint8(&o.CR.Reg) & 0x20) >> 5
}
func (o *OSC_Type) SetCR_ERCLKEN(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *OSC_Type) GetCR_ERCLKEN() uint8 {
	return (volatile.LoadUint8(&o.CR.Reg) & 0x80) >> 7
}

// OSC.DIV: OSC_DIV
func (o *OSC_Type) SetDIV_ERPS(value uint8) {
	volatile.StoreUint8(&o.DIV.Reg, volatile.LoadUint8(&o.DIV.Reg)&^(0xc0)|value<<6)
}
func (o *OSC_Type) GetDIV_ERPS() uint8 {
	return (volatile.LoadUint8(&o.DIV.Reg) & 0xc0) >> 6
}

// Inter-Integrated Circuit
type I2C_Type struct {
	A1   volatile.Register8 // 0x0
	F    volatile.Register8 // 0x1
	C1   volatile.Register8 // 0x2
	S    volatile.Register8 // 0x3
	D    volatile.Register8 // 0x4
	C2   volatile.Register8 // 0x5
	FLT  volatile.Register8 // 0x6
	RA   volatile.Register8 // 0x7
	SMB  volatile.Register8 // 0x8
	A2   volatile.Register8 // 0x9
	SLTH volatile.Register8 // 0xA
	SLTL volatile.Register8 // 0xB
}

// I2C.A1: I2C Address Register 1
func (o *I2C_Type) SetA1_AD(value uint8) {
	volatile.StoreUint8(&o.A1.Reg, volatile.LoadUint8(&o.A1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetA1_AD() uint8 {
	return (volatile.LoadUint8(&o.A1.Reg) & 0xfe) >> 1
}

// I2C.F: I2C Frequency Divider register
func (o *I2C_Type) SetF_ICR(value uint8) {
	volatile.StoreUint8(&o.F.Reg, volatile.LoadUint8(&o.F.Reg)&^(0x3f)|value)
}
func (o *I2C_Type) GetF_ICR() uint8 {
	return volatile.LoadUint8(&o.F.Reg) & 0x3f
}
func (o *I2C_Type) SetF_MULT(value uint8) {
	volatile.StoreUint8(&o.F.Reg, volatile.LoadUint8(&o.F.Reg)&^(0xc0)|value<<6)
}
func (o *I2C_Type) GetF_MULT() uint8 {
	return (volatile.LoadUint8(&o.F.Reg) & 0xc0) >> 6
}

// I2C.C1: I2C Control Register 1
func (o *I2C_Type) SetC1_DMAEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetC1_DMAEN() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *I2C_Type) SetC1_WUEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetC1_WUEN() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetC1_RSTA(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetC1_RSTA() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetC1_TXAK(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetC1_TXAK() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetC1_TX(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetC1_TX() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetC1_MST(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetC1_MST() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetC1_IICIE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetC1_IICIE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetC1_IICEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetC1_IICEN() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x80) >> 7
}

// I2C.S: I2C Status register
func (o *I2C_Type) SetS_RXAK(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetS_RXAK() uint8 {
	return volatile.LoadUint8(&o.S.Reg) & 0x1
}
func (o *I2C_Type) SetS_IICIF(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetS_IICIF() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetS_SRW(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetS_SRW() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetS_RAM(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetS_RAM() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetS_ARBL(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetS_ARBL() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetS_BUSY(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetS_BUSY() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetS_IAAS(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetS_IAAS() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetS_TCF(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetS_TCF() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x80) >> 7
}

// I2C.D: I2C Data I/O register
func (o *I2C_Type) SetD(value uint8) {
	volatile.StoreUint8(&o.D.Reg, value)
}
func (o *I2C_Type) GetD() uint8 {
	return volatile.LoadUint8(&o.D.Reg)
}

// I2C.C2: I2C Control Register 2
func (o *I2C_Type) SetC2_AD(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetC2_AD() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0x7
}
func (o *I2C_Type) SetC2_RMEN(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetC2_RMEN() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetC2_SBRC(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetC2_SBRC() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetC2_HDRS(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetC2_HDRS() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetC2_ADEXT(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetC2_ADEXT() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetC2_GCAEN(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetC2_GCAEN() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x80) >> 7
}

// I2C.FLT: I2C Programmable Input Glitch Filter register
func (o *I2C_Type) SetFLT(value uint8) {
	volatile.StoreUint8(&o.FLT.Reg, volatile.LoadUint8(&o.FLT.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetFLT() uint8 {
	return volatile.LoadUint8(&o.FLT.Reg) & 0xf
}
func (o *I2C_Type) SetFLT_STARTF(value uint8) {
	volatile.StoreUint8(&o.FLT.Reg, volatile.LoadUint8(&o.FLT.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetFLT_STARTF() uint8 {
	return (volatile.LoadUint8(&o.FLT.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetFLT_SSIE(value uint8) {
	volatile.StoreUint8(&o.FLT.Reg, volatile.LoadUint8(&o.FLT.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetFLT_SSIE() uint8 {
	return (volatile.LoadUint8(&o.FLT.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetFLT_STOPF(value uint8) {
	volatile.StoreUint8(&o.FLT.Reg, volatile.LoadUint8(&o.FLT.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetFLT_STOPF() uint8 {
	return (volatile.LoadUint8(&o.FLT.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetFLT_SHEN(value uint8) {
	volatile.StoreUint8(&o.FLT.Reg, volatile.LoadUint8(&o.FLT.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetFLT_SHEN() uint8 {
	return (volatile.LoadUint8(&o.FLT.Reg) & 0x80) >> 7
}

// I2C.RA: I2C Range Address register
func (o *I2C_Type) SetRA_RAD(value uint8) {
	volatile.StoreUint8(&o.RA.Reg, volatile.LoadUint8(&o.RA.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetRA_RAD() uint8 {
	return (volatile.LoadUint8(&o.RA.Reg) & 0xfe) >> 1
}

// I2C.SMB: I2C SMBus Control and Status register
func (o *I2C_Type) SetSMB_SHTF2IE(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSMB_SHTF2IE() uint8 {
	return volatile.LoadUint8(&o.SMB.Reg) & 0x1
}
func (o *I2C_Type) SetSMB_SHTF2(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSMB_SHTF2() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSMB_SHTF1(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSMB_SHTF1() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSMB_SLTF(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSMB_SLTF() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSMB_TCKSEL(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSMB_TCKSEL() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSMB_SIICAEN(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSMB_SIICAEN() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSMB_ALERTEN(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSMB_ALERTEN() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSMB_FACK(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSMB_FACK() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x80) >> 7
}

// I2C.A2: I2C Address Register 2
func (o *I2C_Type) SetA2_SAD(value uint8) {
	volatile.StoreUint8(&o.A2.Reg, volatile.LoadUint8(&o.A2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetA2_SAD() uint8 {
	return (volatile.LoadUint8(&o.A2.Reg) & 0xfe) >> 1
}

// I2C.SLTH: I2C SCL Low Timeout Register High
func (o *I2C_Type) SetSLTH(value uint8) {
	volatile.StoreUint8(&o.SLTH.Reg, value)
}
func (o *I2C_Type) GetSLTH() uint8 {
	return volatile.LoadUint8(&o.SLTH.Reg)
}

// I2C.SLTL: I2C SCL Low Timeout Register Low
func (o *I2C_Type) SetSLTL(value uint8) {
	volatile.StoreUint8(&o.SLTL.Reg, value)
}
func (o *I2C_Type) GetSLTL() uint8 {
	return volatile.LoadUint8(&o.SLTL.Reg)
}

// Serial Communication Interface
type UART_Type struct {
	BDH        volatile.Register8 // 0x0
	BDL        volatile.Register8 // 0x1
	C1         volatile.Register8 // 0x2
	C2         volatile.Register8 // 0x3
	S1         volatile.Register8 // 0x4
	S2         volatile.Register8 // 0x5
	C3         volatile.Register8 // 0x6
	D          volatile.Register8 // 0x7
	MA1        volatile.Register8 // 0x8
	MA2        volatile.Register8 // 0x9
	C4         volatile.Register8 // 0xA
	C5         volatile.Register8 // 0xB
	ED         volatile.Register8 // 0xC
	MODEM      volatile.Register8 // 0xD
	IR         volatile.Register8 // 0xE
	_          byte
	PFIFO      volatile.Register8 // 0x10
	CFIFO      volatile.Register8 // 0x11
	SFIFO      volatile.Register8 // 0x12
	TWFIFO     volatile.Register8 // 0x13
	TCFIFO     volatile.Register8 // 0x14
	RWFIFO     volatile.Register8 // 0x15
	RCFIFO     volatile.Register8 // 0x16
	_          byte
	C7816      volatile.Register8 // 0x18
	IE7816     volatile.Register8 // 0x19
	IS7816     volatile.Register8 // 0x1A
	WP7816     volatile.Register8 // 0x1B
	WN7816     volatile.Register8 // 0x1C
	WF7816     volatile.Register8 // 0x1D
	ET7816     volatile.Register8 // 0x1E
	TL7816     volatile.Register8 // 0x1F
	_          [26]byte
	AP7816A_T0 volatile.Register8 // 0x3A
	AP7816B_T0 volatile.Register8 // 0x3B
	WP7816A_T0 volatile.Register8 // 0x3C
	WP7816B_T0 volatile.Register8 // 0x3D
	WGP7816_T1 volatile.Register8 // 0x3E
	WP7816C_T1 volatile.Register8 // 0x3F
}

// UART.BDH: UART Baud Rate Registers: High
func (o *UART_Type) SetBDH_SBR(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x1f)|value)
}
func (o *UART_Type) GetBDH_SBR() uint8 {
	return volatile.LoadUint8(&o.BDH.Reg) & 0x1f
}
func (o *UART_Type) SetBDH_RXEDGIE(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetBDH_RXEDGIE() uint8 {
	return (volatile.LoadUint8(&o.BDH.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetBDH_LBKDIE(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetBDH_LBKDIE() uint8 {
	return (volatile.LoadUint8(&o.BDH.Reg) & 0x80) >> 7
}

// UART.BDL: UART Baud Rate Registers: Low
func (o *UART_Type) SetBDL(value uint8) {
	volatile.StoreUint8(&o.BDL.Reg, value)
}
func (o *UART_Type) GetBDL() uint8 {
	return volatile.LoadUint8(&o.BDL.Reg)
}

// UART.C1: UART Control Register 1
func (o *UART_Type) SetC1_PT(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetC1_PT() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *UART_Type) SetC1_PE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetC1_PE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetC1_ILT(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetC1_ILT() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetC1_WAKE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetC1_WAKE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetC1_M(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetC1_M() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetC1_RSRC(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetC1_RSRC() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetC1_UARTSWAI(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetC1_UARTSWAI() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetC1_LOOPS(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetC1_LOOPS() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x80) >> 7
}

// UART.C2: UART Control Register 2
func (o *UART_Type) SetC2_SBK(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetC2_SBK() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0x1
}
func (o *UART_Type) SetC2_RWU(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetC2_RWU() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetC2_RE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetC2_RE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetC2_TE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetC2_TE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetC2_ILIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetC2_ILIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetC2_RIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetC2_RIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetC2_TCIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetC2_TCIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetC2_TIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetC2_TIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x80) >> 7
}

// UART.S1: UART Status Register 1
func (o *UART_Type) SetS1_PF(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetS1_PF() uint8 {
	return volatile.LoadUint8(&o.S1.Reg) & 0x1
}
func (o *UART_Type) SetS1_FE(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetS1_FE() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetS1_NF(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetS1_NF() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetS1_OR(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetS1_OR() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetS1_IDLE(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetS1_IDLE() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetS1_RDRF(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetS1_RDRF() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetS1_TC(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetS1_TC() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetS1_TDRE(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetS1_TDRE() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x80) >> 7
}

// UART.S2: UART Status Register 2
func (o *UART_Type) SetS2_RAF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetS2_RAF() uint8 {
	return volatile.LoadUint8(&o.S2.Reg) & 0x1
}
func (o *UART_Type) SetS2_LBKDE(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetS2_LBKDE() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetS2_BRK13(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetS2_BRK13() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetS2_RWUID(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetS2_RWUID() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetS2_RXINV(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetS2_RXINV() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetS2_MSBF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetS2_MSBF() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetS2_RXEDGIF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetS2_RXEDGIF() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetS2_LBKDIF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetS2_LBKDIF() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x80) >> 7
}

// UART.C3: UART Control Register 3
func (o *UART_Type) SetC3_PEIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetC3_PEIE() uint8 {
	return volatile.LoadUint8(&o.C3.Reg) & 0x1
}
func (o *UART_Type) SetC3_FEIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetC3_FEIE() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetC3_NEIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetC3_NEIE() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetC3_ORIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetC3_ORIE() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetC3_TXINV(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetC3_TXINV() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetC3_TXDIR(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetC3_TXDIR() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetC3_T8(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetC3_T8() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetC3_R8(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetC3_R8() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x80) >> 7
}

// UART.D: UART Data Register
func (o *UART_Type) SetD(value uint8) {
	volatile.StoreUint8(&o.D.Reg, value)
}
func (o *UART_Type) GetD() uint8 {
	return volatile.LoadUint8(&o.D.Reg)
}

// UART.MA1: UART Match Address Registers 1
func (o *UART_Type) SetMA1(value uint8) {
	volatile.StoreUint8(&o.MA1.Reg, value)
}
func (o *UART_Type) GetMA1() uint8 {
	return volatile.LoadUint8(&o.MA1.Reg)
}

// UART.MA2: UART Match Address Registers 2
func (o *UART_Type) SetMA2(value uint8) {
	volatile.StoreUint8(&o.MA2.Reg, value)
}
func (o *UART_Type) GetMA2() uint8 {
	return volatile.LoadUint8(&o.MA2.Reg)
}

// UART.C4: UART Control Register 4
func (o *UART_Type) SetC4_BRFA(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x1f)|value)
}
func (o *UART_Type) GetC4_BRFA() uint8 {
	return volatile.LoadUint8(&o.C4.Reg) & 0x1f
}
func (o *UART_Type) SetC4_M10(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetC4_M10() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetC4_MAEN2(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetC4_MAEN2() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetC4_MAEN1(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetC4_MAEN1() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x80) >> 7
}

// UART.C5: UART Control Register 5
func (o *UART_Type) SetC5_RDMAS(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetC5_RDMAS() uint8 {
	return (volatile.LoadUint8(&o.C5.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetC5_TDMAS(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetC5_TDMAS() uint8 {
	return (volatile.LoadUint8(&o.C5.Reg) & 0x80) >> 7
}

// UART.ED: UART Extended Data Register
func (o *UART_Type) SetED_PARITYE(value uint8) {
	volatile.StoreUint8(&o.ED.Reg, volatile.LoadUint8(&o.ED.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetED_PARITYE() uint8 {
	return (volatile.LoadUint8(&o.ED.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetED_NOISY(value uint8) {
	volatile.StoreUint8(&o.ED.Reg, volatile.LoadUint8(&o.ED.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetED_NOISY() uint8 {
	return (volatile.LoadUint8(&o.ED.Reg) & 0x80) >> 7
}

// UART.MODEM: UART Modem Register
func (o *UART_Type) SetMODEM_TXCTSE(value uint8) {
	volatile.StoreUint8(&o.MODEM.Reg, volatile.LoadUint8(&o.MODEM.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetMODEM_TXCTSE() uint8 {
	return volatile.LoadUint8(&o.MODEM.Reg) & 0x1
}
func (o *UART_Type) SetMODEM_TXRTSE(value uint8) {
	volatile.StoreUint8(&o.MODEM.Reg, volatile.LoadUint8(&o.MODEM.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetMODEM_TXRTSE() uint8 {
	return (volatile.LoadUint8(&o.MODEM.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetMODEM_TXRTSPOL(value uint8) {
	volatile.StoreUint8(&o.MODEM.Reg, volatile.LoadUint8(&o.MODEM.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetMODEM_TXRTSPOL() uint8 {
	return (volatile.LoadUint8(&o.MODEM.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetMODEM_RXRTSE(value uint8) {
	volatile.StoreUint8(&o.MODEM.Reg, volatile.LoadUint8(&o.MODEM.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetMODEM_RXRTSE() uint8 {
	return (volatile.LoadUint8(&o.MODEM.Reg) & 0x8) >> 3
}

// UART.IR: UART Infrared Register
func (o *UART_Type) SetIR_TNP(value uint8) {
	volatile.StoreUint8(&o.IR.Reg, volatile.LoadUint8(&o.IR.Reg)&^(0x3)|value)
}
func (o *UART_Type) GetIR_TNP() uint8 {
	return volatile.LoadUint8(&o.IR.Reg) & 0x3
}
func (o *UART_Type) SetIR_IREN(value uint8) {
	volatile.StoreUint8(&o.IR.Reg, volatile.LoadUint8(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetIR_IREN() uint8 {
	return (volatile.LoadUint8(&o.IR.Reg) & 0x4) >> 2
}

// UART.PFIFO: UART FIFO Parameters
func (o *UART_Type) SetPFIFO_RXFIFOSIZE(value uint8) {
	volatile.StoreUint8(&o.PFIFO.Reg, volatile.LoadUint8(&o.PFIFO.Reg)&^(0x7)|value)
}
func (o *UART_Type) GetPFIFO_RXFIFOSIZE() uint8 {
	return volatile.LoadUint8(&o.PFIFO.Reg) & 0x7
}
func (o *UART_Type) SetPFIFO_RXFE(value uint8) {
	volatile.StoreUint8(&o.PFIFO.Reg, volatile.LoadUint8(&o.PFIFO.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetPFIFO_RXFE() uint8 {
	return (volatile.LoadUint8(&o.PFIFO.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetPFIFO_TXFIFOSIZE(value uint8) {
	volatile.StoreUint8(&o.PFIFO.Reg, volatile.LoadUint8(&o.PFIFO.Reg)&^(0x70)|value<<4)
}
func (o *UART_Type) GetPFIFO_TXFIFOSIZE() uint8 {
	return (volatile.LoadUint8(&o.PFIFO.Reg) & 0x70) >> 4
}
func (o *UART_Type) SetPFIFO_TXFE(value uint8) {
	volatile.StoreUint8(&o.PFIFO.Reg, volatile.LoadUint8(&o.PFIFO.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetPFIFO_TXFE() uint8 {
	return (volatile.LoadUint8(&o.PFIFO.Reg) & 0x80) >> 7
}

// UART.CFIFO: UART FIFO Control Register
func (o *UART_Type) SetCFIFO_RXUFE(value uint8) {
	volatile.StoreUint8(&o.CFIFO.Reg, volatile.LoadUint8(&o.CFIFO.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetCFIFO_RXUFE() uint8 {
	return volatile.LoadUint8(&o.CFIFO.Reg) & 0x1
}
func (o *UART_Type) SetCFIFO_TXOFE(value uint8) {
	volatile.StoreUint8(&o.CFIFO.Reg, volatile.LoadUint8(&o.CFIFO.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetCFIFO_TXOFE() uint8 {
	return (volatile.LoadUint8(&o.CFIFO.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetCFIFO_RXOFE(value uint8) {
	volatile.StoreUint8(&o.CFIFO.Reg, volatile.LoadUint8(&o.CFIFO.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetCFIFO_RXOFE() uint8 {
	return (volatile.LoadUint8(&o.CFIFO.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetCFIFO_RXFLUSH(value uint8) {
	volatile.StoreUint8(&o.CFIFO.Reg, volatile.LoadUint8(&o.CFIFO.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetCFIFO_RXFLUSH() uint8 {
	return (volatile.LoadUint8(&o.CFIFO.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetCFIFO_TXFLUSH(value uint8) {
	volatile.StoreUint8(&o.CFIFO.Reg, volatile.LoadUint8(&o.CFIFO.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetCFIFO_TXFLUSH() uint8 {
	return (volatile.LoadUint8(&o.CFIFO.Reg) & 0x80) >> 7
}

// UART.SFIFO: UART FIFO Status Register
func (o *UART_Type) SetSFIFO_RXUF(value uint8) {
	volatile.StoreUint8(&o.SFIFO.Reg, volatile.LoadUint8(&o.SFIFO.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetSFIFO_RXUF() uint8 {
	return volatile.LoadUint8(&o.SFIFO.Reg) & 0x1
}
func (o *UART_Type) SetSFIFO_TXOF(value uint8) {
	volatile.StoreUint8(&o.SFIFO.Reg, volatile.LoadUint8(&o.SFIFO.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetSFIFO_TXOF() uint8 {
	return (volatile.LoadUint8(&o.SFIFO.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetSFIFO_RXOF(value uint8) {
	volatile.StoreUint8(&o.SFIFO.Reg, volatile.LoadUint8(&o.SFIFO.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetSFIFO_RXOF() uint8 {
	return (volatile.LoadUint8(&o.SFIFO.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetSFIFO_RXEMPT(value uint8) {
	volatile.StoreUint8(&o.SFIFO.Reg, volatile.LoadUint8(&o.SFIFO.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetSFIFO_RXEMPT() uint8 {
	return (volatile.LoadUint8(&o.SFIFO.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetSFIFO_TXEMPT(value uint8) {
	volatile.StoreUint8(&o.SFIFO.Reg, volatile.LoadUint8(&o.SFIFO.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetSFIFO_TXEMPT() uint8 {
	return (volatile.LoadUint8(&o.SFIFO.Reg) & 0x80) >> 7
}

// UART.TWFIFO: UART FIFO Transmit Watermark
func (o *UART_Type) SetTWFIFO(value uint8) {
	volatile.StoreUint8(&o.TWFIFO.Reg, value)
}
func (o *UART_Type) GetTWFIFO() uint8 {
	return volatile.LoadUint8(&o.TWFIFO.Reg)
}

// UART.TCFIFO: UART FIFO Transmit Count
func (o *UART_Type) SetTCFIFO(value uint8) {
	volatile.StoreUint8(&o.TCFIFO.Reg, value)
}
func (o *UART_Type) GetTCFIFO() uint8 {
	return volatile.LoadUint8(&o.TCFIFO.Reg)
}

// UART.RWFIFO: UART FIFO Receive Watermark
func (o *UART_Type) SetRWFIFO(value uint8) {
	volatile.StoreUint8(&o.RWFIFO.Reg, value)
}
func (o *UART_Type) GetRWFIFO() uint8 {
	return volatile.LoadUint8(&o.RWFIFO.Reg)
}

// UART.RCFIFO: UART FIFO Receive Count
func (o *UART_Type) SetRCFIFO(value uint8) {
	volatile.StoreUint8(&o.RCFIFO.Reg, value)
}
func (o *UART_Type) GetRCFIFO() uint8 {
	return volatile.LoadUint8(&o.RCFIFO.Reg)
}

// UART.C7816: UART 7816 Control Register
func (o *UART_Type) SetC7816_ISO_7816E(value uint8) {
	volatile.StoreUint8(&o.C7816.Reg, volatile.LoadUint8(&o.C7816.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetC7816_ISO_7816E() uint8 {
	return volatile.LoadUint8(&o.C7816.Reg) & 0x1
}
func (o *UART_Type) SetC7816_TTYPE(value uint8) {
	volatile.StoreUint8(&o.C7816.Reg, volatile.LoadUint8(&o.C7816.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetC7816_TTYPE() uint8 {
	return (volatile.LoadUint8(&o.C7816.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetC7816_INIT(value uint8) {
	volatile.StoreUint8(&o.C7816.Reg, volatile.LoadUint8(&o.C7816.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetC7816_INIT() uint8 {
	return (volatile.LoadUint8(&o.C7816.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetC7816_ANACK(value uint8) {
	volatile.StoreUint8(&o.C7816.Reg, volatile.LoadUint8(&o.C7816.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetC7816_ANACK() uint8 {
	return (volatile.LoadUint8(&o.C7816.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetC7816_ONACK(value uint8) {
	volatile.StoreUint8(&o.C7816.Reg, volatile.LoadUint8(&o.C7816.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetC7816_ONACK() uint8 {
	return (volatile.LoadUint8(&o.C7816.Reg) & 0x10) >> 4
}

// UART.IE7816: UART 7816 Interrupt Enable Register
func (o *UART_Type) SetIE7816_RXTE(value uint8) {
	volatile.StoreUint8(&o.IE7816.Reg, volatile.LoadUint8(&o.IE7816.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIE7816_RXTE() uint8 {
	return volatile.LoadUint8(&o.IE7816.Reg) & 0x1
}
func (o *UART_Type) SetIE7816_TXTE(value uint8) {
	volatile.StoreUint8(&o.IE7816.Reg, volatile.LoadUint8(&o.IE7816.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIE7816_TXTE() uint8 {
	return (volatile.LoadUint8(&o.IE7816.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIE7816_GTVE(value uint8) {
	volatile.StoreUint8(&o.IE7816.Reg, volatile.LoadUint8(&o.IE7816.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetIE7816_GTVE() uint8 {
	return (volatile.LoadUint8(&o.IE7816.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetIE7816_ADTE(value uint8) {
	volatile.StoreUint8(&o.IE7816.Reg, volatile.LoadUint8(&o.IE7816.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIE7816_ADTE() uint8 {
	return (volatile.LoadUint8(&o.IE7816.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIE7816_INITDE(value uint8) {
	volatile.StoreUint8(&o.IE7816.Reg, volatile.LoadUint8(&o.IE7816.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIE7816_INITDE() uint8 {
	return (volatile.LoadUint8(&o.IE7816.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIE7816_BWTE(value uint8) {
	volatile.StoreUint8(&o.IE7816.Reg, volatile.LoadUint8(&o.IE7816.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIE7816_BWTE() uint8 {
	return (volatile.LoadUint8(&o.IE7816.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIE7816_CWTE(value uint8) {
	volatile.StoreUint8(&o.IE7816.Reg, volatile.LoadUint8(&o.IE7816.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIE7816_CWTE() uint8 {
	return (volatile.LoadUint8(&o.IE7816.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIE7816_WTE(value uint8) {
	volatile.StoreUint8(&o.IE7816.Reg, volatile.LoadUint8(&o.IE7816.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIE7816_WTE() uint8 {
	return (volatile.LoadUint8(&o.IE7816.Reg) & 0x80) >> 7
}

// UART.IS7816: UART 7816 Interrupt Status Register
func (o *UART_Type) SetIS7816_RXT(value uint8) {
	volatile.StoreUint8(&o.IS7816.Reg, volatile.LoadUint8(&o.IS7816.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIS7816_RXT() uint8 {
	return volatile.LoadUint8(&o.IS7816.Reg) & 0x1
}
func (o *UART_Type) SetIS7816_TXT(value uint8) {
	volatile.StoreUint8(&o.IS7816.Reg, volatile.LoadUint8(&o.IS7816.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIS7816_TXT() uint8 {
	return (volatile.LoadUint8(&o.IS7816.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIS7816_GTV(value uint8) {
	volatile.StoreUint8(&o.IS7816.Reg, volatile.LoadUint8(&o.IS7816.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetIS7816_GTV() uint8 {
	return (volatile.LoadUint8(&o.IS7816.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetIS7816_ADT(value uint8) {
	volatile.StoreUint8(&o.IS7816.Reg, volatile.LoadUint8(&o.IS7816.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIS7816_ADT() uint8 {
	return (volatile.LoadUint8(&o.IS7816.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIS7816_INITD(value uint8) {
	volatile.StoreUint8(&o.IS7816.Reg, volatile.LoadUint8(&o.IS7816.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIS7816_INITD() uint8 {
	return (volatile.LoadUint8(&o.IS7816.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIS7816_BWT(value uint8) {
	volatile.StoreUint8(&o.IS7816.Reg, volatile.LoadUint8(&o.IS7816.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIS7816_BWT() uint8 {
	return (volatile.LoadUint8(&o.IS7816.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIS7816_CWT(value uint8) {
	volatile.StoreUint8(&o.IS7816.Reg, volatile.LoadUint8(&o.IS7816.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIS7816_CWT() uint8 {
	return (volatile.LoadUint8(&o.IS7816.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIS7816_WT(value uint8) {
	volatile.StoreUint8(&o.IS7816.Reg, volatile.LoadUint8(&o.IS7816.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIS7816_WT() uint8 {
	return (volatile.LoadUint8(&o.IS7816.Reg) & 0x80) >> 7
}

// UART.WP7816: UART 7816 Wait Parameter Register
func (o *UART_Type) SetWP7816(value uint8) {
	volatile.StoreUint8(&o.WP7816.Reg, value)
}
func (o *UART_Type) GetWP7816() uint8 {
	return volatile.LoadUint8(&o.WP7816.Reg)
}

// UART.WN7816: UART 7816 Wait N Register
func (o *UART_Type) SetWN7816(value uint8) {
	volatile.StoreUint8(&o.WN7816.Reg, value)
}
func (o *UART_Type) GetWN7816() uint8 {
	return volatile.LoadUint8(&o.WN7816.Reg)
}

// UART.WF7816: UART 7816 Wait FD Register
func (o *UART_Type) SetWF7816(value uint8) {
	volatile.StoreUint8(&o.WF7816.Reg, value)
}
func (o *UART_Type) GetWF7816() uint8 {
	return volatile.LoadUint8(&o.WF7816.Reg)
}

// UART.ET7816: UART 7816 Error Threshold Register
func (o *UART_Type) SetET7816_RXTHRESHOLD(value uint8) {
	volatile.StoreUint8(&o.ET7816.Reg, volatile.LoadUint8(&o.ET7816.Reg)&^(0xf)|value)
}
func (o *UART_Type) GetET7816_RXTHRESHOLD() uint8 {
	return volatile.LoadUint8(&o.ET7816.Reg) & 0xf
}
func (o *UART_Type) SetET7816_TXTHRESHOLD(value uint8) {
	volatile.StoreUint8(&o.ET7816.Reg, volatile.LoadUint8(&o.ET7816.Reg)&^(0xf0)|value<<4)
}
func (o *UART_Type) GetET7816_TXTHRESHOLD() uint8 {
	return (volatile.LoadUint8(&o.ET7816.Reg) & 0xf0) >> 4
}

// UART.TL7816: UART 7816 Transmit Length Register
func (o *UART_Type) SetTL7816(value uint8) {
	volatile.StoreUint8(&o.TL7816.Reg, value)
}
func (o *UART_Type) GetTL7816() uint8 {
	return volatile.LoadUint8(&o.TL7816.Reg)
}

// UART.AP7816A_T0: UART 7816 ATR Duration Timer Register A
func (o *UART_Type) SetAP7816A_T0(value uint8) {
	volatile.StoreUint8(&o.AP7816A_T0.Reg, value)
}
func (o *UART_Type) GetAP7816A_T0() uint8 {
	return volatile.LoadUint8(&o.AP7816A_T0.Reg)
}

// UART.AP7816B_T0: UART 7816 ATR Duration Timer Register B
func (o *UART_Type) SetAP7816B_T0(value uint8) {
	volatile.StoreUint8(&o.AP7816B_T0.Reg, value)
}
func (o *UART_Type) GetAP7816B_T0() uint8 {
	return volatile.LoadUint8(&o.AP7816B_T0.Reg)
}

// UART.WP7816A_T0: UART 7816 Wait Parameter Register A
func (o *UART_Type) SetWP7816A_T0(value uint8) {
	volatile.StoreUint8(&o.WP7816A_T0.Reg, value)
}
func (o *UART_Type) GetWP7816A_T0() uint8 {
	return volatile.LoadUint8(&o.WP7816A_T0.Reg)
}

// UART.WP7816B_T0: UART 7816 Wait Parameter Register B
func (o *UART_Type) SetWP7816B_T0(value uint8) {
	volatile.StoreUint8(&o.WP7816B_T0.Reg, value)
}
func (o *UART_Type) GetWP7816B_T0() uint8 {
	return volatile.LoadUint8(&o.WP7816B_T0.Reg)
}

// UART.WGP7816_T1: UART 7816 Wait and Guard Parameter Register
func (o *UART_Type) SetWGP7816_T1_BGI(value uint8) {
	volatile.StoreUint8(&o.WGP7816_T1.Reg, volatile.LoadUint8(&o.WGP7816_T1.Reg)&^(0xf)|value)
}
func (o *UART_Type) GetWGP7816_T1_BGI() uint8 {
	return volatile.LoadUint8(&o.WGP7816_T1.Reg) & 0xf
}
func (o *UART_Type) SetWGP7816_T1_CWI1(value uint8) {
	volatile.StoreUint8(&o.WGP7816_T1.Reg, volatile.LoadUint8(&o.WGP7816_T1.Reg)&^(0xf0)|value<<4)
}
func (o *UART_Type) GetWGP7816_T1_CWI1() uint8 {
	return (volatile.LoadUint8(&o.WGP7816_T1.Reg) & 0xf0) >> 4
}

// UART.WP7816C_T1: UART 7816 Wait Parameter Register C
func (o *UART_Type) SetWP7816C_T1_CWI2(value uint8) {
	volatile.StoreUint8(&o.WP7816C_T1.Reg, volatile.LoadUint8(&o.WP7816C_T1.Reg)&^(0x1f)|value)
}
func (o *UART_Type) GetWP7816C_T1_CWI2() uint8 {
	return volatile.LoadUint8(&o.WP7816C_T1.Reg) & 0x1f
}

// Universal Serial Bus, OTG Capable Controller
type USB0_Type struct {
	PERID                  volatile.Register8 // 0x0
	_                      [3]byte
	IDCOMP                 volatile.Register8 // 0x4
	_                      [3]byte
	REV                    volatile.Register8 // 0x8
	_                      [3]byte
	ADDINFO                volatile.Register8 // 0xC
	_                      [3]byte
	OTGISTAT               volatile.Register8 // 0x10
	_                      [3]byte
	OTGICR                 volatile.Register8 // 0x14
	_                      [3]byte
	OTGSTAT                volatile.Register8 // 0x18
	_                      [3]byte
	OTGCTL                 volatile.Register8 // 0x1C
	_                      [99]byte
	ISTAT                  volatile.Register8 // 0x80
	_                      [3]byte
	INTEN                  volatile.Register8 // 0x84
	_                      [3]byte
	ERRSTAT                volatile.Register8 // 0x88
	_                      [3]byte
	ERREN                  volatile.Register8 // 0x8C
	_                      [3]byte
	STAT                   volatile.Register8 // 0x90
	_                      [3]byte
	CTL                    volatile.Register8 // 0x94
	_                      [3]byte
	ADDR                   volatile.Register8 // 0x98
	_                      [3]byte
	BDTPAGE1               volatile.Register8 // 0x9C
	_                      [3]byte
	FRMNUML                volatile.Register8 // 0xA0
	_                      [3]byte
	FRMNUMH                volatile.Register8 // 0xA4
	_                      [3]byte
	TOKEN                  volatile.Register8 // 0xA8
	_                      [3]byte
	SOFTHLD                volatile.Register8 // 0xAC
	_                      [3]byte
	BDTPAGE2               volatile.Register8 // 0xB0
	_                      [3]byte
	BDTPAGE3               volatile.Register8 // 0xB4
	_                      [11]byte
	ENDPT0                 volatile.Register8 // 0xC0
	_                      [3]byte
	ENDPT1                 volatile.Register8 // 0xC4
	_                      [3]byte
	ENDPT2                 volatile.Register8 // 0xC8
	_                      [3]byte
	ENDPT3                 volatile.Register8 // 0xCC
	_                      [3]byte
	ENDPT4                 volatile.Register8 // 0xD0
	_                      [3]byte
	ENDPT5                 volatile.Register8 // 0xD4
	_                      [3]byte
	ENDPT6                 volatile.Register8 // 0xD8
	_                      [3]byte
	ENDPT7                 volatile.Register8 // 0xDC
	_                      [3]byte
	ENDPT8                 volatile.Register8 // 0xE0
	_                      [3]byte
	ENDPT9                 volatile.Register8 // 0xE4
	_                      [3]byte
	ENDPT10                volatile.Register8 // 0xE8
	_                      [3]byte
	ENDPT11                volatile.Register8 // 0xEC
	_                      [3]byte
	ENDPT12                volatile.Register8 // 0xF0
	_                      [3]byte
	ENDPT13                volatile.Register8 // 0xF4
	_                      [3]byte
	ENDPT14                volatile.Register8 // 0xF8
	_                      [3]byte
	ENDPT15                volatile.Register8 // 0xFC
	_                      [3]byte
	USBCTRL                volatile.Register8 // 0x100
	_                      [3]byte
	OBSERVE                volatile.Register8 // 0x104
	_                      [3]byte
	CONTROL                volatile.Register8 // 0x108
	_                      [3]byte
	USBTRC0                volatile.Register8 // 0x10C
	_                      [7]byte
	USBFRMADJUST           volatile.Register8 // 0x114
	_                      [43]byte
	CLK_RECOVER_CTRL       volatile.Register8 // 0x140
	_                      [3]byte
	CLK_RECOVER_IRC_EN     volatile.Register8 // 0x144
	_                      [23]byte
	CLK_RECOVER_INT_STATUS volatile.Register8 // 0x15C
}

// USB0.PERID: Peripheral ID register
func (o *USB0_Type) SetPERID_ID(value uint8) {
	volatile.StoreUint8(&o.PERID.Reg, volatile.LoadUint8(&o.PERID.Reg)&^(0x3f)|value)
}
func (o *USB0_Type) GetPERID_ID() uint8 {
	return volatile.LoadUint8(&o.PERID.Reg) & 0x3f
}

// USB0.IDCOMP: Peripheral ID Complement register
func (o *USB0_Type) SetIDCOMP_NID(value uint8) {
	volatile.StoreUint8(&o.IDCOMP.Reg, volatile.LoadUint8(&o.IDCOMP.Reg)&^(0x3f)|value)
}
func (o *USB0_Type) GetIDCOMP_NID() uint8 {
	return volatile.LoadUint8(&o.IDCOMP.Reg) & 0x3f
}

// USB0.REV: Peripheral Revision register
func (o *USB0_Type) SetREV(value uint8) {
	volatile.StoreUint8(&o.REV.Reg, value)
}
func (o *USB0_Type) GetREV() uint8 {
	return volatile.LoadUint8(&o.REV.Reg)
}

// USB0.ADDINFO: Peripheral Additional Info register
func (o *USB0_Type) SetADDINFO_IEHOST(value uint8) {
	volatile.StoreUint8(&o.ADDINFO.Reg, volatile.LoadUint8(&o.ADDINFO.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetADDINFO_IEHOST() uint8 {
	return volatile.LoadUint8(&o.ADDINFO.Reg) & 0x1
}

// USB0.OTGISTAT: OTG Interrupt Status register
func (o *USB0_Type) SetOTGISTAT_AVBUSCHG(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetOTGISTAT_AVBUSCHG() uint8 {
	return volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x1
}
func (o *USB0_Type) SetOTGISTAT_B_SESS_CHG(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetOTGISTAT_B_SESS_CHG() uint8 {
	return (volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetOTGISTAT_SESSVLDCHG(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetOTGISTAT_SESSVLDCHG() uint8 {
	return (volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetOTGISTAT_LINE_STATE_CHG(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetOTGISTAT_LINE_STATE_CHG() uint8 {
	return (volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetOTGISTAT_ONEMSEC(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetOTGISTAT_ONEMSEC() uint8 {
	return (volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetOTGISTAT_IDCHG(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOTGISTAT_IDCHG() uint8 {
	return (volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x80) >> 7
}

// USB0.OTGICR: OTG Interrupt Control register
func (o *USB0_Type) SetOTGICR_AVBUSEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetOTGICR_AVBUSEN() uint8 {
	return volatile.LoadUint8(&o.OTGICR.Reg) & 0x1
}
func (o *USB0_Type) SetOTGICR_BSESSEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetOTGICR_BSESSEN() uint8 {
	return (volatile.LoadUint8(&o.OTGICR.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetOTGICR_SESSVLDEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetOTGICR_SESSVLDEN() uint8 {
	return (volatile.LoadUint8(&o.OTGICR.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetOTGICR_LINESTATEEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetOTGICR_LINESTATEEN() uint8 {
	return (volatile.LoadUint8(&o.OTGICR.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetOTGICR_ONEMSECEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetOTGICR_ONEMSECEN() uint8 {
	return (volatile.LoadUint8(&o.OTGICR.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetOTGICR_IDEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOTGICR_IDEN() uint8 {
	return (volatile.LoadUint8(&o.OTGICR.Reg) & 0x80) >> 7
}

// USB0.OTGSTAT: OTG Status register
func (o *USB0_Type) SetOTGSTAT_AVBUSVLD(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetOTGSTAT_AVBUSVLD() uint8 {
	return volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x1
}
func (o *USB0_Type) SetOTGSTAT_BSESSEND(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetOTGSTAT_BSESSEND() uint8 {
	return (volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetOTGSTAT_SESS_VLD(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetOTGSTAT_SESS_VLD() uint8 {
	return (volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetOTGSTAT_LINESTATESTABLE(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetOTGSTAT_LINESTATESTABLE() uint8 {
	return (volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetOTGSTAT_ONEMSECEN(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetOTGSTAT_ONEMSECEN() uint8 {
	return (volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetOTGSTAT_ID(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOTGSTAT_ID() uint8 {
	return (volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x80) >> 7
}

// USB0.OTGCTL: OTG Control register
func (o *USB0_Type) SetOTGCTL_OTGEN(value uint8) {
	volatile.StoreUint8(&o.OTGCTL.Reg, volatile.LoadUint8(&o.OTGCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetOTGCTL_OTGEN() uint8 {
	return (volatile.LoadUint8(&o.OTGCTL.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetOTGCTL_DMLOW(value uint8) {
	volatile.StoreUint8(&o.OTGCTL.Reg, volatile.LoadUint8(&o.OTGCTL.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetOTGCTL_DMLOW() uint8 {
	return (volatile.LoadUint8(&o.OTGCTL.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetOTGCTL_DPLOW(value uint8) {
	volatile.StoreUint8(&o.OTGCTL.Reg, volatile.LoadUint8(&o.OTGCTL.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetOTGCTL_DPLOW() uint8 {
	return (volatile.LoadUint8(&o.OTGCTL.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetOTGCTL_DPHIGH(value uint8) {
	volatile.StoreUint8(&o.OTGCTL.Reg, volatile.LoadUint8(&o.OTGCTL.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOTGCTL_DPHIGH() uint8 {
	return (volatile.LoadUint8(&o.OTGCTL.Reg) & 0x80) >> 7
}

// USB0.ISTAT: Interrupt Status register
func (o *USB0_Type) SetISTAT_USBRST(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetISTAT_USBRST() uint8 {
	return volatile.LoadUint8(&o.ISTAT.Reg) & 0x1
}
func (o *USB0_Type) SetISTAT_ERROR(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetISTAT_ERROR() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetISTAT_SOFTOK(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetISTAT_SOFTOK() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetISTAT_TOKDNE(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetISTAT_TOKDNE() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetISTAT_SLEEP(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetISTAT_SLEEP() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetISTAT_RESUME(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetISTAT_RESUME() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetISTAT_ATTACH(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetISTAT_ATTACH() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetISTAT_STALL(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetISTAT_STALL() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x80) >> 7
}

// USB0.INTEN: Interrupt Enable register
func (o *USB0_Type) SetINTEN_USBRSTEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetINTEN_USBRSTEN() uint8 {
	return volatile.LoadUint8(&o.INTEN.Reg) & 0x1
}
func (o *USB0_Type) SetINTEN_ERROREN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetINTEN_ERROREN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetINTEN_SOFTOKEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetINTEN_SOFTOKEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetINTEN_TOKDNEEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetINTEN_TOKDNEEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetINTEN_SLEEPEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetINTEN_SLEEPEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetINTEN_RESUMEEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetINTEN_RESUMEEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetINTEN_ATTACHEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetINTEN_ATTACHEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetINTEN_STALLEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetINTEN_STALLEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x80) >> 7
}

// USB0.ERRSTAT: Error Interrupt Status register
func (o *USB0_Type) SetERRSTAT_PIDERR(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetERRSTAT_PIDERR() uint8 {
	return volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x1
}
func (o *USB0_Type) SetERRSTAT_CRC5EOF(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetERRSTAT_CRC5EOF() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetERRSTAT_CRC16(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetERRSTAT_CRC16() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetERRSTAT_DFN8(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetERRSTAT_DFN8() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetERRSTAT_BTOERR(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetERRSTAT_BTOERR() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetERRSTAT_DMAERR(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetERRSTAT_DMAERR() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetERRSTAT_BTSERR(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetERRSTAT_BTSERR() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x80) >> 7
}

// USB0.ERREN: Error Interrupt Enable register
func (o *USB0_Type) SetERREN_PIDERREN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetERREN_PIDERREN() uint8 {
	return volatile.LoadUint8(&o.ERREN.Reg) & 0x1
}
func (o *USB0_Type) SetERREN_CRC5EOFEN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetERREN_CRC5EOFEN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetERREN_CRC16EN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetERREN_CRC16EN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetERREN_DFN8EN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetERREN_DFN8EN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetERREN_BTOERREN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetERREN_BTOERREN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetERREN_DMAERREN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetERREN_DMAERREN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetERREN_BTSERREN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetERREN_BTSERREN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x80) >> 7
}

// USB0.STAT: Status register
func (o *USB0_Type) SetSTAT_ODD(value uint8) {
	volatile.StoreUint8(&o.STAT.Reg, volatile.LoadUint8(&o.STAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetSTAT_ODD() uint8 {
	return (volatile.LoadUint8(&o.STAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetSTAT_TX(value uint8) {
	volatile.StoreUint8(&o.STAT.Reg, volatile.LoadUint8(&o.STAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetSTAT_TX() uint8 {
	return (volatile.LoadUint8(&o.STAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetSTAT_ENDP(value uint8) {
	volatile.StoreUint8(&o.STAT.Reg, volatile.LoadUint8(&o.STAT.Reg)&^(0xf0)|value<<4)
}
func (o *USB0_Type) GetSTAT_ENDP() uint8 {
	return (volatile.LoadUint8(&o.STAT.Reg) & 0xf0) >> 4
}

// USB0.CTL: Control register
func (o *USB0_Type) SetCTL_USBENSOFEN(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetCTL_USBENSOFEN() uint8 {
	return volatile.LoadUint8(&o.CTL.Reg) & 0x1
}
func (o *USB0_Type) SetCTL_ODDRST(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetCTL_ODDRST() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetCTL_RESUME(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetCTL_RESUME() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetCTL_HOSTMODEEN(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetCTL_HOSTMODEEN() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetCTL_RESET(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetCTL_RESET() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetCTL_TXSUSPENDTOKENBUSY(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetCTL_TXSUSPENDTOKENBUSY() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetCTL_SE0(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetCTL_SE0() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetCTL_JSTATE(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetCTL_JSTATE() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x80) >> 7
}

// USB0.ADDR: Address register
func (o *USB0_Type) SetADDR(value uint8) {
	volatile.StoreUint8(&o.ADDR.Reg, volatile.LoadUint8(&o.ADDR.Reg)&^(0x7f)|value)
}
func (o *USB0_Type) GetADDR() uint8 {
	return volatile.LoadUint8(&o.ADDR.Reg) & 0x7f
}
func (o *USB0_Type) SetADDR_LSEN(value uint8) {
	volatile.StoreUint8(&o.ADDR.Reg, volatile.LoadUint8(&o.ADDR.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetADDR_LSEN() uint8 {
	return (volatile.LoadUint8(&o.ADDR.Reg) & 0x80) >> 7
}

// USB0.BDTPAGE1: BDT Page register 1
func (o *USB0_Type) SetBDTPAGE1_BDTBA(value uint8) {
	volatile.StoreUint8(&o.BDTPAGE1.Reg, volatile.LoadUint8(&o.BDTPAGE1.Reg)&^(0xfe)|value<<1)
}
func (o *USB0_Type) GetBDTPAGE1_BDTBA() uint8 {
	return (volatile.LoadUint8(&o.BDTPAGE1.Reg) & 0xfe) >> 1
}

// USB0.FRMNUML: Frame Number register Low
func (o *USB0_Type) SetFRMNUML(value uint8) {
	volatile.StoreUint8(&o.FRMNUML.Reg, value)
}
func (o *USB0_Type) GetFRMNUML() uint8 {
	return volatile.LoadUint8(&o.FRMNUML.Reg)
}

// USB0.FRMNUMH: Frame Number register High
func (o *USB0_Type) SetFRMNUMH_FRM(value uint8) {
	volatile.StoreUint8(&o.FRMNUMH.Reg, volatile.LoadUint8(&o.FRMNUMH.Reg)&^(0x7)|value)
}
func (o *USB0_Type) GetFRMNUMH_FRM() uint8 {
	return volatile.LoadUint8(&o.FRMNUMH.Reg) & 0x7
}

// USB0.TOKEN: Token register
func (o *USB0_Type) SetTOKEN_TOKENENDPT(value uint8) {
	volatile.StoreUint8(&o.TOKEN.Reg, volatile.LoadUint8(&o.TOKEN.Reg)&^(0xf)|value)
}
func (o *USB0_Type) GetTOKEN_TOKENENDPT() uint8 {
	return volatile.LoadUint8(&o.TOKEN.Reg) & 0xf
}
func (o *USB0_Type) SetTOKEN_TOKENPID(value uint8) {
	volatile.StoreUint8(&o.TOKEN.Reg, volatile.LoadUint8(&o.TOKEN.Reg)&^(0xf0)|value<<4)
}
func (o *USB0_Type) GetTOKEN_TOKENPID() uint8 {
	return (volatile.LoadUint8(&o.TOKEN.Reg) & 0xf0) >> 4
}

// USB0.SOFTHLD: SOF Threshold register
func (o *USB0_Type) SetSOFTHLD(value uint8) {
	volatile.StoreUint8(&o.SOFTHLD.Reg, value)
}
func (o *USB0_Type) GetSOFTHLD() uint8 {
	return volatile.LoadUint8(&o.SOFTHLD.Reg)
}

// USB0.BDTPAGE2: BDT Page Register 2
func (o *USB0_Type) SetBDTPAGE2(value uint8) {
	volatile.StoreUint8(&o.BDTPAGE2.Reg, value)
}
func (o *USB0_Type) GetBDTPAGE2() uint8 {
	return volatile.LoadUint8(&o.BDTPAGE2.Reg)
}

// USB0.BDTPAGE3: BDT Page Register 3
func (o *USB0_Type) SetBDTPAGE3(value uint8) {
	volatile.StoreUint8(&o.BDTPAGE3.Reg, value)
}
func (o *USB0_Type) GetBDTPAGE3() uint8 {
	return volatile.LoadUint8(&o.BDTPAGE3.Reg)
}

// USB0.ENDPT0: Endpoint Control register
func (o *USB0_Type) SetENDPT0_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT0_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT0.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT0_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT0_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT0_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT0_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT0_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT0_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT0_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT0_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT0_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT0_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT0_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT0_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x80) >> 7
}

// USB0.ENDPT1: Endpoint Control register
func (o *USB0_Type) SetENDPT1_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT1_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT1.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT1_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT1_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT1_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT1_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT1_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT1_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT1_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT1_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT1_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT1_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT1_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT1_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x80) >> 7
}

// USB0.ENDPT2: Endpoint Control register
func (o *USB0_Type) SetENDPT2_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT2_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT2.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT2_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT2_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT2_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT2_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT2_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT2_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT2_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT2_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT2_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT2_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT2_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT2_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x80) >> 7
}

// USB0.ENDPT3: Endpoint Control register
func (o *USB0_Type) SetENDPT3_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT3_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT3.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT3_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT3_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT3_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT3_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT3_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT3_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT3_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT3_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT3_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT3_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT3_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT3_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x80) >> 7
}

// USB0.ENDPT4: Endpoint Control register
func (o *USB0_Type) SetENDPT4_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT4_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT4.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT4_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT4_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT4_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT4_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT4_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT4_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT4_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT4_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT4_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT4_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT4_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT4_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x80) >> 7
}

// USB0.ENDPT5: Endpoint Control register
func (o *USB0_Type) SetENDPT5_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT5_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT5.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT5_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT5_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT5_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT5_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT5_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT5_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT5_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT5_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT5_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT5_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT5_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT5_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x80) >> 7
}

// USB0.ENDPT6: Endpoint Control register
func (o *USB0_Type) SetENDPT6_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT6_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT6.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT6_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT6_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT6_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT6_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT6_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT6_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT6_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT6_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT6_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT6_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT6_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT6_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x80) >> 7
}

// USB0.ENDPT7: Endpoint Control register
func (o *USB0_Type) SetENDPT7_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT7_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT7.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT7_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT7_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT7_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT7_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT7_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT7_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT7_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT7_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT7_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT7_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT7_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT7_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x80) >> 7
}

// USB0.ENDPT8: Endpoint Control register
func (o *USB0_Type) SetENDPT8_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT8_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT8.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT8_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT8_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT8_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT8_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT8_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT8_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT8_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT8_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT8_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT8_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT8_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT8_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x80) >> 7
}

// USB0.ENDPT9: Endpoint Control register
func (o *USB0_Type) SetENDPT9_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT9_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT9.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT9_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT9_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT9_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT9_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT9_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT9_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT9_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT9_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT9_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT9_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT9_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT9_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x80) >> 7
}

// USB0.ENDPT10: Endpoint Control register
func (o *USB0_Type) SetENDPT10_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT10_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT10.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT10_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT10_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT10_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT10_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT10_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT10_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT10_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT10_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT10_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT10_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT10_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT10_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x80) >> 7
}

// USB0.ENDPT11: Endpoint Control register
func (o *USB0_Type) SetENDPT11_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT11_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT11.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT11_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT11_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT11_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT11_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT11_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT11_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT11_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT11_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT11_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT11_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT11_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT11_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x80) >> 7
}

// USB0.ENDPT12: Endpoint Control register
func (o *USB0_Type) SetENDPT12_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT12_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT12.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT12_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT12_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT12_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT12_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT12_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT12_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT12_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT12_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT12_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT12_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT12_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT12_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x80) >> 7
}

// USB0.ENDPT13: Endpoint Control register
func (o *USB0_Type) SetENDPT13_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT13_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT13.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT13_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT13_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT13_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT13_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT13_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT13_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT13_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT13_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT13_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT13_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT13_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT13_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x80) >> 7
}

// USB0.ENDPT14: Endpoint Control register
func (o *USB0_Type) SetENDPT14_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT14_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT14.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT14_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT14_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT14_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT14_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT14_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT14_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT14_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT14_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT14_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT14_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT14_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT14_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x80) >> 7
}

// USB0.ENDPT15: Endpoint Control register
func (o *USB0_Type) SetENDPT15_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT15_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT15.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT15_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT15_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT15_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT15_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT15_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT15_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT15_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT15_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT15_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT15_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT15_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT15_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x80) >> 7
}

// USB0.USBCTRL: USB Control register
func (o *USB0_Type) SetUSBCTRL_PDE(value uint8) {
	volatile.StoreUint8(&o.USBCTRL.Reg, volatile.LoadUint8(&o.USBCTRL.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetUSBCTRL_PDE() uint8 {
	return (volatile.LoadUint8(&o.USBCTRL.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetUSBCTRL_SUSP(value uint8) {
	volatile.StoreUint8(&o.USBCTRL.Reg, volatile.LoadUint8(&o.USBCTRL.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetUSBCTRL_SUSP() uint8 {
	return (volatile.LoadUint8(&o.USBCTRL.Reg) & 0x80) >> 7
}

// USB0.OBSERVE: USB OTG Observe register
func (o *USB0_Type) SetOBSERVE_DMPD(value uint8) {
	volatile.StoreUint8(&o.OBSERVE.Reg, volatile.LoadUint8(&o.OBSERVE.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetOBSERVE_DMPD() uint8 {
	return (volatile.LoadUint8(&o.OBSERVE.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetOBSERVE_DPPD(value uint8) {
	volatile.StoreUint8(&o.OBSERVE.Reg, volatile.LoadUint8(&o.OBSERVE.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetOBSERVE_DPPD() uint8 {
	return (volatile.LoadUint8(&o.OBSERVE.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetOBSERVE_DPPU(value uint8) {
	volatile.StoreUint8(&o.OBSERVE.Reg, volatile.LoadUint8(&o.OBSERVE.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOBSERVE_DPPU() uint8 {
	return (volatile.LoadUint8(&o.OBSERVE.Reg) & 0x80) >> 7
}

// USB0.CONTROL: USB OTG Control register
func (o *USB0_Type) SetCONTROL_DPPULLUPNONOTG(value uint8) {
	volatile.StoreUint8(&o.CONTROL.Reg, volatile.LoadUint8(&o.CONTROL.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetCONTROL_DPPULLUPNONOTG() uint8 {
	return (volatile.LoadUint8(&o.CONTROL.Reg) & 0x10) >> 4
}

// USB0.USBTRC0: USB Transceiver Control register 0
func (o *USB0_Type) SetUSBTRC0_USB_RESUME_INT(value uint8) {
	volatile.StoreUint8(&o.USBTRC0.Reg, volatile.LoadUint8(&o.USBTRC0.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetUSBTRC0_USB_RESUME_INT() uint8 {
	return volatile.LoadUint8(&o.USBTRC0.Reg) & 0x1
}
func (o *USB0_Type) SetUSBTRC0_SYNC_DET(value uint8) {
	volatile.StoreUint8(&o.USBTRC0.Reg, volatile.LoadUint8(&o.USBTRC0.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetUSBTRC0_SYNC_DET() uint8 {
	return (volatile.LoadUint8(&o.USBTRC0.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetUSBTRC0_USB_CLK_RECOVERY_INT(value uint8) {
	volatile.StoreUint8(&o.USBTRC0.Reg, volatile.LoadUint8(&o.USBTRC0.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetUSBTRC0_USB_CLK_RECOVERY_INT() uint8 {
	return (volatile.LoadUint8(&o.USBTRC0.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetUSBTRC0_USBRESMEN(value uint8) {
	volatile.StoreUint8(&o.USBTRC0.Reg, volatile.LoadUint8(&o.USBTRC0.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetUSBTRC0_USBRESMEN() uint8 {
	return (volatile.LoadUint8(&o.USBTRC0.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetUSBTRC0_USBRESET(value uint8) {
	volatile.StoreUint8(&o.USBTRC0.Reg, volatile.LoadUint8(&o.USBTRC0.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetUSBTRC0_USBRESET() uint8 {
	return (volatile.LoadUint8(&o.USBTRC0.Reg) & 0x80) >> 7
}

// USB0.USBFRMADJUST: Frame Adjust Register
func (o *USB0_Type) SetUSBFRMADJUST(value uint8) {
	volatile.StoreUint8(&o.USBFRMADJUST.Reg, value)
}
func (o *USB0_Type) GetUSBFRMADJUST() uint8 {
	return volatile.LoadUint8(&o.USBFRMADJUST.Reg)
}

// USB0.CLK_RECOVER_CTRL: USB Clock recovery control
func (o *USB0_Type) SetCLK_RECOVER_CTRL_RESTART_IFRTRIM_EN(value uint8) {
	volatile.StoreUint8(&o.CLK_RECOVER_CTRL.Reg, volatile.LoadUint8(&o.CLK_RECOVER_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetCLK_RECOVER_CTRL_RESTART_IFRTRIM_EN() uint8 {
	return (volatile.LoadUint8(&o.CLK_RECOVER_CTRL.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetCLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN(value uint8) {
	volatile.StoreUint8(&o.CLK_RECOVER_CTRL.Reg, volatile.LoadUint8(&o.CLK_RECOVER_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetCLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN() uint8 {
	return (volatile.LoadUint8(&o.CLK_RECOVER_CTRL.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetCLK_RECOVER_CTRL_CLOCK_RECOVER_EN(value uint8) {
	volatile.StoreUint8(&o.CLK_RECOVER_CTRL.Reg, volatile.LoadUint8(&o.CLK_RECOVER_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetCLK_RECOVER_CTRL_CLOCK_RECOVER_EN() uint8 {
	return (volatile.LoadUint8(&o.CLK_RECOVER_CTRL.Reg) & 0x80) >> 7
}

// USB0.CLK_RECOVER_IRC_EN: IRC48M oscillator enable register
func (o *USB0_Type) SetCLK_RECOVER_IRC_EN_REG_EN(value uint8) {
	volatile.StoreUint8(&o.CLK_RECOVER_IRC_EN.Reg, volatile.LoadUint8(&o.CLK_RECOVER_IRC_EN.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetCLK_RECOVER_IRC_EN_REG_EN() uint8 {
	return volatile.LoadUint8(&o.CLK_RECOVER_IRC_EN.Reg) & 0x1
}
func (o *USB0_Type) SetCLK_RECOVER_IRC_EN_IRC_EN(value uint8) {
	volatile.StoreUint8(&o.CLK_RECOVER_IRC_EN.Reg, volatile.LoadUint8(&o.CLK_RECOVER_IRC_EN.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetCLK_RECOVER_IRC_EN_IRC_EN() uint8 {
	return (volatile.LoadUint8(&o.CLK_RECOVER_IRC_EN.Reg) & 0x2) >> 1
}

// USB0.CLK_RECOVER_INT_STATUS: Clock recovery separated interrupt status
func (o *USB0_Type) SetCLK_RECOVER_INT_STATUS_OVF_ERROR(value uint8) {
	volatile.StoreUint8(&o.CLK_RECOVER_INT_STATUS.Reg, volatile.LoadUint8(&o.CLK_RECOVER_INT_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetCLK_RECOVER_INT_STATUS_OVF_ERROR() uint8 {
	return (volatile.LoadUint8(&o.CLK_RECOVER_INT_STATUS.Reg) & 0x10) >> 4
}

// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
type CMP_Type struct {
	CR0   volatile.Register8 // 0x0
	CR1   volatile.Register8 // 0x1
	FPR   volatile.Register8 // 0x2
	SCR   volatile.Register8 // 0x3
	DACCR volatile.Register8 // 0x4
	MUXCR volatile.Register8 // 0x5
}

// CMP.CR0: CMP Control Register 0
func (o *CMP_Type) SetCR0_HYSTCTR(value uint8) {
	volatile.StoreUint8(&o.CR0.Reg, volatile.LoadUint8(&o.CR0.Reg)&^(0x3)|value)
}
func (o *CMP_Type) GetCR0_HYSTCTR() uint8 {
	return volatile.LoadUint8(&o.CR0.Reg) & 0x3
}
func (o *CMP_Type) SetCR0_FILTER_CNT(value uint8) {
	volatile.StoreUint8(&o.CR0.Reg, volatile.LoadUint8(&o.CR0.Reg)&^(0x70)|value<<4)
}
func (o *CMP_Type) GetCR0_FILTER_CNT() uint8 {
	return (volatile.LoadUint8(&o.CR0.Reg) & 0x70) >> 4
}

// CMP.CR1: CMP Control Register 1
func (o *CMP_Type) SetCR1_EN(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x1)|value)
}
func (o *CMP_Type) GetCR1_EN() uint8 {
	return volatile.LoadUint8(&o.CR1.Reg) & 0x1
}
func (o *CMP_Type) SetCR1_OPE(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *CMP_Type) GetCR1_OPE() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x2) >> 1
}
func (o *CMP_Type) SetCR1_COS(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *CMP_Type) GetCR1_COS() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x4) >> 2
}
func (o *CMP_Type) SetCR1_INV(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *CMP_Type) GetCR1_INV() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x8) >> 3
}
func (o *CMP_Type) SetCR1_PMODE(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *CMP_Type) GetCR1_PMODE() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x10) >> 4
}
func (o *CMP_Type) SetCR1_TRIGM(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *CMP_Type) GetCR1_TRIGM() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x20) >> 5
}
func (o *CMP_Type) SetCR1_WE(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *CMP_Type) GetCR1_WE() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x40) >> 6
}
func (o *CMP_Type) SetCR1_SE(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *CMP_Type) GetCR1_SE() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x80) >> 7
}

// CMP.FPR: CMP Filter Period Register
func (o *CMP_Type) SetFPR(value uint8) {
	volatile.StoreUint8(&o.FPR.Reg, value)
}
func (o *CMP_Type) GetFPR() uint8 {
	return volatile.LoadUint8(&o.FPR.Reg)
}

// CMP.SCR: CMP Status and Control Register
func (o *CMP_Type) SetSCR_COUT(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x1)|value)
}
func (o *CMP_Type) GetSCR_COUT() uint8 {
	return volatile.LoadUint8(&o.SCR.Reg) & 0x1
}
func (o *CMP_Type) SetSCR_CFF(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *CMP_Type) GetSCR_CFF() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x2) >> 1
}
func (o *CMP_Type) SetSCR_CFR(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *CMP_Type) GetSCR_CFR() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x4) >> 2
}
func (o *CMP_Type) SetSCR_IEF(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *CMP_Type) GetSCR_IEF() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x8) >> 3
}
func (o *CMP_Type) SetSCR_IER(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *CMP_Type) GetSCR_IER() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x10) >> 4
}
func (o *CMP_Type) SetSCR_DMAEN(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x40)|value<<6)
}
func (o *CMP_Type) GetSCR_DMAEN() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x40) >> 6
}

// CMP.DACCR: DAC Control Register
func (o *CMP_Type) SetDACCR_VOSEL(value uint8) {
	volatile.StoreUint8(&o.DACCR.Reg, volatile.LoadUint8(&o.DACCR.Reg)&^(0x3f)|value)
}
func (o *CMP_Type) GetDACCR_VOSEL() uint8 {
	return volatile.LoadUint8(&o.DACCR.Reg) & 0x3f
}
func (o *CMP_Type) SetDACCR_VRSEL(value uint8) {
	volatile.StoreUint8(&o.DACCR.Reg, volatile.LoadUint8(&o.DACCR.Reg)&^(0x40)|value<<6)
}
func (o *CMP_Type) GetDACCR_VRSEL() uint8 {
	return (volatile.LoadUint8(&o.DACCR.Reg) & 0x40) >> 6
}
func (o *CMP_Type) SetDACCR_DACEN(value uint8) {
	volatile.StoreUint8(&o.DACCR.Reg, volatile.LoadUint8(&o.DACCR.Reg)&^(0x80)|value<<7)
}
func (o *CMP_Type) GetDACCR_DACEN() uint8 {
	return (volatile.LoadUint8(&o.DACCR.Reg) & 0x80) >> 7
}

// CMP.MUXCR: MUX Control Register
func (o *CMP_Type) SetMUXCR_MSEL(value uint8) {
	volatile.StoreUint8(&o.MUXCR.Reg, volatile.LoadUint8(&o.MUXCR.Reg)&^(0x7)|value)
}
func (o *CMP_Type) GetMUXCR_MSEL() uint8 {
	return volatile.LoadUint8(&o.MUXCR.Reg) & 0x7
}
func (o *CMP_Type) SetMUXCR_PSEL(value uint8) {
	volatile.StoreUint8(&o.MUXCR.Reg, volatile.LoadUint8(&o.MUXCR.Reg)&^(0x38)|value<<3)
}
func (o *CMP_Type) GetMUXCR_PSEL() uint8 {
	return (volatile.LoadUint8(&o.MUXCR.Reg) & 0x38) >> 3
}

// Voltage Reference
type VREF_Type struct {
	TRM volatile.Register8 // 0x0
	SC  volatile.Register8 // 0x1
}

// VREF.TRM: VREF Trim Register
func (o *VREF_Type) SetTRM_TRIM(value uint8) {
	volatile.StoreUint8(&o.TRM.Reg, volatile.LoadUint8(&o.TRM.Reg)&^(0x3f)|value)
}
func (o *VREF_Type) GetTRM_TRIM() uint8 {
	return volatile.LoadUint8(&o.TRM.Reg) & 0x3f
}
func (o *VREF_Type) SetTRM_CHOPEN(value uint8) {
	volatile.StoreUint8(&o.TRM.Reg, volatile.LoadUint8(&o.TRM.Reg)&^(0x40)|value<<6)
}
func (o *VREF_Type) GetTRM_CHOPEN() uint8 {
	return (volatile.LoadUint8(&o.TRM.Reg) & 0x40) >> 6
}

// VREF.SC: VREF Status and Control Register
func (o *VREF_Type) SetSC_MODE_LV(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x3)|value)
}
func (o *VREF_Type) GetSC_MODE_LV() uint8 {
	return volatile.LoadUint8(&o.SC.Reg) & 0x3
}
func (o *VREF_Type) SetSC_VREFST(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x4)|value<<2)
}
func (o *VREF_Type) GetSC_VREFST() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x4) >> 2
}
func (o *VREF_Type) SetSC_ICOMPEN(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x20)|value<<5)
}
func (o *VREF_Type) GetSC_ICOMPEN() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x20) >> 5
}
func (o *VREF_Type) SetSC_REGEN(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x40)|value<<6)
}
func (o *VREF_Type) GetSC_REGEN() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x40) >> 6
}
func (o *VREF_Type) SetSC_VREFEN(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x80)|value<<7)
}
func (o *VREF_Type) GetSC_VREFEN() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x80) >> 7
}

// Low leakage wakeup unit
type LLWU_Type struct {
	PE1   volatile.Register8 // 0x0
	PE2   volatile.Register8 // 0x1
	PE3   volatile.Register8 // 0x2
	PE4   volatile.Register8 // 0x3
	ME    volatile.Register8 // 0x4
	F1    volatile.Register8 // 0x5
	F2    volatile.Register8 // 0x6
	F3    volatile.Register8 // 0x7
	FILT1 volatile.Register8 // 0x8
	FILT2 volatile.Register8 // 0x9
}

// LLWU.PE1: LLWU Pin Enable 1 register
func (o *LLWU_Type) SetPE1_WUPE0(value uint8) {
	volatile.StoreUint8(&o.PE1.Reg, volatile.LoadUint8(&o.PE1.Reg)&^(0x3)|value)
}
func (o *LLWU_Type) GetPE1_WUPE0() uint8 {
	return volatile.LoadUint8(&o.PE1.Reg) & 0x3
}
func (o *LLWU_Type) SetPE1_WUPE1(value uint8) {
	volatile.StoreUint8(&o.PE1.Reg, volatile.LoadUint8(&o.PE1.Reg)&^(0xc)|value<<2)
}
func (o *LLWU_Type) GetPE1_WUPE1() uint8 {
	return (volatile.LoadUint8(&o.PE1.Reg) & 0xc) >> 2
}
func (o *LLWU_Type) SetPE1_WUPE2(value uint8) {
	volatile.StoreUint8(&o.PE1.Reg, volatile.LoadUint8(&o.PE1.Reg)&^(0x30)|value<<4)
}
func (o *LLWU_Type) GetPE1_WUPE2() uint8 {
	return (volatile.LoadUint8(&o.PE1.Reg) & 0x30) >> 4
}
func (o *LLWU_Type) SetPE1_WUPE3(value uint8) {
	volatile.StoreUint8(&o.PE1.Reg, volatile.LoadUint8(&o.PE1.Reg)&^(0xc0)|value<<6)
}
func (o *LLWU_Type) GetPE1_WUPE3() uint8 {
	return (volatile.LoadUint8(&o.PE1.Reg) & 0xc0) >> 6
}

// LLWU.PE2: LLWU Pin Enable 2 register
func (o *LLWU_Type) SetPE2_WUPE4(value uint8) {
	volatile.StoreUint8(&o.PE2.Reg, volatile.LoadUint8(&o.PE2.Reg)&^(0x3)|value)
}
func (o *LLWU_Type) GetPE2_WUPE4() uint8 {
	return volatile.LoadUint8(&o.PE2.Reg) & 0x3
}
func (o *LLWU_Type) SetPE2_WUPE5(value uint8) {
	volatile.StoreUint8(&o.PE2.Reg, volatile.LoadUint8(&o.PE2.Reg)&^(0xc)|value<<2)
}
func (o *LLWU_Type) GetPE2_WUPE5() uint8 {
	return (volatile.LoadUint8(&o.PE2.Reg) & 0xc) >> 2
}
func (o *LLWU_Type) SetPE2_WUPE6(value uint8) {
	volatile.StoreUint8(&o.PE2.Reg, volatile.LoadUint8(&o.PE2.Reg)&^(0x30)|value<<4)
}
func (o *LLWU_Type) GetPE2_WUPE6() uint8 {
	return (volatile.LoadUint8(&o.PE2.Reg) & 0x30) >> 4
}
func (o *LLWU_Type) SetPE2_WUPE7(value uint8) {
	volatile.StoreUint8(&o.PE2.Reg, volatile.LoadUint8(&o.PE2.Reg)&^(0xc0)|value<<6)
}
func (o *LLWU_Type) GetPE2_WUPE7() uint8 {
	return (volatile.LoadUint8(&o.PE2.Reg) & 0xc0) >> 6
}

// LLWU.PE3: LLWU Pin Enable 3 register
func (o *LLWU_Type) SetPE3_WUPE8(value uint8) {
	volatile.StoreUint8(&o.PE3.Reg, volatile.LoadUint8(&o.PE3.Reg)&^(0x3)|value)
}
func (o *LLWU_Type) GetPE3_WUPE8() uint8 {
	return volatile.LoadUint8(&o.PE3.Reg) & 0x3
}
func (o *LLWU_Type) SetPE3_WUPE9(value uint8) {
	volatile.StoreUint8(&o.PE3.Reg, volatile.LoadUint8(&o.PE3.Reg)&^(0xc)|value<<2)
}
func (o *LLWU_Type) GetPE3_WUPE9() uint8 {
	return (volatile.LoadUint8(&o.PE3.Reg) & 0xc) >> 2
}
func (o *LLWU_Type) SetPE3_WUPE10(value uint8) {
	volatile.StoreUint8(&o.PE3.Reg, volatile.LoadUint8(&o.PE3.Reg)&^(0x30)|value<<4)
}
func (o *LLWU_Type) GetPE3_WUPE10() uint8 {
	return (volatile.LoadUint8(&o.PE3.Reg) & 0x30) >> 4
}
func (o *LLWU_Type) SetPE3_WUPE11(value uint8) {
	volatile.StoreUint8(&o.PE3.Reg, volatile.LoadUint8(&o.PE3.Reg)&^(0xc0)|value<<6)
}
func (o *LLWU_Type) GetPE3_WUPE11() uint8 {
	return (volatile.LoadUint8(&o.PE3.Reg) & 0xc0) >> 6
}

// LLWU.PE4: LLWU Pin Enable 4 register
func (o *LLWU_Type) SetPE4_WUPE12(value uint8) {
	volatile.StoreUint8(&o.PE4.Reg, volatile.LoadUint8(&o.PE4.Reg)&^(0x3)|value)
}
func (o *LLWU_Type) GetPE4_WUPE12() uint8 {
	return volatile.LoadUint8(&o.PE4.Reg) & 0x3
}
func (o *LLWU_Type) SetPE4_WUPE13(value uint8) {
	volatile.StoreUint8(&o.PE4.Reg, volatile.LoadUint8(&o.PE4.Reg)&^(0xc)|value<<2)
}
func (o *LLWU_Type) GetPE4_WUPE13() uint8 {
	return (volatile.LoadUint8(&o.PE4.Reg) & 0xc) >> 2
}
func (o *LLWU_Type) SetPE4_WUPE14(value uint8) {
	volatile.StoreUint8(&o.PE4.Reg, volatile.LoadUint8(&o.PE4.Reg)&^(0x30)|value<<4)
}
func (o *LLWU_Type) GetPE4_WUPE14() uint8 {
	return (volatile.LoadUint8(&o.PE4.Reg) & 0x30) >> 4
}
func (o *LLWU_Type) SetPE4_WUPE15(value uint8) {
	volatile.StoreUint8(&o.PE4.Reg, volatile.LoadUint8(&o.PE4.Reg)&^(0xc0)|value<<6)
}
func (o *LLWU_Type) GetPE4_WUPE15() uint8 {
	return (volatile.LoadUint8(&o.PE4.Reg) & 0xc0) >> 6
}

// LLWU.ME: LLWU Module Enable register
func (o *LLWU_Type) SetME_WUME0(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x1)|value)
}
func (o *LLWU_Type) GetME_WUME0() uint8 {
	return volatile.LoadUint8(&o.ME.Reg) & 0x1
}
func (o *LLWU_Type) SetME_WUME1(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x2)|value<<1)
}
func (o *LLWU_Type) GetME_WUME1() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x2) >> 1
}
func (o *LLWU_Type) SetME_WUME2(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x4)|value<<2)
}
func (o *LLWU_Type) GetME_WUME2() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x4) >> 2
}
func (o *LLWU_Type) SetME_WUME3(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x8)|value<<3)
}
func (o *LLWU_Type) GetME_WUME3() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x8) >> 3
}
func (o *LLWU_Type) SetME_WUME4(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x10)|value<<4)
}
func (o *LLWU_Type) GetME_WUME4() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x10) >> 4
}
func (o *LLWU_Type) SetME_WUME5(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x20)|value<<5)
}
func (o *LLWU_Type) GetME_WUME5() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x20) >> 5
}
func (o *LLWU_Type) SetME_WUME6(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x40)|value<<6)
}
func (o *LLWU_Type) GetME_WUME6() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x40) >> 6
}
func (o *LLWU_Type) SetME_WUME7(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetME_WUME7() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x80) >> 7
}

// LLWU.F1: LLWU Flag 1 register
func (o *LLWU_Type) SetF1_WUF0(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x1)|value)
}
func (o *LLWU_Type) GetF1_WUF0() uint8 {
	return volatile.LoadUint8(&o.F1.Reg) & 0x1
}
func (o *LLWU_Type) SetF1_WUF1(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x2)|value<<1)
}
func (o *LLWU_Type) GetF1_WUF1() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x2) >> 1
}
func (o *LLWU_Type) SetF1_WUF2(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x4)|value<<2)
}
func (o *LLWU_Type) GetF1_WUF2() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x4) >> 2
}
func (o *LLWU_Type) SetF1_WUF3(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x8)|value<<3)
}
func (o *LLWU_Type) GetF1_WUF3() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x8) >> 3
}
func (o *LLWU_Type) SetF1_WUF4(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x10)|value<<4)
}
func (o *LLWU_Type) GetF1_WUF4() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x10) >> 4
}
func (o *LLWU_Type) SetF1_WUF5(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x20)|value<<5)
}
func (o *LLWU_Type) GetF1_WUF5() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x20) >> 5
}
func (o *LLWU_Type) SetF1_WUF6(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x40)|value<<6)
}
func (o *LLWU_Type) GetF1_WUF6() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x40) >> 6
}
func (o *LLWU_Type) SetF1_WUF7(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetF1_WUF7() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x80) >> 7
}

// LLWU.F2: LLWU Flag 2 register
func (o *LLWU_Type) SetF2_WUF8(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x1)|value)
}
func (o *LLWU_Type) GetF2_WUF8() uint8 {
	return volatile.LoadUint8(&o.F2.Reg) & 0x1
}
func (o *LLWU_Type) SetF2_WUF9(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x2)|value<<1)
}
func (o *LLWU_Type) GetF2_WUF9() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x2) >> 1
}
func (o *LLWU_Type) SetF2_WUF10(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x4)|value<<2)
}
func (o *LLWU_Type) GetF2_WUF10() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x4) >> 2
}
func (o *LLWU_Type) SetF2_WUF11(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x8)|value<<3)
}
func (o *LLWU_Type) GetF2_WUF11() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x8) >> 3
}
func (o *LLWU_Type) SetF2_WUF12(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x10)|value<<4)
}
func (o *LLWU_Type) GetF2_WUF12() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x10) >> 4
}
func (o *LLWU_Type) SetF2_WUF13(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x20)|value<<5)
}
func (o *LLWU_Type) GetF2_WUF13() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x20) >> 5
}
func (o *LLWU_Type) SetF2_WUF14(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x40)|value<<6)
}
func (o *LLWU_Type) GetF2_WUF14() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x40) >> 6
}
func (o *LLWU_Type) SetF2_WUF15(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetF2_WUF15() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x80) >> 7
}

// LLWU.F3: LLWU Flag 3 register
func (o *LLWU_Type) SetF3_MWUF0(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x1)|value)
}
func (o *LLWU_Type) GetF3_MWUF0() uint8 {
	return volatile.LoadUint8(&o.F3.Reg) & 0x1
}
func (o *LLWU_Type) SetF3_MWUF1(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x2)|value<<1)
}
func (o *LLWU_Type) GetF3_MWUF1() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x2) >> 1
}
func (o *LLWU_Type) SetF3_MWUF2(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x4)|value<<2)
}
func (o *LLWU_Type) GetF3_MWUF2() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x4) >> 2
}
func (o *LLWU_Type) SetF3_MWUF3(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x8)|value<<3)
}
func (o *LLWU_Type) GetF3_MWUF3() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x8) >> 3
}
func (o *LLWU_Type) SetF3_MWUF4(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x10)|value<<4)
}
func (o *LLWU_Type) GetF3_MWUF4() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x10) >> 4
}
func (o *LLWU_Type) SetF3_MWUF5(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x20)|value<<5)
}
func (o *LLWU_Type) GetF3_MWUF5() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x20) >> 5
}
func (o *LLWU_Type) SetF3_MWUF6(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x40)|value<<6)
}
func (o *LLWU_Type) GetF3_MWUF6() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x40) >> 6
}
func (o *LLWU_Type) SetF3_MWUF7(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetF3_MWUF7() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x80) >> 7
}

// LLWU.FILT1: LLWU Pin Filter 1 register
func (o *LLWU_Type) SetFILT1_FILTSEL(value uint8) {
	volatile.StoreUint8(&o.FILT1.Reg, volatile.LoadUint8(&o.FILT1.Reg)&^(0xf)|value)
}
func (o *LLWU_Type) GetFILT1_FILTSEL() uint8 {
	return volatile.LoadUint8(&o.FILT1.Reg) & 0xf
}
func (o *LLWU_Type) SetFILT1_FILTE(value uint8) {
	volatile.StoreUint8(&o.FILT1.Reg, volatile.LoadUint8(&o.FILT1.Reg)&^(0x60)|value<<5)
}
func (o *LLWU_Type) GetFILT1_FILTE() uint8 {
	return (volatile.LoadUint8(&o.FILT1.Reg) & 0x60) >> 5
}
func (o *LLWU_Type) SetFILT1_FILTF(value uint8) {
	volatile.StoreUint8(&o.FILT1.Reg, volatile.LoadUint8(&o.FILT1.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetFILT1_FILTF() uint8 {
	return (volatile.LoadUint8(&o.FILT1.Reg) & 0x80) >> 7
}

// LLWU.FILT2: LLWU Pin Filter 2 register
func (o *LLWU_Type) SetFILT2_FILTSEL(value uint8) {
	volatile.StoreUint8(&o.FILT2.Reg, volatile.LoadUint8(&o.FILT2.Reg)&^(0xf)|value)
}
func (o *LLWU_Type) GetFILT2_FILTSEL() uint8 {
	return volatile.LoadUint8(&o.FILT2.Reg) & 0xf
}
func (o *LLWU_Type) SetFILT2_FILTE(value uint8) {
	volatile.StoreUint8(&o.FILT2.Reg, volatile.LoadUint8(&o.FILT2.Reg)&^(0x60)|value<<5)
}
func (o *LLWU_Type) GetFILT2_FILTE() uint8 {
	return (volatile.LoadUint8(&o.FILT2.Reg) & 0x60) >> 5
}
func (o *LLWU_Type) SetFILT2_FILTF(value uint8) {
	volatile.StoreUint8(&o.FILT2.Reg, volatile.LoadUint8(&o.FILT2.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetFILT2_FILTF() uint8 {
	return (volatile.LoadUint8(&o.FILT2.Reg) & 0x80) >> 7
}

// Power Management Controller
type PMC_Type struct {
	LVDSC1 volatile.Register8 // 0x0
	LVDSC2 volatile.Register8 // 0x1
	REGSC  volatile.Register8 // 0x2
}

// PMC.LVDSC1: Low Voltage Detect Status And Control 1 register
func (o *PMC_Type) SetLVDSC1_LVDV(value uint8) {
	volatile.StoreUint8(&o.LVDSC1.Reg, volatile.LoadUint8(&o.LVDSC1.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetLVDSC1_LVDV() uint8 {
	return volatile.LoadUint8(&o.LVDSC1.Reg) & 0x3
}
func (o *PMC_Type) SetLVDSC1_LVDRE(value uint8) {
	volatile.StoreUint8(&o.LVDSC1.Reg, volatile.LoadUint8(&o.LVDSC1.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetLVDSC1_LVDRE() uint8 {
	return (volatile.LoadUint8(&o.LVDSC1.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetLVDSC1_LVDIE(value uint8) {
	volatile.StoreUint8(&o.LVDSC1.Reg, volatile.LoadUint8(&o.LVDSC1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetLVDSC1_LVDIE() uint8 {
	return (volatile.LoadUint8(&o.LVDSC1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetLVDSC1_LVDACK(value uint8) {
	volatile.StoreUint8(&o.LVDSC1.Reg, volatile.LoadUint8(&o.LVDSC1.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetLVDSC1_LVDACK() uint8 {
	return (volatile.LoadUint8(&o.LVDSC1.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetLVDSC1_LVDF(value uint8) {
	volatile.StoreUint8(&o.LVDSC1.Reg, volatile.LoadUint8(&o.LVDSC1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetLVDSC1_LVDF() uint8 {
	return (volatile.LoadUint8(&o.LVDSC1.Reg) & 0x80) >> 7
}

// PMC.LVDSC2: Low Voltage Detect Status And Control 2 register
func (o *PMC_Type) SetLVDSC2_LVWV(value uint8) {
	volatile.StoreUint8(&o.LVDSC2.Reg, volatile.LoadUint8(&o.LVDSC2.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetLVDSC2_LVWV() uint8 {
	return volatile.LoadUint8(&o.LVDSC2.Reg) & 0x3
}
func (o *PMC_Type) SetLVDSC2_LVWIE(value uint8) {
	volatile.StoreUint8(&o.LVDSC2.Reg, volatile.LoadUint8(&o.LVDSC2.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetLVDSC2_LVWIE() uint8 {
	return (volatile.LoadUint8(&o.LVDSC2.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetLVDSC2_LVWACK(value uint8) {
	volatile.StoreUint8(&o.LVDSC2.Reg, volatile.LoadUint8(&o.LVDSC2.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetLVDSC2_LVWACK() uint8 {
	return (volatile.LoadUint8(&o.LVDSC2.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetLVDSC2_LVWF(value uint8) {
	volatile.StoreUint8(&o.LVDSC2.Reg, volatile.LoadUint8(&o.LVDSC2.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetLVDSC2_LVWF() uint8 {
	return (volatile.LoadUint8(&o.LVDSC2.Reg) & 0x80) >> 7
}

// PMC.REGSC: Regulator Status And Control register
func (o *PMC_Type) SetREGSC_BGBE(value uint8) {
	volatile.StoreUint8(&o.REGSC.Reg, volatile.LoadUint8(&o.REGSC.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetREGSC_BGBE() uint8 {
	return volatile.LoadUint8(&o.REGSC.Reg) & 0x1
}
func (o *PMC_Type) SetREGSC_REGONS(value uint8) {
	volatile.StoreUint8(&o.REGSC.Reg, volatile.LoadUint8(&o.REGSC.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetREGSC_REGONS() uint8 {
	return (volatile.LoadUint8(&o.REGSC.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetREGSC_ACKISO(value uint8) {
	volatile.StoreUint8(&o.REGSC.Reg, volatile.LoadUint8(&o.REGSC.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetREGSC_ACKISO() uint8 {
	return (volatile.LoadUint8(&o.REGSC.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetREGSC_BGEN(value uint8) {
	volatile.StoreUint8(&o.REGSC.Reg, volatile.LoadUint8(&o.REGSC.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetREGSC_BGEN() uint8 {
	return (volatile.LoadUint8(&o.REGSC.Reg) & 0x10) >> 4
}

// System Mode Controller
type SMC_Type struct {
	PMPROT   volatile.Register8 // 0x0
	PMCTRL   volatile.Register8 // 0x1
	STOPCTRL volatile.Register8 // 0x2
	PMSTAT   volatile.Register8 // 0x3
}

// SMC.PMPROT: Power Mode Protection register
func (o *SMC_Type) SetPMPROT_AVLLS(value uint8) {
	volatile.StoreUint8(&o.PMPROT.Reg, volatile.LoadUint8(&o.PMPROT.Reg)&^(0x2)|value<<1)
}
func (o *SMC_Type) GetPMPROT_AVLLS() uint8 {
	return (volatile.LoadUint8(&o.PMPROT.Reg) & 0x2) >> 1
}
func (o *SMC_Type) SetPMPROT_ALLS(value uint8) {
	volatile.StoreUint8(&o.PMPROT.Reg, volatile.LoadUint8(&o.PMPROT.Reg)&^(0x8)|value<<3)
}
func (o *SMC_Type) GetPMPROT_ALLS() uint8 {
	return (volatile.LoadUint8(&o.PMPROT.Reg) & 0x8) >> 3
}
func (o *SMC_Type) SetPMPROT_AVLP(value uint8) {
	volatile.StoreUint8(&o.PMPROT.Reg, volatile.LoadUint8(&o.PMPROT.Reg)&^(0x20)|value<<5)
}
func (o *SMC_Type) GetPMPROT_AVLP() uint8 {
	return (volatile.LoadUint8(&o.PMPROT.Reg) & 0x20) >> 5
}
func (o *SMC_Type) SetPMPROT_AHSRUN(value uint8) {
	volatile.StoreUint8(&o.PMPROT.Reg, volatile.LoadUint8(&o.PMPROT.Reg)&^(0x80)|value<<7)
}
func (o *SMC_Type) GetPMPROT_AHSRUN() uint8 {
	return (volatile.LoadUint8(&o.PMPROT.Reg) & 0x80) >> 7
}

// SMC.PMCTRL: Power Mode Control register
func (o *SMC_Type) SetPMCTRL_STOPM(value uint8) {
	volatile.StoreUint8(&o.PMCTRL.Reg, volatile.LoadUint8(&o.PMCTRL.Reg)&^(0x7)|value)
}
func (o *SMC_Type) GetPMCTRL_STOPM() uint8 {
	return volatile.LoadUint8(&o.PMCTRL.Reg) & 0x7
}
func (o *SMC_Type) SetPMCTRL_STOPA(value uint8) {
	volatile.StoreUint8(&o.PMCTRL.Reg, volatile.LoadUint8(&o.PMCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SMC_Type) GetPMCTRL_STOPA() uint8 {
	return (volatile.LoadUint8(&o.PMCTRL.Reg) & 0x8) >> 3
}
func (o *SMC_Type) SetPMCTRL_RUNM(value uint8) {
	volatile.StoreUint8(&o.PMCTRL.Reg, volatile.LoadUint8(&o.PMCTRL.Reg)&^(0x60)|value<<5)
}
func (o *SMC_Type) GetPMCTRL_RUNM() uint8 {
	return (volatile.LoadUint8(&o.PMCTRL.Reg) & 0x60) >> 5
}

// SMC.STOPCTRL: Stop Control Register
func (o *SMC_Type) SetSTOPCTRL_LLSM(value uint8) {
	volatile.StoreUint8(&o.STOPCTRL.Reg, volatile.LoadUint8(&o.STOPCTRL.Reg)&^(0x7)|value)
}
func (o *SMC_Type) GetSTOPCTRL_LLSM() uint8 {
	return volatile.LoadUint8(&o.STOPCTRL.Reg) & 0x7
}
func (o *SMC_Type) SetSTOPCTRL_PORPO(value uint8) {
	volatile.StoreUint8(&o.STOPCTRL.Reg, volatile.LoadUint8(&o.STOPCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SMC_Type) GetSTOPCTRL_PORPO() uint8 {
	return (volatile.LoadUint8(&o.STOPCTRL.Reg) & 0x20) >> 5
}
func (o *SMC_Type) SetSTOPCTRL_PSTOPO(value uint8) {
	volatile.StoreUint8(&o.STOPCTRL.Reg, volatile.LoadUint8(&o.STOPCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SMC_Type) GetSTOPCTRL_PSTOPO() uint8 {
	return (volatile.LoadUint8(&o.STOPCTRL.Reg) & 0xc0) >> 6
}

// SMC.PMSTAT: Power Mode Status register
func (o *SMC_Type) SetPMSTAT(value uint8) {
	volatile.StoreUint8(&o.PMSTAT.Reg, value)
}
func (o *SMC_Type) GetPMSTAT() uint8 {
	return volatile.LoadUint8(&o.PMSTAT.Reg)
}

// Reset Control Module
type RCM_Type struct {
	SRS0  volatile.Register8 // 0x0
	SRS1  volatile.Register8 // 0x1
	_     [2]byte
	RPFC  volatile.Register8 // 0x4
	RPFW  volatile.Register8 // 0x5
	_     byte
	MR    volatile.Register8 // 0x7
	SSRS0 volatile.Register8 // 0x8
	SSRS1 volatile.Register8 // 0x9
}

// RCM.SRS0: System Reset Status Register 0
func (o *RCM_Type) SetSRS0_WAKEUP(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x1)|value)
}
func (o *RCM_Type) GetSRS0_WAKEUP() uint8 {
	return volatile.LoadUint8(&o.SRS0.Reg) & 0x1
}
func (o *RCM_Type) SetSRS0_LVD(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x2)|value<<1)
}
func (o *RCM_Type) GetSRS0_LVD() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x2) >> 1
}
func (o *RCM_Type) SetSRS0_LOC(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x4)|value<<2)
}
func (o *RCM_Type) GetSRS0_LOC() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x4) >> 2
}
func (o *RCM_Type) SetSRS0_LOL(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x8)|value<<3)
}
func (o *RCM_Type) GetSRS0_LOL() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x8) >> 3
}
func (o *RCM_Type) SetSRS0_WDOG(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x20)|value<<5)
}
func (o *RCM_Type) GetSRS0_WDOG() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x20) >> 5
}
func (o *RCM_Type) SetSRS0_PIN(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x40)|value<<6)
}
func (o *RCM_Type) GetSRS0_PIN() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x40) >> 6
}
func (o *RCM_Type) SetSRS0_POR(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x80)|value<<7)
}
func (o *RCM_Type) GetSRS0_POR() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x80) >> 7
}

// RCM.SRS1: System Reset Status Register 1
func (o *RCM_Type) SetSRS1_JTAG(value uint8) {
	volatile.StoreUint8(&o.SRS1.Reg, volatile.LoadUint8(&o.SRS1.Reg)&^(0x1)|value)
}
func (o *RCM_Type) GetSRS1_JTAG() uint8 {
	return volatile.LoadUint8(&o.SRS1.Reg) & 0x1
}
func (o *RCM_Type) SetSRS1_LOCKUP(value uint8) {
	volatile.StoreUint8(&o.SRS1.Reg, volatile.LoadUint8(&o.SRS1.Reg)&^(0x2)|value<<1)
}
func (o *RCM_Type) GetSRS1_LOCKUP() uint8 {
	return (volatile.LoadUint8(&o.SRS1.Reg) & 0x2) >> 1
}
func (o *RCM_Type) SetSRS1_SW(value uint8) {
	volatile.StoreUint8(&o.SRS1.Reg, volatile.LoadUint8(&o.SRS1.Reg)&^(0x4)|value<<2)
}
func (o *RCM_Type) GetSRS1_SW() uint8 {
	return (volatile.LoadUint8(&o.SRS1.Reg) & 0x4) >> 2
}
func (o *RCM_Type) SetSRS1_MDM_AP(value uint8) {
	volatile.StoreUint8(&o.SRS1.Reg, volatile.LoadUint8(&o.SRS1.Reg)&^(0x8)|value<<3)
}
func (o *RCM_Type) GetSRS1_MDM_AP() uint8 {
	return (volatile.LoadUint8(&o.SRS1.Reg) & 0x8) >> 3
}
func (o *RCM_Type) SetSRS1_EZPT(value uint8) {
	volatile.StoreUint8(&o.SRS1.Reg, volatile.LoadUint8(&o.SRS1.Reg)&^(0x10)|value<<4)
}
func (o *RCM_Type) GetSRS1_EZPT() uint8 {
	return (volatile.LoadUint8(&o.SRS1.Reg) & 0x10) >> 4
}
func (o *RCM_Type) SetSRS1_SACKERR(value uint8) {
	volatile.StoreUint8(&o.SRS1.Reg, volatile.LoadUint8(&o.SRS1.Reg)&^(0x20)|value<<5)
}
func (o *RCM_Type) GetSRS1_SACKERR() uint8 {
	return (volatile.LoadUint8(&o.SRS1.Reg) & 0x20) >> 5
}

// RCM.RPFC: Reset Pin Filter Control register
func (o *RCM_Type) SetRPFC_RSTFLTSRW(value uint8) {
	volatile.StoreUint8(&o.RPFC.Reg, volatile.LoadUint8(&o.RPFC.Reg)&^(0x3)|value)
}
func (o *RCM_Type) GetRPFC_RSTFLTSRW() uint8 {
	return volatile.LoadUint8(&o.RPFC.Reg) & 0x3
}
func (o *RCM_Type) SetRPFC_RSTFLTSS(value uint8) {
	volatile.StoreUint8(&o.RPFC.Reg, volatile.LoadUint8(&o.RPFC.Reg)&^(0x4)|value<<2)
}
func (o *RCM_Type) GetRPFC_RSTFLTSS() uint8 {
	return (volatile.LoadUint8(&o.RPFC.Reg) & 0x4) >> 2
}

// RCM.RPFW: Reset Pin Filter Width register
func (o *RCM_Type) SetRPFW_RSTFLTSEL(value uint8) {
	volatile.StoreUint8(&o.RPFW.Reg, volatile.LoadUint8(&o.RPFW.Reg)&^(0x1f)|value)
}
func (o *RCM_Type) GetRPFW_RSTFLTSEL() uint8 {
	return volatile.LoadUint8(&o.RPFW.Reg) & 0x1f
}

// RCM.MR: Mode Register
func (o *RCM_Type) SetMR_EZP_MS(value uint8) {
	volatile.StoreUint8(&o.MR.Reg, volatile.LoadUint8(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *RCM_Type) GetMR_EZP_MS() uint8 {
	return (volatile.LoadUint8(&o.MR.Reg) & 0x2) >> 1
}

// RCM.SSRS0: Sticky System Reset Status Register 0
func (o *RCM_Type) SetSSRS0_SWAKEUP(value uint8) {
	volatile.StoreUint8(&o.SSRS0.Reg, volatile.LoadUint8(&o.SSRS0.Reg)&^(0x1)|value)
}
func (o *RCM_Type) GetSSRS0_SWAKEUP() uint8 {
	return volatile.LoadUint8(&o.SSRS0.Reg) & 0x1
}
func (o *RCM_Type) SetSSRS0_SLVD(value uint8) {
	volatile.StoreUint8(&o.SSRS0.Reg, volatile.LoadUint8(&o.SSRS0.Reg)&^(0x2)|value<<1)
}
func (o *RCM_Type) GetSSRS0_SLVD() uint8 {
	return (volatile.LoadUint8(&o.SSRS0.Reg) & 0x2) >> 1
}
func (o *RCM_Type) SetSSRS0_SLOC(value uint8) {
	volatile.StoreUint8(&o.SSRS0.Reg, volatile.LoadUint8(&o.SSRS0.Reg)&^(0x4)|value<<2)
}
func (o *RCM_Type) GetSSRS0_SLOC() uint8 {
	return (volatile.LoadUint8(&o.SSRS0.Reg) & 0x4) >> 2
}
func (o *RCM_Type) SetSSRS0_SLOL(value uint8) {
	volatile.StoreUint8(&o.SSRS0.Reg, volatile.LoadUint8(&o.SSRS0.Reg)&^(0x8)|value<<3)
}
func (o *RCM_Type) GetSSRS0_SLOL() uint8 {
	return (volatile.LoadUint8(&o.SSRS0.Reg) & 0x8) >> 3
}
func (o *RCM_Type) SetSSRS0_SWDOG(value uint8) {
	volatile.StoreUint8(&o.SSRS0.Reg, volatile.LoadUint8(&o.SSRS0.Reg)&^(0x20)|value<<5)
}
func (o *RCM_Type) GetSSRS0_SWDOG() uint8 {
	return (volatile.LoadUint8(&o.SSRS0.Reg) & 0x20) >> 5
}
func (o *RCM_Type) SetSSRS0_SPIN(value uint8) {
	volatile.StoreUint8(&o.SSRS0.Reg, volatile.LoadUint8(&o.SSRS0.Reg)&^(0x40)|value<<6)
}
func (o *RCM_Type) GetSSRS0_SPIN() uint8 {
	return (volatile.LoadUint8(&o.SSRS0.Reg) & 0x40) >> 6
}
func (o *RCM_Type) SetSSRS0_SPOR(value uint8) {
	volatile.StoreUint8(&o.SSRS0.Reg, volatile.LoadUint8(&o.SSRS0.Reg)&^(0x80)|value<<7)
}
func (o *RCM_Type) GetSSRS0_SPOR() uint8 {
	return (volatile.LoadUint8(&o.SSRS0.Reg) & 0x80) >> 7
}

// RCM.SSRS1: Sticky System Reset Status Register 1
func (o *RCM_Type) SetSSRS1_SJTAG(value uint8) {
	volatile.StoreUint8(&o.SSRS1.Reg, volatile.LoadUint8(&o.SSRS1.Reg)&^(0x1)|value)
}
func (o *RCM_Type) GetSSRS1_SJTAG() uint8 {
	return volatile.LoadUint8(&o.SSRS1.Reg) & 0x1
}
func (o *RCM_Type) SetSSRS1_SLOCKUP(value uint8) {
	volatile.StoreUint8(&o.SSRS1.Reg, volatile.LoadUint8(&o.SSRS1.Reg)&^(0x2)|value<<1)
}
func (o *RCM_Type) GetSSRS1_SLOCKUP() uint8 {
	return (volatile.LoadUint8(&o.SSRS1.Reg) & 0x2) >> 1
}
func (o *RCM_Type) SetSSRS1_SSW(value uint8) {
	volatile.StoreUint8(&o.SSRS1.Reg, volatile.LoadUint8(&o.SSRS1.Reg)&^(0x4)|value<<2)
}
func (o *RCM_Type) GetSSRS1_SSW() uint8 {
	return (volatile.LoadUint8(&o.SSRS1.Reg) & 0x4) >> 2
}
func (o *RCM_Type) SetSSRS1_SMDM_AP(value uint8) {
	volatile.StoreUint8(&o.SSRS1.Reg, volatile.LoadUint8(&o.SSRS1.Reg)&^(0x8)|value<<3)
}
func (o *RCM_Type) GetSSRS1_SMDM_AP() uint8 {
	return (volatile.LoadUint8(&o.SSRS1.Reg) & 0x8) >> 3
}
func (o *RCM_Type) SetSSRS1_SEZPT(value uint8) {
	volatile.StoreUint8(&o.SSRS1.Reg, volatile.LoadUint8(&o.SSRS1.Reg)&^(0x10)|value<<4)
}
func (o *RCM_Type) GetSSRS1_SEZPT() uint8 {
	return (volatile.LoadUint8(&o.SSRS1.Reg) & 0x10) >> 4
}
func (o *RCM_Type) SetSSRS1_SSACKERR(value uint8) {
	volatile.StoreUint8(&o.SSRS1.Reg, volatile.LoadUint8(&o.SSRS1.Reg)&^(0x20)|value<<5)
}
func (o *RCM_Type) GetSSRS1_SSACKERR() uint8 {
	return (volatile.LoadUint8(&o.SSRS1.Reg) & 0x20) >> 5
}

// General Purpose Input/Output
type GPIO_Type struct {
	PDOR volatile.Register32 // 0x0
	PSOR volatile.Register32 // 0x4
	PCOR volatile.Register32 // 0x8
	PTOR volatile.Register32 // 0xC
	PDIR volatile.Register32 // 0x10
	PDDR volatile.Register32 // 0x14
}

// GPIO.PDOR: Port Data Output Register
func (o *GPIO_Type) SetPDOR(value uint32) {
	volatile.StoreUint32(&o.PDOR.Reg, value)
}
func (o *GPIO_Type) GetPDOR() uint32 {
	return volatile.LoadUint32(&o.PDOR.Reg)
}

// GPIO.PSOR: Port Set Output Register
func (o *GPIO_Type) SetPSOR(value uint32) {
	volatile.StoreUint32(&o.PSOR.Reg, value)
}
func (o *GPIO_Type) GetPSOR() uint32 {
	return volatile.LoadUint32(&o.PSOR.Reg)
}

// GPIO.PCOR: Port Clear Output Register
func (o *GPIO_Type) SetPCOR(value uint32) {
	volatile.StoreUint32(&o.PCOR.Reg, value)
}
func (o *GPIO_Type) GetPCOR() uint32 {
	return volatile.LoadUint32(&o.PCOR.Reg)
}

// GPIO.PTOR: Port Toggle Output Register
func (o *GPIO_Type) SetPTOR(value uint32) {
	volatile.StoreUint32(&o.PTOR.Reg, value)
}
func (o *GPIO_Type) GetPTOR() uint32 {
	return volatile.LoadUint32(&o.PTOR.Reg)
}

// GPIO.PDIR: Port Data Input Register
func (o *GPIO_Type) SetPDIR(value uint32) {
	volatile.StoreUint32(&o.PDIR.Reg, value)
}
func (o *GPIO_Type) GetPDIR() uint32 {
	return volatile.LoadUint32(&o.PDIR.Reg)
}

// GPIO.PDDR: Port Data Direction Register
func (o *GPIO_Type) SetPDDR(value uint32) {
	volatile.StoreUint32(&o.PDDR.Reg, value)
}
func (o *GPIO_Type) GetPDDR() uint32 {
	return volatile.LoadUint32(&o.PDDR.Reg)
}

// System Control Block
type SystemControl_Type struct {
	_      [8]byte
	ACTLR  volatile.Register32 // 0x8
	_      [3316]byte
	CPUID  volatile.Register32 // 0xD00
	ICSR   volatile.Register32 // 0xD04
	VTOR   volatile.Register32 // 0xD08
	AIRCR  volatile.Register32 // 0xD0C
	SCR    volatile.Register32 // 0xD10
	CCR    volatile.Register32 // 0xD14
	SHPR1  volatile.Register32 // 0xD18
	SHPR2  volatile.Register32 // 0xD1C
	SHPR3  volatile.Register32 // 0xD20
	SHCSR  volatile.Register32 // 0xD24
	CFSR   volatile.Register32 // 0xD28
	HFSR   volatile.Register32 // 0xD2C
	DFSR   volatile.Register32 // 0xD30
	MMFAR  volatile.Register32 // 0xD34
	BFAR   volatile.Register32 // 0xD38
	AFSR   volatile.Register32 // 0xD3C
	_      [72]byte
	CPACR  volatile.Register32 // 0xD88
	_      [424]byte
	FPCCR  volatile.Register32 // 0xF34
	FPCAR  volatile.Register32 // 0xF38
	FPDSCR volatile.Register32 // 0xF3C
}

// SystemControl.ACTLR: Auxiliary Control Register,
func (o *SystemControl_Type) SetACTLR_DISMCYCINT(value uint32) {
	volatile.StoreUint32(&o.ACTLR.Reg, volatile.LoadUint32(&o.ACTLR.Reg)&^(0x1)|value)
}
func (o *SystemControl_Type) GetACTLR_DISMCYCINT() uint32 {
	return volatile.LoadUint32(&o.ACTLR.Reg) & 0x1
}
func (o *SystemControl_Type) SetACTLR_DISDEFWBUF(value uint32) {
	volatile.StoreUint32(&o.ACTLR.Reg, volatile.LoadUint32(&o.ACTLR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetACTLR_DISDEFWBUF() uint32 {
	return (volatile.LoadUint32(&o.ACTLR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetACTLR_DISFOLD(value uint32) {
	volatile.StoreUint32(&o.ACTLR.Reg, volatile.LoadUint32(&o.ACTLR.Reg)&^(0x4)|value<<2)
}
func (o *SystemControl_Type) GetACTLR_DISFOLD() uint32 {
	return (volatile.LoadUint32(&o.ACTLR.Reg) & 0x4) >> 2
}

// SystemControl.CPUID: CPUID Base Register
func (o *SystemControl_Type) SetCPUID_REVISION(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf)|value)
}
func (o *SystemControl_Type) GetCPUID_REVISION() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xf
}
func (o *SystemControl_Type) SetCPUID_PARTNO(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xfff0)|value<<4)
}
func (o *SystemControl_Type) GetCPUID_PARTNO() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xfff0) >> 4
}
func (o *SystemControl_Type) SetCPUID_VARIANT(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf00000)|value<<20)
}
func (o *SystemControl_Type) GetCPUID_VARIANT() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf00000) >> 20
}
func (o *SystemControl_Type) SetCPUID_IMPLEMENTER(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff000000)|value<<24)
}
func (o *SystemControl_Type) GetCPUID_IMPLEMENTER() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xff000000) >> 24
}

// SystemControl.ICSR: Interrupt Control and State Register
func (o *SystemControl_Type) SetICSR_VECTACTIVE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1ff)|value)
}
func (o *SystemControl_Type) GetICSR_VECTACTIVE() uint32 {
	return volatile.LoadUint32(&o.ICSR.Reg) & 0x1ff
}
func (o *SystemControl_Type) SetICSR_RETTOBASE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x800)|value<<11)
}
func (o *SystemControl_Type) GetICSR_RETTOBASE() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x800) >> 11
}
func (o *SystemControl_Type) SetICSR_VECTPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x3f000)|value<<12)
}
func (o *SystemControl_Type) GetICSR_VECTPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x3f000) >> 12
}
func (o *SystemControl_Type) SetICSR_ISRPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x400000)|value<<22)
}
func (o *SystemControl_Type) GetICSR_ISRPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x400000) >> 22
}
func (o *SystemControl_Type) SetICSR_ISRPREEMPT(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x800000)|value<<23)
}
func (o *SystemControl_Type) GetICSR_ISRPREEMPT() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x800000) >> 23
}
func (o *SystemControl_Type) SetICSR_PENDSTCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SystemControl_Type) GetICSR_PENDSTCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2000000) >> 25
}
func (o *SystemControl_Type) SetICSR_PENDSTSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4000000)|value<<26)
}
func (o *SystemControl_Type) GetICSR_PENDSTSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4000000) >> 26
}
func (o *SystemControl_Type) SetICSR_PENDSVCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8000000)|value<<27)
}
func (o *SystemControl_Type) GetICSR_PENDSVCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8000000) >> 27
}
func (o *SystemControl_Type) SetICSR_PENDSVSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000000)|value<<28)
}
func (o *SystemControl_Type) GetICSR_PENDSVSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000000) >> 28
}
func (o *SystemControl_Type) SetICSR_NMIPENDSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SystemControl_Type) GetICSR_NMIPENDSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80000000) >> 31
}

// SystemControl.VTOR: Vector Table Offset Register
func (o *SystemControl_Type) SetVTOR_TBLOFF(value uint32) {
	volatile.StoreUint32(&o.VTOR.Reg, volatile.LoadUint32(&o.VTOR.Reg)&^(0xffffff80)|value<<7)
}
func (o *SystemControl_Type) GetVTOR_TBLOFF() uint32 {
	return (volatile.LoadUint32(&o.VTOR.Reg) & 0xffffff80) >> 7
}

// SystemControl.AIRCR: Application Interrupt and Reset Control Register
func (o *SystemControl_Type) SetAIRCR_VECTRESET(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x1)|value)
}
func (o *SystemControl_Type) GetAIRCR_VECTRESET() uint32 {
	return volatile.LoadUint32(&o.AIRCR.Reg) & 0x1
}
func (o *SystemControl_Type) SetAIRCR_VECTCLRACTIVE(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetAIRCR_VECTCLRACTIVE() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetAIRCR_SYSRESETREQ(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x4)|value<<2)
}
func (o *SystemControl_Type) GetAIRCR_SYSRESETREQ() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x4) >> 2
}
func (o *SystemControl_Type) SetAIRCR_PRIGROUP(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x700)|value<<8)
}
func (o *SystemControl_Type) GetAIRCR_PRIGROUP() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x700) >> 8
}
func (o *SystemControl_Type) SetAIRCR_ENDIANNESS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x8000)|value<<15)
}
func (o *SystemControl_Type) GetAIRCR_ENDIANNESS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x8000) >> 15
}
func (o *SystemControl_Type) SetAIRCR_VECTKEY(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SystemControl_Type) GetAIRCR_VECTKEY() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0xffff0000) >> 16
}

// SystemControl.SCR: System Control Register
func (o *SystemControl_Type) SetSCR_SLEEPONEXIT(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetSCR_SLEEPONEXIT() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetSCR_SLEEPDEEP(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SystemControl_Type) GetSCR_SLEEPDEEP() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SystemControl_Type) SetSCR_SEVONPEND(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SystemControl_Type) GetSCR_SEVONPEND() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}

// SystemControl.CCR: Configuration and Control Register
func (o *SystemControl_Type) SetCCR_NONBASETHRDENA(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *SystemControl_Type) GetCCR_NONBASETHRDENA() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *SystemControl_Type) SetCCR_USERSETMPEND(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetCCR_USERSETMPEND() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetCCR_UNALIGN_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *SystemControl_Type) GetCCR_UNALIGN_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *SystemControl_Type) SetCCR_DIV_0_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *SystemControl_Type) GetCCR_DIV_0_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *SystemControl_Type) SetCCR_BFHFNMIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *SystemControl_Type) GetCCR_BFHFNMIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *SystemControl_Type) SetCCR_STKALIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200)|value<<9)
}
func (o *SystemControl_Type) GetCCR_STKALIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200) >> 9
}

// SystemControl.SHPR1: System Handler Priority Register 1
func (o *SystemControl_Type) SetSHPR1_PRI_4(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff)|value)
}
func (o *SystemControl_Type) GetSHPR1_PRI_4() uint32 {
	return volatile.LoadUint32(&o.SHPR1.Reg) & 0xff
}
func (o *SystemControl_Type) SetSHPR1_PRI_5(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff00)|value<<8)
}
func (o *SystemControl_Type) GetSHPR1_PRI_5() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff00) >> 8
}
func (o *SystemControl_Type) SetSHPR1_PRI_6(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *SystemControl_Type) GetSHPR1_PRI_6() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff0000) >> 16
}

// SystemControl.SHPR2: System Handler Priority Register 2
func (o *SystemControl_Type) SetSHPR2_PRI_11(value uint32) {
	volatile.StoreUint32(&o.SHPR2.Reg, volatile.LoadUint32(&o.SHPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *SystemControl_Type) GetSHPR2_PRI_11() uint32 {
	return (volatile.LoadUint32(&o.SHPR2.Reg) & 0xff000000) >> 24
}

// SystemControl.SHPR3: System Handler Priority Register 3
func (o *SystemControl_Type) SetSHPR3_PRI_14(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *SystemControl_Type) GetSHPR3_PRI_14() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff0000) >> 16
}
func (o *SystemControl_Type) SetSHPR3_PRI_15(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *SystemControl_Type) GetSHPR3_PRI_15() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff000000) >> 24
}

// SystemControl.SHCSR: System Handler Control and State Register
func (o *SystemControl_Type) SetSHCSR_MEMFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x1)|value)
}
func (o *SystemControl_Type) GetSHCSR_MEMFAULTACT() uint32 {
	return volatile.LoadUint32(&o.SHCSR.Reg) & 0x1
}
func (o *SystemControl_Type) SetSHCSR_BUSFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetSHCSR_BUSFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetSHCSR_USGFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x8)|value<<3)
}
func (o *SystemControl_Type) GetSHCSR_USGFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x8) >> 3
}
func (o *SystemControl_Type) SetSHCSR_SVCALLACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x80)|value<<7)
}
func (o *SystemControl_Type) GetSHCSR_SVCALLACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x80) >> 7
}
func (o *SystemControl_Type) SetSHCSR_MONITORACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x100)|value<<8)
}
func (o *SystemControl_Type) GetSHCSR_MONITORACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x100) >> 8
}
func (o *SystemControl_Type) SetSHCSR_PENDSVACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x400)|value<<10)
}
func (o *SystemControl_Type) GetSHCSR_PENDSVACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x400) >> 10
}
func (o *SystemControl_Type) SetSHCSR_SYSTICKACT(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x800)|value<<11)
}
func (o *SystemControl_Type) GetSHCSR_SYSTICKACT() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x800) >> 11
}
func (o *SystemControl_Type) SetSHCSR_USGFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x1000)|value<<12)
}
func (o *SystemControl_Type) GetSHCSR_USGFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x1000) >> 12
}
func (o *SystemControl_Type) SetSHCSR_MEMFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x2000)|value<<13)
}
func (o *SystemControl_Type) GetSHCSR_MEMFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x2000) >> 13
}
func (o *SystemControl_Type) SetSHCSR_BUSFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x4000)|value<<14)
}
func (o *SystemControl_Type) GetSHCSR_BUSFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x4000) >> 14
}
func (o *SystemControl_Type) SetSHCSR_SVCALLPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x8000)|value<<15)
}
func (o *SystemControl_Type) GetSHCSR_SVCALLPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x8000) >> 15
}
func (o *SystemControl_Type) SetSHCSR_MEMFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x10000)|value<<16)
}
func (o *SystemControl_Type) GetSHCSR_MEMFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x10000) >> 16
}
func (o *SystemControl_Type) SetSHCSR_BUSFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x20000)|value<<17)
}
func (o *SystemControl_Type) GetSHCSR_BUSFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x20000) >> 17
}
func (o *SystemControl_Type) SetSHCSR_USGFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x40000)|value<<18)
}
func (o *SystemControl_Type) GetSHCSR_USGFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x40000) >> 18
}

// SystemControl.CFSR: Configurable Fault Status Registers
func (o *SystemControl_Type) SetCFSR_IACCVIOL(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x1)|value)
}
func (o *SystemControl_Type) GetCFSR_IACCVIOL() uint32 {
	return volatile.LoadUint32(&o.CFSR.Reg) & 0x1
}
func (o *SystemControl_Type) SetCFSR_DACCVIOL(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetCFSR_DACCVIOL() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetCFSR_MUNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x8)|value<<3)
}
func (o *SystemControl_Type) GetCFSR_MUNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x8) >> 3
}
func (o *SystemControl_Type) SetCFSR_MSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x10)|value<<4)
}
func (o *SystemControl_Type) GetCFSR_MSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x10) >> 4
}
func (o *SystemControl_Type) SetCFSR_MLSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x20)|value<<5)
}
func (o *SystemControl_Type) GetCFSR_MLSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x20) >> 5
}
func (o *SystemControl_Type) SetCFSR_MMARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x80)|value<<7)
}
func (o *SystemControl_Type) GetCFSR_MMARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x80) >> 7
}
func (o *SystemControl_Type) SetCFSR_IBUSERR(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x100)|value<<8)
}
func (o *SystemControl_Type) GetCFSR_IBUSERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x100) >> 8
}
func (o *SystemControl_Type) SetCFSR_PRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x200)|value<<9)
}
func (o *SystemControl_Type) GetCFSR_PRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x200) >> 9
}
func (o *SystemControl_Type) SetCFSR_IMPRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x400)|value<<10)
}
func (o *SystemControl_Type) GetCFSR_IMPRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x400) >> 10
}
func (o *SystemControl_Type) SetCFSR_UNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x800)|value<<11)
}
func (o *SystemControl_Type) GetCFSR_UNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x800) >> 11
}
func (o *SystemControl_Type) SetCFSR_STKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x1000)|value<<12)
}
func (o *SystemControl_Type) GetCFSR_STKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x1000) >> 12
}
func (o *SystemControl_Type) SetCFSR_LSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x2000)|value<<13)
}
func (o *SystemControl_Type) GetCFSR_LSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x2000) >> 13
}
func (o *SystemControl_Type) SetCFSR_BFARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x8000)|value<<15)
}
func (o *SystemControl_Type) GetCFSR_BFARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x8000) >> 15
}
func (o *SystemControl_Type) SetCFSR_UNDEFINSTR(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x10000)|value<<16)
}
func (o *SystemControl_Type) GetCFSR_UNDEFINSTR() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x10000) >> 16
}
func (o *SystemControl_Type) SetCFSR_INVSTATE(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x20000)|value<<17)
}
func (o *SystemControl_Type) GetCFSR_INVSTATE() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x20000) >> 17
}
func (o *SystemControl_Type) SetCFSR_INVPC(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x40000)|value<<18)
}
func (o *SystemControl_Type) GetCFSR_INVPC() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x40000) >> 18
}
func (o *SystemControl_Type) SetCFSR_NOCP(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x80000)|value<<19)
}
func (o *SystemControl_Type) GetCFSR_NOCP() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x80000) >> 19
}
func (o *SystemControl_Type) SetCFSR_UNALIGNED(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *SystemControl_Type) GetCFSR_UNALIGNED() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x1000000) >> 24
}
func (o *SystemControl_Type) SetCFSR_DIVBYZERO(value uint32) {
	volatile.StoreUint32(&o.CFSR.Reg, volatile.LoadUint32(&o.CFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SystemControl_Type) GetCFSR_DIVBYZERO() uint32 {
	return (volatile.LoadUint32(&o.CFSR.Reg) & 0x2000000) >> 25
}

// SystemControl.HFSR: HardFault Status register
func (o *SystemControl_Type) SetHFSR_VECTTBL(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetHFSR_VECTTBL() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetHFSR_FORCED(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *SystemControl_Type) GetHFSR_FORCED() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x40000000) >> 30
}
func (o *SystemControl_Type) SetHFSR_DEBUGEVT(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SystemControl_Type) GetHFSR_DEBUGEVT() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x80000000) >> 31
}

// SystemControl.DFSR: Debug Fault Status Register
func (o *SystemControl_Type) SetDFSR_HALTED(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x1)|value)
}
func (o *SystemControl_Type) GetDFSR_HALTED() uint32 {
	return volatile.LoadUint32(&o.DFSR.Reg) & 0x1
}
func (o *SystemControl_Type) SetDFSR_BKPT(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetDFSR_BKPT() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetDFSR_DWTTRAP(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x4)|value<<2)
}
func (o *SystemControl_Type) GetDFSR_DWTTRAP() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x4) >> 2
}
func (o *SystemControl_Type) SetDFSR_VCATCH(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x8)|value<<3)
}
func (o *SystemControl_Type) GetDFSR_VCATCH() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x8) >> 3
}
func (o *SystemControl_Type) SetDFSR_EXTERNAL(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x10)|value<<4)
}
func (o *SystemControl_Type) GetDFSR_EXTERNAL() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x10) >> 4
}

// SystemControl.MMFAR: MemManage Address Register
func (o *SystemControl_Type) SetMMFAR(value uint32) {
	volatile.StoreUint32(&o.MMFAR.Reg, value)
}
func (o *SystemControl_Type) GetMMFAR() uint32 {
	return volatile.LoadUint32(&o.MMFAR.Reg)
}

// SystemControl.BFAR: BusFault Address Register
func (o *SystemControl_Type) SetBFAR(value uint32) {
	volatile.StoreUint32(&o.BFAR.Reg, value)
}
func (o *SystemControl_Type) GetBFAR() uint32 {
	return volatile.LoadUint32(&o.BFAR.Reg)
}

// SystemControl.AFSR: Auxiliary Fault Status Register
func (o *SystemControl_Type) SetAFSR(value uint32) {
	volatile.StoreUint32(&o.AFSR.Reg, value)
}
func (o *SystemControl_Type) GetAFSR() uint32 {
	return volatile.LoadUint32(&o.AFSR.Reg)
}

// SystemControl.CPACR: Coprocessor Access Control Register
func (o *SystemControl_Type) SetCPACR_CP10(value uint32) {
	volatile.StoreUint32(&o.CPACR.Reg, volatile.LoadUint32(&o.CPACR.Reg)&^(0x300000)|value<<20)
}
func (o *SystemControl_Type) GetCPACR_CP10() uint32 {
	return (volatile.LoadUint32(&o.CPACR.Reg) & 0x300000) >> 20
}
func (o *SystemControl_Type) SetCPACR_CP11(value uint32) {
	volatile.StoreUint32(&o.CPACR.Reg, volatile.LoadUint32(&o.CPACR.Reg)&^(0xc00000)|value<<22)
}
func (o *SystemControl_Type) GetCPACR_CP11() uint32 {
	return (volatile.LoadUint32(&o.CPACR.Reg) & 0xc00000) >> 22
}

// SystemControl.FPCCR: Floating-point Context Control Register
func (o *SystemControl_Type) SetFPCCR_LSPACT(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x1)|value)
}
func (o *SystemControl_Type) GetFPCCR_LSPACT() uint32 {
	return volatile.LoadUint32(&o.FPCCR.Reg) & 0x1
}
func (o *SystemControl_Type) SetFPCCR_USER(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetFPCCR_USER() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetFPCCR_THREAD(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x8)|value<<3)
}
func (o *SystemControl_Type) GetFPCCR_THREAD() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x8) >> 3
}
func (o *SystemControl_Type) SetFPCCR_HFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x10)|value<<4)
}
func (o *SystemControl_Type) GetFPCCR_HFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x10) >> 4
}
func (o *SystemControl_Type) SetFPCCR_MMRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x20)|value<<5)
}
func (o *SystemControl_Type) GetFPCCR_MMRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x20) >> 5
}
func (o *SystemControl_Type) SetFPCCR_BFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40)|value<<6)
}
func (o *SystemControl_Type) GetFPCCR_BFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40) >> 6
}
func (o *SystemControl_Type) SetFPCCR_MONRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x100)|value<<8)
}
func (o *SystemControl_Type) GetFPCCR_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x100) >> 8
}
func (o *SystemControl_Type) SetFPCCR_LSPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40000000)|value<<30)
}
func (o *SystemControl_Type) GetFPCCR_LSPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40000000) >> 30
}
func (o *SystemControl_Type) SetFPCCR_ASPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x80000000)|value<<31)
}
func (o *SystemControl_Type) GetFPCCR_ASPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x80000000) >> 31
}

// SystemControl.FPCAR: Floating-point Context Address Register
func (o *SystemControl_Type) SetFPCAR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.FPCAR.Reg, volatile.LoadUint32(&o.FPCAR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *SystemControl_Type) GetFPCAR_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.FPCAR.Reg) & 0xfffffff8) >> 3
}

// SystemControl.FPDSCR: Floating-point Default Status Control Register
func (o *SystemControl_Type) SetFPDSCR_RMode(value uint32) {
	volatile.StoreUint32(&o.FPDSCR.Reg, volatile.LoadUint32(&o.FPDSCR.Reg)&^(0xc00000)|value<<22)
}
func (o *SystemControl_Type) GetFPDSCR_RMode() uint32 {
	return (volatile.LoadUint32(&o.FPDSCR.Reg) & 0xc00000) >> 22
}
func (o *SystemControl_Type) SetFPDSCR_FZ(value uint32) {
	volatile.StoreUint32(&o.FPDSCR.Reg, volatile.LoadUint32(&o.FPDSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *SystemControl_Type) GetFPDSCR_FZ() uint32 {
	return (volatile.LoadUint32(&o.FPDSCR.Reg) & 0x1000000) >> 24
}
func (o *SystemControl_Type) SetFPDSCR_DN(value uint32) {
	volatile.StoreUint32(&o.FPDSCR.Reg, volatile.LoadUint32(&o.FPDSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *SystemControl_Type) GetFPDSCR_DN() uint32 {
	return (volatile.LoadUint32(&o.FPDSCR.Reg) & 0x2000000) >> 25
}
func (o *SystemControl_Type) SetFPDSCR_AHP(value uint32) {
	volatile.StoreUint32(&o.FPDSCR.Reg, volatile.LoadUint32(&o.FPDSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *SystemControl_Type) GetFPDSCR_AHP() uint32 {
	return (volatile.LoadUint32(&o.FPDSCR.Reg) & 0x4000000) >> 26
}

// System timer
type SysTick_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// SysTick.CSR: SysTick Control and Status Register
func (o *SysTick_Type) SetCSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *SysTick_Type) GetCSR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *SysTick_Type) SetCSR_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *SysTick_Type) GetCSR_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *SysTick_Type) SetCSR_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *SysTick_Type) GetCSR_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *SysTick_Type) SetCSR_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000)|value<<16)
}
func (o *SysTick_Type) GetCSR_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000) >> 16
}

// SysTick.RVR: SysTick Reload Value Register
func (o *SysTick_Type) SetRVR_RELOAD(value uint32) {
	volatile.StoreUint32(&o.RVR.Reg, volatile.LoadUint32(&o.RVR.Reg)&^(0xffffff)|value)
}
func (o *SysTick_Type) GetRVR_RELOAD() uint32 {
	return volatile.LoadUint32(&o.RVR.Reg) & 0xffffff
}

// SysTick.CVR: SysTick Current Value Register
func (o *SysTick_Type) SetCVR_CURRENT(value uint32) {
	volatile.StoreUint32(&o.CVR.Reg, volatile.LoadUint32(&o.CVR.Reg)&^(0xffffff)|value)
}
func (o *SysTick_Type) GetCVR_CURRENT() uint32 {
	return volatile.LoadUint32(&o.CVR.Reg) & 0xffffff
}

// SysTick.CALIB: SysTick Calibration Value Register
func (o *SysTick_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *SysTick_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}
func (o *SysTick_Type) SetCALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *SysTick_Type) GetCALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x40000000) >> 30
}
func (o *SysTick_Type) SetCALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *SysTick_Type) GetCALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x80000000) >> 31
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	NVICISER0 volatile.Register32 // 0x0
	NVICISER1 volatile.Register32 // 0x4
	NVICISER2 volatile.Register32 // 0x8
	NVICISER3 volatile.Register32 // 0xC
	_         [112]byte
	NVICICER0 volatile.Register32 // 0x80
	NVICICER1 volatile.Register32 // 0x84
	NVICICER2 volatile.Register32 // 0x88
	NVICICER3 volatile.Register32 // 0x8C
	_         [112]byte
	NVICISPR0 volatile.Register32 // 0x100
	NVICISPR1 volatile.Register32 // 0x104
	NVICISPR2 volatile.Register32 // 0x108
	NVICISPR3 volatile.Register32 // 0x10C
	_         [112]byte
	NVICICPR0 volatile.Register32 // 0x180
	NVICICPR1 volatile.Register32 // 0x184
	NVICICPR2 volatile.Register32 // 0x188
	NVICICPR3 volatile.Register32 // 0x18C
	_         [112]byte
	NVICIABR0 volatile.Register32 // 0x200
	NVICIABR1 volatile.Register32 // 0x204
	NVICIABR2 volatile.Register32 // 0x208
	NVICIABR3 volatile.Register32 // 0x20C
	_         [240]byte
	NVICIP0   volatile.Register8 // 0x300
	NVICIP1   volatile.Register8 // 0x301
	NVICIP2   volatile.Register8 // 0x302
	NVICIP3   volatile.Register8 // 0x303
	NVICIP4   volatile.Register8 // 0x304
	NVICIP5   volatile.Register8 // 0x305
	NVICIP6   volatile.Register8 // 0x306
	NVICIP7   volatile.Register8 // 0x307
	NVICIP8   volatile.Register8 // 0x308
	NVICIP9   volatile.Register8 // 0x309
	NVICIP10  volatile.Register8 // 0x30A
	NVICIP11  volatile.Register8 // 0x30B
	NVICIP12  volatile.Register8 // 0x30C
	NVICIP13  volatile.Register8 // 0x30D
	NVICIP14  volatile.Register8 // 0x30E
	NVICIP15  volatile.Register8 // 0x30F
	NVICIP16  volatile.Register8 // 0x310
	NVICIP17  volatile.Register8 // 0x311
	NVICIP18  volatile.Register8 // 0x312
	NVICIP19  volatile.Register8 // 0x313
	NVICIP20  volatile.Register8 // 0x314
	NVICIP21  volatile.Register8 // 0x315
	NVICIP22  volatile.Register8 // 0x316
	NVICIP23  volatile.Register8 // 0x317
	NVICIP24  volatile.Register8 // 0x318
	NVICIP25  volatile.Register8 // 0x319
	NVICIP26  volatile.Register8 // 0x31A
	NVICIP27  volatile.Register8 // 0x31B
	NVICIP28  volatile.Register8 // 0x31C
	NVICIP29  volatile.Register8 // 0x31D
	NVICIP30  volatile.Register8 // 0x31E
	NVICIP31  volatile.Register8 // 0x31F
	NVICIP32  volatile.Register8 // 0x320
	NVICIP33  volatile.Register8 // 0x321
	NVICIP34  volatile.Register8 // 0x322
	NVICIP35  volatile.Register8 // 0x323
	NVICIP36  volatile.Register8 // 0x324
	NVICIP37  volatile.Register8 // 0x325
	NVICIP38  volatile.Register8 // 0x326
	NVICIP39  volatile.Register8 // 0x327
	NVICIP40  volatile.Register8 // 0x328
	NVICIP41  volatile.Register8 // 0x329
	NVICIP42  volatile.Register8 // 0x32A
	NVICIP43  volatile.Register8 // 0x32B
	NVICIP44  volatile.Register8 // 0x32C
	NVICIP45  volatile.Register8 // 0x32D
	NVICIP46  volatile.Register8 // 0x32E
	NVICIP47  volatile.Register8 // 0x32F
	NVICIP48  volatile.Register8 // 0x330
	NVICIP49  volatile.Register8 // 0x331
	NVICIP50  volatile.Register8 // 0x332
	NVICIP51  volatile.Register8 // 0x333
	NVICIP52  volatile.Register8 // 0x334
	NVICIP53  volatile.Register8 // 0x335
	NVICIP54  volatile.Register8 // 0x336
	NVICIP55  volatile.Register8 // 0x337
	NVICIP56  volatile.Register8 // 0x338
	NVICIP57  volatile.Register8 // 0x339
	NVICIP58  volatile.Register8 // 0x33A
	NVICIP59  volatile.Register8 // 0x33B
	NVICIP60  volatile.Register8 // 0x33C
	NVICIP61  volatile.Register8 // 0x33D
	NVICIP62  volatile.Register8 // 0x33E
	NVICIP63  volatile.Register8 // 0x33F
	NVICIP64  volatile.Register8 // 0x340
	NVICIP65  volatile.Register8 // 0x341
	NVICIP66  volatile.Register8 // 0x342
	NVICIP67  volatile.Register8 // 0x343
	NVICIP68  volatile.Register8 // 0x344
	NVICIP69  volatile.Register8 // 0x345
	NVICIP70  volatile.Register8 // 0x346
	NVICIP71  volatile.Register8 // 0x347
	NVICIP72  volatile.Register8 // 0x348
	NVICIP73  volatile.Register8 // 0x349
	NVICIP74  volatile.Register8 // 0x34A
	NVICIP75  volatile.Register8 // 0x34B
	NVICIP76  volatile.Register8 // 0x34C
	NVICIP77  volatile.Register8 // 0x34D
	NVICIP78  volatile.Register8 // 0x34E
	NVICIP79  volatile.Register8 // 0x34F
	NVICIP80  volatile.Register8 // 0x350
	NVICIP81  volatile.Register8 // 0x351
	NVICIP82  volatile.Register8 // 0x352
	NVICIP83  volatile.Register8 // 0x353
	NVICIP84  volatile.Register8 // 0x354
	NVICIP85  volatile.Register8 // 0x355
	NVICIP86  volatile.Register8 // 0x356
	NVICIP87  volatile.Register8 // 0x357
	NVICIP88  volatile.Register8 // 0x358
	NVICIP89  volatile.Register8 // 0x359
	NVICIP90  volatile.Register8 // 0x35A
	NVICIP91  volatile.Register8 // 0x35B
	NVICIP92  volatile.Register8 // 0x35C
	NVICIP93  volatile.Register8 // 0x35D
	NVICIP94  volatile.Register8 // 0x35E
	NVICIP95  volatile.Register8 // 0x35F
	NVICIP96  volatile.Register8 // 0x360
	NVICIP97  volatile.Register8 // 0x361
	NVICIP98  volatile.Register8 // 0x362
	NVICIP99  volatile.Register8 // 0x363
	NVICIP100 volatile.Register8 // 0x364
	NVICIP101 volatile.Register8 // 0x365
	NVICIP102 volatile.Register8 // 0x366
	NVICIP103 volatile.Register8 // 0x367
	NVICIP104 volatile.Register8 // 0x368
	NVICIP105 volatile.Register8 // 0x369
	_         [2710]byte
	NVICSTIR  volatile.Register32 // 0xE00
}

// NVIC.NVICISER0: Interrupt Set Enable Register n
func (o *NVIC_Type) SetNVICISER0(value uint32) {
	volatile.StoreUint32(&o.NVICISER0.Reg, value)
}
func (o *NVIC_Type) GetNVICISER0() uint32 {
	return volatile.LoadUint32(&o.NVICISER0.Reg)
}

// NVIC.NVICISER1: Interrupt Set Enable Register n
func (o *NVIC_Type) SetNVICISER1(value uint32) {
	volatile.StoreUint32(&o.NVICISER1.Reg, value)
}
func (o *NVIC_Type) GetNVICISER1() uint32 {
	return volatile.LoadUint32(&o.NVICISER1.Reg)
}

// NVIC.NVICISER2: Interrupt Set Enable Register n
func (o *NVIC_Type) SetNVICISER2(value uint32) {
	volatile.StoreUint32(&o.NVICISER2.Reg, value)
}
func (o *NVIC_Type) GetNVICISER2() uint32 {
	return volatile.LoadUint32(&o.NVICISER2.Reg)
}

// NVIC.NVICISER3: Interrupt Set Enable Register n
func (o *NVIC_Type) SetNVICISER3(value uint32) {
	volatile.StoreUint32(&o.NVICISER3.Reg, value)
}
func (o *NVIC_Type) GetNVICISER3() uint32 {
	return volatile.LoadUint32(&o.NVICISER3.Reg)
}

// NVIC.NVICICER0: Interrupt Clear Enable Register n
func (o *NVIC_Type) SetNVICICER0(value uint32) {
	volatile.StoreUint32(&o.NVICICER0.Reg, value)
}
func (o *NVIC_Type) GetNVICICER0() uint32 {
	return volatile.LoadUint32(&o.NVICICER0.Reg)
}

// NVIC.NVICICER1: Interrupt Clear Enable Register n
func (o *NVIC_Type) SetNVICICER1(value uint32) {
	volatile.StoreUint32(&o.NVICICER1.Reg, value)
}
func (o *NVIC_Type) GetNVICICER1() uint32 {
	return volatile.LoadUint32(&o.NVICICER1.Reg)
}

// NVIC.NVICICER2: Interrupt Clear Enable Register n
func (o *NVIC_Type) SetNVICICER2(value uint32) {
	volatile.StoreUint32(&o.NVICICER2.Reg, value)
}
func (o *NVIC_Type) GetNVICICER2() uint32 {
	return volatile.LoadUint32(&o.NVICICER2.Reg)
}

// NVIC.NVICICER3: Interrupt Clear Enable Register n
func (o *NVIC_Type) SetNVICICER3(value uint32) {
	volatile.StoreUint32(&o.NVICICER3.Reg, value)
}
func (o *NVIC_Type) GetNVICICER3() uint32 {
	return volatile.LoadUint32(&o.NVICICER3.Reg)
}

// NVIC.NVICISPR0: Interrupt Set Pending Register n
func (o *NVIC_Type) SetNVICISPR0(value uint32) {
	volatile.StoreUint32(&o.NVICISPR0.Reg, value)
}
func (o *NVIC_Type) GetNVICISPR0() uint32 {
	return volatile.LoadUint32(&o.NVICISPR0.Reg)
}

// NVIC.NVICISPR1: Interrupt Set Pending Register n
func (o *NVIC_Type) SetNVICISPR1(value uint32) {
	volatile.StoreUint32(&o.NVICISPR1.Reg, value)
}
func (o *NVIC_Type) GetNVICISPR1() uint32 {
	return volatile.LoadUint32(&o.NVICISPR1.Reg)
}

// NVIC.NVICISPR2: Interrupt Set Pending Register n
func (o *NVIC_Type) SetNVICISPR2(value uint32) {
	volatile.StoreUint32(&o.NVICISPR2.Reg, value)
}
func (o *NVIC_Type) GetNVICISPR2() uint32 {
	return volatile.LoadUint32(&o.NVICISPR2.Reg)
}

// NVIC.NVICISPR3: Interrupt Set Pending Register n
func (o *NVIC_Type) SetNVICISPR3(value uint32) {
	volatile.StoreUint32(&o.NVICISPR3.Reg, value)
}
func (o *NVIC_Type) GetNVICISPR3() uint32 {
	return volatile.LoadUint32(&o.NVICISPR3.Reg)
}

// NVIC.NVICICPR0: Interrupt Clear Pending Register n
func (o *NVIC_Type) SetNVICICPR0(value uint32) {
	volatile.StoreUint32(&o.NVICICPR0.Reg, value)
}
func (o *NVIC_Type) GetNVICICPR0() uint32 {
	return volatile.LoadUint32(&o.NVICICPR0.Reg)
}

// NVIC.NVICICPR1: Interrupt Clear Pending Register n
func (o *NVIC_Type) SetNVICICPR1(value uint32) {
	volatile.StoreUint32(&o.NVICICPR1.Reg, value)
}
func (o *NVIC_Type) GetNVICICPR1() uint32 {
	return volatile.LoadUint32(&o.NVICICPR1.Reg)
}

// NVIC.NVICICPR2: Interrupt Clear Pending Register n
func (o *NVIC_Type) SetNVICICPR2(value uint32) {
	volatile.StoreUint32(&o.NVICICPR2.Reg, value)
}
func (o *NVIC_Type) GetNVICICPR2() uint32 {
	return volatile.LoadUint32(&o.NVICICPR2.Reg)
}

// NVIC.NVICICPR3: Interrupt Clear Pending Register n
func (o *NVIC_Type) SetNVICICPR3(value uint32) {
	volatile.StoreUint32(&o.NVICICPR3.Reg, value)
}
func (o *NVIC_Type) GetNVICICPR3() uint32 {
	return volatile.LoadUint32(&o.NVICICPR3.Reg)
}

// NVIC.NVICIABR0: Interrupt Active bit Register n
func (o *NVIC_Type) SetNVICIABR0(value uint32) {
	volatile.StoreUint32(&o.NVICIABR0.Reg, value)
}
func (o *NVIC_Type) GetNVICIABR0() uint32 {
	return volatile.LoadUint32(&o.NVICIABR0.Reg)
}

// NVIC.NVICIABR1: Interrupt Active bit Register n
func (o *NVIC_Type) SetNVICIABR1(value uint32) {
	volatile.StoreUint32(&o.NVICIABR1.Reg, value)
}
func (o *NVIC_Type) GetNVICIABR1() uint32 {
	return volatile.LoadUint32(&o.NVICIABR1.Reg)
}

// NVIC.NVICIABR2: Interrupt Active bit Register n
func (o *NVIC_Type) SetNVICIABR2(value uint32) {
	volatile.StoreUint32(&o.NVICIABR2.Reg, value)
}
func (o *NVIC_Type) GetNVICIABR2() uint32 {
	return volatile.LoadUint32(&o.NVICIABR2.Reg)
}

// NVIC.NVICIABR3: Interrupt Active bit Register n
func (o *NVIC_Type) SetNVICIABR3(value uint32) {
	volatile.StoreUint32(&o.NVICIABR3.Reg, value)
}
func (o *NVIC_Type) GetNVICIABR3() uint32 {
	return volatile.LoadUint32(&o.NVICIABR3.Reg)
}

// NVIC.NVICIP0: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP0(value uint8) {
	volatile.StoreUint8(&o.NVICIP0.Reg, value)
}
func (o *NVIC_Type) GetNVICIP0() uint8 {
	return volatile.LoadUint8(&o.NVICIP0.Reg)
}

// NVIC.NVICIP1: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP1(value uint8) {
	volatile.StoreUint8(&o.NVICIP1.Reg, value)
}
func (o *NVIC_Type) GetNVICIP1() uint8 {
	return volatile.LoadUint8(&o.NVICIP1.Reg)
}

// NVIC.NVICIP2: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP2(value uint8) {
	volatile.StoreUint8(&o.NVICIP2.Reg, value)
}
func (o *NVIC_Type) GetNVICIP2() uint8 {
	return volatile.LoadUint8(&o.NVICIP2.Reg)
}

// NVIC.NVICIP3: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP3(value uint8) {
	volatile.StoreUint8(&o.NVICIP3.Reg, value)
}
func (o *NVIC_Type) GetNVICIP3() uint8 {
	return volatile.LoadUint8(&o.NVICIP3.Reg)
}

// NVIC.NVICIP4: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP4(value uint8) {
	volatile.StoreUint8(&o.NVICIP4.Reg, value)
}
func (o *NVIC_Type) GetNVICIP4() uint8 {
	return volatile.LoadUint8(&o.NVICIP4.Reg)
}

// NVIC.NVICIP5: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP5(value uint8) {
	volatile.StoreUint8(&o.NVICIP5.Reg, value)
}
func (o *NVIC_Type) GetNVICIP5() uint8 {
	return volatile.LoadUint8(&o.NVICIP5.Reg)
}

// NVIC.NVICIP6: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP6(value uint8) {
	volatile.StoreUint8(&o.NVICIP6.Reg, value)
}
func (o *NVIC_Type) GetNVICIP6() uint8 {
	return volatile.LoadUint8(&o.NVICIP6.Reg)
}

// NVIC.NVICIP7: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP7(value uint8) {
	volatile.StoreUint8(&o.NVICIP7.Reg, value)
}
func (o *NVIC_Type) GetNVICIP7() uint8 {
	return volatile.LoadUint8(&o.NVICIP7.Reg)
}

// NVIC.NVICIP8: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP8(value uint8) {
	volatile.StoreUint8(&o.NVICIP8.Reg, value)
}
func (o *NVIC_Type) GetNVICIP8() uint8 {
	return volatile.LoadUint8(&o.NVICIP8.Reg)
}

// NVIC.NVICIP9: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP9(value uint8) {
	volatile.StoreUint8(&o.NVICIP9.Reg, value)
}
func (o *NVIC_Type) GetNVICIP9() uint8 {
	return volatile.LoadUint8(&o.NVICIP9.Reg)
}

// NVIC.NVICIP10: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP10(value uint8) {
	volatile.StoreUint8(&o.NVICIP10.Reg, value)
}
func (o *NVIC_Type) GetNVICIP10() uint8 {
	return volatile.LoadUint8(&o.NVICIP10.Reg)
}

// NVIC.NVICIP11: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP11(value uint8) {
	volatile.StoreUint8(&o.NVICIP11.Reg, value)
}
func (o *NVIC_Type) GetNVICIP11() uint8 {
	return volatile.LoadUint8(&o.NVICIP11.Reg)
}

// NVIC.NVICIP12: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP12(value uint8) {
	volatile.StoreUint8(&o.NVICIP12.Reg, value)
}
func (o *NVIC_Type) GetNVICIP12() uint8 {
	return volatile.LoadUint8(&o.NVICIP12.Reg)
}

// NVIC.NVICIP13: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP13(value uint8) {
	volatile.StoreUint8(&o.NVICIP13.Reg, value)
}
func (o *NVIC_Type) GetNVICIP13() uint8 {
	return volatile.LoadUint8(&o.NVICIP13.Reg)
}

// NVIC.NVICIP14: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP14(value uint8) {
	volatile.StoreUint8(&o.NVICIP14.Reg, value)
}
func (o *NVIC_Type) GetNVICIP14() uint8 {
	return volatile.LoadUint8(&o.NVICIP14.Reg)
}

// NVIC.NVICIP15: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP15(value uint8) {
	volatile.StoreUint8(&o.NVICIP15.Reg, value)
}
func (o *NVIC_Type) GetNVICIP15() uint8 {
	return volatile.LoadUint8(&o.NVICIP15.Reg)
}

// NVIC.NVICIP16: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP16(value uint8) {
	volatile.StoreUint8(&o.NVICIP16.Reg, value)
}
func (o *NVIC_Type) GetNVICIP16() uint8 {
	return volatile.LoadUint8(&o.NVICIP16.Reg)
}

// NVIC.NVICIP17: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP17(value uint8) {
	volatile.StoreUint8(&o.NVICIP17.Reg, value)
}
func (o *NVIC_Type) GetNVICIP17() uint8 {
	return volatile.LoadUint8(&o.NVICIP17.Reg)
}

// NVIC.NVICIP18: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP18(value uint8) {
	volatile.StoreUint8(&o.NVICIP18.Reg, value)
}
func (o *NVIC_Type) GetNVICIP18() uint8 {
	return volatile.LoadUint8(&o.NVICIP18.Reg)
}

// NVIC.NVICIP19: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP19(value uint8) {
	volatile.StoreUint8(&o.NVICIP19.Reg, value)
}
func (o *NVIC_Type) GetNVICIP19() uint8 {
	return volatile.LoadUint8(&o.NVICIP19.Reg)
}

// NVIC.NVICIP20: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP20(value uint8) {
	volatile.StoreUint8(&o.NVICIP20.Reg, value)
}
func (o *NVIC_Type) GetNVICIP20() uint8 {
	return volatile.LoadUint8(&o.NVICIP20.Reg)
}

// NVIC.NVICIP21: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP21(value uint8) {
	volatile.StoreUint8(&o.NVICIP21.Reg, value)
}
func (o *NVIC_Type) GetNVICIP21() uint8 {
	return volatile.LoadUint8(&o.NVICIP21.Reg)
}

// NVIC.NVICIP22: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP22(value uint8) {
	volatile.StoreUint8(&o.NVICIP22.Reg, value)
}
func (o *NVIC_Type) GetNVICIP22() uint8 {
	return volatile.LoadUint8(&o.NVICIP22.Reg)
}

// NVIC.NVICIP23: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP23(value uint8) {
	volatile.StoreUint8(&o.NVICIP23.Reg, value)
}
func (o *NVIC_Type) GetNVICIP23() uint8 {
	return volatile.LoadUint8(&o.NVICIP23.Reg)
}

// NVIC.NVICIP24: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP24(value uint8) {
	volatile.StoreUint8(&o.NVICIP24.Reg, value)
}
func (o *NVIC_Type) GetNVICIP24() uint8 {
	return volatile.LoadUint8(&o.NVICIP24.Reg)
}

// NVIC.NVICIP25: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP25(value uint8) {
	volatile.StoreUint8(&o.NVICIP25.Reg, value)
}
func (o *NVIC_Type) GetNVICIP25() uint8 {
	return volatile.LoadUint8(&o.NVICIP25.Reg)
}

// NVIC.NVICIP26: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP26(value uint8) {
	volatile.StoreUint8(&o.NVICIP26.Reg, value)
}
func (o *NVIC_Type) GetNVICIP26() uint8 {
	return volatile.LoadUint8(&o.NVICIP26.Reg)
}

// NVIC.NVICIP27: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP27(value uint8) {
	volatile.StoreUint8(&o.NVICIP27.Reg, value)
}
func (o *NVIC_Type) GetNVICIP27() uint8 {
	return volatile.LoadUint8(&o.NVICIP27.Reg)
}

// NVIC.NVICIP28: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP28(value uint8) {
	volatile.StoreUint8(&o.NVICIP28.Reg, value)
}
func (o *NVIC_Type) GetNVICIP28() uint8 {
	return volatile.LoadUint8(&o.NVICIP28.Reg)
}

// NVIC.NVICIP29: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP29(value uint8) {
	volatile.StoreUint8(&o.NVICIP29.Reg, value)
}
func (o *NVIC_Type) GetNVICIP29() uint8 {
	return volatile.LoadUint8(&o.NVICIP29.Reg)
}

// NVIC.NVICIP30: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP30(value uint8) {
	volatile.StoreUint8(&o.NVICIP30.Reg, value)
}
func (o *NVIC_Type) GetNVICIP30() uint8 {
	return volatile.LoadUint8(&o.NVICIP30.Reg)
}

// NVIC.NVICIP31: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP31(value uint8) {
	volatile.StoreUint8(&o.NVICIP31.Reg, value)
}
func (o *NVIC_Type) GetNVICIP31() uint8 {
	return volatile.LoadUint8(&o.NVICIP31.Reg)
}

// NVIC.NVICIP32: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP32(value uint8) {
	volatile.StoreUint8(&o.NVICIP32.Reg, value)
}
func (o *NVIC_Type) GetNVICIP32() uint8 {
	return volatile.LoadUint8(&o.NVICIP32.Reg)
}

// NVIC.NVICIP33: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP33(value uint8) {
	volatile.StoreUint8(&o.NVICIP33.Reg, value)
}
func (o *NVIC_Type) GetNVICIP33() uint8 {
	return volatile.LoadUint8(&o.NVICIP33.Reg)
}

// NVIC.NVICIP34: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP34(value uint8) {
	volatile.StoreUint8(&o.NVICIP34.Reg, value)
}
func (o *NVIC_Type) GetNVICIP34() uint8 {
	return volatile.LoadUint8(&o.NVICIP34.Reg)
}

// NVIC.NVICIP35: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP35(value uint8) {
	volatile.StoreUint8(&o.NVICIP35.Reg, value)
}
func (o *NVIC_Type) GetNVICIP35() uint8 {
	return volatile.LoadUint8(&o.NVICIP35.Reg)
}

// NVIC.NVICIP36: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP36(value uint8) {
	volatile.StoreUint8(&o.NVICIP36.Reg, value)
}
func (o *NVIC_Type) GetNVICIP36() uint8 {
	return volatile.LoadUint8(&o.NVICIP36.Reg)
}

// NVIC.NVICIP37: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP37(value uint8) {
	volatile.StoreUint8(&o.NVICIP37.Reg, value)
}
func (o *NVIC_Type) GetNVICIP37() uint8 {
	return volatile.LoadUint8(&o.NVICIP37.Reg)
}

// NVIC.NVICIP38: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP38(value uint8) {
	volatile.StoreUint8(&o.NVICIP38.Reg, value)
}
func (o *NVIC_Type) GetNVICIP38() uint8 {
	return volatile.LoadUint8(&o.NVICIP38.Reg)
}

// NVIC.NVICIP39: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP39(value uint8) {
	volatile.StoreUint8(&o.NVICIP39.Reg, value)
}
func (o *NVIC_Type) GetNVICIP39() uint8 {
	return volatile.LoadUint8(&o.NVICIP39.Reg)
}

// NVIC.NVICIP40: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP40(value uint8) {
	volatile.StoreUint8(&o.NVICIP40.Reg, value)
}
func (o *NVIC_Type) GetNVICIP40() uint8 {
	return volatile.LoadUint8(&o.NVICIP40.Reg)
}

// NVIC.NVICIP41: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP41(value uint8) {
	volatile.StoreUint8(&o.NVICIP41.Reg, value)
}
func (o *NVIC_Type) GetNVICIP41() uint8 {
	return volatile.LoadUint8(&o.NVICIP41.Reg)
}

// NVIC.NVICIP42: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP42(value uint8) {
	volatile.StoreUint8(&o.NVICIP42.Reg, value)
}
func (o *NVIC_Type) GetNVICIP42() uint8 {
	return volatile.LoadUint8(&o.NVICIP42.Reg)
}

// NVIC.NVICIP43: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP43(value uint8) {
	volatile.StoreUint8(&o.NVICIP43.Reg, value)
}
func (o *NVIC_Type) GetNVICIP43() uint8 {
	return volatile.LoadUint8(&o.NVICIP43.Reg)
}

// NVIC.NVICIP44: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP44(value uint8) {
	volatile.StoreUint8(&o.NVICIP44.Reg, value)
}
func (o *NVIC_Type) GetNVICIP44() uint8 {
	return volatile.LoadUint8(&o.NVICIP44.Reg)
}

// NVIC.NVICIP45: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP45(value uint8) {
	volatile.StoreUint8(&o.NVICIP45.Reg, value)
}
func (o *NVIC_Type) GetNVICIP45() uint8 {
	return volatile.LoadUint8(&o.NVICIP45.Reg)
}

// NVIC.NVICIP46: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP46(value uint8) {
	volatile.StoreUint8(&o.NVICIP46.Reg, value)
}
func (o *NVIC_Type) GetNVICIP46() uint8 {
	return volatile.LoadUint8(&o.NVICIP46.Reg)
}

// NVIC.NVICIP47: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP47(value uint8) {
	volatile.StoreUint8(&o.NVICIP47.Reg, value)
}
func (o *NVIC_Type) GetNVICIP47() uint8 {
	return volatile.LoadUint8(&o.NVICIP47.Reg)
}

// NVIC.NVICIP48: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP48(value uint8) {
	volatile.StoreUint8(&o.NVICIP48.Reg, value)
}
func (o *NVIC_Type) GetNVICIP48() uint8 {
	return volatile.LoadUint8(&o.NVICIP48.Reg)
}

// NVIC.NVICIP49: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP49(value uint8) {
	volatile.StoreUint8(&o.NVICIP49.Reg, value)
}
func (o *NVIC_Type) GetNVICIP49() uint8 {
	return volatile.LoadUint8(&o.NVICIP49.Reg)
}

// NVIC.NVICIP50: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP50(value uint8) {
	volatile.StoreUint8(&o.NVICIP50.Reg, value)
}
func (o *NVIC_Type) GetNVICIP50() uint8 {
	return volatile.LoadUint8(&o.NVICIP50.Reg)
}

// NVIC.NVICIP51: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP51(value uint8) {
	volatile.StoreUint8(&o.NVICIP51.Reg, value)
}
func (o *NVIC_Type) GetNVICIP51() uint8 {
	return volatile.LoadUint8(&o.NVICIP51.Reg)
}

// NVIC.NVICIP52: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP52(value uint8) {
	volatile.StoreUint8(&o.NVICIP52.Reg, value)
}
func (o *NVIC_Type) GetNVICIP52() uint8 {
	return volatile.LoadUint8(&o.NVICIP52.Reg)
}

// NVIC.NVICIP53: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP53(value uint8) {
	volatile.StoreUint8(&o.NVICIP53.Reg, value)
}
func (o *NVIC_Type) GetNVICIP53() uint8 {
	return volatile.LoadUint8(&o.NVICIP53.Reg)
}

// NVIC.NVICIP54: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP54(value uint8) {
	volatile.StoreUint8(&o.NVICIP54.Reg, value)
}
func (o *NVIC_Type) GetNVICIP54() uint8 {
	return volatile.LoadUint8(&o.NVICIP54.Reg)
}

// NVIC.NVICIP55: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP55(value uint8) {
	volatile.StoreUint8(&o.NVICIP55.Reg, value)
}
func (o *NVIC_Type) GetNVICIP55() uint8 {
	return volatile.LoadUint8(&o.NVICIP55.Reg)
}

// NVIC.NVICIP56: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP56(value uint8) {
	volatile.StoreUint8(&o.NVICIP56.Reg, value)
}
func (o *NVIC_Type) GetNVICIP56() uint8 {
	return volatile.LoadUint8(&o.NVICIP56.Reg)
}

// NVIC.NVICIP57: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP57(value uint8) {
	volatile.StoreUint8(&o.NVICIP57.Reg, value)
}
func (o *NVIC_Type) GetNVICIP57() uint8 {
	return volatile.LoadUint8(&o.NVICIP57.Reg)
}

// NVIC.NVICIP58: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP58(value uint8) {
	volatile.StoreUint8(&o.NVICIP58.Reg, value)
}
func (o *NVIC_Type) GetNVICIP58() uint8 {
	return volatile.LoadUint8(&o.NVICIP58.Reg)
}

// NVIC.NVICIP59: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP59(value uint8) {
	volatile.StoreUint8(&o.NVICIP59.Reg, value)
}
func (o *NVIC_Type) GetNVICIP59() uint8 {
	return volatile.LoadUint8(&o.NVICIP59.Reg)
}

// NVIC.NVICIP60: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP60(value uint8) {
	volatile.StoreUint8(&o.NVICIP60.Reg, value)
}
func (o *NVIC_Type) GetNVICIP60() uint8 {
	return volatile.LoadUint8(&o.NVICIP60.Reg)
}

// NVIC.NVICIP61: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP61(value uint8) {
	volatile.StoreUint8(&o.NVICIP61.Reg, value)
}
func (o *NVIC_Type) GetNVICIP61() uint8 {
	return volatile.LoadUint8(&o.NVICIP61.Reg)
}

// NVIC.NVICIP62: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP62(value uint8) {
	volatile.StoreUint8(&o.NVICIP62.Reg, value)
}
func (o *NVIC_Type) GetNVICIP62() uint8 {
	return volatile.LoadUint8(&o.NVICIP62.Reg)
}

// NVIC.NVICIP63: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP63(value uint8) {
	volatile.StoreUint8(&o.NVICIP63.Reg, value)
}
func (o *NVIC_Type) GetNVICIP63() uint8 {
	return volatile.LoadUint8(&o.NVICIP63.Reg)
}

// NVIC.NVICIP64: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP64(value uint8) {
	volatile.StoreUint8(&o.NVICIP64.Reg, value)
}
func (o *NVIC_Type) GetNVICIP64() uint8 {
	return volatile.LoadUint8(&o.NVICIP64.Reg)
}

// NVIC.NVICIP65: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP65(value uint8) {
	volatile.StoreUint8(&o.NVICIP65.Reg, value)
}
func (o *NVIC_Type) GetNVICIP65() uint8 {
	return volatile.LoadUint8(&o.NVICIP65.Reg)
}

// NVIC.NVICIP66: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP66(value uint8) {
	volatile.StoreUint8(&o.NVICIP66.Reg, value)
}
func (o *NVIC_Type) GetNVICIP66() uint8 {
	return volatile.LoadUint8(&o.NVICIP66.Reg)
}

// NVIC.NVICIP67: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP67(value uint8) {
	volatile.StoreUint8(&o.NVICIP67.Reg, value)
}
func (o *NVIC_Type) GetNVICIP67() uint8 {
	return volatile.LoadUint8(&o.NVICIP67.Reg)
}

// NVIC.NVICIP68: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP68(value uint8) {
	volatile.StoreUint8(&o.NVICIP68.Reg, value)
}
func (o *NVIC_Type) GetNVICIP68() uint8 {
	return volatile.LoadUint8(&o.NVICIP68.Reg)
}

// NVIC.NVICIP69: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP69(value uint8) {
	volatile.StoreUint8(&o.NVICIP69.Reg, value)
}
func (o *NVIC_Type) GetNVICIP69() uint8 {
	return volatile.LoadUint8(&o.NVICIP69.Reg)
}

// NVIC.NVICIP70: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP70(value uint8) {
	volatile.StoreUint8(&o.NVICIP70.Reg, value)
}
func (o *NVIC_Type) GetNVICIP70() uint8 {
	return volatile.LoadUint8(&o.NVICIP70.Reg)
}

// NVIC.NVICIP71: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP71(value uint8) {
	volatile.StoreUint8(&o.NVICIP71.Reg, value)
}
func (o *NVIC_Type) GetNVICIP71() uint8 {
	return volatile.LoadUint8(&o.NVICIP71.Reg)
}

// NVIC.NVICIP72: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP72(value uint8) {
	volatile.StoreUint8(&o.NVICIP72.Reg, value)
}
func (o *NVIC_Type) GetNVICIP72() uint8 {
	return volatile.LoadUint8(&o.NVICIP72.Reg)
}

// NVIC.NVICIP73: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP73(value uint8) {
	volatile.StoreUint8(&o.NVICIP73.Reg, value)
}
func (o *NVIC_Type) GetNVICIP73() uint8 {
	return volatile.LoadUint8(&o.NVICIP73.Reg)
}

// NVIC.NVICIP74: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP74(value uint8) {
	volatile.StoreUint8(&o.NVICIP74.Reg, value)
}
func (o *NVIC_Type) GetNVICIP74() uint8 {
	return volatile.LoadUint8(&o.NVICIP74.Reg)
}

// NVIC.NVICIP75: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP75(value uint8) {
	volatile.StoreUint8(&o.NVICIP75.Reg, value)
}
func (o *NVIC_Type) GetNVICIP75() uint8 {
	return volatile.LoadUint8(&o.NVICIP75.Reg)
}

// NVIC.NVICIP76: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP76(value uint8) {
	volatile.StoreUint8(&o.NVICIP76.Reg, value)
}
func (o *NVIC_Type) GetNVICIP76() uint8 {
	return volatile.LoadUint8(&o.NVICIP76.Reg)
}

// NVIC.NVICIP77: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP77(value uint8) {
	volatile.StoreUint8(&o.NVICIP77.Reg, value)
}
func (o *NVIC_Type) GetNVICIP77() uint8 {
	return volatile.LoadUint8(&o.NVICIP77.Reg)
}

// NVIC.NVICIP78: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP78(value uint8) {
	volatile.StoreUint8(&o.NVICIP78.Reg, value)
}
func (o *NVIC_Type) GetNVICIP78() uint8 {
	return volatile.LoadUint8(&o.NVICIP78.Reg)
}

// NVIC.NVICIP79: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP79(value uint8) {
	volatile.StoreUint8(&o.NVICIP79.Reg, value)
}
func (o *NVIC_Type) GetNVICIP79() uint8 {
	return volatile.LoadUint8(&o.NVICIP79.Reg)
}

// NVIC.NVICIP80: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP80(value uint8) {
	volatile.StoreUint8(&o.NVICIP80.Reg, value)
}
func (o *NVIC_Type) GetNVICIP80() uint8 {
	return volatile.LoadUint8(&o.NVICIP80.Reg)
}

// NVIC.NVICIP81: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP81(value uint8) {
	volatile.StoreUint8(&o.NVICIP81.Reg, value)
}
func (o *NVIC_Type) GetNVICIP81() uint8 {
	return volatile.LoadUint8(&o.NVICIP81.Reg)
}

// NVIC.NVICIP82: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP82(value uint8) {
	volatile.StoreUint8(&o.NVICIP82.Reg, value)
}
func (o *NVIC_Type) GetNVICIP82() uint8 {
	return volatile.LoadUint8(&o.NVICIP82.Reg)
}

// NVIC.NVICIP83: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP83(value uint8) {
	volatile.StoreUint8(&o.NVICIP83.Reg, value)
}
func (o *NVIC_Type) GetNVICIP83() uint8 {
	return volatile.LoadUint8(&o.NVICIP83.Reg)
}

// NVIC.NVICIP84: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP84(value uint8) {
	volatile.StoreUint8(&o.NVICIP84.Reg, value)
}
func (o *NVIC_Type) GetNVICIP84() uint8 {
	return volatile.LoadUint8(&o.NVICIP84.Reg)
}

// NVIC.NVICIP85: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP85(value uint8) {
	volatile.StoreUint8(&o.NVICIP85.Reg, value)
}
func (o *NVIC_Type) GetNVICIP85() uint8 {
	return volatile.LoadUint8(&o.NVICIP85.Reg)
}

// NVIC.NVICIP86: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP86(value uint8) {
	volatile.StoreUint8(&o.NVICIP86.Reg, value)
}
func (o *NVIC_Type) GetNVICIP86() uint8 {
	return volatile.LoadUint8(&o.NVICIP86.Reg)
}

// NVIC.NVICIP87: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP87(value uint8) {
	volatile.StoreUint8(&o.NVICIP87.Reg, value)
}
func (o *NVIC_Type) GetNVICIP87() uint8 {
	return volatile.LoadUint8(&o.NVICIP87.Reg)
}

// NVIC.NVICIP88: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP88(value uint8) {
	volatile.StoreUint8(&o.NVICIP88.Reg, value)
}
func (o *NVIC_Type) GetNVICIP88() uint8 {
	return volatile.LoadUint8(&o.NVICIP88.Reg)
}

// NVIC.NVICIP89: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP89(value uint8) {
	volatile.StoreUint8(&o.NVICIP89.Reg, value)
}
func (o *NVIC_Type) GetNVICIP89() uint8 {
	return volatile.LoadUint8(&o.NVICIP89.Reg)
}

// NVIC.NVICIP90: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP90(value uint8) {
	volatile.StoreUint8(&o.NVICIP90.Reg, value)
}
func (o *NVIC_Type) GetNVICIP90() uint8 {
	return volatile.LoadUint8(&o.NVICIP90.Reg)
}

// NVIC.NVICIP91: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP91(value uint8) {
	volatile.StoreUint8(&o.NVICIP91.Reg, value)
}
func (o *NVIC_Type) GetNVICIP91() uint8 {
	return volatile.LoadUint8(&o.NVICIP91.Reg)
}

// NVIC.NVICIP92: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP92(value uint8) {
	volatile.StoreUint8(&o.NVICIP92.Reg, value)
}
func (o *NVIC_Type) GetNVICIP92() uint8 {
	return volatile.LoadUint8(&o.NVICIP92.Reg)
}

// NVIC.NVICIP93: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP93(value uint8) {
	volatile.StoreUint8(&o.NVICIP93.Reg, value)
}
func (o *NVIC_Type) GetNVICIP93() uint8 {
	return volatile.LoadUint8(&o.NVICIP93.Reg)
}

// NVIC.NVICIP94: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP94(value uint8) {
	volatile.StoreUint8(&o.NVICIP94.Reg, value)
}
func (o *NVIC_Type) GetNVICIP94() uint8 {
	return volatile.LoadUint8(&o.NVICIP94.Reg)
}

// NVIC.NVICIP95: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP95(value uint8) {
	volatile.StoreUint8(&o.NVICIP95.Reg, value)
}
func (o *NVIC_Type) GetNVICIP95() uint8 {
	return volatile.LoadUint8(&o.NVICIP95.Reg)
}

// NVIC.NVICIP96: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP96(value uint8) {
	volatile.StoreUint8(&o.NVICIP96.Reg, value)
}
func (o *NVIC_Type) GetNVICIP96() uint8 {
	return volatile.LoadUint8(&o.NVICIP96.Reg)
}

// NVIC.NVICIP97: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP97(value uint8) {
	volatile.StoreUint8(&o.NVICIP97.Reg, value)
}
func (o *NVIC_Type) GetNVICIP97() uint8 {
	return volatile.LoadUint8(&o.NVICIP97.Reg)
}

// NVIC.NVICIP98: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP98(value uint8) {
	volatile.StoreUint8(&o.NVICIP98.Reg, value)
}
func (o *NVIC_Type) GetNVICIP98() uint8 {
	return volatile.LoadUint8(&o.NVICIP98.Reg)
}

// NVIC.NVICIP99: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP99(value uint8) {
	volatile.StoreUint8(&o.NVICIP99.Reg, value)
}
func (o *NVIC_Type) GetNVICIP99() uint8 {
	return volatile.LoadUint8(&o.NVICIP99.Reg)
}

// NVIC.NVICIP100: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP100(value uint8) {
	volatile.StoreUint8(&o.NVICIP100.Reg, value)
}
func (o *NVIC_Type) GetNVICIP100() uint8 {
	return volatile.LoadUint8(&o.NVICIP100.Reg)
}

// NVIC.NVICIP101: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP101(value uint8) {
	volatile.StoreUint8(&o.NVICIP101.Reg, value)
}
func (o *NVIC_Type) GetNVICIP101() uint8 {
	return volatile.LoadUint8(&o.NVICIP101.Reg)
}

// NVIC.NVICIP102: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP102(value uint8) {
	volatile.StoreUint8(&o.NVICIP102.Reg, value)
}
func (o *NVIC_Type) GetNVICIP102() uint8 {
	return volatile.LoadUint8(&o.NVICIP102.Reg)
}

// NVIC.NVICIP103: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP103(value uint8) {
	volatile.StoreUint8(&o.NVICIP103.Reg, value)
}
func (o *NVIC_Type) GetNVICIP103() uint8 {
	return volatile.LoadUint8(&o.NVICIP103.Reg)
}

// NVIC.NVICIP104: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP104(value uint8) {
	volatile.StoreUint8(&o.NVICIP104.Reg, value)
}
func (o *NVIC_Type) GetNVICIP104() uint8 {
	return volatile.LoadUint8(&o.NVICIP104.Reg)
}

// NVIC.NVICIP105: Interrupt Priority Register n
func (o *NVIC_Type) SetNVICIP105(value uint8) {
	volatile.StoreUint8(&o.NVICIP105.Reg, value)
}
func (o *NVIC_Type) GetNVICIP105() uint8 {
	return volatile.LoadUint8(&o.NVICIP105.Reg)
}

// NVIC.NVICSTIR: Software Trigger Interrupt Register
func (o *NVIC_Type) SetNVICSTIR_INTID(value uint32) {
	volatile.StoreUint32(&o.NVICSTIR.Reg, volatile.LoadUint32(&o.NVICSTIR.Reg)&^(0x1ff)|value)
}
func (o *NVIC_Type) GetNVICSTIR_INTID() uint32 {
	return volatile.LoadUint32(&o.NVICSTIR.Reg) & 0x1ff
}

// Core Platform Miscellaneous Control Module
type MCM_Type struct {
	_     [8]byte
	PLASC volatile.Register16 // 0x8
	PLAMC volatile.Register16 // 0xA
	PLACR volatile.Register32 // 0xC
	ISCR  volatile.Register32 // 0x10
	_     [44]byte
	CPO   volatile.Register32 // 0x40
}

// MCM.PLASC: Crossbar Switch (AXBS) Slave Configuration
func (o *MCM_Type) SetPLASC_ASC(value uint16) {
	volatile.StoreUint16(&o.PLASC.Reg, volatile.LoadUint16(&o.PLASC.Reg)&^(0xff)|value)
}
func (o *MCM_Type) GetPLASC_ASC() uint16 {
	return volatile.LoadUint16(&o.PLASC.Reg) & 0xff
}

// MCM.PLAMC: Crossbar Switch (AXBS) Master Configuration
func (o *MCM_Type) SetPLAMC_AMC(value uint16) {
	volatile.StoreUint16(&o.PLAMC.Reg, volatile.LoadUint16(&o.PLAMC.Reg)&^(0xff)|value)
}
func (o *MCM_Type) GetPLAMC_AMC() uint16 {
	return volatile.LoadUint16(&o.PLAMC.Reg) & 0xff
}

// MCM.PLACR: Crossbar Switch (AXBS) Control Register
func (o *MCM_Type) SetPLACR_ARB(value uint32) {
	volatile.StoreUint32(&o.PLACR.Reg, volatile.LoadUint32(&o.PLACR.Reg)&^(0x200)|value<<9)
}
func (o *MCM_Type) GetPLACR_ARB() uint32 {
	return (volatile.LoadUint32(&o.PLACR.Reg) & 0x200) >> 9
}

// MCM.ISCR: Interrupt Status and Control Register
func (o *MCM_Type) SetISCR_FIOC(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x100)|value<<8)
}
func (o *MCM_Type) GetISCR_FIOC() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x100) >> 8
}
func (o *MCM_Type) SetISCR_FDZC(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x200)|value<<9)
}
func (o *MCM_Type) GetISCR_FDZC() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x200) >> 9
}
func (o *MCM_Type) SetISCR_FOFC(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x400)|value<<10)
}
func (o *MCM_Type) GetISCR_FOFC() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x400) >> 10
}
func (o *MCM_Type) SetISCR_FUFC(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x800)|value<<11)
}
func (o *MCM_Type) GetISCR_FUFC() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x800) >> 11
}
func (o *MCM_Type) SetISCR_FIXC(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1000)|value<<12)
}
func (o *MCM_Type) GetISCR_FIXC() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x1000) >> 12
}
func (o *MCM_Type) SetISCR_FIDC(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8000)|value<<15)
}
func (o *MCM_Type) GetISCR_FIDC() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8000) >> 15
}
func (o *MCM_Type) SetISCR_FIOCE(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1000000)|value<<24)
}
func (o *MCM_Type) GetISCR_FIOCE() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x1000000) >> 24
}
func (o *MCM_Type) SetISCR_FDZCE(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2000000)|value<<25)
}
func (o *MCM_Type) GetISCR_FDZCE() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2000000) >> 25
}
func (o *MCM_Type) SetISCR_FOFCE(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4000000)|value<<26)
}
func (o *MCM_Type) GetISCR_FOFCE() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4000000) >> 26
}
func (o *MCM_Type) SetISCR_FUFCE(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8000000)|value<<27)
}
func (o *MCM_Type) GetISCR_FUFCE() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8000000) >> 27
}
func (o *MCM_Type) SetISCR_FIXCE(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10000000)|value<<28)
}
func (o *MCM_Type) GetISCR_FIXCE() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10000000) >> 28
}
func (o *MCM_Type) SetISCR_FIDCE(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80000000)|value<<31)
}
func (o *MCM_Type) GetISCR_FIDCE() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80000000) >> 31
}

// MCM.CPO: Compute Operation Control Register
func (o *MCM_Type) SetCPO_CPOREQ(value uint32) {
	volatile.StoreUint32(&o.CPO.Reg, volatile.LoadUint32(&o.CPO.Reg)&^(0x1)|value)
}
func (o *MCM_Type) GetCPO_CPOREQ() uint32 {
	return volatile.LoadUint32(&o.CPO.Reg) & 0x1
}
func (o *MCM_Type) SetCPO_CPOACK(value uint32) {
	volatile.StoreUint32(&o.CPO.Reg, volatile.LoadUint32(&o.CPO.Reg)&^(0x2)|value<<1)
}
func (o *MCM_Type) GetCPO_CPOACK() uint32 {
	return (volatile.LoadUint32(&o.CPO.Reg) & 0x2) >> 1
}
func (o *MCM_Type) SetCPO_CPOWOI(value uint32) {
	volatile.StoreUint32(&o.CPO.Reg, volatile.LoadUint32(&o.CPO.Reg)&^(0x4)|value<<2)
}
func (o *MCM_Type) GetCPO_CPOWOI() uint32 {
	return (volatile.LoadUint32(&o.CPO.Reg) & 0x4) >> 2
}

// Constants for FTFA_FlashConfig: Flash configuration field
const (
	// BACKKEY3: Backdoor Comparison Key 3.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY3_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY3_KEY_Msk = 0xff

	// BACKKEY2: Backdoor Comparison Key 2.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY2_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY2_KEY_Msk = 0xff

	// BACKKEY1: Backdoor Comparison Key 1.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY1_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY1_KEY_Msk = 0xff

	// BACKKEY0: Backdoor Comparison Key 0.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY0_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY0_KEY_Msk = 0xff

	// BACKKEY7: Backdoor Comparison Key 7.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY7_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY7_KEY_Msk = 0xff

	// BACKKEY6: Backdoor Comparison Key 6.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY6_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY6_KEY_Msk = 0xff

	// BACKKEY5: Backdoor Comparison Key 5.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY5_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY5_KEY_Msk = 0xff

	// BACKKEY4: Backdoor Comparison Key 4.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY4_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY4_KEY_Msk = 0xff

	// FPROT3: Non-volatile P-Flash Protection 1 - Low Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT3_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT3_PROT_Msk = 0xff

	// FPROT2: Non-volatile P-Flash Protection 1 - High Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT2_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT2_PROT_Msk = 0xff

	// FPROT1: Non-volatile P-Flash Protection 0 - Low Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT1_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT1_PROT_Msk = 0xff

	// FPROT0: Non-volatile P-Flash Protection 0 - High Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT0_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT0_PROT_Msk = 0xff

	// FSEC: Non-volatile Flash Security Register
	// Position of SEC field.
	FTFA_FlashConfig_FSEC_SEC_Pos = 0x0
	// Bit mask of SEC field.
	FTFA_FlashConfig_FSEC_SEC_Msk = 0x3
	// MCU security status is unsecure
	FTFA_FlashConfig_FSEC_SEC_10 = 0x2
	// MCU security status is secure
	FTFA_FlashConfig_FSEC_SEC_11 = 0x3
	// Position of FSLACC field.
	FTFA_FlashConfig_FSEC_FSLACC_Pos = 0x2
	// Bit mask of FSLACC field.
	FTFA_FlashConfig_FSEC_FSLACC_Msk = 0xc
	// Freescale factory access denied
	FTFA_FlashConfig_FSEC_FSLACC_10 = 0x2
	// Freescale factory access granted
	FTFA_FlashConfig_FSEC_FSLACC_11 = 0x3
	// Position of MEEN field.
	FTFA_FlashConfig_FSEC_MEEN_Pos = 0x4
	// Bit mask of MEEN field.
	FTFA_FlashConfig_FSEC_MEEN_Msk = 0x30
	// Mass erase is disabled
	FTFA_FlashConfig_FSEC_MEEN_10 = 0x2
	// Mass erase is enabled
	FTFA_FlashConfig_FSEC_MEEN_11 = 0x3
	// Position of KEYEN field.
	FTFA_FlashConfig_FSEC_KEYEN_Pos = 0x6
	// Bit mask of KEYEN field.
	FTFA_FlashConfig_FSEC_KEYEN_Msk = 0xc0
	// Backdoor key access enabled
	FTFA_FlashConfig_FSEC_KEYEN_10 = 0x2
	// Backdoor key access disabled
	FTFA_FlashConfig_FSEC_KEYEN_11 = 0x3

	// FOPT: Non-volatile Flash Option Register
	// Position of LPBOOT field.
	FTFA_FlashConfig_FOPT_LPBOOT_Pos = 0x0
	// Bit mask of LPBOOT field.
	FTFA_FlashConfig_FOPT_LPBOOT_Msk = 0x1
	// Bit LPBOOT.
	FTFA_FlashConfig_FOPT_LPBOOT = 0x1
	// Low-power boot
	FTFA_FlashConfig_FOPT_LPBOOT_00 = 0x0
	// Normal boot
	FTFA_FlashConfig_FOPT_LPBOOT_01 = 0x1
	// Position of EZPORT_DIS field.
	FTFA_FlashConfig_FOPT_EZPORT_DIS_Pos = 0x1
	// Bit mask of EZPORT_DIS field.
	FTFA_FlashConfig_FOPT_EZPORT_DIS_Msk = 0x2
	// Bit EZPORT_DIS.
	FTFA_FlashConfig_FOPT_EZPORT_DIS = 0x2
	// EzPort operation is disabled
	FTFA_FlashConfig_FOPT_EZPORT_DIS_00 = 0x0
	// EzPort operation is enabled
	FTFA_FlashConfig_FOPT_EZPORT_DIS_01 = 0x1
	// Position of NMI_DIS field.
	FTFA_FlashConfig_FOPT_NMI_DIS_Pos = 0x2
	// Bit mask of NMI_DIS field.
	FTFA_FlashConfig_FOPT_NMI_DIS_Msk = 0x4
	// Bit NMI_DIS.
	FTFA_FlashConfig_FOPT_NMI_DIS = 0x4
	// NMI interrupts are always blocked
	FTFA_FlashConfig_FOPT_NMI_DIS_00 = 0x0
	// NMI_b pin/interrupts reset default to enabled
	FTFA_FlashConfig_FOPT_NMI_DIS_01 = 0x1
	// Position of FAST_INIT field.
	FTFA_FlashConfig_FOPT_FAST_INIT_Pos = 0x5
	// Bit mask of FAST_INIT field.
	FTFA_FlashConfig_FOPT_FAST_INIT_Msk = 0x20
	// Bit FAST_INIT.
	FTFA_FlashConfig_FOPT_FAST_INIT = 0x20
	// Slower initialization
	FTFA_FlashConfig_FOPT_FAST_INIT_00 = 0x0
	// Fast Initialization
	FTFA_FlashConfig_FOPT_FAST_INIT_01 = 0x1
)

// Constants for DMA: Enhanced direct memory access controller
const (
	// CR: Control Register
	// Position of EDBG field.
	DMA_CR_EDBG_Pos = 0x1
	// Bit mask of EDBG field.
	DMA_CR_EDBG_Msk = 0x2
	// Bit EDBG.
	DMA_CR_EDBG = 0x2
	// When in debug mode, the DMA continues to operate.
	DMA_CR_EDBG_0 = 0x0
	// When in debug mode, the DMA stalls the start of a new channel. Executing channels are allowed to complete. Channel execution resumes when the system exits debug mode or the EDBG bit is cleared.
	DMA_CR_EDBG_1 = 0x1
	// Position of ERCA field.
	DMA_CR_ERCA_Pos = 0x2
	// Bit mask of ERCA field.
	DMA_CR_ERCA_Msk = 0x4
	// Bit ERCA.
	DMA_CR_ERCA = 0x4
	// Fixed priority arbitration is used for channel selection .
	DMA_CR_ERCA_0 = 0x0
	// Round robin arbitration is used for channel selection .
	DMA_CR_ERCA_1 = 0x1
	// Position of HOE field.
	DMA_CR_HOE_Pos = 0x4
	// Bit mask of HOE field.
	DMA_CR_HOE_Msk = 0x10
	// Bit HOE.
	DMA_CR_HOE = 0x10
	// Normal operation
	DMA_CR_HOE_0 = 0x0
	// Any error causes the HALT bit to set. Subsequently, all service requests are ignored until the HALT bit is cleared.
	DMA_CR_HOE_1 = 0x1
	// Position of HALT field.
	DMA_CR_HALT_Pos = 0x5
	// Bit mask of HALT field.
	DMA_CR_HALT_Msk = 0x20
	// Bit HALT.
	DMA_CR_HALT = 0x20
	// Normal operation
	DMA_CR_HALT_0 = 0x0
	// Stall the start of any new channels. Executing channels are allowed to complete. Channel execution resumes when this bit is cleared.
	DMA_CR_HALT_1 = 0x1
	// Position of CLM field.
	DMA_CR_CLM_Pos = 0x6
	// Bit mask of CLM field.
	DMA_CR_CLM_Msk = 0x40
	// Bit CLM.
	DMA_CR_CLM = 0x40
	// A minor loop channel link made to itself goes through channel arbitration before being activated again.
	DMA_CR_CLM_0 = 0x0
	// A minor loop channel link made to itself does not go through channel arbitration before being activated again. Upon minor loop completion, the channel activates again if that channel has a minor loop channel link enabled and the link channel is itself. This effectively applies the minor loop offsets and restarts the next minor loop.
	DMA_CR_CLM_1 = 0x1
	// Position of EMLM field.
	DMA_CR_EMLM_Pos = 0x7
	// Bit mask of EMLM field.
	DMA_CR_EMLM_Msk = 0x80
	// Bit EMLM.
	DMA_CR_EMLM = 0x80
	// Disabled. TCDn.word2 is defined as a 32-bit NBYTES field.
	DMA_CR_EMLM_0 = 0x0
	// Enabled. TCDn.word2 is redefined to include individual enable fields, an offset field, and the NBYTES field. The individual enable fields allow the minor loop offset to be applied to the source address, the destination address, or both. The NBYTES field is reduced when either offset is enabled.
	DMA_CR_EMLM_1 = 0x1
	// Position of ECX field.
	DMA_CR_ECX_Pos = 0x10
	// Bit mask of ECX field.
	DMA_CR_ECX_Msk = 0x10000
	// Bit ECX.
	DMA_CR_ECX = 0x10000
	// Normal operation
	DMA_CR_ECX_0 = 0x0
	// Cancel the remaining data transfer in the same fashion as the CX bit. Stop the executing channel and force the minor loop to finish. The cancel takes effect after the last write of the current read/write sequence. The ECX bit clears itself after the cancel is honored. In addition to cancelling the transfer, ECX treats the cancel as an error condition, thus updating the Error Status register (DMAx_ES) and generating an optional error interrupt.
	DMA_CR_ECX_1 = 0x1
	// Position of CX field.
	DMA_CR_CX_Pos = 0x11
	// Bit mask of CX field.
	DMA_CR_CX_Msk = 0x20000
	// Bit CX.
	DMA_CR_CX = 0x20000
	// Normal operation
	DMA_CR_CX_0 = 0x0
	// Cancel the remaining data transfer. Stop the executing channel and force the minor loop to finish. The cancel takes effect after the last write of the current read/write sequence. The CX bit clears itself after the cancel has been honored. This cancel retires the channel normally as if the minor loop was completed.
	DMA_CR_CX_1 = 0x1

	// ES: Error Status Register
	// Position of DBE field.
	DMA_ES_DBE_Pos = 0x0
	// Bit mask of DBE field.
	DMA_ES_DBE_Msk = 0x1
	// Bit DBE.
	DMA_ES_DBE = 0x1
	// No destination bus error
	DMA_ES_DBE_0 = 0x0
	// The last recorded error was a bus error on a destination write
	DMA_ES_DBE_1 = 0x1
	// Position of SBE field.
	DMA_ES_SBE_Pos = 0x1
	// Bit mask of SBE field.
	DMA_ES_SBE_Msk = 0x2
	// Bit SBE.
	DMA_ES_SBE = 0x2
	// No source bus error
	DMA_ES_SBE_0 = 0x0
	// The last recorded error was a bus error on a source read
	DMA_ES_SBE_1 = 0x1
	// Position of SGE field.
	DMA_ES_SGE_Pos = 0x2
	// Bit mask of SGE field.
	DMA_ES_SGE_Msk = 0x4
	// Bit SGE.
	DMA_ES_SGE = 0x4
	// No scatter/gather configuration error
	DMA_ES_SGE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_DLASTSGA field. This field is checked at the beginning of a scatter/gather operation after major loop completion if TCDn_CSR[ESG] is enabled. TCDn_DLASTSGA is not on a 32 byte boundary.
	DMA_ES_SGE_1 = 0x1
	// Position of NCE field.
	DMA_ES_NCE_Pos = 0x3
	// Bit mask of NCE field.
	DMA_ES_NCE_Msk = 0x8
	// Bit NCE.
	DMA_ES_NCE = 0x8
	// No NBYTES/CITER configuration error
	DMA_ES_NCE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_NBYTES or TCDn_CITER fields. TCDn_NBYTES is not a multiple of TCDn_ATTR[SSIZE] and TCDn_ATTR[DSIZE], or TCDn_CITER[CITER] is equal to zero, or TCDn_CITER[ELINK] is not equal to TCDn_BITER[ELINK]
	DMA_ES_NCE_1 = 0x1
	// Position of DOE field.
	DMA_ES_DOE_Pos = 0x4
	// Bit mask of DOE field.
	DMA_ES_DOE_Msk = 0x10
	// Bit DOE.
	DMA_ES_DOE = 0x10
	// No destination offset configuration error
	DMA_ES_DOE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_DOFF field. TCDn_DOFF is inconsistent with TCDn_ATTR[DSIZE].
	DMA_ES_DOE_1 = 0x1
	// Position of DAE field.
	DMA_ES_DAE_Pos = 0x5
	// Bit mask of DAE field.
	DMA_ES_DAE_Msk = 0x20
	// Bit DAE.
	DMA_ES_DAE = 0x20
	// No destination address configuration error
	DMA_ES_DAE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_DADDR field. TCDn_DADDR is inconsistent with TCDn_ATTR[DSIZE].
	DMA_ES_DAE_1 = 0x1
	// Position of SOE field.
	DMA_ES_SOE_Pos = 0x6
	// Bit mask of SOE field.
	DMA_ES_SOE_Msk = 0x40
	// Bit SOE.
	DMA_ES_SOE = 0x40
	// No source offset configuration error
	DMA_ES_SOE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_SOFF field. TCDn_SOFF is inconsistent with TCDn_ATTR[SSIZE].
	DMA_ES_SOE_1 = 0x1
	// Position of SAE field.
	DMA_ES_SAE_Pos = 0x7
	// Bit mask of SAE field.
	DMA_ES_SAE_Msk = 0x80
	// Bit SAE.
	DMA_ES_SAE = 0x80
	// No source address configuration error.
	DMA_ES_SAE_0 = 0x0
	// The last recorded error was a configuration error detected in the TCDn_SADDR field. TCDn_SADDR is inconsistent with TCDn_ATTR[SSIZE].
	DMA_ES_SAE_1 = 0x1
	// Position of ERRCHN field.
	DMA_ES_ERRCHN_Pos = 0x8
	// Bit mask of ERRCHN field.
	DMA_ES_ERRCHN_Msk = 0xf00
	// Position of CPE field.
	DMA_ES_CPE_Pos = 0xe
	// Bit mask of CPE field.
	DMA_ES_CPE_Msk = 0x4000
	// Bit CPE.
	DMA_ES_CPE = 0x4000
	// No channel priority error
	DMA_ES_CPE_0 = 0x0
	// The last recorded error was a configuration error in the channel priorities . Channel priorities are not unique.
	DMA_ES_CPE_1 = 0x1
	// Position of ECX field.
	DMA_ES_ECX_Pos = 0x10
	// Bit mask of ECX field.
	DMA_ES_ECX_Msk = 0x10000
	// Bit ECX.
	DMA_ES_ECX = 0x10000
	// No canceled transfers
	DMA_ES_ECX_0 = 0x0
	// The last recorded entry was a canceled transfer by the error cancel transfer input
	DMA_ES_ECX_1 = 0x1
	// Position of VLD field.
	DMA_ES_VLD_Pos = 0x1f
	// Bit mask of VLD field.
	DMA_ES_VLD_Msk = 0x80000000
	// Bit VLD.
	DMA_ES_VLD = 0x80000000
	// No ERR bits are set
	DMA_ES_VLD_0 = 0x0
	// At least one ERR bit is set indicating a valid error exists that has not been cleared
	DMA_ES_VLD_1 = 0x1

	// ERQ: Enable Request Register
	// Position of ERQ0 field.
	DMA_ERQ_ERQ0_Pos = 0x0
	// Bit mask of ERQ0 field.
	DMA_ERQ_ERQ0_Msk = 0x1
	// Bit ERQ0.
	DMA_ERQ_ERQ0 = 0x1
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ0_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ0_1 = 0x1
	// Position of ERQ1 field.
	DMA_ERQ_ERQ1_Pos = 0x1
	// Bit mask of ERQ1 field.
	DMA_ERQ_ERQ1_Msk = 0x2
	// Bit ERQ1.
	DMA_ERQ_ERQ1 = 0x2
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ1_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ1_1 = 0x1
	// Position of ERQ2 field.
	DMA_ERQ_ERQ2_Pos = 0x2
	// Bit mask of ERQ2 field.
	DMA_ERQ_ERQ2_Msk = 0x4
	// Bit ERQ2.
	DMA_ERQ_ERQ2 = 0x4
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ2_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ2_1 = 0x1
	// Position of ERQ3 field.
	DMA_ERQ_ERQ3_Pos = 0x3
	// Bit mask of ERQ3 field.
	DMA_ERQ_ERQ3_Msk = 0x8
	// Bit ERQ3.
	DMA_ERQ_ERQ3 = 0x8
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ3_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ3_1 = 0x1
	// Position of ERQ4 field.
	DMA_ERQ_ERQ4_Pos = 0x4
	// Bit mask of ERQ4 field.
	DMA_ERQ_ERQ4_Msk = 0x10
	// Bit ERQ4.
	DMA_ERQ_ERQ4 = 0x10
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ4_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ4_1 = 0x1
	// Position of ERQ5 field.
	DMA_ERQ_ERQ5_Pos = 0x5
	// Bit mask of ERQ5 field.
	DMA_ERQ_ERQ5_Msk = 0x20
	// Bit ERQ5.
	DMA_ERQ_ERQ5 = 0x20
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ5_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ5_1 = 0x1
	// Position of ERQ6 field.
	DMA_ERQ_ERQ6_Pos = 0x6
	// Bit mask of ERQ6 field.
	DMA_ERQ_ERQ6_Msk = 0x40
	// Bit ERQ6.
	DMA_ERQ_ERQ6 = 0x40
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ6_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ6_1 = 0x1
	// Position of ERQ7 field.
	DMA_ERQ_ERQ7_Pos = 0x7
	// Bit mask of ERQ7 field.
	DMA_ERQ_ERQ7_Msk = 0x80
	// Bit ERQ7.
	DMA_ERQ_ERQ7 = 0x80
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ7_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ7_1 = 0x1
	// Position of ERQ8 field.
	DMA_ERQ_ERQ8_Pos = 0x8
	// Bit mask of ERQ8 field.
	DMA_ERQ_ERQ8_Msk = 0x100
	// Bit ERQ8.
	DMA_ERQ_ERQ8 = 0x100
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ8_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ8_1 = 0x1
	// Position of ERQ9 field.
	DMA_ERQ_ERQ9_Pos = 0x9
	// Bit mask of ERQ9 field.
	DMA_ERQ_ERQ9_Msk = 0x200
	// Bit ERQ9.
	DMA_ERQ_ERQ9 = 0x200
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ9_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ9_1 = 0x1
	// Position of ERQ10 field.
	DMA_ERQ_ERQ10_Pos = 0xa
	// Bit mask of ERQ10 field.
	DMA_ERQ_ERQ10_Msk = 0x400
	// Bit ERQ10.
	DMA_ERQ_ERQ10 = 0x400
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ10_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ10_1 = 0x1
	// Position of ERQ11 field.
	DMA_ERQ_ERQ11_Pos = 0xb
	// Bit mask of ERQ11 field.
	DMA_ERQ_ERQ11_Msk = 0x800
	// Bit ERQ11.
	DMA_ERQ_ERQ11 = 0x800
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ11_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ11_1 = 0x1
	// Position of ERQ12 field.
	DMA_ERQ_ERQ12_Pos = 0xc
	// Bit mask of ERQ12 field.
	DMA_ERQ_ERQ12_Msk = 0x1000
	// Bit ERQ12.
	DMA_ERQ_ERQ12 = 0x1000
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ12_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ12_1 = 0x1
	// Position of ERQ13 field.
	DMA_ERQ_ERQ13_Pos = 0xd
	// Bit mask of ERQ13 field.
	DMA_ERQ_ERQ13_Msk = 0x2000
	// Bit ERQ13.
	DMA_ERQ_ERQ13 = 0x2000
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ13_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ13_1 = 0x1
	// Position of ERQ14 field.
	DMA_ERQ_ERQ14_Pos = 0xe
	// Bit mask of ERQ14 field.
	DMA_ERQ_ERQ14_Msk = 0x4000
	// Bit ERQ14.
	DMA_ERQ_ERQ14 = 0x4000
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ14_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ14_1 = 0x1
	// Position of ERQ15 field.
	DMA_ERQ_ERQ15_Pos = 0xf
	// Bit mask of ERQ15 field.
	DMA_ERQ_ERQ15_Msk = 0x8000
	// Bit ERQ15.
	DMA_ERQ_ERQ15 = 0x8000
	// The DMA request signal for the corresponding channel is disabled
	DMA_ERQ_ERQ15_0 = 0x0
	// The DMA request signal for the corresponding channel is enabled
	DMA_ERQ_ERQ15_1 = 0x1

	// EEI: Enable Error Interrupt Register
	// Position of EEI0 field.
	DMA_EEI_EEI0_Pos = 0x0
	// Bit mask of EEI0 field.
	DMA_EEI_EEI0_Msk = 0x1
	// Bit EEI0.
	DMA_EEI_EEI0 = 0x1
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI0_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI0_1 = 0x1
	// Position of EEI1 field.
	DMA_EEI_EEI1_Pos = 0x1
	// Bit mask of EEI1 field.
	DMA_EEI_EEI1_Msk = 0x2
	// Bit EEI1.
	DMA_EEI_EEI1 = 0x2
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI1_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI1_1 = 0x1
	// Position of EEI2 field.
	DMA_EEI_EEI2_Pos = 0x2
	// Bit mask of EEI2 field.
	DMA_EEI_EEI2_Msk = 0x4
	// Bit EEI2.
	DMA_EEI_EEI2 = 0x4
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI2_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI2_1 = 0x1
	// Position of EEI3 field.
	DMA_EEI_EEI3_Pos = 0x3
	// Bit mask of EEI3 field.
	DMA_EEI_EEI3_Msk = 0x8
	// Bit EEI3.
	DMA_EEI_EEI3 = 0x8
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI3_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI3_1 = 0x1
	// Position of EEI4 field.
	DMA_EEI_EEI4_Pos = 0x4
	// Bit mask of EEI4 field.
	DMA_EEI_EEI4_Msk = 0x10
	// Bit EEI4.
	DMA_EEI_EEI4 = 0x10
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI4_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI4_1 = 0x1
	// Position of EEI5 field.
	DMA_EEI_EEI5_Pos = 0x5
	// Bit mask of EEI5 field.
	DMA_EEI_EEI5_Msk = 0x20
	// Bit EEI5.
	DMA_EEI_EEI5 = 0x20
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI5_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI5_1 = 0x1
	// Position of EEI6 field.
	DMA_EEI_EEI6_Pos = 0x6
	// Bit mask of EEI6 field.
	DMA_EEI_EEI6_Msk = 0x40
	// Bit EEI6.
	DMA_EEI_EEI6 = 0x40
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI6_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI6_1 = 0x1
	// Position of EEI7 field.
	DMA_EEI_EEI7_Pos = 0x7
	// Bit mask of EEI7 field.
	DMA_EEI_EEI7_Msk = 0x80
	// Bit EEI7.
	DMA_EEI_EEI7 = 0x80
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI7_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI7_1 = 0x1
	// Position of EEI8 field.
	DMA_EEI_EEI8_Pos = 0x8
	// Bit mask of EEI8 field.
	DMA_EEI_EEI8_Msk = 0x100
	// Bit EEI8.
	DMA_EEI_EEI8 = 0x100
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI8_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI8_1 = 0x1
	// Position of EEI9 field.
	DMA_EEI_EEI9_Pos = 0x9
	// Bit mask of EEI9 field.
	DMA_EEI_EEI9_Msk = 0x200
	// Bit EEI9.
	DMA_EEI_EEI9 = 0x200
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI9_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI9_1 = 0x1
	// Position of EEI10 field.
	DMA_EEI_EEI10_Pos = 0xa
	// Bit mask of EEI10 field.
	DMA_EEI_EEI10_Msk = 0x400
	// Bit EEI10.
	DMA_EEI_EEI10 = 0x400
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI10_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI10_1 = 0x1
	// Position of EEI11 field.
	DMA_EEI_EEI11_Pos = 0xb
	// Bit mask of EEI11 field.
	DMA_EEI_EEI11_Msk = 0x800
	// Bit EEI11.
	DMA_EEI_EEI11 = 0x800
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI11_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI11_1 = 0x1
	// Position of EEI12 field.
	DMA_EEI_EEI12_Pos = 0xc
	// Bit mask of EEI12 field.
	DMA_EEI_EEI12_Msk = 0x1000
	// Bit EEI12.
	DMA_EEI_EEI12 = 0x1000
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI12_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI12_1 = 0x1
	// Position of EEI13 field.
	DMA_EEI_EEI13_Pos = 0xd
	// Bit mask of EEI13 field.
	DMA_EEI_EEI13_Msk = 0x2000
	// Bit EEI13.
	DMA_EEI_EEI13 = 0x2000
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI13_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI13_1 = 0x1
	// Position of EEI14 field.
	DMA_EEI_EEI14_Pos = 0xe
	// Bit mask of EEI14 field.
	DMA_EEI_EEI14_Msk = 0x4000
	// Bit EEI14.
	DMA_EEI_EEI14 = 0x4000
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI14_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI14_1 = 0x1
	// Position of EEI15 field.
	DMA_EEI_EEI15_Pos = 0xf
	// Bit mask of EEI15 field.
	DMA_EEI_EEI15_Msk = 0x8000
	// Bit EEI15.
	DMA_EEI_EEI15 = 0x8000
	// The error signal for corresponding channel does not generate an error interrupt
	DMA_EEI_EEI15_0 = 0x0
	// The assertion of the error signal for corresponding channel generates an error interrupt request
	DMA_EEI_EEI15_1 = 0x1

	// CEEI: Clear Enable Error Interrupt Register
	// Position of CEEI field.
	DMA_CEEI_CEEI_Pos = 0x0
	// Bit mask of CEEI field.
	DMA_CEEI_CEEI_Msk = 0xf
	// Position of CAEE field.
	DMA_CEEI_CAEE_Pos = 0x6
	// Bit mask of CAEE field.
	DMA_CEEI_CAEE_Msk = 0x40
	// Bit CAEE.
	DMA_CEEI_CAEE = 0x40
	// Clear only the EEI bit specified in the CEEI field
	DMA_CEEI_CAEE_0 = 0x0
	// Clear all bits in EEI
	DMA_CEEI_CAEE_1 = 0x1
	// Position of NOP field.
	DMA_CEEI_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_CEEI_NOP_Msk = 0x80
	// Bit NOP.
	DMA_CEEI_NOP = 0x80
	// Normal operation
	DMA_CEEI_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_CEEI_NOP_1 = 0x1

	// SEEI: Set Enable Error Interrupt Register
	// Position of SEEI field.
	DMA_SEEI_SEEI_Pos = 0x0
	// Bit mask of SEEI field.
	DMA_SEEI_SEEI_Msk = 0xf
	// Position of SAEE field.
	DMA_SEEI_SAEE_Pos = 0x6
	// Bit mask of SAEE field.
	DMA_SEEI_SAEE_Msk = 0x40
	// Bit SAEE.
	DMA_SEEI_SAEE = 0x40
	// Set only the EEI bit specified in the SEEI field.
	DMA_SEEI_SAEE_0 = 0x0
	// Sets all bits in EEI
	DMA_SEEI_SAEE_1 = 0x1
	// Position of NOP field.
	DMA_SEEI_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_SEEI_NOP_Msk = 0x80
	// Bit NOP.
	DMA_SEEI_NOP = 0x80
	// Normal operation
	DMA_SEEI_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_SEEI_NOP_1 = 0x1

	// CERQ: Clear Enable Request Register
	// Position of CERQ field.
	DMA_CERQ_CERQ_Pos = 0x0
	// Bit mask of CERQ field.
	DMA_CERQ_CERQ_Msk = 0xf
	// Position of CAER field.
	DMA_CERQ_CAER_Pos = 0x6
	// Bit mask of CAER field.
	DMA_CERQ_CAER_Msk = 0x40
	// Bit CAER.
	DMA_CERQ_CAER = 0x40
	// Clear only the ERQ bit specified in the CERQ field
	DMA_CERQ_CAER_0 = 0x0
	// Clear all bits in ERQ
	DMA_CERQ_CAER_1 = 0x1
	// Position of NOP field.
	DMA_CERQ_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_CERQ_NOP_Msk = 0x80
	// Bit NOP.
	DMA_CERQ_NOP = 0x80
	// Normal operation
	DMA_CERQ_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_CERQ_NOP_1 = 0x1

	// SERQ: Set Enable Request Register
	// Position of SERQ field.
	DMA_SERQ_SERQ_Pos = 0x0
	// Bit mask of SERQ field.
	DMA_SERQ_SERQ_Msk = 0xf
	// Position of SAER field.
	DMA_SERQ_SAER_Pos = 0x6
	// Bit mask of SAER field.
	DMA_SERQ_SAER_Msk = 0x40
	// Bit SAER.
	DMA_SERQ_SAER = 0x40
	// Set only the ERQ bit specified in the SERQ field
	DMA_SERQ_SAER_0 = 0x0
	// Set all bits in ERQ
	DMA_SERQ_SAER_1 = 0x1
	// Position of NOP field.
	DMA_SERQ_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_SERQ_NOP_Msk = 0x80
	// Bit NOP.
	DMA_SERQ_NOP = 0x80
	// Normal operation
	DMA_SERQ_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_SERQ_NOP_1 = 0x1

	// CDNE: Clear DONE Status Bit Register
	// Position of CDNE field.
	DMA_CDNE_CDNE_Pos = 0x0
	// Bit mask of CDNE field.
	DMA_CDNE_CDNE_Msk = 0xf
	// Position of CADN field.
	DMA_CDNE_CADN_Pos = 0x6
	// Bit mask of CADN field.
	DMA_CDNE_CADN_Msk = 0x40
	// Bit CADN.
	DMA_CDNE_CADN = 0x40
	// Clears only the TCDn_CSR[DONE] bit specified in the CDNE field
	DMA_CDNE_CADN_0 = 0x0
	// Clears all bits in TCDn_CSR[DONE]
	DMA_CDNE_CADN_1 = 0x1
	// Position of NOP field.
	DMA_CDNE_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_CDNE_NOP_Msk = 0x80
	// Bit NOP.
	DMA_CDNE_NOP = 0x80
	// Normal operation
	DMA_CDNE_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_CDNE_NOP_1 = 0x1

	// SSRT: Set START Bit Register
	// Position of SSRT field.
	DMA_SSRT_SSRT_Pos = 0x0
	// Bit mask of SSRT field.
	DMA_SSRT_SSRT_Msk = 0xf
	// Position of SAST field.
	DMA_SSRT_SAST_Pos = 0x6
	// Bit mask of SAST field.
	DMA_SSRT_SAST_Msk = 0x40
	// Bit SAST.
	DMA_SSRT_SAST = 0x40
	// Set only the TCDn_CSR[START] bit specified in the SSRT field
	DMA_SSRT_SAST_0 = 0x0
	// Set all bits in TCDn_CSR[START]
	DMA_SSRT_SAST_1 = 0x1
	// Position of NOP field.
	DMA_SSRT_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_SSRT_NOP_Msk = 0x80
	// Bit NOP.
	DMA_SSRT_NOP = 0x80
	// Normal operation
	DMA_SSRT_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_SSRT_NOP_1 = 0x1

	// CERR: Clear Error Register
	// Position of CERR field.
	DMA_CERR_CERR_Pos = 0x0
	// Bit mask of CERR field.
	DMA_CERR_CERR_Msk = 0xf
	// Position of CAEI field.
	DMA_CERR_CAEI_Pos = 0x6
	// Bit mask of CAEI field.
	DMA_CERR_CAEI_Msk = 0x40
	// Bit CAEI.
	DMA_CERR_CAEI = 0x40
	// Clear only the ERR bit specified in the CERR field
	DMA_CERR_CAEI_0 = 0x0
	// Clear all bits in ERR
	DMA_CERR_CAEI_1 = 0x1
	// Position of NOP field.
	DMA_CERR_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_CERR_NOP_Msk = 0x80
	// Bit NOP.
	DMA_CERR_NOP = 0x80
	// Normal operation
	DMA_CERR_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_CERR_NOP_1 = 0x1

	// CINT: Clear Interrupt Request Register
	// Position of CINT field.
	DMA_CINT_CINT_Pos = 0x0
	// Bit mask of CINT field.
	DMA_CINT_CINT_Msk = 0xf
	// Position of CAIR field.
	DMA_CINT_CAIR_Pos = 0x6
	// Bit mask of CAIR field.
	DMA_CINT_CAIR_Msk = 0x40
	// Bit CAIR.
	DMA_CINT_CAIR = 0x40
	// Clear only the INT bit specified in the CINT field
	DMA_CINT_CAIR_0 = 0x0
	// Clear all bits in INT
	DMA_CINT_CAIR_1 = 0x1
	// Position of NOP field.
	DMA_CINT_NOP_Pos = 0x7
	// Bit mask of NOP field.
	DMA_CINT_NOP_Msk = 0x80
	// Bit NOP.
	DMA_CINT_NOP = 0x80
	// Normal operation
	DMA_CINT_NOP_0 = 0x0
	// No operation, ignore the other bits in this register
	DMA_CINT_NOP_1 = 0x1

	// INT: Interrupt Request Register
	// Position of INT0 field.
	DMA_INT_INT0_Pos = 0x0
	// Bit mask of INT0 field.
	DMA_INT_INT0_Msk = 0x1
	// Bit INT0.
	DMA_INT_INT0 = 0x1
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT0_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT0_1 = 0x1
	// Position of INT1 field.
	DMA_INT_INT1_Pos = 0x1
	// Bit mask of INT1 field.
	DMA_INT_INT1_Msk = 0x2
	// Bit INT1.
	DMA_INT_INT1 = 0x2
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT1_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT1_1 = 0x1
	// Position of INT2 field.
	DMA_INT_INT2_Pos = 0x2
	// Bit mask of INT2 field.
	DMA_INT_INT2_Msk = 0x4
	// Bit INT2.
	DMA_INT_INT2 = 0x4
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT2_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT2_1 = 0x1
	// Position of INT3 field.
	DMA_INT_INT3_Pos = 0x3
	// Bit mask of INT3 field.
	DMA_INT_INT3_Msk = 0x8
	// Bit INT3.
	DMA_INT_INT3 = 0x8
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT3_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT3_1 = 0x1
	// Position of INT4 field.
	DMA_INT_INT4_Pos = 0x4
	// Bit mask of INT4 field.
	DMA_INT_INT4_Msk = 0x10
	// Bit INT4.
	DMA_INT_INT4 = 0x10
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT4_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT4_1 = 0x1
	// Position of INT5 field.
	DMA_INT_INT5_Pos = 0x5
	// Bit mask of INT5 field.
	DMA_INT_INT5_Msk = 0x20
	// Bit INT5.
	DMA_INT_INT5 = 0x20
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT5_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT5_1 = 0x1
	// Position of INT6 field.
	DMA_INT_INT6_Pos = 0x6
	// Bit mask of INT6 field.
	DMA_INT_INT6_Msk = 0x40
	// Bit INT6.
	DMA_INT_INT6 = 0x40
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT6_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT6_1 = 0x1
	// Position of INT7 field.
	DMA_INT_INT7_Pos = 0x7
	// Bit mask of INT7 field.
	DMA_INT_INT7_Msk = 0x80
	// Bit INT7.
	DMA_INT_INT7 = 0x80
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT7_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT7_1 = 0x1
	// Position of INT8 field.
	DMA_INT_INT8_Pos = 0x8
	// Bit mask of INT8 field.
	DMA_INT_INT8_Msk = 0x100
	// Bit INT8.
	DMA_INT_INT8 = 0x100
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT8_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT8_1 = 0x1
	// Position of INT9 field.
	DMA_INT_INT9_Pos = 0x9
	// Bit mask of INT9 field.
	DMA_INT_INT9_Msk = 0x200
	// Bit INT9.
	DMA_INT_INT9 = 0x200
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT9_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT9_1 = 0x1
	// Position of INT10 field.
	DMA_INT_INT10_Pos = 0xa
	// Bit mask of INT10 field.
	DMA_INT_INT10_Msk = 0x400
	// Bit INT10.
	DMA_INT_INT10 = 0x400
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT10_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT10_1 = 0x1
	// Position of INT11 field.
	DMA_INT_INT11_Pos = 0xb
	// Bit mask of INT11 field.
	DMA_INT_INT11_Msk = 0x800
	// Bit INT11.
	DMA_INT_INT11 = 0x800
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT11_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT11_1 = 0x1
	// Position of INT12 field.
	DMA_INT_INT12_Pos = 0xc
	// Bit mask of INT12 field.
	DMA_INT_INT12_Msk = 0x1000
	// Bit INT12.
	DMA_INT_INT12 = 0x1000
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT12_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT12_1 = 0x1
	// Position of INT13 field.
	DMA_INT_INT13_Pos = 0xd
	// Bit mask of INT13 field.
	DMA_INT_INT13_Msk = 0x2000
	// Bit INT13.
	DMA_INT_INT13 = 0x2000
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT13_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT13_1 = 0x1
	// Position of INT14 field.
	DMA_INT_INT14_Pos = 0xe
	// Bit mask of INT14 field.
	DMA_INT_INT14_Msk = 0x4000
	// Bit INT14.
	DMA_INT_INT14 = 0x4000
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT14_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT14_1 = 0x1
	// Position of INT15 field.
	DMA_INT_INT15_Pos = 0xf
	// Bit mask of INT15 field.
	DMA_INT_INT15_Msk = 0x8000
	// Bit INT15.
	DMA_INT_INT15 = 0x8000
	// The interrupt request for corresponding channel is cleared
	DMA_INT_INT15_0 = 0x0
	// The interrupt request for corresponding channel is active
	DMA_INT_INT15_1 = 0x1

	// ERR: Error Register
	// Position of ERR0 field.
	DMA_ERR_ERR0_Pos = 0x0
	// Bit mask of ERR0 field.
	DMA_ERR_ERR0_Msk = 0x1
	// Bit ERR0.
	DMA_ERR_ERR0 = 0x1
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR0_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR0_1 = 0x1
	// Position of ERR1 field.
	DMA_ERR_ERR1_Pos = 0x1
	// Bit mask of ERR1 field.
	DMA_ERR_ERR1_Msk = 0x2
	// Bit ERR1.
	DMA_ERR_ERR1 = 0x2
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR1_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR1_1 = 0x1
	// Position of ERR2 field.
	DMA_ERR_ERR2_Pos = 0x2
	// Bit mask of ERR2 field.
	DMA_ERR_ERR2_Msk = 0x4
	// Bit ERR2.
	DMA_ERR_ERR2 = 0x4
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR2_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR2_1 = 0x1
	// Position of ERR3 field.
	DMA_ERR_ERR3_Pos = 0x3
	// Bit mask of ERR3 field.
	DMA_ERR_ERR3_Msk = 0x8
	// Bit ERR3.
	DMA_ERR_ERR3 = 0x8
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR3_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR3_1 = 0x1
	// Position of ERR4 field.
	DMA_ERR_ERR4_Pos = 0x4
	// Bit mask of ERR4 field.
	DMA_ERR_ERR4_Msk = 0x10
	// Bit ERR4.
	DMA_ERR_ERR4 = 0x10
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR4_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR4_1 = 0x1
	// Position of ERR5 field.
	DMA_ERR_ERR5_Pos = 0x5
	// Bit mask of ERR5 field.
	DMA_ERR_ERR5_Msk = 0x20
	// Bit ERR5.
	DMA_ERR_ERR5 = 0x20
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR5_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR5_1 = 0x1
	// Position of ERR6 field.
	DMA_ERR_ERR6_Pos = 0x6
	// Bit mask of ERR6 field.
	DMA_ERR_ERR6_Msk = 0x40
	// Bit ERR6.
	DMA_ERR_ERR6 = 0x40
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR6_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR6_1 = 0x1
	// Position of ERR7 field.
	DMA_ERR_ERR7_Pos = 0x7
	// Bit mask of ERR7 field.
	DMA_ERR_ERR7_Msk = 0x80
	// Bit ERR7.
	DMA_ERR_ERR7 = 0x80
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR7_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR7_1 = 0x1
	// Position of ERR8 field.
	DMA_ERR_ERR8_Pos = 0x8
	// Bit mask of ERR8 field.
	DMA_ERR_ERR8_Msk = 0x100
	// Bit ERR8.
	DMA_ERR_ERR8 = 0x100
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR8_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR8_1 = 0x1
	// Position of ERR9 field.
	DMA_ERR_ERR9_Pos = 0x9
	// Bit mask of ERR9 field.
	DMA_ERR_ERR9_Msk = 0x200
	// Bit ERR9.
	DMA_ERR_ERR9 = 0x200
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR9_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR9_1 = 0x1
	// Position of ERR10 field.
	DMA_ERR_ERR10_Pos = 0xa
	// Bit mask of ERR10 field.
	DMA_ERR_ERR10_Msk = 0x400
	// Bit ERR10.
	DMA_ERR_ERR10 = 0x400
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR10_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR10_1 = 0x1
	// Position of ERR11 field.
	DMA_ERR_ERR11_Pos = 0xb
	// Bit mask of ERR11 field.
	DMA_ERR_ERR11_Msk = 0x800
	// Bit ERR11.
	DMA_ERR_ERR11 = 0x800
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR11_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR11_1 = 0x1
	// Position of ERR12 field.
	DMA_ERR_ERR12_Pos = 0xc
	// Bit mask of ERR12 field.
	DMA_ERR_ERR12_Msk = 0x1000
	// Bit ERR12.
	DMA_ERR_ERR12 = 0x1000
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR12_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR12_1 = 0x1
	// Position of ERR13 field.
	DMA_ERR_ERR13_Pos = 0xd
	// Bit mask of ERR13 field.
	DMA_ERR_ERR13_Msk = 0x2000
	// Bit ERR13.
	DMA_ERR_ERR13 = 0x2000
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR13_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR13_1 = 0x1
	// Position of ERR14 field.
	DMA_ERR_ERR14_Pos = 0xe
	// Bit mask of ERR14 field.
	DMA_ERR_ERR14_Msk = 0x4000
	// Bit ERR14.
	DMA_ERR_ERR14 = 0x4000
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR14_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR14_1 = 0x1
	// Position of ERR15 field.
	DMA_ERR_ERR15_Pos = 0xf
	// Bit mask of ERR15 field.
	DMA_ERR_ERR15_Msk = 0x8000
	// Bit ERR15.
	DMA_ERR_ERR15 = 0x8000
	// An error in the corresponding channel has not occurred
	DMA_ERR_ERR15_0 = 0x0
	// An error in the corresponding channel has occurred
	DMA_ERR_ERR15_1 = 0x1

	// HRS: Hardware Request Status Register
	// Position of HRS0 field.
	DMA_HRS_HRS0_Pos = 0x0
	// Bit mask of HRS0 field.
	DMA_HRS_HRS0_Msk = 0x1
	// Bit HRS0.
	DMA_HRS_HRS0 = 0x1
	// A hardware service request for channel 0 is not present
	DMA_HRS_HRS0_0 = 0x0
	// A hardware service request for channel 0 is present
	DMA_HRS_HRS0_1 = 0x1
	// Position of HRS1 field.
	DMA_HRS_HRS1_Pos = 0x1
	// Bit mask of HRS1 field.
	DMA_HRS_HRS1_Msk = 0x2
	// Bit HRS1.
	DMA_HRS_HRS1 = 0x2
	// A hardware service request for channel 1 is not present
	DMA_HRS_HRS1_0 = 0x0
	// A hardware service request for channel 1 is present
	DMA_HRS_HRS1_1 = 0x1
	// Position of HRS2 field.
	DMA_HRS_HRS2_Pos = 0x2
	// Bit mask of HRS2 field.
	DMA_HRS_HRS2_Msk = 0x4
	// Bit HRS2.
	DMA_HRS_HRS2 = 0x4
	// A hardware service request for channel 2 is not present
	DMA_HRS_HRS2_0 = 0x0
	// A hardware service request for channel 2 is present
	DMA_HRS_HRS2_1 = 0x1
	// Position of HRS3 field.
	DMA_HRS_HRS3_Pos = 0x3
	// Bit mask of HRS3 field.
	DMA_HRS_HRS3_Msk = 0x8
	// Bit HRS3.
	DMA_HRS_HRS3 = 0x8
	// A hardware service request for channel 3 is not present
	DMA_HRS_HRS3_0 = 0x0
	// A hardware service request for channel 3 is present
	DMA_HRS_HRS3_1 = 0x1
	// Position of HRS4 field.
	DMA_HRS_HRS4_Pos = 0x4
	// Bit mask of HRS4 field.
	DMA_HRS_HRS4_Msk = 0x10
	// Bit HRS4.
	DMA_HRS_HRS4 = 0x10
	// A hardware service request for channel 4 is not present
	DMA_HRS_HRS4_0 = 0x0
	// A hardware service request for channel 4 is present
	DMA_HRS_HRS4_1 = 0x1
	// Position of HRS5 field.
	DMA_HRS_HRS5_Pos = 0x5
	// Bit mask of HRS5 field.
	DMA_HRS_HRS5_Msk = 0x20
	// Bit HRS5.
	DMA_HRS_HRS5 = 0x20
	// A hardware service request for channel 5 is not present
	DMA_HRS_HRS5_0 = 0x0
	// A hardware service request for channel 5 is present
	DMA_HRS_HRS5_1 = 0x1
	// Position of HRS6 field.
	DMA_HRS_HRS6_Pos = 0x6
	// Bit mask of HRS6 field.
	DMA_HRS_HRS6_Msk = 0x40
	// Bit HRS6.
	DMA_HRS_HRS6 = 0x40
	// A hardware service request for channel 6 is not present
	DMA_HRS_HRS6_0 = 0x0
	// A hardware service request for channel 6 is present
	DMA_HRS_HRS6_1 = 0x1
	// Position of HRS7 field.
	DMA_HRS_HRS7_Pos = 0x7
	// Bit mask of HRS7 field.
	DMA_HRS_HRS7_Msk = 0x80
	// Bit HRS7.
	DMA_HRS_HRS7 = 0x80
	// A hardware service request for channel 7 is not present
	DMA_HRS_HRS7_0 = 0x0
	// A hardware service request for channel 7 is present
	DMA_HRS_HRS7_1 = 0x1
	// Position of HRS8 field.
	DMA_HRS_HRS8_Pos = 0x8
	// Bit mask of HRS8 field.
	DMA_HRS_HRS8_Msk = 0x100
	// Bit HRS8.
	DMA_HRS_HRS8 = 0x100
	// A hardware service request for channel 8 is not present
	DMA_HRS_HRS8_0 = 0x0
	// A hardware service request for channel 8 is present
	DMA_HRS_HRS8_1 = 0x1
	// Position of HRS9 field.
	DMA_HRS_HRS9_Pos = 0x9
	// Bit mask of HRS9 field.
	DMA_HRS_HRS9_Msk = 0x200
	// Bit HRS9.
	DMA_HRS_HRS9 = 0x200
	// A hardware service request for channel 9 is not present
	DMA_HRS_HRS9_0 = 0x0
	// A hardware service request for channel 9 is present
	DMA_HRS_HRS9_1 = 0x1
	// Position of HRS10 field.
	DMA_HRS_HRS10_Pos = 0xa
	// Bit mask of HRS10 field.
	DMA_HRS_HRS10_Msk = 0x400
	// Bit HRS10.
	DMA_HRS_HRS10 = 0x400
	// A hardware service request for channel 10 is not present
	DMA_HRS_HRS10_0 = 0x0
	// A hardware service request for channel 10 is present
	DMA_HRS_HRS10_1 = 0x1
	// Position of HRS11 field.
	DMA_HRS_HRS11_Pos = 0xb
	// Bit mask of HRS11 field.
	DMA_HRS_HRS11_Msk = 0x800
	// Bit HRS11.
	DMA_HRS_HRS11 = 0x800
	// A hardware service request for channel 11 is not present
	DMA_HRS_HRS11_0 = 0x0
	// A hardware service request for channel 11 is present
	DMA_HRS_HRS11_1 = 0x1
	// Position of HRS12 field.
	DMA_HRS_HRS12_Pos = 0xc
	// Bit mask of HRS12 field.
	DMA_HRS_HRS12_Msk = 0x1000
	// Bit HRS12.
	DMA_HRS_HRS12 = 0x1000
	// A hardware service request for channel 12 is not present
	DMA_HRS_HRS12_0 = 0x0
	// A hardware service request for channel 12 is present
	DMA_HRS_HRS12_1 = 0x1
	// Position of HRS13 field.
	DMA_HRS_HRS13_Pos = 0xd
	// Bit mask of HRS13 field.
	DMA_HRS_HRS13_Msk = 0x2000
	// Bit HRS13.
	DMA_HRS_HRS13 = 0x2000
	// A hardware service request for channel 13 is not present
	DMA_HRS_HRS13_0 = 0x0
	// A hardware service request for channel 13 is present
	DMA_HRS_HRS13_1 = 0x1
	// Position of HRS14 field.
	DMA_HRS_HRS14_Pos = 0xe
	// Bit mask of HRS14 field.
	DMA_HRS_HRS14_Msk = 0x4000
	// Bit HRS14.
	DMA_HRS_HRS14 = 0x4000
	// A hardware service request for channel 14 is not present
	DMA_HRS_HRS14_0 = 0x0
	// A hardware service request for channel 14 is present
	DMA_HRS_HRS14_1 = 0x1
	// Position of HRS15 field.
	DMA_HRS_HRS15_Pos = 0xf
	// Bit mask of HRS15 field.
	DMA_HRS_HRS15_Msk = 0x8000
	// Bit HRS15.
	DMA_HRS_HRS15 = 0x8000
	// A hardware service request for channel 15 is not present
	DMA_HRS_HRS15_0 = 0x0
	// A hardware service request for channel 15 is present
	DMA_HRS_HRS15_1 = 0x1

	// EARS: Enable Asynchronous Request in Stop Register
	// Position of EDREQ_0 field.
	DMA_EARS_EDREQ_0_Pos = 0x0
	// Bit mask of EDREQ_0 field.
	DMA_EARS_EDREQ_0_Msk = 0x1
	// Bit EDREQ_0.
	DMA_EARS_EDREQ_0 = 0x1
	// Disable asynchronous DMA request for channel 0.
	DMA_EARS_EDREQ_0_0 = 0x0
	// Enable asynchronous DMA request for channel 0.
	DMA_EARS_EDREQ_0_1 = 0x1
	// Position of EDREQ_1 field.
	DMA_EARS_EDREQ_1_Pos = 0x1
	// Bit mask of EDREQ_1 field.
	DMA_EARS_EDREQ_1_Msk = 0x2
	// Bit EDREQ_1.
	DMA_EARS_EDREQ_1 = 0x2
	// Disable asynchronous DMA request for channel 1
	DMA_EARS_EDREQ_1_0 = 0x0
	// Enable asynchronous DMA request for channel 1.
	DMA_EARS_EDREQ_1_1 = 0x1
	// Position of EDREQ_2 field.
	DMA_EARS_EDREQ_2_Pos = 0x2
	// Bit mask of EDREQ_2 field.
	DMA_EARS_EDREQ_2_Msk = 0x4
	// Bit EDREQ_2.
	DMA_EARS_EDREQ_2 = 0x4
	// Disable asynchronous DMA request for channel 2.
	DMA_EARS_EDREQ_2_0 = 0x0
	// Enable asynchronous DMA request for channel 2.
	DMA_EARS_EDREQ_2_1 = 0x1
	// Position of EDREQ_3 field.
	DMA_EARS_EDREQ_3_Pos = 0x3
	// Bit mask of EDREQ_3 field.
	DMA_EARS_EDREQ_3_Msk = 0x8
	// Bit EDREQ_3.
	DMA_EARS_EDREQ_3 = 0x8
	// Disable asynchronous DMA request for channel 3.
	DMA_EARS_EDREQ_3_0 = 0x0
	// Enable asynchronous DMA request for channel 3.
	DMA_EARS_EDREQ_3_1 = 0x1
	// Position of EDREQ_4 field.
	DMA_EARS_EDREQ_4_Pos = 0x4
	// Bit mask of EDREQ_4 field.
	DMA_EARS_EDREQ_4_Msk = 0x10
	// Bit EDREQ_4.
	DMA_EARS_EDREQ_4 = 0x10
	// Disable asynchronous DMA request for channel 4.
	DMA_EARS_EDREQ_4_0 = 0x0
	// Enable asynchronous DMA request for channel 4.
	DMA_EARS_EDREQ_4_1 = 0x1
	// Position of EDREQ_5 field.
	DMA_EARS_EDREQ_5_Pos = 0x5
	// Bit mask of EDREQ_5 field.
	DMA_EARS_EDREQ_5_Msk = 0x20
	// Bit EDREQ_5.
	DMA_EARS_EDREQ_5 = 0x20
	// Disable asynchronous DMA request for channel 5.
	DMA_EARS_EDREQ_5_0 = 0x0
	// Enable asynchronous DMA request for channel 5.
	DMA_EARS_EDREQ_5_1 = 0x1
	// Position of EDREQ_6 field.
	DMA_EARS_EDREQ_6_Pos = 0x6
	// Bit mask of EDREQ_6 field.
	DMA_EARS_EDREQ_6_Msk = 0x40
	// Bit EDREQ_6.
	DMA_EARS_EDREQ_6 = 0x40
	// Disable asynchronous DMA request for channel 6.
	DMA_EARS_EDREQ_6_0 = 0x0
	// Enable asynchronous DMA request for channel 6.
	DMA_EARS_EDREQ_6_1 = 0x1
	// Position of EDREQ_7 field.
	DMA_EARS_EDREQ_7_Pos = 0x7
	// Bit mask of EDREQ_7 field.
	DMA_EARS_EDREQ_7_Msk = 0x80
	// Bit EDREQ_7.
	DMA_EARS_EDREQ_7 = 0x80
	// Disable asynchronous DMA request for channel 7.
	DMA_EARS_EDREQ_7_0 = 0x0
	// Enable asynchronous DMA request for channel 7.
	DMA_EARS_EDREQ_7_1 = 0x1
	// Position of EDREQ_8 field.
	DMA_EARS_EDREQ_8_Pos = 0x8
	// Bit mask of EDREQ_8 field.
	DMA_EARS_EDREQ_8_Msk = 0x100
	// Bit EDREQ_8.
	DMA_EARS_EDREQ_8 = 0x100
	// Disable asynchronous DMA request for channel 8.
	DMA_EARS_EDREQ_8_0 = 0x0
	// Enable asynchronous DMA request for channel 8.
	DMA_EARS_EDREQ_8_1 = 0x1
	// Position of EDREQ_9 field.
	DMA_EARS_EDREQ_9_Pos = 0x9
	// Bit mask of EDREQ_9 field.
	DMA_EARS_EDREQ_9_Msk = 0x200
	// Bit EDREQ_9.
	DMA_EARS_EDREQ_9 = 0x200
	// Disable asynchronous DMA request for channel 9.
	DMA_EARS_EDREQ_9_0 = 0x0
	// Enable asynchronous DMA request for channel 9.
	DMA_EARS_EDREQ_9_1 = 0x1
	// Position of EDREQ_10 field.
	DMA_EARS_EDREQ_10_Pos = 0xa
	// Bit mask of EDREQ_10 field.
	DMA_EARS_EDREQ_10_Msk = 0x400
	// Bit EDREQ_10.
	DMA_EARS_EDREQ_10 = 0x400
	// Disable asynchronous DMA request for channel 10.
	DMA_EARS_EDREQ_10_0 = 0x0
	// Enable asynchronous DMA request for channel 10.
	DMA_EARS_EDREQ_10_1 = 0x1
	// Position of EDREQ_11 field.
	DMA_EARS_EDREQ_11_Pos = 0xb
	// Bit mask of EDREQ_11 field.
	DMA_EARS_EDREQ_11_Msk = 0x800
	// Bit EDREQ_11.
	DMA_EARS_EDREQ_11 = 0x800
	// Disable asynchronous DMA request for channel 11.
	DMA_EARS_EDREQ_11_0 = 0x0
	// Enable asynchronous DMA request for channel 11.
	DMA_EARS_EDREQ_11_1 = 0x1
	// Position of EDREQ_12 field.
	DMA_EARS_EDREQ_12_Pos = 0xc
	// Bit mask of EDREQ_12 field.
	DMA_EARS_EDREQ_12_Msk = 0x1000
	// Bit EDREQ_12.
	DMA_EARS_EDREQ_12 = 0x1000
	// Disable asynchronous DMA request for channel 12.
	DMA_EARS_EDREQ_12_0 = 0x0
	// Enable asynchronous DMA request for channel 12.
	DMA_EARS_EDREQ_12_1 = 0x1
	// Position of EDREQ_13 field.
	DMA_EARS_EDREQ_13_Pos = 0xd
	// Bit mask of EDREQ_13 field.
	DMA_EARS_EDREQ_13_Msk = 0x2000
	// Bit EDREQ_13.
	DMA_EARS_EDREQ_13 = 0x2000
	// Disable asynchronous DMA request for channel 13.
	DMA_EARS_EDREQ_13_0 = 0x0
	// Enable asynchronous DMA request for channel 13.
	DMA_EARS_EDREQ_13_1 = 0x1
	// Position of EDREQ_14 field.
	DMA_EARS_EDREQ_14_Pos = 0xe
	// Bit mask of EDREQ_14 field.
	DMA_EARS_EDREQ_14_Msk = 0x4000
	// Bit EDREQ_14.
	DMA_EARS_EDREQ_14 = 0x4000
	// Disable asynchronous DMA request for channel 14.
	DMA_EARS_EDREQ_14_0 = 0x0
	// Enable asynchronous DMA request for channel 14.
	DMA_EARS_EDREQ_14_1 = 0x1
	// Position of EDREQ_15 field.
	DMA_EARS_EDREQ_15_Pos = 0xf
	// Bit mask of EDREQ_15 field.
	DMA_EARS_EDREQ_15_Msk = 0x8000
	// Bit EDREQ_15.
	DMA_EARS_EDREQ_15 = 0x8000
	// Disable asynchronous DMA request for channel 15.
	DMA_EARS_EDREQ_15_0 = 0x0
	// Enable asynchronous DMA request for channel 15.
	DMA_EARS_EDREQ_15_1 = 0x1

	// DCHPRI3: Channel n Priority Register
	// Position of CHPRI field.
	DMA_DCHPRI_CHPRI_Pos = 0x0
	// Bit mask of CHPRI field.
	DMA_DCHPRI_CHPRI_Msk = 0xf
	// Position of DPA field.
	DMA_DCHPRI_DPA_Pos = 0x6
	// Bit mask of DPA field.
	DMA_DCHPRI_DPA_Msk = 0x40
	// Bit DPA.
	DMA_DCHPRI_DPA = 0x40
	// Channel n can suspend a lower priority channel
	DMA_DCHPRI_DPA_0 = 0x0
	// Channel n cannot suspend any channel, regardless of channel priority
	DMA_DCHPRI_DPA_1 = 0x1
	// Position of ECP field.
	DMA_DCHPRI_ECP_Pos = 0x7
	// Bit mask of ECP field.
	DMA_DCHPRI_ECP_Msk = 0x80
	// Bit ECP.
	DMA_DCHPRI_ECP = 0x80
	// Channel n cannot be suspended by a higher priority channel's service request
	DMA_DCHPRI_ECP_0 = 0x0
	// Channel n can be temporarily suspended by the service request of a higher priority channel
	DMA_DCHPRI_ECP_1 = 0x1

	// TCD0_SADDR: TCD Source Address
	// Position of SADDR field.
	DMA_TCD_SADDR_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMA_TCD_SADDR_SADDR_Msk = 0xffffffff

	// TCD0_SOFF: TCD Signed Source Address Offset
	// Position of SOFF field.
	DMA_TCD_SOFF_SOFF_Pos = 0x0
	// Bit mask of SOFF field.
	DMA_TCD_SOFF_SOFF_Msk = 0xffff

	// TCD0_ATTR: TCD Transfer Attributes
	// Position of DSIZE field.
	DMA_TCD_ATTR_DSIZE_Pos = 0x0
	// Bit mask of DSIZE field.
	DMA_TCD_ATTR_DSIZE_Msk = 0x7
	// Position of DMOD field.
	DMA_TCD_ATTR_DMOD_Pos = 0x3
	// Bit mask of DMOD field.
	DMA_TCD_ATTR_DMOD_Msk = 0xf8
	// Position of SSIZE field.
	DMA_TCD_ATTR_SSIZE_Pos = 0x8
	// Bit mask of SSIZE field.
	DMA_TCD_ATTR_SSIZE_Msk = 0x700
	// 8-bit
	DMA_TCD_ATTR_SSIZE_000 = 0x0
	// 16-bit
	DMA_TCD_ATTR_SSIZE_001 = 0x1
	// 32-bit
	DMA_TCD_ATTR_SSIZE_010 = 0x2
	// 16-byte
	DMA_TCD_ATTR_SSIZE_100 = 0x4
	// 32-byte
	DMA_TCD_ATTR_SSIZE_101 = 0x5
	// Position of SMOD field.
	DMA_TCD_ATTR_SMOD_Pos = 0xb
	// Bit mask of SMOD field.
	DMA_TCD_ATTR_SMOD_Msk = 0xf800
	// Source address modulo feature is disabled
	DMA_TCD_ATTR_SMOD_0 = 0x0

	// TCD0_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
	// Position of NBYTES field.
	DMA_TCD_NBYTES_MLNO_NBYTES_Pos = 0x0
	// Bit mask of NBYTES field.
	DMA_TCD_NBYTES_MLNO_NBYTES_Msk = 0xffffffff

	// TCD0_NBYTES_MLOFFNO: TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled)
	// Position of NBYTES field.
	DMA_TCD_NBYTES_MLOFFNO_NBYTES_Pos = 0x0
	// Bit mask of NBYTES field.
	DMA_TCD_NBYTES_MLOFFNO_NBYTES_Msk = 0x3fffffff
	// Position of DMLOE field.
	DMA_TCD_NBYTES_MLOFFNO_DMLOE_Pos = 0x1e
	// Bit mask of DMLOE field.
	DMA_TCD_NBYTES_MLOFFNO_DMLOE_Msk = 0x40000000
	// Bit DMLOE.
	DMA_TCD_NBYTES_MLOFFNO_DMLOE = 0x40000000
	// The minor loop offset is not applied to the DADDR
	DMA_TCD_NBYTES_MLOFFNO_DMLOE_0 = 0x0
	// The minor loop offset is applied to the DADDR
	DMA_TCD_NBYTES_MLOFFNO_DMLOE_1 = 0x1
	// Position of SMLOE field.
	DMA_TCD_NBYTES_MLOFFNO_SMLOE_Pos = 0x1f
	// Bit mask of SMLOE field.
	DMA_TCD_NBYTES_MLOFFNO_SMLOE_Msk = 0x80000000
	// Bit SMLOE.
	DMA_TCD_NBYTES_MLOFFNO_SMLOE = 0x80000000
	// The minor loop offset is not applied to the SADDR
	DMA_TCD_NBYTES_MLOFFNO_SMLOE_0 = 0x0
	// The minor loop offset is applied to the SADDR
	DMA_TCD_NBYTES_MLOFFNO_SMLOE_1 = 0x1

	// TCD0_NBYTES_MLOFFYES: TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled)
	// Position of NBYTES field.
	DMA_TCD_NBYTES_MLOFFYES_NBYTES_Pos = 0x0
	// Bit mask of NBYTES field.
	DMA_TCD_NBYTES_MLOFFYES_NBYTES_Msk = 0x3ff
	// Position of MLOFF field.
	DMA_TCD_NBYTES_MLOFFYES_MLOFF_Pos = 0xa
	// Bit mask of MLOFF field.
	DMA_TCD_NBYTES_MLOFFYES_MLOFF_Msk = 0x3ffffc00
	// Position of DMLOE field.
	DMA_TCD_NBYTES_MLOFFYES_DMLOE_Pos = 0x1e
	// Bit mask of DMLOE field.
	DMA_TCD_NBYTES_MLOFFYES_DMLOE_Msk = 0x40000000
	// Bit DMLOE.
	DMA_TCD_NBYTES_MLOFFYES_DMLOE = 0x40000000
	// The minor loop offset is not applied to the DADDR
	DMA_TCD_NBYTES_MLOFFYES_DMLOE_0 = 0x0
	// The minor loop offset is applied to the DADDR
	DMA_TCD_NBYTES_MLOFFYES_DMLOE_1 = 0x1
	// Position of SMLOE field.
	DMA_TCD_NBYTES_MLOFFYES_SMLOE_Pos = 0x1f
	// Bit mask of SMLOE field.
	DMA_TCD_NBYTES_MLOFFYES_SMLOE_Msk = 0x80000000
	// Bit SMLOE.
	DMA_TCD_NBYTES_MLOFFYES_SMLOE = 0x80000000
	// The minor loop offset is not applied to the SADDR
	DMA_TCD_NBYTES_MLOFFYES_SMLOE_0 = 0x0
	// The minor loop offset is applied to the SADDR
	DMA_TCD_NBYTES_MLOFFYES_SMLOE_1 = 0x1

	// TCD0_SLAST: TCD Last Source Address Adjustment
	// Position of SLAST field.
	DMA_TCD_SLAST_SLAST_Pos = 0x0
	// Bit mask of SLAST field.
	DMA_TCD_SLAST_SLAST_Msk = 0xffffffff

	// TCD0_DADDR: TCD Destination Address
	// Position of DADDR field.
	DMA_TCD_DADDR_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMA_TCD_DADDR_DADDR_Msk = 0xffffffff

	// TCD0_DOFF: TCD Signed Destination Address Offset
	// Position of DOFF field.
	DMA_TCD_DOFF_DOFF_Pos = 0x0
	// Bit mask of DOFF field.
	DMA_TCD_DOFF_DOFF_Msk = 0xffff

	// TCD0_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
	// Position of CITER field.
	DMA_TCD_CITER_ELINKNO_CITER_Pos = 0x0
	// Bit mask of CITER field.
	DMA_TCD_CITER_ELINKNO_CITER_Msk = 0x7fff
	// Position of ELINK field.
	DMA_TCD_CITER_ELINKNO_ELINK_Pos = 0xf
	// Bit mask of ELINK field.
	DMA_TCD_CITER_ELINKNO_ELINK_Msk = 0x8000
	// Bit ELINK.
	DMA_TCD_CITER_ELINKNO_ELINK = 0x8000
	// The channel-to-channel linking is disabled
	DMA_TCD_CITER_ELINKNO_ELINK_0 = 0x0
	// The channel-to-channel linking is enabled
	DMA_TCD_CITER_ELINKNO_ELINK_1 = 0x1

	// TCD0_CITER_ELINKYES: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled)
	// Position of CITER field.
	DMA_TCD_CITER_ELINKYES_CITER_Pos = 0x0
	// Bit mask of CITER field.
	DMA_TCD_CITER_ELINKYES_CITER_Msk = 0x1ff
	// Position of LINKCH field.
	DMA_TCD_CITER_ELINKYES_LINKCH_Pos = 0x9
	// Bit mask of LINKCH field.
	DMA_TCD_CITER_ELINKYES_LINKCH_Msk = 0x1e00
	// Position of ELINK field.
	DMA_TCD_CITER_ELINKYES_ELINK_Pos = 0xf
	// Bit mask of ELINK field.
	DMA_TCD_CITER_ELINKYES_ELINK_Msk = 0x8000
	// Bit ELINK.
	DMA_TCD_CITER_ELINKYES_ELINK = 0x8000
	// The channel-to-channel linking is disabled
	DMA_TCD_CITER_ELINKYES_ELINK_0 = 0x0
	// The channel-to-channel linking is enabled
	DMA_TCD_CITER_ELINKYES_ELINK_1 = 0x1

	// TCD0_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
	// Position of DLASTSGA field.
	DMA_TCD_DLASTSGA_DLASTSGA_Pos = 0x0
	// Bit mask of DLASTSGA field.
	DMA_TCD_DLASTSGA_DLASTSGA_Msk = 0xffffffff

	// TCD0_CSR: TCD Control and Status
	// Position of START field.
	DMA_TCD_CSR_START_Pos = 0x0
	// Bit mask of START field.
	DMA_TCD_CSR_START_Msk = 0x1
	// Bit START.
	DMA_TCD_CSR_START = 0x1
	// The channel is not explicitly started
	DMA_TCD_CSR_START_0 = 0x0
	// The channel is explicitly started via a software initiated service request
	DMA_TCD_CSR_START_1 = 0x1
	// Position of INTMAJOR field.
	DMA_TCD_CSR_INTMAJOR_Pos = 0x1
	// Bit mask of INTMAJOR field.
	DMA_TCD_CSR_INTMAJOR_Msk = 0x2
	// Bit INTMAJOR.
	DMA_TCD_CSR_INTMAJOR = 0x2
	// The end-of-major loop interrupt is disabled
	DMA_TCD_CSR_INTMAJOR_0 = 0x0
	// The end-of-major loop interrupt is enabled
	DMA_TCD_CSR_INTMAJOR_1 = 0x1
	// Position of INTHALF field.
	DMA_TCD_CSR_INTHALF_Pos = 0x2
	// Bit mask of INTHALF field.
	DMA_TCD_CSR_INTHALF_Msk = 0x4
	// Bit INTHALF.
	DMA_TCD_CSR_INTHALF = 0x4
	// The half-point interrupt is disabled
	DMA_TCD_CSR_INTHALF_0 = 0x0
	// The half-point interrupt is enabled
	DMA_TCD_CSR_INTHALF_1 = 0x1
	// Position of DREQ field.
	DMA_TCD_CSR_DREQ_Pos = 0x3
	// Bit mask of DREQ field.
	DMA_TCD_CSR_DREQ_Msk = 0x8
	// Bit DREQ.
	DMA_TCD_CSR_DREQ = 0x8
	// The channel's ERQ bit is not affected
	DMA_TCD_CSR_DREQ_0 = 0x0
	// The channel's ERQ bit is cleared when the major loop is complete
	DMA_TCD_CSR_DREQ_1 = 0x1
	// Position of ESG field.
	DMA_TCD_CSR_ESG_Pos = 0x4
	// Bit mask of ESG field.
	DMA_TCD_CSR_ESG_Msk = 0x10
	// Bit ESG.
	DMA_TCD_CSR_ESG = 0x10
	// The current channel's TCD is normal format.
	DMA_TCD_CSR_ESG_0 = 0x0
	// The current channel's TCD specifies a scatter gather format. The DLASTSGA field provides a memory pointer to the next TCD to be loaded into this channel after the major loop completes its execution.
	DMA_TCD_CSR_ESG_1 = 0x1
	// Position of MAJORELINK field.
	DMA_TCD_CSR_MAJORELINK_Pos = 0x5
	// Bit mask of MAJORELINK field.
	DMA_TCD_CSR_MAJORELINK_Msk = 0x20
	// Bit MAJORELINK.
	DMA_TCD_CSR_MAJORELINK = 0x20
	// The channel-to-channel linking is disabled
	DMA_TCD_CSR_MAJORELINK_0 = 0x0
	// The channel-to-channel linking is enabled
	DMA_TCD_CSR_MAJORELINK_1 = 0x1
	// Position of ACTIVE field.
	DMA_TCD_CSR_ACTIVE_Pos = 0x6
	// Bit mask of ACTIVE field.
	DMA_TCD_CSR_ACTIVE_Msk = 0x40
	// Bit ACTIVE.
	DMA_TCD_CSR_ACTIVE = 0x40
	// Position of DONE field.
	DMA_TCD_CSR_DONE_Pos = 0x7
	// Bit mask of DONE field.
	DMA_TCD_CSR_DONE_Msk = 0x80
	// Bit DONE.
	DMA_TCD_CSR_DONE = 0x80
	// Position of MAJORLINKCH field.
	DMA_TCD_CSR_MAJORLINKCH_Pos = 0x8
	// Bit mask of MAJORLINKCH field.
	DMA_TCD_CSR_MAJORLINKCH_Msk = 0xf00
	// Position of BWC field.
	DMA_TCD_CSR_BWC_Pos = 0xe
	// Bit mask of BWC field.
	DMA_TCD_CSR_BWC_Msk = 0xc000
	// No eDMA engine stalls
	DMA_TCD_CSR_BWC_00 = 0x0
	// eDMA engine stalls for 4 cycles after each r/w
	DMA_TCD_CSR_BWC_10 = 0x2
	// eDMA engine stalls for 8 cycles after each r/w
	DMA_TCD_CSR_BWC_11 = 0x3

	// TCD0_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
	// Position of BITER field.
	DMA_TCD_BITER_ELINKNO_BITER_Pos = 0x0
	// Bit mask of BITER field.
	DMA_TCD_BITER_ELINKNO_BITER_Msk = 0x7fff
	// Position of ELINK field.
	DMA_TCD_BITER_ELINKNO_ELINK_Pos = 0xf
	// Bit mask of ELINK field.
	DMA_TCD_BITER_ELINKNO_ELINK_Msk = 0x8000
	// Bit ELINK.
	DMA_TCD_BITER_ELINKNO_ELINK = 0x8000
	// The channel-to-channel linking is disabled
	DMA_TCD_BITER_ELINKNO_ELINK_0 = 0x0
	// The channel-to-channel linking is enabled
	DMA_TCD_BITER_ELINKNO_ELINK_1 = 0x1

	// TCD0_BITER_ELINKYES: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled)
	// Position of BITER field.
	DMA_TCD_BITER_ELINKYES_BITER_Pos = 0x0
	// Bit mask of BITER field.
	DMA_TCD_BITER_ELINKYES_BITER_Msk = 0x1ff
	// Position of LINKCH field.
	DMA_TCD_BITER_ELINKYES_LINKCH_Pos = 0x9
	// Bit mask of LINKCH field.
	DMA_TCD_BITER_ELINKYES_LINKCH_Msk = 0x1e00
	// Position of ELINK field.
	DMA_TCD_BITER_ELINKYES_ELINK_Pos = 0xf
	// Bit mask of ELINK field.
	DMA_TCD_BITER_ELINKYES_ELINK_Msk = 0x8000
	// Bit ELINK.
	DMA_TCD_BITER_ELINKYES_ELINK = 0x8000
	// The channel-to-channel linking is disabled
	DMA_TCD_BITER_ELINKYES_ELINK_0 = 0x0
	// The channel-to-channel linking is enabled
	DMA_TCD_BITER_ELINKYES_ELINK_1 = 0x1
)

// Constants for FB: FlexBus external bus interface
const (
	// CSAR0: Chip Select Address Register
	// Position of BA field.
	FB_CSAR_BA_Pos = 0x10
	// Bit mask of BA field.
	FB_CSAR_BA_Msk = 0xffff0000

	// CSMR0: Chip Select Mask Register
	// Position of V field.
	FB_CSMR_V_Pos = 0x0
	// Bit mask of V field.
	FB_CSMR_V_Msk = 0x1
	// Bit V.
	FB_CSMR_V = 0x1
	// Chip-select is invalid.
	FB_CSMR_V_0 = 0x0
	// Chip-select is valid.
	FB_CSMR_V_1 = 0x1
	// Position of WP field.
	FB_CSMR_WP_Pos = 0x8
	// Bit mask of WP field.
	FB_CSMR_WP_Msk = 0x100
	// Bit WP.
	FB_CSMR_WP = 0x100
	// Write accesses are allowed.
	FB_CSMR_WP_0 = 0x0
	// Write accesses are not allowed. Attempting to write to the range of addresses for which the WP bit is set results in a bus error termination of the internal cycle and no external cycle.
	FB_CSMR_WP_1 = 0x1
	// Position of BAM field.
	FB_CSMR_BAM_Pos = 0x10
	// Bit mask of BAM field.
	FB_CSMR_BAM_Msk = 0xffff0000
	// The corresponding address bit in CSAR is used in the chip-select decode.
	FB_CSMR_BAM_0 = 0x0
	// The corresponding address bit in CSAR is a don't care in the chip-select decode.
	FB_CSMR_BAM_1 = 0x1

	// CSCR0: Chip Select Control Register
	// Position of BSTW field.
	FB_CSCR_BSTW_Pos = 0x3
	// Bit mask of BSTW field.
	FB_CSCR_BSTW_Msk = 0x8
	// Bit BSTW.
	FB_CSCR_BSTW = 0x8
	// Disabled. Data exceeding the specified port size is broken into individual, port-sized, non-burst writes. For example, a 32-bit write to an 8-bit port takes four byte writes.
	FB_CSCR_BSTW_0 = 0x0
	// Enabled. Enables burst write of data larger than the specified port size, including 32-bit writes to 8- and 16-bit ports, 16-bit writes to 8-bit ports, and line writes to 8-, 16-, and 32-bit ports.
	FB_CSCR_BSTW_1 = 0x1
	// Position of BSTR field.
	FB_CSCR_BSTR_Pos = 0x4
	// Bit mask of BSTR field.
	FB_CSCR_BSTR_Msk = 0x10
	// Bit BSTR.
	FB_CSCR_BSTR = 0x10
	// Disabled. Data exceeding the specified port size is broken into individual, port-sized, non-burst reads. For example, a 32-bit read from an 8-bit port is broken into four 8-bit reads.
	FB_CSCR_BSTR_0 = 0x0
	// Enabled. Enables data burst reads larger than the specified port size, including 32-bit reads from 8- and 16-bit ports, 16-bit reads from 8-bit ports, and line reads from 8-, 16-, and 32-bit ports.
	FB_CSCR_BSTR_1 = 0x1
	// Position of BEM field.
	FB_CSCR_BEM_Pos = 0x5
	// Bit mask of BEM field.
	FB_CSCR_BEM_Msk = 0x20
	// Bit BEM.
	FB_CSCR_BEM = 0x20
	// FB_BE is asserted for data write only.
	FB_CSCR_BEM_0 = 0x0
	// FB_BE is asserted for data read and write accesses.
	FB_CSCR_BEM_1 = 0x1
	// Position of PS field.
	FB_CSCR_PS_Pos = 0x6
	// Bit mask of PS field.
	FB_CSCR_PS_Msk = 0xc0
	// 32-bit port size. Valid data is sampled and driven on FB_D[31:0].
	FB_CSCR_PS_00 = 0x0
	// 8-bit port size. Valid data is sampled and driven on FB_D[31:24] when BLS is 0b, or FB_D[7:0] when BLS is 1b.
	FB_CSCR_PS_01 = 0x1
	// Position of AA field.
	FB_CSCR_AA_Pos = 0x8
	// Bit mask of AA field.
	FB_CSCR_AA_Msk = 0x100
	// Bit AA.
	FB_CSCR_AA = 0x100
	// Disabled. No internal transfer acknowledge is asserted and the cycle is terminated externally.
	FB_CSCR_AA_0 = 0x0
	// Enabled. Internal transfer acknowledge is asserted as specified by WS.
	FB_CSCR_AA_1 = 0x1
	// Position of BLS field.
	FB_CSCR_BLS_Pos = 0x9
	// Bit mask of BLS field.
	FB_CSCR_BLS_Msk = 0x200
	// Bit BLS.
	FB_CSCR_BLS = 0x200
	// Not shifted. Data is left-aligned on FB_AD.
	FB_CSCR_BLS_0 = 0x0
	// Shifted. Data is right-aligned on FB_AD.
	FB_CSCR_BLS_1 = 0x1
	// Position of WS field.
	FB_CSCR_WS_Pos = 0xa
	// Bit mask of WS field.
	FB_CSCR_WS_Msk = 0xfc00
	// Position of WRAH field.
	FB_CSCR_WRAH_Pos = 0x10
	// Bit mask of WRAH field.
	FB_CSCR_WRAH_Msk = 0x30000
	// 1 cycle (default for all but FB_CS0 )
	FB_CSCR_WRAH_00 = 0x0
	// 2 cycles
	FB_CSCR_WRAH_01 = 0x1
	// 3 cycles
	FB_CSCR_WRAH_10 = 0x2
	// 4 cycles (default for FB_CS0 )
	FB_CSCR_WRAH_11 = 0x3
	// Position of RDAH field.
	FB_CSCR_RDAH_Pos = 0x12
	// Bit mask of RDAH field.
	FB_CSCR_RDAH_Msk = 0xc0000
	// When AA is 0b, 1 cycle. When AA is 1b, 0 cycles.
	FB_CSCR_RDAH_00 = 0x0
	// When AA is 0b, 2 cycles. When AA is 1b, 1 cycle.
	FB_CSCR_RDAH_01 = 0x1
	// When AA is 0b, 3 cycles. When AA is 1b, 2 cycles.
	FB_CSCR_RDAH_10 = 0x2
	// When AA is 0b, 4 cycles. When AA is 1b, 3 cycles.
	FB_CSCR_RDAH_11 = 0x3
	// Position of ASET field.
	FB_CSCR_ASET_Pos = 0x14
	// Bit mask of ASET field.
	FB_CSCR_ASET_Msk = 0x300000
	// Assert FB_CSn on the first rising clock edge after the address is asserted (default for all but FB_CS0 ).
	FB_CSCR_ASET_00 = 0x0
	// Assert FB_CSn on the second rising clock edge after the address is asserted.
	FB_CSCR_ASET_01 = 0x1
	// Assert FB_CSn on the third rising clock edge after the address is asserted.
	FB_CSCR_ASET_10 = 0x2
	// Assert FB_CSn on the fourth rising clock edge after the address is asserted (default for FB_CS0 ).
	FB_CSCR_ASET_11 = 0x3
	// Position of EXTS field.
	FB_CSCR_EXTS_Pos = 0x16
	// Bit mask of EXTS field.
	FB_CSCR_EXTS_Msk = 0x400000
	// Bit EXTS.
	FB_CSCR_EXTS = 0x400000
	// Disabled. FB_TS /FB_ALE asserts for one bus clock cycle.
	FB_CSCR_EXTS_0 = 0x0
	// Enabled. FB_TS /FB_ALE remains asserted until the first positive clock edge after FB_CSn asserts.
	FB_CSCR_EXTS_1 = 0x1
	// Position of SWSEN field.
	FB_CSCR_SWSEN_Pos = 0x17
	// Bit mask of SWSEN field.
	FB_CSCR_SWSEN_Msk = 0x800000
	// Bit SWSEN.
	FB_CSCR_SWSEN = 0x800000
	// Disabled. A number of wait states (specified by WS) are inserted before an internal transfer acknowledge is generated for all transfers.
	FB_CSCR_SWSEN_0 = 0x0
	// Enabled. A number of wait states (specified by SWS) are inserted before an internal transfer acknowledge is generated for burst transfer secondary terminations.
	FB_CSCR_SWSEN_1 = 0x1
	// Position of SWS field.
	FB_CSCR_SWS_Pos = 0x1a
	// Bit mask of SWS field.
	FB_CSCR_SWS_Msk = 0xfc000000

	// CSPMCR: Chip Select port Multiplexing Control Register
	// Position of GROUP5 field.
	FB_CSPMCR_GROUP5_Pos = 0xc
	// Bit mask of GROUP5 field.
	FB_CSPMCR_GROUP5_Msk = 0xf000
	// FB_TA
	FB_CSPMCR_GROUP5_0000 = 0x0
	// FB_CS3 . You must also write 1b to CSCR[AA].
	FB_CSPMCR_GROUP5_0001 = 0x1
	// FB_BE_7_0 . You must also write 1b to CSCR[AA].
	FB_CSPMCR_GROUP5_0010 = 0x2
	// Position of GROUP4 field.
	FB_CSPMCR_GROUP4_Pos = 0x10
	// Bit mask of GROUP4 field.
	FB_CSPMCR_GROUP4_Msk = 0xf0000
	// FB_TBST
	FB_CSPMCR_GROUP4_0000 = 0x0
	// FB_CS2
	FB_CSPMCR_GROUP4_0001 = 0x1
	// FB_BE_15_8
	FB_CSPMCR_GROUP4_0010 = 0x2
	// Position of GROUP3 field.
	FB_CSPMCR_GROUP3_Pos = 0x14
	// Bit mask of GROUP3 field.
	FB_CSPMCR_GROUP3_Msk = 0xf00000
	// FB_CS5
	FB_CSPMCR_GROUP3_0000 = 0x0
	// FB_TSIZ1
	FB_CSPMCR_GROUP3_0001 = 0x1
	// FB_BE_23_16
	FB_CSPMCR_GROUP3_0010 = 0x2
	// Position of GROUP2 field.
	FB_CSPMCR_GROUP2_Pos = 0x18
	// Bit mask of GROUP2 field.
	FB_CSPMCR_GROUP2_Msk = 0xf000000
	// FB_CS4
	FB_CSPMCR_GROUP2_0000 = 0x0
	// FB_TSIZ0
	FB_CSPMCR_GROUP2_0001 = 0x1
	// FB_BE_31_24
	FB_CSPMCR_GROUP2_0010 = 0x2
	// Position of GROUP1 field.
	FB_CSPMCR_GROUP1_Pos = 0x1c
	// Bit mask of GROUP1 field.
	FB_CSPMCR_GROUP1_Msk = 0xf0000000
	// FB_ALE
	FB_CSPMCR_GROUP1_0000 = 0x0
	// FB_CS1
	FB_CSPMCR_GROUP1_0001 = 0x1
	// FB_TS
	FB_CSPMCR_GROUP1_0010 = 0x2
)

// Constants for FMC: Flash Memory Controller
const (
	// PFAPR: Flash Access Protection Register
	// Position of M0AP field.
	FMC_PFAPR_M0AP_Pos = 0x0
	// Bit mask of M0AP field.
	FMC_PFAPR_M0AP_Msk = 0x3
	// No access may be performed by this master
	FMC_PFAPR_M0AP_00 = 0x0
	// Only read accesses may be performed by this master
	FMC_PFAPR_M0AP_01 = 0x1
	// Only write accesses may be performed by this master
	FMC_PFAPR_M0AP_10 = 0x2
	// Both read and write accesses may be performed by this master
	FMC_PFAPR_M0AP_11 = 0x3
	// Position of M1AP field.
	FMC_PFAPR_M1AP_Pos = 0x2
	// Bit mask of M1AP field.
	FMC_PFAPR_M1AP_Msk = 0xc
	// No access may be performed by this master
	FMC_PFAPR_M1AP_00 = 0x0
	// Only read accesses may be performed by this master
	FMC_PFAPR_M1AP_01 = 0x1
	// Only write accesses may be performed by this master
	FMC_PFAPR_M1AP_10 = 0x2
	// Both read and write accesses may be performed by this master
	FMC_PFAPR_M1AP_11 = 0x3
	// Position of M2AP field.
	FMC_PFAPR_M2AP_Pos = 0x4
	// Bit mask of M2AP field.
	FMC_PFAPR_M2AP_Msk = 0x30
	// No access may be performed by this master
	FMC_PFAPR_M2AP_00 = 0x0
	// Only read accesses may be performed by this master
	FMC_PFAPR_M2AP_01 = 0x1
	// Only write accesses may be performed by this master
	FMC_PFAPR_M2AP_10 = 0x2
	// Both read and write accesses may be performed by this master
	FMC_PFAPR_M2AP_11 = 0x3
	// Position of M3AP field.
	FMC_PFAPR_M3AP_Pos = 0x6
	// Bit mask of M3AP field.
	FMC_PFAPR_M3AP_Msk = 0xc0
	// No access may be performed by this master
	FMC_PFAPR_M3AP_00 = 0x0
	// Only read accesses may be performed by this master
	FMC_PFAPR_M3AP_01 = 0x1
	// Only write accesses may be performed by this master
	FMC_PFAPR_M3AP_10 = 0x2
	// Both read and write accesses may be performed by this master
	FMC_PFAPR_M3AP_11 = 0x3
	// Position of M4AP field.
	FMC_PFAPR_M4AP_Pos = 0x8
	// Bit mask of M4AP field.
	FMC_PFAPR_M4AP_Msk = 0x300
	// No access may be performed by this master
	FMC_PFAPR_M4AP_00 = 0x0
	// Only read accesses may be performed by this master
	FMC_PFAPR_M4AP_01 = 0x1
	// Only write accesses may be performed by this master
	FMC_PFAPR_M4AP_10 = 0x2
	// Both read and write accesses may be performed by this master
	FMC_PFAPR_M4AP_11 = 0x3
	// Position of M5AP field.
	FMC_PFAPR_M5AP_Pos = 0xa
	// Bit mask of M5AP field.
	FMC_PFAPR_M5AP_Msk = 0xc00
	// No access may be performed by this master
	FMC_PFAPR_M5AP_00 = 0x0
	// Only read accesses may be performed by this master
	FMC_PFAPR_M5AP_01 = 0x1
	// Only write accesses may be performed by this master
	FMC_PFAPR_M5AP_10 = 0x2
	// Both read and write accesses may be performed by this master
	FMC_PFAPR_M5AP_11 = 0x3
	// Position of M6AP field.
	FMC_PFAPR_M6AP_Pos = 0xc
	// Bit mask of M6AP field.
	FMC_PFAPR_M6AP_Msk = 0x3000
	// No access may be performed by this master
	FMC_PFAPR_M6AP_00 = 0x0
	// Only read accesses may be performed by this master
	FMC_PFAPR_M6AP_01 = 0x1
	// Only write accesses may be performed by this master
	FMC_PFAPR_M6AP_10 = 0x2
	// Both read and write accesses may be performed by this master
	FMC_PFAPR_M6AP_11 = 0x3
	// Position of M7AP field.
	FMC_PFAPR_M7AP_Pos = 0xe
	// Bit mask of M7AP field.
	FMC_PFAPR_M7AP_Msk = 0xc000
	// No access may be performed by this master.
	FMC_PFAPR_M7AP_00 = 0x0
	// Only read accesses may be performed by this master.
	FMC_PFAPR_M7AP_01 = 0x1
	// Only write accesses may be performed by this master.
	FMC_PFAPR_M7AP_10 = 0x2
	// Both read and write accesses may be performed by this master.
	FMC_PFAPR_M7AP_11 = 0x3
	// Position of M0PFD field.
	FMC_PFAPR_M0PFD_Pos = 0x10
	// Bit mask of M0PFD field.
	FMC_PFAPR_M0PFD_Msk = 0x10000
	// Bit M0PFD.
	FMC_PFAPR_M0PFD = 0x10000
	// Prefetching for this master is enabled.
	FMC_PFAPR_M0PFD_0 = 0x0
	// Prefetching for this master is disabled.
	FMC_PFAPR_M0PFD_1 = 0x1
	// Position of M1PFD field.
	FMC_PFAPR_M1PFD_Pos = 0x11
	// Bit mask of M1PFD field.
	FMC_PFAPR_M1PFD_Msk = 0x20000
	// Bit M1PFD.
	FMC_PFAPR_M1PFD = 0x20000
	// Prefetching for this master is enabled.
	FMC_PFAPR_M1PFD_0 = 0x0
	// Prefetching for this master is disabled.
	FMC_PFAPR_M1PFD_1 = 0x1
	// Position of M2PFD field.
	FMC_PFAPR_M2PFD_Pos = 0x12
	// Bit mask of M2PFD field.
	FMC_PFAPR_M2PFD_Msk = 0x40000
	// Bit M2PFD.
	FMC_PFAPR_M2PFD = 0x40000
	// Prefetching for this master is enabled.
	FMC_PFAPR_M2PFD_0 = 0x0
	// Prefetching for this master is disabled.
	FMC_PFAPR_M2PFD_1 = 0x1
	// Position of M3PFD field.
	FMC_PFAPR_M3PFD_Pos = 0x13
	// Bit mask of M3PFD field.
	FMC_PFAPR_M3PFD_Msk = 0x80000
	// Bit M3PFD.
	FMC_PFAPR_M3PFD = 0x80000
	// Prefetching for this master is enabled.
	FMC_PFAPR_M3PFD_0 = 0x0
	// Prefetching for this master is disabled.
	FMC_PFAPR_M3PFD_1 = 0x1
	// Position of M4PFD field.
	FMC_PFAPR_M4PFD_Pos = 0x14
	// Bit mask of M4PFD field.
	FMC_PFAPR_M4PFD_Msk = 0x100000
	// Bit M4PFD.
	FMC_PFAPR_M4PFD = 0x100000
	// Prefetching for this master is enabled.
	FMC_PFAPR_M4PFD_0 = 0x0
	// Prefetching for this master is disabled.
	FMC_PFAPR_M4PFD_1 = 0x1
	// Position of M5PFD field.
	FMC_PFAPR_M5PFD_Pos = 0x15
	// Bit mask of M5PFD field.
	FMC_PFAPR_M5PFD_Msk = 0x200000
	// Bit M5PFD.
	FMC_PFAPR_M5PFD = 0x200000
	// Prefetching for this master is enabled.
	FMC_PFAPR_M5PFD_0 = 0x0
	// Prefetching for this master is disabled.
	FMC_PFAPR_M5PFD_1 = 0x1
	// Position of M6PFD field.
	FMC_PFAPR_M6PFD_Pos = 0x16
	// Bit mask of M6PFD field.
	FMC_PFAPR_M6PFD_Msk = 0x400000
	// Bit M6PFD.
	FMC_PFAPR_M6PFD = 0x400000
	// Prefetching for this master is enabled.
	FMC_PFAPR_M6PFD_0 = 0x0
	// Prefetching for this master is disabled.
	FMC_PFAPR_M6PFD_1 = 0x1
	// Position of M7PFD field.
	FMC_PFAPR_M7PFD_Pos = 0x17
	// Bit mask of M7PFD field.
	FMC_PFAPR_M7PFD_Msk = 0x800000
	// Bit M7PFD.
	FMC_PFAPR_M7PFD = 0x800000
	// Prefetching for this master is enabled.
	FMC_PFAPR_M7PFD_0 = 0x0
	// Prefetching for this master is disabled.
	FMC_PFAPR_M7PFD_1 = 0x1

	// PFB0CR: Flash Bank 0 Control Register
	// Position of B0SEBE field.
	FMC_PFB0CR_B0SEBE_Pos = 0x0
	// Bit mask of B0SEBE field.
	FMC_PFB0CR_B0SEBE_Msk = 0x1
	// Bit B0SEBE.
	FMC_PFB0CR_B0SEBE = 0x1
	// Single entry buffer is disabled.
	FMC_PFB0CR_B0SEBE_0 = 0x0
	// Single entry buffer is enabled.
	FMC_PFB0CR_B0SEBE_1 = 0x1
	// Position of B0IPE field.
	FMC_PFB0CR_B0IPE_Pos = 0x1
	// Bit mask of B0IPE field.
	FMC_PFB0CR_B0IPE_Msk = 0x2
	// Bit B0IPE.
	FMC_PFB0CR_B0IPE = 0x2
	// Do not prefetch in response to instruction fetches.
	FMC_PFB0CR_B0IPE_0 = 0x0
	// Enable prefetches in response to instruction fetches.
	FMC_PFB0CR_B0IPE_1 = 0x1
	// Position of B0DPE field.
	FMC_PFB0CR_B0DPE_Pos = 0x2
	// Bit mask of B0DPE field.
	FMC_PFB0CR_B0DPE_Msk = 0x4
	// Bit B0DPE.
	FMC_PFB0CR_B0DPE = 0x4
	// Do not prefetch in response to data references.
	FMC_PFB0CR_B0DPE_0 = 0x0
	// Enable prefetches in response to data references.
	FMC_PFB0CR_B0DPE_1 = 0x1
	// Position of B0ICE field.
	FMC_PFB0CR_B0ICE_Pos = 0x3
	// Bit mask of B0ICE field.
	FMC_PFB0CR_B0ICE_Msk = 0x8
	// Bit B0ICE.
	FMC_PFB0CR_B0ICE = 0x8
	// Do not cache instruction fetches.
	FMC_PFB0CR_B0ICE_0 = 0x0
	// Cache instruction fetches.
	FMC_PFB0CR_B0ICE_1 = 0x1
	// Position of B0DCE field.
	FMC_PFB0CR_B0DCE_Pos = 0x4
	// Bit mask of B0DCE field.
	FMC_PFB0CR_B0DCE_Msk = 0x10
	// Bit B0DCE.
	FMC_PFB0CR_B0DCE = 0x10
	// Do not cache data references.
	FMC_PFB0CR_B0DCE_0 = 0x0
	// Cache data references.
	FMC_PFB0CR_B0DCE_1 = 0x1
	// Position of CRC field.
	FMC_PFB0CR_CRC_Pos = 0x5
	// Bit mask of CRC field.
	FMC_PFB0CR_CRC_Msk = 0xe0
	// LRU replacement algorithm per set across all four ways
	FMC_PFB0CR_CRC_000 = 0x0
	// Independent LRU with ways [0-1] for ifetches, [2-3] for data
	FMC_PFB0CR_CRC_010 = 0x2
	// Independent LRU with ways [0-2] for ifetches, [3] for data
	FMC_PFB0CR_CRC_011 = 0x3
	// Position of B0MW field.
	FMC_PFB0CR_B0MW_Pos = 0x11
	// Bit mask of B0MW field.
	FMC_PFB0CR_B0MW_Msk = 0x60000
	// 32 bits
	FMC_PFB0CR_B0MW_00 = 0x0
	// 64 bits
	FMC_PFB0CR_B0MW_01 = 0x1
	// Position of S_B_INV field.
	FMC_PFB0CR_S_B_INV_Pos = 0x13
	// Bit mask of S_B_INV field.
	FMC_PFB0CR_S_B_INV_Msk = 0x80000
	// Bit S_B_INV.
	FMC_PFB0CR_S_B_INV = 0x80000
	// Speculation buffer and single entry buffer are not affected.
	FMC_PFB0CR_S_B_INV_0 = 0x0
	// Invalidate (clear) speculation buffer and single entry buffer.
	FMC_PFB0CR_S_B_INV_1 = 0x1
	// Position of CINV_WAY field.
	FMC_PFB0CR_CINV_WAY_Pos = 0x14
	// Bit mask of CINV_WAY field.
	FMC_PFB0CR_CINV_WAY_Msk = 0xf00000
	// No cache way invalidation for the corresponding cache
	FMC_PFB0CR_CINV_WAY_0 = 0x0
	// Invalidate cache way for the corresponding cache: clear the tag, data, and vld bits of ways selected
	FMC_PFB0CR_CINV_WAY_1 = 0x1
	// Position of CLCK_WAY field.
	FMC_PFB0CR_CLCK_WAY_Pos = 0x18
	// Bit mask of CLCK_WAY field.
	FMC_PFB0CR_CLCK_WAY_Msk = 0xf000000
	// Cache way is unlocked and may be displaced
	FMC_PFB0CR_CLCK_WAY_0 = 0x0
	// Cache way is locked and its contents are not displaced
	FMC_PFB0CR_CLCK_WAY_1 = 0x1
	// Position of B0RWSC field.
	FMC_PFB0CR_B0RWSC_Pos = 0x1c
	// Bit mask of B0RWSC field.
	FMC_PFB0CR_B0RWSC_Msk = 0xf0000000

	// PFB1CR: Flash Bank 1 Control Register
	// Position of B1SEBE field.
	FMC_PFB1CR_B1SEBE_Pos = 0x0
	// Bit mask of B1SEBE field.
	FMC_PFB1CR_B1SEBE_Msk = 0x1
	// Bit B1SEBE.
	FMC_PFB1CR_B1SEBE = 0x1
	// Single entry buffer is disabled.
	FMC_PFB1CR_B1SEBE_0 = 0x0
	// Single entry buffer is enabled.
	FMC_PFB1CR_B1SEBE_1 = 0x1
	// Position of B1IPE field.
	FMC_PFB1CR_B1IPE_Pos = 0x1
	// Bit mask of B1IPE field.
	FMC_PFB1CR_B1IPE_Msk = 0x2
	// Bit B1IPE.
	FMC_PFB1CR_B1IPE = 0x2
	// Do not prefetch in response to instruction fetches.
	FMC_PFB1CR_B1IPE_0 = 0x0
	// Enable prefetches in response to instruction fetches.
	FMC_PFB1CR_B1IPE_1 = 0x1
	// Position of B1DPE field.
	FMC_PFB1CR_B1DPE_Pos = 0x2
	// Bit mask of B1DPE field.
	FMC_PFB1CR_B1DPE_Msk = 0x4
	// Bit B1DPE.
	FMC_PFB1CR_B1DPE = 0x4
	// Do not prefetch in response to data references.
	FMC_PFB1CR_B1DPE_0 = 0x0
	// Enable prefetches in response to data references.
	FMC_PFB1CR_B1DPE_1 = 0x1
	// Position of B1ICE field.
	FMC_PFB1CR_B1ICE_Pos = 0x3
	// Bit mask of B1ICE field.
	FMC_PFB1CR_B1ICE_Msk = 0x8
	// Bit B1ICE.
	FMC_PFB1CR_B1ICE = 0x8
	// Do not cache instruction fetches.
	FMC_PFB1CR_B1ICE_0 = 0x0
	// Cache instruction fetches.
	FMC_PFB1CR_B1ICE_1 = 0x1
	// Position of B1DCE field.
	FMC_PFB1CR_B1DCE_Pos = 0x4
	// Bit mask of B1DCE field.
	FMC_PFB1CR_B1DCE_Msk = 0x10
	// Bit B1DCE.
	FMC_PFB1CR_B1DCE = 0x10
	// Do not cache data references.
	FMC_PFB1CR_B1DCE_0 = 0x0
	// Cache data references.
	FMC_PFB1CR_B1DCE_1 = 0x1
	// Position of B1MW field.
	FMC_PFB1CR_B1MW_Pos = 0x11
	// Bit mask of B1MW field.
	FMC_PFB1CR_B1MW_Msk = 0x60000
	// 32 bits
	FMC_PFB1CR_B1MW_00 = 0x0
	// 64 bits
	FMC_PFB1CR_B1MW_01 = 0x1
	// Position of B1RWSC field.
	FMC_PFB1CR_B1RWSC_Pos = 0x1c
	// Bit mask of B1RWSC field.
	FMC_PFB1CR_B1RWSC_Msk = 0xf0000000

	// TAGVDW0S0: Cache Tag Storage
	// Position of VALID field.
	FMC_TAGVDW0S_VALID_Pos = 0x0
	// Bit mask of VALID field.
	FMC_TAGVDW0S_VALID_Msk = 0x1
	// Bit VALID.
	FMC_TAGVDW0S_VALID = 0x1
	// Position of TAG field.
	FMC_TAGVDW0S_TAG_Pos = 0x5
	// Bit mask of TAG field.
	FMC_TAGVDW0S_TAG_Msk = 0x7ffe0

	// TAGVDW1S0: Cache Tag Storage
	// Position of VALID field.
	FMC_TAGVDW1S_VALID_Pos = 0x0
	// Bit mask of VALID field.
	FMC_TAGVDW1S_VALID_Msk = 0x1
	// Bit VALID.
	FMC_TAGVDW1S_VALID = 0x1
	// Position of TAG field.
	FMC_TAGVDW1S_TAG_Pos = 0x5
	// Bit mask of TAG field.
	FMC_TAGVDW1S_TAG_Msk = 0x7ffe0

	// TAGVDW2S0: Cache Tag Storage
	// Position of VALID field.
	FMC_TAGVDW2S_VALID_Pos = 0x0
	// Bit mask of VALID field.
	FMC_TAGVDW2S_VALID_Msk = 0x1
	// Bit VALID.
	FMC_TAGVDW2S_VALID = 0x1
	// Position of TAG field.
	FMC_TAGVDW2S_TAG_Pos = 0x5
	// Bit mask of TAG field.
	FMC_TAGVDW2S_TAG_Msk = 0x7ffe0

	// TAGVDW3S0: Cache Tag Storage
	// Position of VALID field.
	FMC_TAGVDW3S_VALID_Pos = 0x0
	// Bit mask of VALID field.
	FMC_TAGVDW3S_VALID_Msk = 0x1
	// Bit VALID.
	FMC_TAGVDW3S_VALID = 0x1
	// Position of TAG field.
	FMC_TAGVDW3S_TAG_Pos = 0x5
	// Bit mask of TAG field.
	FMC_TAGVDW3S_TAG_Msk = 0x7ffe0

	// DATAW0S0U: Cache Data Storage (upper word)
	// Position of DATA field.
	FMC_DATAW0SU_DATA_Pos = 0x0
	// Bit mask of DATA field.
	FMC_DATAW0SU_DATA_Msk = 0xffffffff

	// DATAW0S0L: Cache Data Storage (lower word)
	// Position of DATA field.
	FMC_DATAW0SL_DATA_Pos = 0x0
	// Bit mask of DATA field.
	FMC_DATAW0SL_DATA_Msk = 0xffffffff

	// DATAW1S0U: Cache Data Storage (upper word)
	// Position of DATA field.
	FMC_DATAW1SU_DATA_Pos = 0x0
	// Bit mask of DATA field.
	FMC_DATAW1SU_DATA_Msk = 0xffffffff

	// DATAW1S0L: Cache Data Storage (lower word)
	// Position of DATA field.
	FMC_DATAW1SL_DATA_Pos = 0x0
	// Bit mask of DATA field.
	FMC_DATAW1SL_DATA_Msk = 0xffffffff

	// DATAW2S0U: Cache Data Storage (upper word)
	// Position of DATA field.
	FMC_DATAW2SU_DATA_Pos = 0x0
	// Bit mask of DATA field.
	FMC_DATAW2SU_DATA_Msk = 0xffffffff

	// DATAW2S0L: Cache Data Storage (lower word)
	// Position of DATA field.
	FMC_DATAW2SL_DATA_Pos = 0x0
	// Bit mask of DATA field.
	FMC_DATAW2SL_DATA_Msk = 0xffffffff

	// DATAW3S0U: Cache Data Storage (upper word)
	// Position of DATA field.
	FMC_DATAW3SU_DATA_Pos = 0x0
	// Bit mask of DATA field.
	FMC_DATAW3SU_DATA_Msk = 0xffffffff

	// DATAW3S0L: Cache Data Storage (lower word)
	// Position of DATA field.
	FMC_DATAW3SL_DATA_Pos = 0x0
	// Bit mask of DATA field.
	FMC_DATAW3SL_DATA_Msk = 0xffffffff
)

// Constants for FTFA: Flash Memory Interface
const (
	// FSTAT: Flash Status Register
	// Position of MGSTAT0 field.
	FTFA_FSTAT_MGSTAT0_Pos = 0x0
	// Bit mask of MGSTAT0 field.
	FTFA_FSTAT_MGSTAT0_Msk = 0x1
	// Bit MGSTAT0.
	FTFA_FSTAT_MGSTAT0 = 0x1
	// Position of FPVIOL field.
	FTFA_FSTAT_FPVIOL_Pos = 0x4
	// Bit mask of FPVIOL field.
	FTFA_FSTAT_FPVIOL_Msk = 0x10
	// Bit FPVIOL.
	FTFA_FSTAT_FPVIOL = 0x10
	// No protection violation detected
	FTFA_FSTAT_FPVIOL_0 = 0x0
	// Protection violation detected
	FTFA_FSTAT_FPVIOL_1 = 0x1
	// Position of ACCERR field.
	FTFA_FSTAT_ACCERR_Pos = 0x5
	// Bit mask of ACCERR field.
	FTFA_FSTAT_ACCERR_Msk = 0x20
	// Bit ACCERR.
	FTFA_FSTAT_ACCERR = 0x20
	// No access error detected
	FTFA_FSTAT_ACCERR_0 = 0x0
	// Access error detected
	FTFA_FSTAT_ACCERR_1 = 0x1
	// Position of RDCOLERR field.
	FTFA_FSTAT_RDCOLERR_Pos = 0x6
	// Bit mask of RDCOLERR field.
	FTFA_FSTAT_RDCOLERR_Msk = 0x40
	// Bit RDCOLERR.
	FTFA_FSTAT_RDCOLERR = 0x40
	// No collision error detected
	FTFA_FSTAT_RDCOLERR_0 = 0x0
	// Collision error detected
	FTFA_FSTAT_RDCOLERR_1 = 0x1
	// Position of CCIF field.
	FTFA_FSTAT_CCIF_Pos = 0x7
	// Bit mask of CCIF field.
	FTFA_FSTAT_CCIF_Msk = 0x80
	// Bit CCIF.
	FTFA_FSTAT_CCIF = 0x80
	// Flash command in progress
	FTFA_FSTAT_CCIF_0 = 0x0
	// Flash command has completed
	FTFA_FSTAT_CCIF_1 = 0x1

	// FCNFG: Flash Configuration Register
	// Position of ERSSUSP field.
	FTFA_FCNFG_ERSSUSP_Pos = 0x4
	// Bit mask of ERSSUSP field.
	FTFA_FCNFG_ERSSUSP_Msk = 0x10
	// Bit ERSSUSP.
	FTFA_FCNFG_ERSSUSP = 0x10
	// No suspend requested
	FTFA_FCNFG_ERSSUSP_0 = 0x0
	// Suspend the current Erase Flash Sector command execution.
	FTFA_FCNFG_ERSSUSP_1 = 0x1
	// Position of ERSAREQ field.
	FTFA_FCNFG_ERSAREQ_Pos = 0x5
	// Bit mask of ERSAREQ field.
	FTFA_FCNFG_ERSAREQ_Msk = 0x20
	// Bit ERSAREQ.
	FTFA_FCNFG_ERSAREQ = 0x20
	// No request or request complete
	FTFA_FCNFG_ERSAREQ_0 = 0x0
	// Request to: run the Erase All Blocks command, verify the erased state, program the security byte in the Flash Configuration Field to the unsecure state, and release MCU security by setting the FSEC[SEC] field to the unsecure state.
	FTFA_FCNFG_ERSAREQ_1 = 0x1
	// Position of RDCOLLIE field.
	FTFA_FCNFG_RDCOLLIE_Pos = 0x6
	// Bit mask of RDCOLLIE field.
	FTFA_FCNFG_RDCOLLIE_Msk = 0x40
	// Bit RDCOLLIE.
	FTFA_FCNFG_RDCOLLIE = 0x40
	// Read collision error interrupt disabled
	FTFA_FCNFG_RDCOLLIE_0 = 0x0
	// Read collision error interrupt enabled. An interrupt request is generated whenever a flash memory read collision error is detected (see the description of FSTAT[RDCOLERR]).
	FTFA_FCNFG_RDCOLLIE_1 = 0x1
	// Position of CCIE field.
	FTFA_FCNFG_CCIE_Pos = 0x7
	// Bit mask of CCIE field.
	FTFA_FCNFG_CCIE_Msk = 0x80
	// Bit CCIE.
	FTFA_FCNFG_CCIE = 0x80
	// Command complete interrupt disabled
	FTFA_FCNFG_CCIE_0 = 0x0
	// Command complete interrupt enabled. An interrupt request is generated whenever the FSTAT[CCIF] flag is set.
	FTFA_FCNFG_CCIE_1 = 0x1

	// FSEC: Flash Security Register
	// Position of SEC field.
	FTFA_FSEC_SEC_Pos = 0x0
	// Bit mask of SEC field.
	FTFA_FSEC_SEC_Msk = 0x3
	// MCU security status is secure.
	FTFA_FSEC_SEC_00 = 0x0
	// MCU security status is secure.
	FTFA_FSEC_SEC_01 = 0x1
	// MCU security status is unsecure. (The standard shipping condition of the flash memory module is unsecure.)
	FTFA_FSEC_SEC_10 = 0x2
	// MCU security status is secure.
	FTFA_FSEC_SEC_11 = 0x3
	// Position of FSLACC field.
	FTFA_FSEC_FSLACC_Pos = 0x2
	// Bit mask of FSLACC field.
	FTFA_FSEC_FSLACC_Msk = 0xc
	// Freescale factory access granted
	FTFA_FSEC_FSLACC_00 = 0x0
	// Freescale factory access denied
	FTFA_FSEC_FSLACC_01 = 0x1
	// Freescale factory access denied
	FTFA_FSEC_FSLACC_10 = 0x2
	// Freescale factory access granted
	FTFA_FSEC_FSLACC_11 = 0x3
	// Position of MEEN field.
	FTFA_FSEC_MEEN_Pos = 0x4
	// Bit mask of MEEN field.
	FTFA_FSEC_MEEN_Msk = 0x30
	// Mass erase is enabled
	FTFA_FSEC_MEEN_00 = 0x0
	// Mass erase is enabled
	FTFA_FSEC_MEEN_01 = 0x1
	// Mass erase is disabled
	FTFA_FSEC_MEEN_10 = 0x2
	// Mass erase is enabled
	FTFA_FSEC_MEEN_11 = 0x3
	// Position of KEYEN field.
	FTFA_FSEC_KEYEN_Pos = 0x6
	// Bit mask of KEYEN field.
	FTFA_FSEC_KEYEN_Msk = 0xc0
	// Backdoor key access disabled
	FTFA_FSEC_KEYEN_00 = 0x0
	// Backdoor key access disabled (preferred KEYEN state to disable backdoor key access)
	FTFA_FSEC_KEYEN_01 = 0x1
	// Backdoor key access enabled
	FTFA_FSEC_KEYEN_10 = 0x2
	// Backdoor key access disabled
	FTFA_FSEC_KEYEN_11 = 0x3

	// FOPT: Flash Option Register
	// Position of OPT field.
	FTFA_FOPT_OPT_Pos = 0x0
	// Bit mask of OPT field.
	FTFA_FOPT_OPT_Msk = 0xff

	// FCCOB3: Flash Common Command Object Registers
	// Position of CCOBn field.
	FTFA_FCCOB_CCOBn_Pos = 0x0
	// Bit mask of CCOBn field.
	FTFA_FCCOB_CCOBn_Msk = 0xff

	// FPROT3: Program Flash Protection Registers
	// Position of PROT field.
	FTFA_FPROT_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FPROT_PROT_Msk = 0xff
	// Program flash region is protected.
	FTFA_FPROT_PROT_0 = 0x0
	// Program flash region is not protected
	FTFA_FPROT_PROT_1 = 0x1

	// XACCH3: Execute-only Access Registers
	// Position of XA field.
	FTFA_XACC_XA_Pos = 0x0
	// Bit mask of XA field.
	FTFA_XACC_XA_Msk = 0xff
	// Associated segment is accessible in execute mode only (as an instruction fetch)
	FTFA_XACC_XA_0 = 0x0
	// Associated segment is accessible as data or in execute mode
	FTFA_XACC_XA_1 = 0x1

	// SACCH3: Supervisor-only Access Registers
	// Position of SA field.
	FTFA_SACC_SA_Pos = 0x0
	// Bit mask of SA field.
	FTFA_SACC_SA_Msk = 0xff
	// Associated segment is accessible in supervisor mode only
	FTFA_SACC_SA_0 = 0x0
	// Associated segment is accessible in user or supervisor mode
	FTFA_SACC_SA_1 = 0x1

	// FACSS: Flash Access Segment Size Register
	// Position of SGSIZE field.
	FTFA_FACSS_SGSIZE_Pos = 0x0
	// Bit mask of SGSIZE field.
	FTFA_FACSS_SGSIZE_Msk = 0xff

	// FACSN: Flash Access Segment Number Register
	// Position of NUMSG field.
	FTFA_FACSN_NUMSG_Pos = 0x0
	// Bit mask of NUMSG field.
	FTFA_FACSN_NUMSG_Msk = 0xff
	// Program flash memory is divided into 32 segments (64 Kbytes, 128 Kbytes)
	FTFA_FACSN_NUMSG_100000 = 0x20
	// Program flash memory is divided into 40 segments (160 Kbytes)
	FTFA_FACSN_NUMSG_101000 = 0x28
	// Program flash memory is divided into 64 segments (256 Kbytes, 512 Kbytes)
	FTFA_FACSN_NUMSG_1000000 = 0x40
)

// Constants for DMAMUX: DMA channel multiplexor
const (
	// CHCFG0: Channel Configuration register
	// Position of SOURCE field.
	DMAMUX_CHCFG_SOURCE_Pos = 0x0
	// Bit mask of SOURCE field.
	DMAMUX_CHCFG_SOURCE_Msk = 0x3f
	// Disable_Signal
	DMAMUX_CHCFG_SOURCE_0 = 0x0
	// UART0_Rx_Signal
	DMAMUX_CHCFG_SOURCE_2 = 0x2
	// UART0_Tx_Signal
	DMAMUX_CHCFG_SOURCE_3 = 0x3
	// UART1_Rx_Signal
	DMAMUX_CHCFG_SOURCE_4 = 0x4
	// UART1_Tx_Signal
	DMAMUX_CHCFG_SOURCE_5 = 0x5
	// UART2_Rx_Signal
	DMAMUX_CHCFG_SOURCE_6 = 0x6
	// UART2_Tx_Signal
	DMAMUX_CHCFG_SOURCE_7 = 0x7
	// I2S0_Rx_Signal
	DMAMUX_CHCFG_SOURCE_12 = 0xc
	// I2S0_Tx_Signal
	DMAMUX_CHCFG_SOURCE_13 = 0xd
	// SPI0_Rx_Signal
	DMAMUX_CHCFG_SOURCE_14 = 0xe
	// SPI0_Tx_Signal
	DMAMUX_CHCFG_SOURCE_15 = 0xf
	// SPI1_Signal
	DMAMUX_CHCFG_SOURCE_16 = 0x10
	// I2C0_Signal
	DMAMUX_CHCFG_SOURCE_18 = 0x12
	// I2C1_Signal
	DMAMUX_CHCFG_SOURCE_19 = 0x13
	// FTM0_Channel0_Signal
	DMAMUX_CHCFG_SOURCE_20 = 0x14
	// FTM0_Channel1_Signal
	DMAMUX_CHCFG_SOURCE_21 = 0x15
	// FTM0_Channel2_Signal
	DMAMUX_CHCFG_SOURCE_22 = 0x16
	// FTM0_Channel3_Signal
	DMAMUX_CHCFG_SOURCE_23 = 0x17
	// FTM0_Channel4_Signal
	DMAMUX_CHCFG_SOURCE_24 = 0x18
	// FTM0_Channel5_Signal
	DMAMUX_CHCFG_SOURCE_25 = 0x19
	// FTM0_Channel6_Signal
	DMAMUX_CHCFG_SOURCE_26 = 0x1a
	// FTM0_Channel7_Signal
	DMAMUX_CHCFG_SOURCE_27 = 0x1b
	// FTM1_Channel0_Signal
	DMAMUX_CHCFG_SOURCE_28 = 0x1c
	// FTM1_Channel1_Signal
	DMAMUX_CHCFG_SOURCE_29 = 0x1d
	// FTM2_Channel0_Signal
	DMAMUX_CHCFG_SOURCE_30 = 0x1e
	// FTM2_Channel1_Signal
	DMAMUX_CHCFG_SOURCE_31 = 0x1f
	// FTM3_Channel0_Signal
	DMAMUX_CHCFG_SOURCE_32 = 0x20
	// FTM3_Channel1_Signal
	DMAMUX_CHCFG_SOURCE_33 = 0x21
	// FTM3_Channel2_Signal
	DMAMUX_CHCFG_SOURCE_34 = 0x22
	// FTM3_Channel3_Signal
	DMAMUX_CHCFG_SOURCE_35 = 0x23
	// FTM3_Channel4_Signal
	DMAMUX_CHCFG_SOURCE_36 = 0x24
	// FTM3_Channel5_Signal
	DMAMUX_CHCFG_SOURCE_37 = 0x25
	// FTM3_Channel6_Signal
	DMAMUX_CHCFG_SOURCE_38 = 0x26
	// FTM3_Channel7_Signal
	DMAMUX_CHCFG_SOURCE_39 = 0x27
	// ADC0_Signal
	DMAMUX_CHCFG_SOURCE_40 = 0x28
	// ADC1_Signal
	DMAMUX_CHCFG_SOURCE_41 = 0x29
	// CMP0_Signal
	DMAMUX_CHCFG_SOURCE_42 = 0x2a
	// CMP1_Signal
	DMAMUX_CHCFG_SOURCE_43 = 0x2b
	// DAC0_Signal
	DMAMUX_CHCFG_SOURCE_45 = 0x2d
	// DAC1_Signal
	DMAMUX_CHCFG_SOURCE_46 = 0x2e
	// PDB_Signal
	DMAMUX_CHCFG_SOURCE_48 = 0x30
	// PortA_Signal
	DMAMUX_CHCFG_SOURCE_49 = 0x31
	// PortB_Signal
	DMAMUX_CHCFG_SOURCE_50 = 0x32
	// PortC_Signal
	DMAMUX_CHCFG_SOURCE_51 = 0x33
	// PortD_Signal
	DMAMUX_CHCFG_SOURCE_52 = 0x34
	// PortE_Signal
	DMAMUX_CHCFG_SOURCE_53 = 0x35
	// LPUART0_Rx_Signal
	DMAMUX_CHCFG_SOURCE_58 = 0x3a
	// LPUART0_Tx_Signal
	DMAMUX_CHCFG_SOURCE_59 = 0x3b
	// AlwaysOn60_Signal
	DMAMUX_CHCFG_SOURCE_60 = 0x3c
	// AlwaysOn61_Signal
	DMAMUX_CHCFG_SOURCE_61 = 0x3d
	// AlwaysOn62_Signal
	DMAMUX_CHCFG_SOURCE_62 = 0x3e
	// AlwaysOn63_Signal
	DMAMUX_CHCFG_SOURCE_63 = 0x3f
	// Position of TRIG field.
	DMAMUX_CHCFG_TRIG_Pos = 0x6
	// Bit mask of TRIG field.
	DMAMUX_CHCFG_TRIG_Msk = 0x40
	// Bit TRIG.
	DMAMUX_CHCFG_TRIG = 0x40
	// Triggering is disabled. If triggering is disabled and ENBL is set, the DMA Channel will simply route the specified source to the DMA channel. (Normal mode)
	DMAMUX_CHCFG_TRIG_0 = 0x0
	// Triggering is enabled. If triggering is enabled and ENBL is set, the DMAMUX is in Periodic Trigger mode.
	DMAMUX_CHCFG_TRIG_1 = 0x1
	// Position of ENBL field.
	DMAMUX_CHCFG_ENBL_Pos = 0x7
	// Bit mask of ENBL field.
	DMAMUX_CHCFG_ENBL_Msk = 0x80
	// Bit ENBL.
	DMAMUX_CHCFG_ENBL = 0x80
	// DMA channel is disabled. This mode is primarily used during configuration of the DMAMux. The DMA has separate channel enables/disables, which should be used to disable or reconfigure a DMA channel.
	DMAMUX_CHCFG_ENBL_0 = 0x0
	// DMA channel is enabled
	DMAMUX_CHCFG_ENBL_1 = 0x1
)

// Constants for FTM0: FlexTimer Module
const (
	// SC: Status And Control
	// Position of PS field.
	FTM_SC_PS_Pos = 0x0
	// Bit mask of PS field.
	FTM_SC_PS_Msk = 0x7
	// Divide by 1
	FTM_SC_PS_000 = 0x0
	// Divide by 2
	FTM_SC_PS_001 = 0x1
	// Divide by 4
	FTM_SC_PS_010 = 0x2
	// Divide by 8
	FTM_SC_PS_011 = 0x3
	// Divide by 16
	FTM_SC_PS_100 = 0x4
	// Divide by 32
	FTM_SC_PS_101 = 0x5
	// Divide by 64
	FTM_SC_PS_110 = 0x6
	// Divide by 128
	FTM_SC_PS_111 = 0x7
	// Position of CLKS field.
	FTM_SC_CLKS_Pos = 0x3
	// Bit mask of CLKS field.
	FTM_SC_CLKS_Msk = 0x18
	// No clock selected. This in effect disables the FTM counter.
	FTM_SC_CLKS_00 = 0x0
	// System clock
	FTM_SC_CLKS_01 = 0x1
	// Fixed frequency clock
	FTM_SC_CLKS_10 = 0x2
	// External clock
	FTM_SC_CLKS_11 = 0x3
	// Position of CPWMS field.
	FTM_SC_CPWMS_Pos = 0x5
	// Bit mask of CPWMS field.
	FTM_SC_CPWMS_Msk = 0x20
	// Bit CPWMS.
	FTM_SC_CPWMS = 0x20
	// FTM counter operates in Up Counting mode.
	FTM_SC_CPWMS_0 = 0x0
	// FTM counter operates in Up-Down Counting mode.
	FTM_SC_CPWMS_1 = 0x1
	// Position of TOIE field.
	FTM_SC_TOIE_Pos = 0x6
	// Bit mask of TOIE field.
	FTM_SC_TOIE_Msk = 0x40
	// Bit TOIE.
	FTM_SC_TOIE = 0x40
	// Disable TOF interrupts. Use software polling.
	FTM_SC_TOIE_0 = 0x0
	// Enable TOF interrupts. An interrupt is generated when TOF equals one.
	FTM_SC_TOIE_1 = 0x1
	// Position of TOF field.
	FTM_SC_TOF_Pos = 0x7
	// Bit mask of TOF field.
	FTM_SC_TOF_Msk = 0x80
	// Bit TOF.
	FTM_SC_TOF = 0x80
	// FTM counter has not overflowed.
	FTM_SC_TOF_0 = 0x0
	// FTM counter has overflowed.
	FTM_SC_TOF_1 = 0x1

	// CNT: Counter
	// Position of COUNT field.
	FTM_CNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	FTM_CNT_COUNT_Msk = 0xffff

	// MOD: Modulo
	// Position of MOD field.
	FTM_MOD_MOD_Pos = 0x0
	// Bit mask of MOD field.
	FTM_MOD_MOD_Msk = 0xffff

	// C0SC: Channel (n) Status And Control
	// Position of DMA field.
	FTM_CSC_DMA_Pos = 0x0
	// Bit mask of DMA field.
	FTM_CSC_DMA_Msk = 0x1
	// Bit DMA.
	FTM_CSC_DMA = 0x1
	// Disable DMA transfers.
	FTM_CSC_DMA_0 = 0x0
	// Enable DMA transfers.
	FTM_CSC_DMA_1 = 0x1
	// Position of ICRST field.
	FTM_CSC_ICRST_Pos = 0x1
	// Bit mask of ICRST field.
	FTM_CSC_ICRST_Msk = 0x2
	// Bit ICRST.
	FTM_CSC_ICRST = 0x2
	// FTM counter is not reset when the selected channel (n) input event is detected.
	FTM_CSC_ICRST_0 = 0x0
	// FTM counter is reset when the selected channel (n) input event is detected.
	FTM_CSC_ICRST_1 = 0x1
	// Position of ELSA field.
	FTM_CSC_ELSA_Pos = 0x2
	// Bit mask of ELSA field.
	FTM_CSC_ELSA_Msk = 0x4
	// Bit ELSA.
	FTM_CSC_ELSA = 0x4
	// Position of ELSB field.
	FTM_CSC_ELSB_Pos = 0x3
	// Bit mask of ELSB field.
	FTM_CSC_ELSB_Msk = 0x8
	// Bit ELSB.
	FTM_CSC_ELSB = 0x8
	// Position of MSA field.
	FTM_CSC_MSA_Pos = 0x4
	// Bit mask of MSA field.
	FTM_CSC_MSA_Msk = 0x10
	// Bit MSA.
	FTM_CSC_MSA = 0x10
	// Position of MSB field.
	FTM_CSC_MSB_Pos = 0x5
	// Bit mask of MSB field.
	FTM_CSC_MSB_Msk = 0x20
	// Bit MSB.
	FTM_CSC_MSB = 0x20
	// Position of CHIE field.
	FTM_CSC_CHIE_Pos = 0x6
	// Bit mask of CHIE field.
	FTM_CSC_CHIE_Msk = 0x40
	// Bit CHIE.
	FTM_CSC_CHIE = 0x40
	// Disable channel interrupts. Use software polling.
	FTM_CSC_CHIE_0 = 0x0
	// Enable channel interrupts.
	FTM_CSC_CHIE_1 = 0x1
	// Position of CHF field.
	FTM_CSC_CHF_Pos = 0x7
	// Bit mask of CHF field.
	FTM_CSC_CHF_Msk = 0x80
	// Bit CHF.
	FTM_CSC_CHF = 0x80
	// No channel event has occurred.
	FTM_CSC_CHF_0 = 0x0
	// A channel event has occurred.
	FTM_CSC_CHF_1 = 0x1

	// C0V: Channel (n) Value
	// Position of VAL field.
	FTM_CV_VAL_Pos = 0x0
	// Bit mask of VAL field.
	FTM_CV_VAL_Msk = 0xffff

	// CNTIN: Counter Initial Value
	// Position of INIT field.
	FTM_CNTIN_INIT_Pos = 0x0
	// Bit mask of INIT field.
	FTM_CNTIN_INIT_Msk = 0xffff

	// STATUS: Capture And Compare Status
	// Position of CH0F field.
	FTM_STATUS_CH0F_Pos = 0x0
	// Bit mask of CH0F field.
	FTM_STATUS_CH0F_Msk = 0x1
	// Bit CH0F.
	FTM_STATUS_CH0F = 0x1
	// No channel event has occurred.
	FTM_STATUS_CH0F_0 = 0x0
	// A channel event has occurred.
	FTM_STATUS_CH0F_1 = 0x1
	// Position of CH1F field.
	FTM_STATUS_CH1F_Pos = 0x1
	// Bit mask of CH1F field.
	FTM_STATUS_CH1F_Msk = 0x2
	// Bit CH1F.
	FTM_STATUS_CH1F = 0x2
	// No channel event has occurred.
	FTM_STATUS_CH1F_0 = 0x0
	// A channel event has occurred.
	FTM_STATUS_CH1F_1 = 0x1
	// Position of CH2F field.
	FTM_STATUS_CH2F_Pos = 0x2
	// Bit mask of CH2F field.
	FTM_STATUS_CH2F_Msk = 0x4
	// Bit CH2F.
	FTM_STATUS_CH2F = 0x4
	// No channel event has occurred.
	FTM_STATUS_CH2F_0 = 0x0
	// A channel event has occurred.
	FTM_STATUS_CH2F_1 = 0x1
	// Position of CH3F field.
	FTM_STATUS_CH3F_Pos = 0x3
	// Bit mask of CH3F field.
	FTM_STATUS_CH3F_Msk = 0x8
	// Bit CH3F.
	FTM_STATUS_CH3F = 0x8
	// No channel event has occurred.
	FTM_STATUS_CH3F_0 = 0x0
	// A channel event has occurred.
	FTM_STATUS_CH3F_1 = 0x1
	// Position of CH4F field.
	FTM_STATUS_CH4F_Pos = 0x4
	// Bit mask of CH4F field.
	FTM_STATUS_CH4F_Msk = 0x10
	// Bit CH4F.
	FTM_STATUS_CH4F = 0x10
	// No channel event has occurred.
	FTM_STATUS_CH4F_0 = 0x0
	// A channel event has occurred.
	FTM_STATUS_CH4F_1 = 0x1
	// Position of CH5F field.
	FTM_STATUS_CH5F_Pos = 0x5
	// Bit mask of CH5F field.
	FTM_STATUS_CH5F_Msk = 0x20
	// Bit CH5F.
	FTM_STATUS_CH5F = 0x20
	// No channel event has occurred.
	FTM_STATUS_CH5F_0 = 0x0
	// A channel event has occurred.
	FTM_STATUS_CH5F_1 = 0x1
	// Position of CH6F field.
	FTM_STATUS_CH6F_Pos = 0x6
	// Bit mask of CH6F field.
	FTM_STATUS_CH6F_Msk = 0x40
	// Bit CH6F.
	FTM_STATUS_CH6F = 0x40
	// No channel event has occurred.
	FTM_STATUS_CH6F_0 = 0x0
	// A channel event has occurred.
	FTM_STATUS_CH6F_1 = 0x1
	// Position of CH7F field.
	FTM_STATUS_CH7F_Pos = 0x7
	// Bit mask of CH7F field.
	FTM_STATUS_CH7F_Msk = 0x80
	// Bit CH7F.
	FTM_STATUS_CH7F = 0x80
	// No channel event has occurred.
	FTM_STATUS_CH7F_0 = 0x0
	// A channel event has occurred.
	FTM_STATUS_CH7F_1 = 0x1

	// MODE: Features Mode Selection
	// Position of FTMEN field.
	FTM_MODE_FTMEN_Pos = 0x0
	// Bit mask of FTMEN field.
	FTM_MODE_FTMEN_Msk = 0x1
	// Bit FTMEN.
	FTM_MODE_FTMEN = 0x1
	// Only the TPM-compatible registers (first set of registers) can be used without any restriction. Do not use the FTM-specific registers.
	FTM_MODE_FTMEN_0 = 0x0
	// All registers including the FTM-specific registers (second set of registers) are available for use with no restrictions.
	FTM_MODE_FTMEN_1 = 0x1
	// Position of INIT field.
	FTM_MODE_INIT_Pos = 0x1
	// Bit mask of INIT field.
	FTM_MODE_INIT_Msk = 0x2
	// Bit INIT.
	FTM_MODE_INIT = 0x2
	// Position of WPDIS field.
	FTM_MODE_WPDIS_Pos = 0x2
	// Bit mask of WPDIS field.
	FTM_MODE_WPDIS_Msk = 0x4
	// Bit WPDIS.
	FTM_MODE_WPDIS = 0x4
	// Write protection is enabled.
	FTM_MODE_WPDIS_0 = 0x0
	// Write protection is disabled.
	FTM_MODE_WPDIS_1 = 0x1
	// Position of PWMSYNC field.
	FTM_MODE_PWMSYNC_Pos = 0x3
	// Bit mask of PWMSYNC field.
	FTM_MODE_PWMSYNC_Msk = 0x8
	// Bit PWMSYNC.
	FTM_MODE_PWMSYNC = 0x8
	// No restrictions. Software and hardware triggers can be used by MOD, CnV, OUTMASK, and FTM counter synchronization.
	FTM_MODE_PWMSYNC_0 = 0x0
	// Software trigger can only be used by MOD and CnV synchronization, and hardware triggers can only be used by OUTMASK and FTM counter synchronization.
	FTM_MODE_PWMSYNC_1 = 0x1
	// Position of CAPTEST field.
	FTM_MODE_CAPTEST_Pos = 0x4
	// Bit mask of CAPTEST field.
	FTM_MODE_CAPTEST_Msk = 0x10
	// Bit CAPTEST.
	FTM_MODE_CAPTEST = 0x10
	// Capture test mode is disabled.
	FTM_MODE_CAPTEST_0 = 0x0
	// Capture test mode is enabled.
	FTM_MODE_CAPTEST_1 = 0x1
	// Position of FAULTM field.
	FTM_MODE_FAULTM_Pos = 0x5
	// Bit mask of FAULTM field.
	FTM_MODE_FAULTM_Msk = 0x60
	// Fault control is disabled for all channels.
	FTM_MODE_FAULTM_00 = 0x0
	// Fault control is enabled for even channels only (channels 0, 2, 4, and 6), and the selected mode is the manual fault clearing.
	FTM_MODE_FAULTM_01 = 0x1
	// Fault control is enabled for all channels, and the selected mode is the manual fault clearing.
	FTM_MODE_FAULTM_10 = 0x2
	// Fault control is enabled for all channels, and the selected mode is the automatic fault clearing.
	FTM_MODE_FAULTM_11 = 0x3
	// Position of FAULTIE field.
	FTM_MODE_FAULTIE_Pos = 0x7
	// Bit mask of FAULTIE field.
	FTM_MODE_FAULTIE_Msk = 0x80
	// Bit FAULTIE.
	FTM_MODE_FAULTIE = 0x80
	// Fault control interrupt is disabled.
	FTM_MODE_FAULTIE_0 = 0x0
	// Fault control interrupt is enabled.
	FTM_MODE_FAULTIE_1 = 0x1

	// SYNC: Synchronization
	// Position of CNTMIN field.
	FTM_SYNC_CNTMIN_Pos = 0x0
	// Bit mask of CNTMIN field.
	FTM_SYNC_CNTMIN_Msk = 0x1
	// Bit CNTMIN.
	FTM_SYNC_CNTMIN = 0x1
	// The minimum loading point is disabled.
	FTM_SYNC_CNTMIN_0 = 0x0
	// The minimum loading point is enabled.
	FTM_SYNC_CNTMIN_1 = 0x1
	// Position of CNTMAX field.
	FTM_SYNC_CNTMAX_Pos = 0x1
	// Bit mask of CNTMAX field.
	FTM_SYNC_CNTMAX_Msk = 0x2
	// Bit CNTMAX.
	FTM_SYNC_CNTMAX = 0x2
	// The maximum loading point is disabled.
	FTM_SYNC_CNTMAX_0 = 0x0
	// The maximum loading point is enabled.
	FTM_SYNC_CNTMAX_1 = 0x1
	// Position of REINIT field.
	FTM_SYNC_REINIT_Pos = 0x2
	// Bit mask of REINIT field.
	FTM_SYNC_REINIT_Msk = 0x4
	// Bit REINIT.
	FTM_SYNC_REINIT = 0x4
	// FTM counter continues to count normally.
	FTM_SYNC_REINIT_0 = 0x0
	// FTM counter is updated with its initial value when the selected trigger is detected.
	FTM_SYNC_REINIT_1 = 0x1
	// Position of SYNCHOM field.
	FTM_SYNC_SYNCHOM_Pos = 0x3
	// Bit mask of SYNCHOM field.
	FTM_SYNC_SYNCHOM_Msk = 0x8
	// Bit SYNCHOM.
	FTM_SYNC_SYNCHOM = 0x8
	// OUTMASK register is updated with the value of its buffer in all rising edges of the system clock.
	FTM_SYNC_SYNCHOM_0 = 0x0
	// OUTMASK register is updated with the value of its buffer only by the PWM synchronization.
	FTM_SYNC_SYNCHOM_1 = 0x1
	// Position of TRIG0 field.
	FTM_SYNC_TRIG0_Pos = 0x4
	// Bit mask of TRIG0 field.
	FTM_SYNC_TRIG0_Msk = 0x10
	// Bit TRIG0.
	FTM_SYNC_TRIG0 = 0x10
	// Trigger is disabled.
	FTM_SYNC_TRIG0_0 = 0x0
	// Trigger is enabled.
	FTM_SYNC_TRIG0_1 = 0x1
	// Position of TRIG1 field.
	FTM_SYNC_TRIG1_Pos = 0x5
	// Bit mask of TRIG1 field.
	FTM_SYNC_TRIG1_Msk = 0x20
	// Bit TRIG1.
	FTM_SYNC_TRIG1 = 0x20
	// Trigger is disabled.
	FTM_SYNC_TRIG1_0 = 0x0
	// Trigger is enabled.
	FTM_SYNC_TRIG1_1 = 0x1
	// Position of TRIG2 field.
	FTM_SYNC_TRIG2_Pos = 0x6
	// Bit mask of TRIG2 field.
	FTM_SYNC_TRIG2_Msk = 0x40
	// Bit TRIG2.
	FTM_SYNC_TRIG2 = 0x40
	// Trigger is disabled.
	FTM_SYNC_TRIG2_0 = 0x0
	// Trigger is enabled.
	FTM_SYNC_TRIG2_1 = 0x1
	// Position of SWSYNC field.
	FTM_SYNC_SWSYNC_Pos = 0x7
	// Bit mask of SWSYNC field.
	FTM_SYNC_SWSYNC_Msk = 0x80
	// Bit SWSYNC.
	FTM_SYNC_SWSYNC = 0x80
	// Software trigger is not selected.
	FTM_SYNC_SWSYNC_0 = 0x0
	// Software trigger is selected.
	FTM_SYNC_SWSYNC_1 = 0x1

	// OUTINIT: Initial State For Channels Output
	// Position of CH0OI field.
	FTM_OUTINIT_CH0OI_Pos = 0x0
	// Bit mask of CH0OI field.
	FTM_OUTINIT_CH0OI_Msk = 0x1
	// Bit CH0OI.
	FTM_OUTINIT_CH0OI = 0x1
	// The initialization value is 0.
	FTM_OUTINIT_CH0OI_0 = 0x0
	// The initialization value is 1.
	FTM_OUTINIT_CH0OI_1 = 0x1
	// Position of CH1OI field.
	FTM_OUTINIT_CH1OI_Pos = 0x1
	// Bit mask of CH1OI field.
	FTM_OUTINIT_CH1OI_Msk = 0x2
	// Bit CH1OI.
	FTM_OUTINIT_CH1OI = 0x2
	// The initialization value is 0.
	FTM_OUTINIT_CH1OI_0 = 0x0
	// The initialization value is 1.
	FTM_OUTINIT_CH1OI_1 = 0x1
	// Position of CH2OI field.
	FTM_OUTINIT_CH2OI_Pos = 0x2
	// Bit mask of CH2OI field.
	FTM_OUTINIT_CH2OI_Msk = 0x4
	// Bit CH2OI.
	FTM_OUTINIT_CH2OI = 0x4
	// The initialization value is 0.
	FTM_OUTINIT_CH2OI_0 = 0x0
	// The initialization value is 1.
	FTM_OUTINIT_CH2OI_1 = 0x1
	// Position of CH3OI field.
	FTM_OUTINIT_CH3OI_Pos = 0x3
	// Bit mask of CH3OI field.
	FTM_OUTINIT_CH3OI_Msk = 0x8
	// Bit CH3OI.
	FTM_OUTINIT_CH3OI = 0x8
	// The initialization value is 0.
	FTM_OUTINIT_CH3OI_0 = 0x0
	// The initialization value is 1.
	FTM_OUTINIT_CH3OI_1 = 0x1
	// Position of CH4OI field.
	FTM_OUTINIT_CH4OI_Pos = 0x4
	// Bit mask of CH4OI field.
	FTM_OUTINIT_CH4OI_Msk = 0x10
	// Bit CH4OI.
	FTM_OUTINIT_CH4OI = 0x10
	// The initialization value is 0.
	FTM_OUTINIT_CH4OI_0 = 0x0
	// The initialization value is 1.
	FTM_OUTINIT_CH4OI_1 = 0x1
	// Position of CH5OI field.
	FTM_OUTINIT_CH5OI_Pos = 0x5
	// Bit mask of CH5OI field.
	FTM_OUTINIT_CH5OI_Msk = 0x20
	// Bit CH5OI.
	FTM_OUTINIT_CH5OI = 0x20
	// The initialization value is 0.
	FTM_OUTINIT_CH5OI_0 = 0x0
	// The initialization value is 1.
	FTM_OUTINIT_CH5OI_1 = 0x1
	// Position of CH6OI field.
	FTM_OUTINIT_CH6OI_Pos = 0x6
	// Bit mask of CH6OI field.
	FTM_OUTINIT_CH6OI_Msk = 0x40
	// Bit CH6OI.
	FTM_OUTINIT_CH6OI = 0x40
	// The initialization value is 0.
	FTM_OUTINIT_CH6OI_0 = 0x0
	// The initialization value is 1.
	FTM_OUTINIT_CH6OI_1 = 0x1
	// Position of CH7OI field.
	FTM_OUTINIT_CH7OI_Pos = 0x7
	// Bit mask of CH7OI field.
	FTM_OUTINIT_CH7OI_Msk = 0x80
	// Bit CH7OI.
	FTM_OUTINIT_CH7OI = 0x80
	// The initialization value is 0.
	FTM_OUTINIT_CH7OI_0 = 0x0
	// The initialization value is 1.
	FTM_OUTINIT_CH7OI_1 = 0x1

	// OUTMASK: Output Mask
	// Position of CH0OM field.
	FTM_OUTMASK_CH0OM_Pos = 0x0
	// Bit mask of CH0OM field.
	FTM_OUTMASK_CH0OM_Msk = 0x1
	// Bit CH0OM.
	FTM_OUTMASK_CH0OM = 0x1
	// Channel output is not masked. It continues to operate normally.
	FTM_OUTMASK_CH0OM_0 = 0x0
	// Channel output is masked. It is forced to its inactive state.
	FTM_OUTMASK_CH0OM_1 = 0x1
	// Position of CH1OM field.
	FTM_OUTMASK_CH1OM_Pos = 0x1
	// Bit mask of CH1OM field.
	FTM_OUTMASK_CH1OM_Msk = 0x2
	// Bit CH1OM.
	FTM_OUTMASK_CH1OM = 0x2
	// Channel output is not masked. It continues to operate normally.
	FTM_OUTMASK_CH1OM_0 = 0x0
	// Channel output is masked. It is forced to its inactive state.
	FTM_OUTMASK_CH1OM_1 = 0x1
	// Position of CH2OM field.
	FTM_OUTMASK_CH2OM_Pos = 0x2
	// Bit mask of CH2OM field.
	FTM_OUTMASK_CH2OM_Msk = 0x4
	// Bit CH2OM.
	FTM_OUTMASK_CH2OM = 0x4
	// Channel output is not masked. It continues to operate normally.
	FTM_OUTMASK_CH2OM_0 = 0x0
	// Channel output is masked. It is forced to its inactive state.
	FTM_OUTMASK_CH2OM_1 = 0x1
	// Position of CH3OM field.
	FTM_OUTMASK_CH3OM_Pos = 0x3
	// Bit mask of CH3OM field.
	FTM_OUTMASK_CH3OM_Msk = 0x8
	// Bit CH3OM.
	FTM_OUTMASK_CH3OM = 0x8
	// Channel output is not masked. It continues to operate normally.
	FTM_OUTMASK_CH3OM_0 = 0x0
	// Channel output is masked. It is forced to its inactive state.
	FTM_OUTMASK_CH3OM_1 = 0x1
	// Position of CH4OM field.
	FTM_OUTMASK_CH4OM_Pos = 0x4
	// Bit mask of CH4OM field.
	FTM_OUTMASK_CH4OM_Msk = 0x10
	// Bit CH4OM.
	FTM_OUTMASK_CH4OM = 0x10
	// Channel output is not masked. It continues to operate normally.
	FTM_OUTMASK_CH4OM_0 = 0x0
	// Channel output is masked. It is forced to its inactive state.
	FTM_OUTMASK_CH4OM_1 = 0x1
	// Position of CH5OM field.
	FTM_OUTMASK_CH5OM_Pos = 0x5
	// Bit mask of CH5OM field.
	FTM_OUTMASK_CH5OM_Msk = 0x20
	// Bit CH5OM.
	FTM_OUTMASK_CH5OM = 0x20
	// Channel output is not masked. It continues to operate normally.
	FTM_OUTMASK_CH5OM_0 = 0x0
	// Channel output is masked. It is forced to its inactive state.
	FTM_OUTMASK_CH5OM_1 = 0x1
	// Position of CH6OM field.
	FTM_OUTMASK_CH6OM_Pos = 0x6
	// Bit mask of CH6OM field.
	FTM_OUTMASK_CH6OM_Msk = 0x40
	// Bit CH6OM.
	FTM_OUTMASK_CH6OM = 0x40
	// Channel output is not masked. It continues to operate normally.
	FTM_OUTMASK_CH6OM_0 = 0x0
	// Channel output is masked. It is forced to its inactive state.
	FTM_OUTMASK_CH6OM_1 = 0x1
	// Position of CH7OM field.
	FTM_OUTMASK_CH7OM_Pos = 0x7
	// Bit mask of CH7OM field.
	FTM_OUTMASK_CH7OM_Msk = 0x80
	// Bit CH7OM.
	FTM_OUTMASK_CH7OM = 0x80
	// Channel output is not masked. It continues to operate normally.
	FTM_OUTMASK_CH7OM_0 = 0x0
	// Channel output is masked. It is forced to its inactive state.
	FTM_OUTMASK_CH7OM_1 = 0x1

	// COMBINE: Function For Linked Channels
	// Position of COMBINE0 field.
	FTM_COMBINE_COMBINE0_Pos = 0x0
	// Bit mask of COMBINE0 field.
	FTM_COMBINE_COMBINE0_Msk = 0x1
	// Bit COMBINE0.
	FTM_COMBINE_COMBINE0 = 0x1
	// Channels (n) and (n+1) are independent.
	FTM_COMBINE_COMBINE0_0 = 0x0
	// Channels (n) and (n+1) are combined.
	FTM_COMBINE_COMBINE0_1 = 0x1
	// Position of COMP0 field.
	FTM_COMBINE_COMP0_Pos = 0x1
	// Bit mask of COMP0 field.
	FTM_COMBINE_COMP0_Msk = 0x2
	// Bit COMP0.
	FTM_COMBINE_COMP0 = 0x2
	// The channel (n+1) output is the same as the channel (n) output.
	FTM_COMBINE_COMP0_0 = 0x0
	// The channel (n+1) output is the complement of the channel (n) output.
	FTM_COMBINE_COMP0_1 = 0x1
	// Position of DECAPEN0 field.
	FTM_COMBINE_DECAPEN0_Pos = 0x2
	// Bit mask of DECAPEN0 field.
	FTM_COMBINE_DECAPEN0_Msk = 0x4
	// Bit DECAPEN0.
	FTM_COMBINE_DECAPEN0 = 0x4
	// The Dual Edge Capture mode in this pair of channels is disabled.
	FTM_COMBINE_DECAPEN0_0 = 0x0
	// The Dual Edge Capture mode in this pair of channels is enabled.
	FTM_COMBINE_DECAPEN0_1 = 0x1
	// Position of DECAP0 field.
	FTM_COMBINE_DECAP0_Pos = 0x3
	// Bit mask of DECAP0 field.
	FTM_COMBINE_DECAP0_Msk = 0x8
	// Bit DECAP0.
	FTM_COMBINE_DECAP0 = 0x8
	// The dual edge captures are inactive.
	FTM_COMBINE_DECAP0_0 = 0x0
	// The dual edge captures are active.
	FTM_COMBINE_DECAP0_1 = 0x1
	// Position of DTEN0 field.
	FTM_COMBINE_DTEN0_Pos = 0x4
	// Bit mask of DTEN0 field.
	FTM_COMBINE_DTEN0_Msk = 0x10
	// Bit DTEN0.
	FTM_COMBINE_DTEN0 = 0x10
	// The deadtime insertion in this pair of channels is disabled.
	FTM_COMBINE_DTEN0_0 = 0x0
	// The deadtime insertion in this pair of channels is enabled.
	FTM_COMBINE_DTEN0_1 = 0x1
	// Position of SYNCEN0 field.
	FTM_COMBINE_SYNCEN0_Pos = 0x5
	// Bit mask of SYNCEN0 field.
	FTM_COMBINE_SYNCEN0_Msk = 0x20
	// Bit SYNCEN0.
	FTM_COMBINE_SYNCEN0 = 0x20
	// The PWM synchronization in this pair of channels is disabled.
	FTM_COMBINE_SYNCEN0_0 = 0x0
	// The PWM synchronization in this pair of channels is enabled.
	FTM_COMBINE_SYNCEN0_1 = 0x1
	// Position of FAULTEN0 field.
	FTM_COMBINE_FAULTEN0_Pos = 0x6
	// Bit mask of FAULTEN0 field.
	FTM_COMBINE_FAULTEN0_Msk = 0x40
	// Bit FAULTEN0.
	FTM_COMBINE_FAULTEN0 = 0x40
	// The fault control in this pair of channels is disabled.
	FTM_COMBINE_FAULTEN0_0 = 0x0
	// The fault control in this pair of channels is enabled.
	FTM_COMBINE_FAULTEN0_1 = 0x1
	// Position of COMBINE1 field.
	FTM_COMBINE_COMBINE1_Pos = 0x8
	// Bit mask of COMBINE1 field.
	FTM_COMBINE_COMBINE1_Msk = 0x100
	// Bit COMBINE1.
	FTM_COMBINE_COMBINE1 = 0x100
	// Channels (n) and (n+1) are independent.
	FTM_COMBINE_COMBINE1_0 = 0x0
	// Channels (n) and (n+1) are combined.
	FTM_COMBINE_COMBINE1_1 = 0x1
	// Position of COMP1 field.
	FTM_COMBINE_COMP1_Pos = 0x9
	// Bit mask of COMP1 field.
	FTM_COMBINE_COMP1_Msk = 0x200
	// Bit COMP1.
	FTM_COMBINE_COMP1 = 0x200
	// The channel (n+1) output is the same as the channel (n) output.
	FTM_COMBINE_COMP1_0 = 0x0
	// The channel (n+1) output is the complement of the channel (n) output.
	FTM_COMBINE_COMP1_1 = 0x1
	// Position of DECAPEN1 field.
	FTM_COMBINE_DECAPEN1_Pos = 0xa
	// Bit mask of DECAPEN1 field.
	FTM_COMBINE_DECAPEN1_Msk = 0x400
	// Bit DECAPEN1.
	FTM_COMBINE_DECAPEN1 = 0x400
	// The Dual Edge Capture mode in this pair of channels is disabled.
	FTM_COMBINE_DECAPEN1_0 = 0x0
	// The Dual Edge Capture mode in this pair of channels is enabled.
	FTM_COMBINE_DECAPEN1_1 = 0x1
	// Position of DECAP1 field.
	FTM_COMBINE_DECAP1_Pos = 0xb
	// Bit mask of DECAP1 field.
	FTM_COMBINE_DECAP1_Msk = 0x800
	// Bit DECAP1.
	FTM_COMBINE_DECAP1 = 0x800
	// The dual edge captures are inactive.
	FTM_COMBINE_DECAP1_0 = 0x0
	// The dual edge captures are active.
	FTM_COMBINE_DECAP1_1 = 0x1
	// Position of DTEN1 field.
	FTM_COMBINE_DTEN1_Pos = 0xc
	// Bit mask of DTEN1 field.
	FTM_COMBINE_DTEN1_Msk = 0x1000
	// Bit DTEN1.
	FTM_COMBINE_DTEN1 = 0x1000
	// The deadtime insertion in this pair of channels is disabled.
	FTM_COMBINE_DTEN1_0 = 0x0
	// The deadtime insertion in this pair of channels is enabled.
	FTM_COMBINE_DTEN1_1 = 0x1
	// Position of SYNCEN1 field.
	FTM_COMBINE_SYNCEN1_Pos = 0xd
	// Bit mask of SYNCEN1 field.
	FTM_COMBINE_SYNCEN1_Msk = 0x2000
	// Bit SYNCEN1.
	FTM_COMBINE_SYNCEN1 = 0x2000
	// The PWM synchronization in this pair of channels is disabled.
	FTM_COMBINE_SYNCEN1_0 = 0x0
	// The PWM synchronization in this pair of channels is enabled.
	FTM_COMBINE_SYNCEN1_1 = 0x1
	// Position of FAULTEN1 field.
	FTM_COMBINE_FAULTEN1_Pos = 0xe
	// Bit mask of FAULTEN1 field.
	FTM_COMBINE_FAULTEN1_Msk = 0x4000
	// Bit FAULTEN1.
	FTM_COMBINE_FAULTEN1 = 0x4000
	// The fault control in this pair of channels is disabled.
	FTM_COMBINE_FAULTEN1_0 = 0x0
	// The fault control in this pair of channels is enabled.
	FTM_COMBINE_FAULTEN1_1 = 0x1
	// Position of COMBINE2 field.
	FTM_COMBINE_COMBINE2_Pos = 0x10
	// Bit mask of COMBINE2 field.
	FTM_COMBINE_COMBINE2_Msk = 0x10000
	// Bit COMBINE2.
	FTM_COMBINE_COMBINE2 = 0x10000
	// Channels (n) and (n+1) are independent.
	FTM_COMBINE_COMBINE2_0 = 0x0
	// Channels (n) and (n+1) are combined.
	FTM_COMBINE_COMBINE2_1 = 0x1
	// Position of COMP2 field.
	FTM_COMBINE_COMP2_Pos = 0x11
	// Bit mask of COMP2 field.
	FTM_COMBINE_COMP2_Msk = 0x20000
	// Bit COMP2.
	FTM_COMBINE_COMP2 = 0x20000
	// The channel (n+1) output is the same as the channel (n) output.
	FTM_COMBINE_COMP2_0 = 0x0
	// The channel (n+1) output is the complement of the channel (n) output.
	FTM_COMBINE_COMP2_1 = 0x1
	// Position of DECAPEN2 field.
	FTM_COMBINE_DECAPEN2_Pos = 0x12
	// Bit mask of DECAPEN2 field.
	FTM_COMBINE_DECAPEN2_Msk = 0x40000
	// Bit DECAPEN2.
	FTM_COMBINE_DECAPEN2 = 0x40000
	// The Dual Edge Capture mode in this pair of channels is disabled.
	FTM_COMBINE_DECAPEN2_0 = 0x0
	// The Dual Edge Capture mode in this pair of channels is enabled.
	FTM_COMBINE_DECAPEN2_1 = 0x1
	// Position of DECAP2 field.
	FTM_COMBINE_DECAP2_Pos = 0x13
	// Bit mask of DECAP2 field.
	FTM_COMBINE_DECAP2_Msk = 0x80000
	// Bit DECAP2.
	FTM_COMBINE_DECAP2 = 0x80000
	// The dual edge captures are inactive.
	FTM_COMBINE_DECAP2_0 = 0x0
	// The dual edge captures are active.
	FTM_COMBINE_DECAP2_1 = 0x1
	// Position of DTEN2 field.
	FTM_COMBINE_DTEN2_Pos = 0x14
	// Bit mask of DTEN2 field.
	FTM_COMBINE_DTEN2_Msk = 0x100000
	// Bit DTEN2.
	FTM_COMBINE_DTEN2 = 0x100000
	// The deadtime insertion in this pair of channels is disabled.
	FTM_COMBINE_DTEN2_0 = 0x0
	// The deadtime insertion in this pair of channels is enabled.
	FTM_COMBINE_DTEN2_1 = 0x1
	// Position of SYNCEN2 field.
	FTM_COMBINE_SYNCEN2_Pos = 0x15
	// Bit mask of SYNCEN2 field.
	FTM_COMBINE_SYNCEN2_Msk = 0x200000
	// Bit SYNCEN2.
	FTM_COMBINE_SYNCEN2 = 0x200000
	// The PWM synchronization in this pair of channels is disabled.
	FTM_COMBINE_SYNCEN2_0 = 0x0
	// The PWM synchronization in this pair of channels is enabled.
	FTM_COMBINE_SYNCEN2_1 = 0x1
	// Position of FAULTEN2 field.
	FTM_COMBINE_FAULTEN2_Pos = 0x16
	// Bit mask of FAULTEN2 field.
	FTM_COMBINE_FAULTEN2_Msk = 0x400000
	// Bit FAULTEN2.
	FTM_COMBINE_FAULTEN2 = 0x400000
	// The fault control in this pair of channels is disabled.
	FTM_COMBINE_FAULTEN2_0 = 0x0
	// The fault control in this pair of channels is enabled.
	FTM_COMBINE_FAULTEN2_1 = 0x1
	// Position of COMBINE3 field.
	FTM_COMBINE_COMBINE3_Pos = 0x18
	// Bit mask of COMBINE3 field.
	FTM_COMBINE_COMBINE3_Msk = 0x1000000
	// Bit COMBINE3.
	FTM_COMBINE_COMBINE3 = 0x1000000
	// Channels (n) and (n+1) are independent.
	FTM_COMBINE_COMBINE3_0 = 0x0
	// Channels (n) and (n+1) are combined.
	FTM_COMBINE_COMBINE3_1 = 0x1
	// Position of COMP3 field.
	FTM_COMBINE_COMP3_Pos = 0x19
	// Bit mask of COMP3 field.
	FTM_COMBINE_COMP3_Msk = 0x2000000
	// Bit COMP3.
	FTM_COMBINE_COMP3 = 0x2000000
	// The channel (n+1) output is the same as the channel (n) output.
	FTM_COMBINE_COMP3_0 = 0x0
	// The channel (n+1) output is the complement of the channel (n) output.
	FTM_COMBINE_COMP3_1 = 0x1
	// Position of DECAPEN3 field.
	FTM_COMBINE_DECAPEN3_Pos = 0x1a
	// Bit mask of DECAPEN3 field.
	FTM_COMBINE_DECAPEN3_Msk = 0x4000000
	// Bit DECAPEN3.
	FTM_COMBINE_DECAPEN3 = 0x4000000
	// The Dual Edge Capture mode in this pair of channels is disabled.
	FTM_COMBINE_DECAPEN3_0 = 0x0
	// The Dual Edge Capture mode in this pair of channels is enabled.
	FTM_COMBINE_DECAPEN3_1 = 0x1
	// Position of DECAP3 field.
	FTM_COMBINE_DECAP3_Pos = 0x1b
	// Bit mask of DECAP3 field.
	FTM_COMBINE_DECAP3_Msk = 0x8000000
	// Bit DECAP3.
	FTM_COMBINE_DECAP3 = 0x8000000
	// The dual edge captures are inactive.
	FTM_COMBINE_DECAP3_0 = 0x0
	// The dual edge captures are active.
	FTM_COMBINE_DECAP3_1 = 0x1
	// Position of DTEN3 field.
	FTM_COMBINE_DTEN3_Pos = 0x1c
	// Bit mask of DTEN3 field.
	FTM_COMBINE_DTEN3_Msk = 0x10000000
	// Bit DTEN3.
	FTM_COMBINE_DTEN3 = 0x10000000
	// The deadtime insertion in this pair of channels is disabled.
	FTM_COMBINE_DTEN3_0 = 0x0
	// The deadtime insertion in this pair of channels is enabled.
	FTM_COMBINE_DTEN3_1 = 0x1
	// Position of SYNCEN3 field.
	FTM_COMBINE_SYNCEN3_Pos = 0x1d
	// Bit mask of SYNCEN3 field.
	FTM_COMBINE_SYNCEN3_Msk = 0x20000000
	// Bit SYNCEN3.
	FTM_COMBINE_SYNCEN3 = 0x20000000
	// The PWM synchronization in this pair of channels is disabled.
	FTM_COMBINE_SYNCEN3_0 = 0x0
	// The PWM synchronization in this pair of channels is enabled.
	FTM_COMBINE_SYNCEN3_1 = 0x1
	// Position of FAULTEN3 field.
	FTM_COMBINE_FAULTEN3_Pos = 0x1e
	// Bit mask of FAULTEN3 field.
	FTM_COMBINE_FAULTEN3_Msk = 0x40000000
	// Bit FAULTEN3.
	FTM_COMBINE_FAULTEN3 = 0x40000000
	// The fault control in this pair of channels is disabled.
	FTM_COMBINE_FAULTEN3_0 = 0x0
	// The fault control in this pair of channels is enabled.
	FTM_COMBINE_FAULTEN3_1 = 0x1

	// DEADTIME: Deadtime Insertion Control
	// Position of DTVAL field.
	FTM_DEADTIME_DTVAL_Pos = 0x0
	// Bit mask of DTVAL field.
	FTM_DEADTIME_DTVAL_Msk = 0x3f
	// Position of DTPS field.
	FTM_DEADTIME_DTPS_Pos = 0x6
	// Bit mask of DTPS field.
	FTM_DEADTIME_DTPS_Msk = 0xc0
	// Divide the system clock by 4.
	FTM_DEADTIME_DTPS_10 = 0x2
	// Divide the system clock by 16.
	FTM_DEADTIME_DTPS_11 = 0x3

	// EXTTRIG: FTM External Trigger
	// Position of CH2TRIG field.
	FTM_EXTTRIG_CH2TRIG_Pos = 0x0
	// Bit mask of CH2TRIG field.
	FTM_EXTTRIG_CH2TRIG_Msk = 0x1
	// Bit CH2TRIG.
	FTM_EXTTRIG_CH2TRIG = 0x1
	// The generation of the channel trigger is disabled.
	FTM_EXTTRIG_CH2TRIG_0 = 0x0
	// The generation of the channel trigger is enabled.
	FTM_EXTTRIG_CH2TRIG_1 = 0x1
	// Position of CH3TRIG field.
	FTM_EXTTRIG_CH3TRIG_Pos = 0x1
	// Bit mask of CH3TRIG field.
	FTM_EXTTRIG_CH3TRIG_Msk = 0x2
	// Bit CH3TRIG.
	FTM_EXTTRIG_CH3TRIG = 0x2
	// The generation of the channel trigger is disabled.
	FTM_EXTTRIG_CH3TRIG_0 = 0x0
	// The generation of the channel trigger is enabled.
	FTM_EXTTRIG_CH3TRIG_1 = 0x1
	// Position of CH4TRIG field.
	FTM_EXTTRIG_CH4TRIG_Pos = 0x2
	// Bit mask of CH4TRIG field.
	FTM_EXTTRIG_CH4TRIG_Msk = 0x4
	// Bit CH4TRIG.
	FTM_EXTTRIG_CH4TRIG = 0x4
	// The generation of the channel trigger is disabled.
	FTM_EXTTRIG_CH4TRIG_0 = 0x0
	// The generation of the channel trigger is enabled.
	FTM_EXTTRIG_CH4TRIG_1 = 0x1
	// Position of CH5TRIG field.
	FTM_EXTTRIG_CH5TRIG_Pos = 0x3
	// Bit mask of CH5TRIG field.
	FTM_EXTTRIG_CH5TRIG_Msk = 0x8
	// Bit CH5TRIG.
	FTM_EXTTRIG_CH5TRIG = 0x8
	// The generation of the channel trigger is disabled.
	FTM_EXTTRIG_CH5TRIG_0 = 0x0
	// The generation of the channel trigger is enabled.
	FTM_EXTTRIG_CH5TRIG_1 = 0x1
	// Position of CH0TRIG field.
	FTM_EXTTRIG_CH0TRIG_Pos = 0x4
	// Bit mask of CH0TRIG field.
	FTM_EXTTRIG_CH0TRIG_Msk = 0x10
	// Bit CH0TRIG.
	FTM_EXTTRIG_CH0TRIG = 0x10
	// The generation of the channel trigger is disabled.
	FTM_EXTTRIG_CH0TRIG_0 = 0x0
	// The generation of the channel trigger is enabled.
	FTM_EXTTRIG_CH0TRIG_1 = 0x1
	// Position of CH1TRIG field.
	FTM_EXTTRIG_CH1TRIG_Pos = 0x5
	// Bit mask of CH1TRIG field.
	FTM_EXTTRIG_CH1TRIG_Msk = 0x20
	// Bit CH1TRIG.
	FTM_EXTTRIG_CH1TRIG = 0x20
	// The generation of the channel trigger is disabled.
	FTM_EXTTRIG_CH1TRIG_0 = 0x0
	// The generation of the channel trigger is enabled.
	FTM_EXTTRIG_CH1TRIG_1 = 0x1
	// Position of INITTRIGEN field.
	FTM_EXTTRIG_INITTRIGEN_Pos = 0x6
	// Bit mask of INITTRIGEN field.
	FTM_EXTTRIG_INITTRIGEN_Msk = 0x40
	// Bit INITTRIGEN.
	FTM_EXTTRIG_INITTRIGEN = 0x40
	// The generation of initialization trigger is disabled.
	FTM_EXTTRIG_INITTRIGEN_0 = 0x0
	// The generation of initialization trigger is enabled.
	FTM_EXTTRIG_INITTRIGEN_1 = 0x1
	// Position of TRIGF field.
	FTM_EXTTRIG_TRIGF_Pos = 0x7
	// Bit mask of TRIGF field.
	FTM_EXTTRIG_TRIGF_Msk = 0x80
	// Bit TRIGF.
	FTM_EXTTRIG_TRIGF = 0x80
	// No channel trigger was generated.
	FTM_EXTTRIG_TRIGF_0 = 0x0
	// A channel trigger was generated.
	FTM_EXTTRIG_TRIGF_1 = 0x1

	// POL: Channels Polarity
	// Position of POL0 field.
	FTM_POL_POL0_Pos = 0x0
	// Bit mask of POL0 field.
	FTM_POL_POL0_Msk = 0x1
	// Bit POL0.
	FTM_POL_POL0 = 0x1
	// The channel polarity is active high.
	FTM_POL_POL0_0 = 0x0
	// The channel polarity is active low.
	FTM_POL_POL0_1 = 0x1
	// Position of POL1 field.
	FTM_POL_POL1_Pos = 0x1
	// Bit mask of POL1 field.
	FTM_POL_POL1_Msk = 0x2
	// Bit POL1.
	FTM_POL_POL1 = 0x2
	// The channel polarity is active high.
	FTM_POL_POL1_0 = 0x0
	// The channel polarity is active low.
	FTM_POL_POL1_1 = 0x1
	// Position of POL2 field.
	FTM_POL_POL2_Pos = 0x2
	// Bit mask of POL2 field.
	FTM_POL_POL2_Msk = 0x4
	// Bit POL2.
	FTM_POL_POL2 = 0x4
	// The channel polarity is active high.
	FTM_POL_POL2_0 = 0x0
	// The channel polarity is active low.
	FTM_POL_POL2_1 = 0x1
	// Position of POL3 field.
	FTM_POL_POL3_Pos = 0x3
	// Bit mask of POL3 field.
	FTM_POL_POL3_Msk = 0x8
	// Bit POL3.
	FTM_POL_POL3 = 0x8
	// The channel polarity is active high.
	FTM_POL_POL3_0 = 0x0
	// The channel polarity is active low.
	FTM_POL_POL3_1 = 0x1
	// Position of POL4 field.
	FTM_POL_POL4_Pos = 0x4
	// Bit mask of POL4 field.
	FTM_POL_POL4_Msk = 0x10
	// Bit POL4.
	FTM_POL_POL4 = 0x10
	// The channel polarity is active high.
	FTM_POL_POL4_0 = 0x0
	// The channel polarity is active low.
	FTM_POL_POL4_1 = 0x1
	// Position of POL5 field.
	FTM_POL_POL5_Pos = 0x5
	// Bit mask of POL5 field.
	FTM_POL_POL5_Msk = 0x20
	// Bit POL5.
	FTM_POL_POL5 = 0x20
	// The channel polarity is active high.
	FTM_POL_POL5_0 = 0x0
	// The channel polarity is active low.
	FTM_POL_POL5_1 = 0x1
	// Position of POL6 field.
	FTM_POL_POL6_Pos = 0x6
	// Bit mask of POL6 field.
	FTM_POL_POL6_Msk = 0x40
	// Bit POL6.
	FTM_POL_POL6 = 0x40
	// The channel polarity is active high.
	FTM_POL_POL6_0 = 0x0
	// The channel polarity is active low.
	FTM_POL_POL6_1 = 0x1
	// Position of POL7 field.
	FTM_POL_POL7_Pos = 0x7
	// Bit mask of POL7 field.
	FTM_POL_POL7_Msk = 0x80
	// Bit POL7.
	FTM_POL_POL7 = 0x80
	// The channel polarity is active high.
	FTM_POL_POL7_0 = 0x0
	// The channel polarity is active low.
	FTM_POL_POL7_1 = 0x1

	// FMS: Fault Mode Status
	// Position of FAULTF0 field.
	FTM_FMS_FAULTF0_Pos = 0x0
	// Bit mask of FAULTF0 field.
	FTM_FMS_FAULTF0_Msk = 0x1
	// Bit FAULTF0.
	FTM_FMS_FAULTF0 = 0x1
	// No fault condition was detected at the fault input.
	FTM_FMS_FAULTF0_0 = 0x0
	// A fault condition was detected at the fault input.
	FTM_FMS_FAULTF0_1 = 0x1
	// Position of FAULTF1 field.
	FTM_FMS_FAULTF1_Pos = 0x1
	// Bit mask of FAULTF1 field.
	FTM_FMS_FAULTF1_Msk = 0x2
	// Bit FAULTF1.
	FTM_FMS_FAULTF1 = 0x2
	// No fault condition was detected at the fault input.
	FTM_FMS_FAULTF1_0 = 0x0
	// A fault condition was detected at the fault input.
	FTM_FMS_FAULTF1_1 = 0x1
	// Position of FAULTF2 field.
	FTM_FMS_FAULTF2_Pos = 0x2
	// Bit mask of FAULTF2 field.
	FTM_FMS_FAULTF2_Msk = 0x4
	// Bit FAULTF2.
	FTM_FMS_FAULTF2 = 0x4
	// No fault condition was detected at the fault input.
	FTM_FMS_FAULTF2_0 = 0x0
	// A fault condition was detected at the fault input.
	FTM_FMS_FAULTF2_1 = 0x1
	// Position of FAULTF3 field.
	FTM_FMS_FAULTF3_Pos = 0x3
	// Bit mask of FAULTF3 field.
	FTM_FMS_FAULTF3_Msk = 0x8
	// Bit FAULTF3.
	FTM_FMS_FAULTF3 = 0x8
	// No fault condition was detected at the fault input.
	FTM_FMS_FAULTF3_0 = 0x0
	// A fault condition was detected at the fault input.
	FTM_FMS_FAULTF3_1 = 0x1
	// Position of FAULTIN field.
	FTM_FMS_FAULTIN_Pos = 0x5
	// Bit mask of FAULTIN field.
	FTM_FMS_FAULTIN_Msk = 0x20
	// Bit FAULTIN.
	FTM_FMS_FAULTIN = 0x20
	// The logic OR of the enabled fault inputs is 0.
	FTM_FMS_FAULTIN_0 = 0x0
	// The logic OR of the enabled fault inputs is 1.
	FTM_FMS_FAULTIN_1 = 0x1
	// Position of WPEN field.
	FTM_FMS_WPEN_Pos = 0x6
	// Bit mask of WPEN field.
	FTM_FMS_WPEN_Msk = 0x40
	// Bit WPEN.
	FTM_FMS_WPEN = 0x40
	// Write protection is disabled. Write protected bits can be written.
	FTM_FMS_WPEN_0 = 0x0
	// Write protection is enabled. Write protected bits cannot be written.
	FTM_FMS_WPEN_1 = 0x1
	// Position of FAULTF field.
	FTM_FMS_FAULTF_Pos = 0x7
	// Bit mask of FAULTF field.
	FTM_FMS_FAULTF_Msk = 0x80
	// Bit FAULTF.
	FTM_FMS_FAULTF = 0x80
	// No fault condition was detected.
	FTM_FMS_FAULTF_0 = 0x0
	// A fault condition was detected.
	FTM_FMS_FAULTF_1 = 0x1

	// FILTER: Input Capture Filter Control
	// Position of CH0FVAL field.
	FTM_FILTER_CH0FVAL_Pos = 0x0
	// Bit mask of CH0FVAL field.
	FTM_FILTER_CH0FVAL_Msk = 0xf
	// Position of CH1FVAL field.
	FTM_FILTER_CH1FVAL_Pos = 0x4
	// Bit mask of CH1FVAL field.
	FTM_FILTER_CH1FVAL_Msk = 0xf0
	// Position of CH2FVAL field.
	FTM_FILTER_CH2FVAL_Pos = 0x8
	// Bit mask of CH2FVAL field.
	FTM_FILTER_CH2FVAL_Msk = 0xf00
	// Position of CH3FVAL field.
	FTM_FILTER_CH3FVAL_Pos = 0xc
	// Bit mask of CH3FVAL field.
	FTM_FILTER_CH3FVAL_Msk = 0xf000

	// FLTCTRL: Fault Control
	// Position of FAULT0EN field.
	FTM_FLTCTRL_FAULT0EN_Pos = 0x0
	// Bit mask of FAULT0EN field.
	FTM_FLTCTRL_FAULT0EN_Msk = 0x1
	// Bit FAULT0EN.
	FTM_FLTCTRL_FAULT0EN = 0x1
	// Fault input is disabled.
	FTM_FLTCTRL_FAULT0EN_0 = 0x0
	// Fault input is enabled.
	FTM_FLTCTRL_FAULT0EN_1 = 0x1
	// Position of FAULT1EN field.
	FTM_FLTCTRL_FAULT1EN_Pos = 0x1
	// Bit mask of FAULT1EN field.
	FTM_FLTCTRL_FAULT1EN_Msk = 0x2
	// Bit FAULT1EN.
	FTM_FLTCTRL_FAULT1EN = 0x2
	// Fault input is disabled.
	FTM_FLTCTRL_FAULT1EN_0 = 0x0
	// Fault input is enabled.
	FTM_FLTCTRL_FAULT1EN_1 = 0x1
	// Position of FAULT2EN field.
	FTM_FLTCTRL_FAULT2EN_Pos = 0x2
	// Bit mask of FAULT2EN field.
	FTM_FLTCTRL_FAULT2EN_Msk = 0x4
	// Bit FAULT2EN.
	FTM_FLTCTRL_FAULT2EN = 0x4
	// Fault input is disabled.
	FTM_FLTCTRL_FAULT2EN_0 = 0x0
	// Fault input is enabled.
	FTM_FLTCTRL_FAULT2EN_1 = 0x1
	// Position of FAULT3EN field.
	FTM_FLTCTRL_FAULT3EN_Pos = 0x3
	// Bit mask of FAULT3EN field.
	FTM_FLTCTRL_FAULT3EN_Msk = 0x8
	// Bit FAULT3EN.
	FTM_FLTCTRL_FAULT3EN = 0x8
	// Fault input is disabled.
	FTM_FLTCTRL_FAULT3EN_0 = 0x0
	// Fault input is enabled.
	FTM_FLTCTRL_FAULT3EN_1 = 0x1
	// Position of FFLTR0EN field.
	FTM_FLTCTRL_FFLTR0EN_Pos = 0x4
	// Bit mask of FFLTR0EN field.
	FTM_FLTCTRL_FFLTR0EN_Msk = 0x10
	// Bit FFLTR0EN.
	FTM_FLTCTRL_FFLTR0EN = 0x10
	// Fault input filter is disabled.
	FTM_FLTCTRL_FFLTR0EN_0 = 0x0
	// Fault input filter is enabled.
	FTM_FLTCTRL_FFLTR0EN_1 = 0x1
	// Position of FFLTR1EN field.
	FTM_FLTCTRL_FFLTR1EN_Pos = 0x5
	// Bit mask of FFLTR1EN field.
	FTM_FLTCTRL_FFLTR1EN_Msk = 0x20
	// Bit FFLTR1EN.
	FTM_FLTCTRL_FFLTR1EN = 0x20
	// Fault input filter is disabled.
	FTM_FLTCTRL_FFLTR1EN_0 = 0x0
	// Fault input filter is enabled.
	FTM_FLTCTRL_FFLTR1EN_1 = 0x1
	// Position of FFLTR2EN field.
	FTM_FLTCTRL_FFLTR2EN_Pos = 0x6
	// Bit mask of FFLTR2EN field.
	FTM_FLTCTRL_FFLTR2EN_Msk = 0x40
	// Bit FFLTR2EN.
	FTM_FLTCTRL_FFLTR2EN = 0x40
	// Fault input filter is disabled.
	FTM_FLTCTRL_FFLTR2EN_0 = 0x0
	// Fault input filter is enabled.
	FTM_FLTCTRL_FFLTR2EN_1 = 0x1
	// Position of FFLTR3EN field.
	FTM_FLTCTRL_FFLTR3EN_Pos = 0x7
	// Bit mask of FFLTR3EN field.
	FTM_FLTCTRL_FFLTR3EN_Msk = 0x80
	// Bit FFLTR3EN.
	FTM_FLTCTRL_FFLTR3EN = 0x80
	// Fault input filter is disabled.
	FTM_FLTCTRL_FFLTR3EN_0 = 0x0
	// Fault input filter is enabled.
	FTM_FLTCTRL_FFLTR3EN_1 = 0x1
	// Position of FFVAL field.
	FTM_FLTCTRL_FFVAL_Pos = 0x8
	// Bit mask of FFVAL field.
	FTM_FLTCTRL_FFVAL_Msk = 0xf00

	// QDCTRL: Quadrature Decoder Control And Status
	// Position of QUADEN field.
	FTM_QDCTRL_QUADEN_Pos = 0x0
	// Bit mask of QUADEN field.
	FTM_QDCTRL_QUADEN_Msk = 0x1
	// Bit QUADEN.
	FTM_QDCTRL_QUADEN = 0x1
	// Quadrature Decoder mode is disabled.
	FTM_QDCTRL_QUADEN_0 = 0x0
	// Quadrature Decoder mode is enabled.
	FTM_QDCTRL_QUADEN_1 = 0x1
	// Position of TOFDIR field.
	FTM_QDCTRL_TOFDIR_Pos = 0x1
	// Bit mask of TOFDIR field.
	FTM_QDCTRL_TOFDIR_Msk = 0x2
	// Bit TOFDIR.
	FTM_QDCTRL_TOFDIR = 0x2
	// TOF bit was set on the bottom of counting. There was an FTM counter decrement and FTM counter changes from its minimum value (CNTIN register) to its maximum value (MOD register).
	FTM_QDCTRL_TOFDIR_0 = 0x0
	// TOF bit was set on the top of counting. There was an FTM counter increment and FTM counter changes from its maximum value (MOD register) to its minimum value (CNTIN register).
	FTM_QDCTRL_TOFDIR_1 = 0x1
	// Position of QUADIR field.
	FTM_QDCTRL_QUADIR_Pos = 0x2
	// Bit mask of QUADIR field.
	FTM_QDCTRL_QUADIR_Msk = 0x4
	// Bit QUADIR.
	FTM_QDCTRL_QUADIR = 0x4
	// Counting direction is decreasing (FTM counter decrement).
	FTM_QDCTRL_QUADIR_0 = 0x0
	// Counting direction is increasing (FTM counter increment).
	FTM_QDCTRL_QUADIR_1 = 0x1
	// Position of QUADMODE field.
	FTM_QDCTRL_QUADMODE_Pos = 0x3
	// Bit mask of QUADMODE field.
	FTM_QDCTRL_QUADMODE_Msk = 0x8
	// Bit QUADMODE.
	FTM_QDCTRL_QUADMODE = 0x8
	// Phase A and phase B encoding mode.
	FTM_QDCTRL_QUADMODE_0 = 0x0
	// Count and direction encoding mode.
	FTM_QDCTRL_QUADMODE_1 = 0x1
	// Position of PHBPOL field.
	FTM_QDCTRL_PHBPOL_Pos = 0x4
	// Bit mask of PHBPOL field.
	FTM_QDCTRL_PHBPOL_Msk = 0x10
	// Bit PHBPOL.
	FTM_QDCTRL_PHBPOL = 0x10
	// Normal polarity. Phase B input signal is not inverted before identifying the rising and falling edges of this signal.
	FTM_QDCTRL_PHBPOL_0 = 0x0
	// Inverted polarity. Phase B input signal is inverted before identifying the rising and falling edges of this signal.
	FTM_QDCTRL_PHBPOL_1 = 0x1
	// Position of PHAPOL field.
	FTM_QDCTRL_PHAPOL_Pos = 0x5
	// Bit mask of PHAPOL field.
	FTM_QDCTRL_PHAPOL_Msk = 0x20
	// Bit PHAPOL.
	FTM_QDCTRL_PHAPOL = 0x20
	// Normal polarity. Phase A input signal is not inverted before identifying the rising and falling edges of this signal.
	FTM_QDCTRL_PHAPOL_0 = 0x0
	// Inverted polarity. Phase A input signal is inverted before identifying the rising and falling edges of this signal.
	FTM_QDCTRL_PHAPOL_1 = 0x1
	// Position of PHBFLTREN field.
	FTM_QDCTRL_PHBFLTREN_Pos = 0x6
	// Bit mask of PHBFLTREN field.
	FTM_QDCTRL_PHBFLTREN_Msk = 0x40
	// Bit PHBFLTREN.
	FTM_QDCTRL_PHBFLTREN = 0x40
	// Phase B input filter is disabled.
	FTM_QDCTRL_PHBFLTREN_0 = 0x0
	// Phase B input filter is enabled.
	FTM_QDCTRL_PHBFLTREN_1 = 0x1
	// Position of PHAFLTREN field.
	FTM_QDCTRL_PHAFLTREN_Pos = 0x7
	// Bit mask of PHAFLTREN field.
	FTM_QDCTRL_PHAFLTREN_Msk = 0x80
	// Bit PHAFLTREN.
	FTM_QDCTRL_PHAFLTREN = 0x80
	// Phase A input filter is disabled.
	FTM_QDCTRL_PHAFLTREN_0 = 0x0
	// Phase A input filter is enabled.
	FTM_QDCTRL_PHAFLTREN_1 = 0x1

	// CONF: Configuration
	// Position of NUMTOF field.
	FTM_CONF_NUMTOF_Pos = 0x0
	// Bit mask of NUMTOF field.
	FTM_CONF_NUMTOF_Msk = 0x1f
	// Position of BDMMODE field.
	FTM_CONF_BDMMODE_Pos = 0x6
	// Bit mask of BDMMODE field.
	FTM_CONF_BDMMODE_Msk = 0xc0
	// Position of GTBEEN field.
	FTM_CONF_GTBEEN_Pos = 0x9
	// Bit mask of GTBEEN field.
	FTM_CONF_GTBEEN_Msk = 0x200
	// Bit GTBEEN.
	FTM_CONF_GTBEEN = 0x200
	// Use of an external global time base is disabled.
	FTM_CONF_GTBEEN_0 = 0x0
	// Use of an external global time base is enabled.
	FTM_CONF_GTBEEN_1 = 0x1
	// Position of GTBEOUT field.
	FTM_CONF_GTBEOUT_Pos = 0xa
	// Bit mask of GTBEOUT field.
	FTM_CONF_GTBEOUT_Msk = 0x400
	// Bit GTBEOUT.
	FTM_CONF_GTBEOUT = 0x400
	// A global time base signal generation is disabled.
	FTM_CONF_GTBEOUT_0 = 0x0
	// A global time base signal generation is enabled.
	FTM_CONF_GTBEOUT_1 = 0x1

	// FLTPOL: FTM Fault Input Polarity
	// Position of FLT0POL field.
	FTM_FLTPOL_FLT0POL_Pos = 0x0
	// Bit mask of FLT0POL field.
	FTM_FLTPOL_FLT0POL_Msk = 0x1
	// Bit FLT0POL.
	FTM_FLTPOL_FLT0POL = 0x1
	// The fault input polarity is active high. A 1 at the fault input indicates a fault.
	FTM_FLTPOL_FLT0POL_0 = 0x0
	// The fault input polarity is active low. A 0 at the fault input indicates a fault.
	FTM_FLTPOL_FLT0POL_1 = 0x1
	// Position of FLT1POL field.
	FTM_FLTPOL_FLT1POL_Pos = 0x1
	// Bit mask of FLT1POL field.
	FTM_FLTPOL_FLT1POL_Msk = 0x2
	// Bit FLT1POL.
	FTM_FLTPOL_FLT1POL = 0x2
	// The fault input polarity is active high. A 1 at the fault input indicates a fault.
	FTM_FLTPOL_FLT1POL_0 = 0x0
	// The fault input polarity is active low. A 0 at the fault input indicates a fault.
	FTM_FLTPOL_FLT1POL_1 = 0x1
	// Position of FLT2POL field.
	FTM_FLTPOL_FLT2POL_Pos = 0x2
	// Bit mask of FLT2POL field.
	FTM_FLTPOL_FLT2POL_Msk = 0x4
	// Bit FLT2POL.
	FTM_FLTPOL_FLT2POL = 0x4
	// The fault input polarity is active high. A 1 at the fault input indicates a fault.
	FTM_FLTPOL_FLT2POL_0 = 0x0
	// The fault input polarity is active low. A 0 at the fault input indicates a fault.
	FTM_FLTPOL_FLT2POL_1 = 0x1
	// Position of FLT3POL field.
	FTM_FLTPOL_FLT3POL_Pos = 0x3
	// Bit mask of FLT3POL field.
	FTM_FLTPOL_FLT3POL_Msk = 0x8
	// Bit FLT3POL.
	FTM_FLTPOL_FLT3POL = 0x8
	// The fault input polarity is active high. A 1 at the fault input indicates a fault.
	FTM_FLTPOL_FLT3POL_0 = 0x0
	// The fault input polarity is active low. A 0 at the fault input indicates a fault.
	FTM_FLTPOL_FLT3POL_1 = 0x1

	// SYNCONF: Synchronization Configuration
	// Position of HWTRIGMODE field.
	FTM_SYNCONF_HWTRIGMODE_Pos = 0x0
	// Bit mask of HWTRIGMODE field.
	FTM_SYNCONF_HWTRIGMODE_Msk = 0x1
	// Bit HWTRIGMODE.
	FTM_SYNCONF_HWTRIGMODE = 0x1
	// FTM clears the TRIGj bit when the hardware trigger j is detected, where j = 0, 1,2.
	FTM_SYNCONF_HWTRIGMODE_0 = 0x0
	// FTM does not clear the TRIGj bit when the hardware trigger j is detected, where j = 0, 1,2.
	FTM_SYNCONF_HWTRIGMODE_1 = 0x1
	// Position of CNTINC field.
	FTM_SYNCONF_CNTINC_Pos = 0x2
	// Bit mask of CNTINC field.
	FTM_SYNCONF_CNTINC_Msk = 0x4
	// Bit CNTINC.
	FTM_SYNCONF_CNTINC = 0x4
	// CNTIN register is updated with its buffer value at all rising edges of system clock.
	FTM_SYNCONF_CNTINC_0 = 0x0
	// CNTIN register is updated with its buffer value by the PWM synchronization.
	FTM_SYNCONF_CNTINC_1 = 0x1
	// Position of INVC field.
	FTM_SYNCONF_INVC_Pos = 0x4
	// Bit mask of INVC field.
	FTM_SYNCONF_INVC_Msk = 0x10
	// Bit INVC.
	FTM_SYNCONF_INVC = 0x10
	// INVCTRL register is updated with its buffer value at all rising edges of system clock.
	FTM_SYNCONF_INVC_0 = 0x0
	// INVCTRL register is updated with its buffer value by the PWM synchronization.
	FTM_SYNCONF_INVC_1 = 0x1
	// Position of SWOC field.
	FTM_SYNCONF_SWOC_Pos = 0x5
	// Bit mask of SWOC field.
	FTM_SYNCONF_SWOC_Msk = 0x20
	// Bit SWOC.
	FTM_SYNCONF_SWOC = 0x20
	// SWOCTRL register is updated with its buffer value at all rising edges of system clock.
	FTM_SYNCONF_SWOC_0 = 0x0
	// SWOCTRL register is updated with its buffer value by the PWM synchronization.
	FTM_SYNCONF_SWOC_1 = 0x1
	// Position of SYNCMODE field.
	FTM_SYNCONF_SYNCMODE_Pos = 0x7
	// Bit mask of SYNCMODE field.
	FTM_SYNCONF_SYNCMODE_Msk = 0x80
	// Bit SYNCMODE.
	FTM_SYNCONF_SYNCMODE = 0x80
	// Legacy PWM synchronization is selected.
	FTM_SYNCONF_SYNCMODE_0 = 0x0
	// Enhanced PWM synchronization is selected.
	FTM_SYNCONF_SYNCMODE_1 = 0x1
	// Position of SWRSTCNT field.
	FTM_SYNCONF_SWRSTCNT_Pos = 0x8
	// Bit mask of SWRSTCNT field.
	FTM_SYNCONF_SWRSTCNT_Msk = 0x100
	// Bit SWRSTCNT.
	FTM_SYNCONF_SWRSTCNT = 0x100
	// The software trigger does not activate the FTM counter synchronization.
	FTM_SYNCONF_SWRSTCNT_0 = 0x0
	// The software trigger activates the FTM counter synchronization.
	FTM_SYNCONF_SWRSTCNT_1 = 0x1
	// Position of SWWRBUF field.
	FTM_SYNCONF_SWWRBUF_Pos = 0x9
	// Bit mask of SWWRBUF field.
	FTM_SYNCONF_SWWRBUF_Msk = 0x200
	// Bit SWWRBUF.
	FTM_SYNCONF_SWWRBUF = 0x200
	// The software trigger does not activate MOD, CNTIN, and CV registers synchronization.
	FTM_SYNCONF_SWWRBUF_0 = 0x0
	// The software trigger activates MOD, CNTIN, and CV registers synchronization.
	FTM_SYNCONF_SWWRBUF_1 = 0x1
	// Position of SWOM field.
	FTM_SYNCONF_SWOM_Pos = 0xa
	// Bit mask of SWOM field.
	FTM_SYNCONF_SWOM_Msk = 0x400
	// Bit SWOM.
	FTM_SYNCONF_SWOM = 0x400
	// The software trigger does not activate the OUTMASK register synchronization.
	FTM_SYNCONF_SWOM_0 = 0x0
	// The software trigger activates the OUTMASK register synchronization.
	FTM_SYNCONF_SWOM_1 = 0x1
	// Position of SWINVC field.
	FTM_SYNCONF_SWINVC_Pos = 0xb
	// Bit mask of SWINVC field.
	FTM_SYNCONF_SWINVC_Msk = 0x800
	// Bit SWINVC.
	FTM_SYNCONF_SWINVC = 0x800
	// The software trigger does not activate the INVCTRL register synchronization.
	FTM_SYNCONF_SWINVC_0 = 0x0
	// The software trigger activates the INVCTRL register synchronization.
	FTM_SYNCONF_SWINVC_1 = 0x1
	// Position of SWSOC field.
	FTM_SYNCONF_SWSOC_Pos = 0xc
	// Bit mask of SWSOC field.
	FTM_SYNCONF_SWSOC_Msk = 0x1000
	// Bit SWSOC.
	FTM_SYNCONF_SWSOC = 0x1000
	// The software trigger does not activate the SWOCTRL register synchronization.
	FTM_SYNCONF_SWSOC_0 = 0x0
	// The software trigger activates the SWOCTRL register synchronization.
	FTM_SYNCONF_SWSOC_1 = 0x1
	// Position of HWRSTCNT field.
	FTM_SYNCONF_HWRSTCNT_Pos = 0x10
	// Bit mask of HWRSTCNT field.
	FTM_SYNCONF_HWRSTCNT_Msk = 0x10000
	// Bit HWRSTCNT.
	FTM_SYNCONF_HWRSTCNT = 0x10000
	// A hardware trigger does not activate the FTM counter synchronization.
	FTM_SYNCONF_HWRSTCNT_0 = 0x0
	// A hardware trigger activates the FTM counter synchronization.
	FTM_SYNCONF_HWRSTCNT_1 = 0x1
	// Position of HWWRBUF field.
	FTM_SYNCONF_HWWRBUF_Pos = 0x11
	// Bit mask of HWWRBUF field.
	FTM_SYNCONF_HWWRBUF_Msk = 0x20000
	// Bit HWWRBUF.
	FTM_SYNCONF_HWWRBUF = 0x20000
	// A hardware trigger does not activate MOD, CNTIN, and CV registers synchronization.
	FTM_SYNCONF_HWWRBUF_0 = 0x0
	// A hardware trigger activates MOD, CNTIN, and CV registers synchronization.
	FTM_SYNCONF_HWWRBUF_1 = 0x1
	// Position of HWOM field.
	FTM_SYNCONF_HWOM_Pos = 0x12
	// Bit mask of HWOM field.
	FTM_SYNCONF_HWOM_Msk = 0x40000
	// Bit HWOM.
	FTM_SYNCONF_HWOM = 0x40000
	// A hardware trigger does not activate the OUTMASK register synchronization.
	FTM_SYNCONF_HWOM_0 = 0x0
	// A hardware trigger activates the OUTMASK register synchronization.
	FTM_SYNCONF_HWOM_1 = 0x1
	// Position of HWINVC field.
	FTM_SYNCONF_HWINVC_Pos = 0x13
	// Bit mask of HWINVC field.
	FTM_SYNCONF_HWINVC_Msk = 0x80000
	// Bit HWINVC.
	FTM_SYNCONF_HWINVC = 0x80000
	// A hardware trigger does not activate the INVCTRL register synchronization.
	FTM_SYNCONF_HWINVC_0 = 0x0
	// A hardware trigger activates the INVCTRL register synchronization.
	FTM_SYNCONF_HWINVC_1 = 0x1
	// Position of HWSOC field.
	FTM_SYNCONF_HWSOC_Pos = 0x14
	// Bit mask of HWSOC field.
	FTM_SYNCONF_HWSOC_Msk = 0x100000
	// Bit HWSOC.
	FTM_SYNCONF_HWSOC = 0x100000
	// A hardware trigger does not activate the SWOCTRL register synchronization.
	FTM_SYNCONF_HWSOC_0 = 0x0
	// A hardware trigger activates the SWOCTRL register synchronization.
	FTM_SYNCONF_HWSOC_1 = 0x1

	// INVCTRL: FTM Inverting Control
	// Position of INV0EN field.
	FTM_INVCTRL_INV0EN_Pos = 0x0
	// Bit mask of INV0EN field.
	FTM_INVCTRL_INV0EN_Msk = 0x1
	// Bit INV0EN.
	FTM_INVCTRL_INV0EN = 0x1
	// Inverting is disabled.
	FTM_INVCTRL_INV0EN_0 = 0x0
	// Inverting is enabled.
	FTM_INVCTRL_INV0EN_1 = 0x1
	// Position of INV1EN field.
	FTM_INVCTRL_INV1EN_Pos = 0x1
	// Bit mask of INV1EN field.
	FTM_INVCTRL_INV1EN_Msk = 0x2
	// Bit INV1EN.
	FTM_INVCTRL_INV1EN = 0x2
	// Inverting is disabled.
	FTM_INVCTRL_INV1EN_0 = 0x0
	// Inverting is enabled.
	FTM_INVCTRL_INV1EN_1 = 0x1
	// Position of INV2EN field.
	FTM_INVCTRL_INV2EN_Pos = 0x2
	// Bit mask of INV2EN field.
	FTM_INVCTRL_INV2EN_Msk = 0x4
	// Bit INV2EN.
	FTM_INVCTRL_INV2EN = 0x4
	// Inverting is disabled.
	FTM_INVCTRL_INV2EN_0 = 0x0
	// Inverting is enabled.
	FTM_INVCTRL_INV2EN_1 = 0x1
	// Position of INV3EN field.
	FTM_INVCTRL_INV3EN_Pos = 0x3
	// Bit mask of INV3EN field.
	FTM_INVCTRL_INV3EN_Msk = 0x8
	// Bit INV3EN.
	FTM_INVCTRL_INV3EN = 0x8
	// Inverting is disabled.
	FTM_INVCTRL_INV3EN_0 = 0x0
	// Inverting is enabled.
	FTM_INVCTRL_INV3EN_1 = 0x1

	// SWOCTRL: FTM Software Output Control
	// Position of CH0OC field.
	FTM_SWOCTRL_CH0OC_Pos = 0x0
	// Bit mask of CH0OC field.
	FTM_SWOCTRL_CH0OC_Msk = 0x1
	// Bit CH0OC.
	FTM_SWOCTRL_CH0OC = 0x1
	// The channel output is not affected by software output control.
	FTM_SWOCTRL_CH0OC_0 = 0x0
	// The channel output is affected by software output control.
	FTM_SWOCTRL_CH0OC_1 = 0x1
	// Position of CH1OC field.
	FTM_SWOCTRL_CH1OC_Pos = 0x1
	// Bit mask of CH1OC field.
	FTM_SWOCTRL_CH1OC_Msk = 0x2
	// Bit CH1OC.
	FTM_SWOCTRL_CH1OC = 0x2
	// The channel output is not affected by software output control.
	FTM_SWOCTRL_CH1OC_0 = 0x0
	// The channel output is affected by software output control.
	FTM_SWOCTRL_CH1OC_1 = 0x1
	// Position of CH2OC field.
	FTM_SWOCTRL_CH2OC_Pos = 0x2
	// Bit mask of CH2OC field.
	FTM_SWOCTRL_CH2OC_Msk = 0x4
	// Bit CH2OC.
	FTM_SWOCTRL_CH2OC = 0x4
	// The channel output is not affected by software output control.
	FTM_SWOCTRL_CH2OC_0 = 0x0
	// The channel output is affected by software output control.
	FTM_SWOCTRL_CH2OC_1 = 0x1
	// Position of CH3OC field.
	FTM_SWOCTRL_CH3OC_Pos = 0x3
	// Bit mask of CH3OC field.
	FTM_SWOCTRL_CH3OC_Msk = 0x8
	// Bit CH3OC.
	FTM_SWOCTRL_CH3OC = 0x8
	// The channel output is not affected by software output control.
	FTM_SWOCTRL_CH3OC_0 = 0x0
	// The channel output is affected by software output control.
	FTM_SWOCTRL_CH3OC_1 = 0x1
	// Position of CH4OC field.
	FTM_SWOCTRL_CH4OC_Pos = 0x4
	// Bit mask of CH4OC field.
	FTM_SWOCTRL_CH4OC_Msk = 0x10
	// Bit CH4OC.
	FTM_SWOCTRL_CH4OC = 0x10
	// The channel output is not affected by software output control.
	FTM_SWOCTRL_CH4OC_0 = 0x0
	// The channel output is affected by software output control.
	FTM_SWOCTRL_CH4OC_1 = 0x1
	// Position of CH5OC field.
	FTM_SWOCTRL_CH5OC_Pos = 0x5
	// Bit mask of CH5OC field.
	FTM_SWOCTRL_CH5OC_Msk = 0x20
	// Bit CH5OC.
	FTM_SWOCTRL_CH5OC = 0x20
	// The channel output is not affected by software output control.
	FTM_SWOCTRL_CH5OC_0 = 0x0
	// The channel output is affected by software output control.
	FTM_SWOCTRL_CH5OC_1 = 0x1
	// Position of CH6OC field.
	FTM_SWOCTRL_CH6OC_Pos = 0x6
	// Bit mask of CH6OC field.
	FTM_SWOCTRL_CH6OC_Msk = 0x40
	// Bit CH6OC.
	FTM_SWOCTRL_CH6OC = 0x40
	// The channel output is not affected by software output control.
	FTM_SWOCTRL_CH6OC_0 = 0x0
	// The channel output is affected by software output control.
	FTM_SWOCTRL_CH6OC_1 = 0x1
	// Position of CH7OC field.
	FTM_SWOCTRL_CH7OC_Pos = 0x7
	// Bit mask of CH7OC field.
	FTM_SWOCTRL_CH7OC_Msk = 0x80
	// Bit CH7OC.
	FTM_SWOCTRL_CH7OC = 0x80
	// The channel output is not affected by software output control.
	FTM_SWOCTRL_CH7OC_0 = 0x0
	// The channel output is affected by software output control.
	FTM_SWOCTRL_CH7OC_1 = 0x1
	// Position of CH0OCV field.
	FTM_SWOCTRL_CH0OCV_Pos = 0x8
	// Bit mask of CH0OCV field.
	FTM_SWOCTRL_CH0OCV_Msk = 0x100
	// Bit CH0OCV.
	FTM_SWOCTRL_CH0OCV = 0x100
	// The software output control forces 0 to the channel output.
	FTM_SWOCTRL_CH0OCV_0 = 0x0
	// The software output control forces 1 to the channel output.
	FTM_SWOCTRL_CH0OCV_1 = 0x1
	// Position of CH1OCV field.
	FTM_SWOCTRL_CH1OCV_Pos = 0x9
	// Bit mask of CH1OCV field.
	FTM_SWOCTRL_CH1OCV_Msk = 0x200
	// Bit CH1OCV.
	FTM_SWOCTRL_CH1OCV = 0x200
	// The software output control forces 0 to the channel output.
	FTM_SWOCTRL_CH1OCV_0 = 0x0
	// The software output control forces 1 to the channel output.
	FTM_SWOCTRL_CH1OCV_1 = 0x1
	// Position of CH2OCV field.
	FTM_SWOCTRL_CH2OCV_Pos = 0xa
	// Bit mask of CH2OCV field.
	FTM_SWOCTRL_CH2OCV_Msk = 0x400
	// Bit CH2OCV.
	FTM_SWOCTRL_CH2OCV = 0x400
	// The software output control forces 0 to the channel output.
	FTM_SWOCTRL_CH2OCV_0 = 0x0
	// The software output control forces 1 to the channel output.
	FTM_SWOCTRL_CH2OCV_1 = 0x1
	// Position of CH3OCV field.
	FTM_SWOCTRL_CH3OCV_Pos = 0xb
	// Bit mask of CH3OCV field.
	FTM_SWOCTRL_CH3OCV_Msk = 0x800
	// Bit CH3OCV.
	FTM_SWOCTRL_CH3OCV = 0x800
	// The software output control forces 0 to the channel output.
	FTM_SWOCTRL_CH3OCV_0 = 0x0
	// The software output control forces 1 to the channel output.
	FTM_SWOCTRL_CH3OCV_1 = 0x1
	// Position of CH4OCV field.
	FTM_SWOCTRL_CH4OCV_Pos = 0xc
	// Bit mask of CH4OCV field.
	FTM_SWOCTRL_CH4OCV_Msk = 0x1000
	// Bit CH4OCV.
	FTM_SWOCTRL_CH4OCV = 0x1000
	// The software output control forces 0 to the channel output.
	FTM_SWOCTRL_CH4OCV_0 = 0x0
	// The software output control forces 1 to the channel output.
	FTM_SWOCTRL_CH4OCV_1 = 0x1
	// Position of CH5OCV field.
	FTM_SWOCTRL_CH5OCV_Pos = 0xd
	// Bit mask of CH5OCV field.
	FTM_SWOCTRL_CH5OCV_Msk = 0x2000
	// Bit CH5OCV.
	FTM_SWOCTRL_CH5OCV = 0x2000
	// The software output control forces 0 to the channel output.
	FTM_SWOCTRL_CH5OCV_0 = 0x0
	// The software output control forces 1 to the channel output.
	FTM_SWOCTRL_CH5OCV_1 = 0x1
	// Position of CH6OCV field.
	FTM_SWOCTRL_CH6OCV_Pos = 0xe
	// Bit mask of CH6OCV field.
	FTM_SWOCTRL_CH6OCV_Msk = 0x4000
	// Bit CH6OCV.
	FTM_SWOCTRL_CH6OCV = 0x4000
	// The software output control forces 0 to the channel output.
	FTM_SWOCTRL_CH6OCV_0 = 0x0
	// The software output control forces 1 to the channel output.
	FTM_SWOCTRL_CH6OCV_1 = 0x1
	// Position of CH7OCV field.
	FTM_SWOCTRL_CH7OCV_Pos = 0xf
	// Bit mask of CH7OCV field.
	FTM_SWOCTRL_CH7OCV_Msk = 0x8000
	// Bit CH7OCV.
	FTM_SWOCTRL_CH7OCV = 0x8000
	// The software output control forces 0 to the channel output.
	FTM_SWOCTRL_CH7OCV_0 = 0x0
	// The software output control forces 1 to the channel output.
	FTM_SWOCTRL_CH7OCV_1 = 0x1

	// PWMLOAD: FTM PWM Load
	// Position of CH0SEL field.
	FTM_PWMLOAD_CH0SEL_Pos = 0x0
	// Bit mask of CH0SEL field.
	FTM_PWMLOAD_CH0SEL_Msk = 0x1
	// Bit CH0SEL.
	FTM_PWMLOAD_CH0SEL = 0x1
	// Do not include the channel in the matching process.
	FTM_PWMLOAD_CH0SEL_0 = 0x0
	// Include the channel in the matching process.
	FTM_PWMLOAD_CH0SEL_1 = 0x1
	// Position of CH1SEL field.
	FTM_PWMLOAD_CH1SEL_Pos = 0x1
	// Bit mask of CH1SEL field.
	FTM_PWMLOAD_CH1SEL_Msk = 0x2
	// Bit CH1SEL.
	FTM_PWMLOAD_CH1SEL = 0x2
	// Do not include the channel in the matching process.
	FTM_PWMLOAD_CH1SEL_0 = 0x0
	// Include the channel in the matching process.
	FTM_PWMLOAD_CH1SEL_1 = 0x1
	// Position of CH2SEL field.
	FTM_PWMLOAD_CH2SEL_Pos = 0x2
	// Bit mask of CH2SEL field.
	FTM_PWMLOAD_CH2SEL_Msk = 0x4
	// Bit CH2SEL.
	FTM_PWMLOAD_CH2SEL = 0x4
	// Do not include the channel in the matching process.
	FTM_PWMLOAD_CH2SEL_0 = 0x0
	// Include the channel in the matching process.
	FTM_PWMLOAD_CH2SEL_1 = 0x1
	// Position of CH3SEL field.
	FTM_PWMLOAD_CH3SEL_Pos = 0x3
	// Bit mask of CH3SEL field.
	FTM_PWMLOAD_CH3SEL_Msk = 0x8
	// Bit CH3SEL.
	FTM_PWMLOAD_CH3SEL = 0x8
	// Do not include the channel in the matching process.
	FTM_PWMLOAD_CH3SEL_0 = 0x0
	// Include the channel in the matching process.
	FTM_PWMLOAD_CH3SEL_1 = 0x1
	// Position of CH4SEL field.
	FTM_PWMLOAD_CH4SEL_Pos = 0x4
	// Bit mask of CH4SEL field.
	FTM_PWMLOAD_CH4SEL_Msk = 0x10
	// Bit CH4SEL.
	FTM_PWMLOAD_CH4SEL = 0x10
	// Do not include the channel in the matching process.
	FTM_PWMLOAD_CH4SEL_0 = 0x0
	// Include the channel in the matching process.
	FTM_PWMLOAD_CH4SEL_1 = 0x1
	// Position of CH5SEL field.
	FTM_PWMLOAD_CH5SEL_Pos = 0x5
	// Bit mask of CH5SEL field.
	FTM_PWMLOAD_CH5SEL_Msk = 0x20
	// Bit CH5SEL.
	FTM_PWMLOAD_CH5SEL = 0x20
	// Do not include the channel in the matching process.
	FTM_PWMLOAD_CH5SEL_0 = 0x0
	// Include the channel in the matching process.
	FTM_PWMLOAD_CH5SEL_1 = 0x1
	// Position of CH6SEL field.
	FTM_PWMLOAD_CH6SEL_Pos = 0x6
	// Bit mask of CH6SEL field.
	FTM_PWMLOAD_CH6SEL_Msk = 0x40
	// Bit CH6SEL.
	FTM_PWMLOAD_CH6SEL = 0x40
	// Do not include the channel in the matching process.
	FTM_PWMLOAD_CH6SEL_0 = 0x0
	// Include the channel in the matching process.
	FTM_PWMLOAD_CH6SEL_1 = 0x1
	// Position of CH7SEL field.
	FTM_PWMLOAD_CH7SEL_Pos = 0x7
	// Bit mask of CH7SEL field.
	FTM_PWMLOAD_CH7SEL_Msk = 0x80
	// Bit CH7SEL.
	FTM_PWMLOAD_CH7SEL = 0x80
	// Do not include the channel in the matching process.
	FTM_PWMLOAD_CH7SEL_0 = 0x0
	// Include the channel in the matching process.
	FTM_PWMLOAD_CH7SEL_1 = 0x1
	// Position of LDOK field.
	FTM_PWMLOAD_LDOK_Pos = 0x9
	// Bit mask of LDOK field.
	FTM_PWMLOAD_LDOK_Msk = 0x200
	// Bit LDOK.
	FTM_PWMLOAD_LDOK = 0x200
	// Loading updated values is disabled.
	FTM_PWMLOAD_LDOK_0 = 0x0
	// Loading updated values is enabled.
	FTM_PWMLOAD_LDOK_1 = 0x1
)

// Constants for ADC0: Analog-to-Digital Converter
const (
	// SC1A: ADC Status and Control Registers 1
	// Position of ADCH field.
	ADC_SC1_ADCH_Pos = 0x0
	// Bit mask of ADCH field.
	ADC_SC1_ADCH_Msk = 0x1f
	// When DIFF=0, DADP0 is selected as input; when DIFF=1, DAD0 is selected as input.
	ADC_SC1_ADCH_00000 = 0x0
	// When DIFF=0, DADP1 is selected as input; when DIFF=1, DAD1 is selected as input.
	ADC_SC1_ADCH_00001 = 0x1
	// When DIFF=0, DADP2 is selected as input; when DIFF=1, DAD2 is selected as input.
	ADC_SC1_ADCH_00010 = 0x2
	// When DIFF=0, DADP3 is selected as input; when DIFF=1, DAD3 is selected as input.
	ADC_SC1_ADCH_00011 = 0x3
	// When DIFF=0, AD4 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_00100 = 0x4
	// When DIFF=0, AD5 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_00101 = 0x5
	// When DIFF=0, AD6 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_00110 = 0x6
	// When DIFF=0, AD7 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_00111 = 0x7
	// When DIFF=0, AD8 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_01000 = 0x8
	// When DIFF=0, AD9 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_01001 = 0x9
	// When DIFF=0, AD10 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_01010 = 0xa
	// When DIFF=0, AD11 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_01011 = 0xb
	// When DIFF=0, AD12 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_01100 = 0xc
	// When DIFF=0, AD13 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_01101 = 0xd
	// When DIFF=0, AD14 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_01110 = 0xe
	// When DIFF=0, AD15 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_01111 = 0xf
	// When DIFF=0, AD16 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_10000 = 0x10
	// When DIFF=0, AD17 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_10001 = 0x11
	// When DIFF=0, AD18 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_10010 = 0x12
	// When DIFF=0, AD19 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_10011 = 0x13
	// When DIFF=0, AD20 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_10100 = 0x14
	// When DIFF=0, AD21 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_10101 = 0x15
	// When DIFF=0, AD22 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_10110 = 0x16
	// When DIFF=0, AD23 is selected as input; when DIFF=1, it is reserved.
	ADC_SC1_ADCH_10111 = 0x17
	// When DIFF=0, Temp Sensor (single-ended) is selected as input; when DIFF=1, Temp Sensor (differential) is selected as input.
	ADC_SC1_ADCH_11010 = 0x1a
	// When DIFF=0, Bandgap (single-ended) is selected as input; when DIFF=1, Bandgap (differential) is selected as input.
	ADC_SC1_ADCH_11011 = 0x1b
	// When DIFF=0,VREFSH is selected as input; when DIFF=1, -VREFSH (differential) is selected as input. Voltage reference selected is determined by SC2[REFSEL].
	ADC_SC1_ADCH_11101 = 0x1d
	// When DIFF=0,VREFSL is selected as input; when DIFF=1, it is reserved. Voltage reference selected is determined by SC2[REFSEL].
	ADC_SC1_ADCH_11110 = 0x1e
	// Module is disabled.
	ADC_SC1_ADCH_11111 = 0x1f
	// Position of DIFF field.
	ADC_SC1_DIFF_Pos = 0x5
	// Bit mask of DIFF field.
	ADC_SC1_DIFF_Msk = 0x20
	// Bit DIFF.
	ADC_SC1_DIFF = 0x20
	// Single-ended conversions and input channels are selected.
	ADC_SC1_DIFF_0 = 0x0
	// Differential conversions and input channels are selected.
	ADC_SC1_DIFF_1 = 0x1
	// Position of AIEN field.
	ADC_SC1_AIEN_Pos = 0x6
	// Bit mask of AIEN field.
	ADC_SC1_AIEN_Msk = 0x40
	// Bit AIEN.
	ADC_SC1_AIEN = 0x40
	// Conversion complete interrupt is disabled.
	ADC_SC1_AIEN_0 = 0x0
	// Conversion complete interrupt is enabled.
	ADC_SC1_AIEN_1 = 0x1
	// Position of COCO field.
	ADC_SC1_COCO_Pos = 0x7
	// Bit mask of COCO field.
	ADC_SC1_COCO_Msk = 0x80
	// Bit COCO.
	ADC_SC1_COCO = 0x80
	// Conversion is not completed.
	ADC_SC1_COCO_0 = 0x0
	// Conversion is completed.
	ADC_SC1_COCO_1 = 0x1

	// CFG1: ADC Configuration Register 1
	// Position of ADICLK field.
	ADC_CFG1_ADICLK_Pos = 0x0
	// Bit mask of ADICLK field.
	ADC_CFG1_ADICLK_Msk = 0x3
	// Bus clock
	ADC_CFG1_ADICLK_00 = 0x0
	// Alternate clock 2 (ALTCLK2)
	ADC_CFG1_ADICLK_01 = 0x1
	// Alternate clock (ALTCLK)
	ADC_CFG1_ADICLK_10 = 0x2
	// Asynchronous clock (ADACK)
	ADC_CFG1_ADICLK_11 = 0x3
	// Position of MODE field.
	ADC_CFG1_MODE_Pos = 0x2
	// Bit mask of MODE field.
	ADC_CFG1_MODE_Msk = 0xc
	// When DIFF=0:It is single-ended 8-bit conversion; when DIFF=1, it is differential 9-bit conversion with 2's complement output.
	ADC_CFG1_MODE_00 = 0x0
	// When DIFF=0:It is single-ended 12-bit conversion ; when DIFF=1, it is differential 13-bit conversion with 2's complement output.
	ADC_CFG1_MODE_01 = 0x1
	// When DIFF=0:It is single-ended 10-bit conversion. ; when DIFF=1, it is differential 11-bit conversion with 2's complement output
	ADC_CFG1_MODE_10 = 0x2
	// When DIFF=0:It is single-ended 16-bit conversion..; when DIFF=1, it is differential 16-bit conversion with 2's complement output
	ADC_CFG1_MODE_11 = 0x3
	// Position of ADLSMP field.
	ADC_CFG1_ADLSMP_Pos = 0x4
	// Bit mask of ADLSMP field.
	ADC_CFG1_ADLSMP_Msk = 0x10
	// Bit ADLSMP.
	ADC_CFG1_ADLSMP = 0x10
	// Short sample time.
	ADC_CFG1_ADLSMP_0 = 0x0
	// Long sample time.
	ADC_CFG1_ADLSMP_1 = 0x1
	// Position of ADIV field.
	ADC_CFG1_ADIV_Pos = 0x5
	// Bit mask of ADIV field.
	ADC_CFG1_ADIV_Msk = 0x60
	// The divide ratio is 1 and the clock rate is input clock.
	ADC_CFG1_ADIV_00 = 0x0
	// The divide ratio is 2 and the clock rate is (input clock)/2.
	ADC_CFG1_ADIV_01 = 0x1
	// The divide ratio is 4 and the clock rate is (input clock)/4.
	ADC_CFG1_ADIV_10 = 0x2
	// The divide ratio is 8 and the clock rate is (input clock)/8.
	ADC_CFG1_ADIV_11 = 0x3
	// Position of ADLPC field.
	ADC_CFG1_ADLPC_Pos = 0x7
	// Bit mask of ADLPC field.
	ADC_CFG1_ADLPC_Msk = 0x80
	// Bit ADLPC.
	ADC_CFG1_ADLPC = 0x80
	// Normal power configuration.
	ADC_CFG1_ADLPC_0 = 0x0
	// Low-power configuration. The power is reduced at the expense of maximum clock speed.
	ADC_CFG1_ADLPC_1 = 0x1

	// CFG2: ADC Configuration Register 2
	// Position of ADLSTS field.
	ADC_CFG2_ADLSTS_Pos = 0x0
	// Bit mask of ADLSTS field.
	ADC_CFG2_ADLSTS_Msk = 0x3
	// Default longest sample time; 20 extra ADCK cycles; 24 ADCK cycles total.
	ADC_CFG2_ADLSTS_00 = 0x0
	// 12 extra ADCK cycles; 16 ADCK cycles total sample time.
	ADC_CFG2_ADLSTS_01 = 0x1
	// 6 extra ADCK cycles; 10 ADCK cycles total sample time.
	ADC_CFG2_ADLSTS_10 = 0x2
	// 2 extra ADCK cycles; 6 ADCK cycles total sample time.
	ADC_CFG2_ADLSTS_11 = 0x3
	// Position of ADHSC field.
	ADC_CFG2_ADHSC_Pos = 0x2
	// Bit mask of ADHSC field.
	ADC_CFG2_ADHSC_Msk = 0x4
	// Bit ADHSC.
	ADC_CFG2_ADHSC = 0x4
	// Normal conversion sequence selected.
	ADC_CFG2_ADHSC_0 = 0x0
	// High-speed conversion sequence selected with 2 additional ADCK cycles to total conversion time.
	ADC_CFG2_ADHSC_1 = 0x1
	// Position of ADACKEN field.
	ADC_CFG2_ADACKEN_Pos = 0x3
	// Bit mask of ADACKEN field.
	ADC_CFG2_ADACKEN_Msk = 0x8
	// Bit ADACKEN.
	ADC_CFG2_ADACKEN = 0x8
	// Asynchronous clock output disabled; Asynchronous clock is enabled only if selected by ADICLK and a conversion is active.
	ADC_CFG2_ADACKEN_0 = 0x0
	// Asynchronous clock and clock output is enabled regardless of the state of the ADC.
	ADC_CFG2_ADACKEN_1 = 0x1
	// Position of MUXSEL field.
	ADC_CFG2_MUXSEL_Pos = 0x4
	// Bit mask of MUXSEL field.
	ADC_CFG2_MUXSEL_Msk = 0x10
	// Bit MUXSEL.
	ADC_CFG2_MUXSEL = 0x10
	// ADxxa channels are selected.
	ADC_CFG2_MUXSEL_0 = 0x0
	// ADxxb channels are selected.
	ADC_CFG2_MUXSEL_1 = 0x1

	// RA: ADC Data Result Register
	// Position of D field.
	ADC_R_D_Pos = 0x0
	// Bit mask of D field.
	ADC_R_D_Msk = 0xffff

	// CV1: Compare Value Registers
	// Position of CV field.
	ADC_CV_CV_Pos = 0x0
	// Bit mask of CV field.
	ADC_CV_CV_Msk = 0xffff

	// SC2: Status and Control Register 2
	// Position of REFSEL field.
	ADC_SC2_REFSEL_Pos = 0x0
	// Bit mask of REFSEL field.
	ADC_SC2_REFSEL_Msk = 0x3
	// Default voltage reference pin pair, that is, external pins VREFH and VREFL
	ADC_SC2_REFSEL_00 = 0x0
	// Alternate reference pair, that is, VALTH and VALTL . This pair may be additional external pins or internal sources depending on the MCU configuration. See the chip configuration information for details specific to this MCU
	ADC_SC2_REFSEL_01 = 0x1
	// Position of DMAEN field.
	ADC_SC2_DMAEN_Pos = 0x2
	// Bit mask of DMAEN field.
	ADC_SC2_DMAEN_Msk = 0x4
	// Bit DMAEN.
	ADC_SC2_DMAEN = 0x4
	// DMA is disabled.
	ADC_SC2_DMAEN_0 = 0x0
	// DMA is enabled and will assert the ADC DMA request during an ADC conversion complete event noted when any of the SC1n[COCO] flags is asserted.
	ADC_SC2_DMAEN_1 = 0x1
	// Position of ACREN field.
	ADC_SC2_ACREN_Pos = 0x3
	// Bit mask of ACREN field.
	ADC_SC2_ACREN_Msk = 0x8
	// Bit ACREN.
	ADC_SC2_ACREN = 0x8
	// Range function disabled. Only CV1 is compared.
	ADC_SC2_ACREN_0 = 0x0
	// Range function enabled. Both CV1 and CV2 are compared.
	ADC_SC2_ACREN_1 = 0x1
	// Position of ACFGT field.
	ADC_SC2_ACFGT_Pos = 0x4
	// Bit mask of ACFGT field.
	ADC_SC2_ACFGT_Msk = 0x10
	// Bit ACFGT.
	ADC_SC2_ACFGT = 0x10
	// Configures less than threshold, outside range not inclusive and inside range not inclusive; functionality based on the values placed in CV1 and CV2.
	ADC_SC2_ACFGT_0 = 0x0
	// Configures greater than or equal to threshold, outside and inside ranges inclusive; functionality based on the values placed in CV1 and CV2.
	ADC_SC2_ACFGT_1 = 0x1
	// Position of ACFE field.
	ADC_SC2_ACFE_Pos = 0x5
	// Bit mask of ACFE field.
	ADC_SC2_ACFE_Msk = 0x20
	// Bit ACFE.
	ADC_SC2_ACFE = 0x20
	// Compare function disabled.
	ADC_SC2_ACFE_0 = 0x0
	// Compare function enabled.
	ADC_SC2_ACFE_1 = 0x1
	// Position of ADTRG field.
	ADC_SC2_ADTRG_Pos = 0x6
	// Bit mask of ADTRG field.
	ADC_SC2_ADTRG_Msk = 0x40
	// Bit ADTRG.
	ADC_SC2_ADTRG = 0x40
	// Software trigger selected.
	ADC_SC2_ADTRG_0 = 0x0
	// Hardware trigger selected.
	ADC_SC2_ADTRG_1 = 0x1
	// Position of ADACT field.
	ADC_SC2_ADACT_Pos = 0x7
	// Bit mask of ADACT field.
	ADC_SC2_ADACT_Msk = 0x80
	// Bit ADACT.
	ADC_SC2_ADACT = 0x80
	// Conversion not in progress.
	ADC_SC2_ADACT_0 = 0x0
	// Conversion in progress.
	ADC_SC2_ADACT_1 = 0x1

	// SC3: Status and Control Register 3
	// Position of AVGS field.
	ADC_SC3_AVGS_Pos = 0x0
	// Bit mask of AVGS field.
	ADC_SC3_AVGS_Msk = 0x3
	// 4 samples averaged.
	ADC_SC3_AVGS_00 = 0x0
	// 8 samples averaged.
	ADC_SC3_AVGS_01 = 0x1
	// 16 samples averaged.
	ADC_SC3_AVGS_10 = 0x2
	// 32 samples averaged.
	ADC_SC3_AVGS_11 = 0x3
	// Position of AVGE field.
	ADC_SC3_AVGE_Pos = 0x2
	// Bit mask of AVGE field.
	ADC_SC3_AVGE_Msk = 0x4
	// Bit AVGE.
	ADC_SC3_AVGE = 0x4
	// Hardware average function disabled.
	ADC_SC3_AVGE_0 = 0x0
	// Hardware average function enabled.
	ADC_SC3_AVGE_1 = 0x1
	// Position of ADCO field.
	ADC_SC3_ADCO_Pos = 0x3
	// Bit mask of ADCO field.
	ADC_SC3_ADCO_Msk = 0x8
	// Bit ADCO.
	ADC_SC3_ADCO = 0x8
	// One conversion or one set of conversions if the hardware average function is enabled, that is, AVGE=1, after initiating a conversion.
	ADC_SC3_ADCO_0 = 0x0
	// Continuous conversions or sets of conversions if the hardware average function is enabled, that is, AVGE=1, after initiating a conversion.
	ADC_SC3_ADCO_1 = 0x1
	// Position of CALF field.
	ADC_SC3_CALF_Pos = 0x6
	// Bit mask of CALF field.
	ADC_SC3_CALF_Msk = 0x40
	// Bit CALF.
	ADC_SC3_CALF = 0x40
	// Calibration completed normally.
	ADC_SC3_CALF_0 = 0x0
	// Calibration failed. ADC accuracy specifications are not guaranteed.
	ADC_SC3_CALF_1 = 0x1
	// Position of CAL field.
	ADC_SC3_CAL_Pos = 0x7
	// Bit mask of CAL field.
	ADC_SC3_CAL_Msk = 0x80
	// Bit CAL.
	ADC_SC3_CAL = 0x80

	// OFS: ADC Offset Correction Register
	// Position of OFS field.
	ADC_OFS_OFS_Pos = 0x0
	// Bit mask of OFS field.
	ADC_OFS_OFS_Msk = 0xffff

	// PG: ADC Plus-Side Gain Register
	// Position of PG field.
	ADC_PG_PG_Pos = 0x0
	// Bit mask of PG field.
	ADC_PG_PG_Msk = 0xffff

	// MG: ADC Minus-Side Gain Register
	// Position of MG field.
	ADC_MG_MG_Pos = 0x0
	// Bit mask of MG field.
	ADC_MG_MG_Msk = 0xffff

	// CLPD: ADC Plus-Side General Calibration Value Register
	// Position of CLPD field.
	ADC_CLPD_CLPD_Pos = 0x0
	// Bit mask of CLPD field.
	ADC_CLPD_CLPD_Msk = 0x3f

	// CLPS: ADC Plus-Side General Calibration Value Register
	// Position of CLPS field.
	ADC_CLPS_CLPS_Pos = 0x0
	// Bit mask of CLPS field.
	ADC_CLPS_CLPS_Msk = 0x3f

	// CLP4: ADC Plus-Side General Calibration Value Register
	// Position of CLP4 field.
	ADC_CLP4_CLP4_Pos = 0x0
	// Bit mask of CLP4 field.
	ADC_CLP4_CLP4_Msk = 0x3ff

	// CLP3: ADC Plus-Side General Calibration Value Register
	// Position of CLP3 field.
	ADC_CLP3_CLP3_Pos = 0x0
	// Bit mask of CLP3 field.
	ADC_CLP3_CLP3_Msk = 0x1ff

	// CLP2: ADC Plus-Side General Calibration Value Register
	// Position of CLP2 field.
	ADC_CLP2_CLP2_Pos = 0x0
	// Bit mask of CLP2 field.
	ADC_CLP2_CLP2_Msk = 0xff

	// CLP1: ADC Plus-Side General Calibration Value Register
	// Position of CLP1 field.
	ADC_CLP1_CLP1_Pos = 0x0
	// Bit mask of CLP1 field.
	ADC_CLP1_CLP1_Msk = 0x7f

	// CLP0: ADC Plus-Side General Calibration Value Register
	// Position of CLP0 field.
	ADC_CLP0_CLP0_Pos = 0x0
	// Bit mask of CLP0 field.
	ADC_CLP0_CLP0_Msk = 0x3f

	// CLMD: ADC Minus-Side General Calibration Value Register
	// Position of CLMD field.
	ADC_CLMD_CLMD_Pos = 0x0
	// Bit mask of CLMD field.
	ADC_CLMD_CLMD_Msk = 0x3f

	// CLMS: ADC Minus-Side General Calibration Value Register
	// Position of CLMS field.
	ADC_CLMS_CLMS_Pos = 0x0
	// Bit mask of CLMS field.
	ADC_CLMS_CLMS_Msk = 0x3f

	// CLM4: ADC Minus-Side General Calibration Value Register
	// Position of CLM4 field.
	ADC_CLM4_CLM4_Pos = 0x0
	// Bit mask of CLM4 field.
	ADC_CLM4_CLM4_Msk = 0x3ff

	// CLM3: ADC Minus-Side General Calibration Value Register
	// Position of CLM3 field.
	ADC_CLM3_CLM3_Pos = 0x0
	// Bit mask of CLM3 field.
	ADC_CLM3_CLM3_Msk = 0x1ff

	// CLM2: ADC Minus-Side General Calibration Value Register
	// Position of CLM2 field.
	ADC_CLM2_CLM2_Pos = 0x0
	// Bit mask of CLM2 field.
	ADC_CLM2_CLM2_Msk = 0xff

	// CLM1: ADC Minus-Side General Calibration Value Register
	// Position of CLM1 field.
	ADC_CLM1_CLM1_Pos = 0x0
	// Bit mask of CLM1 field.
	ADC_CLM1_CLM1_Msk = 0x7f

	// CLM0: ADC Minus-Side General Calibration Value Register
	// Position of CLM0 field.
	ADC_CLM0_CLM0_Pos = 0x0
	// Bit mask of CLM0 field.
	ADC_CLM0_CLM0_Msk = 0x3f
)

// Constants for DAC0: 12-Bit Digital-to-Analog Converter
const (
	// DAT0L: DAC Data Low Register
	// Position of DATA0 field.
	DAC_DATL_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	DAC_DATL_DATA0_Msk = 0xff

	// DAT0H: DAC Data High Register
	// Position of DATA1 field.
	DAC_DATH_DATA1_Pos = 0x0
	// Bit mask of DATA1 field.
	DAC_DATH_DATA1_Msk = 0xf

	// SR: DAC Status Register
	// Position of DACBFRPBF field.
	DAC_SR_DACBFRPBF_Pos = 0x0
	// Bit mask of DACBFRPBF field.
	DAC_SR_DACBFRPBF_Msk = 0x1
	// Bit DACBFRPBF.
	DAC_SR_DACBFRPBF = 0x1
	// The DAC buffer read pointer is not equal to C2[DACBFUP].
	DAC_SR_DACBFRPBF_0 = 0x0
	// The DAC buffer read pointer is equal to C2[DACBFUP].
	DAC_SR_DACBFRPBF_1 = 0x1
	// Position of DACBFRPTF field.
	DAC_SR_DACBFRPTF_Pos = 0x1
	// Bi