// SPDX-FileCopyrightText: 2013-2021 Tobias Lorenz <tobias.lorenz@gmx.net>
//
// SPDX-License-Identifier: GPL-3.0-or-later

#pragma once

#include <Vector/BLF/platform.h>

#include <array>

#include <Vector/BLF/AbstractFile.h>
#include <Vector/BLF/ObjectHeader.h>

#include <Vector/BLF/vector_blf_export.h>

namespace Vector {
namespace BLF {

/**
 * @brief AFDX_ERROR_EVENT
 *
 * AFDX general error event, available since 8.5
 */
struct VECTOR_BLF_EXPORT AfdxErrorEvent final : ObjectHeader {
    AfdxErrorEvent();

    void read(AbstractFile & is) override;
    void write(AbstractFile & os) override;
    uint32_t calculateObjectSize() const override;

    /**
     * @brief application channel
     */
    uint16_t channel {};

    /**
     * @brief Error Level
     *   - 0=error
     *   - 1=warning
     *   - 2=info
     */
    uint16_t errorLevel {};

    /** source identifier */
    uint32_t sourceIdentifier {};

    /** error text */
    std::array<char, 512> errorText {};

    /** error attributes */
    std::array<char, 512> errorAttributes {};
};

}
}
