/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.util.AsyncGUIJob;
import org.openide.util.AsyncInitSupport;
import org.openide.util.BaseUtilities;
import org.openide.util.ContextAwareAction;
import org.openide.util.ContextGlobalProvider;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.TopologicalSortException;
import org.openide.util.UtilitiesCompositeActionMap;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public final class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    @Deprecated
    public static final int OS_DEC = 1024;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINVISTA = 262144;
    public static final int OS_UNIX_OTHER = 524288;
    public static final int OS_OPENBSD = 0x100000;
    @Deprecated
    public static final int OS_WINDOWS_MASK = 303111;
    @Deprecated
    public static final int OS_UNIX_MASK = 1709048;
    public static final int TYPICAL_WINDOWS_TASKBAR_HEIGHT = 27;
    private static final int TYPICAL_MACOSX_MENU_HEIGHT = 24;
    private static Timer clearIntrospector;
    private static ActionListener doClear;
    private static final int CTRL_WILDCARD_MASK = 32768;
    private static final int ALT_WILDCARD_MASK = 65536;
    private static final Map<GraphicsConfiguration, Map<Rectangle, Long>> screenBoundsCache;
    private static Lookup global;
    private static Reference<NamesAndValues> namesAndValues;

    private Utilities() {
    }

    public static ReferenceQueue<Object> activeReferenceQueue() {
        return BaseUtilities.activeReferenceQueue();
    }

    public static int getOperatingSystem() {
        return BaseUtilities.getOperatingSystem();
    }

    public static boolean isWindows() {
        return BaseUtilities.isWindows();
    }

    public static boolean isMac() {
        return BaseUtilities.isMac();
    }

    public static boolean isUnix() {
        return BaseUtilities.isUnix();
    }

    public static boolean isJavaIdentifier(String string) {
        return BaseUtilities.isJavaIdentifier((String)string);
    }

    public static BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            Exceptions.attachMessage((Throwable)introspectionException, (String)("Encountered while introspecting " + clazz.getName()));
            throw introspectionException;
        }
        catch (Error error) {
            Exceptions.attachMessage((Throwable)error, (String)("Encountered while introspecting " + clazz.getName()));
            throw error;
        }
        if (Component.class.isAssignableFrom(clazz)) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!propertyDescriptorArray[i].getName().equals("cursor")) continue;
                try {
                    Method method = Component.class.getDeclaredMethod("getCursor", new Class[0]);
                    Method method2 = Component.class.getDeclaredMethod("setCursor", Cursor.class);
                    propertyDescriptorArray[i] = new PropertyDescriptor("cursor", method, method2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
                break;
            }
        }
        if (beanInfo != null) {
            if (clearIntrospector == null) {
                doClear = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Introspector.flushCaches();
                    }
                };
                clearIntrospector = new Timer(15000, doClear);
                clearIntrospector.setRepeats(false);
            }
            clearIntrospector.restart();
        }
        return beanInfo;
    }

    public static BeanInfo getBeanInfo(Class<?> clazz, Class<?> clazz2) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, clazz2);
    }

    @Deprecated
    public static String[] wrapStringToArray(String string, int n, boolean bl, boolean bl2) {
        BreakIterator breakIterator = bl ? BreakIterator.getWordInstance() : BreakIterator.getCharacterInstance();
        return Utilities.wrapStringToArray(string, n, breakIterator, bl2);
    }

    public static String[] wrapStringToArray(String string, int n, BreakIterator breakIterator, boolean bl) {
        return BaseUtilities.wrapStringToArray((String)string, (int)n, (BreakIterator)breakIterator, (boolean)bl);
    }

    public static String wrapString(String string, int n, BreakIterator breakIterator, boolean bl) {
        return BaseUtilities.wrapString((String)string, (int)n, (BreakIterator)breakIterator, (boolean)bl);
    }

    @Deprecated
    public static String wrapString(String string, int n, boolean bl, boolean bl2) {
        if (bl2) {
            while (string.startsWith("\n")) {
                string = string.substring(1);
            }
            while (string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            string = string.replace('\n', ' ');
        }
        if (n < 1) {
            n = 1;
        }
        if (string.length() <= n) {
            return string;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < string.length() && n2 < string.length() - 1; ++i) {
            if (string.charAt(i) == '\n') {
                vector.addElement(string.substring(n2, i));
                n2 = i + 1;
                n3 = -1;
                continue;
            }
            if (Character.isSpaceChar(string.charAt(i))) {
                n3 = i;
            }
            if (i == string.length() - 1) {
                vector.addElement(string.substring(n2));
                break;
            }
            if (i - n2 != n) continue;
            if (bl && n3 != -1) {
                vector.addElement(string.substring(n2, n3));
                n2 = n3 + 1;
                n3 = -1;
                continue;
            }
            vector.addElement(string.substring(n2, i));
            n2 = i;
            n3 = -1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuilder.append((String)enumeration.nextElement());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String replaceString(String string, String string2, String string3) {
        int n;
        int n2 = 0;
        if ("".equals(string2)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ((n = string.indexOf(string2, n2)) == -1) {
                stringBuilder.append(string.substring(n2));
                return stringBuilder.toString();
            }
            stringBuilder.append(string.substring(n2, n));
            stringBuilder.append(string3);
        } while ((n2 = n + string2.length()) != string.length());
        return stringBuilder.toString();
    }

    public static String pureClassName(String string) {
        return BaseUtilities.pureClassName((String)string);
    }

    @Deprecated
    public static boolean isLargeFrameIcons() {
        return Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 32;
    }

    @Deprecated
    public static int arrayHashCode(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            Object object = objectArray[i];
            int n3 = object == null ? 1 : object.hashCode();
            n += n3 ^ i;
        }
        return n;
    }

    public static boolean compareObjects(Object object, Object object2) {
        return BaseUtilities.compareObjects((Object)object, (Object)object2);
    }

    public static boolean compareObjectsImpl(Object object, Object object2, int n) {
        return BaseUtilities.compareObjectsImpl((Object)object, (Object)object2, (int)n);
    }

    public static String getClassName(Class<?> clazz) {
        return BaseUtilities.getClassName(clazz);
    }

    public static String getShortClassName(Class<?> clazz) {
        return BaseUtilities.getShortClassName(clazz);
    }

    public static Object toPrimitiveArray(Object[] objectArray) {
        return BaseUtilities.toPrimitiveArray((Object[])objectArray);
    }

    public static Object[] toObjectArray(Object object) {
        return BaseUtilities.toObjectArray((Object)object);
    }

    public static Class<?> getObjectType(Class<?> clazz) {
        return BaseUtilities.getObjectType(clazz);
    }

    public static Class<?> getPrimitiveType(Class<?> clazz) {
        return BaseUtilities.getPrimitiveType(clazz);
    }

    public static Component getFocusTraversableComponent(Component component) {
        if (component.isFocusable()) {
            return component;
        }
        if (!(component instanceof Container)) {
            return null;
        }
        int n = ((Container)component).getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component2 = ((Container)component).getComponent(i);
            if (component2 == null) continue;
            return component2;
        }
        return null;
    }

    public static String[] parseParameters(String string) {
        return BaseUtilities.parseParameters((String)string);
    }

    public static String escapeParameters(String[] stringArray) {
        return BaseUtilities.escapeParameters((String[])stringArray);
    }

    private static synchronized NamesAndValues initNameAndValues() {
        Object object;
        if (namesAndValues != null && (object = namesAndValues.get()) != null) {
            return object;
        }
        object = KeyEvent.class.getDeclaredFields();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(((Field[])object).length * 4 / 3 + 5, 0.75f);
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>(((Field[])object).length * 4 / 3 + 5, 0.75f);
        for (Field field : object) {
            String string;
            if (!Modifier.isStatic(field.getModifiers()) || !(string = field.getName()).startsWith("VK_")) continue;
            string = string.substring(3);
            try {
                int illegalArgumentException = field.getInt(null);
                hashMap.put(string, illegalArgumentException);
                hashMap2.put(illegalArgumentException, string);
            }
            catch (IllegalArgumentException illegalAccessException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (hashMap.get("CONTEXT_MENU") == null) {
            hashMap.put("CONTEXT_MENU", 524);
            hashMap2.put(524, "CONTEXT_MENU");
            hashMap.put("WINDOWS", 525);
            hashMap2.put(525, "WINDOWS");
        }
        hashMap.put("MOUSE_WHEEL_UP", 656);
        hashMap.put("MOUSE_WHEEL_DOWN", 657);
        hashMap2.put(656, "MOUSE_WHEEL_UP");
        hashMap2.put(657, "MOUSE_WHEEL_DOWN");
        NamesAndValues namesAndValues = new NamesAndValues(hashMap2, hashMap);
        Utilities.namesAndValues = new SoftReference<NamesAndValues>(namesAndValues);
        return namesAndValues;
    }

    public static String keyToString(KeyStroke keyStroke) {
        StringBuilder stringBuilder = new StringBuilder();
        if (Utilities.addModifiers(stringBuilder, keyStroke.getModifiers())) {
            stringBuilder.append('-');
        }
        Utilities.appendRest(stringBuilder, keyStroke);
        return stringBuilder.toString();
    }

    private static void appendRest(StringBuilder stringBuilder, KeyStroke keyStroke) {
        String string = Utilities.initNameAndValues().keyToString.get(keyStroke.getKeyCode());
        if (string == null) {
            stringBuilder.append(keyStroke.getKeyChar());
        } else {
            stringBuilder.append(string);
        }
    }

    public static String keyToString(KeyStroke keyStroke, boolean bl) {
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (Utilities.addModifiersPortable(stringBuilder, keyStroke.getModifiers())) {
                stringBuilder.append('-');
            }
            Utilities.appendRest(stringBuilder, keyStroke);
            return stringBuilder.toString();
        }
        return Utilities.keyToString(keyStroke);
    }

    public static KeyStroke stringToKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(Locale.ENGLISH), "-", true);
        int n = 0;
        Map<String, Integer> map = Utilities.initNameAndValues().stringToKey;
        int n2 = -1;
        try {
            String string2;
            while (true) {
                if ((string2 = stringTokenizer.nextToken()).equals("-")) {
                    if (n2 == -1) continue;
                    n |= n2;
                    n2 = -1;
                    continue;
                }
                if (!stringTokenizer.hasMoreElements()) break;
                n2 = Utilities.readModifiers(string2);
            }
            Integer n3 = map.get(string2);
            boolean bl = (n & 0x8000) != 0;
            boolean bl2 = ((n &= 0xFFFF7FFF) & 0x10000) != 0;
            n &= 0xFFFEFFFF;
            if (n3 != null) {
                if (bl && Utilities.isMac() && !Utilities.usableKeyOnMac(n3, bl2 ? n | 2 : (n |= Utilities.getMenuShortcutKeyMask()))) {
                    n &= ~Utilities.getMenuShortcutKeyMask();
                    n = bl2 ? (n |= 8) : (n |= 2);
                }
                if (bl2) {
                    n = Utilities.getOperatingSystem() == 4096 ? (n |= 2) : (n |= 8);
                }
                return KeyStroke.getKeyStroke(n3, n);
            }
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private static boolean usableKeyOnMac(int n, int n2) {
        boolean bl;
        if (n == 81) {
            return false;
        }
        boolean bl2 = (n2 & 4) != 0 || (n2 & 0x80) != 0;
        boolean bl3 = (n2 & 8) != 0 || (n2 & 0x200) != 0;
        boolean bl4 = bl = bl2 && (n2 & 0xFFFFFEFB) == 0;
        if (bl) {
            return n != 72 && n != 32 && n != 9;
        }
        if (n == 68 && bl2 && bl3) {
            return false;
        }
        return n != 32 || !bl2 || (n2 & 2) == 0;
    }

    private static int getMenuShortcutKeyMask() {
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 2;
    }

    public static KeyStroke[] stringToKeys(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(Locale.ENGLISH), " ");
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreElements()) {
            string = stringTokenizer.nextToken();
            KeyStroke keyStroke = Utilities.stringToKey(string);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    private static boolean addModifiers(StringBuilder stringBuilder, int n) {
        boolean bl = false;
        if ((n & 2) != 0) {
            stringBuilder.append("C");
            bl = true;
        }
        if ((n & 8) != 0) {
            stringBuilder.append("A");
            bl = true;
        }
        if ((n & 1) != 0) {
            stringBuilder.append("S");
            bl = true;
        }
        if ((n & 4) != 0) {
            stringBuilder.append("M");
            bl = true;
        }
        if ((n & 0x8000) != 0) {
            stringBuilder.append("D");
            bl = true;
        }
        if ((n & 0x10000) != 0) {
            stringBuilder.append("O");
            bl = true;
        }
        return bl;
    }

    private static boolean addModifiersPortable(StringBuilder stringBuilder, int n) {
        boolean bl = false;
        if ((n & 1) != 0) {
            stringBuilder.append('S');
            bl = true;
        }
        if (Utilities.isMac() && (n & 4) != 0 || !Utilities.isMac() && (n & 2) != 0) {
            stringBuilder.append('D');
            bl = true;
        }
        if (Utilities.isMac() && (n & 2) != 0 || !Utilities.isMac() && (n & 8) != 0) {
            stringBuilder.append('O');
            bl = true;
        }
        if (Utilities.isMac() && (n & 8) != 0) {
            stringBuilder.append('A');
            bl = true;
        }
        if (!Utilities.isMac() && (n & 4) != 0) {
            stringBuilder.append('M');
            bl = true;
        }
        return bl;
    }

    private static int readModifiers(String string) throws NoSuchElementException {
        int n = 0;
        block8: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'C': {
                    n |= 2;
                    continue block8;
                }
                case 'A': {
                    n |= 8;
                    continue block8;
                }
                case 'M': {
                    n |= 4;
                    continue block8;
                }
                case 'S': {
                    n |= 1;
                    continue block8;
                }
                case 'D': {
                    n |= 0x8000;
                    continue block8;
                }
                case 'O': {
                    n |= 0x10000;
                    continue block8;
                }
                default: {
                    throw new NoSuchElementException(string);
                }
            }
        }
        return n;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null) {
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window != null) {
                return window.getGraphicsConfiguration();
            }
            Frame frame = Utilities.findMainWindow();
            if (frame != null) {
                return frame.getGraphicsConfiguration();
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return Utilities.getUsableScreenBounds(Utilities.getCurrentGraphicsConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle getUsableScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        if (screenBoundsCache == null) {
            return Utilities.calculateUsableScreenBounds(graphicsConfiguration);
        }
        Map<GraphicsConfiguration, Map<Rectangle, Long>> map = screenBoundsCache;
        synchronized (map) {
            Map<Rectangle, Long> map2 = screenBoundsCache.get(graphicsConfiguration);
            if (map2 != null) {
                long l = System.currentTimeMillis();
                Map.Entry<Rectangle, Long> entry = map2.entrySet().iterator().next();
                if (entry.getValue() < l + 10000L) {
                    return new Rectangle(entry.getKey());
                }
            }
            Rectangle rectangle = Utilities.calculateUsableScreenBounds(graphicsConfiguration);
            map2 = new HashMap<Rectangle, Long>(1);
            map2.put(rectangle, System.currentTimeMillis());
            if (screenBoundsCache.size() > 20) {
                screenBoundsCache.clear();
            }
            screenBoundsCache.put(graphicsConfiguration, map2);
            return new Rectangle(rectangle);
        }
    }

    private static Rectangle calculateUsableScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        Rectangle rectangle = new Rectangle(graphicsConfiguration.getBounds());
        String string = System.getProperty("netbeans.screen.insets");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            if (stringTokenizer.countTokens() == 4) {
                try {
                    rectangle.y = Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.x = Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.height -= rectangle.y + Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.width -= rectangle.x + Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.log(Level.WARNING, null, numberFormatException);
                }
            }
            return rectangle;
        }
        string = System.getProperty("netbeans.taskbar.height");
        if (string != null) {
            rectangle.height -= Integer.getInteger(string, 0).intValue();
            return rectangle;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
            if (insets.left > rectangle.x && rectangle.x > 0) {
                insets.left -= rectangle.x;
            }
            if (insets.top > rectangle.y && rectangle.y > 0) {
                insets.top -= rectangle.y;
            }
            rectangle.y += insets.top;
            rectangle.x += insets.left;
            rectangle.height -= insets.top + insets.bottom;
            rectangle.width -= insets.left + insets.right;
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, null, exception);
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            rectangle = new Rectangle(graphicsConfiguration.getBounds());
        }
        return rectangle;
    }

    public static Rectangle findCenterBounds(Dimension dimension) {
        return Utilities.findCenterBounds(Utilities.getCurrentGraphicsConfiguration(), dimension);
    }

    private static Rectangle findCenterBounds(GraphicsConfiguration graphicsConfiguration, Dimension dimension) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return new Rectangle(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2, dimension.width, dimension.height);
    }

    private static Frame findMainWindow() {
        Frame frame = null;
        for (Frame frame2 : Frame.getFrames()) {
            if (!"NbMainWindow".equals(frame2.getName())) continue;
            if (frame2.getWidth() == 0 && frame2.getHeight() == 0) break;
            frame = frame2;
            break;
        }
        return frame;
    }

    public static Component findDialogParent() {
        return Utilities.findDialogParent(null);
    }

    public static Component findDialogParent(Component component) {
        Component component2 = component;
        if (component2 == null) {
            component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (component2 == null) {
            component2 = window;
        } else if (window instanceof Dialog && ((Dialog)window).isModal()) {
            Window window2;
            Window window3 = window2 = component2 instanceof Window ? (Window)component2 : SwingUtilities.windowForComponent(component2);
            if (window2 != window) {
                return window;
            }
        }
        if (component2 == null) {
            component2 = Utilities.findMainWindow();
        }
        return component2;
    }

    public static boolean isModalDialogOpen() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        return window instanceof Dialog && ((Dialog)window).isModal();
    }

    @Deprecated
    public static Dimension getScreenSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (Utilities.isWindows() && !Boolean.getBoolean("netbeans.no.taskbar")) {
            dimension.height -= 27;
        } else if (Utilities.isMac()) {
            dimension.height -= 24;
        }
        return dimension;
    }

    @Deprecated
    public static int showJFileChooser(JFileChooser jFileChooser, Component component, String string) {
        if (string != null) {
            jFileChooser.setApproveButtonText(string);
            jFileChooser.setDialogType(2);
        }
        Frame frame = null;
        Dialog dialog = null;
        if (component instanceof Dialog) {
            dialog = (Dialog)component;
        } else {
            frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
        }
        String string2 = jFileChooser.getDialogTitle();
        if (string2 == null) {
            string2 = jFileChooser.getUI().getDialogTitle(jFileChooser);
        }
        final JDialog jDialog = dialog != null ? new JDialog(dialog, string2, true) : new JDialog(frame, string2, true);
        jDialog.setDefaultCloseOperation(2);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jFileChooser, "Center");
        jDialog.pack();
        jDialog.setBounds(Utilities.findCenterBounds(component.getGraphicsConfiguration(), jDialog.getSize()));
        jFileChooser.rescanCurrentDirectory();
        final int[] nArray = new int[]{1};
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("ApproveSelection".equals(actionEvent.getActionCommand())) {
                    nArray[0] = 0;
                }
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        };
        jFileChooser.addActionListener(actionListener);
        jDialog.show();
        return nArray[0];
    }

    @Deprecated
    public static List partialSort(List list, Comparator comparator, boolean bl) throws UnorderableException {
        Set<Iterator<Object>> set;
        Object object;
        Iterator<Object> iterator;
        int n;
        HashMap<Object, HashSet<Iterator<Object>>> hashMap = new HashMap<Object, HashSet<Iterator<Object>>>();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                n = comparator.compare(list.get(i), list.get(j));
                if (n == 0) continue;
                iterator = list.get(n < 0 ? i : j);
                object = list.get(n > 0 ? i : j);
                set = (Set)hashMap.get(object);
                if (set == null) {
                    set = new HashSet<Iterator<Object>>();
                    hashMap.put(object, (HashSet<Iterator<Object>>)set);
                }
                set.add(iterator);
            }
        }
        LinkedList linkedList = new LinkedList(list);
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        while (linkedList.size() > 0) {
            n = 0;
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                set = (HashSet<Iterator<Object>>)hashMap.get(object);
                if (set != null && !set.isEmpty()) continue;
                iterator.remove();
                n = 1;
                arrayList.add(object);
                for (Object e : linkedList) {
                    Set set2 = (Set)hashMap.get(e);
                    if (set2 == null) continue;
                    set2.remove(object);
                }
                if (!bl) continue;
                break;
            }
            if (n != 0) continue;
            iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                if (!linkedList.contains(object.getKey())) {
                    iterator.remove();
                    continue;
                }
                set = (Set)object.getValue();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    if (linkedList.contains(iterator2.next())) continue;
                    iterator2.remove();
                }
                if (!set.isEmpty()) continue;
                iterator.remove();
            }
            throw new UnorderableException(linkedList, hashMap);
        }
        return arrayList;
    }

    public static <T> List<T> topologicalSort(Collection<? extends T> collection, Map<? super T, ? extends Collection<? extends T>> map) throws TopologicalSortException {
        return BaseUtilities.topologicalSort(collection, map);
    }

    public static String translate(String string) {
        return BaseUtilities.translate((String)string);
    }

    @Deprecated
    public static Image mergeImages(Image image, Image image2, int n, int n2) {
        return ImageUtilities.mergeImages(image, image2, n, n2);
    }

    @Deprecated
    public static Image loadImage(String string) {
        return ImageUtilities.loadImage(string);
    }

    @Deprecated
    public static Image icon2Image(Icon icon) {
        return ImageUtilities.icon2Image(icon);
    }

    /*
     * WARNING - void declaration
     */
    public static JPopupMenu actionsToPopup(Action[] actionArray, Lookup lookup) {
        HashSet<Action> hashSet = new HashSet<Action>();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Action action : actionArray) {
            if (action != null && hashSet.add(action)) {
                void var8_11;
                void object;
                if (action instanceof ContextAwareAction) {
                    Action action2 = ((ContextAwareAction)action).createContextAwareInstance(lookup);
                    if (action2 == null) {
                        Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "ContextAwareAction.createContextAwareInstance(context) returns null. That is illegal! action={0}, context={1}", new Object[]{action, lookup});
                    } else {
                        Action action3 = action2;
                    }
                }
                if (object instanceof Presenter.Popup) {
                    JMenuItem jMenuItem = ((Presenter.Popup)object).getPopupPresenter();
                    if (jMenuItem == null) {
                        Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "findContextMenuImpl, getPopupPresenter returning null for {0}", object);
                        continue;
                    }
                } else {
                    JMenuItem jMenuItem = ActionPresenterProvider.getDefault().createPopupPresenter((Action)object);
                }
                for (Component component : ActionPresenterProvider.getDefault().convertComponents((Component)var8_11)) {
                    if (component instanceof JSeparator) {
                        arrayList.add(null);
                        continue;
                    }
                    arrayList.add(component);
                }
                continue;
            }
            arrayList.add(null);
        }
        JPopupMenu jPopupMenu = ActionPresenterProvider.getDefault().createEmptyPopup();
        int n = 0;
        int n2 = 0;
        for (Component component : arrayList) {
            try {
                if (component == null) {
                    n2 = n;
                    continue;
                }
                n = 1;
                if (n2 != 0) {
                    n2 = 0;
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add(component);
            }
            catch (RuntimeException runtimeException) {
                Exceptions.attachMessage((Throwable)runtimeException, (String)("Current component: " + component));
                Exceptions.attachMessage((Throwable)runtimeException, (String)("List of components: " + arrayList));
                Exceptions.attachMessage((Throwable)runtimeException, (String)("List of actions: " + Arrays.asList(actionArray)));
                Exceptions.printStackTrace((Throwable)runtimeException);
            }
        }
        return jPopupMenu;
    }

    public static JPopupMenu actionsToPopup(Action[] actionArray, Component component) {
        Serializable serializable;
        Lookup lookup = null;
        for (serializable = component; !(serializable == null || serializable instanceof Lookup.Provider && (lookup = ((Lookup.Provider)serializable).getLookup()) != null); serializable = serializable.getParent()) {
        }
        if (lookup == null) {
            serializable = new UtilitiesCompositeActionMap(component);
            lookup = Lookups.singleton((Object)serializable);
        }
        return Utilities.actionsToPopup(actionArray, lookup);
    }

    public static List<? extends Action> actionsForPath(String string) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (Lookup.Item item : Lookups.forPath((String)string).lookupResult(Object.class).allItems()) {
            if (Action.class.isAssignableFrom(item.getType())) {
                Object object = item.getInstance();
                if (object == null) continue;
                arrayList.add((Action)object);
                continue;
            }
            if (JSeparator.class.isAssignableFrom(item.getType())) {
                arrayList.add(null);
                continue;
            }
            Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "Unrecognized object of {0} found in actions path {1}", new Object[]{item.getType(), string});
        }
        return arrayList;
    }

    public static List<? extends Action> actionsForPath(String string, Lookup lookup) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (Lookup.Item item : Lookups.forPath((String)string).lookupResult(Object.class).allItems()) {
            if (Action.class.isAssignableFrom(item.getType())) {
                Object object = item.getInstance();
                if (object instanceof ContextAwareAction) {
                    Action action = ((ContextAwareAction)object).createContextAwareInstance(lookup);
                    if (action == null) {
                        Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "ContextAwareAction.createContextAwareInstance(context) returns null. That is illegal! action={0}, context={1}", new Object[]{object, lookup});
                    } else {
                        object = action;
                    }
                }
                arrayList.add((Action)object);
                continue;
            }
            if (JSeparator.class.isAssignableFrom(item.getType())) {
                arrayList.add(null);
                continue;
            }
            Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "Unrecognized object of {0} found in actions path {1}", new Object[]{item.getType(), string});
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lookup actionsGlobalContext() {
        Object object = ContextGlobalProvider.class;
        synchronized (ContextGlobalProvider.class) {
            if (global != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return global;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            object = (ContextGlobalProvider)Lookup.getDefault().lookup(ContextGlobalProvider.class);
            Lookup lookup = object == null ? Lookup.EMPTY : object.createGlobalContext();
            Class<ContextGlobalProvider> clazz = ContextGlobalProvider.class;
            synchronized (ContextGlobalProvider.class) {
                if (global == null) {
                    global = lookup;
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return global;
            }
        }
    }

    @Deprecated
    public static Image loadImage(String string, boolean bl) {
        return ImageUtilities.loadImage(string, bl);
    }

    public static Cursor createProgressCursor(Component component) {
        if (component == null) {
            throw new NullPointerException("Given component is null");
        }
        Image image = null;
        image = Utilities.isMac() ? ImageUtilities.loadImage("org/openide/util/progress-cursor-mac.gif") : (Utilities.isUnix() ? ImageUtilities.loadImage("org/openide/util/progress-cursor-motif.gif") : ImageUtilities.loadImage("org/openide/util/progress-cursor-win.gif"));
        return Utilities.createCustomCursor(component, image, "PROGRESS_CURSOR");
    }

    public static Cursor createCustomCursor(Component component, Image image, String string) {
        Toolkit toolkit = component.getToolkit();
        Dimension dimension = toolkit.getBestCursorSize(16, 16);
        Image image2 = image;
        if (dimension.width != image.getWidth(null)) {
            if (dimension.width == 0 && dimension.height == 0) {
                return Cursor.getPredefinedCursor(3);
            }
            BufferedImage bufferedImage = ImageUtilities.createBufferedImage(dimension.width, dimension.height);
            image2 = ImageUtilities.mergeImages(image, bufferedImage, 0, 0);
        }
        return toolkit.createCustomCursor(image2, new Point(1, 1), string);
    }

    public static void attachInitJob(Component component, AsyncGUIJob asyncGUIJob) {
        new AsyncInitSupport(component, asyncGUIJob);
    }

    public static URI toURI(File file) {
        return BaseUtilities.toURI((File)file);
    }

    public static File toFile(URI uRI) throws IllegalArgumentException {
        return BaseUtilities.toFile((URI)uRI);
    }

    @Deprecated
    public static URL toURL(File file) throws MalformedURLException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Relative path: " + file);
        }
        URI uRI = Utilities.toURI(file);
        return uRI.toURL();
    }

    @Deprecated
    public static File toFile(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException();
        }
        try {
            URI uRI = uRL.toURI();
            return Utilities.toFile(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static void disabledActionBeep() {
        if (Utilities.isWindows()) {
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    static {
        boolean bl = !GraphicsEnvironment.isHeadless() && Utilities.isUnix() && !Utilities.isMac() && System.getProperty("netbeans.screen.insetsCache", "true").equalsIgnoreCase("true");
        screenBoundsCache = bl ? new WeakHashMap<GraphicsConfiguration, Map<Rectangle, Long>>() : null;
    }

    @Deprecated
    public static class UnorderableException
    extends RuntimeException {
        static final long serialVersionUID = 6749951134051806661L;
        private Collection unorderable;
        private Map deps;

        public UnorderableException(Collection collection, Map map) {
            this.unorderable = collection;
            this.deps = map;
        }

        public UnorderableException(String string, Collection collection, Map map) {
            super(string);
            this.unorderable = collection;
            this.deps = map;
        }

        public Collection getUnorderable() {
            return this.unorderable;
        }

        public Map getDeps() {
            return this.deps;
        }
    }

    private static final class NamesAndValues {
        final Map<Integer, String> keyToString;
        final Map<String, Integer> stringToKey;

        NamesAndValues(Map<Integer, String> map, Map<String, Integer> map2) {
            this.keyToString = map;
            this.stringToKey = map2;
        }
    }
}

