/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.graalvm.visualvm.lib.jfluid.heap.CacheDirectory;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDump;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDumpInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDumpSegment;
import org.graalvm.visualvm.lib.jfluid.heap.ComputedSummary;
import org.graalvm.visualvm.lib.jfluid.heap.DominatorTree;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.HeapProgress;
import org.graalvm.visualvm.lib.jfluid.heap.HeapSummary;
import org.graalvm.visualvm.lib.jfluid.heap.HprofArrayValue;
import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofField;
import org.graalvm.visualvm.lib.jfluid.heap.HprofFieldObjectValue;
import org.graalvm.visualvm.lib.jfluid.heap.HprofGCRoots;
import org.graalvm.visualvm.lib.jfluid.heap.HprofInstanceObjectValue;
import org.graalvm.visualvm.lib.jfluid.heap.HprofProxy;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.InstanceDump;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.LoadClassSegment;
import org.graalvm.visualvm.lib.jfluid.heap.LongBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.LongIterator;
import org.graalvm.visualvm.lib.jfluid.heap.LongMap;
import org.graalvm.visualvm.lib.jfluid.heap.NearestGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayDump;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayDump;
import org.graalvm.visualvm.lib.jfluid.heap.StackFrameSegment;
import org.graalvm.visualvm.lib.jfluid.heap.StackTraceSegment;
import org.graalvm.visualvm.lib.jfluid.heap.StringSegment;
import org.graalvm.visualvm.lib.jfluid.heap.Summary;
import org.graalvm.visualvm.lib.jfluid.heap.SyntheticClassField;
import org.graalvm.visualvm.lib.jfluid.heap.SyntheticClassObjectValue;
import org.graalvm.visualvm.lib.jfluid.heap.TagBounds;
import org.graalvm.visualvm.lib.jfluid.heap.TreeObject;
import org.graalvm.visualvm.lib.jfluid.heap.Value;

class HprofHeap
implements Heap {
    static final int STRING = 1;
    static final int LOAD_CLASS = 2;
    private static final int UNLOAD_CLASS = 3;
    static final int STACK_FRAME = 4;
    static final int STACK_TRACE = 5;
    private static final int ALLOC_SITES = 6;
    static final int HEAP_SUMMARY = 7;
    private static final int START_THREAD = 10;
    private static final int END_THREAD = 11;
    private static final int HEAP_DUMP = 12;
    private static final int HEAP_DUMP_SEGMENT = 28;
    private static final int HEAP_DUMP_END = 44;
    private static final int CPU_SAMPLES = 13;
    private static final int CONTROL_SETTINGS = 14;
    static final int ROOT_UNKNOWN = 255;
    static final int ROOT_JNI_GLOBAL = 1;
    static final int ROOT_JNI_LOCAL = 2;
    static final int ROOT_JAVA_FRAME = 3;
    static final int ROOT_NATIVE_STACK = 4;
    static final int ROOT_STICKY_CLASS = 5;
    static final int ROOT_THREAD_BLOCK = 6;
    static final int ROOT_MONITOR_USED = 7;
    static final int ROOT_THREAD_OBJECT = 8;
    static final int CLASS_DUMP = 32;
    static final int INSTANCE_DUMP = 33;
    static final int OBJECT_ARRAY_DUMP = 34;
    static final int PRIMITIVE_ARRAY_DUMP = 35;
    static final int HEAP_DUMP_INFO = 254;
    static final int ROOT_INTERNED_STRING = 137;
    static final int ROOT_FINALIZING = 138;
    static final int ROOT_DEBUGGER = 139;
    static final int ROOT_REFERENCE_CLEANUP = 140;
    static final int ROOT_VM_INTERNAL = 141;
    static final int ROOT_JNI_MONITOR = 142;
    static final int UNREACHABLE = 144;
    static final int PRIMITIVE_ARRAY_NODATA_DUMP = 195;
    static final int OBJECT = 2;
    static final int BOOLEAN = 4;
    static final int CHAR = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BYTE = 8;
    static final int SHORT = 9;
    static final int INT = 10;
    static final int LONG = 11;
    private static final boolean DEBUG = false;
    private static final String SNAPSHOT_ID = "NBPHD";
    private static final int SNAPSHOT_VERSION = 4;
    private static final String OS_PROP = "os.name";
    HprofByteBuffer dumpBuffer;
    LongMap idToOffsetMap;
    private NearestGCRoot nearestGCRoot;
    final HprofGCRoots gcRoots;
    private ComputedSummary computedSummary;
    private final Object computedSummaryLock = new Object();
    private DominatorTree domTree;
    private TagBounds allInstanceDumpBounds;
    private TagBounds heapDumpSegment;
    private TagBounds[] heapTagBounds;
    private TagBounds[] tagBounds = new TagBounds[255];
    private boolean instancesCountComputed;
    private final Object instancesCountLock = new Object();
    private boolean referencesComputed;
    private final Object referencesLock = new Object();
    private boolean retainedSizeComputed;
    private final Object retainedSizeLock = new Object();
    private boolean retainedSizeByClassComputed;
    private final Object retainedSizeByClassLock = new Object();
    private int idMapSize;
    private int segment;
    File heapDumpFile;
    CacheDirectory cacheDirectory;

    HprofHeap(File dumpFile, int seg, CacheDirectory cacheDir) throws FileNotFoundException, IOException {
        this.cacheDirectory = cacheDir;
        this.dumpBuffer = cacheDir.createHprofByteBuffer(dumpFile);
        this.segment = seg;
        this.fillTagBounds(this.dumpBuffer.getHeaderSize());
        this.heapDumpSegment = this.computeHeapDumpStart();
        if (this.heapDumpSegment != null) {
            this.fillHeapTagBounds();
        }
        this.idToOffsetMap = new LongMap(this.idMapSize, this.dumpBuffer.getIDSize(), this.dumpBuffer.getFoffsetSize(), this.cacheDirectory);
        this.nearestGCRoot = new NearestGCRoot(this);
        this.gcRoots = new HprofGCRoots(this);
        this.heapDumpFile = dumpFile;
    }

    @Override
    public List<JavaClass> getAllClasses() {
        if (this.heapDumpSegment == null) {
            return Collections.emptyList();
        }
        ClassDumpSegment classDumpBounds = this.getClassDumpSegment();
        if (classDumpBounds == null) {
            return Collections.emptyList();
        }
        return classDumpBounds.createClassCollection();
    }

    @Override
    public List<Instance> getBiggestObjectsByRetainedSize(int number) {
        ArrayList<Instance> bigObjects = new ArrayList<Instance>(number);
        this.computeRetainedSize();
        long[] ids = this.idToOffsetMap.getBiggestObjectsByRetainedSize(number);
        for (int i = 0; i < ids.length; ++i) {
            bigObjects.add(this.getInstanceByID(ids[i]));
        }
        return bigObjects;
    }

    @Override
    public Collection<GCRoot> getGCRoots(Instance instance) {
        Long instanceId = instance.getInstanceId();
        Object gcroot = this.gcRoots.getGCRoots(instanceId);
        if (gcroot == null) {
            return Collections.emptyList();
        }
        if (gcroot instanceof GCRoot) {
            return Collections.singletonList((GCRoot)gcroot);
        }
        return Collections.unmodifiableCollection((Collection)gcroot);
    }

    @Override
    public Collection<GCRoot> getGCRoots() {
        if (this.heapDumpSegment == null) {
            return Collections.emptyList();
        }
        return this.gcRoots.getGCRoots();
    }

    @Override
    public Instance getInstanceByID(long instanceID) {
        if (instanceID == 0L) {
            return null;
        }
        this.computeInstances();
        LongMap.Entry entry = this.idToOffsetMap.get(instanceID);
        if (entry == null) {
            return null;
        }
        return this.getInstanceByOffset(new long[]{entry.getOffset()});
    }

    @Override
    public JavaClass getJavaClassByID(long javaclassId) {
        return this.getClassDumpSegment().getClassDumpByID(javaclassId);
    }

    @Override
    public JavaClass getJavaClassByName(String fqn) {
        if (this.heapDumpSegment == null) {
            return null;
        }
        return this.getClassDumpSegment().getJavaClassByName(fqn);
    }

    @Override
    public Collection<JavaClass> getJavaClassesByRegExp(String regexp) {
        if (this.heapDumpSegment == null) {
            return Collections.emptyList();
        }
        return this.getClassDumpSegment().getJavaClassesByRegExp(regexp);
    }

    @Override
    public Iterator<Instance> getAllInstancesIterator() {
        List<JavaClass> classes = this.getAllClasses();
        if (classes.isEmpty()) {
            return Collections.emptyIterator();
        }
        return new InstancesIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HeapSummary getSummary() {
        TagBounds summaryBound = this.tagBounds[7];
        if (summaryBound != null) {
            return new Summary(this.dumpBuffer, summaryBound.startOffset);
        }
        Object object = this.computedSummaryLock;
        synchronized (object) {
            if (this.computedSummary == null) {
                this.computedSummary = new ComputedSummary(this);
            }
        }
        return this.computedSummary;
    }

    @Override
    public Properties getSystemProperties() {
        JavaClass systemClass = this.getJavaClassByName("java.lang.System");
        if (systemClass != null) {
            Instance props = (Instance)systemClass.getValueOfStaticField("props");
            if (props == null) {
                props = (Instance)systemClass.getValueOfStaticField("systemProperties");
            }
            if (props != null) {
                return HprofProxy.getProperties(props);
            }
        }
        if ((systemClass = this.getJavaClassByName("com.oracle.svm.core.jdk.SystemPropertiesSupport")) != null) {
            for (JavaClass propSupportSubClass : systemClass.getSubClasses()) {
                Instance propSupportInstance;
                Object props;
                List<Instance> propSupportInstances = propSupportSubClass.getInstances();
                if (propSupportInstances.isEmpty() || !((props = (propSupportInstance = propSupportInstances.get(0)).getValueOfField("properties")) instanceof Instance)) continue;
                return HprofProxy.getProperties((Instance)props);
            }
        }
        return null;
    }

    @Override
    public boolean isRetainedSizeComputed() {
        return this.retainedSizeComputed;
    }

    @Override
    public boolean isRetainedSizeByClassComputed() {
        return this.retainedSizeByClassComputed;
    }

    void writeToFile() {
        if (!this.cacheDirectory.isTemporary()) {
            try {
                File outFile = this.cacheDirectory.getHeapDumpAuxFile();
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 32768));
                this.writeToStream(out);
                out.close();
                this.cacheDirectory.setDirty(false);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    void writeToStream(DataOutputStream out) throws IOException {
        out.writeUTF(SNAPSHOT_ID);
        out.writeInt(4);
        out.writeUTF(this.heapDumpFile.getAbsolutePath());
        out.writeLong(this.dumpBuffer.getTime());
        out.writeUTF(System.getProperty(OS_PROP));
        this.nearestGCRoot.writeToStream(out);
        this.allInstanceDumpBounds.writeToStream(out);
        this.heapDumpSegment.writeToStream(out);
        TagBounds.writeToStream(this.heapTagBounds, out);
        TagBounds.writeToStream(this.tagBounds, out);
        out.writeBoolean(this.instancesCountComputed);
        out.writeBoolean(this.referencesComputed);
        out.writeBoolean(this.retainedSizeComputed);
        out.writeBoolean(this.retainedSizeByClassComputed);
        out.writeInt(this.idMapSize);
        out.writeInt(this.segment);
        this.idToOffsetMap.writeToStream(out);
        out.writeBoolean(this.domTree != null);
        if (this.domTree != null) {
            this.domTree.writeToStream(out);
        }
    }

    HprofHeap(DataInputStream dis, CacheDirectory cacheDir) throws IOException {
        if (cacheDir.isDirty()) {
            throw new IOException("Dirty cache " + cacheDir);
        }
        String id = dis.readUTF();
        if (!SNAPSHOT_ID.equals(id)) {
            throw new IOException("Invalid HPROF dump id " + id);
        }
        int version = dis.readInt();
        if (version != 4) {
            throw new IOException("Invalid HPROF version 4 loaded " + version);
        }
        this.heapDumpFile = cacheDir.getHeapFile(dis.readUTF());
        this.cacheDirectory = cacheDir;
        this.dumpBuffer = HprofByteBuffer.createHprofByteBuffer(this.heapDumpFile);
        long time = dis.readLong();
        if (time != this.dumpBuffer.getTime()) {
            throw new IOException("HPROF time mismatch. Cached " + time + " from heap dump " + this.dumpBuffer.getTime());
        }
        String os = dis.readUTF();
        if (!os.equals(System.getProperty(OS_PROP))) {
            System.err.println("Warning: HPROF OS mismatch. Cached " + os + " current OS " + System.getProperty(OS_PROP));
        }
        this.nearestGCRoot = new NearestGCRoot(this, dis);
        this.allInstanceDumpBounds = new TagBounds(dis);
        this.heapDumpSegment = new TagBounds(dis);
        this.heapTagBounds = new TagBounds[256];
        TagBounds.readFromStream(dis, this, this.heapTagBounds);
        TagBounds.readFromStream(dis, this, this.tagBounds);
        this.instancesCountComputed = dis.readBoolean();
        this.referencesComputed = dis.readBoolean();
        this.retainedSizeComputed = dis.readBoolean();
        this.retainedSizeByClassComputed = dis.readBoolean();
        this.idMapSize = dis.readInt();
        this.segment = dis.readInt();
        this.idToOffsetMap = new LongMap(dis, this.cacheDirectory);
        if (dis.readBoolean()) {
            this.domTree = new DominatorTree(this, dis);
        }
        this.gcRoots = new HprofGCRoots(this);
        this.getClassDumpSegment().extractSpecialClasses();
    }

    ClassDumpSegment getClassDumpSegment() {
        return (ClassDumpSegment)this.heapTagBounds[32];
    }

    LoadClassSegment getLoadClassSegment() {
        return (LoadClassSegment)this.tagBounds[2];
    }

    StringSegment getStringSegment() {
        return (StringSegment)this.tagBounds[1];
    }

    StackTraceSegment getStackTraceSegment() {
        return (StackTraceSegment)this.tagBounds[5];
    }

    StackFrameSegment getStackFrameSegment() {
        return (StackFrameSegment)this.tagBounds[4];
    }

    TagBounds getAllInstanceDumpBounds() {
        return this.allInstanceDumpBounds;
    }

    long getRetainedSize(Instance instance) {
        this.computeRetainedSize();
        return this.idToOffsetMap.get(instance.getInstanceId()).getRetainedSize();
    }

    int getValueSize(byte type) {
        switch (type) {
            case 2: {
                return this.dumpBuffer.getIDSize();
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    Instance getInstanceByOffset(long[] offset) {
        return this.getInstanceByOffset(offset, null, -1L);
    }

    Instance getInstanceByOffset(long[] offset, ClassDump instanceClassDump, long instanceClassId) {
        long start = offset[0];
        assert (start != 0L);
        ClassDumpSegment classDumpBounds = this.getClassDumpSegment();
        int idSize = this.dumpBuffer.getIDSize();
        int classIdOffset = 0;
        int tag = this.readDumpTag(offset);
        if (tag == 33) {
            classIdOffset = idSize + 4;
        } else if (tag == 34) {
            classIdOffset = idSize + 4 + 4;
        } else if (tag == 35) {
            classIdOffset = idSize + 4 + 4;
        }
        if (tag == 35) {
            ClassDump classDump = classDumpBounds.getPrimitiveArrayClass(this.dumpBuffer.get(start + 1L + (long)classIdOffset));
            if (instanceClassId != -1L && classDump.getJavaClassId() != instanceClassId) {
                return null;
            }
            return new PrimitiveArrayDump(classDump, start);
        }
        long classId = this.dumpBuffer.getID(start + 1L + (long)classIdOffset);
        if (instanceClassId != -1L && classId != instanceClassId) {
            return null;
        }
        ClassDump classDump = instanceClassDump == null ? classDumpBounds.getClassDumpByID(classId) : instanceClassDump;
        if (classDump == null) {
            return null;
        }
        if (tag == 33) {
            return new InstanceDump(classDump, start);
        }
        if (tag == 34) {
            return new ObjectArrayDump(classDump, start);
        }
        if (tag == 32) {
            return new ClassDumpInstance(classDump);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeInstances() {
        Object object = this.instancesCountLock;
        synchronized (object) {
            if (this.instancesCountComputed) {
                return;
            }
            HeapProgress.progressStart();
            this.cacheDirectory.setDirty(true);
            ClassDumpSegment classDumpBounds = this.getClassDumpSegment();
            int idSize = this.dumpBuffer.getIDSize();
            long[] offset = new long[]{this.allInstanceDumpBounds.startOffset};
            Map<Long, JavaClass> classIdToClassMap = classDumpBounds.getClassIdToClassMap();
            long counter = 0L;
            while (offset[0] < this.allInstanceDumpBounds.endOffset) {
                int classIdOffset = 0;
                int instanceIdOffset = 0;
                ClassDump classDump = null;
                long start = offset[0];
                int tag = this.readDumpTag(offset);
                LongMap.Entry instanceEntry = null;
                if (tag == 33) {
                    instanceIdOffset = 1;
                    classIdOffset = idSize + 4;
                } else if (tag == 34) {
                    instanceIdOffset = 1;
                    classIdOffset = idSize + 4 + 4;
                } else if (tag == 35) {
                    byte type = this.dumpBuffer.get(start + 1L + (long)idSize + 4L + 4L);
                    instanceIdOffset = 1;
                    classDump = classDumpBounds.getPrimitiveArrayClass(type);
                }
                if (instanceIdOffset != 0) {
                    long instanceId = this.dumpBuffer.getID(start + (long)instanceIdOffset);
                    instanceEntry = this.idToOffsetMap.put(instanceId, start);
                }
                if (classIdOffset != 0) {
                    long classId = this.dumpBuffer.getID(start + 1L + (long)classIdOffset);
                    classDump = (ClassDump)classIdToClassMap.get(new Long(classId));
                }
                if (classDump != null) {
                    classDump.registerInstance(start);
                    instanceEntry.setIndex(classDump.getInstancesCount());
                    classDumpBounds.addInstanceSize(classDump, tag, start);
                }
                HeapProgress.progress(counter, this.allInstanceDumpBounds.startOffset, start, this.allInstanceDumpBounds.endOffset);
                ++counter;
            }
            this.instancesCountComputed = true;
            this.writeToFile();
        }
        HeapProgress.progressFinish();
    }

    List<Value> findReferencesFor(long instanceId) {
        assert (instanceId != 0L) : "InstanceID is null";
        this.computeReferences();
        ArrayList<Value> refs = new ArrayList<Value>();
        LongIterator refIdsIt = this.idToOffsetMap.get(instanceId).getReferences();
        int idSize = this.dumpBuffer.getIDSize();
        ClassDumpSegment classDumpBounds = this.getClassDumpSegment();
        long[] offset = new long[1];
        while (refIdsIt.hasNext()) {
            long foundInstanceId = refIdsIt.next();
            offset[0] = this.idToOffsetMap.get(foundInstanceId).getOffset();
            long start = offset[0];
            int tag = this.readDumpTag(offset);
            if (tag == 33) {
                int size = this.dumpBuffer.getInt(start + 1L + (long)idSize + 4L + (long)idSize);
                byte[] fields = new byte[size];
                this.dumpBuffer.get(start + 1L + (long)idSize + 4L + (long)idSize + 4L, fields);
                long classId = this.dumpBuffer.getID(start + 1L + (long)idSize + 4L);
                ClassDump classDump = classDumpBounds.getClassDumpByID(classId);
                InstanceDump instance = new InstanceDump(classDump, start);
                for (FieldValue field : instance.getFieldValues()) {
                    HprofInstanceObjectValue objectValue;
                    if (!(field instanceof HprofInstanceObjectValue) || (objectValue = (HprofInstanceObjectValue)field).getInstanceId() != instanceId) continue;
                    refs.add(objectValue);
                }
                if (!refs.isEmpty() || classId != instanceId) continue;
                SyntheticClassField syntheticClassField = new SyntheticClassField(classDump);
                long fieldOffset = start + 1L + (long)this.dumpBuffer.getIDSize() + 4L;
                refs.add(new SyntheticClassObjectValue(instance, syntheticClassField, fieldOffset));
                continue;
            }
            if (tag == 34) {
                int elements = this.dumpBuffer.getInt(start + 1L + (long)idSize + 4L);
                long classId = this.dumpBuffer.getID(start + 1L + (long)idSize + 4L + 4L);
                ClassDump classDump = classDumpBounds.getClassDumpByID(classId);
                long position = start + 1L + (long)idSize + 4L + 4L + (long)idSize;
                int i = 0;
                while (i < elements) {
                    if (this.dumpBuffer.getID(position) == instanceId) {
                        refs.add(new HprofArrayValue(classDump, start, i));
                    }
                    ++i;
                    position += (long)idSize;
                }
                continue;
            }
            if (tag != 32) continue;
            ClassDump cls = classDumpBounds.getClassDumpByID(foundInstanceId);
            cls.findStaticReferencesFor(instanceId, refs);
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeReferences() {
        Object object = this.referencesLock;
        synchronized (object) {
            if (this.referencesComputed) {
                return;
            }
            HeapProgress.progressStart();
            ClassDumpSegment classDumpBounds = this.getClassDumpSegment();
            int idSize = this.dumpBuffer.getIDSize();
            long[] offset = new long[]{this.allInstanceDumpBounds.startOffset};
            Map<Long, JavaClass> classIdToClassMap = classDumpBounds.getClassIdToClassMap();
            this.computeInstances();
            this.cacheDirectory.setDirty(true);
            long counter = 0L;
            while (offset[0] < this.allInstanceDumpBounds.endOffset) {
                long start = offset[0];
                int tag = this.readDumpTag(offset);
                if (tag == 33) {
                    long classId = this.dumpBuffer.getID(start + 1L + (long)idSize + 4L);
                    ClassDump classDump = (ClassDump)classIdToClassMap.get(new Long(classId));
                    if (classDump != null) {
                        long instanceId = this.dumpBuffer.getID(start + 1L);
                        long inOff = start + 1L + (long)idSize + 4L + (long)idSize + 4L;
                        for (Field f : classDump.getAllInstanceFields()) {
                            LongMap.Entry entry;
                            long outId;
                            HprofField field = (HprofField)f;
                            if (field.getValueType() == 2 && (outId = this.dumpBuffer.getID(inOff)) != 0L && (entry = this.idToOffsetMap.get(outId)) != null) {
                                entry.addReference(instanceId);
                            }
                            inOff += (long)field.getValueSize();
                        }
                    }
                } else if (tag == 34) {
                    long instanceId = this.dumpBuffer.getID(start + 1L);
                    int elements = this.dumpBuffer.getInt(start + 1L + (long)idSize + 4L);
                    long position = start + 1L + (long)idSize + 4L + 4L + (long)idSize;
                    int i = 0;
                    while (i < elements) {
                        LongMap.Entry entry;
                        long outId = this.dumpBuffer.getID(position);
                        if (outId != 0L && (entry = this.idToOffsetMap.get(outId)) != null) {
                            entry.addReference(instanceId);
                        }
                        ++i;
                        position += (long)idSize;
                    }
                }
                HeapProgress.progress(counter, this.allInstanceDumpBounds.startOffset, start, this.allInstanceDumpBounds.endOffset);
                ++counter;
            }
            for (JavaClass cls : this.getClassDumpSegment().createClassCollection()) {
                for (FieldValue field : cls.getStaticFieldValues()) {
                    LongMap.Entry entry;
                    long outId;
                    if (!(field instanceof HprofFieldObjectValue) || (outId = ((HprofFieldObjectValue)field).getInstanceID()) == 0L || (entry = this.idToOffsetMap.get(outId)) == null) continue;
                    entry.addReference(cls.getJavaClassId());
                }
            }
            this.idToOffsetMap.flush();
            this.referencesComputed = true;
            this.writeToFile();
        }
        HeapProgress.progressFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeRetainedSize() {
        Object object = this.retainedSizeLock;
        synchronized (object) {
            if (this.retainedSizeComputed) {
                return;
            }
            HeapProgress.progressStart();
            LongBuffer leaves = this.nearestGCRoot.getLeaves();
            this.cacheDirectory.setDirty(true);
            new TreeObject(this, leaves).computeTrees();
            this.domTree = new DominatorTree(this, this.nearestGCRoot.getMultipleParents());
            this.domTree.computeDominators();
            long[] offset = new long[]{this.allInstanceDumpBounds.startOffset};
            long counter = 0L;
            while (offset[0] < this.allInstanceDumpBounds.endOffset) {
                block19: {
                    long start;
                    int instanceIdOffset;
                    block17: {
                        int tag;
                        block18: {
                            block16: {
                                instanceIdOffset = 0;
                                start = offset[0];
                                tag = this.readDumpTag(offset);
                                if (tag != 33) break block16;
                                instanceIdOffset = 1;
                                break block17;
                            }
                            if (tag != 34) break block18;
                            instanceIdOffset = 1;
                            break block17;
                        }
                        if (tag != 35) break block19;
                        instanceIdOffset = 1;
                    }
                    long instanceId = this.dumpBuffer.getID(start + (long)instanceIdOffset);
                    LongMap.Entry instanceEntry = this.idToOffsetMap.get(instanceId);
                    long idom = this.domTree.getIdomId(instanceId, instanceEntry);
                    boolean isTreeObj = instanceEntry.isTreeObj();
                    long instSize = 0L;
                    if (!(isTreeObj || instanceEntry.getNearestGCRootPointer() == 0L && this.gcRoots.getGCRoots(new Long(instanceId)) == null)) {
                        Instance instance;
                        long origSize = instanceEntry.getRetainedSize();
                        if (origSize < 0L) {
                            origSize = 0L;
                        }
                        instSize = (instance = this.getInstanceByOffset(new long[]{start})) != null ? instance.getSize() : (long)this.getClassDumpSegment().sizeSettings.getMinimumInstanceSize();
                        instanceEntry.setRetainedSize(origSize + instSize);
                    }
                    if (idom != 0L) {
                        LongMap.Entry entry;
                        long size;
                        if (isTreeObj) {
                            size = instanceEntry.getRetainedSize();
                        } else {
                            assert (instSize != 0L);
                            size = instSize;
                        }
                        while (idom != 0L && !(entry = this.idToOffsetMap.get(idom)).isTreeObj()) {
                            long retainedSize = entry.getRetainedSize();
                            if (retainedSize < 0L) {
                                retainedSize = 0L;
                            }
                            entry.setRetainedSize(retainedSize + size);
                            idom = this.domTree.getIdomId(idom, entry);
                        }
                    }
                    HeapProgress.progress(counter, this.allInstanceDumpBounds.startOffset, start, this.allInstanceDumpBounds.endOffset);
                }
                ++counter;
            }
            this.retainedSizeComputed = true;
            this.writeToFile();
        }
        HeapProgress.progressFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeRetainedSizeByClass() {
        Object object = this.retainedSizeByClassLock;
        synchronized (object) {
            if (this.retainedSizeByClassComputed) {
                return;
            }
            this.computeRetainedSize();
            this.cacheDirectory.setDirty(true);
            HeapProgress.progressStart();
            long[] offset = new long[]{this.allInstanceDumpBounds.startOffset};
            long counter = 0L;
            while (offset[0] < this.allInstanceDumpBounds.endOffset) {
                ClassDump javaClass;
                Instance i;
                long start = offset[0];
                int tag = this.readDumpTag(offset);
                if (!(tag != 33 && tag != 34 && tag != 35 || (i = this.getInstanceByOffset(new long[]{start})) == null || (javaClass = (ClassDump)i.getJavaClass()) == null || this.domTree.hasInstanceInChain(tag, i))) {
                    javaClass.addSizeForInstance(i);
                }
                HeapProgress.progress(counter, this.allInstanceDumpBounds.startOffset, start, this.allInstanceDumpBounds.endOffset);
                ++counter;
            }
            this.domTree = null;
            this.retainedSizeByClassComputed = true;
            this.writeToFile();
        }
        HeapProgress.progressFinish();
    }

    Instance getNearestGCRootPointer(Instance instance) {
        return this.nearestGCRoot.getNearestGCRootPointer(instance);
    }

    boolean isGCRoot(Instance instance) {
        Long instanceId = instance.getInstanceId();
        return this.gcRoots.getGCRoots(instanceId) != null;
    }

    int readDumpTag(long[] offset) {
        long position = offset[0];
        int dumpTag = this.dumpBuffer.get(position++) & 0xFF;
        long size = 0L;
        long tagOffset = position;
        int idSize = this.dumpBuffer.getIDSize();
        switch (dumpTag) {
            case -1: 
            case 255: {
                size = idSize;
                dumpTag = 255;
                break;
            }
            case 1: {
                size = 2 * idSize;
                break;
            }
            case 2: {
                size = idSize + 8;
                break;
            }
            case 3: {
                size = idSize + 8;
                break;
            }
            case 4: {
                size = idSize + 4;
                break;
            }
            case 5: {
                size = idSize;
                break;
            }
            case 6: {
                size = idSize + 4;
                break;
            }
            case 7: {
                size = idSize;
                break;
            }
            case 8: {
                size = idSize + 8;
                break;
            }
            case 32: {
                int constantSize = idSize + 4 + 6 * idSize + 4;
                offset[0] = position + (long)constantSize;
                int cpoolSize = this.readConstantPool(offset);
                int sfSize = this.readStaticFields(offset);
                int ifSize = this.readInstanceFields(offset);
                size = constantSize + cpoolSize + sfSize + ifSize;
                break;
            }
            case 33: {
                int fieldSize = this.dumpBuffer.getInt(position + (long)idSize + 4L + (long)idSize);
                size = idSize + 4 + idSize + 4 + fieldSize;
                break;
            }
            case 34: {
                long elements = this.dumpBuffer.getInt(position + (long)idSize + 4L);
                size = (long)(idSize + 4 + 4 + idSize) + elements * (long)idSize;
                break;
            }
            case 35: {
                long elements = this.dumpBuffer.getInt(position + (long)idSize + 4L);
                byte type = this.dumpBuffer.get(position + (long)idSize + 4L + 4L);
                size = (long)(idSize + 4 + 4 + 1) + elements * (long)this.getValueSize(type);
                break;
            }
            case 28: {
                size = 8L;
                break;
            }
            case 254: {
                size = 4 + idSize;
                break;
            }
            case 137: {
                size = idSize;
                break;
            }
            case 138: {
                size = idSize;
                break;
            }
            case 139: {
                size = idSize;
                break;
            }
            case 140: {
                size = idSize;
                break;
            }
            case 141: {
                size = idSize;
                break;
            }
            case 142: {
                size = idSize;
                break;
            }
            case 144: {
                size = idSize;
                break;
            }
            case 195: {
                throw new IllegalArgumentException("Don't know how to load a nodata array");
            }
            default: {
                throw new IllegalArgumentException("Invalid dump tag " + dumpTag + " at position " + (position - 1L));
            }
        }
        offset[0] = tagOffset + size;
        return dumpTag;
    }

    int readTag(long[] offset) {
        long start = offset[0];
        byte tag = this.dumpBuffer.get(start);
        long len = (long)this.dumpBuffer.getInt(start + 1L + 4L) & 0xFFFFFFFFL;
        offset[0] = len == 0L && tag != 44 && this.dumpBuffer.version != 3 ? -1L : start + 1L + 4L + 4L + len;
        return tag;
    }

    TagBounds getHeapTagBound(int heapTag) {
        return this.heapTagBounds[heapTag];
    }

    long getHeapTime() {
        if (this.heapDumpSegment == null) {
            return 0L;
        }
        return this.getTagTime(this.heapDumpSegment.startOffset);
    }

    private long getTagTime(long start) {
        int time = this.dumpBuffer.getInt(start + 1L);
        return (long)time & 0xFFFFFFFFL;
    }

    int computeTotalNumberSegments() throws IOException {
        SegmentConsumer sc = new SegmentConsumer(){

            @Override
            boolean accept(long start, long end) {
                ++this.i;
                return false;
            }
        };
        this.heapDumpSegIterator(sc);
        return sc.i;
    }

    private TagBounds computeHeapDumpStart() throws IOException {
        SegmentConsumer sc = new SegmentConsumer(){

            @Override
            boolean accept(long start, long end) {
                if (this.i++ == HprofHeap.this.segment) {
                    this.heapDumpTag = new TagBounds(12, start, end);
                    return true;
                }
                return false;
            }
        };
        this.heapDumpSegIterator(sc);
        if (sc.heapDumpTag == null) {
            throw new IOException("Invalid segment " + this.segment);
        }
        return sc.heapDumpTag;
    }

    private void heapDumpSegIterator(SegmentConsumer sc) throws IOException {
        block8: {
            block7: {
                TagBounds heapDumpBounds = this.tagBounds[12];
                if (heapDumpBounds == null) break block7;
                long start = heapDumpBounds.startOffset;
                long[] offset = new long[]{start};
                while (start < heapDumpBounds.endOffset) {
                    int tag = this.readTag(offset);
                    if (tag == 12 && sc.accept(start, offset[0])) {
                        return;
                    }
                    start = offset[0];
                }
                break block8;
            }
            TagBounds heapDumpSegmentBounds = this.tagBounds[28];
            if (heapDumpSegmentBounds == null) break block8;
            heapDumpSegmentBounds = heapDumpSegmentBounds.union(this.tagBounds[44]);
            long start = heapDumpSegmentBounds.startOffset;
            long[] offset = new long[]{start};
            long segmentStart = 0L;
            long segmentEnd = 0L;
            while (start < heapDumpSegmentBounds.endOffset) {
                int tag = this.readTag(offset);
                if (tag == 28) {
                    if (segmentStart == 0L) {
                        segmentStart = start;
                    }
                    segmentEnd = offset[0];
                }
                if (tag == 44) {
                    if (sc.accept(segmentStart, segmentEnd)) {
                        return;
                    }
                    segmentStart = 0L;
                }
                start = offset[0];
            }
        }
    }

    private void fillHeapTagBounds() {
        if (this.heapTagBounds != null) {
            return;
        }
        HeapProgress.progressStart();
        this.heapTagBounds = new TagBounds[256];
        long[] offset = new long[]{this.heapDumpSegment.startOffset + 1L + 4L + 4L};
        long counter = 0L;
        while (offset[0] < this.heapDumpSegment.endOffset) {
            long start = offset[0];
            int tag = this.readDumpTag(offset);
            TagBounds bounds = this.heapTagBounds[tag];
            long end = offset[0];
            if (bounds == null) {
                TagBounds newBounds = tag == 32 ? new ClassDumpSegment(this, start, end) : new TagBounds(tag, start, end);
                this.heapTagBounds[tag] = newBounds;
            } else {
                bounds.endOffset = end;
            }
            if (tag == 32 || tag == 33 || tag == 34 || tag == 35) {
                ++this.idMapSize;
            }
            HeapProgress.progress(counter, this.heapDumpSegment.startOffset, start, this.heapDumpSegment.endOffset);
            ++counter;
        }
        TagBounds instanceDumpBounds = this.heapTagBounds[33];
        TagBounds objArrayDumpBounds = this.heapTagBounds[34];
        TagBounds primArrayDumpBounds = this.heapTagBounds[35];
        if (instanceDumpBounds == null) {
            instanceDumpBounds = new TagBounds(-1, this.heapDumpSegment.endOffset, this.heapDumpSegment.endOffset);
        }
        this.allInstanceDumpBounds = instanceDumpBounds.union(objArrayDumpBounds);
        this.allInstanceDumpBounds = this.allInstanceDumpBounds.union(primArrayDumpBounds);
        HeapProgress.progressFinish();
    }

    private void fillTagBounds(long tagStart) throws IOException {
        long[] offset = new long[]{tagStart};
        while (offset[0] < this.dumpBuffer.capacity()) {
            long start = offset[0];
            int tag = this.readTag(offset);
            TagBounds bounds = this.tagBounds[tag];
            long end = offset[0];
            if (end == -1L) {
                throw new IOException("Heap dump is broken.\nTag 0x" + Integer.toHexString(tag) + " at offset " + start + " has zero length.");
            }
            if (bounds == null) {
                TagBounds newBounds = tag == 2 ? new LoadClassSegment(this, start, end) : (tag == 1 ? new StringSegment(this, start, end) : (tag == 5 ? new StackTraceSegment(this, start, end) : (tag == 4 ? new StackFrameSegment(this, start, end) : new TagBounds(tag, start, end))));
                this.tagBounds[tag] = newBounds;
                continue;
            }
            bounds.endOffset = end;
        }
    }

    private int readConstantPool(long[] offset) {
        long start = offset[0];
        int size = this.dumpBuffer.getShort(start);
        offset[0] = offset[0] + 2L;
        for (int i = 0; i < size; ++i) {
            offset[0] = offset[0] + 2L;
            this.readValue(offset);
        }
        return (int)(offset[0] - start);
    }

    private int readInstanceFields(long[] offset) {
        long position = offset[0];
        short fields = this.dumpBuffer.getShort(offset[0]);
        offset[0] = offset[0] + 2L;
        offset[0] = offset[0] + (long)(fields * (this.dumpBuffer.getIDSize() + 1));
        return (int)(offset[0] - position);
    }

    private int readStaticFields(long[] offset) {
        long start = offset[0];
        int fields = this.dumpBuffer.getShort(start);
        offset[0] = offset[0] + 2L;
        int idSize = this.dumpBuffer.getIDSize();
        for (int i = 0; i < fields; ++i) {
            offset[0] = offset[0] + (long)idSize;
            byte by = this.readValue(offset);
        }
        return (int)(offset[0] - start);
    }

    private byte readValue(long[] offset) {
        long l = offset[0];
        offset[0] = l + 1L;
        byte type = this.dumpBuffer.get(l);
        offset[0] = offset[0] + (long)this.getValueSize(type);
        return type;
    }

    private abstract class SegmentConsumer {
        int i;
        TagBounds heapDumpTag;

        private SegmentConsumer() {
        }

        abstract boolean accept(long var1, long var3);
    }

    private class InstancesIterator
    implements Iterator<Instance> {
        private long[] offset;
        private Instance nextInstance;

        private InstancesIterator() {
            this.offset = new long[]{((HprofHeap)HprofHeap.this).allInstanceDumpBounds.startOffset};
        }

        @Override
        public boolean hasNext() {
            while (this.offset[0] < ((HprofHeap)HprofHeap.this).allInstanceDumpBounds.endOffset && this.nextInstance == null) {
                this.nextInstance = HprofHeap.this.getInstanceByOffset(this.offset);
            }
            return this.nextInstance != null;
        }

        @Override
        public Instance next() {
            if (this.hasNext()) {
                Instance ni = this.nextInstance;
                this.nextInstance = null;
                return ni;
            }
            throw new NoSuchElementException();
        }
    }
}

