/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.openssl.OpenSSLConf;

public class SSLHostConfigSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(SSLHostConfigSF.class);

    @Override
    public void store(PrintWriter printWriter, int n, Object object) throws Exception {
        StoreDescription storeDescription = this.getRegistry().findDescription(object.getClass());
        if (storeDescription != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("factory.storeTag", new Object[]{storeDescription.getTag(), object}));
            }
            this.getStoreAppender().printIndent(printWriter, n + 2);
            printWriter.print("<");
            printWriter.print(storeDescription.getTag());
            if (storeDescription.isAttributes()) {
                SSLHostConfig sSLHostConfig = (SSLHostConfig)this.getStoreAppender().defaultInstance(object);
                SSLHostConfig sSLHostConfig2 = (SSLHostConfig)object;
                if (!sSLHostConfig.getProtocols().equals(sSLHostConfig2.getProtocols())) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string : sSLHostConfig2.getProtocols()) {
                        stringBuffer.append('+').append(string);
                    }
                    this.getStoreAppender().printValue(printWriter, n, "protocols", stringBuffer.toString());
                }
                this.getStoreAppender().printAttributes(printWriter, n, object, storeDescription);
            }
            printWriter.println(">");
            this.storeChildren(printWriter, n + 2, object, storeDescription);
            this.getStoreAppender().printIndent(printWriter, n + 2);
            this.getStoreAppender().printCloseTag(printWriter, storeDescription);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{object.getClass()}));
        }
    }

    @Override
    public void storeChildren(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        if (object instanceof SSLHostConfig) {
            OpenSSLConf openSSLConf;
            SSLHostConfig sSLHostConfig = (SSLHostConfig)object;
            Object[] objectArray = sSLHostConfig.getCertificates().toArray(new SSLHostConfigCertificate[0]);
            if (objectArray.length > 1) {
                openSSLConf = new ArrayList();
                for (Object object2 : objectArray) {
                    if (SSLHostConfigCertificate.Type.UNDEFINED == object2.getType()) continue;
                    openSSLConf.add(object2);
                }
                objectArray = openSSLConf.toArray(new SSLHostConfigCertificate[0]);
            }
            this.storeElementArray(printWriter, n, objectArray);
            openSSLConf = sSLHostConfig.getOpenSslConf();
            this.storeElement(printWriter, n, openSSLConf);
        }
    }
}

