/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.Server;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.util.ContextName;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceLink;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class MBeanUtils {
    protected static final StringManager sm = StringManager.getManager(MBeanUtils.class);
    private static final String[][] exceptions = new String[][]{{"org.apache.catalina.users.MemoryGroup", "Group"}, {"org.apache.catalina.users.MemoryRole", "Role"}, {"org.apache.catalina.users.MemoryUser", "User"}, {"org.apache.catalina.users.GenericGroup", "Group"}, {"org.apache.catalina.users.GenericRole", "Role"}, {"org.apache.catalina.users.GenericUser", "User"}};
    private static Registry registry = MBeanUtils.createRegistry();
    private static MBeanServer mserver = MBeanUtils.createServer();

    static String createManagedName(Object object) {
        String string = object.getClass().getName();
        for (String[] stringArray : exceptions) {
            if (!string.equals(stringArray[0])) continue;
            return stringArray[1];
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static DynamicMBean createMBean(ContextEnvironment contextEnvironment) throws Exception {
        String string = MBeanUtils.createManagedName(contextEnvironment);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception(sm.getString("mBeanUtils.noManagedBean", new Object[]{string}));
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)contextEnvironment);
        ObjectName objectName = MBeanUtils.createObjectName(string2, contextEnvironment);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    public static DynamicMBean createMBean(ContextResource contextResource) throws Exception {
        String string = MBeanUtils.createManagedName(contextResource);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception(sm.getString("mBeanUtils.noManagedBean", new Object[]{string}));
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)contextResource);
        ObjectName objectName = MBeanUtils.createObjectName(string2, contextResource);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    public static DynamicMBean createMBean(ContextResourceLink contextResourceLink) throws Exception {
        String string = MBeanUtils.createManagedName(contextResourceLink);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception(sm.getString("mBeanUtils.noManagedBean", new Object[]{string}));
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)contextResourceLink);
        ObjectName objectName = MBeanUtils.createObjectName(string2, contextResourceLink);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    static DynamicMBean createMBean(Group group) throws Exception {
        String string = MBeanUtils.createManagedName(group);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception(sm.getString("mBeanUtils.noManagedBean", new Object[]{string}));
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)group);
        ObjectName objectName = MBeanUtils.createObjectName(string2, group);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    static DynamicMBean createMBean(Role role) throws Exception {
        String string = MBeanUtils.createManagedName(role);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception(sm.getString("mBeanUtils.noManagedBean", new Object[]{string}));
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)role);
        ObjectName objectName = MBeanUtils.createObjectName(string2, role);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    static DynamicMBean createMBean(User user) throws Exception {
        String string = MBeanUtils.createManagedName(user);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception(sm.getString("mBeanUtils.noManagedBean", new Object[]{string}));
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)user);
        ObjectName objectName = MBeanUtils.createObjectName(string2, user);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    static DynamicMBean createMBean(UserDatabase userDatabase) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string;
        if (userDatabase.isSparse()) {
            string = registry.findManagedBean("SparseUserDatabase");
            if (string == null) {
                Exception exception = new Exception(sm.getString("mBeanUtils.noManagedBean", new Object[]{"SparseUserDatabase"}));
                throw new MBeanException(exception);
            }
            object3 = string.getDomain();
            if (object3 == null) {
                object3 = mserver.getDefaultDomain();
            }
            object2 = string.createMBean((Object)userDatabase);
            object = MBeanUtils.createObjectName((String)object3, userDatabase);
            if (mserver.isRegistered((ObjectName)object)) {
                mserver.unregisterMBean((ObjectName)object);
            }
            mserver.registerMBean(object2, (ObjectName)object);
        }
        if ((object3 = registry.findManagedBean(string = MBeanUtils.createManagedName(userDatabase))) == null) {
            object2 = new Exception(sm.getString("mBeanUtils.noManagedBean", new Object[]{string}));
            throw new MBeanException((Exception)object2);
        }
        object2 = object3.getDomain();
        if (object2 == null) {
            object2 = mserver.getDefaultDomain();
        }
        object = object3.createMBean((Object)userDatabase);
        ObjectName objectName = MBeanUtils.createObjectName((String)object2, userDatabase);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(object, objectName);
        return object;
    }

    public static ObjectName createObjectName(String string, ContextEnvironment contextEnvironment) throws MalformedObjectNameException {
        ObjectName objectName = null;
        Object object = contextEnvironment.getNamingResources().getContainer();
        if (object instanceof Server) {
            objectName = new ObjectName(string + ":type=Environment,resourcetype=Global,name=" + contextEnvironment.getName());
        } else if (object instanceof Context) {
            Context context = (Context)object;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container = context.getParent();
            objectName = new ObjectName(string + ":type=Environment,resourcetype=Context,host=" + container.getName() + ",context=" + contextName.getDisplayName() + ",name=" + contextEnvironment.getName());
        }
        return objectName;
    }

    public static ObjectName createObjectName(String string, ContextResource contextResource) throws MalformedObjectNameException {
        ObjectName objectName = null;
        String string2 = ObjectName.quote(contextResource.getName());
        Object object = contextResource.getNamingResources().getContainer();
        if (object instanceof Server) {
            objectName = new ObjectName(string + ":type=Resource,resourcetype=Global,class=" + contextResource.getType() + ",name=" + string2);
        } else if (object instanceof Context) {
            Context context = (Context)object;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container = context.getParent();
            objectName = new ObjectName(string + ":type=Resource,resourcetype=Context,host=" + container.getName() + ",context=" + contextName.getDisplayName() + ",class=" + contextResource.getType() + ",name=" + string2);
        }
        return objectName;
    }

    public static ObjectName createObjectName(String string, ContextResourceLink contextResourceLink) throws MalformedObjectNameException {
        ObjectName objectName = null;
        String string2 = ObjectName.quote(contextResourceLink.getName());
        Object object = contextResourceLink.getNamingResources().getContainer();
        if (object instanceof Server) {
            objectName = new ObjectName(string + ":type=ResourceLink,resourcetype=Global,name=" + string2);
        } else if (object instanceof Context) {
            Context context = (Context)object;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container = context.getParent();
            objectName = new ObjectName(string + ":type=ResourceLink,resourcetype=Context,host=" + container.getName() + ",context=" + contextName.getDisplayName() + ",name=" + string2);
        }
        return objectName;
    }

    static ObjectName createObjectName(String string, Group group) throws MalformedObjectNameException {
        ObjectName objectName = null;
        objectName = new ObjectName(string + ":type=Group,groupname=" + ObjectName.quote(group.getGroupname()) + ",database=" + group.getUserDatabase().getId());
        return objectName;
    }

    static ObjectName createObjectName(String string, Role role) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(string + ":type=Role,rolename=" + ObjectName.quote(role.getRolename()) + ",database=" + role.getUserDatabase().getId());
        return objectName;
    }

    static ObjectName createObjectName(String string, User user) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(string + ":type=User,username=" + ObjectName.quote(user.getUsername()) + ",database=" + user.getUserDatabase().getId());
        return objectName;
    }

    static ObjectName createObjectName(String string, UserDatabase userDatabase) throws MalformedObjectNameException {
        ObjectName objectName = null;
        objectName = new ObjectName(string + ":type=UserDatabase,database=" + userDatabase.getId());
        return objectName;
    }

    public static synchronized Registry createRegistry() {
        if (registry == null) {
            registry = Registry.getRegistry(null, null);
            ClassLoader classLoader = MBeanUtils.class.getClassLoader();
            registry.loadDescriptors("org.apache.catalina.mbeans", classLoader);
            registry.loadDescriptors("org.apache.catalina.authenticator", classLoader);
            registry.loadDescriptors("org.apache.catalina.core", classLoader);
            registry.loadDescriptors("org.apache.catalina", classLoader);
            registry.loadDescriptors("org.apache.catalina.deploy", classLoader);
            registry.loadDescriptors("org.apache.catalina.loader", classLoader);
            registry.loadDescriptors("org.apache.catalina.realm", classLoader);
            registry.loadDescriptors("org.apache.catalina.session", classLoader);
            registry.loadDescriptors("org.apache.catalina.startup", classLoader);
            registry.loadDescriptors("org.apache.catalina.users", classLoader);
            registry.loadDescriptors("org.apache.catalina.ha", classLoader);
            registry.loadDescriptors("org.apache.catalina.connector", classLoader);
            registry.loadDescriptors("org.apache.catalina.valves", classLoader);
            registry.loadDescriptors("org.apache.catalina.storeconfig", classLoader);
            registry.loadDescriptors("org.apache.tomcat.util.descriptor.web", classLoader);
        }
        return registry;
    }

    public static synchronized MBeanServer createServer() {
        if (mserver == null) {
            mserver = Registry.getRegistry(null, null).getMBeanServer();
        }
        return mserver;
    }

    public static void destroyMBean(ContextEnvironment contextEnvironment) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(contextEnvironment);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, contextEnvironment))) {
            mserver.unregisterMBean(objectName);
        }
    }

    public static void destroyMBean(ContextResource contextResource) throws Exception {
        ObjectName objectName;
        String string;
        ManagedBean managedBean;
        if ("org.apache.catalina.UserDatabase".equals(contextResource.getType())) {
            MBeanUtils.destroyMBeanUserDatabase(contextResource.getName());
        }
        if ((managedBean = registry.findManagedBean(string = MBeanUtils.createManagedName(contextResource))) == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, contextResource))) {
            mserver.unregisterMBean(objectName);
        }
    }

    public static void destroyMBean(ContextResourceLink contextResourceLink) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(contextResourceLink);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, contextResourceLink))) {
            mserver.unregisterMBean(objectName);
        }
    }

    static void destroyMBean(Group group) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(group);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, group))) {
            mserver.unregisterMBean(objectName);
        }
    }

    static void destroyMBean(Role role) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(role);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, role))) {
            mserver.unregisterMBean(objectName);
        }
    }

    static void destroyMBean(User user) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(user);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, user))) {
            mserver.unregisterMBean(objectName);
        }
    }

    static void destroyMBeanUserDatabase(String string) throws Exception {
        ObjectName objectName = null;
        Set<ObjectName> set = null;
        objectName = new ObjectName("Users:type=Group,database=" + string + ",*");
        set = mserver.queryNames(objectName, null);
        for (ObjectName objectName2 : set) {
            mserver.unregisterMBean(objectName2);
        }
        objectName = new ObjectName("Users:type=Role,database=" + string + ",*");
        set = mserver.queryNames(objectName, null);
        for (ObjectName objectName2 : set) {
            mserver.unregisterMBean(objectName2);
        }
        objectName = new ObjectName("Users:type=User,database=" + string + ",*");
        set = mserver.queryNames(objectName, null);
        for (ObjectName objectName2 : set) {
            mserver.unregisterMBean(objectName2);
        }
        Object object = new ObjectName("Users:type=UserDatabase,database=" + string);
        if (mserver.isRegistered((ObjectName)object)) {
            mserver.unregisterMBean((ObjectName)object);
        }
        if (mserver.isRegistered((ObjectName)(object = new ObjectName("Catalina:type=UserDatabase,database=" + string)))) {
            mserver.unregisterMBean((ObjectName)object);
        }
    }
}

