"use strict";(self.webpackChunkbookmarks=self.webpackChunkbookmarks||[]).push([["src_components_ViewPrivate_vue"],{14948:(t,e,n)=>{n.d(e,{A:()=>r});var o=n(71354),a=n.n(o),s=n(76314),i=n.n(s)()(a());i.push([t.id,"\n.copy-dialog {\n\tmin-width: 300px;\n\theight: 300px;\n\toverflow-y: scroll;\n\tpadding: 20px;\n}\n","",{version:3,sources:["webpack://./src/components/CopyDialog.vue"],names:[],mappings:";AAuDA;CACA,gBAAA;CACA,aAAA;CACA,kBAAA;CACA,aAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021 Artem Lavrukhin <lavryha4590@gmail.com>\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcModal v-if=\"showNcModal\" :name=\"title\" @close=\"onClose\">\n\t\t<div class=\"copy-dialog\">\n\t\t\t<FolderPicker :title=\"title\" :filter=\"filterFolders\" @submit=\"onSubmit\" />\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\nimport { actions, mutations } from '../store/index.js'\nimport FolderPicker from './FolderPicker.vue'\n\nexport default {\n\tname: 'CopyDialog',\n\tcomponents: {\n\t\tFolderPicker,\n\t\tNcModal,\n\t},\n\tcomputed: {\n\t\tshowNcModal() {\n\t\t\treturn this.$store.state.displayCopyDialog\n\t\t},\n\t\tselection() {\n\t\t\treturn this.$store.state.selection\n\t\t},\n\t\ttitle() {\n\t\t\treturn n('bookmarks',\n\t\t\t\t'Adding %n bookmark to new folder',\n\t\t\t\t'Adding %n bookmarks to new folder',\n\t\t\t\tthis.selection.bookmarks.length,\n\t\t\t)\n\t\t},\n\t},\n\tmethods: {\n\t\tasync onSubmit(folderId) {\n\t\t\tthis.$store.commit(mutations.DISPLAY_COPY_DIALOG, false)\n\t\t\tawait this.$store.dispatch(actions.NcNcModal, folderId)\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t},\n\t\tonClose() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_COPY_DIALOG, false)\n\t\t},\n\t\tfilterFolders(child) {\n\t\t\treturn !this.selection.folders.some(folder => folder.id === child.id)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.copy-dialog {\n\tmin-width: 300px;\n\theight: 300px;\n\toverflow-y: scroll;\n\tpadding: 20px;\n}\n</style>\n"],sourceRoot:""}]);const r=i},68944:(t,e,n)=>{n.d(e,{A:()=>r});var o=n(71354),a=n.n(o),s=n(76314),i=n.n(s)()(a());i.push([t.id,"\n.app-content-list {\n\tpadding: 5px;\n\tpadding-top: 45px;\n\toverflow-y: scroll;\n\theight: calc(100vh - 50px);\n}\n","",{version:3,sources:["webpack://./src/components/FolderOverview.vue"],names:[],mappings:";AAmDA;CACA,YAAA;CACA,iBAAA;CACA,kBAAA;CACA,0BAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2022. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcAppContentList :show-details=\"showDetails\" @update:show-details=\"$emit('update:show-details', $event)\">\n\t\t<TreeFolder v-for=\"folder in rootFolder.children\"\n\t\t\t:key=\"folder.id\"\n\t\t\t:folder=\"folder\"\n\t\t\t@select=\"onSelect($event)\" />\n\t</NcAppContentList>\n</template>\n\n<script>\nimport { NcAppContentList } from '@nextcloud/vue'\nimport TreeFolder from './TreeFolder.vue'\nimport { privateRoutes } from '../router.js'\nimport { actions } from '../store/index.js'\n\nexport default {\n\tname: 'FolderOverview',\n\tcomponents: {\n\t\tTreeFolder,\n\t\tNcAppContentList,\n\t},\n\tprops: {\n\t\tshowDetails: {\n\t\t\ttype: Boolean,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tcomputed: {\n\t\trootFolder() {\n\t\t\treturn this.$store.getters.getFolder(-1)[0]\n\t\t},\n\t},\n\tmethods: {\n\t\tonSelect(folder) {\n\t\t\tthis.$router.push({ name: privateRoutes.FOLDER, params: { folder } })\n\t\t\tif (this.$store.state.sidebar && this.$store.state.sidebar.type === 'folder') {\n\t\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_DETAILS, folder)\n\t\t\t}\n\t\t\tthis.$emit('update:show-details', true)\n\t\t},\n\t},\n}\n<\/script>\n\n<style>\n.app-content-list {\n\tpadding: 5px;\n\tpadding-top: 45px;\n\toverflow-y: scroll;\n\theight: calc(100vh - 50px);\n}\n</style>\n"],sourceRoot:""}]);const r=i},60218:(t,e,n)=>{n.d(e,{A:()=>r});var o=n(71354),a=n.n(o),s=n(76314),i=n.n(s)()(a());i.push([t.id,"\n.loading[data-v-752b936f] {\n\tmin-width: 300px;\n\theight: 200px;\n\toverflow-y: scroll;\n\tpadding: 10px;\n\ttext-align: center;\n}\n","",{version:3,sources:["webpack://./src/components/LoadingModal.vue"],names:[],mappings:";AAyDA;CACA,gBAAA;CACA,aAAA;CACA,kBAAA;CACA,aAAA;CACA,kBAAA;AACA",sourcesContent:["<template>\n\t<NcModal v-if=\"showNcModal\" :can-close=\"false\">\n\t\t<div class=\"loading icon-loading\">\n\t\t\t<h3>{{ title }}</h3>\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\n\nexport default {\n\tname: 'LoadingModal',\n\tcomponents: {\n\t\tNcModal,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tstates: {\n\t\t\t\tdeleteBookmarks: this.t('bookmarks', 'Deleting bookmarks'),\n\t\t\t\tdeleteSelection: this.t('bookmarks', 'Deleting selection'),\n\t\t\t\timportBookmarks: this.t('bookmarks', 'Importing bookmarks'),\n\t\t\t\tmoveSelection: this.t('bookmkarks', 'Moving selection'),\n\t\t\t\tcopySelection: this.t('bookmkarks', 'Adding selection to folders'),\n\t\t\t\temptyTrashbin: this.t('bookmkarks', 'Emptying trashbin'),\n\t\t\t},\n\t\t\tshowNcModal: false,\n\t\t\tshowTimeout: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\tstate() {\n\t\t\treturn Object.keys(this.states).find(state => this.$store.state.loading[state])\n\t\t},\n\t\ttitle() {\n\t\t\tconst state = this.state\n\t\t\tif (state) {\n\t\t\t\treturn this.states[state]\n\t\t\t} else {\n\t\t\t\treturn ''\n\t\t\t}\n\t\t},\n\t},\n\twatch: {\n\t\tstate(newState, previous) {\n\t\t\tif (this.state && !previous) {\n\t\t\t\tthis.showTimeout = setTimeout(() => {\n\t\t\t\t\tthis.showNcModal = true\n\t\t\t\t}, 500)\n\t\t\t} else if (!this.state && previous) {\n\t\t\t\tclearTimeout(this.showTimeout)\n\t\t\t\tthis.showNcModal = false\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.loading {\n\tmin-width: 300px;\n\theight: 200px;\n\toverflow-y: scroll;\n\tpadding: 10px;\n\ttext-align: center;\n}\n</style>\n"],sourceRoot:""}]);const r=i},31392:(t,e,n)=>{n.d(e,{A:()=>r});var o=n(71354),a=n.n(o),s=n(76314),i=n.n(s)()(a());i.push([t.id,"\n.move-dialog {\n\tmin-width: 300px;\n\theight: 300px;\n\toverflow-y: scroll;\n\tpadding: 20px;\n}\n","",{version:3,sources:["webpack://./src/components/MoveDialog.vue"],names:[],mappings:";AA0EA;CACA,gBAAA;CACA,aAAA;CACA,kBAAA;CACA,aAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcModal v-if=\"showNcModal\" :name=\"title\" @close=\"onClose\">\n\t\t<div class=\"move-dialog\">\n\t\t\t<FolderPicker :title=\"title\" :filter=\"filterFolders\" @submit=\"onSubmit\" />\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\nimport { actions, mutations } from '../store/index.js'\nimport FolderPicker from './FolderPicker.vue'\n\nexport default {\n\tname: 'MoveDialog',\n\tcomponents: {\n\t\tFolderPicker,\n\t\tNcModal,\n\t},\n\tcomputed: {\n\t\tshowNcModal() {\n\t\t\treturn this.$store.state.displayMoveDialog\n\t\t},\n\t\tselection() {\n\t\t\treturn this.$store.state.selection\n\t\t},\n\t\ttitle() {\n\t\t\tif (this.selection.folders.length) {\n\t\t\t\tif (this.selection.bookmarks.length) {\n\t\t\t\t\treturn n('bookmarks',\n\t\t\t\t\t\t'Moving %n folder and some bookmarks',\n\t\t\t\t\t\t'Moving %n folders and some bookmarks',\n\t\t\t\t\t\tthis.selection.folders.length,\n\t\t\t\t\t)\n\t\t\t\t} else {\n\t\t\t\t\treturn n('bookmarks',\n\t\t\t\t\t\t'Moving %n folder',\n\t\t\t\t\t\t'Moving %n folders',\n\t\t\t\t\t\tthis.selection.folders.length,\n\t\t\t\t\t)\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\treturn n('bookmarks',\n\t\t\t\t\t'Moving %n bookmark',\n\t\t\t\t\t'Moving %n bookmarks',\n\t\t\t\t\tthis.selection.bookmarks.length,\n\t\t\t\t)\n\t\t\t}\n\t\t},\n\t},\n\tmethods: {\n\t\tasync onSubmit(folderId) {\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, false)\n\t\t\ttry {\n\t\t\t\tawait this.$store.dispatch(actions.MOVE_SELECTION, folderId)\n\t\t\t} finally {\n\t\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\t}\n\t\t},\n\t\tonClose() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, false)\n\t\t},\n\t\tfilterFolders(child) {\n\t\t\treturn !this.selection.folders.some(folder => folder.id === child.id)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.move-dialog {\n\tmin-width: 300px;\n\theight: 300px;\n\toverflow-y: scroll;\n\tpadding: 20px;\n}\n</style>\n"],sourceRoot:""}]);const r=i},2353:(t,e,n)=>{n.d(e,{A:()=>r});var o=n(71354),a=n.n(o),s=n(76314),i=n.n(s)()(a());i.push([t.id,"\n.navigation .dropTarget--available {\n\tbackground: var(--color-primary-element-light);\n}\n.navigation .dropTarget--active {\n\tbackground: var(--color-primary-element-light);\n}\n","",{version:3,sources:["webpack://./src/components/Navigation.vue"],names:[],mappings:";AAkOA;CACA,8CAAA;AACA;AAEA;CACA,8CAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcAppNavigation class="navigation">\n\t\t<template #list>\n\t\t\t<NcAppNavigationItem key="menu-home"\n\t\t\t\t:to="{ name: routes.HOME }"\n\t\t\t\t:name="t(\'bookmarks\', \'All bookmarks\')"\n\t\t\t\t:exact="true">\n\t\t\t\t<HomeIcon slot="icon" :size="20" />\n\t\t\t\t<NcCounterBubble slot="counter">\n\t\t\t\t\t{{ allBookmarksCount | largeNumbers }}\n\t\t\t\t</NcCounterBubble>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem key="menu-recent"\n\t\t\t\t:to="{ name: routes.RECENT }"\n\t\t\t\t:name="t(\'bookmarks\', \'Recent\')">\n\t\t\t\t<HistoryIcon slot="icon" :size="20" />\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem key="menu-shared-folders"\n\t\t\t\t:to="{ name: routes.SHARED_FOLDERS }"\n\t\t\t\t:name="t(\'bookmarks\', \'Shared with you\')">\n\t\t\t\t<ShareVariantIcon slot="icon" :size="20" />\n\t\t\t\t<NcCounterBubble slot="counter">\n\t\t\t\t\t{{ sharedFoldersCount | largeNumbers }}\n\t\t\t\t</NcCounterBubble>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem v-if="scrapingEnabled && archiveEnabled"\n\t\t\t\tkey="menu-archived"\n\t\t\t\t:to="{ name: routes.ARCHIVED }"\n\t\t\t\t:name="t(\'bookmarks\', \'Files\')">\n\t\t\t\t<FileDocumentMultipleIcon slot="icon" :size="20" />\n\t\t\t\t<NcCounterBubble slot="counter">\n\t\t\t\t\t{{ archivedBookmarksCount | largeNumbers }}\n\t\t\t\t</NcCounterBubble>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem key="menu-duplicated"\n\t\t\t\t:to="{ name: routes.DUPLICATED }"\n\t\t\t\t:name="t(\'bookmarks\', \'Duplicates\')">\n\t\t\t\t<VectorLinkIcon slot="icon" :size="20" />\n\t\t\t\t<NcCounterBubble slot="counter">\n\t\t\t\t\t{{ duplicatedBookmarksCount | largeNumbers }}\n\t\t\t\t</NcCounterBubble>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem key="menu-unavailable"\n\t\t\t\t:to="{ name: routes.UNAVAILABLE }"\n\t\t\t\t:name="t(\'bookmarks\', \'Broken links\')">\n\t\t\t\t<LinkVariantOffIcon slot="icon" :size="20" />\n\t\t\t\t<NcCounterBubble slot="counter">\n\t\t\t\t\t{{ unavailableBookmarksCount | largeNumbers }}\n\t\t\t\t</NcCounterBubble>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationSpacer />\n\t\t\t<NcAppNavigationNewItem key="menu-new-tag"\n\t\t\t\t:name="t(\'bookmarks\', \'New tag\')"\n\t\t\t\t@new-item="onNewTag">\n\t\t\t\t<TagPlusIcon slot="icon" :size="20" />\n\t\t\t</NcAppNavigationNewItem>\n\t\t\t<template v-if="Boolean(tags.length)">\n\t\t\t\t<NcAppNavigationItem key="menu-tags"\n\t\t\t\t\t:name="t(\'bookmarks\', \'Search tags\')"\n\t\t\t\t\t@click="onSearchTags">\n\t\t\t\t\t<TagMultipleIcon slot="icon" :size="20" />\n\t\t\t\t</NcAppNavigationItem>\n\t\t\t\t<NcAppNavigationItem v-for="tag in tags"\n\t\t\t\t\t:key="\'tag-\'+tag.name"\n\t\t\t\t\tv-drop-target="{allow: (e) => allowDropOnTag(tag.name, e), drop: (e) => onDropOnTag(tag.name, e)}"\n\t\t\t\t\t:to="tag.route"\n\t\t\t\t\t:force-menu="true"\n\t\t\t\t\t:edit-label="t(\'bookmarks\', \'Rename\')"\n\t\t\t\t\t:editable="!isPublic"\n\t\t\t\t\t:name="tag.name"\n\t\t\t\t\t@update:name="onRenameTag(tag.name, $event)">\n\t\t\t\t\t<TagIcon slot="icon" :size="20" />\n\t\t\t\t\t<NcCounterBubble slot="counter">\n\t\t\t\t\t\t{{ tag.count | largeNumbers }}\n\t\t\t\t\t</NcCounterBubble>\n\t\t\t\t\t<template v-if="!isPublic" slot="actions">\n\t\t\t\t\t\t<NcActionButton :close-after-click="true" @click="onDeleteTag(tag.name)">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<DeleteIcon :size="20" />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Delete\') }}\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</template>\n\t\t\t\t</NcAppNavigationItem>\n\t\t\t\t<NcAppNavigationItem key="menu-untagged"\n\t\t\t\t\t:to="{ name: routes.UNTAGGED }"\n\t\t\t\t\t:name="t(\'bookmarks\', \'Untagged\')">\n\t\t\t\t\t<TagOffIcon slot="icon" :size="20" />\n\t\t\t\t</NcAppNavigationItem>\n\t\t\t</template>\n\t\t</template>\n\t\t<template #footer>\n\t\t\t<template v-if="Number(bookmarksLimit) > 0">\n\t\t\t\t<NcAppNavigationItem key="menu-limit" :name="t(\'bookmarks\', \'{used} bookmarks of {available} available\', {used: allBookmarksCount, available: bookmarksLimit})">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<GaugeIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t<ProgressBar :val="allBookmarksCount >= bookmarksLimit ? 100 : (allBookmarksCount / bookmarksLimit) * 100" />\n\t\t\t\t</NcAppNavigationItem>\n\t\t\t</template>\n\t\t\t<NcAppNavigationItem key="menu-trashbin"\n\t\t\t\t:to="{ name: routes.TRASHBIN }"\n\t\t\t\t:name="t(\'bookmarks\', \'Trash Bin\')">\n\t\t\t\t<TrashbinIcon slot="icon" :size="20" />\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem :name="t(\'bookmarks\', \'Bookmarks Settings\')" @click="settingsOpen = !settingsOpen">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<CogIcon :size="20" />\n\t\t\t\t</template>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<Settings :settings-open.sync="settingsOpen" />\n\t\t</template>\n\t</NcAppNavigation>\n</template>\n\n<script>\nimport { NcActionButton, NcAppNavigation, NcAppNavigationItem, NcAppNavigationNewItem, NcCounterBubble, NcAppNavigationSpacer } from \'@nextcloud/vue\'\nimport { TrashbinIcon, HomeIcon, HistoryIcon, TagOffIcon, LinkVariantOffIcon, ShareVariantIcon, FileDocumentMultipleIcon, TagPlusIcon, TagMultipleIcon, VectorLinkIcon, TagIcon, DeleteIcon, GaugeIcon, CogIcon } from \'./Icons.js\'\nimport ProgressBar from \'vue-simple-progress\'\nimport Settings from \'./Settings.vue\'\nimport { actions, mutations } from \'../store/index.js\'\n\nexport default {\n\tname: \'Navigation\',\n\tcomponents: {\n\t\tNcAppNavigation,\n\t\tNcAppNavigationItem,\n\t\tNcAppNavigationNewItem,\n\t\tNcCounterBubble,\n\t\tNcAppNavigationSpacer,\n\t\tNcActionButton,\n\t\tSettings,\n\t\tProgressBar,\n\t\tHistoryIcon,\n\t\tTagOffIcon,\n\t\tLinkVariantOffIcon,\n\t\tTagPlusIcon,\n\t\tTagMultipleIcon,\n\t\tFileDocumentMultipleIcon,\n\t\tShareVariantIcon,\n\t\tVectorLinkIcon,\n\t\tHomeIcon,\n\t\tTagIcon,\n\t\tDeleteIcon,\n\t\tGaugeIcon,\n\t\tCogIcon,\n\t\tTrashbinIcon,\n\t},\n\n\tfilters: {\n\t\tlargeNumbers(num) {\n\t\t\treturn num > 10000 ? Math.round(num / 1000) + \'K\' : num >= 1000 ? (Math.round(num / 100) / 10) + \'K\' : num\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tsettingsOpen: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\ttags() {\n\t\t\treturn this.$store.state.tags.map(tag => ({\n\t\t\t\troute: { name: this.routes.TAGS, params: { tags: tag.name } },\n\t\t\t\tname: tag.name,\n\t\t\t\tcount: tag.count,\n\t\t\t}))\n\t\t},\n\t\tallBookmarksCount() {\n\t\t\treturn this.$store.state.countsByFolder[-1]\n\t\t},\n\t\tunavailableBookmarksCount() {\n\t\t\treturn this.$store.state.unavailableCount\n\t\t},\n\t\tsharedFoldersCount() {\n\t\t\treturn Object.keys(this.$store.state.sharedFoldersById).length\n\t\t},\n\t\tarchivedBookmarksCount() {\n\t\t\treturn this.$store.state.archivedCount\n\t\t},\n\t\tduplicatedBookmarksCount() {\n\t\t\treturn this.$store.state.duplicatedCount\n\t\t},\n\t\tbookmarksLimit() {\n\t\t\treturn this.$store.state.settings.limit\n\t\t},\n\t\tscrapingEnabled() {\n\t\t\treturn this.$store.state.settings[\'privacy.enableScraping\'] === \'true\'\n\t\t},\n\t\tarchiveEnabled() {\n\t\t\treturn this.$store.state.settings[\'archive.enabled\'] && this.$store.state.settings[\'privacy.enableScraping\'] === \'true\'\n\t\t},\n\t},\n\n\tcreated() {\n\t},\n\n\tmethods: {\n\t\tonSearchTags() {\n\t\t\tthis.$router.push({ name: this.routes.TAGS })\n\t\t},\n\t\tonDeleteTag(tag) {\n\t\t\tthis.$store.dispatch(actions.DELETE_TAG, tag)\n\t\t},\n\t\tonRenameTag(oldName, newName) {\n\t\t\tthis.$store.dispatch(actions.RENAME_TAG, { oldName, newName })\n\t\t},\n\t\tonNewTag(tagName) {\n\t\t\tthis.$store.commit(mutations.ADD_TAG, tagName)\n\t\t},\n\t\tallowDropOnTag(tagName) {\n\t\t\treturn !this.$store.state.selection.folders.length && this.$store.state.selection.bookmarks.length\n\t\t},\n\t\tonDropOnTag(tagName) {\n\t\t\tthis.$store.dispatch(actions.TAG_SELECTION, { tags: [tagName], originalTags: [] })\n\t\t},\n\t},\n}\n<\/script>\n<style>\n\n.navigation .dropTarget--available {\n\tbackground: var(--color-primary-element-light);\n}\n\n.navigation .dropTarget--active {\n\tbackground: var(--color-primary-element-light);\n}\n</style>\n'],sourceRoot:""}]);const r=i},48060:(t,e,n)=>{n.d(e,{A:()=>r});var o=n(71354),a=n.n(o),s=n(76314),i=n.n(s)()(a());i.push([t.id,"\n.import {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tleft: -1000px;\n}\n.settings p a {\n\ttext-decoration: underline;\n}\n","",{version:3,sources:["webpack://./src/components/Settings.vue"],names:[],mappings:";AAuRA;CACA,UAAA;CACA,kBAAA;CACA,MAAA;CACA,aAAA;AACA;AAEA;CACA,0BAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcAppSettingsDialog :open=\"settingsOpen\"\n\t\t:show-navigation=\"true\"\n\t\t:name=\"t('bookmarks', 'Bookmarks settings')\"\n\t\tclass=\"settings\"\n\t\t@update:open=\"$emit('update:settingsOpen', $event)\">\n\t\t<NcAppSettingsSection id=\"importexport\" :name=\"t('bookmarks', 'Import/Export')\">\n\t\t\t<template #icon>\n\t\t\t\t<ImportIcon :size=\"20\" />\n\t\t\t</template>\n\t\t\t<input type=\"file\"\n\t\t\t\tclass=\"import\"\n\t\t\t\tsize=\"5\"\n\t\t\t\t@change=\"onImportSubmit\">\n\t\t\t<button @click=\"onImportOpen\">\n\t\t\t\t<span :class=\"{'icon-upload': !importing, 'icon-loading-small': importing}\" />{{ t('bookmarks', 'Import bookmarks') }}\n\t\t\t</button>\n\t\t\t<button @click=\"onExport\">\n\t\t\t\t<span class=\"icon-download\" /> {{ t('bookmarks', 'Export bookmarks') }}\n\t\t\t</button>\n\t\t</NcAppSettingsSection>\n\n\t\t<NcAppSettingsSection id=\"archive\" :name=\"t('bookmarks', 'Auto-archiving')\">\n\t\t\t<template #icon>\n\t\t\t\t<ArchiveIcon :size=\"20\" />\n\t\t\t</template>\n\t\t\t<p>{{ t('bookmarks', 'The bookmarks app can automatically archive the web content of links you have bookmarked') }}</p>\n\t\t\t<template v-if=\"scrapingEnabled\">\n\t\t\t\t<NcCheckboxRadioSwitch :checked=\"archiveEnabled\" @update:checked=\"onChangeArchiveEnabled\">\n\t\t\t\t\t{{ t('bookmarks', 'Enable archiving') }}\n\t\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t\t<NcTextField v-if=\"archiveEnabled\"\n\t\t\t\t\t:label=\"t('bookmarks', 'Enter the path of a folder in your Files where bookmarked files should be stored.')\"\n\t\t\t\t\t:value=\"archivePath\"\n\t\t\t\t\t:readonly=\"true\"\n\t\t\t\t\t@click=\"onChangeArchivePath\" />\n\t\t\t</template>\n\t\t\t<template v-else>\n\t\t\t\t<p>{{ t('bookmarks', 'Currently your administrator has disabled network access for this app, however, which is why Auto-archiving is disabled at the moment.') }}</p>\n\t\t\t</template>\n\t\t</NcAppSettingsSection>\n\n\t\t<NcAppSettingsSection id=\"backup\" :name=\"t('bookmarks', 'Auto-Backup')\">\n\t\t\t<template #icon>\n\t\t\t\t<BackupIcon :size=\"20\" />\n\t\t\t</template>\n\t\t\t<p>{{ t('bookmarks', 'The bookmarks app can automatically backup your bookmarks on a daily basis to prevent data loss when syncing bookmarks across devices.') }}</p>\n\t\t\t<NcCheckboxRadioSwitch :checked=\"backupEnabled\" @update:checked=\"onChangeBackupEnabled\">\n\t\t\t\t{{ t('bookmarks', 'Enable backups') }}\n\t\t\t</NcCheckboxRadioSwitch>\n\t\t\t<NcTextField v-if=\"backupEnabled\"\n\t\t\t\t:label=\"t('bookmarks', 'Enter the path of a folder in your Files where backups will be stored.')\"\n\t\t\t\t:value=\"backupPath\"\n\t\t\t\t:readonly=\"true\"\n\t\t\t\t@click=\"onChangeBackupPath\" />\n\t\t</NcAppSettingsSection>\n\n\t\t<NcAppSettingsSection id=\"client-apps\" :name=\"t('bookmarks', 'Client apps')\">\n\t\t\t<template #icon>\n\t\t\t\t<ApplicationIcon :size=\"20\" />\n\t\t\t</template>\n\t\t\t<p>\n\t\t\t\t{{\n\t\t\t\t\tt('bookmarks',\n\t\t\t\t\t\t'Also check out the collection of client apps that integrate with this app: '\n\t\t\t\t\t)\n\t\t\t\t}}\n\t\t\t\t<a href=\"https://github.com/nextcloud/bookmarks#third-party-clients\" style=\"text-decoration: underline;\">{{\n\t\t\t\t\tt('bookmarks', 'Client apps')\n\t\t\t\t}}</a>\n\t\t\t</p>\n\t\t</NcAppSettingsSection>\n\n\t\t<NcAppSettingsSection id=\"install\" :name=\"t('bookmarks', 'Install web app')\">\n\t\t\t<template #icon>\n\t\t\t\t<ApplicationImportIcon :size=\"20\" />\n\t\t\t</template>\n\t\t\t<p>{{ t('bookmarks', 'You can install this app on your device home screen to quickly access your bookmarks on your phone. You can easily remove the app from your home screen again, if you don\\'t like it.') }}</p>\n\t\t\t<a class=\"button center\" href=\"#\" @click.prevent=\"clickAddToHomeScreen\">{{ t('bookmarks', 'Install on home screen') }}</a>\n\t\t</NcAppSettingsSection>\n\n\t\t<NcAppSettingsSection id=\"bookmarklet\" :name=\"t('bookmarks', 'Bookmarklet')\">\n\t\t\t<template #icon>\n\t\t\t\t<LinkIcon :size=\"20\" />\n\t\t\t</template>\n\t\t\t<p>\n\t\t\t\t{{ t('bookmarks',\n\t\t\t\t\t'Drag this to your browser bookmarks and click it to quickly bookmark a webpage.'\n\t\t\t\t) }}\n\t\t\t</p>\n\t\t\t<a class=\"button center\"\n\t\t\t\t:href=\"bookmarklet\"\n\t\t\t\t@click.prevent=\"void 0\">{{\n\t\t\t\t\tt('bookmarks', 'Add to {instanceName}', {\n\t\t\t\t\t\tinstanceName: oc_defaults.name\n\t\t\t\t\t})\n\t\t\t\t}}</a>\n\t\t</NcAppSettingsSection>\n\n\t\t<NcAppSettingsSection id=\"need-help\" :name=\"t('bookmarks', 'Need help?')\">\n\t\t\t<template #icon>\n\t\t\t\t<LifebuoyIcon :size=\"20\" />\n\t\t\t</template>\n\t\t\t<p><a href=\"https://github.com/nextcloud/bookmarks/issues/\">{{ t('bookmarks', 'If you have problems with this Bookmarks app or have an idea about what could be improved, don\\'t hesitate to get in touch by clicking here.') }}</a></p>\n\t\t</NcAppSettingsSection>\n\n\t\t<NcAppSettingsSection id=\"support-project\" :name=\"t('bookmarks', 'Support this project')\">\n\t\t\t<template #icon>\n\t\t\t\t<HeartIcon :size=\"20\" />\n\t\t\t</template>\n\t\t\t<p>{{ t('bookmarks', 'My work on this Bookmarks app is fuelled by a voluntary subscription model. If you think what I do is worthwhile, I would be happy if you could support my work. Also, please consider giving the app a review on the Nextcloud app store. Thank you 💙 ') }}</p>\n\t\t\t<p>&nbsp;</p>\n\t\t\t<p><a href=\"https://github.com/sponsors/marcelklehr\">GitHub Sponsors</a>, <a href=\"https://www.patreon.com/marcelklehr\">Patreon</a>, <a href=\"https://liberapay.com/marcelklehr/donate\">Liberapay</a>, <a href=\"https://ko-fi.com/marcelklehr\">Ko-Fi</a>, <a href=\"https://www.paypal.me/marcelklehr1\">PayPal</a></p>\n\t\t\t<p><a href=\"https://apps.nextcloud.com/apps/bookmarks\">Review Nextcloud Bookmarks on apps.nextcloud.com</a></p>\n\t\t</NcAppSettingsSection>\n\t</NcAppSettingsDialog>\n</template>\n<script>\nimport { generateUrl } from '@nextcloud/router'\nimport { actions } from '../store/index.js'\nimport { getRequestToken } from '@nextcloud/auth'\nimport { getFilePickerBuilder } from '@nextcloud/dialogs'\nimport { privateRoutes } from '../router.js'\nimport { NcAppSettingsSection, NcAppSettingsDialog, NcCheckboxRadioSwitch, NcTextField } from '@nextcloud/vue'\nimport { ImportIcon, ArchiveIcon, BackupIcon, LinkIcon, ApplicationIcon, ApplicationImportIcon } from './Icons.js'\nimport HeartIcon from 'vue-material-design-icons/Heart.vue'\nimport LifebuoyIcon from 'vue-material-design-icons/Lifebuoy.vue'\n\nexport default {\n\tname: 'Settings',\n\tcomponents: { LifebuoyIcon, HeartIcon, NcAppSettingsSection, NcAppSettingsDialog, NcCheckboxRadioSwitch, NcTextField, ImportIcon, ArchiveIcon, BackupIcon, LinkIcon, ApplicationIcon, ApplicationImportIcon },\n\tprops: {\n\t\tsettingsOpen: {\n\t\t\ttype: Boolean,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\timporting: false,\n\t\t\tdeleting: false,\n\t\t\taddToHomeScreen: null,\n\t\t\tarchivePathPicker: getFilePickerBuilder(this.t('bookmarks', 'Archive path'))\n\t\t\t\t.allowDirectories(true)\n\t\t\t\t.setModal(true)\n\t\t\t\t.setType(1)// CHOOSE\n\t\t\t\t.setMultiSelect(false)\n\t\t\t\t.build(),\n\t\t\tbackupPathPicker: getFilePickerBuilder(this.t('bookmarks', 'Backup path'))\n\t\t\t\t.allowDirectories(true)\n\t\t\t\t.setModal(true)\n\t\t\t\t.setType(1)// CHOOSE\n\t\t\t\t.setMultiSelect(false)\n\t\t\t\t.build(),\n\t\t}\n\t},\n\tcomputed: {\n\t\toc_defaults() {\n\t\t\treturn window.oc_defaults\n\t\t},\n\t\tbookmarklet() {\n\t\t\tconst bookmarkletUrl\n\t\t= window.location.origin + generateUrl('/apps/bookmarks/bookmarklet')\n\t\t\tlet queryStringExtension = ''\n\t\t\tif (this.$route.name === privateRoutes.FOLDER) {\n\t\t\t\tqueryStringExtension = `+'&folderId=${this.$route.params.folder}'`\n\t\t\t}\n\t\t\treturn `javascript:(function(){var a=window,b=document,c=encodeURIComponent,e=c(document.title),d=a.open('${bookmarkletUrl}?url='+c(b.location)+'&title='+e${queryStringExtension},'bkmk_popup','left='+((a.screenX||a.screenLeft)+10)+',top='+((a.screenY||a.screenTop)+10)+',height=650px,width=550px,resizable=1,alwaysRaised=1');a.setTimeout(function(){d.focus()},300);})();`\n\t\t},\n\t\tscrapingEnabled() {\n\t\t\treturn this.$store.state.settings['privacy.enableScraping'] === 'true'\n\t\t},\n\t\tarchiveEnabled() {\n\t\t\treturn this.$store.state.settings['archive.enabled'] && this.$store.state.settings['privacy.enableScraping'] === 'true'\n\t\t},\n\t\tarchivePath() {\n\t\t\treturn this.$store.state.settings['archive.filePath']\n\t\t},\n\t\tbackupPath() {\n\t\t\treturn this.$store.state.settings['backup.filePath']\n\t\t},\n\t\tbackupEnabled() {\n\t\t\treturn this.$store.state.settings['backup.enabled'] === 'true'\n\t\t},\n\t},\n\tmounted() {\n\t\twindow.addEventListener('beforeinstallprompt', (e) => {\n\t\t// Prevent Chrome 67 and earlier from automatically showing the prompt\n\t\t\te.preventDefault()\n\t\t\t// Stash the event so it can be triggered later.\n\t\t\tthis.addToHomeScreen = e\n\t\t\tthis.showAddToHomeScreen = true\n\t\t})\n\t},\n\tmethods: {\n\t\tonImportOpen(e) {\n\t\t\te.target.previousElementSibling.click()\n\t\t},\n\t\tasync onImportSubmit(e) {\n\t\t\tthis.importing = true\n\t\t\ttry {\n\t\t\t\tawait this.$store.dispatch(actions.IMPORT_BOOKMARKS, { file: e.target.files[0], folder: this.$route.params.folder || -1 })\n\t\t\t} catch (e) {\n\t\t\t\tconsole.warn(e)\n\t\t\t}\n\t\t\tthis.importing = false\n\t\t},\n\t\tonExport() {\n\n\t\t\twindow.location = generateUrl(`/apps/bookmarks/bookmark/export?requesttoken=${encodeURIComponent(getRequestToken())}`)\n\t\t},\n\t\tasync onChangeArchiveEnabled(e) {\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'archive.enabled',\n\t\t\t\tvalue: String(!this.archiveEnabled),\n\t\t\t})\n\t\t},\n\t\tasync onChangeArchivePath(e) {\n\t\t\tconst path = await this.archivePathPicker.pick()\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'archive.filePath',\n\t\t\t\tvalue: path,\n\t\t\t})\n\t\t},\n\t\tasync onChangeBackupPath(e) {\n\t\t\tif (!this.backupEnabled) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tconst path = await this.backupPathPicker.pick()\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'backup.filePath',\n\t\t\t\tvalue: path,\n\t\t\t})\n\t\t},\n\t\tasync onChangeBackupEnabled(e) {\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'backup.enabled',\n\t\t\t\tvalue: String(!this.backupEnabled),\n\t\t\t})\n\t\t},\n\t\tclickAddToHomeScreen() {\n\t\t\tif (!this.addToHomeScreen) {\n\t\t\t\talert(this.t('bookmarks', 'Please select \"Add to home screen\" in your browser menu'))\n\t\t\t\treturn\n\t\t\t}\n\t\t\t// Show the prompt\n\t\t\tthis.addToHomeScreen.prompt()\n\t\t\t// Wait for the user to respond to the prompt\n\t\t\tthis.addToHomeScreen.userChoice.then((choiceResult) => {\n\t\t\t\tif (choiceResult.outcome === 'accepted') {\n\t\t\t\t\tconsole.warn('User accepted the A2HS prompt')\n\t\t\t\t} else {\n\t\t\t\t\tconsole.warn('User dismissed the A2HS prompt')\n\t\t\t\t}\n\t\t\t\tthis.addToHomeScreen = null\n\t\t\t})\n\t\t},\n\t},\n}\n<\/script>\n<style>\n\t.import {\n\t\topacity: 0;\n\t\tposition: absolute;\n\t\ttop: 0;\n\t\tleft: -1000px;\n\t}\n\n\t.settings p a {\n\t\ttext-decoration: underline;\n\t}\n</style>\n"],sourceRoot:""}]);const r=i},50534:(t,e,n)=>{n.d(e,{A:()=>r});var o=n(71354),a=n.n(o),s=n(76314),i=n.n(s)()(a());i.push([t.id,"\n.sidebar h3 {\n\tmargin-top: 20px;\n}\n.sidebar .tags {\n\twidth: 100%;\n}\n.sidebar .notes {\n\tflex-grow: 1;\n\tmin-height: 80px;\n}\n.sidebar .details__line {\n\tdisplay: flex;\n\talign-items: flex-start;\n\tmargin-bottom: 10px;\n}\n.sidebar .details__line > * {\n\tflex-grow: 0;\n\tmargin-right: 10px;\n}\n.sidebar .details__line > :nth-child(2) {\n\tflex-grow: 1;\n}\n.sidebar .details__line .notes {\n\tflex-grow: 1;\n}\n.sidebar .details__url {\n\tflex-grow: 1;\n\tpadding: 8px 0;\n\ttext-overflow: ellipsis;\n\theight: 2em;\n\tdisplay: inline-block;\n\toverflow: hidden;\n}\n.sidebar .details__action {\n\tflex-grow: 0;\n}\n.sidebar .folders {\n\tdisplay: flex;\n\talign-items: flex-start;\n}\n.sidebar .folders__folder {\n\tborder: 1px solid var(--color-border);\n\tpadding: 2px 10px;\n\tborder-radius: var(--border-radius-large);\n\tmargin-right: 5px;\n\tcursor: pointer;\n\tdisplay: flex;\n}\n.sidebar .folders__folder * {\n\tcursor: pointer;\n}\n","",{version:3,sources:["webpack://./src/components/SidebarBookmark.vue"],names:[],mappings:";AA8RA;CACA,gBAAA;AACA;AAEA;CACA,WAAA;AACA;AAEA;CACA,YAAA;CACA,gBAAA;AACA;AAEA;CACA,aAAA;CACA,uBAAA;CACA,mBAAA;AACA;AAEA;CACA,YAAA;CACA,kBAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,YAAA;CACA,cAAA;CACA,uBAAA;CACA,WAAA;CACA,qBAAA;CACA,gBAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,aAAA;CACA,uBAAA;AACA;AAEA;CACA,qCAAA;CACA,iBAAA;CACA,yCAAA;CACA,iBAAA;CACA,eAAA;CACA,aAAA;AACA;AAEA;CACA,eAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcAppSidebar v-if="isActive"\n\t\tclass="sidebar"\n\t\t:name="bookmark.title || t(\'bookmarks\', \'(Empty title)\')"\n\t\t:name-editable="editingTitle"\n\t\t:name-placeholder="t(\'bookmarks\', \'Title\')"\n\t\t:subtitle="addedDate"\n\t\t:background="background"\n\t\t@update:active="activeTab = $event"\n\t\t@update:name="onEditTitleUpdate"\n\t\t@submit-name="onEditTitleSubmit"\n\t\t@dismiss-editing="onEditTitleCancel"\n\t\t@close="onClose">\n\t\t<template v-if="!editingTitle" slot="secondary-actions">\n\t\t\t<NcActionButton @click="onEditTitle">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<PencilIcon :size="20" />\n\t\t\t\t</template>\n\t\t\t</NcActionButton>\n\t\t</template>\n\t\t<template v-if="editingTitle" slot="secondary-actions">\n\t\t\t<NcActionButton @click="onEditTitleCancel">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<CloseIcon :size="20" />\n\t\t\t\t</template>\n\t\t\t</NcActionButton>\n\t\t</template>\n\t\t<NcAppSidebarTab id="bookmark-details"\n\t\t\t:name="t(\'bookmarks\', \'Details\')"\n\t\t\t:order="0">\n\t\t\t<template #icon>\n\t\t\t\t<InformationVariantIcon :size="20" />\n\t\t\t</template>\n\t\t\t<div class="sidebar">\n\t\t\t\t<div v-if="!editingTarget" class="details__line">\n\t\t\t\t\t<OpenInNewIcon :size="20" :aria-label="t(\'bookmarks\', \'Link\')" :title="t(\'bookmarks\', \'Link\')" />\n\t\t\t\t\t<a class="details__url" :href="bookmark.target === bookmark.url ? bookmark.target : \'javascript:void(0)\'">{{ bookmark.target }}</a>\n\t\t\t\t\t<NcActions v-if="isEditable" class="details__action">\n\t\t\t\t\t\t<NcActionButton @click="onEditTarget">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<PencilIcon :size="20" />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</NcActions>\n\t\t\t\t</div>\n\t\t\t\t<div v-else class="details__line">\n\t\t\t\t\t<OpenInNewIcon :size="20" :aria-label="t(\'bookmarks\', \'Link\')" :title="t(\'bookmarks\', \'Link\')" />\n\t\t\t\t\t<input v-model="target" class="details__url">\n\t\t\t\t\t<NcActions class="details__action">\n\t\t\t\t\t\t<NcActionButton @click="onEditTargetSubmit">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<ArrowRightIcon :size="20" />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</NcActions>\n\t\t\t\t\t<NcActions class="details__action">\n\t\t\t\t\t\t<NcActionButton @click="onEditTargetCancel">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<CloseIcon :size="20" />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</NcActions>\n\t\t\t\t</div>\n\t\t\t\t<div class="details__line">\n\t\t\t\t\t<FolderIcon :size="20" />\n\t\t\t\t\t<div class="folders">\n\t\t\t\t\t\t<span v-for="folderId in bookmark.folders"\n\t\t\t\t\t\t\t:key="folderId"\n\t\t\t\t\t\t\tv-tooltip="getFolderPath(folderId)"\n\t\t\t\t\t\t\tclass="folders__folder"\n\t\t\t\t\t\t\t@click="onOpenFolder(folderId)">\n\t\t\t\t\t\t\t<FolderIcon :size="20" /> {{ getFolder(folderId).title || (getFolder(folderId).parent_folder ? t(\'bookmarks\', \'Untitled folder\') : t(\'bookmarks\', \'Root folder\')) }}\n\t\t\t\t\t\t</span>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t\t<div class="details__line">\n\t\t\t\t\t<TagIcon :size="20" :aria-label="t(\'bookmarks\', \'Tags\')" :title="t(\'bookmarks\', \'Tags\')" />\n\t\t\t\t\t<NcSelect class="tags"\n\t\t\t\t\t\t:value="tags"\n\t\t\t\t\t\t:auto-limit="false"\n\t\t\t\t\t\t:limit="7"\n\t\t\t\t\t\t:options="allTags"\n\t\t\t\t\t\t:multiple="true"\n\t\t\t\t\t\t:taggable="true"\n\t\t\t\t\t\topen-direction="below"\n\t\t\t\t\t\t:placeholder="t(\'bookmarks\', \'Select tags and create new ones\')"\n\t\t\t\t\t\t:disabled="!isEditable"\n\t\t\t\t\t\t@input="onTagsChange"\n\t\t\t\t\t\t@tag="onAddTag" />\n\t\t\t\t</div>\n\t\t\t\t<div class="details__line">\n\t\t\t\t\t<PencilBoxIcon :size="20"\n\t\t\t\t\t\trole="figure"\n\t\t\t\t\t\t:aria-label="t(\'bookmarks\', \'Notes\')"\n\t\t\t\t\t\t:title="t(\'bookmarks\', \'Notes\')" />\n\t\t\t\t\t<NcRichContenteditable :value.sync="bookmark.description"\n\t\t\t\t\t\t:contenteditable="isEditable"\n\t\t\t\t\t\t:auto-complete="() => {}"\n\t\t\t\t\t\t:placeholder="t(\'bookmarks\', \'Notes for this bookmark …\')"\n\t\t\t\t\t\t:multiline="true"\n\t\t\t\t\t\tclass="notes"\n\t\t\t\t\t\t@update:value="onNotesChange" />\n\t\t\t\t</div>\n\t\t\t\t<div v-if="archivedFile" class="details__line">\n\t\t\t\t\t<FileDocumentIcon :size="20"\n\t\t\t\t\t\trole="figure"\n\t\t\t\t\t\t:aria-label="t(\'bookmarks\', \'Archived file\')"\n\t\t\t\t\t\t:title="t(\'bookmarks\', \'Archived file\')" />\n\t\t\t\t\t<NcButton :href="archivedFileUrl" target="_blank" type="primary">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<DownloadIcon :size="18" :fill-color="colorMainText" />\n\t\t\t\t\t\t</template>{{ t(\'bookmarks\', \'Download file\') }}\n\t\t\t\t\t</NcButton>\n\t\t\t\t\t<NcButton :href="archivedFile" target="_blank">\n\t\t\t\t\t\t{{ t(\'bookmarks\', \'Open file location\') }}\n\t\t\t\t\t</NcButton>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</NcAppSidebarTab>\n\t</NcAppSidebar>\n</template>\n<script>\nimport { NcAppSidebar, NcRichContenteditable, NcActionButton, NcActions, NcSelect, NcAppSidebarTab, NcButton } from \'@nextcloud/vue\'\nimport { FileDocumentIcon, FolderIcon, InformationVariantIcon, PencilIcon, ArrowRightIcon, TagIcon, OpenInNewIcon, CloseIcon, PencilBoxIcon, DownloadIcon } from \'./Icons.js\'\n\nimport { getCurrentUser } from \'@nextcloud/auth\'\nimport { generateRemoteUrl, generateUrl } from \'@nextcloud/router\'\nimport humanizeDuration from \'humanize-duration\'\nimport { actions, mutations } from \'../store/index.js\'\n\nconst MAX_RELATIVE_DATE = 1000 * 60 * 60 * 24 * 7 // one week\n\nexport default {\n\tname: \'SidebarBookmark\',\n\tcomponents: { NcAppSidebar, NcAppSidebarTab, NcSelect, NcActions, NcActionButton, NcRichContenteditable, FileDocumentIcon, FolderIcon, InformationVariantIcon, PencilIcon, ArrowRightIcon, TagIcon, OpenInNewIcon, CloseIcon, PencilBoxIcon, DownloadIcon, NcButton },\n\tdata() {\n\t\treturn {\n\t\t\ttitle: \'\',\n\t\t\teditingTitle: false,\n\t\t\ttarget: \'\',\n\t\t\teditingTarget: false,\n\t\t\tactiveTab: \'\',\n\t\t}\n\t},\n\tcomputed: {\n\t\tisActive() {\n\t\t\tif (!this.$store.state.sidebar) return false\n\t\t\treturn this.$store.state.sidebar.type === \'bookmark\'\n\t\t},\n\t\tbookmark() {\n\t\t\tif (!this.isActive) return\n\t\t\treturn this.$store.getters.getBookmark(this.$store.state.sidebar.id)\n\t\t},\n\t\tbackground() {\n\t\t\treturn generateUrl(`/apps/bookmarks/bookmark/${this.bookmark.id}/image`)\n\t\t},\n\t\taddedDate() {\n\t\t\tconst date = new Date(Number(this.bookmark.added) * 1000)\n\t\t\tconst age = Date.now() - date\n\t\t\tif (age < MAX_RELATIVE_DATE) {\n\t\t\t\tconst duration = humanizeDuration(age, {\n\t\t\t\t\tlanguage: OC.getLanguage().split(\'-\')[0],\n\t\t\t\t\tunits: [\'d\', \'h\', \'m\', \'s\'],\n\t\t\t\t\tlargest: 1,\n\t\t\t\t\tround: true,\n\t\t\t\t})\n\t\t\t\treturn this.t(\'bookmarks\', \'Created {time} ago\', { time: duration })\n\t\t\t} else {\n\t\t\t\treturn this.t(\'bookmarks\', \'Created on {date}\', { date: date.toLocaleDateString() })\n\t\t\t}\n\t\t},\n\t\ttags() {\n\t\t\treturn this.bookmark.tags\n\t\t},\n\t\tallTags() {\n\t\t\treturn this.$store.state.tags.map(tag => tag.name)\n\t\t},\n\t\tisOwner() {\n\t\t\tconst currentUser = getCurrentUser()\n\t\t\treturn currentUser && this.bookmark.userId === currentUser.uid\n\t\t},\n\t\tpermissions() {\n\t\t\treturn this.$store.getters.getPermissionsForBookmark(this.bookmark.id)\n\t\t},\n\t\tisEditable() {\n\t\t\treturn this.isOwner || (!this.isOwner && this.permissions.canWrite)\n\t\t},\n\t\tarchivedFile() {\n\t\t\tif (this.bookmark.archivedFile) {\n\t\t\t\treturn generateUrl(`/apps/files/?fileid=${this.bookmark.archivedFile}`)\n\t\t\t}\n\t\t\treturn null\n\t\t},\n\t\tarchivedFileUrl() {\n\t\t\t// remove `/username/files/`\n\t\t\tconst barePath = this.bookmark.archivedFilePath.split(\'/\').slice(3).join(\'/\')\n\t\t\treturn generateRemoteUrl(`webdav/${barePath}`)\n\t\t},\n\t},\n\tcreated() {\n\t},\n\tmethods: {\n\t\tonClose() {\n\t\t\tthis.$store.commit(mutations.SET_SIDEBAR, null)\n\t\t\tthis.editingTitle = false\n\t\t\tthis.editingTarget = false\n\t\t},\n\t\tonNotesChange(e) {\n\t\t\tthis.scheduleSave()\n\t\t},\n\t\tonTagsChange(tags) {\n\t\t\tthis.bookmark.tags = tags\n\t\t\tthis.scheduleSave()\n\t\t},\n\t\tonAddTag(tag) {\n\t\t\tthis.bookmark.tags.push(tag)\n\t\t\tthis.scheduleSave()\n\t\t},\n\t\tonEditTitle() {\n\t\t\tthis.title = this.bookmark.title\n\t\t\tthis.editingTitle = true\n\t\t},\n\t\tonEditTitleUpdate(e) {\n\t\t\tthis.title = e\n\t\t},\n\t\tonEditTitleSubmit() {\n\t\t\tthis.editingTitle = false\n\t\t\tthis.bookmark.title = this.title\n\t\t\tthis.scheduleSave()\n\t\t},\n\t\tonEditTitleCancel() {\n\t\t\tthis.editingTitle = false\n\t\t\tthis.title = \'\'\n\t\t},\n\t\tonEditTarget() {\n\t\t\tthis.target = this.bookmark.target\n\t\t\tthis.editingTarget = true\n\t\t},\n\t\tonEditTargetSubmit() {\n\t\t\tthis.editingTarget = false\n\t\t\tthis.bookmark.target = this.target\n\t\t\tthis.scheduleSave()\n\t\t},\n\t\tonEditTargetCancel() {\n\t\t\tthis.editingTarget = false\n\t\t\tthis.target = \'\'\n\t\t},\n\t\tscheduleSave() {\n\t\t\tif (this.changeTimeout) clearTimeout(this.changeTimeout)\n\t\t\tthis.changeTimeout = setTimeout(async () => {\n\t\t\t\tawait this.$store.dispatch(actions.SAVE_BOOKMARK, this.bookmark.id)\n\t\t\t\tawait this.$store.dispatch(actions.LOAD_TAGS)\n\t\t\t}, 1000)\n\t\t},\n\t\tonOpenFolder(id) {\n\t\t\tthis.$router.push({ name: this.routes.FOLDER, params: { folder: id } })\n\t\t\tthis.onClose()\n\t\t},\n\t\tgetFolder(id) {\n\t\t\tconst path = this.$store.getters.getFolder(id)\n\t\t\tconst folder = path[0]\n\t\t\treturn folder\n\t\t},\n\t\tgetFolderPath(id) {\n\t\t\tconst path = this.$store.getters.getFolder(id).reverse().map(folder => folder.title)\n\t\t\treturn \'/\' + path.join(\'/\')\n\t\t},\n\t\topenViewer() {\n\t\t\ttry {\n\t\t\t\tOCA.Viewer.open({\n\t\t\t\t\tpath: \'/\' + this.bookmark.archivedFilePath.split(\'/\').slice(2).join(\'/\'),\n\t\t\t\t})\n\t\t\t} catch (e) {\n\t\t\t\tthis.$store.commit(mutations.SHOW_ERROR, e.message)\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.sidebar h3 {\n\tmargin-top: 20px;\n}\n\n.sidebar .tags {\n\twidth: 100%;\n}\n\n.sidebar .notes {\n\tflex-grow: 1;\n\tmin-height: 80px;\n}\n\n.sidebar .details__line {\n\tdisplay: flex;\n\talign-items: flex-start;\n\tmargin-bottom: 10px;\n}\n\n.sidebar .details__line > * {\n\tflex-grow: 0;\n\tmargin-right: 10px;\n}\n\n.sidebar .details__line > :nth-child(2) {\n\tflex-grow: 1;\n}\n\n.sidebar .details__line .notes {\n\tflex-grow: 1;\n}\n\n.sidebar .details__url {\n\tflex-grow: 1;\n\tpadding: 8px 0;\n\ttext-overflow: ellipsis;\n\theight: 2em;\n\tdisplay: inline-block;\n\toverflow: hidden;\n}\n\n.sidebar .details__action {\n\tflex-grow: 0;\n}\n\n.sidebar .folders {\n\tdisplay: flex;\n\talign-items: flex-start;\n}\n\n.sidebar .folders__folder {\n\tborder: 1px solid var(--color-border);\n\tpadding: 2px 10px;\n\tborder-radius: var(--border-radius-large);\n\tmargin-right: 5px;\n\tcursor: pointer;\n\tdisplay: flex;\n}\n\n.sidebar .folders__folder * {\n\tcursor: pointer;\n}\n</style>\n'],sourceRoot:""}]);const r=i},34302:(t,e,n)=>{n.d(e,{A:()=>r});var o=n(71354),a=n.n(o),s=n(76314),i=n.n(s)()(a());i.push([t.id,"\n.sidebar h3 {\n\tfont-size: 1em;\n\tfont-weight: normal;\n}\n.participant-select {\n\tdisplay: flex;\n}\n.participant-select__selection {\n\tflex: 1;\n\tmargin-top: 5px !important;\n}\n.participant-select__actions {\n\tflex-grow: 0;\n}\n.share {\n\tdisplay: flex;\n\talign-items: center;\n\tmargin-top: 10px;\n}\n.share__avatar {\n\tflex-grow: 0;\n\theight: 44px;\n\twidth: 44px;\n}\n.share__avatar.active {\n\tbackground-color: var(--color-primary-element-light);\n\tborder-radius: 44px;\n}\n.share__privs {\n\tdisplay: flex;\n\twidth: 70px;\n\tflex-direction: row;\n\tjustify-content: end;\n}\n.share__privs > * {\n\tpadding-right: 5px;\n}\n.share__title {\n\tflex: 1;\n\tpadding-left: 10px;\n\tmargin: 0 !important;\n}\n.share__actions {\n\tflex-grow: 0;\n}\n","",{version:3,sources:["webpack://./src/components/SidebarFolder.vue"],names:[],mappings:";AAmVA;CACA,cAAA;CACA,mBAAA;AACA;AAEA;CACA,aAAA;AACA;AAEA;CACA,OAAA;CACA,0BAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,gBAAA;AACA;AAEA;CACA,YAAA;CACA,YAAA;CACA,WAAA;AACA;AAEA;CACA,oDAAA;CACA,mBAAA;AACA;AAEA;CACA,aAAA;CACA,WAAA;CACA,mBAAA;CACA,oBAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,OAAA;CACA,kBAAA;CACA,oBAAA;AACA;AAEA;CACA,YAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcAppSidebar v-if="isActive"\n\t\tclass="sidebar"\n\t\t:name="folder.title"\n\t\t:active.sync="activeTab"\n\t\t@close="onClose">\n\t\t<NcAppSidebarTab id="folder-details"\n\t\t\t:name="t(\'bookmarks\', \'Details\')"\n\t\t\t:order="0">\n\t\t\t<template #icon>\n\t\t\t\t<InformationVariantIcon :size="20" />\n\t\t\t</template>\n\t\t\t<h3>{{ t(\'bookmarks\', \'Owner\') }}</h3>\n\t\t\t<NcUserBubble :user="folder.userId" :display-name="folder.userDisplayName" />\n\t\t\t<h3>{{ t(\'bookmarks\', \'Bookmarks\') }}</h3>\n\t\t\t{{ bookmarkCount }}\n\t\t</NcAppSidebarTab>\n\t\t<NcAppSidebarTab v-if="isSharable"\n\t\t\tid="folder-sharing"\n\t\t\t:name="t(\'bookmarks\', \'Sharing\')"\n\t\t\t:order="1">\n\t\t\t<template #icon>\n\t\t\t\t<ShareVariantIcon :size="20" />\n\t\t\t</template>\n\t\t\t<div class="participant-select">\n\t\t\t\t<AccountIcon :size="20" :class="{\'share__avatar\': true }" />\n\t\t\t\t<NcSelect v-model="participant"\n\t\t\t\t\tlabel="displayName"\n\t\t\t\t\ttrack-by="user"\n\t\t\t\t\tclass="participant-select__selection"\n\t\t\t\t\t:user-select="true"\n\t\t\t\t\t:options="participantSearchResults"\n\t\t\t\t\t:loading="isSearching"\n\t\t\t\t\t:placeholder="t(\'bookmarks\', \'Select a user or group\')"\n\t\t\t\t\t@option:selected="onAddShare"\n\t\t\t\t\t@search="onParticipantSearch" />\n\t\t\t</div>\n\t\t\t<div class="share">\n\t\t\t\t<LinkIcon :size="20" :class="{\'share__avatar\': true, active: publicLink }" />\n\t\t\t\t<h3 class="share__title">\n\t\t\t\t\t{{ t(\'bookmarks\', \'Share link\') }}\n\t\t\t\t</h3>\n\t\t\t\t<div class="share__privs">\n\t\t\t\t\t<div v-if="publicLink"\n\t\t\t\t\t\tv-tooltip="t(\'bookmarks\', \'Reading allowed\')"\n\t\t\t\t\t\t:aria-label="t(\'bookmarks\', \'Reading allowed\')">\n\t\t\t\t\t\t<EyeIcon :size="20"\n\t\t\t\t\t\t\t:fill-color="colorMainText" />\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t\t<NcActions class="share__actions">\n\t\t\t\t\t<template v-if="publicLink">\n\t\t\t\t\t\t<NcActionButton @click="onCopyPublicLink">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<ClipboardIcon :size="20" />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Copy link\') }}\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t<NcActionButton icon="icon-clippy" @click="onCopyRssLink">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<RssIcon :size="20" />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Copy RSS feed\') }}\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t<NcActionSeparator />\n\t\t\t\t\t\t<NcActionButton @click="onDeletePublicLink">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<DeleteIcon :size="20" />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Delete link\') }}\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</template>\n\t\t\t\t\t<NcActionButton v-else @click="onAddPublicLink">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<PlusIcon :size="20" />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t{{ t(\'bookmarks\', \'Create public link\') }}\n\t\t\t\t\t</NcActionButton>\n\t\t\t\t</NcActions>\n\t\t\t</div>\n\t\t\t<div v-for="share of shares" :key="share.id">\n\t\t\t\t<div class="share">\n\t\t\t\t\t<NcAvatar v-if="share.type < 2"\n\t\t\t\t\t\t:user="share.participant"\n\t\t\t\t\t\tclass="share__avatar"\n\t\t\t\t\t\t:size="44" />\n\t\t\t\t\t<CircleIcon v-if="share.type === 7" :size="20" class="share_avatar" />\n\t\t\t\t\t<h3 class="share__title">\n\t\t\t\t\t\t{{ share.participantDisplayName }}\n\t\t\t\t\t</h3>\n\t\t\t\t\t<div class="share__privs">\n\t\t\t\t\t\t<div v-if="share.canShare"\n\t\t\t\t\t\t\tv-tooltip="t(\'bookmarks\', \'Resharing allowed\')"\n\t\t\t\t\t\t\t:aria-label="t(\'bookmarks\',\'Resharing allowed\')">\n\t\t\t\t\t\t\t<ShareAllIcon :size="20"\n\t\t\t\t\t\t\t\t:fill-color="colorMainText" />\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div v-if="share.canWrite"\n\t\t\t\t\t\t\tv-tooltip="t(\'bookmarks\',\'Editing allowed\')"\n\t\t\t\t\t\t\t:aria-label="t(\'bookmarks\',\'Editing allowed\')">\n\t\t\t\t\t\t\t<PencilIcon :size="20"\n\t\t\t\t\t\t\t\t:fill-color="colorMainText" />\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div v-tooltip="t(\'bookmarks\',\'Reading allowed\')"\n\t\t\t\t\t\t\t:aria-label="t(\'bookmarks\', \'Reading allowed\')">\n\t\t\t\t\t\t\t<EyeIcon :size="20"\n\t\t\t\t\t\t\t\t:fill-color="colorMainText" />\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<NcActions class="share__actions">\n\t\t\t\t\t\t<NcActionCheckbox :checked="share.canWrite" @update:checked="onEditShare(share.id, {canWrite: $event, canShare: share.canShare})">\n\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Allow editing\') }}\n\t\t\t\t\t\t</NcActionCheckbox>\n\t\t\t\t\t\t<NcActionCheckbox :checked="share.canShare" @update:checked="onEditShare(share.id, {canWrite: share.canWrite, canShare: $event})">\n\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Allow resharing\') }}\n\t\t\t\t\t\t</NcActionCheckbox>\n\t\t\t\t\t\t<NcActionButton icon="icon-delete" @click="onDeleteShare(share.id)">\n\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Remove share\') }}\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</NcActions>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</NcAppSidebarTab>\n\t</NcAppSidebar>\n</template>\n<script>\nimport { NcAppSidebar, NcUserBubble, NcActionSeparator, NcActionCheckbox, NcActionButton, NcActions, NcSelect, NcAvatar, NcAppSidebarTab } from \'@nextcloud/vue\'\nimport { getCurrentUser } from \'@nextcloud/auth\'\nimport { generateUrl, generateOcsUrl } from \'@nextcloud/router\'\nimport axios from \'@nextcloud/axios\'\nimport { actions, mutations } from \'../store/index.js\'\nimport { EyeIcon, PencilIcon, ShareAllIcon, ShareVariantIcon, InformationVariantIcon, ClipboardIcon, DeleteIcon, RssIcon, PlusIcon, LinkIcon, AccountIcon, CircleIcon } from \'./Icons.js\'\n\nexport default {\n\tname: \'SidebarFolder\',\n\tcomponents: { NcAppSidebar, NcAppSidebarTab, NcAvatar, NcSelect, NcActionButton, NcActionCheckbox, NcActions, NcUserBubble, NcActionSeparator, EyeIcon, PencilIcon, ShareAllIcon, ShareVariantIcon, InformationVariantIcon, ClipboardIcon, RssIcon, PlusIcon, DeleteIcon, LinkIcon, AccountIcon, CircleIcon },\n\tdata() {\n\t\treturn {\n\t\t\tparticipantSearchResults: [],\n\t\t\tparticipant: null,\n\t\t\tisSearching: false,\n\t\t\tactiveTab: \'\',\n\t\t}\n\t},\n\tcomputed: {\n\t\tisActive() {\n\t\t\tif (!this.$store.state.sidebar) return false\n\t\t\treturn this.$store.state.sidebar.type === \'folder\'\n\t\t},\n\t\tfolder() {\n\t\t\tif (!this.isActive) return\n\t\t\tconst folders = this.$store.getters.getFolder(this.$store.state.sidebar.id)\n\t\t\tconst folder = folders[0]\n\t\t\tif (folder.userId === getCurrentUser()) {\n\t\t\t\tthis.$store.dispatch(actions.LOAD_SHARES_OF_FOLDER, folder.id)\n\t\t\t\tthis.$store.dispatch(actions.LOAD_PUBLIC_LINK, folder.id)\n\t\t\t}\n\t\t\treturn folder\n\t\t},\n\t\tisOwner() {\n\t\t\tif (!this.folder) return\n\t\t\tconst currentUser = getCurrentUser()\n\t\t\treturn currentUser && this.folder.userId === currentUser.uid\n\t\t},\n\t\tpermissions() {\n\t\t\treturn this.$store.getters.getPermissionsForFolder(this.folder.id)\n\t\t},\n\t\tisSharable() {\n\t\t\tif (!this.folder) return\n\t\t\treturn this.isOwner || (!this.isOwner && this.permissions.canShare)\n\t\t},\n\t\tisEditable() {\n\t\t\tif (!this.folder) return\n\t\t\treturn this.isOwner || (!this.isOwner && this.permissions.canWrite)\n\t\t},\n\t\tshares() {\n\t\t\tif (!this.folder) return\n\t\t\treturn this.$store.getters.getSharesOfFolder(this.folder.id)\n\t\t},\n\t\ttoken() {\n\t\t\tif (!this.folder) return\n\t\t\treturn this.$store.getters.getTokenOfFolder(this.folder.id)\n\t\t},\n\t\tpublicLink() {\n\t\t\tif (!this.token) return\n\t\t\treturn window.location.origin + generateUrl(\'/apps/bookmarks/public/\' + this.token)\n\t\t},\n\t\trssLink() {\n\t\t\treturn (\n\t\t\t\twindow.location.origin\n\t\t\t\t\t+ generateUrl(\n\t\t\t\t\t\t\'/apps/bookmarks/public/rest/v2/bookmark?\'\n\t\t\t\t\t\t\t+ new URLSearchParams({\n\t\t\t\t\t\t\t\tformat: \'rss\',\n\t\t\t\t\t\t\t\tfolder: this.folder.id,\n\t\t\t\t\t\t\t\tpage: -1,\n\t\t\t\t\t\t\t\ttoken: this.token,\n\t\t\t\t\t\t\t}),\n\t\t\t\t\t).toString()\n\t\t\t)\n\t\t},\n\t\tbookmarkCount() {\n\t\t\treturn this.$store.state.countsByFolder[this.folder.id]\n\t\t},\n\t},\n\n\twatch: {\n\t\t\'$store.state.sidebar.tab\'(newActiveTab) {\n\t\t\tthis.activeTab = newActiveTab\n\t\t},\n\t},\n\n\tmethods: {\n\t\tonClose() {\n\t\t\tthis.$store.commit(mutations.SET_SIDEBAR, null)\n\t\t},\n\t\tasync onAddPublicLink() {\n\t\t\tawait this.$store.dispatch(actions.CREATE_PUBLIC_LINK, this.folder.id)\n\t\t\tthis.onCopyPublicLink()\n\t\t},\n\t\tonCopyPublicLink() {\n\t\t\tnavigator.clipboard.writeText(this.publicLink)\n\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, t(\'bookmarks\', \'Link copied\'))\n\t\t},\n\t\tonCopyRssLink() {\n\t\t\tnavigator.clipboard.writeText(this.rssLink)\n\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, t(\'bookmarks\', \'RSS feed copied\'))\n\t\t},\n\t\tasync onDeletePublicLink() {\n\t\t\tawait this.$store.dispatch(actions.DELETE_PUBLIC_LINK, this.folder.id)\n\t\t},\n\t\tasync onParticipantSearch(searchTerm) {\n\t\t\tif (!searchTerm) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.isSearching = true\n\t\t\tconst { data: { ocs: { data, meta } } } = await axios.get(generateOcsUrl(\'apps/files_sharing/api/v1\', 1) + `/sharees?format=json&itemType=folder&search=${searchTerm}&lookup=false&perPage=200&shareType[]=0&shareType[]=1&shareType[]=7`)\n\t\t\tif (meta.status !== \'ok\') {\n\t\t\t\tthis.participantSearchResults = []\n\t\t\t\treturn\n\t\t\t}\n\t\t\tconst users = data.exact.users.concat(data.users)\n\t\t\tconst groups = data.exact.groups.concat(data.groups)\n\t\t\tconst circles = data.exact.circles.concat(data.circles)\n\t\t\tthis.participantSearchResults = users.map(result => ({\n\t\t\t\tuser: result.value.shareWith,\n\t\t\t\tdisplayName: result.label,\n\t\t\t\ticon: \'icon-user\',\n\t\t\t\tisNoUser: false,\n\t\t\t})).concat(groups.map(result => ({\n\t\t\t\tuser: result.value.shareWith,\n\t\t\t\tdisplayName: result.label,\n\t\t\t\ticon: \'icon-group\',\n\t\t\t\tisNoUser: true,\n\t\t\t}))).concat(circles.map(result => ({\n\t\t\t\tuser: result.value.shareWith,\n\t\t\t\tdisplayName: result.label,\n\t\t\t\ticon: \'icon-circle\',\n\t\t\t\tisNoUser: true,\n\t\t\t\tisCircle: true,\n\t\t\t})))\n\t\t\tthis.isSearching = false\n\t\t},\n\t\tasync onAddShare(user) {\n\t\t\tawait this.$store.dispatch(actions.CREATE_SHARE, { folderId: this.folder.id, participant: user.user, type: user.isNoUser ? (user.isCircle ? 7 : 1) : 0 })\n\t\t},\n\t\tasync onEditShare(shareId, { canWrite, canShare }) {\n\t\t\tawait this.$store.dispatch(actions.EDIT_SHARE, { shareId, canWrite, canShare })\n\t\t},\n\t\tasync onDeleteShare(shareId) {\n\t\t\tawait this.$store.dispatch(actions.DELETE_SHARE, shareId)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n\t.sidebar h3 {\n\t\tfont-size: 1em;\n\t\tfont-weight: normal;\n\t}\n\n\t.participant-select {\n\t\tdisplay: flex;\n\t}\n\n\t.participant-select__selection {\n\t\tflex: 1;\n\t\tmargin-top: 5px !important;\n\t}\n\n\t.participant-select__actions {\n\t\tflex-grow: 0;\n\t}\n\n\t.share {\n\t\tdisplay: flex;\n\t\talign-items: center;\n\t\tmargin-top: 10px;\n\t}\n\n\t.share__avatar {\n\t\tflex-grow: 0;\n\t\theight: 44px;\n\t\twidth: 44px;\n\t}\n\n\t.share__avatar.active {\n\t\tbackground-color: var(--color-primary-element-light);\n\t\tborder-radius: 44px;\n\t}\n\n\t.share__privs {\n\t\tdisplay: flex;\n\t\twidth: 70px;\n\t\tflex-direction: row;\n\t\tjustify-content: end;\n\t}\n\n\t.share__privs > * {\n\t\tpadding-right: 5px;\n\t}\n\n\t.share__title {\n\t\tflex: 1;\n\t\tpadding-left: 10px;\n\t\tmargin: 0 !important;\n\t}\n\n\t.share__actions {\n\t\tflex-grow: 0;\n\t}\n</style>\n'],sourceRoot:""}]);const r=i},61205:(t,e,n)=>{n.d(e,{A:()=>r});var o=n(71354),a=n.n(o),s=n(76314),i=n.n(s)()(a());i.push([t.id,"\n.app-content {\n\tposition: relative !important;\n}\n","",{version:3,sources:["webpack://./src/components/ViewPrivate.vue"],names:[],mappings:";AA2PA;CACA,6BAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcContent app-name=\"bookmarks\">\n\t\t<Navigation />\n\t\t<NcAppContent :show-details.sync=\"showDetails\">\n\t\t\t<template v-if=\"showFolderOverview\" #list>\n\t\t\t\t<FolderOverview :show-details.sync=\"showDetails\" />\n\t\t\t</template>\n\t\t\t<template #default>\n\t\t\t\t<Controls />\n\t\t\t\t<BookmarksList />\n\t\t\t</template>\n\t\t</NcAppContent>\n\t\t<SidebarBookmark />\n\t\t<SidebarFolder />\n\t\t<MoveDialog />\n\t\t<CopyDialog />\n\t\t<LoadingModal />\n\t\t<BookmarkContent />\n\t\t<WhatsnewModal />\n\t</NcContent>\n</template>\n\n<script>\nimport { NcContent, NcAppContent } from '@nextcloud/vue'\nimport Navigation from './Navigation.vue'\nimport FolderOverview from './FolderOverview.vue'\nimport BookmarksList from './BookmarksList.vue'\nimport Controls from './Controls.vue'\nimport SidebarBookmark from './SidebarBookmark.vue'\nimport SidebarFolder from './SidebarFolder.vue'\nimport MoveDialog from './MoveDialog.vue'\nimport CopyDialog from './CopyDialog.vue'\nimport { privateRoutes } from '../router.js'\nimport { actions, mutations } from '../store/index.js'\nimport LoadingModal from './LoadingModal.vue'\nimport BookmarkContent from './BookmarkContent.vue'\nimport WhatsnewModal from './WhatsnewModal.vue'\nimport { getCurrentUser } from '@nextcloud/auth'\n\nexport default {\n\tname: 'ViewPrivate',\n\tcomponents: {\n\t\tBookmarkContent,\n\t\tLoadingModal,\n\t\tNavigation,\n\t\tNcContent,\n\t\tNcAppContent,\n\t\tFolderOverview,\n\t\tControls,\n\t\tBookmarksList,\n\t\tSidebarBookmark,\n\t\tSidebarFolder,\n\t\tMoveDialog,\n\t\tCopyDialog,\n\t\tWhatsnewModal,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tnewBookmark: false,\n\t\t\tshowDetails: false,\n\t\t\tsmallScreen: false,\n\t\t\tshowWhatsnew: false,\n\t\t\tinitialLoad: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\tfolders() {\n\t\t\treturn this.$store.state.folders\n\t\t},\n\t\ttags() {\n\t\t\treturn this.$store.state.tags\n\t\t},\n\t\tisFolderView() {\n\t\t\treturn this.$route.name === privateRoutes.FOLDER || this.$route.name === privateRoutes.HOME\n\t\t},\n\t\tisSharedWithYou() {\n\t\t\treturn this.$route.name === privateRoutes.SHARED_FOLDERS\n\t\t},\n\t\tisTrashbin() {\n\t\t\tconst folder = this.$store.getters.getFolder(this.$route.params.folder || '-1')[0]\n\t\t\treturn this.$route.name === privateRoutes.TRASHBIN || (this.$route.name === privateRoutes.FOLDER && folder.softDeleted)\n\t\t},\n\t\tshowFolderOverview() {\n\t\t\treturn this.isFolderView && !this.smallScreen && this.folders.length && !this.isTrashbin && !this.isSharedWithYou\n\t\t},\n\t},\n\twatch: {\n\t\t$route: 'onRoute',\n\t\tasync showFolderOverview(value) {\n\t\t\tif (!this.initialLoad && value) {\n\t\t\t\t// hack to make bookmarkslist rerender\n\t\t\t\tawait this.$store.dispatch(actions.RELOAD_VIEW)\n\t\t\t}\n\t\t},\n\t},\n\tasync created() {\n\t\tthis.initialLoad = true\n\t\tconst mediaQuery = window.matchMedia('(max-width: 1024px)')\n\t\tthis.smallScreen = mediaQuery.matches\n\t\tmediaQuery.addEventListener('change', this.onWindowFormatChange)\n\n\t\t// set loading indicator\n\t\tthis.$store.commit(mutations.FETCH_START, { type: 'bookmarks' })\n\n\t\tawait this.reloadSettings()\n\n\t\tthis.reloadSharedFolders()\n\t\tthis.reloadCount()\n\t\tthis.reloadTags()\n\n\t\tawait Promise.all([\n\t\t\tthis.reloadFolders(),\n\t\t\tthis.reloadDeletedFolders(),\n\t\t])\n\n\t\tthis.onRoute()\n\n\t\tconst currentUser = getCurrentUser()\n\t\tif (currentUser.isAdmin) {\n\t\t\tconst scrapingEnabled = await this.getSettingValue('privacy.enableScraping')\n\t\t\tconst alreadyShown = window.localStorage && window.localStorage.getItem('bookmarks.scrapingNoteShown')\n\t\t\tif (scrapingEnabled !== 'true' && alreadyShown !== 'true') {\n\t\t\t\twindow.localStorage && window.localStorage.setItem('bookmarks.scrapingNoteShown', 'true')\n\t\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, t('bookmarks', 'Network access is disabled by default. Go to administrator settings for the bookmarks app to allow fetching previews and favicons.'))\n\t\t\t}\n\t\t}\n\t\tthis.initialLoad = false\n\t},\n\n\tmethods: {\n\t\tasync onRoute() {\n\t\t\tconst route = this.$route\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tif (typeof this.$store.state.loading.bookmarks === 'function') {\n\t\t\t\tthis.$store.state.loading.bookmarks()\n\t\t\t}\n\t\t\tswitch (route.name) {\n\t\t\tcase privateRoutes.HOME:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_FOLDER, { folder: '-1' })\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.RECENT:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_RECENT)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.UNTAGGED:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_UNTAGGED)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.UNAVAILABLE:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_UNAVAILABLE)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.ARCHIVED:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_ARCHIVED)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.DUPLICATED:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_DUPLICATED)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.TRASHBIN:\n\t\t\t\tthis.$store.commit(mutations.FETCH_END, 'bookmarks')\n\t\t\t\tawait this.$store.dispatch(actions.LOAD_DELETED_BOOKMARKS)\n\t\t\t\tawait this.$store.dispatch(actions.LOAD_DELETED_FOLDERS)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.SHARED_FOLDERS:\n\t\t\t\tthis.$store.dispatch(actions.LOAD_SHARED_FOLDERS)\n\t\t\t\tawait this.$store.dispatch(actions.RELOAD_VIEW)\n\t\t\t\tawait this.$store.commit(mutations.REMOVE_ALL_BOOKMARKS)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.BOOKMARK:\n\t\t\t\tawait this.$store.dispatch(actions.LOAD_BOOKMARK, route.params.bookmark)\n\t\t\t\tthis.$store.dispatch(actions.OPEN_BOOKMARK, route.params.bookmark)\n\t\t\t\tthis.$store.commit(mutations.FETCH_END, 'bookmarks')\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.FOLDER:\n\t\t\t\t// eslint-disable-next-line no-case-declarations\n\t\t\t\tconst folder = this.$store.getters.getFolder(route.params.folder)[0]\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_FOLDER, { folder: route.params.folder, softDeleted: folder.softDeleted })\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.TAGS:\n\t\t\t\tthis.$store.dispatch(\n\t\t\t\t\tactions.FILTER_BY_TAGS,\n\t\t\t\t\troute.params.tags.split(','),\n\t\t\t\t)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.SEARCH:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_SEARCH, { search: route.params.search, folder: route.params.folder || -1 })\n\t\t\t\tbreak\n\t\t\tdefault:\n\t\t\t\tthrow new Error('Nothing here. Move along.')\n\t\t\t}\n\t\t},\n\n\t\tasync reloadTags() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_TAGS)\n\t\t},\n\t\tasync reloadFolders() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_FOLDERS)\n\t\t},\n\t\tasync reloadDeletedFolders() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_DELETED_FOLDERS)\n\t\t},\n\t\tasync reloadSharedFolders() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_SHARED_FOLDERS)\n\t\t},\n\t\tasync reloadSettings() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_SETTINGS)\n\t\t},\n\t\tasync reloadCount() {\n\t\t\treturn Promise.all([\n\t\t\t\tthis.$store.dispatch(actions.COUNT_BOOKMARKS, -1),\n\t\t\t\tthis.$store.dispatch(actions.COUNT_UNAVAILABLE),\n\t\t\t\tthis.$store.dispatch(actions.COUNT_ARCHIVED),\n\t\t\t\tthis.$store.dispatch(actions.COUNT_DUPLICATED),\n\t\t\t\tthis.$store.dispatch(actions.COUNT_ALL_CLICKS),\n\t\t\t\tthis.$store.dispatch(actions.COUNT_WITH_CLICKS),\n\t\t\t])\n\t\t},\n\n\t\tonSearch(search) {\n\t\t\tthis.$router.push({ name: privateRoutes.SEARCH, params: { search } })\n\t\t},\n\n\t\tonResetSearch() {\n\t\t\tthis.$router.push({ name: privateRoutes.HOME })\n\t\t},\n\n\t\tasync getSettingValue(setting) {\n\t\t\tconst resDocument = await new Promise((resolve, reject) =>\n\t\t\t\tOCP.AppConfig.getValue('bookmarks', setting, null, {\n\t\t\t\t\tsuccess: resolve,\n\t\t\t\t\terror: reject,\n\t\t\t\t}),\n\t\t\t)\n\t\t\tif (resDocument.querySelector('status').textContent !== 'ok') {\n\t\t\t\tconsole.error('Failed request', resDocument)\n\t\t\t\treturn\n\t\t\t}\n\t\t\tconst dataEl = resDocument.querySelector('data')\n\t\t\treturn dataEl.firstElementChild.textContent\n\t\t},\n\n\t\tonWindowFormatChange(mediaQuery) {\n\t\t\tthis.smallScreen = mediaQuery.matches\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.app-content {\n\tposition: relative !important;\n}\n</style>\n"],sourceRoot:""}]);const r=i},30041:(t,e,n)=>{n.d(e,{A:()=>r});var o=n(71354),a=n.n(o),s=n(76314),i=n.n(s)()(a());i.push([t.id,"\n.whatsnew {\n\tmin-width: 300px;\n\toverflow-y: scroll;\n\tpadding: 30px;\n}\n.whatsnew li {\n\tfont-size: 1.2em;\n\tmargin-bottom: 15px;\n}\n.whatsnew h3 {\n\tfont-size: 2em;\n\tmargin-bottom: 25px;\n}\n.whatsnew a {\n\ttext-decoration:  underline;\n}\n","",{version:3,sources:["webpack://./src/components/WhatsnewModal.vue"],names:[],mappings:";AAmDA;CACA,gBAAA;CACA,kBAAA;CACA,aAAA;AACA;AAEA;CACA,gBAAA;CACA,mBAAA;AACA;AAEA;CACA,cAAA;CACA,mBAAA;AACA;AAEA;CACA,2BAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021 Artem Lavrukhin <lavryha4590@gmail.com>\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcModal v-if=\"showModal\" :name=\"t('bookmarks', `What's new?`)\" @close=\"onClose\">\n\t\t<div class=\"whatsnew\">\n\t\t\t<h3>✨ {{ t('bookmarks', 'What\\'s new?') }}</h3>\n\t\t\t<ul>\n\t\t\t\t<li>🔥 Visualized click count</li>\n\t\t\t\t<li>🐛 Lots of small bug fixes and performance improvements</li>\n\t\t\t</ul>\n\t\t\t<p>&nbsp;</p>\n\t\t\t<h3>💙 {{ t('bookmarks', 'Support this project') }}</h3>\n\t\t\t<p>{{ t('bookmarks', 'My work on this Bookmarks app is fuelled by a voluntary subscription model. If you think what I do is worthwhile, I would be happy if you could support my work. Also, please consider giving the app a review on the Nextcloud app store. Thank you 💙 ') }}</p>\n\t\t\t<p>&nbsp;</p>\n\t\t\t<p><a href=\"https://github.com/sponsors/marcelklehr\">GitHub Sponsors</a>, <a href=\"https://www.patreon.com/marcelklehr\">Patreon</a>, <a href=\"https://liberapay.com/marcelklehr/donate\">Liberapay</a>, <a href=\"https://ko-fi.com/marcelklehr\">Ko-Fi</a>, <a href=\"https://www.paypal.com/donate/?hosted_button_id=VESJWWBEZ9V6J\">PayPal</a></p>\n\t\t\t<p><a href=\"https://apps.nextcloud.com/apps/bookmarks\">{{ t('bookmarks', 'Leave a rating on the Nextcloud App Store') }}</a></p>\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\nimport { actions } from '../store/index.js'\nimport packageJson from '../../package.json'\n\nconst ENABLED = false\n\nexport default {\n\tname: 'WhatsnewModal',\n\tcomponents: {\n\t\tNcModal,\n\t},\n\tcomputed: {\n\t\tshowModal() {\n\t\t\treturn ENABLED && this.$store.state.settings.hasSeenWhatsnew?.split('.').slice(0, 2).join('.') !== packageJson.version.split('.').slice(0, 2).join('.')\n\t\t},\n\t},\n\tmethods: {\n\t\tonClose() {\n\t\t\tthis.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'hasSeenWhatsnew',\n\t\t\t\tvalue: packageJson.version,\n\t\t\t})\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.whatsnew {\n\tmin-width: 300px;\n\toverflow-y: scroll;\n\tpadding: 30px;\n}\n\n.whatsnew li {\n\tfont-size: 1.2em;\n\tmargin-bottom: 15px;\n}\n\n.whatsnew h3 {\n\tfont-size: 2em;\n\tmargin-bottom: 25px;\n}\n\n.whatsnew a {\n\ttext-decoration:  underline;\n}\n</style>\n"],sourceRoot:""}]);const r=i},56265:(e,o,a)=>{a.r(o),a.d(o,{default:()=>_t});var s=a(64613),i=a(96192),r=a(85090),l=a.n(r),c=a(99498),d=a(2326),p=a(21777),h=a(85168),m=a(39912),u=a(2545);const k={name:"Settings",components:{LifebuoyIcon:a(13016).A,HeartIcon:u.A,NcAppSettingsSection:s.Te,NcAppSettingsDialog:s.q4,NcCheckboxRadioSwitch:s.AO,NcTextField:s.v,ImportIcon:i.z5,ArchiveIcon:i.kb,BackupIcon:i.Cn,LinkIcon:i.qY,ApplicationIcon:i.UR,ApplicationImportIcon:i.lU},props:{settingsOpen:{type:Boolean,required:!0}},data(){return{importing:!1,deleting:!1,addToHomeScreen:null,archivePathPicker:(0,h.a1)(this.t("bookmarks","Archive path")).allowDirectories(!0).setModal(!0).setType(1).setMultiSelect(!1).build(),backupPathPicker:(0,h.a1)(this.t("bookmarks","Backup path")).allowDirectories(!0).setModal(!0).setType(1).setMultiSelect(!1).build()}},computed:{oc_defaults:()=>window.oc_defaults,bookmarklet(){const t=window.location.origin+(0,c.generateUrl)("/apps/bookmarks/bookmarklet");let e="";return this.$route.name===m.YO.FOLDER&&(e="+'&folderId=".concat(this.$route.params.folder,"'")),"javascript:(function(){var a=window,b=document,c=encodeURIComponent,e=c(document.title),d=a.open('".concat(t,"?url='+c(b.location)+'&title='+e").concat(e,",'bkmk_popup','left='+((a.screenX||a.screenLeft)+10)+',top='+((a.screenY||a.screenTop)+10)+',height=650px,width=550px,resizable=1,alwaysRaised=1');a.setTimeout(function(){d.focus()},300);})();")},scrapingEnabled(){return"true"===this.$store.state.settings["privacy.enableScraping"]},archiveEnabled(){return this.$store.state.settings["archive.enabled"]&&"true"===this.$store.state.settings["privacy.enableScraping"]},archivePath(){return this.$store.state.settings["archive.filePath"]},backupPath(){return this.$store.state.settings["backup.filePath"]},backupEnabled(){return"true"===this.$store.state.settings["backup.enabled"]}},mounted(){window.addEventListener("beforeinstallprompt",(t=>{t.preventDefault(),this.addToHomeScreen=t,this.showAddToHomeScreen=!0}))},methods:{onImportOpen(t){t.target.previousElementSibling.click()},async onImportSubmit(t){this.importing=!0;try{await this.$store.dispatch(d.o1.IMPORT_BOOKMARKS,{file:t.target.files[0],folder:this.$route.params.folder||-1})}catch(t){console.warn(t)}this.importing=!1},onExport(){window.location=(0,c.generateUrl)("/apps/bookmarks/bookmark/export?requesttoken=".concat(encodeURIComponent((0,p.do)())))},async onChangeArchiveEnabled(t){await this.$store.dispatch(d.o1.SET_SETTING,{key:"archive.enabled",value:String(!this.archiveEnabled)})},async onChangeArchivePath(t){const e=await this.archivePathPicker.pick();await this.$store.dispatch(d.o1.SET_SETTING,{key:"archive.filePath",value:e})},async onChangeBackupPath(t){if(!this.backupEnabled)return;const e=await this.backupPathPicker.pick();await this.$store.dispatch(d.o1.SET_SETTING,{key:"backup.filePath",value:e})},async onChangeBackupEnabled(t){await this.$store.dispatch(d.o1.SET_SETTING,{key:"backup.enabled",value:String(!this.backupEnabled)})},clickAddToHomeScreen(){this.addToHomeScreen?(this.addToHomeScreen.prompt(),this.addToHomeScreen.userChoice.then((t=>{"accepted"===t.outcome?console.warn("User accepted the A2HS prompt"):console.warn("User dismissed the A2HS prompt"),this.addToHomeScreen=null}))):alert(this.t("bookmarks",'Please select "Add to home screen" in your browser menu'))}}};var A=a(85072),b=a.n(A),g=a(97825),v=a.n(g),f=a(77659),_=a.n(f),C=a(55056),N=a.n(C),S=a(10540),w=a.n(S),I=a(41113),y=a.n(I),T=a(48060),E={};E.styleTagTransform=y(),E.setAttributes=N(),E.insert=_().bind(null,"head"),E.domAPI=v(),E.insertStyleElement=w();b()(T.A,E);T.A&&T.A.locals&&T.A.locals;var x=a(14486);const O=(0,x.A)(k,(function(){var t=this,e=t._self._c;return e("NcAppSettingsDialog",{staticClass:"settings",attrs:{open:t.settingsOpen,"show-navigation":!0,name:t.t("bookmarks","Bookmarks settings")},on:{"update:open":function(e){return t.$emit("update:settingsOpen",e)}}},[e("NcAppSettingsSection",{attrs:{id:"importexport",name:t.t("bookmarks","Import/Export")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ImportIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v(" "),e("input",{staticClass:"import",attrs:{type:"file",size:"5"},on:{change:t.onImportSubmit}}),t._v(" "),e("button",{on:{click:t.onImportOpen}},[e("span",{class:{"icon-upload":!t.importing,"icon-loading-small":t.importing}}),t._v(t._s(t.t("bookmarks","Import bookmarks"))+"\n\t\t")]),t._v(" "),e("button",{on:{click:t.onExport}},[e("span",{staticClass:"icon-download"}),t._v(" "+t._s(t.t("bookmarks","Export bookmarks"))+"\n\t\t")])]),t._v(" "),e("NcAppSettingsSection",{attrs:{id:"archive",name:t.t("bookmarks","Auto-archiving")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArchiveIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v(" "),e("p",[t._v(t._s(t.t("bookmarks","The bookmarks app can automatically archive the web content of links you have bookmarked")))]),t._v(" "),t.scrapingEnabled?[e("NcCheckboxRadioSwitch",{attrs:{checked:t.archiveEnabled},on:{"update:checked":t.onChangeArchiveEnabled}},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Enable archiving"))+"\n\t\t\t")]),t._v(" "),t.archiveEnabled?e("NcTextField",{attrs:{label:t.t("bookmarks","Enter the path of a folder in your Files where bookmarked files should be stored."),value:t.archivePath,readonly:!0},on:{click:t.onChangeArchivePath}}):t._e()]:[e("p",[t._v(t._s(t.t("bookmarks","Currently your administrator has disabled network access for this app, however, which is why Auto-archiving is disabled at the moment.")))])]],2),t._v(" "),e("NcAppSettingsSection",{attrs:{id:"backup",name:t.t("bookmarks","Auto-Backup")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("BackupIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v(" "),e("p",[t._v(t._s(t.t("bookmarks","The bookmarks app can automatically backup your bookmarks on a daily basis to prevent data loss when syncing bookmarks across devices.")))]),t._v(" "),e("NcCheckboxRadioSwitch",{attrs:{checked:t.backupEnabled},on:{"update:checked":t.onChangeBackupEnabled}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Enable backups"))+"\n\t\t")]),t._v(" "),t.backupEnabled?e("NcTextField",{attrs:{label:t.t("bookmarks","Enter the path of a folder in your Files where backups will be stored."),value:t.backupPath,readonly:!0},on:{click:t.onChangeBackupPath}}):t._e()],1),t._v(" "),e("NcAppSettingsSection",{attrs:{id:"client-apps",name:t.t("bookmarks","Client apps")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ApplicationIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v(" "),e("p",[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Also check out the collection of client apps that integrate with this app: "))+"\n\t\t\t"),e("a",{staticStyle:{"text-decoration":"underline"},attrs:{href:"https://github.com/nextcloud/bookmarks#third-party-clients"}},[t._v(t._s(t.t("bookmarks","Client apps")))])])]),t._v(" "),e("NcAppSettingsSection",{attrs:{id:"install",name:t.t("bookmarks","Install web app")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ApplicationImportIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v(" "),e("p",[t._v(t._s(t.t("bookmarks","You can install this app on your device home screen to quickly access your bookmarks on your phone. You can easily remove the app from your home screen again, if you don't like it.")))]),t._v(" "),e("a",{staticClass:"button center",attrs:{href:"#"},on:{click:function(e){return e.preventDefault(),t.clickAddToHomeScreen.apply(null,arguments)}}},[t._v(t._s(t.t("bookmarks","Install on home screen")))])]),t._v(" "),e("NcAppSettingsSection",{attrs:{id:"bookmarklet",name:t.t("bookmarks","Bookmarklet")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("LinkIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v(" "),e("p",[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Drag this to your browser bookmarks and click it to quickly bookmark a webpage."))+"\n\t\t")]),t._v(" "),e("a",{staticClass:"button center",attrs:{href:t.bookmarklet},on:{click:function(t){t.preventDefault()}}},[t._v(t._s(t.t("bookmarks","Add to {instanceName}",{instanceName:t.oc_defaults.name})))])]),t._v(" "),e("NcAppSettingsSection",{attrs:{id:"need-help",name:t.t("bookmarks","Need help?")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("LifebuoyIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v(" "),e("p",[e("a",{attrs:{href:"https://github.com/nextcloud/bookmarks/issues/"}},[t._v(t._s(t.t("bookmarks","If you have problems with this Bookmarks app or have an idea about what could be improved, don't hesitate to get in touch by clicking here.")))])])]),t._v(" "),e("NcAppSettingsSection",{attrs:{id:"support-project",name:t.t("bookmarks","Support this project")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("HeartIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v(" "),e("p",[t._v(t._s(t.t("bookmarks","My work on this Bookmarks app is fuelled by a voluntary subscription model. If you think what I do is worthwhile, I would be happy if you could support my work. Also, please consider giving the app a review on the Nextcloud app store. Thank you 💙 ")))]),t._v(" "),e("p",[t._v(" ")]),t._v(" "),e("p",[e("a",{attrs:{href:"https://github.com/sponsors/marcelklehr"}},[t._v("GitHub Sponsors")]),t._v(", "),e("a",{attrs:{href:"https://www.patreon.com/marcelklehr"}},[t._v("Patreon")]),t._v(", "),e("a",{attrs:{href:"https://liberapay.com/marcelklehr/donate"}},[t._v("Liberapay")]),t._v(", "),e("a",{attrs:{href:"https://ko-fi.com/marcelklehr"}},[t._v("Ko-Fi")]),t._v(", "),e("a",{attrs:{href:"https://www.paypal.me/marcelklehr1"}},[t._v("PayPal")])]),t._v(" "),e("p",[e("a",{attrs:{href:"https://apps.nextcloud.com/apps/bookmarks"}},[t._v("Review Nextcloud Bookmarks on apps.nextcloud.com")])])])],1)}),[],!1,null,null,null).exports,L={name:"Navigation",components:{NcAppNavigation:s.hN,NcAppNavigationItem:s.G_,NcAppNavigationNewItem:s.qU,NcCounterBubble:s.E7,NcAppNavigationSpacer:s.lJ,NcActionButton:s.Ko,Settings:O,ProgressBar:l(),HistoryIcon:i.os,TagOffIcon:i.Zq,LinkVariantOffIcon:i.KD,TagPlusIcon:i.Ox,TagMultipleIcon:i.Kr,FileDocumentMultipleIcon:i.ni,ShareVariantIcon:i.wr,VectorLinkIcon:i.LW,HomeIcon:i.fA,TagIcon:i.gq,DeleteIcon:i.d7,GaugeIcon:i.TP,CogIcon:i.DP,TrashbinIcon:i.X},filters:{largeNumbers:t=>t>1e4?Math.round(t/1e3)+"K":t>=1e3?Math.round(t/100)/10+"K":t},data:()=>({settingsOpen:!1}),computed:{tags(){return this.$store.state.tags.map((t=>({route:{name:this.routes.TAGS,params:{tags:t.name}},name:t.name,count:t.count})))},allBookmarksCount(){return this.$store.state.countsByFolder[-1]},unavailableBookmarksCount(){return this.$store.state.unavailableCount},sharedFoldersCount(){return Object.keys(this.$store.state.sharedFoldersById).length},archivedBookmarksCount(){return this.$store.state.archivedCount},duplicatedBookmarksCount(){return this.$store.state.duplicatedCount},bookmarksLimit(){return this.$store.state.settings.limit},scrapingEnabled(){return"true"===this.$store.state.settings["privacy.enableScraping"]},archiveEnabled(){return this.$store.state.settings["archive.enabled"]&&"true"===this.$store.state.settings["privacy.enableScraping"]}},created(){},methods:{onSearchTags(){this.$router.push({name:this.routes.TAGS})},onDeleteTag(t){this.$store.dispatch(d.o1.DELETE_TAG,t)},onRenameTag(t,e){this.$store.dispatch(d.o1.RENAME_TAG,{oldName:t,newName:e})},onNewTag(t){this.$store.commit(d.z4.ADD_TAG,t)},allowDropOnTag(t){return!this.$store.state.selection.folders.length&&this.$store.state.selection.bookmarks.length},onDropOnTag(t){this.$store.dispatch(d.o1.TAG_SELECTION,{tags:[t],originalTags:[]})}}};var D=a(2353),B={};B.styleTagTransform=y(),B.setAttributes=N(),B.insert=_().bind(null,"head"),B.domAPI=v(),B.insertStyleElement=w();b()(D.A,B);D.A&&D.A.locals&&D.A.locals;const $=(0,x.A)(L,(function(){var t=this,e=t._self._c;return e("NcAppNavigation",{staticClass:"navigation",scopedSlots:t._u([{key:"list",fn:function(){return[e("NcAppNavigationItem",{key:"menu-home",attrs:{to:{name:t.routes.HOME},name:t.t("bookmarks","All bookmarks"),exact:!0}},[e("HomeIcon",{attrs:{slot:"icon",size:20},slot:"icon"}),t._v(" "),e("NcCounterBubble",{attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t"+t._s(t._f("largeNumbers")(t.allBookmarksCount))+"\n\t\t\t")])],1),t._v(" "),e("NcAppNavigationItem",{key:"menu-recent",attrs:{to:{name:t.routes.RECENT},name:t.t("bookmarks","Recent")}},[e("HistoryIcon",{attrs:{slot:"icon",size:20},slot:"icon"})],1),t._v(" "),e("NcAppNavigationItem",{key:"menu-shared-folders",attrs:{to:{name:t.routes.SHARED_FOLDERS},name:t.t("bookmarks","Shared with you")}},[e("ShareVariantIcon",{attrs:{slot:"icon",size:20},slot:"icon"}),t._v(" "),e("NcCounterBubble",{attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t"+t._s(t._f("largeNumbers")(t.sharedFoldersCount))+"\n\t\t\t")])],1),t._v(" "),t.scrapingEnabled&&t.archiveEnabled?e("NcAppNavigationItem",{key:"menu-archived",attrs:{to:{name:t.routes.ARCHIVED},name:t.t("bookmarks","Files")}},[e("FileDocumentMultipleIcon",{attrs:{slot:"icon",size:20},slot:"icon"}),t._v(" "),e("NcCounterBubble",{attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t"+t._s(t._f("largeNumbers")(t.archivedBookmarksCount))+"\n\t\t\t")])],1):t._e(),t._v(" "),e("NcAppNavigationItem",{key:"menu-duplicated",attrs:{to:{name:t.routes.DUPLICATED},name:t.t("bookmarks","Duplicates")}},[e("VectorLinkIcon",{attrs:{slot:"icon",size:20},slot:"icon"}),t._v(" "),e("NcCounterBubble",{attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t"+t._s(t._f("largeNumbers")(t.duplicatedBookmarksCount))+"\n\t\t\t")])],1),t._v(" "),e("NcAppNavigationItem",{key:"menu-unavailable",attrs:{to:{name:t.routes.UNAVAILABLE},name:t.t("bookmarks","Broken links")}},[e("LinkVariantOffIcon",{attrs:{slot:"icon",size:20},slot:"icon"}),t._v(" "),e("NcCounterBubble",{attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t"+t._s(t._f("largeNumbers")(t.unavailableBookmarksCount))+"\n\t\t\t")])],1),t._v(" "),e("NcAppNavigationSpacer"),t._v(" "),e("NcAppNavigationNewItem",{key:"menu-new-tag",attrs:{name:t.t("bookmarks","New tag")},on:{"new-item":t.onNewTag}},[e("TagPlusIcon",{attrs:{slot:"icon",size:20},slot:"icon"})],1),t._v(" "),Boolean(t.tags.length)?[e("NcAppNavigationItem",{key:"menu-tags",attrs:{name:t.t("bookmarks","Search tags")},on:{click:t.onSearchTags}},[e("TagMultipleIcon",{attrs:{slot:"icon",size:20},slot:"icon"})],1),t._v(" "),t._l(t.tags,(function(n){return e("NcAppNavigationItem",{directives:[{name:"drop-target",rawName:"v-drop-target",value:{allow:e=>t.allowDropOnTag(n.name,e),drop:e=>t.onDropOnTag(n.name,e)},expression:"{allow: (e) => allowDropOnTag(tag.name, e), drop: (e) => onDropOnTag(tag.name, e)}"}],key:"tag-"+n.name,attrs:{to:n.route,"force-menu":!0,"edit-label":t.t("bookmarks","Rename"),editable:!t.isPublic,name:n.name},on:{"update:name":function(e){return t.onRenameTag(n.name,e)}}},[e("TagIcon",{attrs:{slot:"icon",size:20},slot:"icon"}),t._v(" "),e("NcCounterBubble",{attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t\t"+t._s(t._f("largeNumbers")(n.count))+"\n\t\t\t\t")]),t._v(" "),t.isPublic?t._e():e("template",{slot:"actions"},[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:function(e){return t.onDeleteTag(n.name)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteIcon",{attrs:{size:20}})]},proxy:!0}],null,!0)},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Delete"))+"\n\t\t\t\t\t")])],1)],2)})),t._v(" "),e("NcAppNavigationItem",{key:"menu-untagged",attrs:{to:{name:t.routes.UNTAGGED},name:t.t("bookmarks","Untagged")}},[e("TagOffIcon",{attrs:{slot:"icon",size:20},slot:"icon"})],1)]:t._e()]},proxy:!0},{key:"footer",fn:function(){return[Number(t.bookmarksLimit)>0?[e("NcAppNavigationItem",{key:"menu-limit",attrs:{name:t.t("bookmarks","{used} bookmarks of {available} available",{used:t.allBookmarksCount,available:t.bookmarksLimit})},scopedSlots:t._u([{key:"icon",fn:function(){return[e("GaugeIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,721576210)},[t._v(" "),e("ProgressBar",{attrs:{val:t.allBookmarksCount>=t.bookmarksLimit?100:t.allBookmarksCount/t.bookmarksLimit*100}})],1)]:t._e(),t._v(" "),e("NcAppNavigationItem",{key:"menu-trashbin",attrs:{to:{name:t.routes.TRASHBIN},name:t.t("bookmarks","Trash Bin")}},[e("TrashbinIcon",{attrs:{slot:"icon",size:20},slot:"icon"})],1),t._v(" "),e("NcAppNavigationItem",{attrs:{name:t.t("bookmarks","Bookmarks Settings")},on:{click:function(e){t.settingsOpen=!t.settingsOpen}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("CogIcon",{attrs:{size:20}})]},proxy:!0}])}),t._v(" "),e("Settings",{attrs:{"settings-open":t.settingsOpen},on:{"update:settingsOpen":function(e){t.settingsOpen=e},"update:settings-open":function(e){t.settingsOpen=e}}})]},proxy:!0}])})}),[],!1,null,null,null).exports;const R={name:"FolderOverview",components:{TreeFolder:a(90917).A,NcAppContentList:s.Qm},props:{showDetails:{type:Boolean,required:!0}},computed:{rootFolder(){return this.$store.getters.getFolder(-1)[0]}},methods:{onSelect(t){this.$router.push({name:m.YO.FOLDER,params:{folder:t}}),this.$store.state.sidebar&&"folder"===this.$store.state.sidebar.type&&this.$store.dispatch(d.o1.OPEN_FOLDER_DETAILS,t),this.$emit("update:show-details",!0)}}};var F=a(68944),P={};P.styleTagTransform=y(),P.setAttributes=N(),P.insert=_().bind(null,"head"),P.domAPI=v(),P.insertStyleElement=w();b()(F.A,P);F.A&&F.A.locals&&F.A.locals;const M=(0,x.A)(R,(function(){var t=this,e=t._self._c;return e("NcAppContentList",{attrs:{"show-details":t.showDetails},on:{"update:show-details":function(e){return t.$emit("update:show-details",e)}}},t._l(t.rootFolder.children,(function(n){return e("TreeFolder",{key:n.id,attrs:{folder:n},on:{select:function(e){return t.onSelect(e)}}})})),1)}),[],!1,null,null,null).exports;var z=a(57958),U=a(87785),H=a(76123),V=a.n(H);const G={name:"SidebarBookmark",components:{NcAppSidebar:s.Jx,NcAppSidebarTab:s.Gl,NcSelect:s.EQ,NcActions:s.B6,NcActionButton:s.Ko,NcRichContenteditable:s.Fi,FileDocumentIcon:i.PW,FolderIcon:i.sj,InformationVariantIcon:i.fM,PencilIcon:i.R2,ArrowRightIcon:i.fl,TagIcon:i.gq,OpenInNewIcon:i.PH,CloseIcon:i.US,PencilBoxIcon:i.OG,DownloadIcon:i.s3,NcButton:s.x1},data:()=>({title:"",editingTitle:!1,target:"",editingTarget:!1,activeTab:""}),computed:{isActive(){return!!this.$store.state.sidebar&&"bookmark"===this.$store.state.sidebar.type},bookmark(){if(this.isActive)return this.$store.getters.getBookmark(this.$store.state.sidebar.id)},background(){return(0,c.generateUrl)("/apps/bookmarks/bookmark/".concat(this.bookmark.id,"/image"))},addedDate(){const t=new Date(1e3*Number(this.bookmark.added)),e=Date.now()-t;if(e<6048e5){const t=V()(e,{language:OC.getLanguage().split("-")[0],units:["d","h","m","s"],largest:1,round:!0});return this.t("bookmarks","Created {time} ago",{time:t})}return this.t("bookmarks","Created on {date}",{date:t.toLocaleDateString()})},tags(){return this.bookmark.tags},allTags(){return this.$store.state.tags.map((t=>t.name))},isOwner(){const t=(0,p.HW)();return t&&this.bookmark.userId===t.uid},permissions(){return this.$store.getters.getPermissionsForBookmark(this.bookmark.id)},isEditable(){return this.isOwner||!this.isOwner&&this.permissions.canWrite},archivedFile(){return this.bookmark.archivedFile?(0,c.generateUrl)("/apps/files/?fileid=".concat(this.bookmark.archivedFile)):null},archivedFileUrl(){const t=this.bookmark.archivedFilePath.split("/").slice(3).join("/");return(0,c.generateRemoteUrl)("webdav/".concat(t))}},created(){},methods:{onClose(){this.$store.commit(d.z4.SET_SIDEBAR,null),this.editingTitle=!1,this.editingTarget=!1},onNotesChange(t){this.scheduleSave()},onTagsChange(t){this.bookmark.tags=t,this.scheduleSave()},onAddTag(t){this.bookmark.tags.push(t),this.scheduleSave()},onEditTitle(){this.title=this.bookmark.title,this.editingTitle=!0},onEditTitleUpdate(t){this.title=t},onEditTitleSubmit(){this.editingTitle=!1,this.bookmark.title=this.title,this.scheduleSave()},onEditTitleCancel(){this.editingTitle=!1,this.title=""},onEditTarget(){this.target=this.bookmark.target,this.editingTarget=!0},onEditTargetSubmit(){this.editingTarget=!1,this.bookmark.target=this.target,this.scheduleSave()},onEditTargetCancel(){this.editingTarget=!1,this.target=""},scheduleSave(){this.changeTimeout&&clearTimeout(this.changeTimeout),this.changeTimeout=setTimeout((async()=>{await this.$store.dispatch(d.o1.SAVE_BOOKMARK,this.bookmark.id),await this.$store.dispatch(d.o1.LOAD_TAGS)}),1e3)},onOpenFolder(t){this.$router.push({name:this.routes.FOLDER,params:{folder:t}}),this.onClose()},getFolder(t){return this.$store.getters.getFolder(t)[0]},getFolderPath(t){return"/"+this.$store.getters.getFolder(t).reverse().map((t=>t.title)).join("/")},openViewer(){try{OCA.Viewer.open({path:"/"+this.bookmark.archivedFilePath.split("/").slice(2).join("/")})}catch(t){this.$store.commit(d.z4.SHOW_ERROR,t.message)}}}};var Y=a(50534),W={};W.styleTagTransform=y(),W.setAttributes=N(),W.insert=_().bind(null,"head"),W.domAPI=v(),W.insertStyleElement=w();b()(Y.A,W);Y.A&&Y.A.locals&&Y.A.locals;const K=(0,x.A)(G,(function(){var t=this,e=t._self._c;return t.isActive?e("NcAppSidebar",{staticClass:"sidebar",attrs:{name:t.bookmark.title||t.t("bookmarks","(Empty title)"),"name-editable":t.editingTitle,"name-placeholder":t.t("bookmarks","Title"),subtitle:t.addedDate,background:t.background},on:{"update:active":function(e){t.activeTab=e},"update:name":t.onEditTitleUpdate,"submit-name":t.onEditTitleSubmit,"dismiss-editing":t.onEditTitleCancel,close:t.onClose}},[t.editingTitle?t._e():e("template",{slot:"secondary-actions"},[e("NcActionButton",{on:{click:t.onEditTitle},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PencilIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,4260349822)})],1),t._v(" "),t.editingTitle?e("template",{slot:"secondary-actions"},[e("NcActionButton",{on:{click:t.onEditTitleCancel},scopedSlots:t._u([{key:"icon",fn:function(){return[e("CloseIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2428343285)})],1):t._e(),t._v(" "),e("NcAppSidebarTab",{attrs:{id:"bookmark-details",name:t.t("bookmarks","Details"),order:0},scopedSlots:t._u([{key:"icon",fn:function(){return[e("InformationVariantIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3093928408)},[t._v(" "),e("div",{staticClass:"sidebar"},[t.editingTarget?e("div",{staticClass:"details__line"},[e("OpenInNewIcon",{attrs:{size:20,"aria-label":t.t("bookmarks","Link"),title:t.t("bookmarks","Link")}}),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.target,expression:"target"}],staticClass:"details__url",domProps:{value:t.target},on:{input:function(e){e.target.composing||(t.target=e.target.value)}}}),t._v(" "),e("NcActions",{staticClass:"details__action"},[e("NcActionButton",{on:{click:t.onEditTargetSubmit},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowRightIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3165524186)})],1),t._v(" "),e("NcActions",{staticClass:"details__action"},[e("NcActionButton",{on:{click:t.onEditTargetCancel},scopedSlots:t._u([{key:"icon",fn:function(){return[e("CloseIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2428343285)})],1)],1):e("div",{staticClass:"details__line"},[e("OpenInNewIcon",{attrs:{size:20,"aria-label":t.t("bookmarks","Link"),title:t.t("bookmarks","Link")}}),t._v(" "),e("a",{staticClass:"details__url",attrs:{href:t.bookmark.target===t.bookmark.url?t.bookmark.target:"javascript:void(0)"}},[t._v(t._s(t.bookmark.target))]),t._v(" "),t.isEditable?e("NcActions",{staticClass:"details__action"},[e("NcActionButton",{on:{click:t.onEditTarget},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PencilIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,4260349822)})],1):t._e()],1),t._v(" "),e("div",{staticClass:"details__line"},[e("FolderIcon",{attrs:{size:20}}),t._v(" "),e("div",{staticClass:"folders"},t._l(t.bookmark.folders,(function(n){return e("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.getFolderPath(n),expression:"getFolderPath(folderId)"}],key:n,staticClass:"folders__folder",on:{click:function(e){return t.onOpenFolder(n)}}},[e("FolderIcon",{attrs:{size:20}}),t._v(" "+t._s(t.getFolder(n).title||(t.getFolder(n).parent_folder?t.t("bookmarks","Untitled folder"):t.t("bookmarks","Root folder")))+"\n\t\t\t\t\t")],1)})),0)],1),t._v(" "),e("div",{staticClass:"details__line"},[e("TagIcon",{attrs:{size:20,"aria-label":t.t("bookmarks","Tags"),title:t.t("bookmarks","Tags")}}),t._v(" "),e("NcSelect",{staticClass:"tags",attrs:{value:t.tags,"auto-limit":!1,limit:7,options:t.allTags,multiple:!0,taggable:!0,"open-direction":"below",placeholder:t.t("bookmarks","Select tags and create new ones"),disabled:!t.isEditable},on:{input:t.onTagsChange,tag:t.onAddTag}})],1),t._v(" "),e("div",{staticClass:"details__line"},[e("PencilBoxIcon",{attrs:{size:20,role:"figure","aria-label":t.t("bookmarks","Notes"),title:t.t("bookmarks","Notes")}}),t._v(" "),e("NcRichContenteditable",{staticClass:"notes",attrs:{value:t.bookmark.description,contenteditable:t.isEditable,"auto-complete":()=>{},placeholder:t.t("bookmarks","Notes for this bookmark …"),multiline:!0},on:{"update:value":[function(e){return t.$set(t.bookmark,"description",e)},t.onNotesChange]}})],1),t._v(" "),t.archivedFile?e("div",{staticClass:"details__line"},[e("FileDocumentIcon",{attrs:{size:20,role:"figure","aria-label":t.t("bookmarks","Archived file"),title:t.t("bookmarks","Archived file")}}),t._v(" "),e("NcButton",{attrs:{href:t.archivedFileUrl,target:"_blank",type:"primary"},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DownloadIcon",{attrs:{size:18,"fill-color":t.colorMainText}})]},proxy:!0}],null,!1,793491294)},[t._v(t._s(t.t("bookmarks","Download file"))+"\n\t\t\t\t")]),t._v(" "),e("NcButton",{attrs:{href:t.archivedFile,target:"_blank"}},[t._v("\n\t\t\t\t\t"+t._s(t.t("bookmarks","Open file location"))+"\n\t\t\t\t")])],1):t._e()])])],2):t._e()}),[],!1,null,null,null).exports;var j=a(91458);const q={name:"SidebarFolder",components:{NcAppSidebar:s.Jx,NcAppSidebarTab:s.Gl,NcAvatar:s.Bx,NcSelect:s.EQ,NcActionButton:s.Ko,NcActionCheckbox:s.RI,NcActions:s.B6,NcUserBubble:s.Z9,NcActionSeparator:s.z,EyeIcon:i.bM,PencilIcon:i.R2,ShareAllIcon:i._3,ShareVariantIcon:i.wr,InformationVariantIcon:i.fM,ClipboardIcon:i.ui,RssIcon:i.wi,PlusIcon:i.c1,DeleteIcon:i.d7,LinkIcon:i.qY,AccountIcon:i.JM,CircleIcon:i.GQ},data:()=>({participantSearchResults:[],participant:null,isSearching:!1,activeTab:""}),computed:{isActive(){return!!this.$store.state.sidebar&&"folder"===this.$store.state.sidebar.type},folder(){if(!this.isActive)return;const t=this.$store.getters.getFolder(this.$store.state.sidebar.id)[0];return t.userId===(0,p.HW)()&&(this.$store.dispatch(d.o1.LOAD_SHARES_OF_FOLDER,t.id),this.$store.dispatch(d.o1.LOAD_PUBLIC_LINK,t.id)),t},isOwner(){if(!this.folder)return;const t=(0,p.HW)();return t&&this.folder.userId===t.uid},permissions(){return this.$store.getters.getPermissionsForFolder(this.folder.id)},isSharable(){if(this.folder)return this.isOwner||!this.isOwner&&this.permissions.canShare},isEditable(){if(this.folder)return this.isOwner||!this.isOwner&&this.permissions.canWrite},shares(){if(this.folder)return this.$store.getters.getSharesOfFolder(this.folder.id)},token(){if(this.folder)return this.$store.getters.getTokenOfFolder(this.folder.id)},publicLink(){if(this.token)return window.location.origin+(0,c.generateUrl)("/apps/bookmarks/public/"+this.token)},rssLink(){return window.location.origin+(0,c.generateUrl)("/apps/bookmarks/public/rest/v2/bookmark?"+new URLSearchParams({format:"rss",folder:this.folder.id,page:-1,token:this.token})).toString()},bookmarkCount(){return this.$store.state.countsByFolder[this.folder.id]}},watch:{"$store.state.sidebar.tab"(t){this.activeTab=t}},methods:{onClose(){this.$store.commit(d.z4.SET_SIDEBAR,null)},async onAddPublicLink(){await this.$store.dispatch(d.o1.CREATE_PUBLIC_LINK,this.folder.id),this.onCopyPublicLink()},onCopyPublicLink(){navigator.clipboard.writeText(this.publicLink),this.$store.commit(d.z4.SET_NOTIFICATION,t("bookmarks","Link copied"))},onCopyRssLink(){navigator.clipboard.writeText(this.rssLink),this.$store.commit(d.z4.SET_NOTIFICATION,t("bookmarks","RSS feed copied"))},async onDeletePublicLink(){await this.$store.dispatch(d.o1.DELETE_PUBLIC_LINK,this.folder.id)},async onParticipantSearch(t){if(!t)return;this.isSearching=!0;const{data:{ocs:{data:e,meta:n}}}=await j.Ay.get((0,c.generateOcsUrl)("apps/files_sharing/api/v1",1)+"/sharees?format=json&itemType=folder&search=".concat(t,"&lookup=false&perPage=200&shareType[]=0&shareType[]=1&shareType[]=7"));if("ok"!==n.status)return void(this.participantSearchResults=[]);const o=e.exact.users.concat(e.users),a=e.exact.groups.concat(e.groups),s=e.exact.circles.concat(e.circles);this.participantSearchResults=o.map((t=>({user:t.value.shareWith,displayName:t.label,icon:"icon-user",isNoUser:!1}))).concat(a.map((t=>({user:t.value.shareWith,displayName:t.label,icon:"icon-group",isNoUser:!0})))).concat(s.map((t=>({user:t.value.shareWith,displayName:t.label,icon:"icon-circle",isNoUser:!0,isCircle:!0})))),this.isSearching=!1},async onAddShare(t){await this.$store.dispatch(d.o1.CREATE_SHARE,{folderId:this.folder.id,participant:t.user,type:t.isNoUser?t.isCircle?7:1:0})},async onEditShare(t,e){let{canWrite:n,canShare:o}=e;await this.$store.dispatch(d.o1.EDIT_SHARE,{shareId:t,canWrite:n,canShare:o})},async onDeleteShare(t){await this.$store.dispatch(d.o1.DELETE_SHARE,t)}}};var J=a(34302),Q={};Q.styleTagTransform=y(),Q.setAttributes=N(),Q.insert=_().bind(null,"head"),Q.domAPI=v(),Q.insertStyleElement=w();b()(J.A,Q);J.A&&J.A.locals&&J.A.locals;const X=(0,x.A)(q,(function(){var t=this,e=t._self._c;return t.isActive?e("NcAppSidebar",{staticClass:"sidebar",attrs:{name:t.folder.title,active:t.activeTab},on:{"update:active":function(e){t.activeTab=e},close:t.onClose}},[e("NcAppSidebarTab",{attrs:{id:"folder-details",name:t.t("bookmarks","Details"),order:0},scopedSlots:t._u([{key:"icon",fn:function(){return[e("InformationVariantIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3093928408)},[t._v(" "),e("h3",[t._v(t._s(t.t("bookmarks","Owner")))]),t._v(" "),e("NcUserBubble",{attrs:{user:t.folder.userId,"display-name":t.folder.userDisplayName}}),t._v(" "),e("h3",[t._v(t._s(t.t("bookmarks","Bookmarks")))]),t._v("\n\t\t"+t._s(t.bookmarkCount)+"\n\t")],1),t._v(" "),t.isSharable?e("NcAppSidebarTab",{attrs:{id:"folder-sharing",name:t.t("bookmarks","Sharing"),order:1},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ShareVariantIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,1624511161)},[t._v(" "),e("div",{staticClass:"participant-select"},[e("AccountIcon",{class:{share__avatar:!0},attrs:{size:20}}),t._v(" "),e("NcSelect",{staticClass:"participant-select__selection",attrs:{label:"displayName","track-by":"user","user-select":!0,options:t.participantSearchResults,loading:t.isSearching,placeholder:t.t("bookmarks","Select a user or group")},on:{"option:selected":t.onAddShare,search:t.onParticipantSearch},model:{value:t.participant,callback:function(e){t.participant=e},expression:"participant"}})],1),t._v(" "),e("div",{staticClass:"share"},[e("LinkIcon",{class:{share__avatar:!0,active:t.publicLink},attrs:{size:20}}),t._v(" "),e("h3",{staticClass:"share__title"},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Share link"))+"\n\t\t\t")]),t._v(" "),e("div",{staticClass:"share__privs"},[t.publicLink?e("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","Reading allowed"),expression:"t('bookmarks', 'Reading allowed')"}],attrs:{"aria-label":t.t("bookmarks","Reading allowed")}},[e("EyeIcon",{attrs:{size:20,"fill-color":t.colorMainText}})],1):t._e()]),t._v(" "),e("NcActions",{staticClass:"share__actions"},[t.publicLink?[e("NcActionButton",{on:{click:t.onCopyPublicLink},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ClipboardIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3031907247)},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Copy link"))+"\n\t\t\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{icon:"icon-clippy"},on:{click:t.onCopyRssLink},scopedSlots:t._u([{key:"icon",fn:function(){return[e("RssIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3906975985)},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Copy RSS feed"))+"\n\t\t\t\t\t")]),t._v(" "),e("NcActionSeparator"),t._v(" "),e("NcActionButton",{on:{click:t.onDeletePublicLink},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,1311746650)},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Delete link"))+"\n\t\t\t\t\t")])]:e("NcActionButton",{on:{click:t.onAddPublicLink},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PlusIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2953566425)},[t._v("\n\t\t\t\t\t"+t._s(t.t("bookmarks","Create public link"))+"\n\t\t\t\t")])],2)],1),t._v(" "),t._l(t.shares,(function(n){return e("div",{key:n.id},[e("div",{staticClass:"share"},[n.type<2?e("NcAvatar",{staticClass:"share__avatar",attrs:{user:n.participant,size:44}}):t._e(),t._v(" "),7===n.type?e("CircleIcon",{staticClass:"share_avatar",attrs:{size:20}}):t._e(),t._v(" "),e("h3",{staticClass:"share__title"},[t._v("\n\t\t\t\t\t"+t._s(n.participantDisplayName)+"\n\t\t\t\t")]),t._v(" "),e("div",{staticClass:"share__privs"},[n.canShare?e("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","Resharing allowed"),expression:"t('bookmarks', 'Resharing allowed')"}],attrs:{"aria-label":t.t("bookmarks","Resharing allowed")}},[e("ShareAllIcon",{attrs:{size:20,"fill-color":t.colorMainText}})],1):t._e(),t._v(" "),n.canWrite?e("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","Editing allowed"),expression:"t('bookmarks','Editing allowed')"}],attrs:{"aria-label":t.t("bookmarks","Editing allowed")}},[e("PencilIcon",{attrs:{size:20,"fill-color":t.colorMainText}})],1):t._e(),t._v(" "),e("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","Reading allowed"),expression:"t('bookmarks','Reading allowed')"}],attrs:{"aria-label":t.t("bookmarks","Reading allowed")}},[e("EyeIcon",{attrs:{size:20,"fill-color":t.colorMainText}})],1)]),t._v(" "),e("NcActions",{staticClass:"share__actions"},[e("NcActionCheckbox",{attrs:{checked:n.canWrite},on:{"update:checked":function(e){return t.onEditShare(n.id,{canWrite:e,canShare:n.canShare})}}},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Allow editing"))+"\n\t\t\t\t\t")]),t._v(" "),e("NcActionCheckbox",{attrs:{checked:n.canShare},on:{"update:checked":function(e){return t.onEditShare(n.id,{canWrite:n.canWrite,canShare:e})}}},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Allow resharing"))+"\n\t\t\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{icon:"icon-delete"},on:{click:function(e){return t.onDeleteShare(n.id)}}},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Remove share"))+"\n\t\t\t\t\t")])],1)],1)])}))],2):t._e()],1):t._e()}),[],!1,null,null,null).exports;var Z=a(78229);const tt={name:"MoveDialog",components:{FolderPicker:Z.A,NcModal:s.FH},computed:{showNcModal(){return this.$store.state.displayMoveDialog},selection(){return this.$store.state.selection},title(){return this.selection.folders.length?this.selection.bookmarks.length?n("bookmarks","Moving %n folder and some bookmarks","Moving %n folders and some bookmarks",this.selection.folders.length):n("bookmarks","Moving %n folder","Moving %n folders",this.selection.folders.length):n("bookmarks","Moving %n bookmark","Moving %n bookmarks",this.selection.bookmarks.length)}},methods:{async onSubmit(t){this.$store.commit(d.z4.DISPLAY_MOVE_DIALOG,!1);try{await this.$store.dispatch(d.o1.MOVE_SELECTION,t)}finally{this.$store.commit(d.z4.RESET_SELECTION)}},onClose(){this.$store.commit(d.z4.DISPLAY_MOVE_DIALOG,!1)},filterFolders(t){return!this.selection.folders.some((e=>e.id===t.id))}}};var et=a(31392),nt={};nt.styleTagTransform=y(),nt.setAttributes=N(),nt.insert=_().bind(null,"head"),nt.domAPI=v(),nt.insertStyleElement=w();b()(et.A,nt);et.A&&et.A.locals&&et.A.locals;const ot=(0,x.A)(tt,(function(){var t=this,e=t._self._c;return t.showNcModal?e("NcModal",{attrs:{name:t.title},on:{close:t.onClose}},[e("div",{staticClass:"move-dialog"},[e("FolderPicker",{attrs:{title:t.title,filter:t.filterFolders},on:{submit:t.onSubmit}})],1)]):t._e()}),[],!1,null,null,null).exports;const at={name:"CopyDialog",components:{FolderPicker:Z.A,NcModal:s.FH},computed:{showNcModal(){return this.$store.state.displayCopyDialog},selection(){return this.$store.state.selection},title(){return n("bookmarks","Adding %n bookmark to new folder","Adding %n bookmarks to new folder",this.selection.bookmarks.length)}},methods:{async onSubmit(t){this.$store.commit(d.z4.DISPLAY_COPY_DIALOG,!1),await this.$store.dispatch(d.o1.NcNcModal,t),this.$store.commit(d.z4.RESET_SELECTION)},onClose(){this.$store.commit(d.z4.DISPLAY_COPY_DIALOG,!1)},filterFolders(t){return!this.selection.folders.some((e=>e.id===t.id))}}};var st=a(14948),it={};it.styleTagTransform=y(),it.setAttributes=N(),it.insert=_().bind(null,"head"),it.domAPI=v(),it.insertStyleElement=w();b()(st.A,it);st.A&&st.A.locals&&st.A.locals;const rt=(0,x.A)(at,(function(){var t=this,e=t._self._c;return t.showNcModal?e("NcModal",{attrs:{name:t.title},on:{close:t.onClose}},[e("div",{staticClass:"copy-dialog"},[e("FolderPicker",{attrs:{title:t.title,filter:t.filterFolders},on:{submit:t.onSubmit}})],1)]):t._e()}),[],!1,null,null,null).exports;const lt={name:"LoadingModal",components:{NcModal:s.FH},data(){return{states:{deleteBookmarks:this.t("bookmarks","Deleting bookmarks"),deleteSelection:this.t("bookmarks","Deleting selection"),importBookmarks:this.t("bookmarks","Importing bookmarks"),moveSelection:this.t("bookmkarks","Moving selection"),copySelection:this.t("bookmkarks","Adding selection to folders"),emptyTrashbin:this.t("bookmkarks","Emptying trashbin")},showNcModal:!1,showTimeout:null}},computed:{state(){return Object.keys(this.states).find((t=>this.$store.state.loading[t]))},title(){const t=this.state;return t?this.states[t]:""}},watch:{state(t,e){this.state&&!e?this.showTimeout=setTimeout((()=>{this.showNcModal=!0}),500):!this.state&&e&&(clearTimeout(this.showTimeout),this.showNcModal=!1)}}};var ct=a(60218),dt={};dt.styleTagTransform=y(),dt.setAttributes=N(),dt.insert=_().bind(null,"head"),dt.domAPI=v(),dt.insertStyleElement=w();b()(ct.A,dt);ct.A&&ct.A.locals&&ct.A.locals;const pt=(0,x.A)(lt,(function(){var t=this,e=t._self._c;return t.showNcModal?e("NcModal",{attrs:{"can-close":!1}},[e("div",{staticClass:"loading icon-loading"},[e("h3",[t._v(t._s(t.title))])])]):t._e()}),[],!1,null,"752b936f",null).exports;var ht=a(59926);const mt={rE:"15.0.5"},ut={name:"WhatsnewModal",components:{NcModal:s.FH},computed:{showModal:()=>false},methods:{onClose(){this.$store.dispatch(d.o1.SET_SETTING,{key:"hasSeenWhatsnew",value:mt.rE})}}};var kt=a(30041),At={};At.styleTagTransform=y(),At.setAttributes=N(),At.insert=_().bind(null,"head"),At.domAPI=v(),At.insertStyleElement=w();b()(kt.A,At);kt.A&&kt.A.locals&&kt.A.locals;const bt=(0,x.A)(ut,(function(){var t=this,e=t._self._c;return t.showModal?e("NcModal",{attrs:{name:t.t("bookmarks","What's new?")},on:{close:t.onClose}},[e("div",{staticClass:"whatsnew"},[e("h3",[t._v("✨ "+t._s(t.t("bookmarks","What's new?")))]),t._v(" "),e("ul",[e("li",[t._v("🔥 Visualized click count")]),t._v(" "),e("li",[t._v("🐛 Lots of small bug fixes and performance improvements")])]),t._v(" "),e("p",[t._v(" ")]),t._v(" "),e("h3",[t._v("💙 "+t._s(t.t("bookmarks","Support this project")))]),t._v(" "),e("p",[t._v(t._s(t.t("bookmarks","My work on this Bookmarks app is fuelled by a voluntary subscription model. If you think what I do is worthwhile, I would be happy if you could support my work. Also, please consider giving the app a review on the Nextcloud app store. Thank you 💙 ")))]),t._v(" "),e("p",[t._v(" ")]),t._v(" "),e("p",[e("a",{attrs:{href:"https://github.com/sponsors/marcelklehr"}},[t._v("GitHub Sponsors")]),t._v(", "),e("a",{attrs:{href:"https://www.patreon.com/marcelklehr"}},[t._v("Patreon")]),t._v(", "),e("a",{attrs:{href:"https://liberapay.com/marcelklehr/donate"}},[t._v("Liberapay")]),t._v(", "),e("a",{attrs:{href:"https://ko-fi.com/marcelklehr"}},[t._v("Ko-Fi")]),t._v(", "),e("a",{attrs:{href:"https://www.paypal.com/donate/?hosted_button_id=VESJWWBEZ9V6J"}},[t._v("PayPal")])]),t._v(" "),e("p",[e("a",{attrs:{href:"https://apps.nextcloud.com/apps/bookmarks"}},[t._v(t._s(t.t("bookmarks","Leave a rating on the Nextcloud App Store")))])])])]):t._e()}),[],!1,null,null,null).exports,gt={name:"ViewPrivate",components:{BookmarkContent:ht.A,LoadingModal:pt,Navigation:$,NcContent:s.bw,NcAppContent:s.ir,FolderOverview:M,Controls:U.A,BookmarksList:z.A,SidebarBookmark:K,SidebarFolder:X,MoveDialog:ot,CopyDialog:rt,WhatsnewModal:bt},data:()=>({newBookmark:!1,showDetails:!1,smallScreen:!1,showWhatsnew:!1,initialLoad:!1}),computed:{folders(){return this.$store.state.folders},tags(){return this.$store.state.tags},isFolderView(){return this.$route.name===m.YO.FOLDER||this.$route.name===m.YO.HOME},isSharedWithYou(){return this.$route.name===m.YO.SHARED_FOLDERS},isTrashbin(){const t=this.$store.getters.getFolder(this.$route.params.folder||"-1")[0];return this.$route.name===m.YO.TRASHBIN||this.$route.name===m.YO.FOLDER&&t.softDeleted},showFolderOverview(){return this.isFolderView&&!this.smallScreen&&this.folders.length&&!this.isTrashbin&&!this.isSharedWithYou}},watch:{$route:"onRoute",async showFolderOverview(t){!this.initialLoad&&t&&await this.$store.dispatch(d.o1.RELOAD_VIEW)}},async created(){this.initialLoad=!0;const e=window.matchMedia("(max-width: 1024px)");this.smallScreen=e.matches,e.addEventListener("change",this.onWindowFormatChange),this.$store.commit(d.z4.FETCH_START,{type:"bookmarks"}),await this.reloadSettings(),this.reloadSharedFolders(),this.reloadCount(),this.reloadTags(),await Promise.all([this.reloadFolders(),this.reloadDeletedFolders()]),this.onRoute();if((0,p.HW)().isAdmin){const e=await this.getSettingValue("privacy.enableScraping"),n=window.localStorage&&window.localStorage.getItem("bookmarks.scrapingNoteShown");"true"!==e&&"true"!==n&&(window.localStorage&&window.localStorage.setItem("bookmarks.scrapingNoteShown","true"),this.$store.commit(d.z4.SET_NOTIFICATION,t("bookmarks","Network access is disabled by default. Go to administrator settings for the bookmarks app to allow fetching previews and favicons.")))}this.initialLoad=!1},methods:{async onRoute(){const t=this.$route;switch(this.$store.commit(d.z4.RESET_SELECTION),"function"==typeof this.$store.state.loading.bookmarks&&this.$store.state.loading.bookmarks(),t.name){case m.YO.HOME:this.$store.dispatch(d.o1.FILTER_BY_FOLDER,{folder:"-1"});break;case m.YO.RECENT:this.$store.dispatch(d.o1.FILTER_BY_RECENT);break;case m.YO.UNTAGGED:this.$store.dispatch(d.o1.FILTER_BY_UNTAGGED);break;case m.YO.UNAVAILABLE:this.$store.dispatch(d.o1.FILTER_BY_UNAVAILABLE);break;case m.YO.ARCHIVED:this.$store.dispatch(d.o1.FILTER_BY_ARCHIVED);break;case m.YO.DUPLICATED:this.$store.dispatch(d.o1.FILTER_BY_DUPLICATED);break;case m.YO.TRASHBIN:this.$store.commit(d.z4.FETCH_END,"bookmarks"),await this.$store.dispatch(d.o1.LOAD_DELETED_BOOKMARKS),await this.$store.dispatch(d.o1.LOAD_DELETED_FOLDERS);break;case m.YO.SHARED_FOLDERS:this.$store.dispatch(d.o1.LOAD_SHARED_FOLDERS),await this.$store.dispatch(d.o1.RELOAD_VIEW),await this.$store.commit(d.z4.REMOVE_ALL_BOOKMARKS);break;case m.YO.BOOKMARK:await this.$store.dispatch(d.o1.LOAD_BOOKMARK,t.params.bookmark),this.$store.dispatch(d.o1.OPEN_BOOKMARK,t.params.bookmark),this.$store.commit(d.z4.FETCH_END,"bookmarks");break;case m.YO.FOLDER:const e=this.$store.getters.getFolder(t.params.folder)[0];this.$store.dispatch(d.o1.FILTER_BY_FOLDER,{folder:t.params.folder,softDeleted:e.softDeleted});break;case m.YO.TAGS:this.$store.dispatch(d.o1.FILTER_BY_TAGS,t.params.tags.split(","));break;case m.YO.SEARCH:this.$store.dispatch(d.o1.FILTER_BY_SEARCH,{search:t.params.search,folder:t.params.folder||-1});break;default:throw new Error("Nothing here. Move along.")}},async reloadTags(){return this.$store.dispatch(d.o1.LOAD_TAGS)},async reloadFolders(){return this.$store.dispatch(d.o1.LOAD_FOLDERS)},async reloadDeletedFolders(){return this.$store.dispatch(d.o1.LOAD_DELETED_FOLDERS)},async reloadSharedFolders(){return this.$store.dispatch(d.o1.LOAD_SHARED_FOLDERS)},async reloadSettings(){return this.$store.dispatch(d.o1.LOAD_SETTINGS)},async reloadCount(){return Promise.all([this.$store.dispatch(d.o1.COUNT_BOOKMARKS,-1),this.$store.dispatch(d.o1.COUNT_UNAVAILABLE),this.$store.dispatch(d.o1.COUNT_ARCHIVED),this.$store.dispatch(d.o1.COUNT_DUPLICATED),this.$store.dispatch(d.o1.COUNT_ALL_CLICKS),this.$store.dispatch(d.o1.COUNT_WITH_CLICKS)])},onSearch(t){this.$router.push({name:m.YO.SEARCH,params:{search:t}})},onResetSearch(){this.$router.push({name:m.YO.HOME})},async getSettingValue(t){const e=await new Promise(((e,n)=>OCP.AppConfig.getValue("bookmarks",t,null,{success:e,error:n})));if("ok"!==e.querySelector("status").textContent)return void console.error("Failed request",e);return e.querySelector("data").firstElementChild.textContent},onWindowFormatChange(t){this.smallScreen=t.matches}}};var vt=a(61205),ft={};ft.styleTagTransform=y(),ft.setAttributes=N(),ft.insert=_().bind(null,"head"),ft.domAPI=v(),ft.insertStyleElement=w();b()(vt.A,ft);vt.A&&vt.A.locals&&vt.A.locals;const _t=(0,x.A)(gt,(function(){var t=this,e=t._self._c;return e("NcContent",{attrs:{"app-name":"bookmarks"}},[e("Navigation"),t._v(" "),e("NcAppContent",{attrs:{"show-details":t.showDetails},on:{"update:showDetails":function(e){t.showDetails=e},"update:show-details":function(e){t.showDetails=e}},scopedSlots:t._u([t.showFolderOverview?{key:"list",fn:function(){return[e("FolderOverview",{attrs:{"show-details":t.showDetails},on:{"update:showDetails":function(e){t.showDetails=e},"update:show-details":function(e){t.showDetails=e}}})]},proxy:!0}:null,{key:"default",fn:function(){return[e("Controls"),t._v(" "),e("BookmarksList")]},proxy:!0}],null,!0)}),t._v(" "),e("SidebarBookmark"),t._v(" "),e("SidebarFolder"),t._v(" "),e("MoveDialog"),t._v(" "),e("CopyDialog"),t._v(" "),e("LoadingModal"),t._v(" "),e("BookmarkContent"),t._v(" "),e("WhatsnewModal")],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=bookmarks-src_components_ViewPrivate_vue.js.map?v=f864c53cd016a3fa1242