# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_firefoxpwa_global_optspecs
	string join \n h/help V/version
end

function __fish_firefoxpwa_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_firefoxpwa_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_firefoxpwa_using_subcommand
	set -l cmd (__fish_firefoxpwa_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c firefoxpwa -n "__fish_firefoxpwa_needs_command" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_needs_command" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_needs_command" -f -a "site" -d 'Manage web apps'
complete -c firefoxpwa -n "__fish_firefoxpwa_needs_command" -f -a "profile" -d 'Manage profiles'
complete -c firefoxpwa -n "__fish_firefoxpwa_needs_command" -f -a "runtime" -d 'Manage the runtime'
complete -c firefoxpwa -n "__fish_firefoxpwa_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and not __fish_seen_subcommand_from launch install uninstall update help" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and not __fish_seen_subcommand_from launch install uninstall update help" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and not __fish_seen_subcommand_from launch install uninstall update help" -f -a "launch" -d 'Launch a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and not __fish_seen_subcommand_from launch install uninstall update help" -f -a "install" -d 'Install a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and not __fish_seen_subcommand_from launch install uninstall update help" -f -a "uninstall" -d 'Uninstall a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and not __fish_seen_subcommand_from launch install uninstall update help" -f -a "update" -d 'Update a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and not __fish_seen_subcommand_from launch install uninstall update help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from launch" -l url -d 'Launch web app on a custom start URL' -r -f
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from launch" -l protocol -d 'Launch web app on a protocol handler URL' -r -f
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from launch" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from launch" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l document-url -d 'Direct URL of the site\'s main document {n}Defaults to the result of parsing a manifest URL with `.`' -r -f
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l profile -d 'Profile where this web app will be installed {n}Defaults to the shared profile' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l start-url -d 'Set a custom web app start URL' -r -f
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l icon-url -d 'Set a custom web app icon URL' -r -f
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l name -d 'Set a custom web app name' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l description -d 'Set a custom web app description' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l categories -d 'Set custom web app categories' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l keywords -d 'Set custom web app keywords' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l launch-on-login -d 'Set the web app to launch on the system login' -r -f -a "true\t''
false\t''"
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l launch-on-browser -d 'Set the web app to launch on the browser launch' -r -f -a "true\t''
false\t''"
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l tls-root-certificates-der -d 'Import additional root certificates from a DER file' -r -F
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l tls-root-certificates-pem -d 'Import additional root certificates from a PEM file' -r -F
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l launch-now -d 'Launch this web app when the installation finishes'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l no-system-integration -d 'Disable system integration'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l tls-danger-accept-invalid-certs -d 'Dangerous: Allow client to accept invalid certs'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -l tls-danger-accept-invalid-hostnames -d 'Dangerous: Allow client to accept invalid hostnames'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from install" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from uninstall" -s q -l quiet -d 'Disable any interactive prompts'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from uninstall" -l no-system-integration -d 'Disable system integration'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from uninstall" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from uninstall" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l start-url -d 'Set a custom web app start URL' -r -f
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l icon-url -d 'Set a custom web app icon URL' -r -f
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l name -d 'Set a custom web app name' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l description -d 'Set a custom web app description' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l categories -d 'Set custom web app categories' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l keywords -d 'Set custom web app keywords' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l enabled-url-handlers -d 'Set enabled URL handlers' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l enabled-protocol-handlers -d 'Set enabled protocol handlers' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l launch-on-login -d 'Set the web app to launch on the system login' -r -f -a "true\t''
false\t''"
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l launch-on-browser -d 'Set the web app to launch on the browser launch' -r -f -a "true\t''
false\t''"
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l tls-root-certificates-der -d 'Import additional root certificates from a DER file' -r -F
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l tls-root-certificates-pem -d 'Import additional root certificates from a PEM file' -r -F
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l no-manifest-updates -d 'Disable manifest updates'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l no-icon-updates -d 'Disable icon updates'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l no-system-integration -d 'Disable system integration'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l tls-danger-accept-invalid-certs -d 'Dangerous: Allow client to accept invalid certs'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -l tls-danger-accept-invalid-hostnames -d 'Dangerous: Allow client to accept invalid hostnames'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from update" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from help" -f -a "launch" -d 'Launch a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from help" -f -a "install" -d 'Install a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from help" -f -a "uninstall" -d 'Uninstall a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from help" -f -a "update" -d 'Update a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand site; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and not __fish_seen_subcommand_from list create remove update help" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and not __fish_seen_subcommand_from list create remove update help" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and not __fish_seen_subcommand_from list create remove update help" -f -a "list" -d 'List available profiles and their web apps'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and not __fish_seen_subcommand_from list create remove update help" -f -a "create" -d 'Create a new profile'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and not __fish_seen_subcommand_from list create remove update help" -f -a "remove" -d 'Remove an existing profile'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and not __fish_seen_subcommand_from list create remove update help" -f -a "update" -d 'Update an existing profile'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and not __fish_seen_subcommand_from list create remove update help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from list" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from create" -l name -d 'Set a profile name' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from create" -l description -d 'Set a profile description' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from create" -l template -d 'Set a profile template {n}All contents of the template directory will be copied to a newly-created profile' -r -f -a "(__fish_complete_directories)"
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from create" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from remove" -s q -l quiet -d 'Disable any interactive prompts'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from remove" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from update" -l name -d 'Set a profile name' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from update" -l description -d 'Set a profile description' -r
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from update" -l template -d 'Set a profile template {n}All contents of the template directory will be copied to the currently-updated profile' -r -f -a "(__fish_complete_directories)"
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from update" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from update" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "list" -d 'List available profiles and their web apps'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "create" -d 'Create a new profile'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove an existing profile'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "update" -d 'Update an existing profile'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and not __fish_seen_subcommand_from install uninstall patch help" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and not __fish_seen_subcommand_from install uninstall patch help" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and not __fish_seen_subcommand_from install uninstall patch help" -f -a "install" -d 'Install the runtime'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and not __fish_seen_subcommand_from install uninstall patch help" -f -a "uninstall" -d 'Uninstall the runtime'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and not __fish_seen_subcommand_from install uninstall patch help" -f -a "patch" -d 'Patch the runtime'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and not __fish_seen_subcommand_from install uninstall patch help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and __fish_seen_subcommand_from install" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and __fish_seen_subcommand_from install" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and __fish_seen_subcommand_from uninstall" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and __fish_seen_subcommand_from uninstall" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and __fish_seen_subcommand_from patch" -s h -l help -d 'Print help'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and __fish_seen_subcommand_from patch" -s V -l version -d 'Print version'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and __fish_seen_subcommand_from help" -f -a "install" -d 'Install the runtime'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and __fish_seen_subcommand_from help" -f -a "uninstall" -d 'Uninstall the runtime'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and __fish_seen_subcommand_from help" -f -a "patch" -d 'Patch the runtime'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand runtime; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and not __fish_seen_subcommand_from site profile runtime help" -f -a "site" -d 'Manage web apps'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and not __fish_seen_subcommand_from site profile runtime help" -f -a "profile" -d 'Manage profiles'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and not __fish_seen_subcommand_from site profile runtime help" -f -a "runtime" -d 'Manage the runtime'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and not __fish_seen_subcommand_from site profile runtime help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from site" -f -a "launch" -d 'Launch a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from site" -f -a "install" -d 'Install a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from site" -f -a "uninstall" -d 'Uninstall a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from site" -f -a "update" -d 'Update a web app'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from profile" -f -a "list" -d 'List available profiles and their web apps'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from profile" -f -a "create" -d 'Create a new profile'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from profile" -f -a "remove" -d 'Remove an existing profile'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from profile" -f -a "update" -d 'Update an existing profile'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from runtime" -f -a "install" -d 'Install the runtime'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from runtime" -f -a "uninstall" -d 'Uninstall the runtime'
complete -c firefoxpwa -n "__fish_firefoxpwa_using_subcommand help; and __fish_seen_subcommand_from runtime" -f -a "patch" -d 'Patch the runtime'
