/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import javax.management.openmbean.CompositeData;
import sun.management.LockInfoCompositeData;

public class LockInfo {
    private String className;
    private int identityHashCode;

    public LockInfo(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Parameter className cannot be null");
        }
        this.className = string;
        this.identityHashCode = n;
    }

    LockInfo(Object object) {
        this.className = object.getClass().getName();
        this.identityHashCode = System.identityHashCode(object);
    }

    public String getClassName() {
        return this.className;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public static LockInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        if (compositeData instanceof LockInfoCompositeData) {
            return ((LockInfoCompositeData)compositeData).getLockInfo();
        }
        return LockInfoCompositeData.toLockInfo(compositeData);
    }

    public String toString() {
        return this.className + '@' + Integer.toHexString(this.identityHashCode);
    }
}

