"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerObservabilityUISettings = void 0;
var _configSchema = require("@osd/config-schema");
var _trace_analytics = require("../../common/constants/trace_analytics");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const registerObservabilityUISettings = uiSettings => {
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_SPAN_INDEX_SETTING]: {
      name: 'Trace analytics custom span indices',
      value: '',
      category: ['Observability'],
      description: '<strong>Experimental feature:</strong> Configure custom span indices that adhere to data prepper schema, to be used by the trace analytics plugin',
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_SERVICE_INDEX_SETTING]: {
      name: 'Trace analytics custom service indices',
      value: '',
      category: ['Observability'],
      description: '<strong>Experimental feature:</strong> Configure custom service indices that adhere to data prepper schema, to be used by the trace analytics plugin',
      schema: _configSchema.schema.string()
    }
  });
};
exports.registerObservabilityUISettings = registerObservabilityUISettings;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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