/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.MethodHandle;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.core.VerifyArgument;
import java.util.List;

public final class DynamicCallSite {
    private final int _bootstrapMethodIndex;
    private final MethodHandle _bootstrapMethodHandle;
    private final List<Object> _bootstrapArguments;
    private final String _methodName;
    private final IMethodSignature _methodType;

    public DynamicCallSite(int bootstrapMethodIndex, MethodHandle method, List<Object> bootstrapArguments, String methodName, IMethodSignature methodType) {
        this._bootstrapMethodIndex = bootstrapMethodIndex;
        this._bootstrapMethodHandle = VerifyArgument.notNull(method, "method");
        this._bootstrapArguments = VerifyArgument.notNull(bootstrapArguments, "bootstrapArguments");
        this._methodName = VerifyArgument.notNull(methodName, "methodName");
        this._methodType = VerifyArgument.notNull(methodType, "methodType");
    }

    public final int getBootstrapMethodIndex() {
        return this._bootstrapMethodIndex;
    }

    public final String getMethodName() {
        return this._methodName;
    }

    public final IMethodSignature getMethodType() {
        return this._methodType;
    }

    public final List<Object> getBootstrapArguments() {
        return this._bootstrapArguments;
    }

    public final MethodHandle getBootstrapMethodHandle() {
        return this._bootstrapMethodHandle;
    }

    public final MethodReference getBootstrapMethod() {
        return this._bootstrapMethodHandle.getMethod();
    }
}

