/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler;

import com.strobel.decompiler.LineNumberPrintWriter;
import com.strobel.decompiler.languages.LineNumberPosition;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class LineNumberFormatter {
    private final List<LineNumberPosition> _positions;
    private final File _file;
    private final EnumSet<LineNumberOption> _options;

    public LineNumberFormatter(File file, List<LineNumberPosition> lineNumberPositions, EnumSet<LineNumberOption> options) {
        this._file = file;
        this._positions = lineNumberPositions;
        this._options = options == null ? EnumSet.noneOf(LineNumberOption.class) : options;
    }

    public void reformatFile() throws IOException {
        ArrayList<LineNumberPosition> lineBrokenPositions = new ArrayList<LineNumberPosition>();
        List<String> brokenLines = this.breakLines(lineBrokenPositions);
        this.emitFormatted(brokenLines, lineBrokenPositions);
    }

    private List<String> breakLines(List<LineNumberPosition> o_LineBrokenPositions) throws IOException {
        int numLinesRead = 0;
        int lineOffset = 0;
        ArrayList<String> brokenLines = new ArrayList<String>();
        try (BufferedReader r = new BufferedReader(new FileReader(this._file));){
            String line;
            for (int posIndex = 0; posIndex < this._positions.size(); ++posIndex) {
                LineNumberPosition nextPos;
                LineNumberPosition pos = this._positions.get(posIndex);
                o_LineBrokenPositions.add(new LineNumberPosition(pos.getOriginalLine(), pos.getEmittedLine() + lineOffset, pos.getEmittedColumn()));
                while (numLinesRead < pos.getEmittedLine() - 1) {
                    brokenLines.add(r.readLine());
                    ++numLinesRead;
                }
                String line2 = r.readLine();
                ++numLinesRead;
                int prevPartLen = 0;
                char[] indent = new char[]{};
                do {
                    LineNumberPosition lineNumberPosition = nextPos = posIndex < this._positions.size() - 1 ? this._positions.get(posIndex + 1) : null;
                    if (nextPos != null && nextPos.getEmittedLine() == pos.getEmittedLine() && nextPos.getOriginalLine() > pos.getOriginalLine()) {
                        ++posIndex;
                        ++lineOffset;
                        String firstPart = line2.substring(0, nextPos.getEmittedColumn() - prevPartLen - 1);
                        brokenLines.add(new String(indent) + firstPart);
                        indent = new char[prevPartLen += firstPart.length()];
                        Arrays.fill(indent, ' ');
                        line2 = line2.substring(firstPart.length(), line2.length());
                        o_LineBrokenPositions.add(new LineNumberPosition(nextPos.getOriginalLine(), nextPos.getEmittedLine() + lineOffset, nextPos.getEmittedColumn()));
                        continue;
                    }
                    nextPos = null;
                } while (nextPos != null);
                brokenLines.add(new String(indent) + line2);
            }
            while ((line = r.readLine()) != null) {
                brokenLines.add(line);
            }
        }
        return brokenLines;
    }

    private void emitFormatted(List<String> brokenLines, List<LineNumberPosition> lineBrokenPositions) throws IOException {
        File tempFile = new File(this._file.getAbsolutePath() + ".fixed");
        int globalOffset = 0;
        int numLinesRead = 0;
        Iterator<String> lines = brokenLines.iterator();
        int maxLineNo = LineNumberPosition.computeMaxLineNumber(lineBrokenPositions);
        try (LineNumberPrintWriter w = new LineNumberPrintWriter(maxLineNo, new BufferedWriter(new FileWriter(tempFile)));){
            if (!this._options.contains((Object)LineNumberOption.LEADING_COMMENTS)) {
                w.suppressLineNumbers();
            }
            boolean doStretching = this._options.contains((Object)LineNumberOption.STRETCHED);
            for (LineNumberPosition pos : lineBrokenPositions) {
                int nextTarget = pos.getOriginalLine();
                int nextActual = pos.getEmittedLine();
                int requiredAdjustment = nextTarget - nextActual - globalOffset;
                if (doStretching && requiredAdjustment < 0) {
                    ArrayList<String> stripped = new ArrayList<String>();
                    while (numLinesRead < nextActual - 1) {
                        String line = lines.next();
                        ++numLinesRead;
                        if (requiredAdjustment < 0 && line.trim().isEmpty()) {
                            ++requiredAdjustment;
                            --globalOffset;
                            continue;
                        }
                        stripped.add(line);
                    }
                    int lineNoToPrint = stripped.size() + requiredAdjustment <= 0 ? nextTarget : -1;
                    for (String line : stripped) {
                        if (requiredAdjustment < 0) {
                            w.print(lineNoToPrint, line);
                            w.print("  ");
                            ++requiredAdjustment;
                            --globalOffset;
                            continue;
                        }
                        w.println(lineNoToPrint, line);
                    }
                    String line = lines.next();
                    ++numLinesRead;
                    if (requiredAdjustment < 0) {
                        w.print(nextTarget, line);
                        w.print("  ");
                        --globalOffset;
                        continue;
                    }
                    w.println(nextTarget, line);
                    continue;
                }
                while (numLinesRead < nextActual) {
                    int lineNoToPrint;
                    String line = lines.next();
                    boolean isLast = ++numLinesRead >= nextActual;
                    int n = lineNoToPrint = isLast ? nextTarget : -1;
                    if (requiredAdjustment > 0 && doStretching) {
                        do {
                            w.println("");
                            ++globalOffset;
                        } while (isLast && --requiredAdjustment > 0);
                        w.println(lineNoToPrint, line);
                        continue;
                    }
                    w.println(lineNoToPrint, line);
                }
            }
            while (lines.hasNext()) {
                String line = lines.next();
                w.println(line);
            }
        }
        this._file.delete();
        tempFile.renameTo(this._file);
    }

    public static enum LineNumberOption {
        LEADING_COMMENTS,
        STRETCHED;

    }
}

