'''OpenGL extension NV.shader_noperspective_interpolation

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.shader_noperspective_interpolation to provide a more 
Python-friendly API

Overview (from the spec)
	
	In OpenGL 3.0 and later, and in other APIs, there are three types of
	interpolation qualifiers that are available for fragment shader inputs:
	flat, smooth, and noperspective.  The 'flat' qualifier indicates that no
	interpolation should be used. This is mandatory for integer-type
	variables. The 'smooth' qualifier indicates that interpolation should be
	performed in a perspective0correct manner. This is the default for
	floating-point type variables.  The 'noperspective' qualifier indicates
	that interpolation should be performed linearly in screen space.
	
	While perspective-correct (smooth) and non-interpolated (flat) are the
	two types of interpolation that most commonly used, there are important
	use cases for linear (noperspective) interpolation.  In particular, in
	some work loads where screen-space aligned geometry is common, the use of
	linear interpolation can result in performance and/or power improvements.
	
	The smooth and flat interpolation qualifiers are already supported in
	OpenGL ES 3.0 and later. This extension adds support for noperspective
	interpolation to OpenGL ES.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/shader_noperspective_interpolation.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.shader_noperspective_interpolation import *
from OpenGL.raw.GLES2.NV.shader_noperspective_interpolation import _EXTENSION_NAME

def glInitShaderNoperspectiveInterpolationNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION