# This file has been autogenerated by the pywayland scanner

# Copyright © 2022 Andri Yngvason
# Copyright © 2024 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..ext_foreign_toplevel_list_v1 import ExtForeignToplevelHandleV1
from .ext_image_capture_source_v1 import ExtImageCaptureSourceV1


class ExtForeignToplevelImageCaptureSourceManagerV1(Interface):
    """Image capture source manager for foreign toplevels

    A manager for creating image capture source objects for
    :class:`~pywayland.protocol.ext_foreign_toplevel_list_v1.ExtForeignToplevelHandleV1`
    objects.
    """

    name = "ext_foreign_toplevel_image_capture_source_manager_v1"
    version = 1


class ExtForeignToplevelImageCaptureSourceManagerV1Proxy(Proxy[ExtForeignToplevelImageCaptureSourceManagerV1]):
    interface = ExtForeignToplevelImageCaptureSourceManagerV1

    @ExtForeignToplevelImageCaptureSourceManagerV1.request(
        Argument(ArgumentType.NewId, interface=ExtImageCaptureSourceV1),
        Argument(ArgumentType.Object, interface=ExtForeignToplevelHandleV1),
    )
    def create_source(self, toplevel_handle: ExtForeignToplevelHandleV1) -> Proxy[ExtImageCaptureSourceV1]:
        """Create source object for foreign toplevel

        Creates a source object for a foreign toplevel handle. Images captured
        from this source will show the same content as the toplevel.

        :param toplevel_handle:
        :type toplevel_handle:
            :class:`~pywayland.protocol.ext_foreign_toplevel_list_v1.ExtForeignToplevelHandleV1`
        :returns:
            :class:`~pywayland.protocol.ext_image_capture_source_v1.ExtImageCaptureSourceV1`
        """
        source = self._marshal_constructor(0, ExtImageCaptureSourceV1, toplevel_handle)
        return source

    @ExtForeignToplevelImageCaptureSourceManagerV1.request()
    def destroy(self) -> None:
        """Delete this object

        Destroys the manager. This request may be sent at any time by the
        client and objects created by the manager will remain valid after its
        destruction.
        """
        self._marshal(1)
        self._destroy()


class ExtForeignToplevelImageCaptureSourceManagerV1Resource(Resource):
    interface = ExtForeignToplevelImageCaptureSourceManagerV1


class ExtForeignToplevelImageCaptureSourceManagerV1Global(Global):
    interface = ExtForeignToplevelImageCaptureSourceManagerV1


ExtForeignToplevelImageCaptureSourceManagerV1._gen_c()
ExtForeignToplevelImageCaptureSourceManagerV1.proxy_class = ExtForeignToplevelImageCaptureSourceManagerV1Proxy
ExtForeignToplevelImageCaptureSourceManagerV1.resource_class = ExtForeignToplevelImageCaptureSourceManagerV1Resource
ExtForeignToplevelImageCaptureSourceManagerV1.global_class = ExtForeignToplevelImageCaptureSourceManagerV1Global
