/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LockedFloor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.ChaliceOfBlood;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfEnergy;
import com.shatteredpixel.shatteredpixeldungeon.items.trinkets.ChaoticCenser;
import com.shatteredpixel.shatteredpixeldungeon.items.trinkets.SaltCube;

public class Regeneration
extends Buff {
    private static final float REGENERATION_DELAY = 10.0f;

    public Regeneration() {
        this.actPriority = -1;
    }

    @Override
    public boolean act() {
        if (this.target.isAlive()) {
            if (ChaoticCenser.averageTurnsUntilGas() != -1) {
                Buff.affect(Dungeon.hero, ChaoticCenser.CenserGasTracker.class);
            }
            if (SaltCube.healthRegenMultiplier() == 0.0f) {
                this.spend(10.0f);
                return true;
            }
            if (this.target.HP < this.regencap() && !((Hero)this.target).isStarving() && Regeneration.regenOn()) {
                ++this.target.HP;
                if (this.target.HP == this.regencap()) {
                    ((Hero)this.target).resting = false;
                }
            }
            ChaliceOfBlood.chaliceRegen regenBuff = Dungeon.hero.buff(ChaliceOfBlood.chaliceRegen.class);
            float delay = 10.0f;
            if (regenBuff != null && this.target.buff(MagicImmune.class) == null) {
                if (regenBuff.isCursed()) {
                    delay *= 1.5f;
                } else {
                    delay -= 1.33f + (float)regenBuff.itemLevel() * 0.667f;
                    delay /= RingOfEnergy.artifactChargeMultiplier(this.target);
                }
            }
            this.spend(delay /= SaltCube.healthRegenMultiplier());
        } else {
            this.diactivate();
        }
        return true;
    }

    public int regencap() {
        return this.target.HT;
    }

    public static boolean regenOn() {
        LockedFloor lock = Dungeon.hero.buff(LockedFloor.class);
        return lock == null || lock.regenOn();
    }
}

