/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.apache.catalina.Engine;
import org.apache.catalina.Executor;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.mapper.Mapper;
import org.apache.catalina.mapper.MapperListener;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StandardService
extends LifecycleMBeanBase
implements Service {
    private static final Log log = LogFactory.getLog(StandardService.class);
    private static final StringManager sm = StringManager.getManager(StandardService.class);
    private String name = null;
    private Server server = null;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    private final Object connectorsLock = new Object();
    protected final ArrayList<Executor> executors = new ArrayList();
    private Engine engine = null;
    private ClassLoader parentClassLoader = null;
    protected final Mapper mapper = new Mapper();
    protected final MapperListener mapperListener = new MapperListener(this);
    private long gracefulStopAwaitMillis = 0L;

    public long getGracefulStopAwaitMillis() {
        return this.gracefulStopAwaitMillis;
    }

    public void setGracefulStopAwaitMillis(long l) {
        this.gracefulStopAwaitMillis = l;
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public Engine getContainer() {
        return this.engine;
    }

    @Override
    public void setContainer(Engine engine) {
        Engine engine2 = this.engine;
        if (engine2 != null) {
            engine2.setService(null);
        }
        this.engine = engine;
        if (this.engine != null) {
            this.engine.setService(this);
        }
        if (this.getState().isAvailable()) {
            if (this.engine != null) {
                try {
                    this.engine.start();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardService.engine.startFailed"), (Throwable)lifecycleException);
                }
            }
            try {
                this.mapperListener.stop();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardService.mapperListener.stopFailed"), (Throwable)lifecycleException);
            }
            try {
                this.mapperListener.start();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardService.mapperListener.startFailed"), (Throwable)lifecycleException);
            }
            if (engine2 != null) {
                try {
                    engine2.stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardService.engine.stopFailed"), (Throwable)lifecycleException);
                }
            }
        }
        this.support.firePropertyChange("container", engine2, this.engine);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnector(Connector connector) {
        Object object = this.connectorsLock;
        synchronized (object) {
            connector.setService(this);
            Connector[] connectorArray = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, connectorArray, 0, this.connectors.length);
            connectorArray[this.connectors.length] = connector;
            this.connectors = connectorArray;
            if (this.getState().isAvailable()) {
                try {
                    connector.start();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardService.connector.startFailed", new Object[]{connector}), (Throwable)lifecycleException);
                }
            }
            this.support.firePropertyChange("connector", null, connector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getConnectorNames() {
        Object object = this.connectorsLock;
        synchronized (object) {
            ObjectName[] objectNameArray = new ObjectName[this.connectors.length];
            for (int i = 0; i < objectNameArray.length; ++i) {
                objectNameArray[i] = this.connectors[i].getObjectName();
            }
            return objectNameArray;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connector[] findConnectors() {
        Object object = this.connectorsLock;
        synchronized (object) {
            return (Connector[])this.connectors.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnector(Connector connector) {
        Object object = this.connectorsLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.connectors.length; ++n) {
                if (connector != this.connectors[n]) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            if (this.connectors[n2].getState().isAvailable()) {
                try {
                    this.connectors[n2].stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardService.connector.stopFailed", new Object[]{this.connectors[n2]}), (Throwable)lifecycleException);
                }
            }
            connector.setService(null);
            n = 0;
            Connector[] connectorArray = new Connector[this.connectors.length - 1];
            for (int i = 0; i < this.connectors.length; ++i) {
                if (i == n2) continue;
                connectorArray[n++] = this.connectors[i];
            }
            this.connectors = connectorArray;
            this.support.firePropertyChange("connector", connector, null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("StandardService[");
        stringBuilder.append(this.getName());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutor(Executor executor) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (!this.executors.contains(executor)) {
                this.executors.add(executor);
                if (this.getState().isAvailable()) {
                    try {
                        executor.start();
                    }
                    catch (LifecycleException lifecycleException) {
                        log.error((Object)sm.getString("standardService.executor.start"), (Throwable)lifecycleException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor[] findExecutors() {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            return this.executors.toArray(new Executor[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getExecutor(String string) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            for (Executor executor : this.executors) {
                if (!string.equals(executor.getName())) continue;
                return executor;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutor(Executor executor) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (this.executors.remove(executor) && this.getState().isAvailable()) {
                try {
                    executor.stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardService.executor.stop"), (Throwable)lifecycleException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        Object object;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.start.name", new Object[]{this.name}));
        }
        this.setState(LifecycleState.STARTING);
        if (this.engine != null) {
            object = this.engine;
            synchronized (object) {
                this.engine.start();
            }
        }
        object = this.executors;
        synchronized (object) {
            for (Executor executor : this.executors) {
                executor.start();
            }
        }
        this.mapperListener.start();
        object = this.connectorsLock;
        synchronized (object) {
            for (Connector connector : this.connectors) {
                try {
                    if (connector.getState() == LifecycleState.FAILED) continue;
                    connector.start();
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("standardService.connector.startFailed", new Object[]{connector}), (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopInternal() throws LifecycleException {
        ArrayList<Executor> arrayList = this.connectorsLock;
        synchronized (arrayList) {
            for (Connector connector : this.connectors) {
                connector.getProtocolHandler().closeServerSocketGraceful();
            }
            long l = this.gracefulStopAwaitMillis;
            if (l > 0L) {
                Connector[] connectorArray = this.connectors;
                int n = connectorArray.length;
                for (int i = 0; i < n; ++i) {
                    Connector connector = connectorArray[i];
                    l = connector.getProtocolHandler().awaitConnectionsClose(l);
                }
            }
            for (Connector connector : this.connectors) {
                connector.pause();
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.stop.name", new Object[]{this.name}));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.engine != null) {
            arrayList = this.engine;
            synchronized (arrayList) {
                this.engine.stop();
            }
        }
        arrayList = this.connectorsLock;
        synchronized (arrayList) {
            for (Connector connector : this.connectors) {
                if (!LifecycleState.STARTED.equals((Object)connector.getState())) continue;
                try {
                    connector.stop();
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("standardService.connector.stopFailed", new Object[]{connector}), (Throwable)exception);
                }
            }
        }
        if (this.mapperListener.getState() != LifecycleState.INITIALIZED) {
            this.mapperListener.stop();
        }
        arrayList = this.executors;
        synchronized (arrayList) {
            for (Executor executor : this.executors) {
                executor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.engine != null) {
            this.engine.init();
        }
        for (Executor executor : this.findExecutors()) {
            if (executor instanceof JmxEnabled) {
                ((JmxEnabled)((Object)executor)).setDomain(this.getDomain());
            }
            executor.init();
        }
        this.mapperListener.init();
        Object object = this.connectorsLock;
        synchronized (object) {
            for (Connector connector : this.connectors) {
                try {
                    connector.init();
                }
                catch (Exception exception) {
                    String string = sm.getString("standardService.connector.initFailed", new Object[]{connector});
                    log.error((Object)string, (Throwable)exception);
                    if (!Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE")) continue;
                    throw new LifecycleException(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyInternal() throws LifecycleException {
        this.mapperListener.destroy();
        Executor[] executorArray = this.connectorsLock;
        synchronized (this.connectorsLock) {
            Connector[] connectorArray = this.connectors;
            int n = connectorArray.length;
            for (int i = 0; i < n; ++i) {
                Connector connector = connectorArray[i];
                try {
                    connector.destroy();
                    continue;
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("standardService.connector.destroyFailed", new Object[]{connector}), (Throwable)exception);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (Executor executor : this.findExecutors()) {
                executor.destroy();
            }
            if (this.engine != null) {
                this.engine.destroy();
            }
            super.destroyInternal();
            return;
        }
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.server != null) {
            return this.server.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = this.parentClassLoader;
        this.parentClassLoader = classLoader;
        this.support.firePropertyChange("parentClassLoader", classLoader2, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        String string = null;
        Engine engine = this.getContainer();
        if (engine != null) {
            string = engine.getName();
        }
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    @Override
    public final String getObjectNameKeyProperties() {
        return "type=Service";
    }
}

