/*
 * Decompiled with CFR 0.152.
 */
package com.concurrent_ruby.ext;

import java.io.IOException;
import java.lang.reflect.Field;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import sun.misc.Unsafe;

public class AtomicReferenceLibrary
implements Library {
    private static final ObjectAllocator JRUBYREFERENCE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JRubyReference(ruby, rubyClass);
        }
    };
    private static final ObjectAllocator JRUBYREFERENCE8_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JRubyReference8(ruby, rubyClass);
        }
    };

    public void load(Ruby ruby, boolean bl) throws IOException {
        RubyModule rubyModule = ruby.defineModule("Concurrent");
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaAtomicReference", ruby.getObject(), JRUBYREFERENCE_ALLOCATOR);
        try {
            Unsafe.class.getMethod("getAndSetObject", Object.class);
            rubyClass.setAllocator(JRUBYREFERENCE8_ALLOCATOR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        rubyClass.defineAnnotatedMethods(JRubyReference.class);
    }

    @JRubyClass(name={"JRubyReference"}, parent="Object")
    public static class JRubyReference
    extends RubyObject {
        volatile IRubyObject reference;
        static final Unsafe UNSAFE;
        static final long referenceOffset;

        public JRubyReference(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext) {
            UNSAFE.putObject((Object)this, referenceOffset, threadContext.nil);
            return threadContext.nil;
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
            UNSAFE.putObject((Object)this, referenceOffset, iRubyObject);
            return threadContext.nil;
        }

        @JRubyMethod(name={"get", "value"})
        public IRubyObject get() {
            return this.reference;
        }

        @JRubyMethod(name={"set", "value="})
        public IRubyObject set(IRubyObject iRubyObject) {
            UNSAFE.putObjectVolatile((Object)this, referenceOffset, iRubyObject);
            return iRubyObject;
        }

        @JRubyMethod(name={"compare_and_set", "compare_and_swap"})
        public IRubyObject compare_and_set(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Ruby ruby = threadContext.runtime;
            if (iRubyObject instanceof RubyNumeric) {
                return this.compareAndSetNumeric(threadContext, iRubyObject, iRubyObject2);
            }
            return ruby.newBoolean(UNSAFE.compareAndSwapObject((Object)this, referenceOffset, iRubyObject, iRubyObject2));
        }

        @JRubyMethod(name={"get_and_set", "swap"})
        public IRubyObject get_and_set(ThreadContext threadContext, IRubyObject iRubyObject) {
            IRubyObject iRubyObject2;
            while (!UNSAFE.compareAndSwapObject((Object)this, referenceOffset, iRubyObject2 = this.get(), iRubyObject)) {
            }
            return iRubyObject2;
        }

        private IRubyObject compareAndSetNumeric(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            IRubyObject iRubyObject3;
            boolean bl;
            Ruby ruby = threadContext.runtime;
            do {
                if (!((iRubyObject3 = this.reference) instanceof RubyNumeric)) {
                    return ruby.getFalse();
                }
                RubyNumeric rubyNumeric = (RubyNumeric)iRubyObject3;
                if (rubyNumeric.equals((Object)iRubyObject)) continue;
                return ruby.getFalse();
            } while (!(bl = UNSAFE.compareAndSwapObject((Object)this, referenceOffset, iRubyObject3, iRubyObject2)));
            return ruby.getTrue();
        }

        static {
            try {
                UNSAFE = UnsafeHolder.U;
                Class<JRubyReference> clazz = JRubyReference.class;
                referenceOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("reference"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static class JRubyReference8
    extends JRubyReference {
        public JRubyReference8(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @Override
        public IRubyObject get_and_set(ThreadContext threadContext, IRubyObject iRubyObject) {
            return (IRubyObject)UNSAFE.getAndSetObject((Object)this, referenceOffset, iRubyObject);
        }
    }

    private static final class UnsafeHolder {
        public static final Unsafe U = UnsafeHolder.loadUnsafe();

        private UnsafeHolder() {
        }

        private static Unsafe loadUnsafe() {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Field field = clazz.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

