/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import jakarta.servlet.HttpConstraintElement;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.ServletSecurity;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.descriptor.web.Constants;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.XmlEncodingBase;
import org.apache.tomcat.util.res.StringManager;

public class SecurityConstraint
extends XmlEncodingBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ROLE_ALL_ROLES = "*";
    public static final String ROLE_ALL_AUTHENTICATED_USERS = "**";
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private boolean allRoles = false;
    private boolean authenticatedUsers = false;
    private boolean authConstraint = false;
    private String[] authRoles = new String[0];
    private SecurityCollection[] collections = new SecurityCollection[0];
    private String displayName = null;
    private String userConstraint = "NONE";

    public boolean getAllRoles() {
        return this.allRoles;
    }

    public boolean getAuthenticatedUsers() {
        return this.authenticatedUsers;
    }

    public boolean getAuthConstraint() {
        return this.authConstraint;
    }

    public void setAuthConstraint(boolean bl) {
        this.authConstraint = bl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getUserConstraint() {
        return this.userConstraint;
    }

    public void setUserConstraint(String string) {
        if (string != null) {
            this.userConstraint = string;
        }
    }

    public void treatAllAuthenticatedUsersAsApplicationRole() {
        if (this.authenticatedUsers) {
            this.authenticatedUsers = false;
            String[] stringArray = Arrays.copyOf(this.authRoles, this.authRoles.length + 1);
            stringArray[this.authRoles.length] = ROLE_ALL_AUTHENTICATED_USERS;
            this.authRoles = stringArray;
            this.authConstraint = true;
        }
    }

    public void addAuthRole(String string) {
        if (string == null) {
            return;
        }
        if (ROLE_ALL_ROLES.equals(string)) {
            this.allRoles = true;
            return;
        }
        if (ROLE_ALL_AUTHENTICATED_USERS.equals(string)) {
            this.authenticatedUsers = true;
            return;
        }
        String[] stringArray = Arrays.copyOf(this.authRoles, this.authRoles.length + 1);
        stringArray[this.authRoles.length] = string;
        this.authRoles = stringArray;
        this.authConstraint = true;
    }

    @Override
    public void setCharset(Charset charset) {
        super.setCharset(charset);
        for (SecurityCollection securityCollection : this.collections) {
            securityCollection.setCharset(this.getCharset());
        }
    }

    public void addCollection(SecurityCollection securityCollection) {
        if (securityCollection == null) {
            return;
        }
        securityCollection.setCharset(this.getCharset());
        SecurityCollection[] securityCollectionArray = Arrays.copyOf(this.collections, this.collections.length + 1);
        securityCollectionArray[this.collections.length] = securityCollection;
        this.collections = securityCollectionArray;
    }

    public boolean findAuthRole(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : this.authRoles) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public String[] findAuthRoles() {
        return this.authRoles;
    }

    public SecurityCollection findCollection(String string) {
        if (string == null) {
            return null;
        }
        for (SecurityCollection securityCollection : this.collections) {
            if (!string.equals(securityCollection.getName())) continue;
            return securityCollection;
        }
        return null;
    }

    public SecurityCollection[] findCollections() {
        return this.collections;
    }

    public boolean included(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        for (SecurityCollection securityCollection : this.collections) {
            String[] stringArray;
            if (!securityCollection.findMethod(string2)) continue;
            for (String string3 : stringArray = securityCollection.findPatterns()) {
                if (!this.matchPattern(string, string3)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeAuthRole(String string) {
        int n;
        if (string == null) {
            return;
        }
        if (ROLE_ALL_ROLES.equals(string)) {
            this.allRoles = false;
            return;
        }
        if (ROLE_ALL_AUTHENTICATED_USERS.equals(string)) {
            this.authenticatedUsers = false;
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.authRoles.length; ++n) {
            if (!this.authRoles[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            n = 0;
            String[] stringArray = new String[this.authRoles.length - 1];
            for (int i = 0; i < this.authRoles.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.authRoles[i];
            }
            this.authRoles = stringArray;
        }
    }

    public void removeCollection(SecurityCollection securityCollection) {
        int n;
        if (securityCollection == null) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.collections.length; ++n) {
            if (!this.collections[n].equals(securityCollection)) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            n = 0;
            SecurityCollection[] securityCollectionArray = new SecurityCollection[this.collections.length - 1];
            for (int i = 0; i < this.collections.length; ++i) {
                if (i == n2) continue;
                securityCollectionArray[n++] = this.collections[i];
            }
            this.collections = securityCollectionArray;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SecurityConstraint[");
        for (int i = 0; i < this.collections.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.collections[i].getName());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private boolean matchPattern(String string, String string2) {
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "/";
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string2.startsWith("/") && string2.endsWith("/*")) {
            if ((string2 = string2.substring(0, string2.length() - 2)).length() == 0) {
                return true;
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            while (true) {
                if (string2.equals(string)) {
                    return true;
                }
                int n = string.lastIndexOf(47);
                if (n <= 0) break;
                string = string.substring(0, n);
            }
            return false;
        }
        if (string2.startsWith("*.")) {
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(46);
            return n >= 0 && n2 > n && string.endsWith(string2.substring(1));
        }
        return string2.equals("/");
    }

    public static SecurityConstraint[] createConstraints(ServletSecurityElement servletSecurityElement, String string) {
        HashSet<Object> hashSet = new HashSet<Object>();
        Collection collection = servletSecurityElement.getHttpMethodConstraints();
        for (Object object : collection) {
            SecurityConstraint securityConstraint = SecurityConstraint.createConstraint((HttpConstraintElement)object, string, true);
            Object object2 = securityConstraint.findCollections()[0];
            ((SecurityCollection)object2).addMethod(object.getMethodName());
            hashSet.add(securityConstraint);
        }
        SecurityConstraint securityConstraint = SecurityConstraint.createConstraint((HttpConstraintElement)servletSecurityElement, string, false);
        if (securityConstraint != null) {
            Object object;
            object = securityConstraint.findCollections()[0];
            for (Object object2 : servletSecurityElement.getMethodNames()) {
                ((SecurityCollection)object).addOmittedMethod((String)object2);
            }
            hashSet.add(securityConstraint);
        }
        return hashSet.toArray(new SecurityConstraint[0]);
    }

    private static SecurityConstraint createConstraint(HttpConstraintElement httpConstraintElement, String string, boolean bl) {
        SecurityConstraint securityConstraint = new SecurityConstraint();
        SecurityCollection securityCollection = new SecurityCollection();
        boolean bl2 = bl;
        if (httpConstraintElement.getTransportGuarantee() != ServletSecurity.TransportGuarantee.NONE) {
            securityConstraint.setUserConstraint(httpConstraintElement.getTransportGuarantee().name());
            bl2 = true;
        }
        if (httpConstraintElement.getRolesAllowed().length > 0) {
            String[] stringArray;
            for (String string2 : stringArray = httpConstraintElement.getRolesAllowed()) {
                securityConstraint.addAuthRole(string2);
            }
            bl2 = true;
        }
        if (httpConstraintElement.getEmptyRoleSemantic() != ServletSecurity.EmptyRoleSemantic.PERMIT) {
            securityConstraint.setAuthConstraint(true);
            bl2 = true;
        }
        if (bl2) {
            securityCollection.addPattern(string);
            securityConstraint.addCollection(securityCollection);
            return securityConstraint;
        }
        return null;
    }

    public static SecurityConstraint[] findUncoveredHttpMethods(SecurityConstraint[] securityConstraintArray, boolean bl, Log log) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        HashMap hashMap2 = new HashMap();
        ArrayList<SecurityConstraint> arrayList = new ArrayList<SecurityConstraint>();
        for (SecurityConstraint object2 : securityConstraintArray) {
            for (Object object3 : object = object2.findCollections()) {
                String[] stringArray = ((SecurityCollection)object3).findPatterns();
                String[] stringArray2 = ((SecurityCollection)object3).findMethods();
                String[] stringArray3 = ((SecurityCollection)object3).findOmittedMethods();
                if (stringArray2.length == 0 && stringArray3.length == 0) {
                    hashSet.addAll(Arrays.asList(stringArray));
                    continue;
                }
                List<String> list = null;
                if (stringArray3.length != 0) {
                    list = Arrays.asList(stringArray3);
                }
                for (String string2 : stringArray) {
                    if (hashSet.contains(string2)) continue;
                    if (stringArray2.length == 0) {
                        HashSet<String> hashSet2 = (HashSet<String>)hashMap2.get(string2);
                        if (hashSet2 == null) {
                            hashSet2 = new HashSet<String>();
                            hashMap2.put(string2, hashSet2);
                            hashSet2.addAll(list);
                            continue;
                        }
                        hashSet2.retainAll(list);
                        continue;
                    }
                    hashMap.computeIfAbsent(string2, string -> new HashSet()).addAll(Arrays.asList(stringArray2));
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String string3 = (String)entry.getKey();
            if (hashSet.contains(string3)) {
                hashMap2.remove(string3);
                continue;
            }
            Set set = (Set)hashMap2.remove(string3);
            object = (Set)entry.getValue();
            if (set == null) {
                Object object4;
                StringBuilder stringBuilder = new StringBuilder();
                Object object5 = object.iterator();
                while (object5.hasNext()) {
                    object4 = (String)object5.next();
                    stringBuilder.append((String)object4);
                    stringBuilder.append(' ');
                }
                if (bl) {
                    log.info((Object)sm.getString("securityConstraint.uncoveredHttpMethodFix", new Object[]{string3, stringBuilder.toString().trim()}));
                    object5 = new SecurityCollection();
                    object4 = object.iterator();
                    while (object4.hasNext()) {
                        Object object3;
                        object3 = (String)object4.next();
                        ((SecurityCollection)object5).addOmittedMethod((String)object3);
                    }
                    ((SecurityCollection)object5).addPatternDecoded(string3);
                    ((SecurityCollection)object5).setName("deny-uncovered-http-methods");
                    object4 = new SecurityConstraint();
                    ((SecurityConstraint)object4).setAuthConstraint(true);
                    ((SecurityConstraint)object4).addCollection((SecurityCollection)object5);
                    arrayList.add((SecurityConstraint)object4);
                    continue;
                }
                log.error((Object)sm.getString("securityConstraint.uncoveredHttpMethod", new Object[]{string3, stringBuilder.toString().trim()}));
                continue;
            }
            set.removeAll((Collection<?>)object);
            SecurityConstraint.handleOmittedMethods(set, string3, bl, arrayList, log);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            String string4 = (String)entry.getKey();
            if (hashSet.contains(string4)) continue;
            SecurityConstraint.handleOmittedMethods((Set)entry.getValue(), string4, bl, arrayList, log);
        }
        return arrayList.toArray(new SecurityConstraint[0]);
    }

    private static void handleOmittedMethods(Set<String> set, String string, boolean bl, List<SecurityConstraint> list, Log log) {
        if (set.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String object : set) {
                stringBuilder.append(object);
                stringBuilder.append(' ');
            }
            if (bl) {
                log.info((Object)sm.getString("securityConstraint.uncoveredHttpOmittedMethodFix", new Object[]{string, stringBuilder.toString().trim()}));
                SecurityCollection securityCollection = new SecurityCollection();
                for (String string2 : set) {
                    securityCollection.addMethod(string2);
                }
                securityCollection.addPatternDecoded(string);
                securityCollection.setName("deny-uncovered-http-methods");
                SecurityConstraint securityConstraint = new SecurityConstraint();
                securityConstraint.setAuthConstraint(true);
                securityConstraint.addCollection(securityCollection);
                list.add(securityConstraint);
            } else {
                log.error((Object)sm.getString("securityConstraint.uncoveredHttpOmittedMethod", new Object[]{string, stringBuilder.toString().trim()}));
            }
        }
    }
}

