/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.servlets.WebdavServlet;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.XMLWriter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.w3c.dom.Node;

public class DataSourcePropertyStore
implements WebdavServlet.PropertyStore {
    protected static final StringManager sm = StringManager.getManager(DataSourcePropertyStore.class);
    private final Log log = LogFactory.getLog(DataSourcePropertyStore.class);
    private static String ADD_PROPERTY_STMT = "INSERT INTO properties (path, namespace, name, node) VALUES (?, ?, ?, ?)";
    private static String SET_PROPERTY_STMT = "UPDATE properties SET node = ? WHERE path = ? AND namespace = ? AND name = ?";
    private static String REMOVE_ALL_PROPERTIES_STMT = "DELETE FROM properties WHERE path = ?";
    private static String REMOVE_PROPERTY_STMT = "DELETE FROM properties WHERE path = ? AND namespace = ? AND name = ?";
    private static String GET_PROPERTY_STMT = "SELECT node FROM properties WHERE path = ? AND namespace = ? AND name = ?";
    private static String GET_PROPERTIES_NAMES_STMT = "SELECT namespace, name FROM properties WHERE path = ?";
    private static String GET_PROPERTIES_STMT = "SELECT namespace, name, node FROM properties WHERE path = ?";
    private static String GET_PROPERTIES_NODES_STMT = "SELECT node FROM properties WHERE path = ?";
    private String dataSourceName = "WebdavPropertyStore";
    private final ReentrantReadWriteLock dbLock = new ReentrantReadWriteLock();
    private final Lock dbReadLock = this.dbLock.readLock();
    private final Lock dbWriteLock = this.dbLock.writeLock();
    protected DataSource dataSource = null;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    @Override
    public void init() {
        if (this.dataSource == null) {
            try {
                this.dataSource = (DataSource)new InitialContext().lookup("java:comp/env/" + this.dataSourceName);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(sm.getString("webdavservlet.dataSourceStore.noDataSource", new Object[]{this.dataSourceName}), namingException);
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void periodicEvent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(String string, String string2) {
        block38: {
            if (this.dataSource == null) {
                return;
            }
            this.dbWriteLock.lock();
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(GET_PROPERTIES_STMT);){
                preparedStatement.setString(1, string);
                if (!preparedStatement.execute()) break block38;
                ResultSet resultSet = preparedStatement.getResultSet();
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    String string5 = resultSet.getString(3);
                    boolean bl = false;
                    try (PreparedStatement preparedStatement2 = connection.prepareStatement(GET_PROPERTY_STMT);){
                        ResultSet resultSet2;
                        preparedStatement2.setString(1, string2);
                        preparedStatement2.setString(2, string3);
                        preparedStatement2.setString(3, string4);
                        if (preparedStatement2.execute() && (resultSet2 = preparedStatement2.getResultSet()).next()) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        preparedStatement2 = connection.prepareStatement(SET_PROPERTY_STMT);
                        try {
                            preparedStatement2.setString(1, string5);
                            preparedStatement2.setString(2, string2);
                            preparedStatement2.setString(3, string3);
                            preparedStatement2.setString(4, string4);
                            preparedStatement2.execute();
                            continue;
                        }
                        finally {
                            if (preparedStatement2 != null) {
                                preparedStatement2.close();
                            }
                            continue;
                        }
                    }
                    preparedStatement2 = connection.prepareStatement(ADD_PROPERTY_STMT);
                    try {
                        preparedStatement2.setString(1, string2);
                        preparedStatement2.setString(2, string3);
                        preparedStatement2.setString(3, string4);
                        preparedStatement2.setString(4, string5);
                        preparedStatement2.execute();
                    }
                    finally {
                        if (preparedStatement2 == null) continue;
                        preparedStatement2.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                this.log.warn((Object)sm.getString("webdavservlet.dataSourceStore.error", new Object[]{"copy", string}), (Throwable)sQLException);
            }
            finally {
                this.dbWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string) {
        if (this.dataSource == null) {
            return;
        }
        this.dbWriteLock.lock();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(REMOVE_ALL_PROPERTIES_STMT);){
            preparedStatement.setString(1, string);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            this.log.warn((Object)sm.getString("webdavservlet.dataSourceStore.error", new Object[]{"delete", string}), (Throwable)sQLException);
        }
        finally {
            this.dbWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean propfind(String string, Node node, boolean bl, XMLWriter xMLWriter) {
        if (this.dataSource == null) {
            return false;
        }
        if (bl) {
            this.dbReadLock.lock();
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(GET_PROPERTIES_NAMES_STMT);){
                preparedStatement.setString(1, string);
                if (!preparedStatement.execute()) return false;
                ResultSet resultSet = preparedStatement.getResultSet();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    xMLWriter.writeElement(null, string2, string3, 2);
                }
                return false;
            }
            catch (SQLException sQLException) {
                this.log.warn((Object)sm.getString("webdavservlet.dataSourceStore.error", new Object[]{"propfind", string}), (Throwable)sQLException);
                return false;
            }
            finally {
                this.dbReadLock.unlock();
            }
        }
        if (node != null) {
            this.dbReadLock.lock();
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(GET_PROPERTY_STMT);){
                ResultSet resultSet;
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, node.getNamespaceURI());
                preparedStatement.setString(3, node.getLocalName());
                if (!preparedStatement.execute() || !(resultSet = preparedStatement.getResultSet()).next()) return false;
                String string4 = resultSet.getString(1);
                xMLWriter.writeRaw(string4);
                boolean bl2 = true;
                return bl2;
            }
            catch (SQLException sQLException) {
                this.log.warn((Object)sm.getString("webdavservlet.dataSourceStore.error", new Object[]{"propfind", string}), (Throwable)sQLException);
                return false;
            }
            finally {
                this.dbReadLock.unlock();
            }
        }
        this.dbReadLock.lock();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(GET_PROPERTIES_NODES_STMT);){
            preparedStatement.setString(1, string);
            if (!preparedStatement.execute()) return false;
            ResultSet resultSet = preparedStatement.getResultSet();
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                xMLWriter.writeRaw(string5);
            }
            return false;
        }
        catch (SQLException sQLException) {
            this.log.warn((Object)sm.getString("webdavservlet.dataSourceStore.error", new Object[]{"propfind", string}), (Throwable)sQLException);
            return false;
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proppatch(String string, ArrayList<WebdavServlet.ProppatchOperation> arrayList) {
        boolean bl = false;
        for (WebdavServlet.ProppatchOperation object : arrayList) {
            if (!object.getProtectedProperty()) continue;
            bl = true;
            object.setStatusCode(403);
        }
        if (bl) {
            for (WebdavServlet.ProppatchOperation proppatchOperation : arrayList) {
                if (proppatchOperation.getProtectedProperty()) continue;
                proppatchOperation.setStatusCode(424);
            }
        } else {
            if (this.dataSource == null) {
                for (WebdavServlet.ProppatchOperation proppatchOperation : arrayList) {
                    proppatchOperation.setStatusCode(500);
                }
                return;
            }
            boolean bl2 = false;
            this.dbWriteLock.lock();
            try (Connection connection = this.dataSource.getConnection();){
                connection.setAutoCommit(false);
                for (WebdavServlet.ProppatchOperation proppatchOperation : arrayList) {
                    AutoCloseable autoCloseable;
                    Node node;
                    block52: {
                        if (proppatchOperation.getUpdateType() == WebdavServlet.PropertyUpdateType.SET) {
                            node = proppatchOperation.getPropertyNode().cloneNode(true);
                            autoCloseable = new StringWriter();
                            DOMWriter dOMWriter = new DOMWriter((Writer)autoCloseable);
                            dOMWriter.print(node);
                            String string2 = ((StringWriter)autoCloseable).toString();
                            boolean bl3 = false;
                            try {
                                try (PreparedStatement preparedStatement = connection.prepareStatement(GET_PROPERTY_STMT);){
                                    ResultSet resultSet;
                                    preparedStatement.setString(1, string);
                                    preparedStatement.setString(2, node.getNamespaceURI());
                                    preparedStatement.setString(3, node.getLocalName());
                                    if (preparedStatement.execute() && (resultSet = preparedStatement.getResultSet()).next()) {
                                        bl3 = true;
                                    }
                                }
                                if (bl3) {
                                    preparedStatement = connection.prepareStatement(SET_PROPERTY_STMT);
                                    try {
                                        preparedStatement.setString(1, string2);
                                        preparedStatement.setString(2, string);
                                        preparedStatement.setString(3, node.getNamespaceURI());
                                        preparedStatement.setString(4, node.getLocalName());
                                        preparedStatement.execute();
                                        break block52;
                                    }
                                    finally {
                                        if (preparedStatement != null) {
                                            preparedStatement.close();
                                        }
                                    }
                                }
                                preparedStatement = connection.prepareStatement(ADD_PROPERTY_STMT);
                                try {
                                    preparedStatement.setString(1, string);
                                    preparedStatement.setString(2, node.getNamespaceURI());
                                    preparedStatement.setString(3, node.getLocalName());
                                    preparedStatement.setString(4, string2);
                                    preparedStatement.execute();
                                }
                                finally {
                                    if (preparedStatement != null) {
                                        preparedStatement.close();
                                    }
                                }
                            }
                            catch (SQLException sQLException) {
                                bl2 = true;
                                proppatchOperation.setStatusCode(500);
                                break;
                            }
                        }
                    }
                    if (proppatchOperation.getUpdateType() != WebdavServlet.PropertyUpdateType.REMOVE) continue;
                    node = proppatchOperation.getPropertyNode();
                    try {
                        autoCloseable = connection.prepareStatement(REMOVE_PROPERTY_STMT);
                        try {
                            autoCloseable.setString(1, string);
                            autoCloseable.setString(2, node.getNamespaceURI());
                            autoCloseable.setString(3, node.getLocalName());
                            autoCloseable.execute();
                        }
                        finally {
                            if (autoCloseable == null) continue;
                            autoCloseable.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        bl2 = true;
                        proppatchOperation.setStatusCode(500);
                        break;
                    }
                }
                if (bl2) {
                    connection.rollback();
                    for (WebdavServlet.ProppatchOperation proppatchOperation : arrayList) {
                        if (proppatchOperation.getStatusCode() != 200) continue;
                        proppatchOperation.setStatusCode(424);
                    }
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                this.log.warn((Object)sm.getString("webdavservlet.dataSourceStore.error", new Object[]{"proppatch", string}), (Throwable)sQLException);
                for (WebdavServlet.ProppatchOperation proppatchOperation : arrayList) {
                    proppatchOperation.setStatusCode(500);
                }
            }
            finally {
                this.dbWriteLock.unlock();
            }
        }
    }
}

