/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class MotifIconFactory
implements Serializable {
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon menuArrowIcon;

    public static Icon getMenuItemCheckIcon() {
        return null;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private Color focus = UIManager.getColor("windowBorder");
        private Color shadow = UIManager.getColor("controlShadow");
        private Color highlight = UIManager.getColor("controlHighlight");

        private MenuArrowIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            Color color = graphics.getColor();
            if (buttonModel.isSelected()) {
                if (MotifGraphicsUtils.isLeftToRight(component)) {
                    graphics.setColor(this.shadow);
                    graphics.fillRect(n + 1, n2 + 1, 2, n4);
                    graphics.drawLine(n + 4, n2 + 2, n + 4, n2 + 2);
                    graphics.drawLine(n + 6, n2 + 3, n + 6, n2 + 3);
                    graphics.drawLine(n + 8, n2 + 4, n + 8, n2 + 5);
                    graphics.setColor(this.focus);
                    graphics.fillRect(n + 2, n2 + 2, 2, n4 - 2);
                    graphics.fillRect(n + 4, n2 + 3, 2, n4 - 4);
                    graphics.fillRect(n + 6, n2 + 4, 2, n4 - 6);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(n + 2, n2 + n4, n + 2, n2 + n4);
                    graphics.drawLine(n + 4, n2 + n4 - 1, n + 4, n2 + n4 - 1);
                    graphics.drawLine(n + 6, n2 + n4 - 2, n + 6, n2 + n4 - 2);
                    graphics.drawLine(n + 8, n2 + n4 - 4, n + 8, n2 + n4 - 3);
                } else {
                    graphics.setColor(this.highlight);
                    graphics.fillRect(n + 7, n2 + 1, 2, 10);
                    graphics.drawLine(n + 5, n2 + 9, n + 5, n2 + 9);
                    graphics.drawLine(n + 3, n2 + 8, n + 3, n2 + 8);
                    graphics.drawLine(n + 1, n2 + 6, n + 1, n2 + 7);
                    graphics.setColor(this.focus);
                    graphics.fillRect(n + 6, n2 + 2, 2, 8);
                    graphics.fillRect(n + 4, n2 + 3, 2, 6);
                    graphics.fillRect(n + 2, n2 + 4, 2, 4);
                    graphics.setColor(this.shadow);
                    graphics.drawLine(n + 1, n2 + 4, n + 1, n2 + 5);
                    graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + 3);
                    graphics.drawLine(n + 5, n2 + 2, n + 5, n2 + 2);
                    graphics.drawLine(n + 7, n2 + 1, n + 7, n2 + 1);
                }
            } else if (MotifGraphicsUtils.isLeftToRight(component)) {
                graphics.setColor(this.highlight);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4);
                graphics.drawLine(n + 2, n2 + 1, n + 2, n2 + n4 - 2);
                graphics.fillRect(n + 3, n2 + 2, 2, 2);
                graphics.fillRect(n + 5, n2 + 3, 2, 2);
                graphics.fillRect(n + 7, n2 + 4, 2, 2);
                graphics.setColor(this.shadow);
                graphics.drawLine(n + 2, n2 + n4 - 1, n + 2, n2 + n4);
                graphics.fillRect(n + 3, n2 + n4 - 2, 2, 2);
                graphics.fillRect(n + 5, n2 + n4 - 3, 2, 2);
                graphics.fillRect(n + 7, n2 + n4 - 4, 2, 2);
                graphics.setColor(color);
            } else {
                graphics.setColor(this.highlight);
                graphics.fillRect(n + 1, n2 + 4, 2, 2);
                graphics.fillRect(n + 3, n2 + 3, 2, 2);
                graphics.fillRect(n + 5, n2 + 2, 2, 2);
                graphics.drawLine(n + 7, n2 + 1, n + 7, n2 + 2);
                graphics.setColor(this.shadow);
                graphics.fillRect(n + 1, n2 + n4 - 4, 2, 2);
                graphics.fillRect(n + 3, n2 + n4 - 3, 2, 2);
                graphics.fillRect(n + 5, n2 + n4 - 2, 2, 2);
                graphics.drawLine(n + 7, n2 + 3, n + 7, n2 + n4);
                graphics.drawLine(n + 8, n2 + 1, n + 8, n2 + n4);
                graphics.setColor(color);
            }
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemArrowIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemCheckIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private Color dot = UIManager.getColor("activeCaptionBorder");
        private Color highlight = UIManager.getColor("controlHighlight");
        private Color shadow = UIManager.getColor("controlShadow");

        private RadioButtonIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl;
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            boolean bl2 = buttonModel.isPressed();
            boolean bl3 = buttonModel.isArmed();
            boolean bl4 = buttonModel.isEnabled();
            boolean bl5 = buttonModel.isSelected();
            boolean bl6 = bl = bl2 && !bl3 && bl5 || bl2 && bl3 && !bl5 || !bl2 && bl3 && bl5 || !bl2 && !bl3 && bl5;
            if (bl) {
                graphics.setColor(this.shadow);
                graphics.drawLine(n + 5, n2 + 0, n + 8, n2 + 0);
                graphics.drawLine(n + 3, n2 + 1, n + 4, n2 + 1);
                graphics.drawLine(n + 9, n2 + 1, n + 9, n2 + 1);
                graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
                graphics.drawLine(n + 1, n2 + 3, n + 1, n2 + 3);
                graphics.drawLine(n, n2 + 4, n, n2 + 9);
                graphics.drawLine(n + 1, n2 + 10, n + 1, n2 + 10);
                graphics.drawLine(n + 2, n2 + 11, n + 2, n2 + 11);
                graphics.setColor(this.highlight);
                graphics.drawLine(n + 3, n2 + 12, n + 4, n2 + 12);
                graphics.drawLine(n + 5, n2 + 13, n + 8, n2 + 13);
                graphics.drawLine(n + 9, n2 + 12, n + 10, n2 + 12);
                graphics.drawLine(n + 11, n2 + 11, n + 11, n2 + 11);
                graphics.drawLine(n + 12, n2 + 10, n + 12, n2 + 10);
                graphics.drawLine(n + 13, n2 + 9, n + 13, n2 + 4);
                graphics.drawLine(n + 12, n2 + 3, n + 12, n2 + 3);
                graphics.drawLine(n + 11, n2 + 2, n + 11, n2 + 2);
                graphics.drawLine(n + 10, n2 + 1, n + 10, n2 + 1);
                graphics.setColor(this.dot);
                graphics.fillRect(n + 4, n2 + 5, 6, 4);
                graphics.drawLine(n + 5, n2 + 4, n + 8, n2 + 4);
                graphics.drawLine(n + 5, n2 + 9, n + 8, n2 + 9);
            } else {
                graphics.setColor(this.highlight);
                graphics.drawLine(n + 5, n2 + 0, n + 8, n2 + 0);
                graphics.drawLine(n + 3, n2 + 1, n + 4, n2 + 1);
                graphics.drawLine(n + 9, n2 + 1, n + 9, n2 + 1);
                graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
                graphics.drawLine(n + 1, n2 + 3, n + 1, n2 + 3);
                graphics.drawLine(n, n2 + 4, n, n2 + 9);
                graphics.drawLine(n + 1, n2 + 10, n + 1, n2 + 10);
                graphics.drawLine(n + 2, n2 + 11, n + 2, n2 + 11);
                graphics.setColor(this.shadow);
                graphics.drawLine(n + 3, n2 + 12, n + 4, n2 + 12);
                graphics.drawLine(n + 5, n2 + 13, n + 8, n2 + 13);
                graphics.drawLine(n + 9, n2 + 12, n + 10, n2 + 12);
                graphics.drawLine(n + 11, n2 + 11, n + 11, n2 + 11);
                graphics.drawLine(n + 12, n2 + 10, n + 12, n2 + 10);
                graphics.drawLine(n + 13, n2 + 9, n + 13, n2 + 4);
                graphics.drawLine(n + 12, n2 + 3, n + 12, n2 + 3);
                graphics.drawLine(n + 11, n2 + 2, n + 11, n2 + 2);
                graphics.drawLine(n + 10, n2 + 1, n + 10, n2 + 1);
            }
        }

        @Override
        public int getIconWidth() {
            return 14;
        }

        @Override
        public int getIconHeight() {
            return 14;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        static final int csize = 13;
        private Color control = UIManager.getColor("control");
        private Color foreground = UIManager.getColor("CheckBox.foreground");
        private Color shadow = UIManager.getColor("controlShadow");
        private Color highlight = UIManager.getColor("controlHighlight");
        private Color lightShadow = UIManager.getColor("controlLightShadow");

        private CheckBoxIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl;
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl2 = false;
            if (abstractButton instanceof JCheckBox) {
                bl2 = ((JCheckBox)abstractButton).isBorderPaintedFlat();
            }
            boolean bl3 = buttonModel.isPressed();
            boolean bl4 = buttonModel.isArmed();
            boolean bl5 = buttonModel.isEnabled();
            boolean bl6 = buttonModel.isSelected();
            boolean bl7 = bl3 && !bl4 && bl6 || bl3 && bl4 && !bl6;
            boolean bl8 = bl3 && !bl4 && !bl6 || bl3 && bl4 && bl6;
            boolean bl9 = bl = !bl3 && bl4 && bl6 || !bl3 && !bl4 && bl6;
            if (bl2) {
                graphics.setColor(this.shadow);
                graphics.drawRect(n + 2, n2, 12, 12);
                if (bl8 || bl7) {
                    graphics.setColor(this.control);
                    graphics.fillRect(n + 3, n2 + 1, 11, 11);
                }
            }
            if (bl7) {
                this.drawCheckBezel(graphics, n, n2, 13, true, false, false, bl2);
            } else if (bl8) {
                this.drawCheckBezel(graphics, n, n2, 13, true, true, false, bl2);
            } else if (bl) {
                this.drawCheckBezel(graphics, n, n2, 13, false, false, true, bl2);
            } else if (!bl2) {
                this.drawCheckBezelOut(graphics, n, n2, 13);
            }
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }

        public void drawCheckBezelOut(Graphics graphics, int n, int n2, int n3) {
            Color color = UIManager.getColor("controlShadow");
            int n4 = n3;
            int n5 = n3;
            Color color2 = graphics.getColor();
            graphics.translate(n, n2);
            graphics.setColor(this.highlight);
            graphics.drawLine(0, 0, 0, n5 - 1);
            graphics.drawLine(1, 0, n4 - 1, 0);
            graphics.setColor(this.shadow);
            graphics.drawLine(1, n5 - 1, n4 - 1, n5 - 1);
            graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, 1);
            graphics.translate(-n, -n2);
            graphics.setColor(color2);
        }

        public void drawCheckBezel(Graphics graphics, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            Color color = graphics.getColor();
            graphics.translate(n, n2);
            if (!bl4) {
                if (bl2) {
                    graphics.setColor(this.control);
                    graphics.fillRect(1, 1, n3 - 2, n3 - 2);
                    graphics.setColor(this.shadow);
                } else {
                    graphics.setColor(this.lightShadow);
                    graphics.fillRect(0, 0, n3, n3);
                    graphics.setColor(this.highlight);
                }
                graphics.drawLine(1, n3 - 1, n3 - 2, n3 - 1);
                if (bl) {
                    graphics.drawLine(2, n3 - 2, n3 - 3, n3 - 2);
                    graphics.drawLine(n3 - 2, 2, n3 - 2, n3 - 1);
                    if (bl2) {
                        graphics.setColor(this.highlight);
                    } else {
                        graphics.setColor(this.shadow);
                    }
                    graphics.drawLine(1, 2, 1, n3 - 2);
                    graphics.drawLine(1, 1, n3 - 3, 1);
                    if (bl2) {
                        graphics.setColor(this.shadow);
                    } else {
                        graphics.setColor(this.highlight);
                    }
                }
                graphics.drawLine(n3 - 1, 1, n3 - 1, n3 - 1);
                if (bl2) {
                    graphics.setColor(this.highlight);
                } else {
                    graphics.setColor(this.shadow);
                }
                graphics.drawLine(0, 1, 0, n3 - 1);
                graphics.drawLine(0, 0, n3 - 1, 0);
            }
            if (bl3) {
                graphics.setColor(this.foreground);
                graphics.drawLine(n3 - 2, 1, n3 - 2, 2);
                graphics.drawLine(n3 - 3, 2, n3 - 3, 3);
                graphics.drawLine(n3 - 4, 3, n3 - 4, 4);
                graphics.drawLine(n3 - 5, 4, n3 - 5, 6);
                graphics.drawLine(n3 - 6, 5, n3 - 6, 8);
                graphics.drawLine(n3 - 7, 6, n3 - 7, 10);
                graphics.drawLine(n3 - 8, 7, n3 - 8, 10);
                graphics.drawLine(n3 - 9, 6, n3 - 9, 9);
                graphics.drawLine(n3 - 10, 5, n3 - 10, 8);
                graphics.drawLine(n3 - 11, 5, n3 - 11, 7);
                graphics.drawLine(n3 - 12, 6, n3 - 12, 6);
            }
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }
}

