/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.AnomalyDetectorJobAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.model.DateRange;
import org.opensearch.timeseries.rest.RestJobAction;
import org.opensearch.timeseries.transport.JobRequest;

public class RestAnomalyDetectorJobAction
extends RestJobAction {
    public static final String AD_JOB_ACTION = "anomaly_detector_job_action";
    private volatile TimeValue requestTimeout;

    public RestAnomalyDetectorJobAction(Settings settings, ClusterService clusterService) {
        this.requestTimeout = (TimeValue)AnomalyDetectorSettings.AD_REQUEST_TIMEOUT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_REQUEST_TIMEOUT, it -> {
            this.requestTimeout = it;
        });
    }

    public String getName() {
        return AD_JOB_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new IllegalStateException("AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        String detectorId = request.param("detectorID");
        boolean historical = request.paramAsBoolean("historical", false);
        String rawPath = request.rawPath();
        DateRange detectionDateRange = this.parseInputDateRange(request);
        JobRequest anomalyDetectorJobRequest = new JobRequest(detectorId, detectionDateRange, historical, rawPath);
        return channel -> client.execute((ActionType)AnomalyDetectorJobAction.INSTANCE, (ActionRequest)anomalyDetectorJobRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "_start"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_opendistro/_anomaly_detection/detectors", "detectorID", "_start")), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "_stop"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_opendistro/_anomaly_detection/detectors", "detectorID", "_stop")));
    }
}

