/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.bulk.BulkAction;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexingPressure;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.ratelimit.ResultWriteRequest;
import org.opensearch.timeseries.transport.ResultBulkRequest;
import org.opensearch.timeseries.transport.ResultBulkResponse;
import org.opensearch.timeseries.util.BulkUtil;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.TransportService;

public abstract class ResultBulkTransportAction<ResultType extends IndexableResult, ADResultWriteRequestType extends ResultWriteRequest<ResultType>, ResultBulkRequestType extends ResultBulkRequest<ResultType, ADResultWriteRequestType>>
extends HandledTransportAction<ResultBulkRequestType, ResultBulkResponse> {
    private static final Logger LOG = LogManager.getLogger(ResultBulkTransportAction.class);
    protected IndexingPressure indexingPressure;
    private final long primaryAndCoordinatingLimits;
    protected float softLimit;
    protected float hardLimit;
    protected String indexName;
    private Client client;
    protected Random random;

    public ResultBulkTransportAction(String actionName, TransportService transportService, ActionFilters actionFilters, IndexingPressure indexingPressure, Settings settings, Client client, float softLimit, float hardLimit, String indexName, Writeable.Reader<ResultBulkRequestType> requestReader) {
        super(actionName, transportService, actionFilters, requestReader, "same");
        this.indexingPressure = indexingPressure;
        this.primaryAndCoordinatingLimits = ((ByteSizeValue)IndexingPressure.MAX_INDEXING_BYTES.get(settings)).getBytes();
        this.client = client;
        this.softLimit = softLimit;
        this.hardLimit = hardLimit;
        this.indexName = indexName;
        this.random = new Random(42L);
    }

    protected void doExecute(Task task, ResultBulkRequestType request, ActionListener<ResultBulkResponse> listener) {
        BulkRequest bulkRequest;
        long totalBytes = this.indexingPressure.getCurrentCombinedCoordinatingAndPrimaryBytes() + this.indexingPressure.getCurrentReplicaBytes();
        float indexingPressurePercent = (float)totalBytes / (float)this.primaryAndCoordinatingLimits;
        List results = ((ResultBulkRequest)((Object)request)).getResults();
        if (results == null || results.size() < 1) {
            listener.onResponse((Object)new ResultBulkResponse());
        }
        if ((bulkRequest = this.prepareBulkRequest(indexingPressurePercent, request)).numberOfActions() > 0) {
            this.client.execute((ActionType)BulkAction.INSTANCE, (ActionRequest)bulkRequest, ActionListener.wrap(bulkResponse -> {
                List<IndexRequest> failedRequests = BulkUtil.getFailedIndexRequest(bulkRequest, bulkResponse);
                listener.onResponse((Object)new ResultBulkResponse(failedRequests));
            }, e -> {
                LOG.error("Failed to bulk index AD result", (Throwable)e);
                listener.onFailure(e);
            }));
        } else {
            listener.onResponse((Object)new ResultBulkResponse());
        }
    }

    protected abstract BulkRequest prepareBulkRequest(float var1, ResultBulkRequestType var2);

    protected void addResult(BulkRequest bulkRequest, ToXContentObject result, String resultIndex) {
        String index = resultIndex == null ? this.indexName : resultIndex;
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            IndexRequest indexRequest = new IndexRequest(index).source(result.toXContent(builder, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE));
            bulkRequest.add(indexRequest);
        }
        catch (IOException e) {
            LOG.error("Failed to prepare bulk index request for index " + index, (Throwable)e);
        }
    }
}

