/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import java.util.function.BiConsumer;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.util.TimeSeriesSafeSecurityInjector;

public class SecurityClientUtil {
    private static final String INJECTION_ID = "direct";
    private NodeStateManager nodeStateManager;
    private Settings settings;

    @Inject
    public SecurityClientUtil(NodeStateManager nodeStateManager, Settings settings) {
        this.nodeStateManager = nodeStateManager;
        this.settings = settings;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void asyncRequestWithInjectedSecurity(Request request, BiConsumer<Request, ActionListener<Response>> consumer, String detectorId, Client client, AnalysisType context, ActionListener<Response> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        try (TimeSeriesSafeSecurityInjector injectSecurity = new TimeSeriesSafeSecurityInjector(detectorId, this.settings, threadContext, this.nodeStateManager, context);){
            injectSecurity.injectUserRolesFromConfig((ActionListener<Void>)ActionListener.wrap(success -> consumer.accept(request, ActionListener.runBefore((ActionListener)listener, () -> injectSecurity.close())), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void asyncRequestWithInjectedSecurity(Request request, BiConsumer<Request, ActionListener<Response>> consumer, User user, Client client, AnalysisType context, ActionListener<Response> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        try (TimeSeriesSafeSecurityInjector injectSecurity = new TimeSeriesSafeSecurityInjector(INJECTION_ID, this.settings, threadContext, this.nodeStateManager, context);){
            injectSecurity.injectUserRoles(user);
            consumer.accept(request, ActionListener.runBefore(listener, () -> injectSecurity.close()));
        }
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void executeWithInjectedSecurity(ActionType<Response> action, Request request, User user, Client client, AnalysisType context, ActionListener<Response> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        try (TimeSeriesSafeSecurityInjector injectSecurity = new TimeSeriesSafeSecurityInjector(INJECTION_ID, this.settings, threadContext, this.nodeStateManager, context);){
            injectSecurity.injectUserRoles(user);
            client.execute(action, request, ActionListener.runBefore(listener, () -> injectSecurity.close()));
        }
    }
}

