/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.coode.owlapi.obo12.parser.AbstractTagValueHandler;
import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOVocabulary;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;

class SynonymTypeDefTagHandler
extends AbstractTagValueHandler {
    private static final Pattern PATTERN = Pattern.compile("([^\\s]*)\\s+\"([^\"]*)\"(\\s*([^\\s]*)\\s*)?");
    private static final int ID_GROUP = 1;
    private static final int NAME_GROUP = 2;

    public SynonymTypeDefTagHandler(@Nonnull OBOConsumer consumer) {
        super(OBOVocabulary.SYNONYM_TYPE_DEF.getName(), consumer);
    }

    @Override
    public void handle(String currentId, String value, String qualifierBlock, String comment) {
        Matcher matcher = PATTERN.matcher(value);
        if (matcher.matches()) {
            String id = matcher.group(1);
            IRI annotationPropertyIRI = this.getIRIFromOBOId(id);
            String name = matcher.group(2);
            assert (name != null);
            OWLDataFactory df = this.getDataFactory();
            OWLAnnotationProperty annotationProperty = df.getOWLAnnotationProperty(annotationPropertyIRI);
            this.applyChange(new AddAxiom(this.getOntology(), df.getOWLDeclarationAxiom(annotationProperty)));
            IRI subsetdefIRI = this.getTagIRI(OBOVocabulary.SUBSETDEF.getName());
            OWLAnnotationProperty subsetdefAnnotationProperty = df.getOWLAnnotationProperty(subsetdefIRI);
            this.applyChange(new AddAxiom(this.getOntology(), df.getOWLSubAnnotationPropertyOfAxiom(annotationProperty, subsetdefAnnotationProperty)));
            OWLLiteral nameLiteral = df.getOWLLiteral(name);
            this.applyChange(new AddAxiom(this.getOntology(), df.getOWLAnnotationAssertionAxiom(df.getRDFSLabel(), annotationPropertyIRI, nameLiteral)));
        } else {
            OWLAnnotation annotation = this.getAnnotationForTagValuePair(OBOVocabulary.SYNONYM_TYPE_DEF.getName(), value);
            this.applyChange(new AddOntologyAnnotation(this.getOntology(), annotation));
        }
    }
}

