/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreVendor;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtilBase;
import org.apache.tomcat.util.net.jsse.JSSESSLContext;
import org.apache.tomcat.util.res.StringManager;

public class JSSEUtil
extends SSLUtilBase {
    private static final Log log;
    private static final StringManager sm;
    private static final Set<String> implementedProtocols;
    private static final Set<String> implementedCiphers;

    public JSSEUtil(SSLHostConfigCertificate sSLHostConfigCertificate) {
        this(sSLHostConfigCertificate, true);
    }

    public JSSEUtil(SSLHostConfigCertificate sSLHostConfigCertificate, boolean bl) {
        super(sSLHostConfigCertificate, bl);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Set<String> getImplementedProtocols() {
        return implementedProtocols;
    }

    @Override
    protected Set<String> getImplementedCiphers() {
        return implementedCiphers;
    }

    @Override
    protected boolean isTls13RenegAuthAvailable() {
        return false;
    }

    @Override
    public SSLContext createSSLContextInternal(List<String> list) throws NoSuchAlgorithmException {
        return new JSSESSLContext(this.sslHostConfig.getSslProtocol());
    }

    static {
        JSSESSLContext jSSESSLContext;
        log = LogFactory.getLog(JSSEUtil.class);
        sm = StringManager.getManager(JSSEUtil.class);
        try {
            jSSESSLContext = new JSSESSLContext("TLS");
            jSSESSLContext.init(null, null, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            throw new IllegalArgumentException(generalSecurityException);
        }
        String[] stringArray = jSSESSLContext.getSupportedSSLParameters().getProtocols();
        implementedProtocols = new HashSet<String>(stringArray.length);
        for (String string : stringArray) {
            String string2 = string.toUpperCase(Locale.ENGLISH);
            if (!"SSLV2HELLO".equals(string2) && !"SSLV3".equals(string2) && string2.contains("SSL")) {
                log.debug((Object)sm.getString("jsseUtil.excludeProtocol", new Object[]{string}));
                continue;
            }
            implementedProtocols.add(string);
        }
        if (implementedProtocols.size() == 0) {
            log.warn((Object)sm.getString("jsseUtil.noDefaultProtocols"));
        }
        String[] stringArray2 = jSSESSLContext.getSupportedSSLParameters().getCipherSuites();
        if (JreVendor.IS_IBM_JVM) {
            implementedCiphers = new HashSet<String>(stringArray2.length * 2);
            for (String string2 : stringArray2) {
                implementedCiphers.add(string2);
                if (!string2.startsWith("SSL")) continue;
                implementedCiphers.add("TLS" + string2.substring(3));
            }
        } else {
            implementedCiphers = new HashSet<String>(stringArray2.length);
            implementedCiphers.addAll(Arrays.asList(stringArray2));
        }
    }
}

