/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class CallbackHandlerImpl
implements CallbackHandler,
Contained {
    private static final StringManager sm = StringManager.getManager(CallbackHandlerImpl.class);
    private final Log log = LogFactory.getLog(CallbackHandlerImpl.class);
    private Container container;

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        String string = null;
        Principal principal = null;
        Subject subject = null;
        String[] stringArray = null;
        if (callbackArray != null) {
            for (Callback callback : callbackArray) {
                CallerPrincipalCallback callerPrincipalCallback;
                if (callback instanceof CallerPrincipalCallback) {
                    callerPrincipalCallback = (CallerPrincipalCallback)callback;
                    string = callerPrincipalCallback.getName();
                    if (callerPrincipalCallback.getPrincipal() != null) {
                        principal = callerPrincipalCallback.getPrincipal();
                    }
                    subject = callerPrincipalCallback.getSubject();
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    callerPrincipalCallback = (GroupPrincipalCallback)callback;
                    stringArray = callerPrincipalCallback.getGroups();
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    if (this.container == null) {
                        this.log.warn((Object)sm.getString("callbackHandlerImpl.containerMissing", new Object[]{callback.getClass().getName()}));
                        continue;
                    }
                    if (this.container.getRealm() == null) {
                        this.log.warn((Object)sm.getString("callbackHandlerImpl.realmMissing", new Object[]{callback.getClass().getName(), this.container.getName()}));
                        continue;
                    }
                    callerPrincipalCallback = (PasswordValidationCallback)callback;
                    principal = this.container.getRealm().authenticate(callerPrincipalCallback.getUsername(), String.valueOf(callerPrincipalCallback.getPassword()));
                    callerPrincipalCallback.setResult(principal != null);
                    subject = callerPrincipalCallback.getSubject();
                    continue;
                }
                this.log.error((Object)sm.getString("callbackHandlerImpl.jaspicCallbackMissing", new Object[]{callback.getClass().getName()}));
            }
            if (subject != null) {
                if (string == null && principal != null) {
                    string = principal.getName();
                }
                if (string != null) {
                    if (principal instanceof GenericPrincipal) {
                        subject.getPrivateCredentials().add(principal);
                    } else {
                        Object object = new ArrayList();
                        Set<GenericPrincipal> set = subject.getPrivateCredentials(GenericPrincipal.class);
                        if (!set.isEmpty()) {
                            GenericPrincipal genericPrincipal = set.iterator().next();
                            object.addAll(Arrays.asList(genericPrincipal.getRoles()));
                            subject.getPrivateCredentials().remove(genericPrincipal);
                        }
                        if (stringArray != null) {
                            object.addAll(Arrays.asList(stringArray));
                        }
                        if (object.size() == 0) {
                            object = Collections.emptyList();
                        }
                        subject.getPrivateCredentials().add(new GenericPrincipal(string, null, (List<String>)object, principal));
                    }
                }
            }
        }
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }
}

