/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.faiss;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.common.TriFunction;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.DefaultHnswSearchContext;
import org.opensearch.knn.index.engine.Encoder;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.Parameter;
import org.opensearch.knn.index.engine.faiss.AbstractFaissMethod;
import org.opensearch.knn.index.engine.faiss.FaissFlatEncoder;
import org.opensearch.knn.index.engine.faiss.FaissHNSWPQEncoder;
import org.opensearch.knn.index.engine.faiss.FaissSQEncoder;
import org.opensearch.knn.index.engine.faiss.MethodAsMapBuilder;
import org.opensearch.knn.index.engine.faiss.QFrameBitEncoder;

public class FaissHNSWMethod
extends AbstractFaissMethod {
    private static final Set<VectorDataType> SUPPORTED_DATA_TYPES = ImmutableSet.of((Object)((Object)VectorDataType.FLOAT), (Object)((Object)VectorDataType.BINARY), (Object)((Object)VectorDataType.BYTE));
    public static final List<SpaceType> SUPPORTED_SPACES = Arrays.asList(SpaceType.UNDEFINED, SpaceType.HAMMING, SpaceType.L2, SpaceType.INNER_PRODUCT);
    private static final MethodComponentContext DEFAULT_ENCODER_CONTEXT = new MethodComponentContext("flat", Collections.emptyMap());
    static final Encoder FLAT_ENCODER = new FaissFlatEncoder();
    static final Encoder SQ_ENCODER = new FaissSQEncoder();
    static final Encoder HNSW_PQ_ENCODER = new FaissHNSWPQEncoder();
    static final Encoder QFRAME_BIT_ENCODER = new QFrameBitEncoder();
    static final Map<String, Encoder> SUPPORTED_ENCODERS = Map.of(FLAT_ENCODER.getName(), FLAT_ENCODER, SQ_ENCODER.getName(), SQ_ENCODER, HNSW_PQ_ENCODER.getName(), HNSW_PQ_ENCODER, QFRAME_BIT_ENCODER.getName(), QFRAME_BIT_ENCODER);
    static final MethodComponent HNSW_COMPONENT = FaissHNSWMethod.initMethodComponent();

    public FaissHNSWMethod() {
        super(HNSW_COMPONENT, Set.copyOf(SUPPORTED_SPACES), new DefaultHnswSearchContext());
    }

    private static MethodComponent initMethodComponent() {
        return MethodComponent.Builder.builder("hnsw").addSupportedDataTypes(SUPPORTED_DATA_TYPES).addParameter("m", new Parameter.IntegerParameter("m", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M, (v, context) -> v > 0)).addParameter("ef_construction", new Parameter.IntegerParameter("ef_construction", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION, (v, context) -> v > 0)).addParameter("ef_search", new Parameter.IntegerParameter("ef_search", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH, (v, context) -> v > 0)).addParameter("encoder", FaissHNSWMethod.initEncoderParameter()).setKnnLibraryIndexingContextGenerator((TriFunction<MethodComponent, MethodComponentContext, KNNMethodConfigContext, KNNLibraryIndexingContext>)((TriFunction)(methodComponent, methodComponentContext, knnMethodConfigContext) -> {
            MethodAsMapBuilder methodAsMapBuilder = MethodAsMapBuilder.builder("HNSW", methodComponent, methodComponentContext, knnMethodConfigContext).addParameter("m", "", "").addParameter("encoder", ",", "");
            return FaissHNSWMethod.adjustIndexDescription(methodAsMapBuilder, methodComponentContext, knnMethodConfigContext);
        })).build();
    }

    private static Parameter.MethodComponentContextParameter initEncoderParameter() {
        return new Parameter.MethodComponentContextParameter("encoder", DEFAULT_ENCODER_CONTEXT, SUPPORTED_ENCODERS.values().stream().collect(Collectors.toMap(Encoder::getName, Encoder::getMethodComponent)));
    }
}

