/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.HallInfo;
import org.jmol.symmetry.SpecialGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.Viewer;

public class SpaceGroup
implements Cloneable,
HallInfo.HallReceiver {
    protected String specialPrefix = "";
    private static final String NEW_HALL_GROUP = "0;--;--;0;--;--;";
    protected static final String NEW_NO_HALL_GROUP = "0;--;--;0;--;--;--";
    private static final String SG_NONE = "--";
    static final String NO_NAME = "-- [--]";
    private static final int SG_ITA = -2;
    public int groupType = 0;
    public SymmetryOperation[] symmetryOperations;
    SymmetryOperation[] finalOperations;
    SymmetryOperation[] allOperations;
    Map<String, Integer> xyzList;
    char uniqueAxis = '\u0000';
    char axisChoice = '\u0000';
    protected String itaNumber;
    String jmolId;
    int operationCount;
    int latticeOp = -1;
    boolean isBio;
    char latticeType = (char)80;
    String itaTransform;
    public int itaNo;
    public int setNo;
    public transient int sfIndex = -1;
    protected String itaIndex;
    protected int nDim = 3;
    protected int periodicity = 7;
    private String clegId;
    private String canonicalCLEG;
    private int index;
    private int referenceIndex = -1;
    public boolean isSSG;
    private String name = "unknown!";
    private String hallSymbol;
    private String hallSymbolAlt;
    private String crystalClass;
    private String hmSymbol;
    private String jmolIdExt;
    private HallInfo hallInfo;
    private int latticeParameter;
    private int modDim;
    private boolean doNormalize = true;
    private Object info;
    private Integer nHallOperators;
    private String hmSymbolFull;
    private String hmSymbolExt;
    private String hmSymbolAbbr;
    private String hmSymbolAlternative;
    private String hmSymbolAbbrShort;
    private char ambiguityType = '\u0000';
    private static String[] canonicalSeitzList;
    private static final int NAME_UNK = 0;
    private static final int NAME_HM = 3;
    private static final int NAME_ITA = 4;
    private static final int NAME_HALL = 5;
    private static final int NAME_CLEG = 6;
    private static volatile int sgIndex;
    private static volatile String lastInfo;
    private static final String SET_AB = "a-b,a+b,c";
    private static volatile String ambiguousHMNames;
    private static volatile String lastHallSymbol;
    String strName;
    public String displayName;
    public static final String PREFIX_FRIEZE = "f/";
    public static final String PREFIX_ROD = "r/";
    public static final String PREFIX_LAYER = "l/";
    public static final String PREFIX_PLANE = "p/";
    public static final String PREFIX_SPACE = "";
    public static final int TYPE_FRIEZE = 600;
    public static final int TYPE_ROD = 500;
    public static final int TYPE_LAYER = 400;
    public static final int TYPE_PLANE = 300;
    public static final int TYPE_SPACE = 0;
    public static final int TYPE_INVALID = -1;
    private static SpaceGroup[] SG;
    private static Map<Integer, Lst<SpaceGroup>> htByOpCount;
    static Map<String, SpaceGroup> nameToGroup;
    static int nSG;
    private static String[] STR_SG;
    private static final String[] moreSettings;
    private static Hashtable<String, String> HMtoCleg;
    private static Hashtable<String, String> ClegtoHM;

    private SpaceGroup setFrom(SpaceGroup sg, boolean isITA) {
        if (isITA) {
            this.setName(sg.itaNumber.equals("0") ? this.clegId : "HM:" + sg.hmSymbolFull + " #" + sg.clegId);
            this.referenceIndex = -2;
        } else {
            this.setName(sg.getName());
            this.referenceIndex = sg.index;
        }
        this.latticeType = sg.latticeType;
        this.specialPrefix = sg.specialPrefix;
        this.periodicity = sg.periodicity;
        this.groupType = sg.groupType;
        this.setClegId(sg.getClegId());
        this.itaIndex = sg.itaIndex;
        this.crystalClass = sg.crystalClass;
        this.hallSymbol = sg.hallSymbol;
        this.hmSymbol = sg.hmSymbol;
        this.hmSymbolAbbr = sg.hmSymbolAbbr;
        this.hmSymbolAbbrShort = sg.hmSymbolAbbrShort;
        this.hmSymbolAlternative = sg.hmSymbolAlternative;
        this.hmSymbolExt = sg.hmSymbolExt;
        this.hmSymbolFull = sg.hmSymbolFull;
        this.itaNumber = sg.itaNumber;
        this.itaTransform = sg.itaTransform;
        this.jmolId = null;
        this.jmolIdExt = null;
        this.displayName = null;
        this.strName = null;
        return this;
    }

    static SpaceGroup getNull(boolean doInit, boolean doNormalize, boolean doFinalize) {
        SpaceGroup sg = new SpaceGroup(-1, null, doInit);
        sg.doNormalize = doNormalize;
        if (doFinalize) {
            sg.setFinalOperations();
        }
        return sg;
    }

    protected SpaceGroup(int index, String strData, boolean doInit) {
        ++sgIndex;
        if (index < 0) {
            index = sgIndex;
        }
        this.index = index;
        this.init(doInit && strData == null);
        if (doInit && strData != null) {
            this.buildSelf(strData);
        }
    }

    private void init(boolean addXYZ) {
        this.xyzList = new Hashtable<String, Integer>();
        this.operationCount = 0;
        if (addXYZ) {
            this.addSymmetry("x,y,z", 0, false);
        }
    }

    public static SpaceGroup createSpaceGroup(int desiredSpaceGroupIndex, String name, Object data, int modDim) {
        SpaceGroup sg = null;
        if (desiredSpaceGroupIndex >= 0) {
            sg = SG[desiredSpaceGroupIndex];
        } else {
            sg = data instanceof Lst ? SpaceGroup.createSGFromList(name, (Lst)data) : SpaceGroup.determineSpaceGroupNA(name, (float[])data);
            if (sg == null) {
                sg = SpaceGroup.createSpaceGroupN(modDim <= 0 ? name : "x1,x2,x3,x4,x5,x6,x7,x8,x9".substring(0, modDim * 3 + 8), true);
            }
        }
        if (sg != null) {
            sg.generateMatrixOperators(null);
        }
        return sg;
    }

    public String getItaIndex() {
        return this.itaIndex != null && !SG_NONE.equals(this.itaIndex) ? this.itaIndex : (!"0".equals(this.itaNumber) ? this.itaNumber : (!SG_NONE.equals(this.hallSymbol) ? "[" + this.hallSymbol + "]" : "?"));
    }

    public int getIndex() {
        return this.referenceIndex >= 0 ? this.referenceIndex : this.index;
    }

    public void setClegId(String cleg) {
        this.clegId = cleg;
        this.canonicalCLEG = SpaceGroup.canonicalizeCleg(cleg);
    }

    public String getClegId() {
        return this.clegId;
    }

    private static SpaceGroup createSGFromList(String name, Lst<?> data) {
        SpaceGroup sg = new SpaceGroup(-1, NEW_NO_HALL_GROUP, true);
        sg.doNormalize = false;
        sg.setName(name);
        int n = data.size();
        if (n == 0) {
            return sg;
        }
        for (int i = 0; i < n; ++i) {
            Object operation = data.get(i);
            if (operation instanceof SymmetryOperation) {
                SymmetryOperation op = (SymmetryOperation)operation;
                int iop = sg.addOp(op, op.xyz, false);
                sg.symmetryOperations[iop].setTimeReversal(op.timeReversal);
                continue;
            }
            sg.addSymmetrySM("xyz matrix:" + operation, (M4)operation);
        }
        sg.setFinalOperationsSafely();
        SpaceGroup sgn = sg.getReferenceSpaceGroup();
        if (sgn != null) {
            sg = sgn;
        }
        return sg;
    }

    public int addSymmetry(String xyz, int opId, boolean allowScaling) {
        return (xyz = xyz.toLowerCase()).indexOf("[[") < 0 && xyz.indexOf("x4") < 0 && xyz.indexOf(";") < 0 && (xyz.indexOf("x") < 0 || xyz.indexOf("y") < 0 || xyz.indexOf("z") < 0) ? -1 : this.addOperation(xyz, opId, allowScaling);
    }

    public void setFinalOperationsSafely() {
        if (this.finalOperations == null) {
            this.setFinalOperations();
        }
    }

    protected void setFinalOperations() {
        this.setFinalOperationsForAtoms(3, null, 0, 0, false);
    }

    void setFinalOperationsForAtoms(int dim, P3[] atoms, int atomIndex, int count, boolean doNormalize) {
        SpaceGroup sg;
        if (this.hallInfo == null && this.latticeParameter != 0) {
            HallInfo h = new HallInfo(HallInfo.getHallLatticeEquivalent(this.latticeParameter));
            this.generateMatrixOperators(h);
        } else {
            this.checkCreateFromHall();
        }
        this.finalOperations = null;
        boolean bl = this.isBio = this.name.indexOf("bio") >= 0;
        if (!this.isBio && this.index >= SG.length && this.allowCheckForReference() && (sg = this.getReferenceSpaceGroup()) != null && sg != this) {
            this.setFrom(sg, false);
        }
        if (this.operationCount == 0) {
            this.addOperation("x,y,z", 1, false);
        }
        this.finalOperations = new SymmetryOperation[this.operationCount];
        boolean doOffset = doNormalize && count > 0 && atoms != null;
        SymmetryOperation op = null;
        if (doOffset) {
            op = this.finalOperations[0] = new SymmetryOperation(this.symmetryOperations[0], 0, true);
            if (op.sigma == null) {
                SymmetryOperation.normalizeOperationToCentroid(dim, op, atoms, atomIndex, count);
            }
            P3 atom = atoms[atomIndex];
            P3 c = P3.newP(atom);
            op.rotTrans(c);
            if (c.distance(atom) > 1.0E-4f) {
                for (int i = 0; i < count; ++i) {
                    atom = atoms[atomIndex + i];
                    c.setT(atom);
                    op.rotTrans(c);
                    atom.setT(c);
                }
            }
            if (!doNormalize) {
                op = null;
            }
        }
        for (int i = 0; i < this.operationCount; ++i) {
            if (i > 0 || op == null) {
                op = this.finalOperations[i] = new SymmetryOperation(this.symmetryOperations[i], 0, doNormalize);
                if (!op.isFinalized) {
                    op.doFinalize();
                }
            }
            if (doOffset && op.sigma == null) {
                SymmetryOperation.normalizeOperationToCentroid(dim, op, atoms, atomIndex, count);
            }
            op.getCentering();
        }
    }

    private boolean allowCheckForReference() {
        return this.modDim == 0 && this.symmetryOperations != null && this.symmetryOperations.length > 0 && this.symmetryOperations[0].timeReversal == 0 && this.name.indexOf("[subsystem") < 0;
    }

    private static HallInfo newHallInfo(String hallSymbol) {
        if (hallSymbol.startsWith("Hall:")) {
            hallSymbol = hallSymbol.substring(5).trim();
        }
        return new HallInfo(hallSymbol);
    }

    int getOperationCount() {
        this.setFinalOperationsSafely();
        return this.finalOperations.length;
    }

    M4 getOperation(int i) {
        return this.finalOperations[i];
    }

    int getAdditionalOperationsCount() {
        this.setFinalOperationsSafely();
        if (this.allOperations == null) {
            this.allOperations = SymmetryOperation.getAdditionalOperations(this.finalOperations, this.periodicity << 4 | this.nDim);
        }
        return this.allOperations.length - this.getOperationCount();
    }

    M4[] getAdditionalOperations() {
        this.getAdditionalOperationsCount();
        return this.allOperations;
    }

    M4 getAllOperation(int i) {
        return this.allOperations[i];
    }

    String getXyz(int i, boolean doNormalize) {
        return this.finalOperations == null ? this.symmetryOperations[i].getXyz(doNormalize) : this.finalOperations[i].getXyz(doNormalize);
    }

    public static SpaceGroup findSpaceGroupFromXYZ(String xyzList) {
        SpaceGroup sg = new SpaceGroup(-1, NEW_NO_HALL_GROUP, true);
        sg.doNormalize = false;
        String[] xyzlist = xyzList.split(";");
        int n = xyzlist.length;
        for (int i = 0; i < n; ++i) {
            SymmetryOperation op = new SymmetryOperation(null, i, false);
            op.setMatrixFromXYZ(xyzlist[i], 0, false);
            sg.addOp(op, xyzlist[i], false);
        }
        return SpaceGroup.findReferenceSpaceGroup(sg.operationCount, sg.getCanonicalSeitzList(), null);
    }

    static Object getInfo(SpaceGroup sg, String spaceGroup, float[] params, boolean asMap, boolean andNonstandard) {
        try {
            SpaceGroup sgReference;
            if (sg != null && sg.index >= SG.length && (sgReference = SpaceGroup.findReferenceSpaceGroup(sg.operationCount, sg.getCanonicalSeitzList(), sg.clegId)) != null) {
                sg = sgReference;
            }
            if (params != null) {
                if (sg == null) {
                    if (spaceGroup.indexOf("[") >= 0) {
                        spaceGroup = spaceGroup.substring(0, spaceGroup.indexOf("[")).trim();
                    }
                    if (spaceGroup.equals("unspecified!")) {
                        return "no space group identified in file";
                    }
                    sg = SpaceGroup.determineSpaceGroupNA(spaceGroup, params);
                }
            } else {
                if (spaceGroup.equalsIgnoreCase("ALL")) {
                    return SpaceGroup.dumpAll(asMap);
                }
                if (spaceGroup.equalsIgnoreCase("MAP")) {
                    return SpaceGroup.dumpAll(true);
                }
                if (spaceGroup.equalsIgnoreCase("ALLSEITZ")) {
                    return SpaceGroup.dumpAllSeitz();
                }
                sg = SpaceGroup.determineSpaceGroupN(spaceGroup);
            }
            if (sg == null) {
                SpaceGroup sgFound = SpaceGroup.createSpaceGroupN(spaceGroup, true);
                if (sgFound != null) {
                    sgFound = SpaceGroup.findReferenceSpaceGroup(sgFound.operationCount, sgFound.getCanonicalSeitzList(), sgFound.clegId);
                }
                if (sgFound != null) {
                    sg = sgFound;
                }
            }
            if (sg != null) {
                if (asMap) {
                    return sg.dumpInfoObj();
                }
                SB sb = new SB();
                while (sg != null && sg.index >= SG.length && !andNonstandard) {
                    sg = SG[sg.index];
                }
                sg.getOperationCount();
                sb.append(sg.dumpInfo());
                return sb.toString();
            }
            return asMap ? null : "?";
        }
        catch (Exception e) {
            return "?";
        }
    }

    public String dumpInfo() {
        SB sb = new SB();
        if (this.groupType != 0) {
            sb.append("\ngroupType: ").append(SpaceGroup.getSpecialGroupName(this.groupType));
        }
        sb.append("\nHermann-Mauguin symbol: ");
        if (this.hmSymbol == null || this.hmSymbolExt == null) {
            sb.append("?");
        } else {
            sb.append(this.hmSymbol).append(this.hmSymbolExt.length() > 0 ? ":" + this.hmSymbolExt : PREFIX_SPACE);
        }
        if (this.itaNumber != null) {
            sb.append("\ninternational table number: ").append(this.itaNumber);
        }
        if (this.crystalClass != null) {
            sb.append("\ncrystal class: " + this.crystalClass);
        }
        if (this.jmolId != null) {
            sb.append("\nJmol_ID: ").append(this.jmolId).append(" (" + this.itaIndex + ")");
        }
        if (this.clegId != null) {
            sb.append("\nCLEG: " + this.clegId);
        }
        sb.append("\n\n").append(this.hallInfo == null ? "Hall symbol unknown" : (Logger.debugging ? this.hallInfo.dumpInfo() : PREFIX_SPACE));
        sb.append("\n\n").appendI(this.operationCount).append(" operators").append(this.hallInfo != null && !this.hallInfo.getHallSymbol().equals(SG_NONE) ? " from Hall symbol " + this.hallInfo.getHallSymbol() : PREFIX_SPACE).append(": ");
        for (int i = 0; i < this.operationCount; ++i) {
            sb.append("\n").append(this.symmetryOperations[i].xyz);
        }
        return sb.toString();
    }

    Object dumpInfoObj() {
        String info = this.dumpCanonicalSeitzList();
        if (info instanceof SpaceGroup) {
            return ((SpaceGroup)((Object)info)).dumpInfoObj();
        }
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (this.itaNumber != null && !this.itaNumber.equals("0")) {
            String s = this.hmSymbol == null || this.hmSymbolExt == null ? "?" : this.hmSymbol + (this.hmSymbolExt.length() > 0 ? ":" + this.hmSymbolExt : PREFIX_SPACE);
            map.put("index", this.index);
            map.put("hm", s);
            map.put("HermannMauguinSymbol", s);
            map.put("ita", PT.parseInt(this.itaNumber));
            if (this.hallInfo != null && this.hallInfo.getHallSymbol() != null) {
                map.put("HallSymbol", this.hallInfo.getHallSymbol());
            }
            if (this.hallSymbolAlt != null) {
                map.put("HallSymbolAlt", this.hallSymbolAlt);
            }
            map.put("itaIndex", this.itaIndex == null ? "n/a" : this.itaIndex);
            map.put("clegId", this.itaIndex == null ? "n/a" : this.clegId);
            if (this.jmolId != null) {
                map.put("jmolId", this.jmolId);
            }
            if (this.crystalClass != null) {
                map.put("crystalClass", this.crystalClass);
            }
            map.put("operationCount", this.operationCount);
        } else if (this.hallInfo != null) {
            if (this.hallInfo.getHallSymbol() != null) {
                map.put("HallSymbol", this.hallInfo.getHallSymbol());
            }
            if (this.hallSymbolAlt != null) {
                map.put("HallSymbolAlt", this.hallSymbolAlt);
            }
            map.put("operationCount", this.operationCount);
        }
        Lst<String> lst = new Lst<String>();
        for (int i = 0; i < this.operationCount; ++i) {
            lst.addLast(this.symmetryOperations[i].xyz);
        }
        map.put("operationsXYZ", lst);
        return map;
    }

    String getCIFWriterValue(String type, SymmetryInterface uc) {
        String ret = null;
        switch (type) {
            case "HermannMauguinSymbol": {
                ret = this.hmSymbol;
                break;
            }
            case "ita": {
                ret = this.itaNumber;
                break;
            }
            case "HallSymbol": {
                ret = this.hallSymbol;
            }
        }
        if (ret != null) {
            return ret;
        }
        if (this.info == null) {
            this.info = SpaceGroup.getInfo(this, this.hmSymbol, uc.getUnitCellParams(), true, false);
        }
        if (this.info instanceof String) {
            return null;
        }
        Map map = (Map)this.info;
        Object v = map.get(type);
        return v == null ? null : v.toString();
    }

    String getName() {
        return this.name;
    }

    String getShelxLATTDesignation() {
        return HallInfo.getLatticeDesignation(this.latticeParameter);
    }

    void setLatticeParam(int latticeParameter) {
        this.latticeParameter = latticeParameter;
        if (latticeParameter > 10) {
            this.latticeParameter = -HallInfo.getLatticeIndexFromCode(latticeParameter);
        }
    }

    private String dumpCanonicalSeitzList() {
        SpaceGroup sgReference;
        this.checkCreateFromHall();
        String s = this.getCanonicalSeitzList();
        if (this.index >= SG.length && (sgReference = SpaceGroup.findReferenceSpaceGroup(this.operationCount, s, this.clegId)) != null) {
            return sgReference.getCanonicalSeitzList();
        }
        return (this.index >= 0 && this.index < SG.length ? this.hallSymbol + " = " : PREFIX_SPACE) + s;
    }

    private void checkCreateFromHall() {
        if (this.nHallOperators != null && this.hallSymbol != null) {
            this.hallInfo = SpaceGroup.newHallInfo(this.hallSymbol);
            this.generateMatrixOperators(null);
        }
    }

    SpaceGroup getReferenceSpaceGroup() {
        if (this.referenceIndex == -2 || this.index >= 0 && this.index < SG.length || !this.allowCheckForReference()) {
            return this;
        }
        String s = this.getCanonicalSeitzList();
        return s == null ? null : SpaceGroup.findReferenceSpaceGroup(this.operationCount, s, this.clegId);
    }

    private String getCanonicalSeitzList() {
        return SpaceGroup.getCanonicalSeitzForOperations(this.symmetryOperations, this.operationCount);
    }

    static String getCanonicalSeitzForOperations(SymmetryOperation[] operations, int n) {
        Object[] list = new String[n];
        for (int i = 0; i < n; ++i) {
            list[i] = SymmetryOperation.dumpSeitz(operations[i], true);
        }
        Arrays.sort(list, 0, n);
        SB sb = new SB().append("\n[");
        for (int i = 0; i < n; ++i) {
            sb.append(((String)list[i]).replace('\t', ' ').replace('\n', ' ')).append("; ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static synchronized SpaceGroup findReferenceSpaceGroup(int opCount, String s, String clegId) {
        Lst<SpaceGroup> lst = htByOpCount.get(opCount);
        if (lst != null) {
            int n = lst.size();
            for (int i = 0; i < n; ++i) {
                String sgi;
                SpaceGroup sg = (SpaceGroup)lst.get(i);
                if (clegId != null && clegId.equals(sg.clegId)) {
                    return SG[sg.index];
                }
                if (sg.clegId != null && clegId != null && !clegId.equals("0:a,b,c") || (sgi = SpaceGroup.getCanonicalSeitz(sg.index)).indexOf(s) < 0) continue;
                return SG[sg.index];
            }
        }
        return null;
    }

    private static final Object dumpAll(boolean asMap) {
        if (asMap) {
            Lst<Object> info = new Lst<Object>();
            for (int i = 0; i < SG.length; ++i) {
                info.addLast(SG[i].dumpInfoObj());
            }
            return info;
        }
        SB sb = new SB();
        for (int i = 0; i < SG.length; ++i) {
            sb.append("\n----------------------\n" + SG[i].dumpInfo());
        }
        return sb.toString();
    }

    private static final String dumpAllSeitz() {
        SB sb = new SB();
        for (int i = 0; i < SG.length; ++i) {
            sb.append("\n").appendO(SpaceGroup.getCanonicalSeitz(i));
        }
        return sb.toString();
    }

    private static String getCanonicalSeitz(int i) {
        String cs;
        if (canonicalSeitzList == null) {
            canonicalSeitzList = new String[SG.length];
        }
        return (cs = canonicalSeitzList[i]) == null ? SG[i].dumpCanonicalSeitzList().toString() : cs;
    }

    private void setLattice(char latticeCode, boolean isCentrosymmetric) {
        this.latticeParameter = HallInfo.getLatticeIndex(latticeCode);
        if (!isCentrosymmetric) {
            this.latticeParameter = -this.latticeParameter;
        }
    }

    static final SpaceGroup createSpaceGroupN(String name, boolean allowHall) {
        SpaceGroup sg = SpaceGroup.determineSpaceGroupN(name = name.trim());
        if (sg == null && allowHall) {
            HallInfo hallInfo = SpaceGroup.newHallInfo(name);
            if (hallInfo.isGenerated()) {
                sg = new SpaceGroup(-1, NEW_HALL_GROUP + name, true);
                sg.hallInfo = hallInfo;
                sg.hallSymbol = hallInfo.getHallSymbol();
                sg.setName("[" + sg.hallSymbol + "]");
                sg.jmolId = null;
            } else if (name.indexOf(",") >= 0) {
                sg = new SpaceGroup(-1, NEW_NO_HALL_GROUP, true);
                sg.doNormalize = false;
                sg.generateOperatorsFromXyzInfo(name);
            }
        }
        if (sg != null) {
            try {
                sg.generateMatrixOperators(null);
                return sg;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected int addOperation(String xyz0, int opId, boolean allowScaling) {
        int id;
        boolean isSpecial;
        if (xyz0 == null || xyz0.length() < 3) {
            this.init(false);
            return -1;
        }
        boolean bl = isSpecial = (xyz0 = PT.rep(xyz0, " ", PREFIX_SPACE)).charAt(0) == '=';
        if (isSpecial) {
            xyz0 = xyz0.substring(1);
        }
        if ((id = this.checkXYZlist(xyz0)) >= 0) {
            return id;
        }
        if (xyz0.startsWith("x1,x2,x3,x4") && this.modDim == 0) {
            this.xyzList.clear();
            this.operationCount = 0;
            this.modDim = PT.parseInt(xyz0.substring(xyz0.lastIndexOf("x") + 1)) - 3;
        } else if ((xyz0.indexOf("m") >= 0 || xyz0.indexOf("u") >= 0) && ((xyz0 = PT.rep(xyz0, "+m", "m")).equals("x,y,z,m") || xyz0.equals("x,y,z(mx,my,mz)") || xyz0.equals("x,y,z(u,v,w)"))) {
            this.xyzList.clear();
            this.operationCount = 0;
        }
        SymmetryOperation op = new SymmetryOperation(null, opId, this.doNormalize);
        if (!op.setMatrixFromXYZ(xyz0, this.modDim, allowScaling)) {
            Logger.error("couldn't interpret symmetry operation: " + xyz0);
            return -1;
        }
        if (xyz0.charAt(0) == '!') {
            xyz0 = xyz0.substring(xyz0.lastIndexOf(33) + 1);
        }
        return this.addOp(op, xyz0, isSpecial);
    }

    private int checkXYZlist(String xyz) {
        return this.xyzList.containsKey(xyz) ? this.xyzList.get(xyz) : -1;
    }

    protected int addOp(SymmetryOperation op, String xyz0, boolean isSpecial) {
        String xyz = op.xyz;
        if (!isSpecial) {
            int id = this.checkXYZlist(xyz);
            if (id >= 0) {
                return id;
            }
            if (this.latticeOp < 0) {
                String xxx = PT.replaceAllCharacters(this.modDim > 0 ? SymmetryOperation.replaceXn(xyz, this.modDim + 3) : xyz, "+123/", PREFIX_SPACE);
                if (this.xyzList.containsKey(xxx + "!")) {
                    this.latticeOp = this.operationCount;
                } else {
                    this.xyzList.put(xxx + "!", this.operationCount);
                }
            }
            this.xyzList.put(xyz, this.operationCount);
        }
        if (!xyz.equals(xyz0)) {
            this.xyzList.put(xyz0, this.operationCount);
        }
        if (this.symmetryOperations == null) {
            this.symmetryOperations = new SymmetryOperation[4];
        }
        if (this.operationCount == this.symmetryOperations.length) {
            this.symmetryOperations = (SymmetryOperation[])AU.arrayCopyObject(this.symmetryOperations, this.operationCount * 2);
        }
        this.symmetryOperations[this.operationCount++] = op;
        op.number = this.operationCount;
        if (op.timeReversal != 0) {
            this.symmetryOperations[0].timeReversal = 1;
        }
        if (Logger.debugging) {
            Logger.debug("\naddOperation " + this.operationCount + op.dumpInfo());
        }
        return this.operationCount - 1;
    }

    private void generateOperatorsFromXyzInfo(String xyzInfo) {
        this.init(true);
        String[] terms = PT.split(xyzInfo.toLowerCase(), ";");
        for (int i = 0; i < terms.length; ++i) {
            this.addSymmetry(terms[i], 0, false);
        }
    }

    private void generateMatrixOperators(HallInfo h) {
        if (h == null) {
            if (this.operationCount > 0) {
                return;
            }
            if (this.hallSymbol == null || this.hallSymbol.endsWith("?")) {
                this.checkHallOperators();
                return;
            }
            this.symmetryOperations = new SymmetryOperation[4];
            if (this.hallInfo == null || !this.hallInfo.isGenerated()) {
                this.hallInfo = SpaceGroup.newHallInfo(this.hallSymbol);
            }
            this.setLattice(this.hallInfo.getLatticeCode(), this.hallInfo.isCentrosymmetric());
            this.init(true);
            h = this.hallInfo;
        }
        h.generateAllOperators(this);
        if (this.hmSymbol == null) {
            this.hmSymbol = SG_NONE;
        }
        if (this.hmSymbol.equals(SG_NONE)) {
            this.hallSymbol = h.getHallSymbol();
            this.nHallOperators = this.operationCount;
        }
        if (this.nHallOperators != null && this.operationCount != this.nHallOperators) {
            Logger.error("Operator mismatch " + this.operationCount + " for " + this);
        }
        char code = h.getLatticeCode();
        switch (code) {
            case '\u0000': 
            case 'P': 
            case 'S': 
            case 'T': {
                this.latticeType = (char)80;
                break;
            }
            default: {
                this.latticeType = code;
            }
        }
    }

    int addSymmetrySM(String xyz, M4 operation) {
        int iop = this.addOperation(xyz, 0, false);
        if (iop >= 0) {
            SymmetryOperation symmetryOperation = this.symmetryOperations[iop];
            symmetryOperation.setM4(operation);
        }
        return iop;
    }

    static final SpaceGroup determineSpaceGroupN(String name) {
        return SpaceGroup.determineSpaceGroup(name, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1);
    }

    public static SpaceGroup determineSpaceGroupNS(String name, SpaceGroup sg) {
        return SpaceGroup.determineSpaceGroup(name, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, sg.index);
    }

    public static SpaceGroup determineSpaceGroupNA(String name, float[] unitCellParams) {
        return unitCellParams == null ? SpaceGroup.determineSpaceGroup(name, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1) : SpaceGroup.determineSpaceGroup(name, unitCellParams[0], unitCellParams[1], unitCellParams[2], unitCellParams[3], unitCellParams[4], unitCellParams[5], -1);
    }

    private static final SpaceGroup determineSpaceGroup(String name, float a, float b, float c, float alpha, float beta, float gamma, int lastIndex) {
        int i = SpaceGroup.determineSpaceGroupIndex(name, a, b, c, alpha, beta, gamma, lastIndex);
        return i >= 0 ? SG[i] : null;
    }

    static boolean isXYZList(String name) {
        return name != null && name.indexOf(",") >= 0 && name.indexOf("(") < 0 && name.indexOf(":") < 0;
    }

    private static final int determineSpaceGroupIndex(String name, float a, float b, float c, float alpha, float beta, float gamma, int lastIndex) {
        SpaceGroup s;
        int i;
        int pt;
        if (SpaceGroup.isXYZList(name)) {
            return -1;
        }
        if (lastIndex < 0) {
            lastIndex = SG.length;
        }
        if (SpaceGroup.getExplicitSpecialGroupType(name) > 0) {
            return -1;
        }
        if ((name = name.trim().toLowerCase()).startsWith("bilbao:")) {
            name = name.substring(7);
        }
        if ((pt = name.indexOf("hall:")) > 0) {
            name = name.substring(pt);
        }
        int nameType = name.indexOf(",") >= 0 ? 6 : (name.startsWith("ita/") ? 4 : (name.startsWith("hall:") ? 5 : (name.startsWith("hm:") ? 3 : 0)));
        switch (nameType) {
            case 6: {
                name = SpaceGroup.canonicalizeCleg(name);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                name = name.substring(nameType);
                break;
            }
            case 0: {
                if (name.contains("[")) {
                    nameType = 5;
                    name = name.substring(0, name.indexOf("[")).trim();
                    break;
                }
                if (name.indexOf(".") <= 0) break;
                nameType = 4;
            }
        }
        switch (nameType) {
            case 6: {
                for (int i2 = 0; i2 < lastIndex; ++i2) {
                    if (!name.equals(SpaceGroup.SG[i2].canonicalCLEG)) continue;
                    return i2;
                }
                return -1;
            }
            case 5: {
                for (int i3 = 0; i3 < lastIndex; ++i3) {
                    if (!SpaceGroup.SG[i3].hallSymbol.equalsIgnoreCase(name)) continue;
                    return i3;
                }
                return -1;
            }
        }
        String nameExt = name;
        boolean haveExtension = false;
        if (nameType != 4 && (name = name.replace('_', ' ')).length() >= 2) {
            int n = i = name.indexOf("-") == 0 ? 2 : 1;
            if (i < name.length() && name.charAt(i) != ' ') {
                name = name.substring(0, i) + " " + name.substring(i);
            }
            name = SpaceGroup.toCap(name, 2);
        }
        String ext = PREFIX_SPACE;
        i = name.indexOf(":");
        if (i > 0) {
            ext = name.substring(i + 1);
            name = name.substring(0, i).trim();
            boolean bl = haveExtension = ext.length() > 0;
        }
        if (nameType != 4 && nameType != 5 && !haveExtension && PT.isOneOf(name, ambiguousHMNames)) {
            ext = "?";
            haveExtension = true;
        }
        String abbr = PT.replaceAllCharacters(name, " ()", PREFIX_SPACE);
        switch (nameType) {
            case 4: {
                if (haveExtension) {
                    for (i = 0; i < lastIndex; ++i) {
                        if (!nameExt.equalsIgnoreCase(SpaceGroup.SG[i].itaIndex)) continue;
                        return i;
                    }
                } else {
                    for (i = 0; i < lastIndex; ++i) {
                        if (!name.equalsIgnoreCase(SpaceGroup.SG[i].itaIndex)) continue;
                        return i;
                    }
                }
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            default: {
                if (nameType != 3) {
                    for (i = 0; i < lastIndex; ++i) {
                        if (!SpaceGroup.SG[i].jmolId.equalsIgnoreCase(nameExt)) continue;
                        return i;
                    }
                }
                for (i = 0; i < lastIndex; ++i) {
                    if (!SpaceGroup.SG[i].hmSymbolFull.equalsIgnoreCase(nameExt)) continue;
                    return i;
                }
                for (i = 0; i < lastIndex; ++i) {
                    s = SG[i];
                    if (s.hmSymbolAlternative == null || !s.hmSymbolAlternative.equalsIgnoreCase(nameExt)) continue;
                    return i;
                }
                if (haveExtension) {
                    for (i = 0; i < lastIndex; ++i) {
                        s = SG[i];
                        if (!s.hmSymbolAbbr.equalsIgnoreCase(abbr) || !s.hmSymbolExt.equalsIgnoreCase(ext) && !s.jmolIdExt.equalsIgnoreCase(ext)) continue;
                        return i;
                    }
                    for (i = 0; i < lastIndex; ++i) {
                        s = SG[i];
                        if (!s.hmSymbolAbbrShort.equalsIgnoreCase(abbr) || !s.hmSymbolExt.equalsIgnoreCase(ext) && !s.jmolIdExt.equalsIgnoreCase(ext)) continue;
                        return i;
                    }
                }
                char uniqueAxis = SpaceGroup.determineUniqueAxis(a, b, c, alpha, beta, gamma);
                if (haveExtension && ext.charAt(0) != '?') break;
                block28: for (i = 0; i < lastIndex; ++i) {
                    s = SG[i];
                    if (!s.hmSymbolAbbr.equalsIgnoreCase(abbr) && !s.hmSymbolAbbrShort.equalsIgnoreCase(abbr) && !s.itaNumber.equals(abbr)) continue;
                    switch (s.ambiguityType) {
                        case '\u0000': 
                        case '-': {
                            return i;
                        }
                        case 'a': {
                            if (s.uniqueAxis != uniqueAxis && uniqueAxis != '\u0000') continue block28;
                            return i;
                        }
                        case 'o': {
                            if (!(ext.length() == 0 ? s.hmSymbolExt.equals("2") : s.hmSymbolExt.equalsIgnoreCase(ext))) continue block28;
                            return i;
                        }
                        case 't': {
                            if (!(ext.length() == 0 ? s.axisChoice == 'h' : (s.axisChoice + PREFIX_SPACE).equalsIgnoreCase(ext))) continue block28;
                            return i;
                        }
                    }
                }
            }
        }
        if (ext.length() == 0) {
            for (i = 0; i < lastIndex; ++i) {
                s = SG[i];
                if (!s.itaNumber.equals(nameExt)) continue;
                return i;
            }
        }
        return -1;
    }

    private void setJmolCode(String name) {
        this.jmolId = name;
        String[] parts = PT.split(name, ":");
        this.itaNumber = parts[0];
        this.jmolIdExt = parts.length == 1 ? PREFIX_SPACE : parts[1];
        this.ambiguityType = '\u0000';
        if (this.jmolIdExt.length() > 0) {
            char c = this.jmolIdExt.charAt(0);
            if (this.jmolIdExt.equals("h") || this.jmolIdExt.equals("r")) {
                this.ambiguityType = (char)116;
                this.axisChoice = this.jmolIdExt.charAt(0);
            } else if (c == '1' || c == '2') {
                this.ambiguityType = (char)111;
            } else if (this.jmolIdExt.length() <= 2 || this.jmolIdExt.length() == 3 && c == '-') {
                this.ambiguityType = (char)97;
                this.uniqueAxis = this.jmolIdExt.charAt(c == '-' ? 1 : 0);
            } else if (this.jmolIdExt.contains("-")) {
                this.ambiguityType = (char)45;
            }
        }
    }

    private static final char determineUniqueAxis(float a, float b, float c, float alpha, float beta, float gamma) {
        if (a == b) {
            return b == c ? (char)'\u0000' : 'c';
        }
        if (b == c) {
            return 'a';
        }
        if (c == a) {
            return 'b';
        }
        if (alpha == beta) {
            return beta == gamma ? (char)'\u0000' : 'c';
        }
        if (beta == gamma) {
            return 'a';
        }
        if (gamma == alpha) {
            return 'b';
        }
        return '\u0000';
    }

    private void buildSelf(String sgLineData) {
        String info;
        String[] terms = PT.split(sgLineData.toLowerCase(), ";");
        this.jmolId = terms[0].trim();
        this.setJmolCode(this.jmolId);
        boolean isAlternate = this.jmolId.endsWith("*");
        if (isAlternate) {
            this.jmolId = this.jmolId.substring(0, this.jmolId.length() - 1);
        }
        this.itaIndex = terms[1].replace('|', ';');
        int pt = this.itaIndex.indexOf(".");
        if (pt < 0) {
            this.setNo = Integer.MAX_VALUE;
            pt = this.itaIndex.indexOf(":");
        } else {
            this.setNo = Integer.parseInt(this.itaIndex.substring(pt + 1));
        }
        this.itaNo = pt < 0 ? 0 : Integer.parseInt(this.itaIndex.substring(0, pt));
        String s = terms[2];
        this.itaTransform = s.length() == 0 || s.equals(SG_NONE) ? "a,b,c" : (s.equals("r") ? "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c" : PT.rep(s, "ab", SET_AB).replace('|', ';'));
        this.setClegId(this.itaNumber + ":" + this.itaTransform);
        if (terms[3].length() > 0) {
            this.nHallOperators = Integer.valueOf(terms[3]);
            Lst<SpaceGroup> lst = htByOpCount.get(this.nHallOperators);
            if (lst == null) {
                lst = new Lst();
                htByOpCount.put(this.nHallOperators, lst);
            }
            lst.addLast(this);
        }
        this.crystalClass = SpaceGroup.toCap(PT.split(terms[4], "^")[0], 1);
        String hm = terms[5];
        if (hm.endsWith("*")) {
            hm = hm.substring(0, hm.length() - 1);
        }
        this.setHMSymbol(hm);
        if ("xyz".equals(terms[6])) {
            info = this.hmSymbol;
            this.hallSymbol = PREFIX_SPACE + this.latticeType + "?";
        } else {
            this.hallSymbol = terms[6];
            if (this.hallSymbol.length() > 1) {
                this.hallSymbol = SpaceGroup.toCap(this.hallSymbol, 2);
            }
            if (isAlternate) {
                this.hallSymbolAlt = this.hallSymbol;
                this.hallSymbol = lastHallSymbol;
            }
            info = this.itaNumber + this.hallSymbol;
            if (this.itaNumber.charAt(0) != '0' && info.equals(lastInfo)) {
                isAlternate = true;
                ambiguousHMNames = ambiguousHMNames + this.hmSymbol + ";";
            }
        }
        lastHallSymbol = this.hallSymbol;
        lastInfo = info;
        this.name = "HM:" + this.hmSymbolFull + " " + (this.hallSymbol == null || this.hallSymbol == "?" ? "[" + this.hallSymbol + "]" : PREFIX_SPACE) + " #" + this.itaIndex;
    }

    void setHMSymbol(String name) {
        int pt = name.indexOf("#");
        if (pt >= 0) {
            name = name.substring(0, pt).trim();
        }
        this.hmSymbolFull = this.groupType == 0 ? SpaceGroup.toCap(name, 1) : name.toLowerCase();
        this.latticeType = Character.toUpperCase(this.hmSymbolFull.charAt(0));
        String[] parts = PT.split(this.hmSymbolFull, ":");
        this.hmSymbol = parts[0];
        this.hmSymbolExt = parts.length == 1 ? PREFIX_SPACE : parts[1];
        pt = this.hmSymbol.indexOf(" -3");
        if (pt >= 1 && "admn".indexOf(this.hmSymbol.charAt(pt - 1)) >= 0) {
            this.hmSymbolAlternative = (this.hmSymbol.substring(0, pt) + " 3" + this.hmSymbol.substring(pt + 3)).toLowerCase();
        }
        this.hmSymbolAbbr = PT.rep(this.hmSymbol, " ", PREFIX_SPACE);
        this.hmSymbolAbbrShort = this.hmSymbol.length() > 3 && this.hmSymbol.charAt(2) != '3' && this.hmSymbol.charAt(3) != '3' ? PT.rep(this.hmSymbol, " 1", PREFIX_SPACE) : this.hmSymbolAbbr;
        this.hmSymbolAbbrShort = PT.rep(this.hmSymbolAbbrShort, " ", PREFIX_SPACE);
        this.strName = null;
    }

    private static String toCap(String s, int n) {
        return s.substring(0, n).toUpperCase() + s.substring(n);
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        return this.strName == null ? (this.strName = this.jmolId == null || this.jmolId.equals("0") ? this.name : this.jmolId + " HM:" + this.hmSymbolFull + (this.getClegId() == null ? PREFIX_SPACE : " #" + this.getClegId())) : this.strName;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            String name = null;
            if (this.jmolId == null || SG_NONE.equals(this.hallSymbol)) {
                name = PREFIX_SPACE;
                if (this.hmSymbolFull != null && !SG_NONE.equals(this.hmSymbol)) {
                    name = this.hmSymbolFull;
                }
            } else if (!this.jmolId.equals("0")) {
                name = this.hmSymbolFull;
            }
            if (name == null) {
                name = "[" + this.hallSymbol + "]";
            } else if (this.getClegId() != null) {
                name = name + " #" + this.getClegId();
            }
            if (name.endsWith("2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c")) {
                name = PT.rep(name, "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c", "r");
            }
            if (name.indexOf(NO_NAME) >= 0) {
                name = PREFIX_SPACE;
            }
            if (name.endsWith(":a,b,c")) {
                name = name.substring(0, name.length() - 6);
            }
            this.displayName = name;
        }
        return this.displayName;
    }

    private static synchronized SpaceGroup[] getSpaceGroups() {
        if (SG == null) {
            int n = STR_SG.length;
            nameToGroup = new Hashtable<String, SpaceGroup>();
            SpaceGroup[] defs = new SpaceGroup[n];
            for (int i = 0; i < n; ++i) {
                defs[i] = new SpaceGroup(i, STR_SG[i], true);
                nameToGroup.put(defs[i].jmolId, defs[i]);
            }
            System.out.println("SpaceGroup - " + n + " settings generated");
            STR_SG = null;
            SG = defs;
        }
        return SG;
    }

    public boolean addMagLatticeVectors(Lst<float[]> lattvecs) {
        if (this.latticeOp >= 0 || lattvecs.size() == 0) {
            return false;
        }
        int nOps = this.latticeOp = this.operationCount;
        boolean isMagnetic = ((float[])lattvecs.get(0)).length == this.modDim + 4;
        int magRev = -2;
        for (int j = 0; j < lattvecs.size(); ++j) {
            float[] data = (float[])lattvecs.get(j);
            if (isMagnetic) {
                magRev = (int)data[this.modDim + 3];
                data = AU.arrayCopyF(data, this.modDim + 3);
            }
            if (data.length > this.modDim + 3) {
                return false;
            }
            for (int i = 0; i < nOps; ++i) {
                SymmetryOperation newOp = new SymmetryOperation(null, 0, true);
                newOp.modDim = this.modDim;
                SymmetryOperation op = this.symmetryOperations[i];
                newOp.divisor = op.divisor;
                newOp.linearRotTrans = AU.arrayCopyF(op.linearRotTrans, -1);
                newOp.setFromMatrix(data, false);
                if (magRev != -2) {
                    newOp.setTimeReversal(op.timeReversal * magRev);
                }
                newOp.xyzOriginal = newOp.xyz;
                this.addOp(newOp, newOp.xyz, true);
            }
        }
        return true;
    }

    public boolean addSpinLattice(Lst<String> lstSpinFrames) {
        if (this.latticeOp >= 0 || lstSpinFrames.size() == 0) {
            return false;
        }
        this.latticeOp = this.operationCount;
        for (int j = 0; j < lstSpinFrames.size(); ++j) {
            String frameXyzUvw = (String)lstSpinFrames.get(j);
            if (frameXyzUvw.equals("x,y,z(u,v,w)")) continue;
            int nOps = this.operationCount;
            SymmetryOperation latticeOp = new SymmetryOperation(null, 0, true);
            latticeOp.setMatrixFromXYZ(frameXyzUvw, 0, false);
            latticeOp.doFinalize();
            for (int i = 0; i < nOps; ++i) {
                M4 spinU;
                SymmetryOperation op = this.symmetryOperations[i];
                op.doFinalize();
                SymmetryOperation newOp = new SymmetryOperation(op, 0, true);
                newOp.doFinalize();
                newOp.mul(latticeOp);
                if (op.spinU == null) {
                    spinU = new M4();
                    spinU.setIdentity();
                } else {
                    spinU = M4.newM4(op.spinU);
                }
                if (latticeOp.spinU != null) {
                    spinU.mul(latticeOp.spinU);
                }
                newOp.modDim = this.modDim;
                newOp.divisor = op.divisor;
                String xyz = SymmetryOperation.getXYZFromMatrix(newOp, false, true, false) + SymmetryOperation.getSpecialString(spinU, "u", "v", "w");
                newOp.setMatrixFromXYZ(xyz, this.modDim, false);
                this.addOperation(xyz, nOps + i, false);
                this.symmetryOperations[nOps + i].doFinalize();
            }
        }
        return true;
    }

    int getSiteMultiplicity(P3 pt, UnitCell unitCell) {
        int n = this.finalOperations.length;
        Lst<P3> pts = new Lst<P3>();
        int i = n;
        while (--i >= 0) {
            P3 pt1 = P3.newP(pt);
            this.finalOperations[i].rotTrans(pt1);
            unitCell.unitize(pt1);
            int j = pts.size();
            while (--j >= 0) {
                P3 pt0 = (P3)pts.get(j);
                if (!(pt1.distanceSquared(pt0) < 1.96E-6f)) continue;
                pt1 = null;
                break;
            }
            if (pt1 == null) continue;
            pts.addLast(pt1);
        }
        return n / pts.size();
    }

    void setName(String name) {
        this.name = name;
        if (name != null && name.startsWith("HM:")) {
            this.setHMSymbol(name.substring(3));
        }
        this.displayName = null;
        this.strName = null;
    }

    static SpaceGroup getSpaceGroupFromJmolClegOrITA(Viewer vwr, String name) {
        int specialType = SpaceGroup.getExplicitSpecialGroupType(name);
        if (specialType > 0) {
            return Symmetry.getSGFactory().getSpecialGroup(null, vwr, name, specialType);
        }
        int ptCleg = name.indexOf(":");
        int ptTrm = name.indexOf(",");
        int ptIndex = name.indexOf(".");
        int pt = ptCleg > 0 && ptTrm > ptCleg ? ptCleg : ptIndex;
        int n = SG.length;
        if (pt > 0 && pt == ptCleg) {
            for (int i = 0; i < n; ++i) {
                if (!name.equals(SpaceGroup.SG[i].clegId)) continue;
                return SG[i];
            }
        } else if (ptCleg > 0) {
            for (int i = 0; i < n; ++i) {
                if (!name.equals(SpaceGroup.SG[i].jmolId)) continue;
                return SG[i];
            }
        } else if (ptIndex > 0) {
            for (int i = 0; i < n; ++i) {
                if (!name.equals(SpaceGroup.SG[i].itaIndex)) continue;
                return SG[i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!name.equals(SpaceGroup.SG[i].itaNumber)) continue;
                return SG[i];
            }
        }
        return null;
    }

    void checkHallOperators() {
        if (this.nHallOperators != null && this.nHallOperators != this.operationCount) {
            if (this.hallInfo == null || this.hallInfo.isGenerated()) {
                this.generateMatrixOperators(this.hallInfo);
            } else {
                this.init(false);
                this.doNormalize = true;
                SpaceGroup.transformSpaceGroup(0, this, SpaceGroup.getSpaceGroupFromJmolClegOrITA(null, this.itaNumber), null, this.itaTransform, null);
                this.hallInfo = null;
            }
        }
    }

    M4[] getOpsCtr(String transform) {
        SpaceGroup sg = SpaceGroup.getNull(true, true, false);
        SpaceGroup.transformSpaceGroup(this.groupType, sg, this, null, "!" + transform, null);
        sg.setFinalOperations();
        SpaceGroup sg2 = SpaceGroup.getNull(true, false, false);
        SpaceGroup.transformSpaceGroup(this.groupType, sg2, sg, null, transform, null);
        sg2.setFinalOperations();
        return sg2.finalOperations;
    }

    static SpaceGroup getSpaceGroupFromIndex(int i) {
        return SG != null && i >= 0 && i < SG.length ? SG[i] : null;
    }

    void setITATableNames(String jmolId, String sg, String set, String tr) {
        this.itaNumber = sg;
        this.itaIndex = tr != null ? sg + ":" + tr : (set.indexOf(".") >= 0 ? set : sg + "." + set);
        this.itaTransform = tr;
        this.setClegId(this.specialPrefix + sg + ":" + tr);
        this.displayName = null;
        this.strName = null;
        this.jmolId = jmolId;
        if (jmolId == null) {
            this.name = this.clegId;
            this.info = this.dumpInfoObj();
        } else {
            this.setJmolCode(jmolId);
        }
    }

    static Lst<Object> transformCoords(Lst<Object> coord, M4 trmInv, P3 centering, M4 t, float[] v, Lst<Object> coordt) {
        if (coordt == null) {
            coordt = new Lst();
        }
        int n = coord.size();
        for (int j = 0; j < n; ++j) {
            String xyz = SymmetryOperation.transformStr((String)coord.get(j), null, trmInv, t, v, null, centering, true, true);
            if (coordt.contains(xyz)) continue;
            coordt.addLast(xyz);
        }
        return coordt;
    }

    static float[][] getTransformRange(M4 trm) {
        float[][] t = new float[2][3];
        float[] row = new float[4];
        for (int i = 0; i < 3; ++i) {
            trm.getRow(i, row);
            for (int j = 0; j < 3; ++j) {
                float v = row[j];
                if (v < 0.0f) {
                    float[] fArray = t[0];
                    int n = i;
                    fArray[n] = fArray[n] + -row[j];
                    continue;
                }
                if (!(v > 0.0f)) continue;
                float[] fArray = t[1];
                int n = i;
                fArray[n] = fArray[n] + row[j];
            }
        }
        boolean ignore = true;
        int i = 0;
        int dz = 0;
        while (i < 2) {
            for (int j = 0; j < 3; ++j) {
                int d = (int)Math.ceil(t[i][j]);
                if (d > dz) {
                    ignore = false;
                }
                t[i][j] = i == 0 ? -d : d;
            }
            ++i;
            ++dz;
        }
        return ignore ? (float[][])null : t;
    }

    private static M4 getTransformedCentering(M4 trm, Lst<Object> cent) {
        M4 trmInv = M4.newM4(trm);
        trmInv.invert();
        int n0 = cent.size();
        P3 pc = new P3();
        P3 p = new P3();
        float[][] c = SpaceGroup.getTransformRange(trm);
        if (c != null) {
            int n = SpaceGroup.addCentering(trmInv, c, pc, p, cent, 0);
            int i = n0;
            while (--i >= 0 && n < 3) {
                SymmetryOperation.toPoint((String)cent.remove(i), pc);
                n = SpaceGroup.addCentering(trmInv, c, pc, p, cent, n);
            }
        }
        return trmInv;
    }

    private static int addCentering(M4 trmInv, float[][] c, P3 pc, P3 p, Lst<Object> cent, int n) {
        int i = (int)c[0][0];
        while ((float)i <= c[1][0]) {
            int j = (int)c[0][1];
            while ((float)j <= c[1][1]) {
                int k = (int)c[0][2];
                while ((float)k <= c[1][2]) {
                    p.set(i, j, k);
                    p.add(pc);
                    trmInv.rotTrans(p);
                    if (p.length() % 1.0f != 0.0f) {
                        p.x %= 1.0f;
                        p.y %= 1.0f;
                        p.z %= 1.0f;
                        String s = SymmetryOperation.norm3(p);
                        if (!s.equals("0,0,0") && !cent.contains(s)) {
                            cent.addLast(s);
                            if (++n == 3) {
                                return 3;
                            }
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return n;
    }

    static Map<String, Object> fillMoreData(Viewer vwr, Map<String, Object> map, String clegId, int itno, Map<String, Object> its0) {
        int pt = clegId.indexOf(58);
        String transform = pt < 0 ? "a,b,c" : clegId.substring(pt + 1);
        M4 trm = UnitCell.toTrm(transform, null);
        Lst gp0 = (Lst)its0.get("gp");
        Map wpos0 = (Map)its0.get("wpos");
        Lst cent0 = (Lst)wpos0.get("cent");
        Lst<Object> cent = new Lst<Object>();
        if (cent0 != null) {
            cent.addAll(cent0);
        }
        int nctr0 = cent.size();
        M4 trmInv = SpaceGroup.getTransformedCentering(trm, cent);
        int nctr = cent.size();
        Lst pos0 = (Lst)wpos0.get("pos");
        Lst pos = new Lst();
        M4 t = new M4();
        float[] v = new float[16];
        float f = ((float)nctr + 1.0f) / (float)(nctr0 + 1);
        int n = pos0.size();
        for (int i = 0; i < n; ++i) {
            Map p0 = (Map)pos0.get(i);
            Hashtable<String, Serializable> p = new Hashtable<String, Serializable>();
            p.putAll(p0);
            Lst<Object> coord = (Lst<Object>)p0.get("coord");
            if (coord != null) {
                coord = SpaceGroup.transformCoords(coord, trmInv, null, t, v, null);
                p.put("coord", coord);
            }
            int mult = (Integer)p0.get("mult");
            p.put("mult", Integer.valueOf((int)((float)mult * f)));
            pos.addLast(p);
        }
        Lst<Object> gp = new Lst<Object>();
        SpaceGroup.transformCoords(gp0, trmInv, null, t, v, gp);
        if (nctr > 0) {
            for (int i = 0; i < nctr; ++i) {
                P3 p = new P3();
                SpaceGroup.transformCoords(gp0, trmInv, SymmetryOperation.toPoint((String)cent.get(i), p), t, v, gp);
            }
        }
        if (map == null) {
            map = new Hashtable<String, Object>();
            map.put("sg", itno);
            map.put("trm", transform);
            map.put("clegId", itno + ":" + transform);
            map.put("det", Float.valueOf(trm.determinant3()));
        } else {
            map.remove("more");
        }
        Hashtable<String, Lst<Object>> wpos = new Hashtable<String, Lst<Object>>();
        if (nctr > 0) {
            wpos.put("cent", cent);
        }
        wpos.put("pos", pos);
        map.put("wpos", wpos);
        gp = new Lst();
        SpaceGroup base = SpaceGroup.getSpaceGroupFromJmolClegOrITA(vwr, clegId);
        SpaceGroup sg = SpaceGroup.transformSpaceGroup(0, null, base, gp0, transform, new M4());
        int n2 = sg.getOperationCount();
        for (int i = 0; i < n2; ++i) {
            gp.addLast(((SymmetryOperation)sg.getOperation((int)i)).xyz);
        }
        map.put("gp", gp);
        return map;
    }

    static SpaceGroup transformSpaceGroup(int groupType, SpaceGroup sg, SpaceGroup base, Lst<Object> genPos, String transform, M4 trm) {
        if (genPos == null) {
            base.setFinalOperationsSafely();
            genPos = new Lst();
            int n = base.getOperationCount();
            for (int i = 0; i < n; ++i) {
                genPos.addLast(base.getXyz(i, false));
            }
        }
        boolean normalize = sg == null || sg.doNormalize;
        Lst<Object> xyzList = SpaceGroup.addTransformXYZList(sg, genPos, transform, trm, normalize);
        if (sg == null) {
            return SpaceGroup.createITASpaceGroup(groupType, xyzList, base);
        }
        if (transform == null) {
            sg.setFrom(base, true);
        } else {
            sg.setITATableNames(sg.jmolId, sg.itaNumber, "1", transform);
        }
        return sg;
    }

    static SpaceGroup createITASpaceGroup(int groupType, Lst<Object> genpos, SpaceGroup base) {
        SpaceGroup sg = groupType == 0 ? new SpaceGroup(-1, NEW_NO_HALL_GROUP, true) : Symmetry.getSGFactory().createSpecialGroup((SpecialGroup)base, null, null, groupType);
        sg.doNormalize = false;
        int n = genpos.size();
        for (int i = 0; i < n; ++i) {
            SymmetryOperation op = new SymmetryOperation(null, i, false);
            String xyz = (String)genpos.get(i);
            op.setMatrixFromXYZ(xyz, 0, false);
            sg.addOp(op, xyz, false);
        }
        if (base != null) {
            sg.setFrom(base, true);
        }
        sg.setFinalOperationsSafely();
        return sg;
    }

    private static Lst<Object> addTransformXYZList(SpaceGroup sg, Lst<Object> genPos, String transform, M4 trm, boolean normalize) {
        M4 trmInv = null;
        M4 t = null;
        float[] v = null;
        float[][] c = null;
        int nTotal = genPos.size();
        if (transform != null) {
            if (transform.equals("r")) {
                transform = "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c";
            }
            trm = UnitCell.toTrm(transform, trm);
            trmInv = M4.newM4(trm);
            trmInv.invert();
            int det = Math.round(trm.determinant3());
            if (det > 1) {
                c = SpaceGroup.getTransformRange(trm);
                nTotal *= det;
            }
            v = new float[16];
            t = new M4();
        }
        Lst<Object> xyzList = SpaceGroup.addTransformedOperations(sg, genPos, trm, trmInv, t, v, sg == null ? new Lst<Object>() : null, null, normalize);
        if (c != null) {
            P3 p = new P3();
            int k = (int)c[0][2];
            while ((float)k <= c[1][2]) {
                int j = (int)c[0][1];
                while ((float)j <= c[1][1]) {
                    int i = (int)c[0][0];
                    while ((float)i < c[1][0]) {
                        if (i != 0 || j != 0 || k != 0) {
                            p.set(i, j, k);
                            if (SpaceGroup.addTransformedOperations(sg, genPos, trm, trmInv, t, v, xyzList, p, normalize) != null && xyzList.size() == nTotal) {
                                return xyzList;
                            }
                        }
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
        }
        return sg == null ? xyzList : null;
    }

    private static Lst<Object> addTransformedOperations(SpaceGroup sg, Lst<Object> genPos, M4 trm, M4 trmInv, M4 t, float[] v, Lst<Object> retGenPos, P3 centering, boolean normalize) {
        if (sg != null) {
            sg.latticeOp = 0;
        }
        int c = genPos.size();
        for (int i = 0; i < c; ++i) {
            String xyz = (String)genPos.get(i);
            if (trm != null && (i > 0 || centering != null)) {
                xyz = SymmetryOperation.transformStr(xyz, trm, trmInv, t, v, centering, null, normalize, false);
            }
            if (sg != null) {
                sg.addOperation(xyz, 0, false);
                continue;
            }
            if (retGenPos.contains(xyz)) continue;
            retGenPos.addLast(xyz);
        }
        return retGenPos;
    }

    @Override
    public M4 getMatrixOperation(int i) {
        return this.symmetryOperations[i];
    }

    @Override
    public int getMatrixOperationCount() {
        return this.operationCount;
    }

    @Override
    public boolean addHallOperationCheckDuplicates(M4 operation) {
        String xyz = SymmetryOperation.getXYZFromMatrix(operation, true, true, false);
        if (this.checkXYZlist(xyz) >= 0) {
            return false;
        }
        this.addSymmetrySM("!nohalf!" + xyz, operation);
        return true;
    }

    public static String canonicalizeCleg(String t) {
        if (t.indexOf(":") < 0) {
            t = t + ":a,b,c;0,0,0";
        } else if (t.indexOf(",") > 0 && t.indexOf(";") < 0) {
            t = t + ";0,0,0";
        }
        return t;
    }

    static String convertWyckoffHMCleg(String hmName, String cleg) {
        if (HMtoCleg == null) {
            HMtoCleg = new Hashtable();
            ClegtoHM = new Hashtable();
            int i = moreSettings.length;
            while (--i >= 0) {
                String c = moreSettings[i];
                String h = moreSettings[--i];
                h = PT.rep(h, " ", PREFIX_SPACE);
                ClegtoHM.put(c, h);
                HMtoCleg.put(h, c);
            }
        }
        return hmName != null ? HMtoCleg.get(PT.rep(hmName, " ", PREFIX_SPACE)) : ClegtoHM.get(cleg);
    }

    public String getHMName() {
        return this.hmSymbol;
    }

    public Object getHMNameShort() {
        System.out.println(this.clegId + "\t" + this.hmSymbolFull + "\t" + this.hmSymbolAbbr + "\t" + this.hmSymbolAbbrShort);
        return this.hmSymbolAbbrShort == null ? this.hmSymbol : this.hmSymbolAbbrShort;
    }

    public static int getITNo(String name, int n) {
        if (n <= 0) {
            n = name.length();
        }
        int i = n;
        while (--i >= 0) {
            if (PT.isDigit(name.charAt(i))) continue;
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(name.substring(0, n));
    }

    public static boolean isInRange(float itno, int groupType, boolean allowSetIndex, boolean allow300) {
        int max = SpaceGroup.getMax(groupType);
        switch (groupType) {
            case 0: {
                if (!allow300) break;
                int i = (int)itno;
                int type = SpaceGroup.getImplicitSpecialGroupType(i);
                if (type == 300) {
                    allowSetIndex = false;
                }
                return type != -1 && (allowSetIndex || (float)i == itno);
            }
            case 300: {
                allowSetIndex = false;
                break;
            }
        }
        return itno >= 1.0f && (allowSetIndex ? itno < (float)(max + 1) : itno <= (float)max);
    }

    public static int getMax(int groupType) {
        switch (groupType) {
            case 0: {
                return 230;
            }
            case 300: {
                return 17;
            }
            case 400: {
                return 80;
            }
            case 500: {
                return 75;
            }
            case 600: {
                return 7;
            }
        }
        return 0;
    }

    public static String getGroupTypePrefix(int itno) {
        itno -= itno % 100;
        switch (itno) {
            case 0: {
                return PREFIX_SPACE;
            }
            case 300: {
                return PREFIX_PLANE;
            }
            case 400: {
                return PREFIX_LAYER;
            }
            case 500: {
                return PREFIX_ROD;
            }
            case 600: {
                return PREFIX_FRIEZE;
            }
        }
        return PREFIX_SPACE;
    }

    public static int getExplicitSpecialGroupType(String name) {
        if (name.length() < 2 || name.charAt(1) != '/') {
            return 0;
        }
        switch (name.substring(0, 2)) {
            case "p/": {
                return 300;
            }
            case "l/": {
                return 400;
            }
            case "r/": {
                return 500;
            }
            case "f/": {
                return 600;
            }
        }
        return -1;
    }

    public static String getSpecialGroupName(int type) {
        switch (type) {
            case 0: {
                return PREFIX_SPACE;
            }
            case 300: {
                return "plane";
            }
            case 400: {
                return "layer";
            }
            case 500: {
                return "rod";
            }
            case 600: {
                return "frieze";
            }
        }
        return null;
    }

    public static int getImplicitSpecialGroupType(int itno) {
        if (itno < 1) {
            return -1;
        }
        if (itno <= 230) {
            return 0;
        }
        if (itno > 300 && itno <= 317) {
            return 300;
        }
        if (itno > 400 && itno <= 480) {
            return 400;
        }
        if (itno > 500 && itno <= 575) {
            return 500;
        }
        if (itno > 600 && itno <= 607) {
            return 600;
        }
        return -1;
    }

    public static boolean hmMatches(String hm, String name, int specialType) {
        if (hm.charAt(1) == '/') {
            hm = hm.substring(2);
        }
        if (hm.charAt(0) != name.charAt(0)) {
            return false;
        }
        if (name.indexOf(32) < 0) {
            hm = PT.rep(hm, " ", PREFIX_SPACE);
        }
        if (hm.equals(name)) {
            return true;
        }
        if (specialType == 300) {
            int n = hm.length();
            if (n <= name.length()) {
                return false;
            }
            char c = name.charAt(1);
            switch (name.length()) {
                case 2: {
                    return n == 4 && hm.charAt(1) == '1' && c == hm.charAt(2);
                }
                case 3: {
                    char c2 = hm.charAt(1);
                    return c2 == '2' ? hm.charAt(2) == c && hm.charAt(3) == name.charAt(2) : hm.charAt(n - 1) == 'm' && hm.startsWith(name);
                }
            }
        }
        return false;
    }

    public boolean createCompatibleUnitCell(float[] params, float[] newParams, boolean allowSame) {
        int n = this.itaNumber == null ? 0 : PT.parseInt(this.itaNumber);
        boolean toHex = false;
        boolean isHex = false;
        boolean toRhom = false;
        boolean isRhom = false;
        toHex = n != 0 && this.isHexagonalSG(n, null);
        isHex = toHex && this.isHexagonalSG(-1, params);
        toRhom = n != 0 && this.axisChoice == 'r';
        boolean bl = isRhom = toRhom && SimpleUnitCell.isRhombohedral(params);
        if (toHex && isHex || toRhom && isRhom) {
            allowSame = true;
        }
        ParamCheck pc = new ParamCheck(params, allowSame, true);
        if (n > (allowSame ? 2 : 0)) {
            if (toHex) {
                if (!(!toRhom ? isHex : isRhom)) {
                    if (this.axisChoice == 'r') {
                        pc.c = pc.b = pc.a;
                        if (!allowSame && pc.alpha > 85.0f && pc.alpha < 95.0f) {
                            pc.alpha = 80.0f;
                        }
                        pc.gamma = pc.beta = pc.alpha;
                    } else {
                        pc.b = pc.a;
                        pc.beta = 90.0f;
                        pc.alpha = 90.0f;
                        pc.gamma = 120.0f;
                    }
                }
            } else if (n >= 195) {
                pc.c = pc.b = pc.a;
                pc.gamma = 90.0f;
                pc.beta = 90.0f;
                pc.alpha = 90.0f;
            } else if (n >= 75) {
                pc.b = pc.a;
                if (pc.acsame && !allowSame) {
                    pc.c = pc.a * 1.5f;
                }
                pc.gamma = 90.0f;
                pc.beta = 90.0f;
                pc.alpha = 90.0f;
            } else if (n >= 16) {
                pc.gamma = 90.0f;
                pc.beta = 90.0f;
                pc.alpha = 90.0f;
            } else if (n >= 3) {
                switch (this.uniqueAxis) {
                    case 'a': {
                        pc.gamma = 90.0f;
                        pc.beta = 90.0f;
                        break;
                    }
                    default: {
                        pc.gamma = 90.0f;
                        pc.alpha = 90.0f;
                        break;
                    }
                    case 'c': {
                        pc.beta = 90.0f;
                        pc.alpha = 90.0f;
                    }
                }
            }
        }
        return pc.checkNew(params, newParams == null ? params : newParams);
    }

    public boolean isHexagonalSG(int n, float[] params) {
        return n < 1 ? SimpleUnitCell.isHexagonal(params) : n >= 143 && n <= 194;
    }

    static {
        sgIndex = -1;
        ambiguousHMNames = PREFIX_SPACE;
        lastHallSymbol = PREFIX_SPACE;
        htByOpCount = new Hashtable<Integer, Lst<SpaceGroup>>();
        nSG = 0;
        STR_SG = new String[]{"1;1.1;;1;c1^1;p 1;p 1", "2;2.1;;2;ci^1;p -1;-p 1", "3:b;3.1;;2;c2^1;p 1 2 1;p 2y", "3:b;3.1;;2;c2^1;p 2;p 2y", "3:c;3.2;c,a,b;2;c2^1;p 1 1 2;p 2", "3:a;3.3;b,c,a;2;c2^1;p 2 1 1;p 2x", "4:b;4.1;;2;c2^2;p 1 21 1;p 2yb", "4:b;4.1;;2;c2^2;p 21;p 2yb", "4:c;4.2;c,a,b;2;c2^2;p 1 1 21;p 2c", "4:a;4.3;b,c,a;2;c2^2;p 21 1 1;p 2xa", "5:b1;5.1;;4;c2^3;c 1 2 1;c 2y", "5:b1;5.1;;4;c2^3;c 2;c 2y", "5:b2;5.2;-a-c,b,a;4;c2^3;a 1 2 1;a 2y", "5:b3;5.3;c,b,-a-c;4;c2^3;i 1 2 1;i 2y", "5:c1;5.4;c,a,b;4;c2^3;a 1 1 2;a 2", "5:c2;5.5;a,-a-c,b;4;c2^3;b 1 1 2;b 2", "5:c3;5.6;-a-c,c,b;4;c2^3;i 1 1 2;i 2", "5:a1;5.7;b,c,a;4;c2^3;b 2 1 1;b 2x", "5:a2;5.8;b,a,-a-c;4;c2^3;c 2 1 1;c 2x", "5:a3;5.9;b,-a-c,c;4;c2^3;i 2 1 1;i 2x", "6:b;6.1;;2;cs^1;p 1 m 1;p -2y", "6:b;6.1;;2;cs^1;p m;p -2y", "6:c;6.2;c,a,b;2;cs^1;p 1 1 m;p -2", "6:a;6.3;b,c,a;2;cs^1;p m 1 1;p -2x", "7:b1;7.1;;2;cs^2;p 1 c 1;p -2yc", "7:b1;7.1;;2;cs^2;p c;p -2yc", "7:b2;7.2;-a-c,b,a;2;cs^2;p 1 n 1;p -2yac", "7:b2;7.2;-a-c,b,a;2;cs^2;p n;p -2yac", "7:b3;7.3;c,b,-a-c;2;cs^2;p 1 a 1;p -2ya", "7:b3;7.3;c,b,-a-c;2;cs^2;p a;p -2ya", "7:c1;7.4;c,a,b;2;cs^2;p 1 1 a;p -2a", "7:c2;7.5;a,-a-c,b;2;cs^2;p 1 1 n;p -2ab", "7:c3;7.6;-a-c,c,b;2;cs^2;p 1 1 b;p -2b", "7:a1;7.7;b,c,a;2;cs^2;p b 1 1;p -2xb", "7:a2;7.8;b,a,-a-c;2;cs^2;p n 1 1;p -2xbc", "7:a3;7.9;b,-a-c,c;2;cs^2;p c 1 1;p -2xc", "8:b1;8.1;;4;cs^3;c 1 m 1;c -2y", "8:b1;8.1;;4;cs^3;c m;c -2y", "8:b2;8.2;-a-c,b,a;4;cs^3;a 1 m 1;a -2y", "8:b3;8.3;c,b,-a-c;4;cs^3;i 1 m 1;i -2y", "8:b3;8.3;c,b,-a-c;4;cs^3;i m;i -2y", "8:c1;8.4;c,a,b;4;cs^3;a 1 1 m;a -2", "8:c2;8.5;a,-a-c,b;4;cs^3;b 1 1 m;b -2", "8:c3;8.6;-a-c,c,b;4;cs^3;i 1 1 m;i -2", "8:a1;8.7;b,c,a;4;cs^3;b m 1 1;b -2x", "8:a2;8.8;b,a,-a-c;4;cs^3;c m 1 1;c -2x", "8:a3;8.9;b,-a-c,c;4;cs^3;i m 1 1;i -2x", "9:b1;9.1;;4;cs^4;c 1 c 1;c -2yc", "9:b1;9.1;;4;cs^4;c c;c -2yc", "9:b2;9.2;-a-c,b,a;4;cs^4;a 1 n 1;a -2yab", "9:b3;9.3;c,b,-a-c;4;cs^4;i 1 a 1;i -2ya", "9:-b1;9.4;c,-b,a;4;cs^4;a 1 a 1;a -2ya", "9:-b2;9.5;a,-b,-a-c;4;cs^4;c 1 n 1;c -2yac", "9:-b3;9.6;-a-c,-b,c;4;cs^4;i 1 c 1;i -2yc", "9:c1;9.7;c,a,b;4;cs^4;a 1 1 a;a -2a", "9:c2;9.8;a,-a-c,b;4;cs^4;b 1 1 n;b -2ab", "9:c3;9.9;-a-c,c,b;4;cs^4;i 1 1 b;i -2b", "9:-c1;9.10;a,c,-b;4;cs^4;b 1 1 b;b -2b", "9:-c2;9.11;-a-c,a,-b;4;cs^4;a 1 1 n;a -2ab", "9:-c3;9.12;c,-a-c,-b;4;cs^4;i 1 1 a;i -2a", "9:a1;9.13;b,c,a;4;cs^4;b b 1 1;b -2xb", "9:a2;9.14;b,a,-a-c;4;cs^4;c n 1 1;c -2xac", "9:a3;9.15;b,-a-c,c;4;cs^4;i c 1 1;i -2xc", "9:-a1;9.16;-b,a,c;4;cs^4;c c 1 1;c -2xc", "9:-a2;9.17;-b,-a-c,a;4;cs^4;b n 1 1;b -2xab", "9:-a3;9.18;-b,c,-a-c;4;cs^4;i b 1 1;i -2xb", "10:b;10.1;;4;c2h^1;p 1 2/m 1;-p 2y", "10:b;10.1;;4;c2h^1;p 2/m;-p 2y", "10:c;10.2;c,a,b;4;c2h^1;p 1 1 2/m;-p 2", "10:a;10.3;b,c,a;4;c2h^1;p 2/m 1 1;-p 2x", "11:b;11.1;;4;c2h^2;p 1 21/m 1;-p 2yb", "11:b;11.1;;4;c2h^2;p 21/m;-p 2yb", "11:c;11.2;c,a,b;4;c2h^2;p 1 1 21/m;-p 2c", "11:a;11.3;b,c,a;4;c2h^2;p 21/m 1 1;-p 2xa", "12:b1;12.1;;8;c2h^3;c 1 2/m 1;-c 2y", "12:b1;12.1;;8;c2h^3;c 2/m;-c 2y", "12:b2;12.2;-a-c,b,a;8;c2h^3;a 1 2/m 1;-a 2y", "12:b3;12.3;c,b,-a-c;8;c2h^3;i 1 2/m 1;-i 2y", "12:b3;12.3;c,b,-a-c;8;c2h^3;i 2/m;-i 2y", "12:c1;12.4;c,a,b;8;c2h^3;a 1 1 2/m;-a 2", "12:c2;12.5;a,-a-c,b;8;c2h^3;b 1 1 2/m;-b 2", "12:c3;12.6;-a-c,c,b;8;c2h^3;i 1 1 2/m;-i 2", "12:a1;12.7;b,c,a;8;c2h^3;b 2/m 1 1;-b 2x", "12:a2;12.8;b,a,-a-c;8;c2h^3;c 2/m 1 1;-c 2x", "12:a3;12.9;b,-a-c,c;8;c2h^3;i 2/m 1 1;-i 2x", "13:b1;13.1;;4;c2h^4;p 1 2/c 1;-p 2yc", "13:b1;13.1;;4;c2h^4;p 2/c;-p 2yc", "13:b2;13.2;-a-c,b,a;4;c2h^4;p 1 2/n 1;-p 2yac", "13:b2;13.2;-a-c,b,a;4;c2h^4;p 2/n;-p 2yac", "13:b3;13.3;c,b,-a-c;4;c2h^4;p 1 2/a 1;-p 2ya", "13:b3;13.3;c,b,-a-c;4;c2h^4;p 2/a;-p 2ya", "13:c1;13.4;c,a,b;4;c2h^4;p 1 1 2/a;-p 2a", "13:c2;13.5;a,-a-c,b;4;c2h^4;p 1 1 2/n;-p 2ab", "13:c3;13.6;-a-c,c,b;4;c2h^4;p 1 1 2/b;-p 2b", "13:a1;13.7;b,c,a;4;c2h^4;p 2/b 1 1;-p 2xb", "13:a2;13.8;b,a,-a-c;4;c2h^4;p 2/n 1 1;-p 2xbc", "13:a3;13.9;b,-a-c,c;4;c2h^4;p 2/c 1 1;-p 2xc", "14:b1;14.1;;4;c2h^5;p 1 21/c 1;-p 2ybc", "14:b1;14.1;;4;c2h^5;p 21/c;-p 2ybc", "14:b2;14.2;-a-c,b,a;4;c2h^5;p 1 21/n 1;-p 2yn", "14:b2;14.2;-a-c,b,a;4;c2h^5;p 21/n;-p 2yn", "14:b3;14.3;c,b,-a-c;4;c2h^5;p 1 21/a 1;-p 2yab", "14:b3;14.3;c,b,-a-c;4;c2h^5;p 21/a;-p 2yab", "14:c1;14.4;c,a,b;4;c2h^5;p 1 1 21/a;-p 2ac", "14:c2;14.5;a,-a-c,b;4;c2h^5;p 1 1 21/n;-p 2n", "14:c3;14.6;-a-c,c,b;4;c2h^5;p 1 1 21/b;-p 2bc", "14:a1;14.7;b,c,a;4;c2h^5;p 21/b 1 1;-p 2xab", "14:a2;14.8;b,a,-a-c;4;c2h^5;p 21/n 1 1;-p 2xn", "14:a3;14.9;b,-a-c,c;4;c2h^5;p 21/c 1 1;-p 2xac", "15:b1;15.1;;8;c2h^6;c 1 2/c 1;-c 2yc", "15:b1;15.1;;8;c2h^6;c 2/c;-c 2yc", "15:b2;15.2;-a-c,b,a;8;c2h^6;a 1 2/n 1;-a 2yab", "15:b3;15.3;c,b,-a-c;8;c2h^6;i 1 2/a 1;-i 2ya", "15:b3;15.3;c,b,-a-c;8;c2h^6;i 2/a;-i 2ya", "15:-b1;15.4;c,-b,a;8;c2h^6;a 1 2/a 1;-a 2ya", "15:-b2;15.5;a,-b,-a-c;8;c2h^6;c 1 2/n 1;-c 2yac", "15:-b2;15.5;a,-b,-a-c;8;c2h^6;c 2/n;-c 2yac", "15:-b3;15.6;-a-c,-b,c;8;c2h^6;i 1 2/c 1;-i 2yc", "15:-b3;15.6;-a-c,-b,c;8;c2h^6;i 2/c;-i 2yc", "15:c1;15.7;c,a,b;8;c2h^6;a 1 1 2/a;-a 2a", "15:c2;15.8;a,-a-c,b;8;c2h^6;b 1 1 2/n;-b 2ab", "15:c3;15.9;-a-c,c,b;8;c2h^6;i 1 1 2/b;-i 2b", "15:-c1;15.10;a,c,-b;8;c2h^6;b 1 1 2/b;-b 2b", "15:-c2;15.11;-a-c,a,-b;8;c2h^6;a 1 1 2/n;-a 2ab", "15:-c3;15.12;c,-a-c,-b;8;c2h^6;i 1 1 2/a;-i 2a", "15:a1;15.13;b,c,a;8;c2h^6;b 2/b 1 1;-b 2xb", "15:a2;15.14;b,a,-a-c;8;c2h^6;c 2/n 1 1;-c 2xac", "15:a3;15.15;b,-a-c,c;8;c2h^6;i 2/c 1 1;-i 2xc", "15:-a1;15.16;-b,a,c;8;c2h^6;c 2/c 1 1;-c 2xc", "15:-a2;15.17;-b,-a-c,a;8;c2h^6;b 2/n 1 1;-b 2xab", "15:-a3;15.18;-b,c,-a-c;8;c2h^6;i 2/b 1 1;-i 2xb", "16;16.1;;4;d2^1;p 2 2 2;p 2 2", "17;17.1;;4;d2^2;p 2 2 21;p 2c 2", "17:cab;17.2;c,a,b;4;d2^2;p 21 2 2;p 2a 2a", "17:bca;17.3;b,c,a;4;d2^2;p 2 21 2;p 2 2b", "18;18.1;;4;d2^3;p 21 21 2;p 2 2ab", "18:cab;18.2;c,a,b;4;d2^3;p 2 21 21;p 2bc 2", "18:bca;18.3;b,c,a;4;d2^3;p 21 2 21;p 2ac 2ac", "19;19.1;;4;d2^4;p 21 21 21;p 2ac 2ab", "20;20.1;;8;d2^5;c 2 2 21;c 2c 2", "20:cab;20.2;c,a,b;8;d2^5;a 21 2 2;a 2a 2a", "20:cab*;20.2;c,a,b;8;d2^5;a 21 2 2*;a 2a 21", "20:bca;20.3;b,c,a;8;d2^5;b 2 21 2;b 2 2b", "21;21.1;;8;d2^6;c 2 2 2;c 2 2", "21:cab;21.2;c,a,b;8;d2^6;a 2 2 2;a 2 2", "21:bca;21.3;b,c,a;8;d2^6;b 2 2 2;b 2 2", "22;22.1;;16;d2^7;f 2 2 2;f 2 2", "23;23.1;;8;d2^8;i 2 2 2;i 2 2", "24;24.1;;8;d2^9;i 21 21 21;i 2b 2c", "25;25.1;;4;c2v^1;p m m 2;p 2 -2", "25:cab;25.2;c,a,b;4;c2v^1;p 2 m m;p -2 2", "25:bca;25.3;b,c,a;4;c2v^1;p m 2 m;p -2 -2", "26;26.1;;4;c2v^2;p m c 21;p 2c -2", "26:ba-c;26.2;b,a,-c;4;c2v^2;p c m 21;p 2c -2c", "26:ba-c*;26.2;b,a,-c;4;c2v^2;p c m 21*;p 21 -2c", "26:cab;26.3;c,a,b;4;c2v^2;p 21 m a;p -2a 2a", "26:-cba;26.4;-c,b,a;4;c2v^2;p 21 a m;p -2 2a", "26:bca;26.5;b,c,a;4;c2v^2;p b 21 m;p -2 -2b", "26:a-cb;26.6;a,-c,b;4;c2v^2;p m 21 b;p -2b -2", "27;27.1;;4;c2v^3;p c c 2;p 2 -2c", "27:cab;27.2;c,a,b;4;c2v^3;p 2 a a;p -2a 2", "27:bca;27.3;b,c,a;4;c2v^3;p b 2 b;p -2b -2b", "28;28.1;;4;c2v^4;p m a 2;p 2 -2a", "28:ba-c;28.2;b,a,-c;4;c2v^4;p b m 2;p 2 -2b", "28:cab;28.3;c,a,b;4;c2v^4;p 2 m b;p -2b 2", "28:-cba;28.4;-c,b,a;4;c2v^4;p 2 c m;p -2c 2", "28:-cba*;28.4;-c,b,a;4;c2v^4;p 2 c m*;p -21 2", "28:bca;28.5;b,c,a;4;c2v^4;p c 2 m;p -2c -2c", "28:a-cb;28.6;a,-c,b;4;c2v^4;p m 2 a;p -2a -2a", "29;29.1;;4;c2v^5;p c a 21;p 2c -2ac", "29:ba-c;29.2;b,a,-c;4;c2v^5;p b c 21;p 2c -2b", "29:cab;29.3;c,a,b;4;c2v^5;p 21 a b;p -2b 2a", "29:-cba;29.4;-c,b,a;4;c2v^5;p 21 c a;p -2ac 2a", "29:bca;29.5;b,c,a;4;c2v^5;p c 21 b;p -2bc -2c", "29:a-cb;29.6;a,-c,b;4;c2v^5;p b 21 a;p -2a -2ab", "30;30.1;;4;c2v^6;p n c 2;p 2 -2bc", "30:ba-c;30.2;b,a,-c;4;c2v^6;p c n 2;p 2 -2ac", "30:cab;30.3;c,a,b;4;c2v^6;p 2 n a;p -2ac 2", "30:-cba;30.4;-c,b,a;4;c2v^6;p 2 a n;p -2ab 2", "30:bca;30.5;b,c,a;4;c2v^6;p b 2 n;p -2ab -2ab", "30:a-cb;30.6;a,-c,b;4;c2v^6;p n 2 b;p -2bc -2bc", "31;31.1;;4;c2v^7;p m n 21;p 2ac -2", "31:ba-c;31.2;b,a,-c;4;c2v^7;p n m 21;p 2bc -2bc", "31:cab;31.3;c,a,b;4;c2v^7;p 21 m n;p -2ab 2ab", "31:-cba;31.4;-c,b,a;4;c2v^7;p 21 n m;p -2 2ac", "31:bca;31.5;b,c,a;4;c2v^7;p n 21 m;p -2 -2bc", "31:a-cb;31.6;a,-c,b;4;c2v^7;p m 21 n;p -2ab -2", "32;32.1;;4;c2v^8;p b a 2;p 2 -2ab", "32:cab;32.2;c,a,b;4;c2v^8;p 2 c b;p -2bc 2", "32:bca;32.3;b,c,a;4;c2v^8;p c 2 a;p -2ac -2ac", "33;33.1;;4;c2v^9;p n a 21;p 2c -2n", "33:ba-c;33.2;b,a,-c;4;c2v^9;p b n 21;p 2c -2ab", "33:cab;33.3;c,a,b;4;c2v^9;p 21 n b;p -2bc 2a", "33:-cba;33.4;-c,b,a;4;c2v^9;p 21 c n;p -2n 2a", "33:bca;33.5;b,c,a;4;c2v^9;p c 21 n;p -2n -2ac", "33:a-cb;33.6;a,-c,b;4;c2v^9;p n 21 a;p -2ac -2n", "34;34.1;;4;c2v^10;p n n 2;p 2 -2n", "34:cab;34.2;c,a,b;4;c2v^10;p 2 n n;p -2n 2", "34:bca;34.3;b,c,a;4;c2v^10;p n 2 n;p -2n -2n", "35;35.1;;8;c2v^11;c m m 2;c 2 -2", "35:cab;35.2;c,a,b;8;c2v^11;a 2 m m;a -2 2", "35:bca;35.3;b,c,a;8;c2v^11;b m 2 m;b -2 -2", "36;36.1;;8;c2v^12;c m c 21;c 2c -2", "36:ba-c;36.2;b,a,-c;8;c2v^12;c c m 21;c 2c -2c", "36:cab;36.3;c,a,b;8;c2v^12;a 21 m a;a -2a 2a", "36:-cba;36.4;-c,b,a;8;c2v^12;a 21 a m;a -2 2a", "36:bca;36.5;b,c,a;8;c2v^12;b b 21 m;b -2 -2b", "36:a-cb;36.6;a,-c,b;8;c2v^12;b m 21 b;b -2b -2", "37;37.1;;8;c2v^13;c c c 2;c 2 -2c", "37:cab;37.2;c,a,b;8;c2v^13;a 2 a a;a -2a 2", "37:bca;37.3;b,c,a;8;c2v^13;b b 2 b;b -2b -2b", "38;38.1;;8;c2v^14;a m m 2;a 2 -2", "38:ba-c;38.2;b,a,-c;8;c2v^14;b m m 2;b 2 -2", "38:cab;38.3;c,a,b;8;c2v^14;b 2 m m;b -2 2", "38:-cba;38.4;-c,b,a;8;c2v^14;c 2 m m;c -2 2", "38:bca;38.5;b,c,a;8;c2v^14;c m 2 m;c -2 -2", "38:a-cb;38.6;a,-c,b;8;c2v^14;a m 2 m;a -2 -2", "39;39.1;;8;c2v^15;a e m 2;a 2 -2b", "39;39.1;;8;c2v^15;a b m 2;a 2 -2b", "39:ba-c;39.2;b,a,-c;8;c2v^15;b m e 2;b 2 -2a", "39:ba-c;39.2;b,a,-c;8;c2v^15;b m a 2;b 2 -2a", "39:cab;39.3;c,a,b;8;c2v^15;b 2 e m;b -2a 2", "39:cab;39.3;c,a,b;8;c2v^15;b 2 c m;b -2a 2", "39:-cba;39.4;-c,b,a;8;c2v^15;c 2 m e;c -2a 2", "39:-cba;39.4;-c,b,a;8;c2v^15;c 2 m b;c -2a 2", "39:bca;39.5;b,c,a;8;c2v^15;c m 2 e;c -2a -2a", "39:bca;39.5;b,c,a;8;c2v^15;c m 2 a;c -2a -2a", "39:a-cb;39.6;a,-c,b;8;c2v^15;a e 2 m;a -2b -2b", "39:a-cb;39.6;a,-c,b;8;c2v^15;a c 2 m;a -2b -2b", "40;40.1;;8;c2v^16;a m a 2;a 2 -2a", "40:ba-c;40.2;b,a,-c;8;c2v^16;b b m 2;b 2 -2b", "40:cab;40.3;c,a,b;8;c2v^16;b 2 m b;b -2b 2", "40:-cba;40.4;-c,b,a;8;c2v^16;c 2 c m;c -2c 2", "40:bca;40.5;b,c,a;8;c2v^16;c c 2 m;c -2c -2c", "40:a-cb;40.6;a,-c,b;8;c2v^16;a m 2 a;a -2a -2a", "41;41.1;;8;c2v^17;a e a 2;a 2 -2ab", "41;41.1;;8;c2v^17;a b a 2;a 2 -2ab", "41:ba-c;41.2;b,a,-c;8;c2v^17;b b e 2;b 2 -2ab", "41:ba-c;41.2;b,a,-c;8;c2v^17;b b a 2;b 2 -2ab", "41:cab;41.3;c,a,b;8;c2v^17;b 2 e b;b -2ab 2", "41:cab;41.3;c,a,b;8;c2v^17;b 2 c b;b -2ab 2", "41:-cba;41.4;-c,b,a;8;c2v^17;c 2 c e;c -2ac 2", "41:-cba;41.4;-c,b,a;8;c2v^17;c 2 c b;c -2ac 2", "41:bca;41.5;b,c,a;8;c2v^17;c c 2 e;c -2ac -2ac", "41:bca;41.5;b,c,a;8;c2v^17;c c 2 a;c -2ac -2ac", "41:a-cb;41.6;a,-c,b;8;c2v^17;a e 2 a;a -2ab -2ab", "41:a-cb;41.6;a,-c,b;8;c2v^17;a c 2 a;a -2ab -2ab", "42;42.1;;16;c2v^18;f m m 2;f 2 -2", "42:cab;42.2;c,a,b;16;c2v^18;f 2 m m;f -2 2", "42:bca;42.3;b,c,a;16;c2v^18;f m 2 m;f -2 -2", "43;43.1;;16;c2v^19;f d d 2;f 2 -2d", "43:cab;43.2;c,a,b;16;c2v^19;f 2 d d;f -2d 2", "43:bca;43.3;b,c,a;16;c2v^19;f d 2 d;f -2d -2d", "44;44.1;;8;c2v^20;i m m 2;i 2 -2", "44:cab;44.2;c,a,b;8;c2v^20;i 2 m m;i -2 2", "44:bca;44.3;b,c,a;8;c2v^20;i m 2 m;i -2 -2", "45;45.1;;8;c2v^21;i b a 2;i 2 -2c", "45:cab;45.2;c,a,b;8;c2v^21;i 2 c b;i -2a 2", "45:bca;45.3;b,c,a;8;c2v^21;i c 2 a;i -2b -2b", "46;46.1;;8;c2v^22;i m a 2;i 2 -2a", "46:ba-c;46.2;b,a,-c;8;c2v^22;i b m 2;i 2 -2b", "46:cab;46.3;c,a,b;8;c2v^22;i 2 m b;i -2b 2", "46:-cba;46.4;-c,b,a;8;c2v^22;i 2 c m;i -2c 2", "46:bca;46.5;b,c,a;8;c2v^22;i c 2 m;i -2c -2c", "46:a-cb;46.6;a,-c,b;8;c2v^22;i m 2 a;i -2a -2a", "47;47.1;;8;d2h^1;p m m m;-p 2 2", "48:2;48.1;;8;d2h^2;p n n n :2;-p 2ab 2bc", "48:1;48.2;a,b,c|1/4,1/4,1/4;8;d2h^2;p n n n :1;p 2 2 -1n", "49;49.1;;8;d2h^3;p c c m;-p 2 2c", "49:cab;49.2;c,a,b;8;d2h^3;p m a a;-p 2a 2", "49:bca;49.3;b,c,a;8;d2h^3;p b m b;-p 2b 2b", "50:2;50.1;;8;d2h^4;p b a n :2;-p 2ab 2b", "50:2cab;50.2;c,a,b;8;d2h^4;p n c b :2;-p 2b 2bc", "50:2bca;50.3;b,c,a;8;d2h^4;p c n a :2;-p 2a 2c", "50:1;50.4;a,b,c|1/4,1/4,0;8;d2h^4;p b a n :1;p 2 2 -1ab", "50:1cab;50.5;c,a,b|1/4,1/4,0;8;d2h^4;p n c b :1;p 2 2 -1bc", "50:1bca;50.6;b,c,a|1/4,1/4,0;8;d2h^4;p c n a :1;p 2 2 -1ac", "51;51.1;;8;d2h^5;p m m a;-p 2a 2a", "51:ba-c;51.2;b,a,-c;8;d2h^5;p m m b;-p 2b 2", "51:cab;51.3;c,a,b;8;d2h^5;p b m m;-p 2 2b", "51:-cba;51.4;-c,b,a;8;d2h^5;p c m m;-p 2c 2c", "51:bca;51.5;b,c,a;8;d2h^5;p m c m;-p 2c 2", "51:a-cb;51.6;a,-c,b;8;d2h^5;p m a m;-p 2 2a", "52;52.1;;8;d2h^6;p n n a;-p 2a 2bc", "52:ba-c;52.2;b,a,-c;8;d2h^6;p n n b;-p 2b 2n", "52:cab;52.3;c,a,b;8;d2h^6;p b n n;-p 2n 2b", "52:-cba;52.4;-c,b,a;8;d2h^6;p c n n;-p 2ab 2c", "52:bca;52.5;b,c,a;8;d2h^6;p n c n;-p 2ab 2n", "52:a-cb;52.6;a,-c,b;8;d2h^6;p n a n;-p 2n 2bc", "53;53.1;;8;d2h^7;p m n a;-p 2ac 2", "53:ba-c;53.2;b,a,-c;8;d2h^7;p n m b;-p 2bc 2bc", "53:cab;53.3;c,a,b;8;d2h^7;p b m n;-p 2ab 2ab", "53:-cba;53.4;-c,b,a;8;d2h^7;p c n m;-p 2 2ac", "53:bca;53.5;b,c,a;8;d2h^7;p n c m;-p 2 2bc", "53:a-cb;53.6;a,-c,b;8;d2h^7;p m a n;-p 2ab 2", "54;54.1;;8;d2h^8;p c c a;-p 2a 2ac", "54:ba-c;54.2;b,a,-c;8;d2h^8;p c c b;-p 2b 2c", "54:cab;54.3;c,a,b;8;d2h^8;p b a a;-p 2a 2b", "54:-cba;54.4;-c,b,a;8;d2h^8;p c a a;-p 2ac 2c", "54:bca;54.5;b,c,a;8;d2h^8;p b c b;-p 2bc 2b", "54:a-cb;54.6;a,-c,b;8;d2h^8;p b a b;-p 2b 2ab", "55;55.1;;8;d2h^9;p b a m;-p 2 2ab", "55:cab;55.2;c,a,b;8;d2h^9;p m c b;-p 2bc 2", "55:bca;55.3;b,c,a;8;d2h^9;p c m a;-p 2ac 2ac", "56;56.1;;8;d2h^10;p c c n;-p 2ab 2ac", "56:cab;56.2;c,a,b;8;d2h^10;p n a a;-p 2ac 2bc", "56:bca;56.3;b,c,a;8;d2h^10;p b n b;-p 2bc 2ab", "57;57.1;;8;d2h^11;p b c m;-p 2c 2b", "57:ba-c;57.2;b,a,-c;8;d2h^11;p c a m;-p 2c 2ac", "57:cab;57.3;c,a,b;8;d2h^11;p m c a;-p 2ac 2a", "57:-cba;57.4;-c,b,a;8;d2h^11;p m a b;-p 2b 2a", "57:bca;57.5;b,c,a;8;d2h^11;p b m a;-p 2a 2ab", "57:a-cb;57.6;a,-c,b;8;d2h^11;p c m b;-p 2bc 2c", "58;58.1;;8;d2h^12;p n n m;-p 2 2n", "58:cab;58.2;c,a,b;8;d2h^12;p m n n;-p 2n 2", "58:bca;58.3;b,c,a;8;d2h^12;p n m n;-p 2n 2n", "59:2;59.1;;8;d2h^13;p m m n :2;-p 2ab 2a", "59:2cab;59.2;c,a,b;8;d2h^13;p n m m :2;-p 2c 2bc", "59:2bca;59.3;b,c,a;8;d2h^13;p m n m :2;-p 2c 2a", "59:1;59.4;a,b,c|1/4,1/4,0;8;d2h^13;p m m n :1;p 2 2ab -1ab", "59:1cab;59.5;c,a,b|1/4,1/4,0;8;d2h^13;p n m m :1;p 2bc 2 -1bc", "59:1bca;59.6;b,c,a|1/4,1/4,0;8;d2h^13;p m n m :1;p 2ac 2ac -1ac", "60;60.1;;8;d2h^14;p b c n;-p 2n 2ab", "60:ba-c;60.2;b,a,-c;8;d2h^14;p c a n;-p 2n 2c", "60:cab;60.3;c,a,b;8;d2h^14;p n c a;-p 2a 2n", "60:-cba;60.4;-c,b,a;8;d2h^14;p n a b;-p 2bc 2n", "60:bca;60.5;b,c,a;8;d2h^14;p b n a;-p 2ac 2b", "60:a-cb;60.6;a,-c,b;8;d2h^14;p c n b;-p 2b 2ac", "61;61.1;;8;d2h^15;p b c a;-p 2ac 2ab", "61:ba-c;61.2;b,a,-c;8;d2h^15;p c a b;-p 2bc 2ac", "62;62.1;;8;d2h^16;p n m a;-p 2ac 2n", "62:ba-c;62.2;b,a,-c;8;d2h^16;p m n b;-p 2bc 2a", "62:cab;62.3;c,a,b;8;d2h^16;p b n m;-p 2c 2ab", "62:-cba;62.4;-c,b,a;8;d2h^16;p c m n;-p 2n 2ac", "62:bca;62.5;b,c,a;8;d2h^16;p m c n;-p 2n 2a", "62:a-cb;62.6;a,-c,b;8;d2h^16;p n a m;-p 2c 2n", "63;63.1;;16;d2h^17;c m c m;-c 2c 2", "63:ba-c;63.2;b,a,-c;16;d2h^17;c c m m;-c 2c 2c", "63:cab;63.3;c,a,b;16;d2h^17;a m m a;-a 2a 2a", "63:-cba;63.4;-c,b,a;16;d2h^17;a m a m;-a 2 2a", "63:bca;63.5;b,c,a;16;d2h^17;b b m m;-b 2 2b", "63:a-cb;63.6;a,-c,b;16;d2h^17;b m m b;-b 2b 2", "64;64.1;;16;d2h^18;c m c e;-c 2ac 2", "64;64.1;;16;d2h^18;c m c a;-c 2ac 2", "64:ba-c;64.2;b,a,-c;16;d2h^18;c c m e;-c 2ac 2ac", "64:ba-c;64.2;b,a,-c;16;d2h^18;c c m b;-c 2ac 2ac", "64:cab;64.3;c,a,b;16;d2h^18;a e m a;-a 2ab 2ab", "64:cab;64.3;c,a,b;16;d2h^18;a b m a;-a 2ab 2ab", "64:-cba;64.4;-c,b,a;16;d2h^18;a e a m;-a 2 2ab", "64:-cba;64.4;-c,b,a;16;d2h^18;a c a m;-a 2 2ab", "64:bca;64.5;b,c,a;16;d2h^18;b b e m;-b 2 2ab", "64:bca;64.5;b,c,a;16;d2h^18;b b c m;-b 2 2ab", "64:a-cb;64.6;a,-c,b;16;d2h^18;b m e b;-b 2ab 2", "64:a-cb;64.6;a,-c,b;16;d2h^18;b m a b;-b 2ab 2", "65;65.1;;16;d2h^19;c m m m;-c 2 2", "65:cab;65.2;c,a,b;16;d2h^19;a m m m;-a 2 2", "65:bca;65.3;b,c,a;16;d2h^19;b m m m;-b 2 2", "66;66.1;;16;d2h^20;c c c m;-c 2 2c", "66:cab;66.2;c,a,b;16;d2h^20;a m a a;-a 2a 2", "66:bca;66.3;b,c,a;16;d2h^20;b b m b;-b 2b 2b", "67;67.1;;16;d2h^21;c m m e;-c 2a 2", "67;67.1;;16;d2h^21;c m m a;-c 2a 2", "67:ba-c;67.2;b,a,-c;16;d2h^21;c m m b;-c 2a 2a", "67:cab;67.3;c,a,b;16;d2h^21;a b m m;-a 2b 2b", "67:-cba;67.4;-c,b,a;16;d2h^21;a c m m;-a 2 2b", "67:bca;67.5;b,c,a;16;d2h^21;b m c m;-b 2 2a", "67:a-cb;67.6;a,-c,b;16;d2h^21;b m a m;-b 2a 2", "68:2;68.1;;16;d2h^22;c c c e :2;-c 2a 2ac", "68:2;68.1;;16;d2h^22;c c c a :2;-c 2a 2ac", "68:2ba-c;68.2;b,a,-c;16;d2h^22;c c c b :2;-c 2a 2c", "68:2cab;68.3;c,a,b;16;d2h^22;a b a a :2;-a 2a 2b", "68:2-cba;68.4;-c,b,a;16;d2h^22;a c a a :2;-a 2ab 2b", "68:2bca;68.5;b,c,a;16;d2h^22;b b c b :2;-b 2ab 2b", "68:2a-cb;68.6;a,-c,b;16;d2h^22;b b a b :2;-b 2b 2ab", "68:1;68.7;a,b,c|0,1/4,1/4;16;d2h^22;c c c e :1;c 2 2 -1ac", "68:1;68.7;a,b,c|0,1/4,1/4;16;d2h^22;c c c a :1;c 2 2 -1ac", "68:1ba-c;68.8;b,a,-c|0,1/4,1/4;16;d2h^22;c c c b :1;c 2 2 -1ac", "68:1cab;68.9;c,a,b|0,1/4,1/4;16;d2h^22;a b a a :1;a 2 2 -1ab", "68:1-cba;68.10;-c,b,a|0,1/4,1/4;16;d2h^22;a c a a :1;a 2 2 -1ab", "68:1bca;68.11;b,c,a|0,1/4,1/4;16;d2h^22;b b c b :1;b 2 2 -1ab", "68:1a-cb;68.12;a,-c,b|0,1/4,1/4;16;d2h^22;b b a b :1;b 2 2 -1ab", "69;69.1;;32;d2h^23;f m m m;-f 2 2", "70:2;70.1;;32;d2h^24;f d d d :2;-f 2uv 2vw", "70:1;70.2;a,b,c|-1/8,-1/8,-1/8;32;d2h^24;f d d d :1;f 2 2 -1d", "71;71.1;;16;d2h^25;i m m m;-i 2 2", "72;72.1;;16;d2h^26;i b a m;-i 2 2c", "72:cab;72.2;c,a,b;16;d2h^26;i m c b;-i 2a 2", "72:bca;72.3;b,c,a;16;d2h^26;i c m a;-i 2b 2b", "73;73.1;;16;d2h^27;i b c a;-i 2b 2c", "73:ba-c;73.2;b,a,-c;16;d2h^27;i c a b;-i 2a 2b", "74;74.1;;16;d2h^28;i m m a;-i 2b 2", "74:ba-c;74.2;b,a,-c;16;d2h^28;i m m b;-i 2a 2a", "74:cab;74.3;c,a,b;16;d2h^28;i b m m;-i 2c 2c", "74:-cba;74.4;-c,b,a;16;d2h^28;i c m m;-i 2 2b", "74:bca;74.5;b,c,a;16;d2h^28;i m c m;-i 2 2a", "74:a-cb;74.6;a,-c,b;16;d2h^28;i m a m;-i 2c 2", "75;75.1;;4;c4^1;p 4;p 4", "75:c;75.2;ab;8;c4^1;c 4;c 4", "76;76.1;;4;c4^2;p 41;p 4w", "76:c;76.2;ab;8;c4^2;c 41;c 4w", "77;77.1;;4;c4^3;p 42;p 4c", "77:c;77.2;ab;8;c4^3;c 42;c 4c", "78;78.1;;4;c4^4;p 43;p 4cw", "78:c;78.2;ab;8;c4^4;c 43;c 4cw", "79;79.1;;8;c4^5;i 4;i 4", "79:f;79.2;ab;16;c4^5;f 4;f 4", "80;80.1;;8;c4^6;i 41;i 4bw", "80:f;80.2;ab;16;c4^6;f 41;xyz", "81;81.1;;4;s4^1;p -4;p -4", "81:c;81.2;ab;8;s4^1;c -4;c -4", "82;82.1;;8;s4^2;i -4;i -4", "82:f;82.2;ab;16;s4^2;f -4;f -4", "83;83.1;;8;c4h^1;p 4/m;-p 4", "83:f;83.2;ab;16;c4h^1;c 4/m;-c 4", "84;84.1;;8;c4h^2;p 42/m;-p 4c", "84:c;84.2;ab;16;c4h^2;c 42/m;-c 4c", "85:2;85.1;;8;c4h^3;p 4/n :2;-p 4a", "85:c2;85.2;ab;16;c4h^3;c 4/e :2;xyz", "85:1;85.3;a,b,c|-1/4,1/4,0;8;c4h^3;p 4/n :1;p 4ab -1ab", "85:c1;85.4;ab|-1/4,1/4,0;16;c4h^3;c 4/e :1;xyz", "86:2;86.1;;8;c4h^4;p 42/n :2;-p 4bc", "86:1;86.3;a,b,c|-1/4,-1/4,-1/4;8;c4h^4;p 42/n :1;p 4n -1n", "86:c1;86.4;ab|-1/4,-1/4,-1/4;16;c4h^4;c 42/e :1;xyz", "86:c2;86.2;ab;16;c4h^4;c 42/e :2;xyz", "87;87.1;;16;c4h^5;i 4/m;-i 4", "87:f;87.2;ab;32;c4h^5;f 4/m;xyz", "88:2;88.1;;16;c4h^6;i 41/a :2;-i 4ad", "88:f2;88.2;ab;32;c4h^6;f 41/d :2;xyz", "88:1;88.3;a,b,c|0,-1/4,-1/8;16;c4h^6;i 41/a :1;i 4bw -1bw", "88:f1;88.4;ab|0,-1/4,-1/8;32;c4h^6;f 41/d :1;xyz", "89;89.1;;8;d4^1;p 4 2 2;p 4 2", "89:c;89.2;ab;16;d4^1;c 4 2 2;xyz", "90;90.1;;8;d4^2;p 4 21 2;p 4ab 2ab", "90:c;90.2;ab;16;d4^2;c 4 2 21;xyz", "91;91.1;;8;d4^3;p 41 2 2;p 4w 2c", "91:c;91.2;ab;16;d4^3;c 41 2 2;xyz", "92;92.1;;8;d4^4;p 41 21 2;p 4abw 2nw", "92:c;92.2;ab;16;d4^4;c 41 2 21;xyz", "93;93.1;;8;d4^5;p 42 2 2;p 4c 2", "93:c;93.2;ab;16;d4^5;c 42 2 2;xyz", "94;94.1;;8;d4^6;p 42 21 2;p 4n 2n", "94:c;94.2;ab;16;d4^6;c 42 2 21;xyz", "95;95.1;;8;d4^7;p 43 2 2;p 4cw 2c", "95:c;95.2;ab;16;d4^7;c 43 2 2;xyz", "96;96.1;;8;d4^8;p 43 21 2;p 4nw 2abw", "96:c;96.2;ab;16;d4^8;c 43 2 21;xyz", "97;97.1;;16;d4^9;i 4 2 2;i 4 2", "97:f;97.2;ab;32;d4^9;f 4 2 2;f 4 2", "98;98.1;;16;d4^10;i 41 2 2;i 4bw 2bw", "98:f;98.2;ab;32;d4^10;f 41 2 2;xyz", "99;99.1;;8;c4v^1;p 4 m m;p 4 -2", "99:c;99.2;ab;16;c4v^1;c 4 m m;c 4 -2", "100;100.1;;8;c4v^2;p 4 b m;p 4 -2ab", "100:c;100.2;ab;16;c4v^2;c 4 m g1;xyz", "101;101.1;;8;c4v^3;p 42 c m;p 4c -2c", "101:c;101.2;ab;16;c4v^3;c 42 m c;xyz", "102;102.1;;8;c4v^4;p 42 n m;p 4n -2n", "102:c;102.2;ab;16;c4v^4;c 42 m g2;xyz", "103;103.1;;8;c4v^5;p 4 c c;p 4 -2c", "103:c;103.2;ab;16;c4v^5;c 4 c c;c 4 -2c", "104;104.1;;8;c4v^6;p 4 n c;p 4 -2n", "104:c;104.2;ab;16;c4v^6;c 4 c g2;xyz", "105;105.1;;8;c4v^7;p 42 m c;p 4c -2", "105:c;105.2;ab;16;c4v^7;c 42 c m;xyz", "106;106.1;;8;c4v^8;p 42 b c;p 4c -2ab", "106:c;106.2;ab;16;c4v^8;c 42 c g1;xyz", "107;107.1;;16;c4v^9;i 4 m m;i 4 -2", "107:f;107.2;ab;32;c4v^9;f 4 m m;f 4 -2", "108;108.1;;16;c4v^10;i 4 c m;i 4 -2c", "108:f;108.2;ab;32;c4v^10;f 4 m c;xyz", "109;109.1;;16;c4v^11;i 41 m d;i 4bw -2", "109:f;109.2;ab;32;c4v^11;f 41 d m;xyz", "110;110.1;;16;c4v^12;i 41 c d;i 4bw -2c", "110:f;110.2;ab;32;c4v^12;f 41 d c;xyz", "111;111.1;;8;d2d^1;p -4 2 m;p -4 2", "111:c;111.2;ab;16;d2d^1;c -4 m 2;xyz", "112;112.1;;8;d2d^2;p -4 2 c;p -4 2c", "112:c;112.2;ab;16;d2d^2;c -4 c 2;xyz", "113;113.1;;8;d2d^3;p -4 21 m;p -4 2ab", "113:c;113.2;ab;16;d2d^3;c -4 m 21;xyz", "114;114.1;;8;d2d^4;p -4 21 c;p -4 2n", "114:c;114.2;ab;16;d2d^4;c -4 c 21;xyz", "115;115.1;;8;d2d^5;p -4 m 2;p -4 -2", "115:c;115.2;ab;16;d2d^5;c -4 2 m;xyz", "116;116.1;;8;d2d^6;p -4 c 2;p -4 -2c", "116:c;116.2;ab;16;d2d^6;c -4 2 c;xyz", "117;117.1;;8;d2d^7;p -4 b 2;p -4 -2ab", "117:c;117.2;ab;16;d2d^7;c -4 2 g1;xyz", "118;118.1;;8;d2d^8;p -4 n 2;p -4 -2n", "118:c;118.2;ab;16;d2d^8;c -4 2 g2;xyz", "119;119.1;;16;d2d^9;i -4 m 2;i -4 -2", "119:f;119.2;ab;32;d2d^9;f -4 2 m;xyz", "120;120.1;;16;d2d^10;i -4 c 2;i -4 -2c", "120:f;120.2;ab;32;d2d^10;f -4 2 c;xyz", "121;121.1;;16;d2d^11;i -4 2 m;i -4 2", "121:f;121.2;ab;32;d2d^11;f -4 m 2;xyz", "122;122.1;;16;d2d^12;i -4 2 d;i -4 2bw", "122:f;122.2;ab;32;d2d^12;f -4 d 2;xyz", "123;123.1;;16;d4h^1;p 4/m m m;-p 4 2", "123:c;123.2;ab;32;d4h^1;c 4/m m m;xyz", "124;124.1;;16;d4h^2;p 4/m c c;-p 4 2c", "124:c;124.2;ab;32;d4h^2;c 4/m c c;xyz", "125:2;125.1;;16;d4h^3;p 4/n b m :2;-p 4a 2b", "125:c2;125.2;ab;32;d4h^3;c 4/e m g1 :2;xyz", "125:1;125.3;a,b,c|-1/4,-1/4,0;16;d4h^3;p 4/n b m :1;p 4 2 -1ab", "125:c1;125.4;ab|-1/4,-1/4,0;32;d4h^3;c 4/e m g1 :1;xyz", "126:2;126.1;;16;d4h^4;p 4/n n c :2;-p 4a 2bc", "126:c1;126.2;ab;32;d4h^4;c 4/e c g2 :2;xyz", "126:1;126.3;a,b,c|-1/4,-1/4,-1/4;16;d4h^4;p 4/n n c :1;p 4 2 -1n", "126:c4;126.4;ab|-1/4,-1/4,-1/4;32;d4h^4;c 4/e c g2 :1;xyz", "127;127.1;;16;d4h^5;p 4/m b m;-p 4 2ab", "127:c;127.2;ab;32;d4h^5;c 4/m m g1;xyz", "128;128.1;;16;d4h^6;p 4/m n c;-p 4 2n", "128:c;128.2;ab;32;d4h^6;c 4/m c g2;xyz", "129:2;129.1;;16;d4h^7;p 4/n m m :2;-p 4a 2a", "129:c2;129.2;ab;32;d4h^7;c 4/e m m :2;xyz", "129:1;129.3;a,b,c|-1/4,1/4,0;16;d4h^7;p 4/n m m :1;p 4ab 2ab -1ab", "129:c1;129.4;ab|-1/4,1/4,0;32;d4h^7;c 4/e m m :1;xyz", "130:2;130.1;;16;d4h^8;p 4/n c c :2;-p 4a 2ac", "130:c2;130.2;ab;32;d4h^8;c 4/e c c :2;xyz", "130:1;130.3;a,b,c|-1/4,1/4,0;16;d4h^8;p 4/n c c :1;p 4ab 2n -1ab", "130:c1;130.4;ab|-1/4,1/4,0;32;d4h^8;c 4/e c c :1;xyz", "131;131.1;;16;d4h^9;p 42/m m c;-p 4c 2", "131:c;131.2;ab;32;d4h^9;c 42/m c m;xyz", "132;132.1;;16;d4h^10;p 42/m c m;-p 4c 2c", "132:c;132.2;ab;32;d4h^10;c 42/m m c;xyz", "133:2;133.1;;16;d4h^11;p 42/n b c :2;-p 4ac 2b", "133:c1;133.2;ab;32;d4h^11;c 42/e c g1 :2;xyz", "133:1;133.3;a,b,c|-1/4,1/4,-1/4;16;d4h^11;p 42/n b c :1;p 4n 2c -1n", "133:c2;133.4;ab|-1/4,1/4,-1/4;32;d4h^11;c 42/e c g1 :1;xyz", "134:2;134.1;;16;d4h^12;p 42/n n m :2;-p 4ac 2bc", "134:c2;134.2;ab;32;d4h^12;c 42/e m g2 :2;xyz", "134:1;134.3;a,b,c|-1/4,1/4,-1/4;16;d4h^12;p 42/n n m :1;p 4n 2 -1n", "134:c1;134.4;ab|-1/4,1/4,-1/4;32;d4h^12;c 42/e m g2 :1;xyz", "135;135.1;;16;d4h^13;p 42/m b c;-p 4c 2ab", "135:c;135.2;ab;32;d4h^13;c 42/m c g1;xyz", "136;136.1;;16;d4h^14;p 42/m n m;-p 4n 2n", "136:c;136.2;ab;32;d4h^14;c 42/m m g2;xyz", "137:2;137.1;;16;d4h^15;p 42/n m c :2;-p 4ac 2a", "137:c1;137.2;ab;32;d4h^15;c 42/e c m :2;xyz", "137:1;137.3;a,b,c|-1/4,1/4,-1/4;16;d4h^15;p 42/n m c :1;p 4n 2n -1n", "137:c2;137.4;ab|-1/4,1/4,-1/4;32;d4h^15;c 42/e c m :1;xyz", "138:2;138.1;;16;d4h^16;p 42/n c m :2;-p 4ac 2ac", "138:c2;138.2;ab;32;d4h^16;c 42/e m c :2;xyz", "138:1;138.3;a,b,c|-1/4,1/4,-1/4;16;d4h^16;p 42/n c m :1;p 4n 2ab -1n", "138:c1;138.4;ab|-1/4,1/4,-1/4;32;d4h^16;c 42/e m c :1;xyz", "139;139.1;;32;d4h^17;i 4/m m m;-i 4 2", "139:f;139.2;ab;64;d4h^17;f 4/m m m;xyz", "140;140.1;;32;d4h^18;i 4/m c m;-i 4 2c", "140:f;140.2;ab;64;d4h^18;f 4/m m c;xyz", "141:2;141.1;;32;d4h^19;i 41/a m d :2;-i 4bd 2", "141:f2;141.2;ab;64;d4h^19;f 41/d d m :2;xyz", "141:1;141.3;a,b,c|0,1/4,-1/8;32;d4h^19;i 41/a m d :1;i 4bw 2bw -1bw", "141:f1;141.4;ab|0,1/4,-1/8;64;d4h^19;f 41/d d m :1;xyz", "142:2;142.1;;32;d4h^20;i 41/a c d :2;-i 4bd 2c", "142:f2;142.2;ab;64;d4h^20;f 41/d d c :2;xyz", "142:1;142.3;a,b,c|0,1/4,-1/8;32;d4h^20;i 41/a c d :1;i 4bw 2aw -1bw", "142:f1;142.4;ab|0,1/4,-1/8;64;d4h^20;f 41/d d c :1;xyz", "143;143.1;;3;c3^1;p 3;p 3", "144;144.1;;3;c3^2;p 31;p 31", "145;145.1;;3;c3^3;p 32;p 32", "146:h;146.1;;9;c3^4;r 3 :h;r 3", "146:r;146.2;r;3;c3^4;r 3 :r;p 3*", "147;147.1;;6;c3i^1;p -3;-p 3", "148:h;148.1;;18;c3i^2;r -3 :h;-r 3", "148:r;148.2;r;6;c3i^2;r -3 :r;-p 3*", "149;149.1;;6;d3^1;p 3 1 2;p 3 2", "150;150.1;;6;d3^2;p 3 2 1;p 3 2\"", "151;151.1;;6;d3^3;p 31 1 2;p 31 2 (0 0 4)", "152;152.1;;6;d3^4;p 31 2 1;p 31 2\"", "152:_2;152:a,b,c|0,0,-1/3;a,b,c|0,0,-1/3;6;d3^4;p 31 2 1;p 31 2\" (0 0 4)", "153;153.1;;6;d3^5;p 32 1 2;p 32 2 (0 0 2)", "154;154.1;;6;d3^6;p 32 2 1;p 32 2\"", "154:_2;154:a,b,c|0,0,-1/3;a,b,c|0,0,-1/3;6;d3^6;p 32 2 1;p 32 2\" (0 0 4)", "155:h;155.1;;18;d3^7;r 3 2 :h;r 3 2\"", "155:r;155.2;r;6;d3^7;r 3 2 :r;p 3* 2", "156;156.1;;6;c3v^1;p 3 m 1;p 3 -2\"", "157;157.1;;6;c3v^2;p 3 1 m;p 3 -2", "158;158.1;;6;c3v^3;p 3 c 1;p 3 -2\"c", "159;159.1;;6;c3v^4;p 3 1 c;p 3 -2c", "160:h;160.1;;18;c3v^5;r 3 m :h;r 3 -2\"", "160:r;160.2;r;6;c3v^5;r 3 m :r;p 3* -2", "161:h;161.1;;18;c3v^6;r 3 c :h;r 3 -2\"c", "161:r;161.2;r;6;c3v^6;r 3 c :r;p 3* -2n", "162;162.1;;12;d3d^1;p -3 1 m;-p 3 2", "163;163.1;;12;d3d^2;p -3 1 c;-p 3 2c", "164;164.1;;12;d3d^3;p -3 m 1;-p 3 2\"", "165;165.1;;12;d3d^4;p -3 c 1;-p 3 2\"c", "166:h;166.1;;36;d3d^5;r -3 m :h;-r 3 2\"", "166:r;166.2;r;12;d3d^5;r -3 m :r;-p 3* 2", "167:h;167.1;;36;d3d^6;r -3 c :h;-r 3 2\"c", "167:r;167.2;r;12;d3d^6;r -3 c :r;-p 3* 2n", "168;168.1;;6;c6^1;p 6;p 6", "169;169.1;;6;c6^2;p 61;p 61", "170;170.1;;6;c6^3;p 65;p 65", "171;171.1;;6;c6^4;p 62;p 62", "172;172.1;;6;c6^5;p 64;p 64", "173;173.1;;6;c6^6;p 63;p 6c", "174;174.1;;6;c3h^1;p -6;p -6", "175;175.1;;12;c6h^1;p 6/m;-p 6", "176;176.1;;12;c6h^2;p 63/m;-p 6c", "177;177.1;;12;d6^1;p 6 2 2;p 6 2", "178;178.1;;12;d6^2;p 61 2 2;p 61 2 (0 0 5)", "179;179.1;;12;d6^3;p 65 2 2;p 65 2 (0 0 1)", "180;180.1;;12;d6^4;p 62 2 2;p 62 2 (0 0 4)", "181;181.1;;12;d6^5;p 64 2 2;p 64 2 (0 0 2)", "182;182.1;;12;d6^6;p 63 2 2;p 6c 2c", "183;183.1;;12;c6v^1;p 6 m m;p 6 -2", "184;184.1;;12;c6v^2;p 6 c c;p 6 -2c", "185;185.1;;12;c6v^3;p 63 c m;p 6c -2", "186;186.1;;12;c6v^4;p 63 m c;p 6c -2c", "187;187.1;;12;d3h^1;p -6 m 2;p -6 2", "188;188.1;;12;d3h^2;p -6 c 2;p -6c 2", "189;189.1;;12;d3h^3;p -6 2 m;p -6 -2", "190;190.1;;12;d3h^4;p -6 2 c;p -6c -2c", "191;191.1;;24;d6h^1;p 6/m m m;-p 6 2", "192;192.1;;24;d6h^2;p 6/m c c;-p 6 2c", "193;193.1;;24;d6h^3;p 63/m c m;-p 6c 2", "194;194.1;;24;d6h^4;p 63/m m c;-p 6c 2c", "195;195.1;;12;t^1;p 2 3;p 2 2 3", "196;196.1;;48;t^2;f 2 3;f 2 2 3", "197;197.1;;24;t^3;i 2 3;i 2 2 3", "198;198.1;;12;t^4;p 21 3;p 2ac 2ab 3", "199;199.1;;24;t^5;i 21 3;i 2b 2c 3", "200;200.1;;24;th^1;p m -3;-p 2 2 3", "201:2;201.1;;24;th^2;p n -3 :2;-p 2ab 2bc 3", "201:1;201.2;a,b,c|-1/4,-1/4,-1/4;24;th^2;p n -3 :1;p 2 2 3 -1n", "202;202.1;;96;th^3;f m -3;-f 2 2 3", "203:2;203.1;;96;th^4;f d -3 :2;-f 2uv 2vw 3", "203:1;203.2;a,b,c|-1/8,-1/8,-1/8;96;th^4;f d -3 :1;f 2 2 3 -1d", "204;204.1;;48;th^5;i m -3;-i 2 2 3", "205;205.1;;24;th^6;p a -3;-p 2ac 2ab 3", "206;206.1;;48;th^7;i a -3;-i 2b 2c 3", "207;207.1;;24;o^1;p 4 3 2;p 4 2 3", "208;208.1;;24;o^2;p 42 3 2;p 4n 2 3", "209;209.1;;96;o^3;f 4 3 2;f 4 2 3", "210;210.1;;96;o^4;f 41 3 2;f 4d 2 3", "211;211.1;;48;o^5;i 4 3 2;i 4 2 3", "212;212.1;;24;o^6;p 43 3 2;p 4acd 2ab 3", "213;213.1;;24;o^7;p 41 3 2;p 4bd 2ab 3", "214;214.1;;48;o^8;i 41 3 2;i 4bd 2c 3", "215;215.1;;24;td^1;p -4 3 m;p -4 2 3", "216;216.1;;96;td^2;f -4 3 m;f -4 2 3", "217;217.1;;48;td^3;i -4 3 m;i -4 2 3", "218;218.1;;24;td^4;p -4 3 n;p -4n 2 3", "219;219.1;;96;td^5;f -4 3 c;f -4a 2 3", "220;220.1;;48;td^6;i -4 3 d;i -4bd 2c 3", "221;221.1;;48;oh^1;p m -3 m;-p 4 2 3", "222:2;222.1;;48;oh^2;p n -3 n :2;-p 4a 2bc 3", "222:1;222.2;a,b,c|-1/4,-1/4,-1/4;48;oh^2;p n -3 n :1;p 4 2 3 -1n", "223;223.1;;48;oh^3;p m -3 n;-p 4n 2 3", "224:2;224.1;;48;oh^4;p n -3 m :2;-p 4bc 2bc 3", "224:1;224.2;a,b,c|-1/4,-1/4,-1/4;48;oh^4;p n -3 m :1;p 4n 2 3 -1n", "225;225.1;;192;oh^5;f m -3 m;-f 4 2 3", "226;226.1;;192;oh^6;f m -3 c;-f 4a 2 3", "227:2;227.1;;192;oh^7;f d -3 m :2;-f 4vw 2vw 3", "227:1;227.2;a,b,c|-1/8,-1/8,-1/8;192;oh^7;f d -3 m :1;f 4d 2 3 -1d", "228:2;228.1;;192;oh^8;f d -3 c :2;-f 4ud 2vw 3", "228:1;228.2;a,b,c|-3/8,-3/8,-3/8;192;oh^8;f d -3 c :1;f 4d 2 3 -1ad", "229;229.1;;96;oh^9;i m -3 m;-i 4 2 3", "230;230.1;;96;oh^10;i a -3 d;-i 4bd 2c 3"};
        moreSettings = new String[]{"A 1 1 2 :2'", "5:-a-c,a,-b", "A 1 2 1 :1'", "5:c,-b,a", "B 1 1 2 :1'", "5:a,c,-b", "B 2 1 1 :2'", "5:-b,-a-c,a", "C 1 2 1 :2'", "5:a,-b,-a-c", "C 2 1 1 :1'", "5:-b,a,c", "I 1 1 2 :3'", "5:c,-a-c,-b", "I 1 2 1 :3'", "5:-a-c,-b,c", "I 2 1 1 :3'", "5:-b,c,-a-c", "P 1 1 a :3'", "7:c,-a-c,-b", "P 1 1 b :1'", "7:a,c,-b", "P 1 1 n :2'", "7:-a-c,a,-b", "P 1 a 1 :1'", "7:c,-b,a", "P 1 c 1 :3'", "7:-a-c,-b,c", "P 1 n 1 :2'", "7:a,-b,-a-c", "P b 1 1 :3'", "7:-b,c,-a-c", "P c 1 1 :1'", "7:-b,a,c", "P n 1 1 :2'", "7:-b,-a-c,a", "A 1 1 m :2'", "8:-a-c,a,-b", "A 1 m 1 :1'", "8:c,-b,a", "B 1 1 m :1'", "8:a,c,-b", "B m 1 1 :2'", "8:-b,-a-c,a", "C 1 m 1 :2'", "8:a,-b,-a-c", "C m 1 1 :1'", "8:-b,a,c", "I 1 1 m :3'", "8:c,-a-c,-b", "I 1 m 1 :3'", "8:-a-c,-b,c", "I m 1 1 :3'", "8:-b,c,-a-c", "A 1 1 2/m :2'", "12:-a-c,a,-b", "A 1 2/m 1 :1'", "12:c,-b,a", "B 1 1 2/m :1'", "12:a,c,-b", "B 2/m 1 1 :2'", "12:-b,-a-c,a", "C 1 2/m 1 :2'", "12:a,-b,-a-c", "C 2/m 1 1 :1'", "12:-b,a,c", "I 1 1 2/m :3'", "12:c,-a-c,-b", "I 1 2/m 1 :3'", "12:-a-c,-b,c", "I 2/m 1 1 :3'", "12:-b,c,-a-c", "P 1 1 2/a :3'", "13:c,-a-c,-b", "P 1 1 2/b :1'", "13:a,c,-b", "P 1 1 2/n :2'", "13:-a-c,a,-b", "P 1 2/a 1 :1'", "13:c,-b,a", "P 1 2/c 1 :3'", "13:-a-c,-b,c", "P 1 2/n 1 :2'", "13:a,-b,-a-c", "P 2/b 1 1 :3'", "13:-b,c,-a-c", "P 2/c 1 1 :1'", "13:-b,a,c", "P 2/n 1 1 :2'", "13:-b,-a-c,a", "P 1 1 21/a :3'", "14:c,-a-c,-b", "P 1 1 21/b :1'", "14:a,c,-b", "P 1 1 21/n :2'", "14:-a-c,a,-b", "P 1 21/a 1 :1'", "14:c,-b,a", "P 1 21/c 1 :3'", "14:-a-c,-b,c", "P 1 21/n 1 :2'", "14:a,-b,-a-c", "P 21/b 1 1 :3'", "14:-b,c,-a-c", "P 21/c 1 1 :1'", "14:-b,a,c", "P 21/n 1 1 :2'", "14:-b,-a-c,a", "C 4'", "75:a+b,-a+b,c", "C 41'", "76:a+b,-a+b,c", "C 42'", "77:a+b,-a+b,c", "C 43'", "78:a+b,-a+b,c", "F 4'", "79:a+b,-a+b,c", "F 41'", "80:a+b,-a+b,c", "C -4'", "81:a+b,-a+b,c", "F -4'", "82:a+b,-a+b,c", "C 4/m'", "83:a+b,-a+b,c", "C 42/m'", "84:a+b,-a+b,c", "C 4/e :1'", "85:a+b,-a+b,c;-1/4,1/4,0", "C 4/e :2'", "85:a+b,-a+b,c", "C 42/e :1'", "86:a+b,-a+b,c;-1/4,-1/4,-1/4", "C 42/e :2'", "86:a+b,-a+b,c", "F 4/m'", "87:a+b,-a+b,c", "F 41/d :1'", "88:a+b,-a+b,c;0,-1/4,-1/8", "F 41/d :2'", "88:a+b,-a+b,c", "C 4 2 2'", "89:a+b,-a+b,c", "C 4 2 21'", "90:a+b,-a+b,c", "C 41 2 2'", "91:a+b,-a+b,c", "C 41 2 21'", "92:a+b,-a+b,c", "C 42 2 2'", "93:a+b,-a+b,c", "C 42 2 21'", "94:a+b,-a+b,c", "C 43 2 2'", "95:a+b,-a+b,c", "C 43 2 21'", "96:a+b,-a+b,c", "F 4 2 2'", "97:a+b,-a+b,c", "F 41 2 2'", "98:a+b,-a+b,c", "C 4 m m'", "99:a+b,-a+b,c", "C 4 m g1'", "100:a+b,-a+b,c", "C 42 m c'", "101:a+b,-a+b,c", "C 42 m g2'", "102:a+b,-a+b,c", "C 4 c c'", "103:a+b,-a+b,c", "C 4 c g2'", "104:a+b,-a+b,c", "C 42 c m'", "105:a+b,-a+b,c", "C 42 c g1'", "106:a+b,-a+b,c", "F 4 m m'", "107:a+b,-a+b,c", "F 4 m c'", "108:a+b,-a+b,c", "F 41 d m'", "109:a+b,-a+b,c", "F 41 d c'", "110:a+b,-a+b,c", "C -4 m 2'", "111:a+b,-a+b,c", "C -4 c 2'", "112:a+b,-a+b,c", "C -4 m 21'", "113:a+b,-a+b,c", "C -4 c 21'", "114:a+b,-a+b,c", "C -4 2 m'", "115:a+b,-a+b,c", "C -4 2 c'", "116:a+b,-a+b,c", "C -4 2 g1'", "117:a+b,-a+b,c", "C -4 2 g2'", "118:a+b,-a+b,c", "F -4 2 m'", "119:a+b,-a+b,c", "F -4 2 c'", "120:a+b,-a+b,c", "F -4 m 2'", "121:a+b,-a+b,c", "F -4 d 2'", "122:a+b,-a+b,c", "C 4/m m m'", "123:a+b,-a+b,c", "C 4/m c c'", "124:a+b,-a+b,c", "C 4/e m g1 :1'", "125:a+b,-a+b,c;-1/4,-1/4,0", "C 4/e m g1 :2'", "125:a+b,-a+b,c", "C 4/e c g2 :1'", "126:a+b,-a+b,c;-1/4,-1/4,-1/4", "C 4/e c g2 :2'", "126:a+b,-a+b,c", "C 4/m m g1'", "127:a+b,-a+b,c", "C 4/m c g2'", "128:a+b,-a+b,c", "C 4/e m m :1'", "129:a+b,-a+b,c;-1/4,1/4,0", "C 4/e m m :2'", "129:a+b,-a+b,c", "C 4/e c c :1'", "130:a+b,-a+b,c;-1/4,1/4,0", "C 4/e c c :2'", "130:a+b,-a+b,c", "C 42/m c m'", "131:a+b,-a+b,c", "C 42/m m c'", "132:a+b,-a+b,c", "C 42/e c g1 :1'", "133:a+b,-a+b,c;-1/4,1/4,-1/4", "C 42/e c g1 :2'", "133:a+b,-a+b,c", "C 42/e m g2 :1'", "134:a+b,-a+b,c;-1/4,1/4,-1/4", "C 42/e m g2 :2'", "134:a+b,-a+b,c", "C 42/m c g1'", "135:a+b,-a+b,c", "C 42/m m g2'", "136:a+b,-a+b,c", "C 42/e c m :1'", "137:a+b,-a+b,c;-1/4,1/4,-1/4", "C 42/e c m :2'", "137:a+b,-a+b,c", "C 42/e m c :1'", "138:a+b,-a+b,c;-1/4,1/4,-1/4", "C 42/e m c :2'", "138:a+b,-a+b,c", "F 4/m m m'", "139:a+b,-a+b,c", "F 4/m m c'", "140:a+b,-a+b,c", "F 41/d d m :1'", "141:a+b,-a+b,c;0,1/4,-1/8", "F 41/d d m :2'", "141:a+b,-a+b,c", "F 41/d d c :1'", "142:a+b,-a+b,c;0,1/4,-1/8", "F 41/d d c :2'", "142:a+b,-a+b,c"};
        SpaceGroup.getSpaceGroups();
    }

    protected static class ParamCheck {
        float a;
        float b;
        float c;
        float alpha;
        float beta;
        float gamma;
        boolean acsame;

        protected ParamCheck(float[] params, boolean allowSame, boolean checkC) {
            this.a = params[0];
            this.b = params[1];
            this.c = params[2];
            this.alpha = params[3];
            this.beta = params[4];
            this.gamma = params[5];
            if (!allowSame) {
                this.checkParams(checkC);
            }
        }

        private void checkParams(boolean checkC) {
            boolean absame;
            boolean bcsame;
            if (this.b > 0.0f && this.a > this.b) {
                float d = this.a;
                this.a = this.b;
                this.b = d;
            }
            boolean bl = bcsame = checkC && this.c > 0.0f && SimpleUnitCell.approx0(this.b - this.c);
            if (bcsame) {
                this.c = this.b * 1.5f;
            }
            if (absame = SimpleUnitCell.approx0(this.a - this.b)) {
                this.b = this.a * 1.2f;
            }
            if (SimpleUnitCell.approx0(this.gamma - 90.0f)) {
                this.gamma = 130.0f;
            }
            if (!checkC) {
                return;
            }
            boolean bl2 = this.acsame = this.c > 0.0f && SimpleUnitCell.approx0(this.c - this.a);
            if (this.acsame) {
                this.c = this.a * 1.1f;
            }
            if (SimpleUnitCell.approx0(this.alpha - 90.0f)) {
                this.alpha = 80.0f;
            }
            if (SimpleUnitCell.approx0(this.beta - 90.0f)) {
                this.beta = 100.0f;
            }
            if (this.alpha > this.beta) {
                float d = this.alpha;
                this.alpha = this.beta;
                this.beta = d;
            }
            boolean albesame = SimpleUnitCell.approx0(this.alpha - this.beta);
            boolean begasame = SimpleUnitCell.approx0(this.beta - this.gamma);
            boolean algasame = SimpleUnitCell.approx0(this.gamma - this.alpha);
            if (albesame) {
                this.beta = this.alpha * 1.2f;
            }
            if (begasame) {
                this.gamma = this.beta * 1.3f;
            }
            if (algasame) {
                this.gamma = this.alpha * 1.4f;
            }
        }

        protected boolean checkNew(float[] params, float[] newParams) {
            boolean isNew = this.a != params[0] || this.b != params[1] || this.c != params[2] || this.alpha != params[3] || this.beta != params[4] || this.gamma != params[5];
            newParams[0] = this.a;
            newParams[1] = this.b;
            newParams[2] = this.c;
            newParams[3] = this.alpha;
            newParams[4] = this.beta;
            newParams[5] = this.gamma;
            return isNew;
        }
    }
}

