/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.memory;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.memory.NativeMemoryAllocation;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.memory.NativeMemoryEntryContext;
import org.opensearch.knn.index.memory.SharedIndexState;
import org.opensearch.knn.index.memory.SharedIndexStateManager;
import org.opensearch.knn.index.util.IndexUtil;
import org.opensearch.knn.jni.JNIService;
import org.opensearch.knn.training.TrainingDataConsumer;
import org.opensearch.knn.training.VectorReader;
import org.opensearch.watcher.FileChangesListener;
import org.opensearch.watcher.FileWatcher;
import org.opensearch.watcher.ResourceWatcher;
import org.opensearch.watcher.ResourceWatcherService;
import org.opensearch.watcher.WatcherHandle;

public interface NativeMemoryLoadStrategy<T extends NativeMemoryAllocation, U extends NativeMemoryEntryContext<T>> {
    public T load(U var1) throws IOException;

    public static class AnonymousLoadStrategy
    implements NativeMemoryLoadStrategy<NativeMemoryAllocation.AnonymousAllocation, NativeMemoryEntryContext.AnonymousEntryContext>,
    Closeable {
        private static AnonymousLoadStrategy INSTANCE;
        private final ExecutorService executor = Executors.newSingleThreadExecutor();

        public static synchronized AnonymousLoadStrategy getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new AnonymousLoadStrategy();
            }
            return INSTANCE;
        }

        private AnonymousLoadStrategy() {
        }

        @Override
        public NativeMemoryAllocation.AnonymousAllocation load(NativeMemoryEntryContext.AnonymousEntryContext nativeMemoryEntryContext) {
            return new NativeMemoryAllocation.AnonymousAllocation(this.executor, nativeMemoryEntryContext.calculateSizeInKB());
        }

        @Override
        public void close() {
            this.executor.shutdown();
        }
    }

    public static class TrainingLoadStrategy
    implements NativeMemoryLoadStrategy<NativeMemoryAllocation.TrainingDataAllocation, NativeMemoryEntryContext.TrainingDataEntryContext>,
    Closeable {
        private static TrainingLoadStrategy INSTANCE;
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        private VectorReader vectorReader;

        public static synchronized TrainingLoadStrategy getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new TrainingLoadStrategy();
            }
            return INSTANCE;
        }

        public static void initialize(VectorReader vectorReader) {
            TrainingLoadStrategy.getInstance().vectorReader = vectorReader;
        }

        private TrainingLoadStrategy() {
        }

        @Override
        public NativeMemoryAllocation.TrainingDataAllocation load(NativeMemoryEntryContext.TrainingDataEntryContext nativeMemoryEntryContext) {
            NativeMemoryAllocation.TrainingDataAllocation trainingDataAllocation = new NativeMemoryAllocation.TrainingDataAllocation(this.executor, 0L, nativeMemoryEntryContext.calculateSizeInKB(), nativeMemoryEntryContext.getVectorDataType());
            QuantizationConfig quantizationConfig = nativeMemoryEntryContext.getQuantizationConfig();
            trainingDataAllocation.setQuantizationConfig(quantizationConfig);
            TrainingDataConsumer vectorDataConsumer = nativeMemoryEntryContext.getVectorDataType().getTrainingDataConsumer(trainingDataAllocation);
            trainingDataAllocation.writeLock();
            this.vectorReader.read(nativeMemoryEntryContext.getClusterService(), nativeMemoryEntryContext.getTrainIndexName(), nativeMemoryEntryContext.getTrainFieldName(), nativeMemoryEntryContext.getMaxVectorCount(), nativeMemoryEntryContext.getSearchSize(), vectorDataConsumer, (ActionListener<SearchResponse>)ActionListener.wrap(response -> trainingDataAllocation.writeUnlock(), ex -> {
                trainingDataAllocation.closeUnsafe();
                throw new RuntimeException((Throwable)ex);
            }));
            return trainingDataAllocation;
        }

        @Override
        public void close() throws IOException {
            this.executor.shutdown();
        }
    }

    public static class IndexLoadStrategy
    implements NativeMemoryLoadStrategy<NativeMemoryAllocation.IndexAllocation, NativeMemoryEntryContext.IndexEntryContext>,
    Closeable {
        @Generated
        private static final Logger log = LogManager.getLogger(IndexLoadStrategy.class);
        private static IndexLoadStrategy INSTANCE;
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        private final FileChangesListener indexFileOnDeleteListener = new FileChangesListener(){

            public void onFileDeleted(Path indexFilePath) {
                NativeMemoryCacheManager.getInstance().invalidate(indexFilePath.toString());
            }
        };
        private ResourceWatcherService resourceWatcherService;

        public static synchronized IndexLoadStrategy getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new IndexLoadStrategy();
            }
            return INSTANCE;
        }

        public static void initialize(ResourceWatcherService resourceWatcherService) {
            IndexLoadStrategy.getInstance().resourceWatcherService = resourceWatcherService;
        }

        private IndexLoadStrategy() {
        }

        @Override
        public NativeMemoryAllocation.IndexAllocation load(NativeMemoryEntryContext.IndexEntryContext indexEntryContext) throws IOException {
            Path indexPath = Paths.get(indexEntryContext.getKey(), new String[0]);
            FileWatcher fileWatcher = new FileWatcher(indexPath);
            fileWatcher.addListener((Object)this.indexFileOnDeleteListener);
            fileWatcher.init();
            KNNEngine knnEngine = KNNEngine.getEngineNameFromPath(indexPath.toString());
            long indexAddress = JNIService.loadIndex(indexPath.toString(), indexEntryContext.getParameters(), knnEngine);
            SharedIndexState sharedIndexState = null;
            String modelId = indexEntryContext.getModelId();
            if (IndexUtil.isSharedIndexStateRequired(knnEngine, modelId, indexAddress)) {
                log.info("Index with model: \"{}\" requires shared state. Retrieving shared state.", (Object)modelId);
                sharedIndexState = SharedIndexStateManager.getInstance().get(indexAddress, modelId, knnEngine);
                JNIService.setSharedIndexState(indexAddress, sharedIndexState.getSharedIndexStateAddress(), knnEngine);
            }
            WatcherHandle watcherHandle = this.resourceWatcherService.add((ResourceWatcher)fileWatcher);
            return new NativeMemoryAllocation.IndexAllocation(this.executor, indexAddress, indexEntryContext.calculateSizeInKB(), knnEngine, indexPath.toString(), indexEntryContext.getOpenSearchIndexName(), (WatcherHandle<FileWatcher>)watcherHandle, sharedIndexState, IndexUtil.isBinaryIndex(knnEngine, indexEntryContext.getParameters()));
        }

        @Override
        public void close() {
            this.executor.shutdown();
        }
    }
}

