# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_alpm_srcinfo_global_optspecs
	string join \n h/help V/version
end

function __fish_alpm_srcinfo_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_alpm_srcinfo_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_alpm_srcinfo_using_subcommand
	set -l cmd (__fish_alpm_srcinfo_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_needs_command" -s h -l help -d 'Print help'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_needs_command" -s V -l version -d 'Print version'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_needs_command" -f -a "validate" -d 'Validate a SRCINFO file from a path or `stdin`'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_needs_command" -f -a "format-packages" -d 'Format a SRCINFO file from a path or `stdin`'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_needs_command" -f -a "check" -d 'Read a SRCINFO file from a path or `stdin` and perform linter checks on it'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_using_subcommand validate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_using_subcommand format-packages" -s a -l architecture -d 'The selected architecture that should be used to interpret the SRCINFO file' -r
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_using_subcommand format-packages" -s o -l output-format -d 'Provide the output format' -r -f -a "json\t''"
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_using_subcommand format-packages" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_using_subcommand format-packages" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_using_subcommand check" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_using_subcommand help; and not __fish_seen_subcommand_from validate format-packages check help" -f -a "validate" -d 'Validate a SRCINFO file from a path or `stdin`'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_using_subcommand help; and not __fish_seen_subcommand_from validate format-packages check help" -f -a "format-packages" -d 'Format a SRCINFO file from a path or `stdin`'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_using_subcommand help; and not __fish_seen_subcommand_from validate format-packages check help" -f -a "check" -d 'Read a SRCINFO file from a path or `stdin` and perform linter checks on it'
complete -c alpm-srcinfo -n "__fish_alpm_srcinfo_using_subcommand help; and not __fish_seen_subcommand_from validate format-packages check help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
