
#ifndef QACCESSIBILITYCLIENT_EXPORT_H
#define QACCESSIBILITYCLIENT_EXPORT_H

#ifdef QACCESSIBILITYCLIENT_STATIC_DEFINE
#  define QACCESSIBILITYCLIENT_EXPORT
#  define QACCESSIBILITYCLIENT_NO_EXPORT
#else
#  ifndef QACCESSIBILITYCLIENT_EXPORT
#    ifdef QAccessibilityClient_EXPORTS
        /* We are building this library */
#      define QACCESSIBILITYCLIENT_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define QACCESSIBILITYCLIENT_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef QACCESSIBILITYCLIENT_NO_EXPORT
#    define QACCESSIBILITYCLIENT_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef QACCESSIBILITYCLIENT_DECL_DEPRECATED
#  define QACCESSIBILITYCLIENT_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef QACCESSIBILITYCLIENT_DECL_DEPRECATED_EXPORT
#  define QACCESSIBILITYCLIENT_DECL_DEPRECATED_EXPORT QACCESSIBILITYCLIENT_EXPORT QACCESSIBILITYCLIENT_DECL_DEPRECATED
#endif

#ifndef QACCESSIBILITYCLIENT_DECL_DEPRECATED_NO_EXPORT
#  define QACCESSIBILITYCLIENT_DECL_DEPRECATED_NO_EXPORT QACCESSIBILITYCLIENT_NO_EXPORT QACCESSIBILITYCLIENT_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef QACCESSIBILITYCLIENT_NO_DEPRECATED
#    define QACCESSIBILITYCLIENT_NO_DEPRECATED
#  endif
#endif

#define QACCESSIBILITYCLIENT_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(QACCESSIBILITYCLIENT_NO_DEPRECATED)
#  undef QACCESSIBILITYCLIENT_DEPRECATED
#  define QACCESSIBILITYCLIENT_DEPRECATED_EXPORT QACCESSIBILITYCLIENT_EXPORT
#  define QACCESSIBILITYCLIENT_DEPRECATED_NO_EXPORT QACCESSIBILITYCLIENT_NO_EXPORT
#elif defined(QACCESSIBILITYCLIENT_NO_DEPRECATED_WARNINGS)
#  define QACCESSIBILITYCLIENT_DEPRECATED
#  define QACCESSIBILITYCLIENT_DEPRECATED_EXPORT QACCESSIBILITYCLIENT_EXPORT
#  define QACCESSIBILITYCLIENT_DEPRECATED_NO_EXPORT QACCESSIBILITYCLIENT_NO_EXPORT
#else
#  define QACCESSIBILITYCLIENT_DEPRECATED QACCESSIBILITYCLIENT_DECL_DEPRECATED
#  define QACCESSIBILITYCLIENT_DEPRECATED_EXPORT QACCESSIBILITYCLIENT_DECL_DEPRECATED_EXPORT
#  define QACCESSIBILITYCLIENT_DEPRECATED_NO_EXPORT QACCESSIBILITYCLIENT_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define QACCESSIBILITYCLIENT_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define QACCESSIBILITYCLIENT_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef QACCESSIBILITYCLIENT_NO_DEPRECATED
#  define QACCESSIBILITYCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT 0x600
#endif
#ifdef QACCESSIBILITYCLIENT_NO_DEPRECATED_WARNINGS
#  define QACCESSIBILITYCLIENT_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef QACCESSIBILITYCLIENT_DEPRECATED_WARNINGS_SINCE
#  ifdef QACCESSIBILITYCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define QACCESSIBILITYCLIENT_DEPRECATED_WARNINGS_SINCE QACCESSIBILITYCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define QACCESSIBILITYCLIENT_DEPRECATED_WARNINGS_SINCE 0x600
#  endif
#endif

#ifndef QACCESSIBILITYCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define QACCESSIBILITYCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef QACCESSIBILITYCLIENT_DEPRECATED
#  define QACCESSIBILITYCLIENT_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > QACCESSIBILITYCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define QACCESSIBILITYCLIENT_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* QACCESSIBILITYCLIENT_EXPORT_H */
